Ext.define('services.view.ServicesTreePanel', {
	extend: 'Ext.panel.Panel',
	alias:'widget.servicestreepanel',
	layout : {
							align : 'stretch',
							type : 'vbox'
					},
	flex:1,
	margin:'8 0 0 0',
	bodyCls:'top-left-radius bottom-left-radius',
	autoDestroy:true,
//	requires:['Ext.data.TreeModel'],
//	cls : 'tree-panel',
	url : null,
	id:'servicestreepanel',
	nodeId:null,
	items:[],
	treePanelTitle : treePanelTitle,
	initComponent : function(){
		var me = this;

		Ext.Ajax.request({
			url : me.url,
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				jsonData["expanded"] = true;
				jsonData["cls"] = "list-tree-root-expand-collapse";
				var treePanelStore = Ext.create('Ext.data.TreeStore', {
					id:'treestore',
					root : jsonData
				});

				var treeTitle='<a href="'+jsonData.link+'">'+jsonData.text+'</a>';
				if(!Ext.isEmpty(jsonData.iconCls)){
					treeTitle='<div class="'+jsonData.iconCls+'"><span style="padding-left:20px">'+treeTitle+'</span></div>';
				}

				var treePanel = Ext.create('utilities.TreeScrollPanel',{
					store : treePanelStore,
					cls:'treePanelDesign',
					margin:'0 0 0 8',
					animate:true,
					iconCls:'service20_GRAY',
					layout : {
							align : 'stretch',
							type : 'vbox'
					},
					scroll: true,
					containerScroll: false,
					autoScroll: false,
					overflowY: 'scroll',
					border : true,
					frame:true,
					flex:1,
					maxWidth:350,
					minWidth : 150,
					width:250,
					title: me.treePanelTitle,
					//style:{'border':'0px solid red'},
	//				selModel: Ext.create("Ext.selection.RowModel", { mode : 'SINGLE'}),
					selModel: Ext.create("Ext.selection.TreeModel", { mode : 'MULTI'}),
					//title : treeTitle,
					useArrows: true,
					rootVisible : true,
					stateId:'services-tree-panel-stateId',
					id:'select',
				});

				//me.items.add(treePanel);
				me.add(treePanel);
				me.doLayout();
			},
			failure : function(response, opts){
				alert("Failure");
			}
		});

		this.callParent();
	}
});
