Ext.define('services.view.TransactionGridPanel', {
	extend : 'utilities.CustomGrid',
	requires:['services.store.TransactionsStore'],
	alias : 'widget.transactiongridpanel',
	forceFit:false,
	layout:'fit',
	//	store:'services.store.TransactionsStore',
	jsonData:null,
	cls:'uxGrid',
	border:false,
	frame:false,
	margin:'5 5 0 5',
	height:214,
	bodyCls:'transactionGridWrap',
	itemId : 'transactiongridpanel',
	id:'transactiongridpanel',
	listeners:{
		'render':function(panel){
			var width = Ext.getBody().getViewSize().width - 160;
			var height = (Ext.getBody().getViewSize().height - 150)/2;
			
			panel.setHeight(height);

			Ext.EventManager.onWindowResize(function () {
				panel.setHeight(height);
				panel.doLayout();
			});
		},
		'afterrender':function(panel){

			var faultyServer = this.jsonData.GridScreenLabels["faultyServer"];
			var regexObj = RegExp('NULL','i');
			var flag = regexObj.test(String(faultyServer));
			if(flag)
				faultyServer = faultyServer.substring(0,faultyServer.indexOf(':')) + ')';

			var lastTimeStr = "";
			if(!Ext.isEmpty(this.jsonData.GridScreenLabels["lastMeasurementTime"]))
			{
				/* lastTimeStr = '<div style="font-size:12px;margin:5px 15px 0"><span id="lastMeasurementTime">'+jsonData.GridScreenLabels["lastMeasurementTime_Text"]+': '+Ext.Date.format(new Date(jsonData.GridScreenLabels["lastMeasurementTime"]),
				mgr_dateFormat+" H:i:s")+'</span><span id="faultyServer">'+faultyServer+'</span></div>';*/
				// lastTimeStr = '<div style="margin:5px 15px 0"><span id="lastMeasurementTime" class="font_normal12"> '+this.jsonData.GridScreenLabels["lastMeasurementTime_Text"]+': '+Ext.Date.format(new Date(this.jsonData.GridScreenLabels["lastMeasurementTime"]),
				 lastTimeStr = '<div style="margin:5px 15px 0"><span id="lastMeasurementTime" class="font_normal12"> '+this.jsonData.GridScreenLabels["lastMeasurementTime_Text"]+': '+this.jsonData.GridScreenLabels["lastMeasurementTime"]+'</div>';
			}
			else
			{
				lastTimeStr = '<div style="font-size:12px;margin:5px 15px 0"><span id="faultyServer">'+faultyServer+'</span></div>';
			}

			var lastMTimeIdObj=Ext.getCmp("lastMTimeId");
			if(lastMTimeIdObj!=null && lastMTimeIdObj!=undefined && lastTimeStr!=null && lastTimeStr!=undefined)
			{
				lastMTimeIdObj.update(lastTimeStr);
			}
		}
	},
	tools:[
		{
			xtype:'container',
			id:'lastMTimeId',
			itemid:'lastMTimeId',
			//html:'Last Measure Time: Oct 01, 2015 02:17:15',
			html:'',
		},
		{xtype:'tbseparator',cls:'uxSeparator',height:25,style:{'top':'0px !important'}},
		{
			xtype:'button',
			iconCls: 'iconAdd',
			margin:'3 0 0 3',
			id:'iconAddId',
			itemid:'iconAddId',
			//hidden:hideConfigIcon,
			style:{
				background:'none',border:'0px'
				},
			//cls : 'component-list-right-panel-header-button',
			//text : jsonData.GridScreenLabels["configureTransBtnLabel"],
			action:'transactionsGridConfigureBtn',
			listeners:{
				afterrender:function(){
				console.log("isEmuEnabled",this.up('grid').isEmuEnabled);
					if(this.up('grid').isEmuEnabled!=null && this.up('grid').isEmuEnabled!=undefined)
					{
						this.hidden = this.up('grid').isEmuEnabled;
					}
				}
			}
		},
		{
			xtype:'tbseparator',cls:'uxSeparator',id:'iconAddLineId',
				itemid:'iconAddLineId',height:25,style:{'top':'0px !important'},
				listeners:{
				afterrender:function(){
						if(this.up('grid').isEmuEnabled!=null && this.up('grid').isEmuEnabled!=undefined)
						{
							this.hidden = this.up('grid').isEmuEnabled;
						}
					}
				}
		},
		{
			xtype:'button',
			margin:'5 0 0 0',
			enableToggle: true,
			iconCls:'iconToggleArrowDown',
			style:{background:'none',border:'0px'},
			handler:function(){
				this.up('transactiongridpanel').toggleCollapse();
				var chartPanel = Ext.getCmp("transactionschartpanel");
				var gridPanel = Ext.getCmp("transactiongridpanel");

				if(chartPanel != undefined && chartPanel != 'undefined' && chartPanel != null && gridPanel != undefined && gridPanel != 'undefined' && gridPanel != null )
				{
					//var chartHeight=Ext.getCmp("transactionschartpanel").getHeight()+Ext.getCmp("transactiongridpanel").getHeight();

					var width = Ext.getBody().getViewSize().width - 40;
					var height = Ext.getBody().getViewSize().height;

					if(this.pressed == true){
						//alert("1111");
						this.setIconCls("iconToggleArrowRight");
						if(!Ext.isEmpty(Ext.getCmp('timeWindow')) && Ext.getCmp('timeWindow')!=null && Ext.getCmp('timeWindow')!=undefined)
							Ext.getCmp('timeWindow').close();
						/*Ext.getCmp("transactiontoolpanel").show();
						if (Ext.getCmp("transactionschartpanel").getHeight()==30)
						{
							Ext.getCmp("transactionschartpanel").setHeight(height-36);
							this.up('transactiongridpanel').setHeight(height-236);
						}
						else
						{
							Ext.getCmp("transactionschartpanel").setHeight(height-150);
							this.up('transactiongridpanel').setHeight(height-370);
						}*/
					}else{
						//alert("2222");
						//Ext.getCmp("transactiontoolpanel").hide();
						this.setIconCls("iconToggleArrowDown");
						if(!Ext.isEmpty(Ext.getCmp('timeWindow')) && Ext.getCmp('timeWindow')!=null && Ext.getCmp('timeWindow')!=undefined)
							Ext.getCmp('timeWindow').close();
						//Ext.getCmp("transactionschartpanel").setHeight(height-340);
					}
				}
				

				/*if(this.pressed == true){
					this.setIconCls("iconToggleArrowRight");
					//Ext.getCmp('transactiontoolpanel').update("Transactions");
					
					alert(Ext.getCmp("transactionschartpanel").getHeight()+"---"+Ext.getCmp("transactiongridpanel").getHeight());
					var dockPanel=Ext.getCmp("transactiongridpanel").getDockedItems();
					//alert(Ext.getCmp("transactiongridpanel").getDockedItems());
					Ext.getCmp("gridTool1").show();
					Ext.getCmp("gridTool2").hide();
					Ext.getCmp("transactionschartpanel").setHeight(chartHeight-26);

				}else{
					Ext.getCmp("gridTool1").show();
					Ext.getCmp("gridTool2").hide();
					this.setIconCls("iconToggleArrowDown");
					//Ext.getCmp('transactiontoolpanel').update("");
					
				}*/


			}
		}
	],
	collapsed:false,
	collapsible: true,
	hideCollapseTool:true,
    viewConfig: {
        getRowClass: function(record, index, rowParams, store) {
			if(!Ext.isEmpty(record.get('Message'))){
				return "msg-row";
			}
				return '';
        },
		emptyText:'<center><div style="text-align:center;margin-top:40px"><div class="iconInformation" style="margin:0px auto"></div><div>No data found</div></div></center>',
		deferEmptyText: false 
    },
    
	initComponent : function() {
		this.store=Ext.create('services.store.TransactionsStore');
    	var jsonData=this.jsonData;
		var storeFields=['Message','transImage','transactionStateClass','transactionStateTitle'];
		var columns=new Array();
		if(jsonData != null && jsonData != undefined && !Ext.isEmpty(jsonData.GridScreenLabels.TransactionHeaders))
		{
			for(var j=0;j<jsonData.GridScreenLabels.TransactionHeaders.length;j++){
				var recMeasureCol=jsonData.GridScreenLabels.TransactionHeaders[j];
				var measureCol=new Object();
				if(j==0){
					measureCol.text='<span style="text-transform:uppercase;font-size:11px">'+recMeasureCol.Header+'</span>';
				}else{
					measureCol.text='<span style="text-transform:uppercase;font-size:11px;line-height:8px">'+recMeasureCol.Header+'</span>&nbsp;<span style="font-size:11px;line-height:8px">('+recMeasureCol.UnitForHeader+')</span';
				}
				if(j==0){
					measureCol.sortType='asString';
					measureCol.dataIndex='transactionName';			// Small Image Display
					measureCol.sortable=false;
					measureCol.width=250;
					measureCol.renderer=function(value,metaData,record,rowIndex,colIndex){
						var htmlStr= '<a href="javascript:DashboardToTopology();" style="position:relative;display:block"><img style="vertical-align:middle;padding-right:19px;"  class=" '+record.get("transactionStateClass")+'" src="/final/images/clear.png" title="'+record.get("transactionStateTitle")+'"/> <span>'+value+'</span><img style="vertical-align:middle;position:absolute;right:0px;top:3px"   class="trans_'+record.raw.transImageTitle+'_small" src="/final/images/clear.png" /></a>';
						//if(!Ext.isEmpty(record.get('transImage'))){
						//	htmlStr+='<img src="'+record.get('transImage')+'"/>';
						//}
					
						return htmlStr;
						
					};
				}else if(j==2 || j==3){
					measureCol.dataIndex=(j-1)+'MeasureValue';
					measureCol.sortType=(j-1)+'asFloat';
					if(jsonData.GridScreenLabels.TransactionHeaders.length == 3 )
						measureCol.flex=.6;
					else
						measureCol.width=200;
					storeFields.push((j-1)+'MeasureValueImg');
					storeFields.push((j-1)+'MeasureValueImgTitle');
					
					measureCol.renderer=function(value,metaData,record,rowIndex,colIndex){
						var imgStr;

						if(!Ext.isEmpty(record.get((colIndex-1)+'MeasureValueImg'))){
							
							imgStr = '<a href="javascript:DashboardToTopology()"; return false;><img style="vertical-align:middle;padding-right:22px;" class="'+record.get((colIndex-1)+'MeasureValueImg')+'"  src="/final/images/clear.png"/>'+value +'</a>';
							return imgStr;
						}
						else
						{
							imgStr = '<div style="text-align:left">&nbsp; - </div>';
							return imgStr;
						}
					}
				}else{
					measureCol.sortType=(j-1)+'asFloat';
					measureCol.dataIndex=(j-1)+'MeasureValue';
					measureCol.flex=.6;
					storeFields.push((j-1)+'MeasureValueImg');
					storeFields.push((j-1)+'MeasureValueImgTitle');
					
					measureCol.renderer=function(value,metaData,record,rowIndex,colIndex){
						var imgStr;

						if(!Ext.isEmpty(record.get((colIndex-1)+'MeasureValueImg'))){
							
							imgStr = '<a href="javascript:void(0)"; return false;><img style="vertical-align:middle;padding-right:22px;" class="'+record.get((colIndex-1)+'MeasureValueImg')+'"  src="/final/images/clear.png"/>'+value +'</a>';
							return imgStr;
						}
						else
						{
							imgStr = '<div style="text-align:left">&nbsp; - </div>';
							return imgStr;
						}
					}
				}
				if(j==1){
					measureCol.renderer=function(value,metaData,record,rowIndex,colIndex){
						var msg=record.get('Message');
						if(!Ext.isEmpty(msg)){
							//metaData.style="display:inline;text-align:center;position:relative;left:200%;white-space: nowrap !important;";
							msg = '<div style="text-align:left">&nbsp; - </div>';
							//return msg;
							return '-';
						}else{
							if(!Ext.isEmpty(record.get((colIndex-1)+'MeasureValueImg'))){
								imgStr = '<a href="javascript:void(0)"; return false;><img style="vertical-align:middle;padding-right:22px;" class="'+record.get((colIndex-1)+'MeasureValueImg')+'"  src="/final/images/clear.png"/>'+value +'</a>';
								return imgStr;
							}
							else
							{
								imgStr = '<div style="text-align:left">&nbsp; - </div>';
								return imgStr;
							}
						}
					};
				}
				storeFields.push(measureCol.dataIndex);
				columns.push(measureCol);
			}
		}
		var gridStore=Ext.create('Ext.data.Store',{
			fields:storeFields,
		    proxy: {
		        type: 'memory',
		        reader: {
		            type: 'json',
		            root:'TransactionsIfo'
		        }
		    },
		    data:jsonData
		});
		
		var toolbarArray=new Array();

		
		if(!Ext.isEmpty(jsonData.GridScreenLabels["lastMeasurementTime_Text"])){
			toolbarArray.push({
				xtype:'label',
				text:jsonData.GridScreenLabels["lastMeasurementTime_Text"]+" : "
			});
		}
		
		if(!Ext.isEmpty(jsonData.GridScreenLabels["lastMeasurementTime"])){
			toolbarArray.push({
				xtype:'label',
				//text:Ext.Date.format(new Date(jsonData.GridScreenLabels["lastMeasurementTime"]),mgr_dateFormat+" H:i:s")
				text:jsonData.GridScreenLabels["lastMeasurementTime"]
			});
		}

		/*--- Kaliraj ---*/

		var faultyServer = jsonData.GridScreenLabels["faultyServer"];
		var regexObj = RegExp('NULL','i');
		var flag = regexObj.test(String(faultyServer));
		if(flag)
			faultyServer = faultyServer.substring(0,faultyServer.indexOf(':')) + ')';

		/*--------*/

		if(!Ext.isEmpty(jsonData.GridScreenLabels["faultyServer"])){
			toolbarArray.push({
				xtype:'label',
				text:faultyServer         // Kaliraj
			});
		}
		
		if(!Ext.isEmpty(jsonData.GridScreenLabels["configureTransBtnLabel"])){
			toolbarArray.push("->");
			toolbarArray.push({
				xtype:'button',
				cls: 'button20',
				//cls : 'component-list-right-panel-header-button',
				text : jsonData.GridScreenLabels["configureTransBtnLabel"],
				action:'transactionsGridConfigureBtn'
			});
		}
		
		/*this.dockedItems= [{
			xtype: 'toolbar',
			dock: 'top',
			style:{'background-color':'#b4b4b4'},
			items: toolbarArray
		}];*/
		//this.tbar=toolbarArray;
		this.store=gridStore;
		this.columns=columns;
		this.callParent();
	}
});