var leftSpace;
var height = screen.height;

Ext.define('services.view.TransactionsMainPanel', {
	extend : 'Ext.panel.Panel',
	requires : ['utilities.ScrollCombo','services.view.TransactionGridPanel','Ext.data.Store','services.view.TransactionsChartPanel','services.view.TransactionsMainTabPanel','services.view.TransactionsMainTabPanelAll','services.view.ServicesTreePanel',
	'sessionSimulation.view.SessionSimulation'],
	alias : 'widget.transactionsmainpanel',
	border : false,
	enableSelectAll:false,
	header:{
		padding:'5 5 5 5',
		margin:0
	},
	layout : {
		type : 'vbox',
		align:'stretch'
	},
	init: function() {
		this.control({
			'transactionsMainTabPanelAll':{
				tabchange:this.changeTabAll
			},
		});
	},
	initComponent : function(){
		this.callParent();
	},
	updateLabels:function(screenLabels,ComponentList){
		var rumSize = Object.keys(rumServiceListObject).length;
		var runDis = false;
		if(rumServiceListObject != null && rumServiceListObject != 'undefined' && rumServiceListObject != undefined && rumSize > 0){
			runDis = true;
		}
		/*var topToolbar={
			xtype: 'toolbar',
			dock: 'top',
			style:{'border':'0px solid red !important'},
			border:false,
			frame:false
			//cls : 'component-list-right-panel-header'
		};
		var toolbarItemsArray = new Array();
		toolbarItemsArray.push({
			xtype: 'label',
			html : '<div style="float:left;"><div  class="service20_'+screenLabels["siteState"]+'" style="float:left;margin-top:5px;margin-left:5px;"></div><div style="float:left;margin-top:5px;margin-left:5px;">'+screenLabels["Title"]+'</div></div>',
			cls:'toolbar-title',
			itemId : 'serviceToolbarLabel'
		});
		
		toolbarItemsArray.push('->');
		
		if(!Ext.isEmpty(screenLabels["webBtnLabel"])){
			toolbarItemsArray.push({
				xtype : 'button',
				text : screenLabels["webBtnLabel"],
				cls: 'button20',
				//cls : 'component-list-right-panel-header-button',
				itemId : 'serviceToolbarWebButton',
				dataUrl:screenLabels["webBtnURL"]
			});
		}
		if(!Ext.isEmpty(screenLabels["emulBtnLabel"])){
			toolbarItemsArray.push({
				xtype : 'button',
				margin:'0 0 0 5',
				cls: 'button20',
				//cls : 'component-list-right-panel-header-button',
				text : screenLabels["emulBtnLabel"],
				itemId : 'serviceToolbarEmulatedButton',
				dataUrl:screenLabels["emulBtnURL"]
			});
		}
		toolbarItemsArray.push('->');
		if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined){
				var comboStore = Ext.create('Ext.data.Store',{
					fields:['value','name'],
					proxy:{
						type: 'memory',
						reader: {
							type: 'json',
							root:'options'
						}
					},
					data:ComponentList
				});
				
				compCombo={
						xtype:'combo',
						editable : false,
						store:comboStore,
						cls : 'dropdown',
						displayField:'name',
						valueField:'value',
						trigerAction:'all',
						fieldLabel:ComponentList.label,
						labelWidth:80,
						value:ComponentList.selectedValue
				};
			toolbarItemsArray.push(compCombo);
		}
		topToolbar.items=toolbarItemsArray;
		//this.addDocked(topToolbar); Hide the toolbar here
		
		if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined)
		{
			var upperPanel = Ext.create('Ext.container.Container',{ //Feroz
				cls:'searchTopPanel',
				margin:'6 0 0 0',
				border:false,
				padding:'0 10 0 10',
				layout:{type:'hbox',align:'stretch'},
				items:[{
					xtype: 'label',
					flex:1,
					html : '<div style="float:left;"><div class="service20_'+screenLabels["siteState"]+'" style="float:left;margin-top:3px;margin-left:0px;"></div><div style="float:left;margin-top:3px;margin-left:4px;font-size:13px">'+screenLabels["Title"]+'</div></div>',
					cls:'toolbar-title',
					itemId : 'serviceToolbarLabel'
				},{
					xtype:'combo',
					itemId:'componentCombo',
					editable : true,
					store:comboStore,
					cls : 'dropdown',
					displayField:'name',
					valueField:'value',
					trigerAction:'all',
					fieldLabel:ComponentList.label,
					labelWidth:80,
					value:ComponentList.selectedValue
				}]
			});*/
			//this.insert(0,upperPanel);
		//}

	
		
	},
	showGrid:function(jsonData){
		var systemGrid=Ext.create('services.view.TransactionGridPanel',{
			jsonData:jsonData,
			border:false,
			frame:false,
			layout:{type:'fit'},
			margin:'0 0 0 0',
			flex:1
		});
		return systemGrid;
	},
	showGraph:function(jsonData){
		var systemGraph=Ext.create('services.view.TransactionChartPanel',{
			jsonData:jsonData,
			border:false,
			frame:false,
			layout:{type:'fit'},
			//margin:'20 6 0 6',
			flex:1
		});
		return systemGraph;
	},
	showTransactionGridPanelData:function(screenLabels ,jsonData){
		var tabPanelAll = Ext.getCmp('tabAll');
		var webTrans = Ext.getCmp('webtrans');
		if(webTrans!=null && webTrans!=undefined)
		{
			webTrans.removeAll();
		}
		var selectedTabProp = new Object();
		
		
		var hideConfigIcon = true;
		selectedTabProp['title'] = screenLabels["emulBtnLabel"];
		selectedTabProp['itemId'] = 'serviceToolbarEmulatedButton';
		selectedTabProp['dataUrl'] = screenLabels["emulBtnURL"];
		var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
		
		var compCombo22 = Ext.getCmp('componentCombo');
		var ComponentList = jsonData.ComponentList;
		var siteName = jsonData.HiddenFields.siteName;
		if(siteName!=null && siteName!=undefined)
			services.app.getController("ServicesTransactions").siteName=siteName;
		var label='',selectedVal='';
		var defalutHide = true;
		var comboStore;
		if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined)
		{
			defalutHide = false;
		}
		if(!Ext.isEmpty(compCombo22)){
			if(defalutHide == false || defalutHide == 'false'){
				try{
					compCombo22.suspendEvents(true);
					compCombo22.getStore().removeAll();
					compCombo22.getStore().loadRawData('');
					compCombo22.getStore().loadRawData(ComponentList);
					compCombo22.setValue(ComponentList.selectedValue);
					compCombo22.setFieldLabel(ComponentList.label);
					compCombo22.resumeEvents();
				}catch(e){
					alert(e)
				}
			}else{
				compCombo22.setVisible(false);
			}
		}

		if (strSkin=="Dark")
				{
					skinBg="#444444";
				}
				else if (strSkin=="Light")
				{
					skinBg="#ffffff";
				}
		var innertabPanel = Ext.create('Ext.panel.Panel',{
			//margin:'0 0 20 0',
			frame:false,
			layout:'column',
			border:false,
			style:{'padding-bottom':'4px'},
			layout:{type:'vbox',align:'stretch'},
			bodyStyle:{background:skinBg+'!important'},
			//flex:1,
			height:480,
			listeners:{
				'resize':function(panel){
					var width = Ext.getBody().getViewSize().width;
					var height = Ext.getBody().getViewSize().height-110;
					panel.setHeight(height);
				}
			},
			//this.showGrid(jsonData),
			items: [{
						xtype:'transactiongridpanel',
						//title:'<span class="font_bold12">Transactions-&&&</span>',
						columnWidth:1.0,
						jsonData:jsonData,
						isEmuEnabled:isEmuEnabled,
						margin:'0 0 0 0',
						padding:0,
						flex:0.43,
						border:false
						
					},
					{
						xtype:'transactionschartpanel',
						//title:'Graphs',
						columnWidth:1.0,
						jsonData:jsonData,
						margin:'5 6 0 6',
						padding:0,
						flex:0.57,
						border:false,
						//layout:{type:'vbox'},
						//style:{'overflow':'auto'}
							
					}]
		});
		webTrans.add(innertabPanel);
	},
	showEmulTransactionGridPanelData:function(screenLabels ,jsonData){
		var tabPanelAll = Ext.getCmp('tabAll');
		var webTrans = Ext.getCmp('emultrans');
		if(webTrans!=null && webTrans!=undefined)
		{
			webTrans.removeAll();
		}
		var selectedTabProp = new Object();
		
		
		var hideConfigIcon = true;
		selectedTabProp['title'] = screenLabels["emulBtnLabel"];
		selectedTabProp['itemId'] = 'serviceToolbarEmulatedButton';
		selectedTabProp['dataUrl'] = screenLabels["emulBtnURL"];
		var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
		
		var compCombo22 = Ext.getCmp('componentCombo');
		var ComponentList = jsonData.ComponentList;
		var siteName = jsonData.HiddenFields.siteName;
		if(siteName!=null && siteName!=undefined)
			services.app.getController("ServicesTransactions").siteName=siteName;
		var label='',selectedVal='';
		var defalutHide = true;
		var comboStore;
		if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined)
		{
			defalutHide = false;
		}
		if(!Ext.isEmpty(compCombo22)){
			if(defalutHide == false || defalutHide == 'false'){
				try{
					compCombo22.suspendEvents(true);
					compCombo22.getStore().removeAll();
					compCombo22.getStore().loadRawData('');
					compCombo22.getStore().loadRawData(ComponentList);
					compCombo22.setValue(ComponentList.selectedValue);
					compCombo22.setFieldLabel(ComponentList.label);
					compCombo22.resumeEvents();
				}catch(e){
					alert(e)
				}
			}else{
				compCombo22.setVisible(false);
			}
		}

		if (strSkin=="Dark")
		{
			skinBg="#444444";
		}
		else if (strSkin=="Light")
		{
			skinBg="#ffffff";
		}

		var isWebTrans = jsonData.HiddenFields.isWebTrans;
						
		var siteBasedWeb = "NULL";
		if(isWebTrans=='true')
		 siteBasedWeb = siteName;
		var compType = jsonData.HiddenFields.compType;
		var compName = jsonData.HiddenFields.compName;
		var siteName = jsonData.HiddenFields.siteName;
		var innertabPanel = Ext.create('Ext.panel.Panel',{
			//margin:'0 0 20 0',
			frame:false,
			layout:'column',
			border:false,
			style:{'padding-bottom':'4px'},
			layout:{type:'vbox',align:'stretch'},
			bodyStyle:{background:skinBg+'!important'},
			//flex:1,
			height:480,
			listeners:{
				'resize':function(panel){
					var width = Ext.getBody().getViewSize().width;
					var height = Ext.getBody().getViewSize().height-110;
					panel.setHeight(height);
				}
			},
			//this.showGrid(jsonData),
			/*items: [{
						xtype:'transactiongridpanel',
						//title:'<span class="font_bold12">Transactions-&&&</span>',
						columnWidth:1.0,
						jsonData:jsonData,
						isEmuEnabled:isEmuEnabled,
						margin:'0 0 0 0',
						padding:0,
						flex:0.43,
						border:false
						
					},
					{
						xtype:'transactionschartpanel',
						//title:'Graphs',
						columnWidth:1.0,
						jsonData:jsonData,
						margin:'5 6 0 6',
						padding:0,
						flex:0.57,
						border:false,
						//layout:{type:'vbox'},
						//style:{'overflow':'auto'}
							
					}]*/
			items:[{
					xtype : 'container',
					margin : 0,
					id : 'sessionSimTopology',
					bodyPadding :0,
					padding:0,
					border : false,
					frame : false,
					layout:'fit',
					listeners:{
						"resize":function(panel){
								panel.setHeight(Ext.getBody().getViewSize().height-70)
						}
					},
					autoEl : {
						tag : 'iframe',
						name : 'perMainIframe',
						id:'sessionSimTopologyIframe',
						frameborder : '0',
						style:{'top':'0px','left':'0px'},
						scrolling:"yes",
						marginLeft:0,
						//height : Ext.getBody().getViewSize().height-70,
						marginTop:0,
						src:"/final/monitor/sessionSimulation.jsp?compName="+compName+"&site="+siteBasedWeb+"&compType="+compType+"&serviceName="+siteName+"&isServiceMenu=true"
						
					}
				}]
		});
		webTrans.add(innertabPanel);
	},
	showTransactionGridPanel:function(screenLabels ,jsonData){
		var runDis = false;
		if(rumServiceList != null && rumServiceList.indexOf(curServiceName) > -1 ){
			runDis = true;
		}
		
		/*if(rumServiceListObject != null && rumServiceListObject != 'undefined' && rumServiceListObject != undefined ){
			var rumSize = Object.keys(rumServiceListObject).length;
			if(rumSize > 0)
				runDis = true;
		}*/
		var compType = jsonData.HiddenFields.compType;
		var compName = jsonData.HiddenFields.compName;
		var siteName = jsonData.HiddenFields.siteName;
		var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
		var isTransEnabled = ( !Ext.isEmpty(screenLabels["webBtnLabel"]) )?true:false;
		var isTabChanged = ( !Ext.isEmpty(jsonData['isTabChanged']) )?true:false;
		var isFromRefresh = ( !Ext.isEmpty(jsonData['fromRefresh']) )?true:false;
		var isLogonEnabled = jsonData.HiddenFields.isLogonSimul;
		var refreshing = jsonData.HiddenFields.Refreshing;
		var innerActiveTab = jsonData.HiddenFields.innerActiveTab;
		var graphParam = jsonData.HiddenFields.timelineParam;
		var isWebTrans = jsonData.HiddenFields.isWebTrans;

							
		var siteBasedWeb = "NULL";
		if(isWebTrans=='true')
		 siteBasedWeb = siteName;
		var timelineUrl = '';
		if(!Ext.isEmpty(graphParam) && graphParam != null && graphParam != undefined)
		{
			timelineUrl = '&mode='+graphParam.mode+'&time_line='+graphParam.time_line+'&starthr='+graphParam.starthr+'&endhr='+graphParam.endhr+'&starttime='+graphParam.starttime+'&endtime='+graphParam.endtime+'&startmin='+graphParam.startmin+'&endmin='+graphParam.endmin;
		}

		var serviceRefSortByLogon = "";
		var serviceRefSortByLogonType = "";
		var serviceRefSortByLogonId = "";

		if(!Ext.isEmpty(jsonData.HiddenFields))
		{
			serviceRefSortByLogon = jsonData.HiddenFields.serviceRefSortByLogon;
			serviceRefSortByLogonType = jsonData.HiddenFields.serviceRefSortByLogonType;
			serviceRefSortByLogonId = jsonData.HiddenFields.serviceRefSortByLogonId;
		}

		var ComponentList = jsonData.ComponentList;
		var externalAgentsList = jsonData.externalAgents;
		var logonComponentList = jsonData.logonComponentList;
		var componentListObj = jsonData.componentListObj;
		var logonParam = jsonData.logonParam;
		gLogonParam = jsonData.logonParam;
		var logonTitle = jsonData.logonTitle;
		var label='',selectedVal='',simLabel='',simulationSelectedVal='',simulationSelectedOrgValue = '';
		var compLabel='',compSelectedVal='',compSelectedOrgValue = '';
		var defalutHide = false;
		var isComponentType = true;
		var comboStore,simulationComboStore,compStroe;

		//if(!Ext.isEmpty(componentListObj) && componentListObj!=null && componentListObj!=undefined)
		if(!Ext.isEmpty(componentListObj) && componentListObj!=null && componentListObj!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled)))
		{
			isComponentType = false;
			compStroe = Ext.create('Ext.data.Store',{
				fields:['value', 'name', 'url'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'options'
					}
				},
				data:componentListObj
			});
			compLabel = componentListObj.label;
			compSelectedVal = componentListObj.selectedValue;
			selectedCompType =componentListObj.selectedValue;

			//compSelectedOrgValue = logonComponentList.selectedOrgValue;
		}
		if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
			comboStore = Ext.create('Ext.data.Store',{
				fields:['value', 'name', 'comptype'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'options'
					}
				},
				data:ComponentList
			});
			defalutHide = false;
			label = ComponentList.label;
			selectedVal = ComponentList.selectedValue;
		}
		else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
			extAgentData = externalAgentsList;
			//externalAgentsList = externalAgentsList[simulationSelectedVal];
			comboStore = Ext.create('Ext.data.Store',{
				fields:['value', 'name'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'options'
					}
				},
				data:externalAgentsList
			});
			defalutHide = false;
			label = extAgentData.label;
			selectedVal = externalAgentsList.selectedValue;
			selectedExtAgent = externalAgentsList.selectedValue;
		}
		else
			defalutHide = true;
		
		if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled)))
		{
			extSimData = logonComponentList;
			logonComponentList = logonComponentList[selectedExtAgent];
			simulationComboStore = Ext.create('Ext.data.Store',{
				fields:['value', 'name', 'comptype'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'options'
					}
				},
				data:logonComponentList
			});
			simLabel = logonComponentList.label;

			simulationSelectedVal = logonComponentList.selectedValue;
			if(!Ext.isEmpty(refreshSimulation) && refreshSimulation != null)
			{
				if(refreshSimulation.indexOf(":")>-1)
				{
					var componentVal = refreshSimulation;
					componentVal = componentVal.substring(0,componentVal.indexOf(":"));
					selectedSimulation = componentVal;
				}
				simulationSelectedOrgValue = refreshSimulation;
			}
			else
			{
				selectedSimulation = logonComponentList.selectedValue;
				simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
			}
		}

		var tabPanel = '';
		var emulTabPanel = '';
		var  hideConfigIcon = false;
		if( isTransEnabled && isEmuEnabled && false)
		{
			 tabIndex = (Ext.isEmpty(jsonData['tabInx']))?0:jsonData['tabInx'];
			 tabPanel = Ext.create('services.view.TransactionsMainTabPanel',{
				margin:'9 10 0 10',
				flex:0.7,
				frame:false,
				id:'transTabAll',
				border:true,
				layout:{type:'vbox',align:'stretch'},
				activeTab: jsonData['tabInx'],
				items: [
					{
						title: screenLabels["webBtnLabel"],
						itemId : 'serviceToolbarWebButton',
						dataUrl:screenLabels["webBtnURL"],
						layout:{type:'vbox',align:'stretch'},
						flex:1,
						hidden:false,
						items:[this.showGrid(jsonData)]
					},
					{
						title: screenLabels["emulBtnLabel"],
						itemId : 'serviceToolbarEmulatedButton',
						layout:{type:'vbox',align:'stretch'},
						dataUrl:screenLabels["emulBtnURL"],
						flex:1,
						hidden:false,
						items:[this.showGrid(jsonData)]
					}
				]
			});
				
				if(!isTabChanged )
				{
					if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){
						hideConfigIcon = true;
						tabPanel.setActiveTab(1)
					}else{
							tabPanel.setActiveTab(0)
						}
				}
				else
					hideConfigIcon = ( tabIndex == 0 )?false:true;
		}
		else
		{
			var selectedTabProp = new Object();
			if(isTransEnabled && isEmuEnabled)
			{
				selectedTabProp['title'] = screenLabels["webBtnLabel"];
				selectedTabProp['itemId'] = 'serviceToolbarWebButton';
				selectedTabProp['dataUrl'] = screenLabels["webBtnURL"];

				hideConfigIcon = true;
				selectedTabProp['emultitle'] = screenLabels["emulBtnLabel"];
				selectedTabProp['emulitemId'] = 'serviceToolbarEmulatedButton';
				selectedTabProp['emuldataUrl'] = screenLabels["emulBtnURL"];
			}
			else if(isTransEnabled)
			{
				selectedTabProp['title'] = screenLabels["webBtnLabel"];
				selectedTabProp['itemId'] = 'serviceToolbarWebButton';
				selectedTabProp['dataUrl'] = screenLabels["webBtnURL"];
			}
			else if(isEmuEnabled)
			{
				hideConfigIcon = true;
				selectedTabProp['title'] = screenLabels["emulBtnLabel"];
				selectedTabProp['itemId'] = 'serviceToolbarEmulatedButton';
				selectedTabProp['dataUrl'] = screenLabels["emulBtnURL"];
			}
			/*var chartPanel=Ext.create('services.view.TransactionsChartPanel',{
				//xtype:'transactionschartpanel',
				jsonData:jsonData,
				margin:'5 6 0 6',
				padding:0,
				height:248,
				border:false,
				layout:{type:'fit'},
				autoScroll:true,
				scroll:true,
				//style:{'overflow':'auto !important','border':'1px solid red'}
				
			});*/
			innerText='<div style="margin-left:-211px;margin-top:7px"><div id="stateIcon" style="float:left;margin-right:3px" class="state_'+serviceState+'"></div><div class="uxtab-separator" style="float:left;font-size:12px;font-weight:bold;padding-right:7px;margin-right:5px">'+screenLabels["Title"]+'</div><div style="float:left;margin-right:5px;width:25px" onclick=\'DashboardToLayers("'+compName+'","'+compType+'","'+siteName+'");\' class="iconLayerstack uxtab-separator mouse" data-class="yellowTip"  data-qtip="Layer Model" ></div><div style="float:left;margin-right:5px;width:25px" onclick=\'DashboardToTopology();\' class="iconShare uxtab-separator mouse" data-class="yellowTip"  data-qtip="Topology"></div></div>';
			
			if(isEmuEnabled)
			{
				tabPanel = Ext.create('services.view.TransactionsMainTabPanel',{
					margin:'0 0 20 0',
					//flex:0.57,
					flex:1,
					frame:false,
					border:false,
					layout:{type:'fit'},
					//style:{'border':'2px solid blue'},
					//layout:{type:'vbox',align:'stretch'},
					tabBar: {
						id:'tabBarIn',
					},
					//activeTab: 0,
					items: [{
							xtype:'container',
							title: selectedTabProp['title'],
							itemId : selectedTabProp['itemId'],
							dataUrl:selectedTabProp['dataUrl'],
							layout:{type:'vbox',align:'stretch'},
							style:{'padding-bottom':'0px'},
							autoScroll:true,
							border:true,
							scroll:true,
							height:490,
							listeners:{
								'resize':function(panel){
									var width = Ext.getBody().getViewSize().width;
									var height = Ext.getBody().getViewSize().height-110;
									panel.setHeight(height);
								}
							},
							items:[{
									xtype : 'container',
									margin : 0,
									id : 'sessionSimTopology',
									bodyPadding :0,
									padding:0,
									border : false,
									frame : false,
									layout:'fit',
									listeners:{
										"resize":function(panel){
												panel.setHeight(Ext.getBody().getViewSize().height-70)
										}
									},
									autoEl : {
										tag : 'iframe',
										name : 'perMainIframe',
										id:'sessionSimTopologyIframe',
										frameborder : '0',
										style:{'top':'0px','left':'0px'},
										scrolling:"yes",
										marginLeft:0,
										//height : Ext.getBody().getViewSize().height-70,
										marginTop:0,
										src:"/final/monitor/sessionSimulation.jsp?compName="+compName+"&site="+siteBasedWeb+"&compType="+compType+"&serviceName="+siteName+"&isServiceMenu=true"
										
									}
							}]
						}]
					});
			}
			else
			{
				tabPanel = Ext.create('services.view.TransactionsMainTabPanel',{
					margin:'0 0 20 0',
					//flex:0.57,
					flex:1,
					frame:false,
					border:false,
					layout:{type:'fit'},
					//style:{'border':'2px solid blue'},
					//layout:{type:'vbox',align:'stretch'},
					tabBar: {
						id:'tabBarIn',
					},
					//activeTab: 0,
					items: [{
							xtype:'container',
							title: selectedTabProp['title'],
							itemId : selectedTabProp['itemId'],
							dataUrl:selectedTabProp['dataUrl'],
							//dataUrl:"/final/monitor/realUserMonitorsDashboard.jsp?drilldown=true&compName=RUM_11.70:NULL",
							layout:{type:'vbox',align:'stretch'},
							style:{'padding-bottom':'0px'},
							autoScroll:true,
							border:true,
							scroll:true,
							height:490,
							listeners:{
								'resize':function(panel){
									var width = Ext.getBody().getViewSize().width;
									var height = Ext.getBody().getViewSize().height-110;
									panel.setHeight(height);
								}
							},
						
							items:[{
								xtype:'transactiongridpanel',
								//title:'<span class="font_bold12">Transactions</span>',
								columnWidth:1.0,
								jsonData:jsonData,
								//hidden:isEmuEnabled,
								margin:'5 6 0 6',
								padding:0,
								id:'transGrid',
								flex:0.43,
								border:false
							},
							{
								xtype:'transactionschartpanel',
								//title:'Graphs',
								columnWidth:1.0,
								jsonData:jsonData,
								margin:'5 6 0 6',
								//hidden:isEmuEnabled,
								padding:0,
								flex:0.57,
								border:false,
								//layout:{type:'vbox'},
								//style:{'overflow':'auto'}
									
							}]
						}]
				});
			}

			if(isTransEnabled && isEmuEnabled)
			{
				if(!isTabChanged )
				{
					if(jsonData.HiddenFields.selectedTab=="EmulatedClients")
					{
						tabPanel=null;
						tabPanel = Ext.create('services.view.TransactionsMainTabPanel',{
							margin:'0 0 20 0',
							//flex:0.57,
							flex:1,
							frame:false,
							border:false,
							layout:{type:'fit'},
							//style:{'border':'2px solid blue'},
							//layout:{type:'vbox',align:'stretch'},
							tabBar: {
								id:'tabBarIn',
							},
							//activeTab: 0,
							items: [{
									xtype:'container',
									title: selectedTabProp['emultitle'],
									itemId : selectedTabProp['emulitemId'],
									dataUrl:selectedTabProp['emuldataUrl'],
									//dataUrl:"/final/monitor/realUserMonitorsDashboard.jsp?drilldown=true&compName=RUM_11.70:NULL",
									layout:{type:'vbox',align:'stretch'},
									style:{'padding-bottom':'0px'},
									autoScroll:true,
									border:true,
									scroll:true,
									height:490,
									listeners:{
										'resize':function(panel){
											var width = Ext.getBody().getViewSize().width;
											var height = Ext.getBody().getViewSize().height-110;
											panel.setHeight(height);
										}
									},
									items:[{
										xtype:'transactiongridpanel',
										//title:'<span class="font_bold12">Transactions</span>',
										columnWidth:1.0,
										jsonData:jsonData,
										isEmuEnabled:isEmuEnabled,
										margin:'5 6 0 6',
										padding:0,
										id:'transGrid',
										flex:0.43,
										border:false
									},
									{
										xtype:'transactionschartpanel',
										//title:'Graphs',
										columnWidth:1.0,
										jsonData:jsonData,
										margin:'5 6 0 6',
										padding:0,
										flex:0.57,
										border:false,
										//layout:{type:'vbox'},
										//style:{'overflow':'auto'}
											
									}]
									//hidden:isTransEnabled,
								}]
						});
					}
				}
			}

			/*if(isLogonEnabled == 'true' && ((!isEmuEnabled && !isTransEnabled) || (refreshing != null && refreshing == 'true' && innerActiveTab != null && innerActiveTab == 'logonSim'))){
				tabPanel.setActiveTab(3);
			}
			else{
				tabPanel.setActiveTab(0);
			}*/
			var inTabObj = Ext.getCmp('tabBarIn');
			inTabObj.setVisible(false);
			
			var logonSimWin = this.add({
				xtype:'panel',
				border:false,
				//flex:1,
				height:245,
				layout:{type:'fit',align:'stretch'},
				padding:'0 0 0 0',
				scroll:false,
				autoScroll:false,
				autoDestroy:true,
				id:'logonSimPanel',
				constrain : true,
				//style:{'border':'0px solid red','top':'-3px !important','left':'-6px !important','background':'transparent !important'},
				items : [{
					xtype : "component",
					id:'logonSimCompId',
					timelineParamJson:null,
					service_RefSortByLogon:null,
					service_RefSortByLogonType:null,
					service_RefSortByLogonId:null,
					autoEl : {
						tag : "iframe",
						itemId:'logonSimIframeId',
						constrain : true,
						frameBorder:0,
						src:'/final/monitor/comparisonDashboard.jsp?'+logonParam+'&isFromMenu=true&showGraph=true&isLogonFromService=true&servicename='+siteName+'&externalAgent='+selectedVal+'&componentNameService='+simulationSelectedOrgValue+'&componentNameSearch='+selectedSimulation+'&subFilter=&componentNameSearch=&refresh='+refreshing+timelineUrl+'&serviceRefSortByLogon='+serviceRefSortByLogon+'&serviceRefSortByLogonType='+serviceRefSortByLogonType+'&serviceRefSortByLogonId='+serviceRefSortByLogonId
					}
				}]
			});

		//	var label='',selectedVal='';
		//var defalutHide = true;
			var serviceState = "GOOD";
			serviceState=jsonData.GridScreenLabels.siteState;
			var activePanel="";
			if((isLogonEnabled == 'true' || isLogonEnabled==true) && ((!isEmuEnabled && !isTransEnabled) || (refreshing != null && refreshing == 'true' && innerActiveTab != null && innerActiveTab == 'logonSim'))){
				activePanel = 4;
				innerActiveTab = 'logonSim';
			}
			else{
				activePanel = 0;
				innerActiveTab = 'webtrans';

				if(isTransEnabled && isEmuEnabled)
				{
					if(!isTabChanged )
					{
						if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){
							activePanel = 1;
							innerActiveTab = 'emultrans';
						}else{
								activePanel = 0;
								innerActiveTab = 'webtrans';
							}
					}
					else
					{
						activePanel = 0;
						innerActiveTab = 'webtrans';
					}
				}
			}
			var simulationComboHide = true;
			if(!Ext.isEmpty(innerActiveTab) && innerActiveTab != null && innerActiveTab != undefined && innerActiveTab == 'logonSim')
				simulationComboHide = false;
			curViewTab = innerActiveTab;
			var tabPanelAllFlag=false;
			if((isTransEnabled && isEmuEnabled))
			{
				if(!isTabChanged )
				{
					if(jsonData.HiddenFields.selectedTab=="EmulatedClients")
					{
						tabPanelAllFlag=false;
						tabPanelAll = Ext.create('services.view.TransactionsMainTabPanelAll',{
						margin:'9 10 10 10',
						flex:1,
						frame:false,
						border:false,
						id:'tabAll',
						cls:'uxtab',
						activeTab:activePanel, // Setting the ative TAB
						layout:{type:'fit'},
						items:[{
							iconCls:'iconWebTransActive',
							title:'',
							itemId:'webtrans',
							id:'webtrans',
							dataUrl:selectedTabProp['dataUrl'],
							items:[],
							listeners:{
								activate:function(tab){
									tab.setTitle(selectedTabProp['title']);
									tab.removeCls("iconWebTrans");
									tab.setIconCls("iconWebTransActive");
								},
								deactivate:function(tab){
									tab.setTitle("");
									tab.setIconCls("iconWebTrans");
									tab.removeCls("iconWebTransActive");
									}
								}
							},
							{
							iconCls:'iconWebTransActive',
							title:'',
							itemId:'emultrans',
							id:'emultrans',
							dataUrl:selectedTabProp['emuldataUrl'],
							items:[tabPanel],
							listeners:{
								activate:function(tab){
									tab.setTitle(selectedTabProp['emultitle']);
									tab.removeCls("iconWebTrans");
									tab.setIconCls("iconWebTransActive");
								},
								deactivate:function(tab){
									tab.setTitle("");
									tab.setIconCls("iconWebTrans");
									tab.removeCls("iconWebTransActive");
									}
								}
							},
							{
								iconCls:'iconSynthTrans',
								title:'SYNTHETIC TRANSACTIONS',
								itemId : selectedTabProp['itemId'],
								itemId:'synTrans',
								id:'synTrans',
								dataUrl:selectedTabProp['dataUrl'],
								listeners:{
									activate:function(tab){
										tab.setTitle("Synthetic User Monitoring");
										tab.removeCls("iconSynthTrans");
										tab.setIconCls("iconSynthTransActive");
									},
									deactivate:function(tab){
										tab.setTitle("");
										tab.setIconCls("iconSynthTrans");
										tab.removeCls("iconSynthTransActive");
										}
									}
							},{
							iconCls:'iconRumTrans',
							title:'REAL USER MONITORING',
							itemId : selectedTabProp['itemId'],
							itemId:'rumTrans',
							id:'rumTrans',
							flex:1,
							dataUrl:selectedTabProp['dataUrl'],
							listeners:{
								'activate':function(tab){
									tab.setTitle("Real User Monitoring");
									tab.removeCls("iconRumTrans");
									tab.setIconCls("iconRumTransActive");
								},
								'deactivate':function(tab){
									tab.setTitle("");
									tab.setIconCls("iconRumTrans");
									tab.removeCls("iconRumTransActive");
									}
								}
							},
							{
							iconCls:'iconSynthTrans',
							title:'',
							//itemId : selectedTabProp['itemId'],
							itemId:'logonSim',
							id:'logonSim',
							autoScroll:true,
							ui:'logonsim',
							scroll:true,
							//style:{'overflow':'hidden !important','width':'40px !important'},
							flex:1,
							layout:{type:'fit',align:'stretch'},
							//dataUrl:selectedTabProp['dataUrl'],
							height:245,
							items:[logonSimWin],
							listeners:{
								activate:function(tab){
									tab.setTitle(logonTitle);
									tab.removeCls("iconSynthTrans");
									tab.setIconCls("iconSynthTransActive");
								},
								deactivate:function(tab){
									tab.setTitle("");
									tab.setIconCls("iconSynthTrans");
									tab.removeCls("iconSynthTransActive");
									}
								}	
							}],
							listeners:{
								render:function()
								{
									/*me=this;
									totalBody = me.up('tabpanel').getWidth() -6;
									var totalOther="";
									me.items.each(function(bt,i){
										//console.log(bt.getWidth());
										if(bt!=null && bt!=undefined)
										{
											if (bt.getXType()!='tab')
											{
												itemArry.push(bt.getWidth());
											}
											
											if(i == me.items.length-1){
												totalOther = itemArry.reduce(function(pV, cV) {
														return pV + cV;
												});
											}
											var textLeft=totalBody - totalOther;
										}
									});*/

									this.tabBar.add(
										{
										xtype:'container',
										id:'tabBarHeader',
										layout:{type:'hbox',align:'stretch'},
										margin:'10 0 0 0',
										style:{'left':'0px !important'},
										items:[
										{
											xtype:'label',
											cls:"state_"+serviceState,
											border:0,
											margin:'-2 0 0 0'
										},{
											xtype:'label',
											html:'&nbsp;<span class="f14-bold" style="margin-right:6px;">'+screenLabels["Title"]+'</span>'
												
										},
										{xtype:'tbseparator'},
										{
											xtype:'button',
											tooltip:'Layer Model',
											style:{'border':'none'},
											cls:'iconLayerstack',
											handler: function() {
												DashboardToLayers(compName,compType,siteName);
											}
										},
										{xtype:'tbseparator'},
										{
											xtype:'button',
											tooltip:'Topology',
											style:{'border':'none'},
											cls:'iconShare',
											handler: function() {
												DashboardToTopology();
											}
										},
										{
											xtype:'combo',
											id:'simulationCombo',
											itemId:'simulationCombo',
											editable : false,
											margin:'-4 0 0 50',
											width:250,
											hidden:simulationComboHide,
											store:simulationComboStore,
											cls : 'dropdown',
											displayField:'name',
											valueField:'value',
											trigerAction:'all',
											fieldLabel:''+simLabel,
											labelWidth:80,
											value:simulationSelectedVal,
											queryMode : 'local',
											hidden:true
										},
										{
											xtype:'combo',
											id:'componentCombo',
											itemId:'componentCombo',
											editable : false,
											margin:'-4 0 0 50',
											hidden:defalutHide,
											store:comboStore,
											cls : 'dropdown',
											width:250,
											displayField:'name',
											valueField:'value',
											trigerAction:'all',
											fieldLabel:''+label,
											value:selectedVal,
											queryMode : 'local',
											hidden:true
										}
										]
										}
									);
								}
						},
					});
					}
					else
						tabPanelAllFlag=true;
				}
				else
					tabPanelAllFlag=true;
			}
			else
			{
				tabPanelAllFlag=true;
			}

			if(tabPanelAllFlag)
			{
				tabPanelAll = Ext.create('services.view.TransactionsMainTabPanelAll',{
						margin:'9 10 10 10',
						flex:1,
						frame:false,
						border:false,
						id:'tabAll',
						cls:'uxtab',
						activeTab:activePanel, // Setting the ative TAB
						layout:{type:'fit'},
						items:[{
							iconCls:'iconWebTransActive',
							title:'',
							itemId:'webtrans',
							id:'webtrans',
							dataUrl:selectedTabProp['dataUrl'],
							items:[tabPanel],
							listeners:{
								activate:function(tab){
									tab.setTitle(selectedTabProp['title']);
									tab.removeCls("iconWebTrans");
									tab.setIconCls("iconWebTransActive");
								},
								deactivate:function(tab){
									tab.setTitle("");
									tab.setIconCls("iconWebTrans");
									tab.removeCls("iconWebTransActive");
									}
								}
							},
							{
							iconCls:'iconWebTransActive',
							title:'',
							itemId:'emultrans',
							id:'emultrans',
							dataUrl:selectedTabProp['emuldataUrl'],
							items:[],
							listeners:{
								activate:function(tab){
									tab.setTitle(selectedTabProp['emultitle']);
									tab.removeCls("iconWebTrans");
									tab.setIconCls("iconWebTransActive");
								},
								deactivate:function(tab){
									tab.setTitle("");
									tab.setIconCls("iconWebTrans");
									tab.removeCls("iconWebTransActive");
									}
								}
							},
							{
								iconCls:'iconSynthTrans',
								title:'SYNTHETIC TRANSACTIONS',
								itemId : selectedTabProp['itemId'],
								itemId:'synTrans',
								id:'synTrans',
								dataUrl:selectedTabProp['dataUrl'],
								listeners:{
									activate:function(tab){
										tab.setTitle("Synthetic User Monitoring");
										tab.removeCls("iconSynthTrans");
										tab.setIconCls("iconSynthTransActive");
									},
									deactivate:function(tab){
										tab.setTitle("");
										tab.setIconCls("iconSynthTrans");
										tab.removeCls("iconSynthTransActive");
										}
									}
							},{
							iconCls:'iconRumTrans',
							title:'REAL USER MONITORING',
							itemId : selectedTabProp['itemId'],
							itemId:'rumTrans',
							id:'rumTrans',
							flex:1,
							dataUrl:selectedTabProp['dataUrl'],
							listeners:{
								'activate':function(tab){
									tab.setTitle("Real User Monitoring");
									tab.removeCls("iconRumTrans");
									tab.setIconCls("iconRumTransActive");
								},
								'deactivate':function(tab){
									tab.setTitle("");
									tab.setIconCls("iconRumTrans");
									tab.removeCls("iconRumTransActive");
									}
								}
							},
							{
							iconCls:'iconSynthTrans',
							title:'',
							//itemId : selectedTabProp['itemId'],
							itemId:'logonSim',
							id:'logonSim',
							autoScroll:true,
							ui:'logonsim',
							scroll:true,
							//style:{'overflow':'hidden !important','width':'40px !important'},
							flex:1,
							layout:{type:'fit',align:'stretch'},
							//dataUrl:selectedTabProp['dataUrl'],
							height:245,
							items:[logonSimWin],
							listeners:{
								activate:function(tab){
									tab.setTitle(logonTitle);
									tab.removeCls("iconSynthTrans");
									tab.setIconCls("iconSynthTransActive");
								},
								deactivate:function(tab){
									tab.setTitle("");
									tab.setIconCls("iconSynthTrans");
									tab.removeCls("iconSynthTransActive");
									}
								}	
							}],
							listeners:{
								render:function()
								{
									/*me=this;
									totalBody = me.up('tabpanel').getWidth() -6;
									var totalOther="";
									me.items.each(function(bt,i){
										//console.log(bt.getWidth());
										if(bt!=null && bt!=undefined)
										{
											if (bt.getXType()!='tab')
											{
												itemArry.push(bt.getWidth());
											}
											
											if(i == me.items.length-1){
												totalOther = itemArry.reduce(function(pV, cV) {
														return pV + cV;
												});
											}
											var textLeft=totalBody - totalOther;
										}
									});*/

									this.tabBar.add(
										{
										xtype:'container',
										id:'tabBarHeader',
										layout:{type:'hbox',align:'stretch'},
										margin:'10 0 0 0',
										style:{'left':'0px !important'},
										items:[
										{
											xtype:'label',
											cls:"state_"+serviceState,
											border:0,
											margin:'-2 0 0 0'
										},{
											xtype:'label',
											html:'&nbsp;<span class="f14-bold" style="margin-right:6px;">'+screenLabels["Title"]+'</span>'
												
										},
										{xtype:'tbseparator'},
										{
											xtype:'button',
											tooltip:'Layer Model',
											style:{'border':'none'},
											cls:'iconLayerstack',
											handler: function() {
												DashboardToLayers(compName,compType,siteName);
											}
										},
										{xtype:'tbseparator'},
										{
											xtype:'button',
											tooltip:'Topology',
											style:{'border':'none'},
											cls:'iconShare',
											handler: function() {
												DashboardToTopology();
											}
										},
										{
											xtype:'combo',
											id:'compTypeCombo',
											itemId:'compTypeCombo',
											labelAlign : 'left',
											editable : false,
											store:compStroe,
											hidden:isComponentType,
											labelSeparator:'',
											cls : 'dropdown',
											displayField: 'name',
											valueField: 'value',
												url:'url',
											trigerAction:'all',
											//fieldLabel:'Monitors',
											fieldLabel:compLabel+':',
											//labelWidth:60,
											width:250,
											queryMode: 'local',
											margin:'-4 0 0 25',
											value:compSelectedVal,
										},
										{
											xtype:'combo',
											id:'componentCombo',
											itemId:'componentCombo',
											editable : false,
											margin:'-4 0 0 25',
											hidden:defalutHide,
											store:comboStore,
											cls : 'dropdown',
											width:250,
											displayField:'name',
											valueField:'value',
											trigerAction:'all',
											fieldLabel:''+label,
											value:selectedVal,
											queryMode : 'local'
										},
										{
											xtype:'combo',
											id:'simulationCombo',
											itemId:'simulationCombo',
											editable : false,
											margin:'-4 0 0 25',
											width:250,
											hidden:simulationComboHide,
											//style:{'border':'1px solid blue !important'},
											store:simulationComboStore,
											cls : 'dropdown',
											displayField:'name',
											valueField:'value',
											trigerAction:'all',
											fieldLabel:''+simLabel,
											labelWidth:80,
											value:selectedSimulation,
											queryMode : 'local'
										}
										]
										}
									);
								}
						},
					});
			}
			//tabPanelAll.setActiveTab(0);
		}
		if(isEmuEnabled == true || isEmuEnabled == 'true'){
			/*var iconAd = Ext.getCmp('iconAddId');
			var iconAddLineId = Ext.getCmp('iconAddLineId');
			console.log("iconAddLineId",iconAddLineId);
			if(!Ext.isEmpty(iconAd))
				iconAd.setVisible(false);
			if(!Ext.isEmpty(iconAddLineId))
				iconAddLineId.setVisible(false);*/
		}
		var faultyServer = jsonData.GridScreenLabels["faultyServer"];
		var regexObj = RegExp('NULL','i');
		var flag = regexObj.test(String(faultyServer));
		if(flag)
			faultyServer = faultyServer.substring(0,faultyServer.indexOf(':')) + ')';

		var lastTimeStr = "";
		if(!Ext.isEmpty(jsonData.GridScreenLabels["lastMeasurementTime"]))
		{
			/* lastTimeStr = '<div style="font-size:12px;margin:5px 15px 0"><span id="lastMeasurementTime">'+jsonData.GridScreenLabels["lastMeasurementTime_Text"]+': '+Ext.Date.format(new Date(jsonData.GridScreenLabels["lastMeasurementTime"]),
			mgr_dateFormat+" H:i:s")+'</span><span id="faultyServer">'+faultyServer+'</span></div>';*/
			//lastTimeStr = '<div style="margin:5px 15px 0"><span id="lastMeasurementTime" class="font_normal12"> '+jsonData.GridScreenLabels["lastMeasurementTime_Text"]+': '+Ext.Date.format(new Date(jsonData.GridScreenLabels["lastMeasurementTime"]),
			//lastTimeStr = '<div style="margin:5px 15px 0"><span id="lastMeasurementTime" class="font_normal12"> '+jsonData.GridScreenLabels["lastMeasurementTime_Text"]+': '+Ext.Date.format(new Date(jsonData.GridScreenLabels["lastMeasurementTime"]),
			//mgr_dateFormat+" H:i:s")+'</div>';
			lastTimeStr = '<div style="margin:5px 15px 0"><span id="lastMeasurementTime" class="font_normal12"> '+jsonData.GridScreenLabels["lastMeasurementTime_Text"]+': '+jsonData.GridScreenLabels["lastMeasurementTime"]+'</div>';
		}
		else
		{
			lastTimeStr = '<div style="font-size:12px;margin:5px 15px 0"><span id="faultyServer">'+faultyServer+'</span></div>';
		}
		/*tabPanel.getTabBar().add([{xtype:'tbfill'},
		{
			xtype:'label',
			html:lastTimeStr
		},{
				xtype:'button',
				iconCls: 'iconAdd',
				id:'iconAddId',
				itemid:'iconAddId',
				margin:'3px 0 0 0',
				hidden:hideConfigIcon,
				style:{
					background:'none',border:'0px'
					},
				//cls : 'component-list-right-panel-header-button',
				//text : jsonData.GridScreenLabels["configureTransBtnLabel"],
				action:'transactionsGridConfigureBtn'
			},{xtype:'tbseparator',id:'iconAddLineId',
				itemid:'iconAddLineId',margin:'5px 0px 0 5px'},
			{
				xtype:'button',
				margin:'5px 0 0 0',
				enableToggle: true,
				iconCls:'iconPanelUpArrow',
				style:{
					background:'none',border:'0px'
					},
				handler:function(){
				tabPanel.toggleCollapse();
				tabPanel.getTabBar().show();
				if(this.pressed == true){
					
					this.setIconCls("iconTreeDownArrow");
					//tabPanel.disable(true);
					 //this.disable(false);
					
				}else{
					this.setIconCls("iconPanelUpArrow");
					//tabPanel.disable(false);
					 
					
					
				}
			}
			}]);*/

	//this.insert(1,tabPanel);
		
	if(runDis)
		tabPanelAll.child('#synTrans').tab.hide();
	else{
		tabPanelAll.child('#synTrans').tab.hide();
		tabPanelAll.child('#rumTrans').tab.hide();
	}

	if(!isEmuEnabled && !isTransEnabled && isLogonEnabled == 'true'){
		tabPanelAll.child('#webtrans').tab.hide();
		tabPanelAll.child('#emultrans').tab.hide();
	}
	if(isEmuEnabled && (!isTransEnabled))
	{
		//tabPanelAll.child('#webtrans').tab.hide();
		tabPanelAll.child('#emultrans').tab.hide();
	}
	else if((!isEmuEnabled) && isTransEnabled)
	{
		tabPanelAll.child('#emultrans').tab.hide();
	}
	
	if(isLogonEnabled == false || isLogonEnabled == 'false')
		tabPanelAll.child('#logonSim').tab.hide();
	this.insert(1,tabPanelAll);
	},
	displayRum:function(rumUrl,serviceName,trasFlag,serviceState,jsonData){
		var compName = rumUrl.substring(rumUrl.indexOf('compName=')+9);

		var label='',selectedVal='',simLabel='',simulationSelectedVal='',simulationSelectedOrgValue = '';
		var compLabel='',compSelectedVal='',selectedCompType='';
		var defalutHide = false;
		var isComponentType = true;
		var compStroe,comboStore,simulationComboStore;
		var simulationComboHide = true;
		var isEmuEnabled = jsonData.isEmulTrans;
		var isWebTrans = jsonData.isWebTrans;
		var isLogonSimul = jsonData.isLogonSimul;
		var isrumTab = jsonData.isrumTab;
		var logonParam = jsonData.logonParam;
		var logonTitle = jsonData.logonTitle;
		
		var tempObject = new Array();

		if(rumServiceList != null  ){
			for(var a=0;a<rumServiceList.length;a++){
				if(rumServiceList[a]== curServiceName){
					tempObject.push(rumServiceListObject[a]);
				}
			}
		}
		var tempObjectSize = tempObject.length;
		if(tempObjectSize == 1){
			defalutHide = true;
			isComponentType = true;
		}
		if(tempObjectSize > 1){
			
			var storeArray = new Array();
			var selectedVal = '';

			for(var a=0;a<tempObject.length;a++){
				var obj = tempObject[a];
				var objStore = new Object();
				if(obj.port == 'NULL')
					objStore.name = obj.value;
				else
					objStore.name = obj.value+":"+obj.port;
				objStore.value = "Real_user_monitor:"+obj.value+":"+obj.port;
				objStore.comptype = "Real_user_monitor";

				if(selectedVal=='')
				{
					if(obj.port == 'NULL')
						selectedVal = obj.value;
					else
						selectedVal = obj.value+":"+obj.port;
				}
				storeArray.push(objStore);
			}
			var totalObject = new Object();
			totalObject.label="Component";
			totalObject.options=storeArray;
			totalObject.selectedValue=selectedVal;
			comboStore = Ext.create('Ext.data.Store',{
				fields:['value','name', 'comptype'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'options'
					}
				},
				data:totalObject
			});
			defalutHide = false;
			isComponentType = true;
			label = totalObject.label;
			selectedVal = totalObject.selectedValue;
			
		}

		var serviceRefSortByLogon = "";
		var serviceRefSortByLogonType = "";
		var serviceRefSortByLogonId = "";

		if(!Ext.isEmpty(jsonData.HiddenFields))
		{
			serviceRefSortByLogon = jsonData.HiddenFields.serviceRefSortByLogon;
			serviceRefSortByLogonType = jsonData.HiddenFields.serviceRefSortByLogonType;
			serviceRefSortByLogonId = jsonData.HiddenFields.serviceRefSortByLogonId;
		}

		var componentListObj = jsonData.componentListObj;
		if(!Ext.isEmpty(componentListObj) && componentListObj!=null && componentListObj!=undefined && !isrumTab && (isLogonSimul || (!isEmuEnabled && !isTransEnabled)))
		{
			isComponentType = false;
			compStroe = Ext.create('Ext.data.Store',{
				fields:['value', 'name', 'url'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'options'
					}
				},
				data:componentListObj
			});
			compLabel = componentListObj.label;
			compSelectedVal = componentListObj.selectedValue;
			selectedCompType =componentListObj.selectedValue;
		}

		var externalAgentsList = jsonData.externalAgents;
		if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && !isrumTab && (isLogonSimul || (!isEmuEnabled && !isTransEnabled))){
			extAgentData = externalAgentsList;
			comboStore = Ext.create('Ext.data.Store',{
				fields:['value', 'name'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'options'
					}
				},
				data:externalAgentsList
			});
			label = extAgentData.label;
			selectedVal = externalAgentsList.selectedValue;
			selectedExtAgent = externalAgentsList.selectedValue;
		}
		var logonComponentsList = jsonData.logonComponentList;
		if(logonComponentsList != null && !Ext.isEmpty(logonComponentsList) && !isrumTab && logonComponentsList != undefined)
		{
			extSimData = logonComponentsList;
			logonComponentsList = logonComponentsList[selectedExtAgent];
			simulationComboStore = Ext.create('Ext.data.Store',{
				fields:['value', 'name', 'comptype'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'options'
					}
				},
				data:logonComponentsList
			});
			simLabel = logonComponentsList.label;
			simulationSelectedVal = logonComponentsList.selectedValue;
			simulationSelectedOrgValue = logonComponentsList.selectedOrgValue;
		}
		var rumWin = this.add({
			xtype:'panel',
			border:false,
			flex:1,
			layout:{type:'fit'},
			//cls:'rumDataInnerpanel',
			//height:370,
			//title:'Geo Performance',
			//columnWidth:.50,
			//layout:{type:'vbox',align:'stretch'},
			//layout:'fit',
			//width:540,
			//minWidth:520,
			padding:'0 0 0 0',
			//margin:'0 15 0 0',
			//cls:'content-frame',
			scroll:false,
			autoScroll:false,
			id:'geoMapPanel',
			//id:'asaa',
			listeners:{
				'afterrender':function(){
					//alert("Test");
					//alert("geoMapPanel--------"+Ext.getCmp("geoMapPanel"));
					//alert("servicestreepanel--------"+Ext.getCmp("servicestreepanel").getWidth());

					var treeWidth=Ext.getCmp("servicestreepanel").getWidth();
					var width = Ext.getBody().getViewSize().width;
					

					//alert("screen height--------"+height);

				//alert("width---------"+width+"treeWidth---------"+treeWidth);

					Ext.getCmp("geoMapPanel").setWidth((width-treeWidth)-32);
				}
			},
			style:{'border':'0px solid red','top':'-3px !important','left':'-6px !important','background':'transparent !important'},
			items : [{
				frame: false,
				border: true,
				xtype : "component",
				autoEl : {
					tag : "iframe",
					src: rumUrl,
					border:false,
					frameborder:0,
					style:{'border':'none'},
					flex:1,
					height:height+845,
					autoScroll:true,
					scroll:true,
					layout:{type:'fit'},
				}
			}]
			//html:"<iframe id='asa'  width='100%' height='1550' src='"+rumUrl+"' border='0' scrolling='no' marginwidth='0px' marginheight='0px' frameborder='0' allowtransparency='true' style='border:0px solid red' ></iframe>"
			//html:"<iframe id='asa'  width='100%' height='1550'  border='0' scrolling='no' marginwidth='0px' marginheight='0px' frameborder='0' allowtransparency='true' style='border:0px solid red' ></iframe>"
		});

		var logonWin = this.add({
			xtype:'panel',
			flex:1,
			layout:{type:'fit',align:'stretch'},
			padding:'0 0 0 0',
			scroll:false,
			autoScroll:false,
			constrain : true,
			autoDestroy:true,
			id:'logonSimPanel',
			ui:'logonsim',
			//style:{'border':'0px solid red','top':'-3px !important','left':'-6px !important','background':'transparent !important'},
			items : [{
				xtype : "component",
				id:'logonSimCompId',
				constrain : true,
				timelineParamJson:null,
				service_RefSortByLogon:null,
				service_RefSortByLogonType:null,
				service_RefSortByLogonId:null,
                autoEl : {
					tag : "iframe",
					itemId:'logonSimIframeId',
					constrain : true,
					frameBorder:0,
					src: '/final/monitor/comparisonDashboard.jsp?'+logonParam+'&isFromMenu=true&showGraph=true&isLogonFromService=true&servicename='+serviceName+'&externalAgent='+selectedVal+'&subFilter=&componentNameSearch='+simulationSelectedOrgValue+'&serviceRefSortByLogon='+serviceRefSortByLogon+'&serviceRefSortByLogonType='+serviceRefSortByLogonType+'&serviceRefSortByLogonId='+serviceRefSortByLogonId,
				}
			}]
		});
	this.doLayout();
		if(serviceState==null || serviceState==undefined)
			serviceState="GOOD";
		curViewTab = 'rumTrans';
		var tabPanelAll = Ext.create('services.view.TransactionsMainTabPanelAll',{
			margin:'9 10 10 10',
			autoDestroy: true,
			flex:1,
			//height:530,
			frame:false,
			border:true,
			id:'tabAll',
			items:[{
				iconCls:'iconRumTrans',
				title:'REAL USER MONITORING',
				itemId:'rumTrans',
				id:'rumTrans',
				cls:'iconRumTrans',
				//flex:1,
				margin:0,
				padding:0,
				dataUrl:'',
				autoScroll:true,
				scroll:true,
				style:{'overflow-x':'hidden !important'},
				items:[rumWin],
				listeners:{
					'activate':function(tab){
						//alert(tab.id + ' was activated.');
						tab.setTitle("REAL USER MONITORING");
						tab.removeCls("iconRumTrans");
						tab.setIconCls("iconRumTransActive");
						//Ext.getCmp("webTrans").setWidth(50);
						//tab.setWidth(200);

					},
					'deactivate':function(tab){
						//alert(tab.title + ' was activated.');
						tab.setTitle("");
						//tab.setWidth(28);
						//tab.setWidth(50);
						tab.setIconCls("iconRumTrans");
						tab.removeCls("iconRumTransActive");
					}
				}
				},{
				iconCls:'iconSynthTrans',
				//title:'SYNTHETIC TRANSACTIONS',
				itemId:'synTrans',
				id:'synTrans',
				//flex:1,
				//dataUrl:selectedTabProp['dataUrl'],
				//items:[tabPanel],
				//width:400,
				listeners:{
					'activate':function(tab){
						//alert(tab + ' was activated.');
						tab.setTitle("SYNTHETIC TRANSACTIONS");
						tab.removeCls("iconSynthTrans");
						tab.setIconCls("iconSynthTransActive");
						//tab.setWidth(400);
					},
					'deactivate':function(tab){
						//alert(tab + ' was deactivated.');
						Ext.getCmp("webTrans").setTitle("");
						tab.setIconCls("iconSynthTrans");
						tab.removeCls("iconSynthTransActive");
					}
				}
				},
				{
				iconCls:'iconWebTrans',
				//title:'WEB TRANSACTIONS',
				//itemId : selectedTabProp['itemId'],
				itemId:'webtrans',
				margin:0,
				padding:0,
				id:'webtrans',
				jsonData:jsonData,
				//style:{'overflow':'hidden !important','width':'40px !important'},
				//flex:1,
				//dataUrl:selectedTabProp['dataUrl'],
				//items:[tabPanel],
					listeners:{
								'activate':function(tab){
									var tmp_title="WEB TRANSACTIONS";
									/*if(tab.jsonData != null && !Ext.isEmpty(tab.jsonData))
									{
										var isEmuEnabled = tab.jsonData.isEmulTrans;
										var isTransEnabled = tab.jsonData.isWebTrans;
										if(isEmuEnabled=='true' && isTransEnabled=='false')
											tmp_title="EMULATED TRANSACTIONS";
									}*/
									//tab.setTitle("WEB TRANSACTIONS");
									tab.setTitle(tmp_title);
									tab.removeCls("iconWebTrans");
									tab.setIconCls("iconWebTransActive");
									//Ext.getCmp("rumTrans").setWidth(50);
									//tab.setWidth(200);

							},
								'deactivate':function(tab){
									//alert(tab.title + ' was activated.');
									tab.setTitle("");
									//alert(Ext.getCmp("rumTrans").tab.setTitle("44444"));
									tab.setIconCls("iconWebTrans");
									tab.removeCls("iconWebTransActive");
							}
						}
				},
				{
					iconCls:'iconWebTransActive',
					title:'',
					itemId:'emultrans',
					id:'emultrans',
					jsonData:jsonData,
					//dataUrl:selectedTabProp['emuldataUrl'],
					//items:[tabPanel],
					listeners:{
						activate:function(tab){
							tab.setTitle("EMULATED TRANSACTIONS");
							tab.removeCls("iconWebTrans");
							tab.setIconCls("iconWebTransActive");
						},
						deactivate:function(tab){
							tab.setTitle("");
							tab.setIconCls("iconWebTrans");
							tab.removeCls("iconWebTransActive");
							}
						}
					},
				{
				iconCls:'iconSynthTrans',
				title:'',
				itemId:'logonSim',
				id:'logonSim',
				cls:'iconSynthTrans',
				//flex:1,
				margin:0,
				padding:0,
				dataUrl:'',
				layout:{
					type:'fit'
				},
				autoScroll:true,
				scroll:true,
				style:{'overflow-x':'hidden !important'},
				items:[logonWin],
				listeners:{
					'activate':function(tab){
						tab.setTitle(logonTitle);
						tab.removeCls("iconSynthTrans");
						tab.setIconCls("iconSynthTransActive");
					},
					'deactivate':function(tab){
						tab.setTitle("");
						tab.setIconCls("iconSynthTrans");
						tab.removeCls("iconSynthTransActive");
					}
				}
				}],
				listeners:{
						render:function()
						{
							this.tabBar.add(
								{
									//html:'<div id="toplabel" style="'+mLeft+';margin-top:7px"><div id="stateIcon" style="float:left;margin-right:3px" class="state_'+serviceState+'"></div><div class="uxtab-separator" style="float:left;font-size:12px;font-weight:bold;padding-right:7px;margin-right:5px">'+serviceName+'</div><div style="float:left;margin-right:5px;width:25px" onclick=\'DashboardToLayers("'+compName+'","Real_user_monitor");\'  class="iconLayerstack uxtab-separator mouse" data-class="yellowTip"  data-qtip="Layermodel"></div><div style="float:left;margin-right:5px;width:25px" onclick=\'DashboardToTopology();\' data-class="yellowTip" data-qtip="Topology" class="iconShare uxtab-separator mouse"></div></div>'
									xtype:'container',
									id:'tabBarHeader',
									layout:'hbox',
									margin:'10 0 0 0',
									style:{'left':'0px !important'},
									items:[
									{
										xtype:'label',
										cls:"state_"+serviceState,
										border:0,
										margin:'0 5 0 0'
									},{
										xtype:'label',
										cls:'font_bold14',
										html:serviceName
									},
									{xtype:'tbseparator'},
									{
										xtype:'button',
										tooltip:'Layer Model',
										style:{'border':'none'},
										cls:'iconLayerstack',
										handler: function() {
											DashboardToLayers(compName,'Real_user_monitor',serviceName);
										}
									},
									{xtype:'tbseparator'},
									{
										xtype:'button',
										tooltip:'Topology',
										style:{'border':'none'},
										cls:'iconShare',
										handler: function() {
											DashboardToTopology();
										}
									},
									{
										xtype:'combo',
										id:'compTypeCombo',
										itemId:'compTypeCombo',
										labelAlign : 'left',
										editable : false,
										store:compStroe,
										hidden:isComponentType,
										labelSeparator:'',
										cls : 'dropdown',
										displayField: 'name',
										valueField: 'value',
											url:'url',
										trigerAction:'all',
										//fieldLabel:'Monitors',
										fieldLabel:compLabel+':',
										//labelWidth:60,
										width:250,
										queryMode: 'local',
										margin:'-4 0 0 30',
										value:compSelectedVal,
									},
									{
										xtype:'combo',
										itemId:'componentCombo',
										editable : false,
										id:'componentCombo',
										top:0,
										margin:'-4 0 0 50',
										hidden:defalutHide,
										store:comboStore,
										cls : 'dropdown',
										displayField:'name',
										valueField:'value',
										trigerAction:'all',
										fieldLabel:''+label,
										width:250,
										value:selectedVal,
										queryMode : 'local'
									},
									{
										xtype:'combo',
										id:'simulationCombo',
										itemId:'simulationCombo',
										editable : false,
										margin:'-4 0 0 30',
										hidden:simulationComboHide,
										store:simulationComboStore,
										cls : 'dropdown',
										displayField:'name',
										valueField:'value',
										trigerAction:'all',
										fieldLabel:''+simLabel,
										width:250,
										labelWidth:80,
										value:simulationSelectedVal,
										queryMode : 'local'
									}
									]
									
								}
								
							);

							//this.tabBar.doComponentLayout();
						}
				}
		 });
		if(jsonData != null && !Ext.isEmpty(jsonData))
		{
			var isEmuEnabled = jsonData.isEmulTrans;
			var isTransEnabled = jsonData.isWebTrans;
			var isLogonEnabled = jsonData.isLogonSimul;
			if((! isEmuEnabled || isEmuEnabled == false || isEmuEnabled == 'false') && (!isTransEnabled || isTransEnabled == false || isTransEnabled == 'false')){
				tabPanelAll.child('#webtrans').tab.hide();
			}
			if(!isLogonEnabled || isLogonEnabled == false || isLogonEnabled == 'false'){
				tabPanelAll.child('#logonSim').tab.hide();
			}
		}
		
		/*if(hasTransactions == true || hasTransactions == 'true')
		{
			tabPanelAll.child('#synTrans').tab.hide();
		}else*/ if(trasFlag == true || trasFlag == 'true'){
			tabPanelAll.child('#synTrans').tab.hide();
		}
		else{
			//tabPanelAll.child('#webtrans').tab.hide();
			tabPanelAll.child('#synTrans').tab.hide();
		}
		this.insert(1,tabPanelAll);
	},
	displayGrid:function(jsonData){
		/*var systemGrid=Ext.create('services.view.TransactionGridPanel',{
			jsonData:jsonData,
			border:false,
			frame:false,
			style:{'border':'0px solid red !important'},
			flex:0.9652
		});*/
		//this.removeAll();
		var topToolbar=this.getDockedComponent(0);
		if(!Ext.isEmpty(topToolbar)){
			this.removeDocked( topToolbar, true);
		}
		//this.add(systemGrid);

		this.add({
			xtype:'toolbar',
			height:14,
			margin:0,
			hidden:true,
			padding:0,
			border:false,
			frame:false,
			style:{'border':'1px solid #d7d7d7 !important'},
			//flex:0.0368,
			items:['->',{
				xtype:'tool',
				type:'up',
				cls:'x-toolbar-custom',
				action:'up'
			},{
				xtype:'tool',
				type:'down',
				cls:'x-toolbar-custom',
				action:'down'
			},'->']
		});
		/*this.add({
			xtype:'transactionschartpanel',
			jsonData:jsonData,
			margin:'10',
			padding:0,
			flex:1
		});*/
		
		/*this.add({
			xtype:'panel',
			url:"/final/monitor/realUserMonitorsDashboard.jsp",
			margin:'10',
			padding:0,
			flex:1
		});*/
		//this.doLayout();
	},
	ConfigurePanels : function(jsonData){
		
		var itemsArray =new Array();
		var upperPanel= "";
		var trans = [];
		
		var comboStore = Ext.create('Ext.data.Store',{
			fields:['value','name'],
			proxy:{
				type: 'memory',
				reader: {
					type: 'json',
					root:'options'
				}
			},
			data:jsonData.IconsInfo
		});
		
		//setValue("");
		if(trans.length<12){
			var addtransactionDetails = {
				xtype:'form',
				//width:780,
				//cls:'formOuter',
				bodyPadding:0,
				margin:'0px 0px 0px 0px',
				defaults:{
					labelSeparator:'',
					labelAlign:'top',
					margin:'5px 10px 10px 10px',
				},
				layout:'hbox',
				items:[
				{
							xtype: 'scrollcombo',
							//cls : 'dropdown',
							store:comboStore,
							id:'imagecombo',
							cls:'imagecombo',
							name:'imagecombo',
							displayField:'name',
							valueField:'value',
							queryMode: 'local',
							editable: false,
							typeAhead: false,
							editable:false,
							value:'Choose a type',
							fieldLabel: jsonData.DownGridLabels.newTransType,
							tpl: Ext.create('Ext.XTemplate',
								'<ul>',
								'<tpl for=".">',
									'<li class="x-boundlist-item"><span style="padding-left:18px" class=trans_{value}_small></span>{name}</li>',
								'</tpl>',
								'</ul>'
							),
							listeners:{
								select:function(combo, records, eOpts){
									var record = records[0];
									var image = record.get('value');
									cls = 'trans_'+image+'_small';
									if(image){
									$('#'+combo.inputEl.id).removeClass().addClass(cls);
									}
									
			
								}
							}
							// template for the content inside text field
							/*displayTpl: Ext.create('Ext.XTemplate',
								'<tpl for=".">',
									'{name}',
								'</tpl>'
							)*/
						},
				 {
						xtype : 'textfield',
						cls:'textbox',
						fieldLabel:jsonData.DownGridLabels.newTransName,
						
						
						//cls : 'configure-transaction-textfield',
						//fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
						
						labelSeparator:'',
						width : '220px',
						labelAlign:'top',
						id : 'tname',
						action : 'tname'
					}, {
						xtype : 'textfield',
						fieldLabel:jsonData.DownGridLabels.pagesToInclude,
						labelAlign:'top',
						cls:'textbox',
						
						//cls : 'configure-transaction-textfield',
						//fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
						
						labelSeparator:'',
						labelAlign:'top',
						width : '210px',
						action : 'tpage',
						id : 'tpage'
					},{
						xtype : 'button',
						text : jsonData.DownGridLabels.addBtnLabel,
						
						//cls : 'delete-service-transaction-button',
						action:'addAction',
						id:'addButton',
						cls: 'button20',
						margin:'27px 10px 0px 10px',
						handler: function() {
							var transNameStr = Ext.getCmp('tname').getValue();
							var incluedPageStr = Ext.getCmp('tpage').getValue();
							//var imagecomboStr = Ext.getCmp('imagecombo').getRawValue();
							var imagecomboStr = Ext.getCmp('imagecombo').getRawValue();
							var imagecomboDispStr = Ext.getCmp('imagecombo').getValue();
							var siteName = jsonData.HiddenFields.site;
							if(siteName==null || siteName==undefined)
								siteName = jsonData.HiddenFields.siteName;
							var cuserName = jsonData.HiddenFields.currentuser;
							if( Ext.isEmpty(imagecomboStr) || Ext.isEmpty(transNameStr) || Ext.isEmpty(incluedPageStr) )
							{
								Ext.Msg.alert('Empty',"Choose required fields");
								return;
							}
							else
							{
								//incluedPageStr =  services.app.getController("Main").checkFields(incluedPageStr,'Page Include');
								

								var arrayValue2 = [];
								var arrayValue1 = [];

								var styleStr = '<div><img style="padding-left:18px;vertical-align:middle;dispaly:inline-block" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="trans_'+imagecomboDispStr+'_small"/>'+imagecomboStr+'</div>';
								//styleStr = styleStr;
								arrayValue1.push(styleStr);
								arrayValue1.push(transNameStr);
								arrayValue1.push(incluedPageStr);
								arrayValue2.push(arrayValue1);

								 

								var resultUrl = "../monitor/addTransactionsP.jsp?mode=add&site="+siteName+"&m="+imagecomboDispStr+"&currentuser="+cuserName+"&tran="+transNameStr+"&pageinclude="+incluedPageStr;
								Ext.Ajax.request({
									url: resultUrl,
									method: 'POST',
									async: false,
									success: function( response )
									{
										if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
										{
											
											
											var gridValue = Ext.getCmp('gridStore');
											if(!Ext.isEmpty(gridValue))
											{
												var recCount = gridValue.getStore().getCount()+1;
												gridValue.getStore().insert(recCount,arrayValue2);
												Ext.getCmp('tname').setValue('');
												Ext.getCmp('tpage').setValue('');
											}
											else
											{
												
											}
										}
									}
								});
							}

					    }
						
					}
				]
			}
			var topToolbar= {
					xtype : 'toolbar',
					docked : 'top',
					cls : 'component-list-right-panel-header',
					height : '30px',
					style:{'border':'0px solid red !important'},
					border:false,
					frame:false,
					items : [{
						xtype : 'label',
						text : jsonData.DownGridLabels.newTransName,
						cls : 'configure-transaction-label',
						action : 'tname'
					}, {
						xtype : 'textfield',
						cls:'textbox',
						margin:'0px 20px 0px 0px',
						//cls : 'configure-transaction-textfield',
						//fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
						labelCls :'config-window-font',
						labelSeparator:'',
						width : '200px',
						itemId : 'tname',
						action : 'tname'
					}, {
						xtype : 'label',
						text : jsonData.DownGridLabels.pagesToInclude,
						cls : 'configure-transaction-label'
					}, {
						xtype : 'textfield',
						cls:'textbox',
						margin:'0px 20px 0px 0px',
						//cls : 'configure-transaction-textfield',
						//fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
						labelCls :'config-window-font',
						labelSeparator:'',
						width : '250px',
						action : 'tpage',
						itemId : 'tpage'
					},'->',{
						xtype : 'button',
						text : jsonData.DownGridLabels.addBtnLabel,
						cls: 'button20',
						//cls : 'delete-service-transaction-button',
						itemId :'addbtn',
						action:'addbtn',
					}]
				}
				// Transaction image changes start here
				var transImages = [{
						xtype : 'panel',
						width : '100%',
						height : 25,
						border : false,
						html : '<div class="configure-transaction-info-text">&nbsp;* '+jsonData.DownGridLabels.info+'</div>'
				}];

				for(i=0;i<jsonData.IconsInfo.length;i++){
					transImages.push({
						xtype : 'container',
						width : 80,
						margin:14,
						layout:'column',
						border : true,
						items:[{
							xtype : 'radio',
							name : 'transaction',
							cls : 'radiobt',
							margin:'5 4 0 2',
							value:jsonData.IconsInfo[i].value			//Prem
						},{
							xtype:'component',
							html : '<div class="trans_'+jsonData.IconsInfo[i].value+'" title="'+jsonData.IconsInfo[i].name+'"></div>',
							listeners:{
								render: function(imageObj){
									imageObj.getEl().on({
										click: function() {
											imageObj.prev().setValue(true);
										}
									});
								}
							}
						}]
					});
				}
				// end here
			var lowerPanel = {
					xtype : 'panel',
					//autoScroll:true,
					
					width : '100%',
					cls:'block1',
					border:false,
					frame:false,
					
					//scrollable : true,
					//cls : 'new-transaction-panel',
					//bodyCls:'bottom-left-radius bottom-right-radius',
					flex : 3,
					layout:'vbox',
					items :[addtransactionDetails]			 // changes
				};
			
			//lowerPanel.xtype = 'scrollpanel';
			//lowerPanel.dockedItems=topToolbar;
			itemsArray.push(lowerPanel);
		}
		
			{
			var transArray = new Array();
			trans = jsonData.upperGridLabels.transHeaders;
			var panel = "";
			if(trans.length==0){
						var toolbar = {
								xtype : 'toolbar',
								docked : 'top',
								style:{'border':'0px solid red !important'},
								border:false,
								frame:false,
								//cls : 'top-left-radius top-right-radius',
								items : [{
									xtype : 'label',
									text : jsonData.upperGridLabels.transactionName,
									cls :'delete-service-transaction-label'
									},'->',
									{
									xtype : 'button',
									text : jsonData.upperGridLabels.deleteBtn,
									action : 'deleteTrans',
									//cls : 'delete-service-transaction-button',
									cls : 'button20',
									user : jsonData.upperGridLabels.user,
									
									tname : jsonData.upperGridLabels.transactionName,
									currentUser : Ext.isEmpty(jsonData.HiddenFields.currentuser)?"":jsonData.HiddenFields.currentuser
								}]
						}
				 panel = {
						xtype : 'panel',
						cls:'service-transaction-toolbar',
						//bodyCls:'bottom-left-radius bottom-right-radius',
						border:false,
						frame:false,
						style:{'border':'0px solid blue !important'},
						width : '100%',
						html : jsonData.upperGridLabels.files
						}
						panel.dockedItems = toolbar;
						transArray.push(panel);
			}
			var toolbar ="";
			var myOuterArray = [];
			var myData = [];
			for(var i=0; i < trans.length; i++){
				if(user != 'admin' && user == trans[i].user)
					this.enableSelectAll = true;

				var trmpStr = '<div><img style="padding-left:18px;vertical-align:middle;dispaly:inline-block" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="trans_'+trans[i].img+'_small"/>'+trans[i].uiImg+'</div>';
				//var trmpStr = '<div class="x-boundlist-item"><span style="padding-left:18px" class="'+trans[i].img+'"></span>'+trans[i].uiImg+'</div>';
				myData.push([trmpStr,trans[i].transactionName,trans[i].files]);
			}
			myOuterArray.push(myData);
			var store = Ext.create('Ext.data.ArrayStore', {
				fields: [
				   {name: 'Type'},
				   {name: 'Transaction Name'},
				   {name: 'Pages'}
				],
				data: myData
			});
				var grid = {
					xtype:'grid',
					id:'gridStore',
					height : 405,
					border:false,
					cls:'gridSkin',
					store:store,
					columns: [
								{
									text     : 'Type',
									flex     : .25,
									sortable : false,
									dataIndex: 'Type'
								},
								{
									text     : 'Transaction Name',
									//width    : 150,
									flex     : .3,
									sortable : true,
									dataIndex: 'Transaction Name'
								},
								{
									text     : 'Pages',
									//width    : 75,
									flex     : .4,
									sortable : true,
									dataIndex: 'Pages'
								},{
									xtype:'actioncolumn',
									width:32,
									items:[{
									iconCls:'iconDelete',
									tooltip:'Delete',
									 handler: function(grid, rowIndex, colIndex) {
											if(Ext.isEmpty(grid))
											{
												alert("No data found");
											}
											else
											{
												var rec = grid.getStore().getAt(rowIndex);
												
												var columnValue = grid.getStore().getAt(colIndex);
												var transName = rec.raw[1];
												var siteName = jsonData.HiddenFields.site;
												if(siteName==null || siteName==undefined)
													siteName = jsonData.HiddenFields.siteName;
												var cuserName = jsonData.upperGridLabels.user;
												var resultUrl = "../monitor/addTransactionsP.jsp?mode=del&site="+siteName+"&currentuser="+cuserName+"&trans="+transName;
												Ext.Ajax.request({
													url: resultUrl,
													method: 'POST',
													async: false,
													success: function( response )
													{
														if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
														{
															grid.getStore().removeAt(rowIndex);
															
														}
													}
												});
											}
										}
									}]
								}]
					}
				
			//}

			upperPanel = {
				xtype : 'panel',
				height : 405,
				padding:0,
				border:false,
				items:[grid],
				margin:'0 10 0 10',
				flex : 4
			}
			itemsArray.push(upperPanel);
		}
		return itemsArray;
	}
});
