Ext.define('servicesBusinessDash.controller.Main',{
	extend: 'Ext.app.Controller',
	requires:['utilities.ZoomGraphPanel','servicesBusinessDash.view.Main','servicesBusinessDash.view.ConfigWindow','servicesBusinessDash.view.Addwindow','utilities.ErrorPanel','servicesBusinessDash.view.SharingWindow','floatingContainer'],
	views:['Main','ConfigWindow','Addwindow','SharingWindow'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'main container[name=mainConId]',ref:'mainConId'},
		{ref : 'zoomGraphComboMode',selector : 'zoomgraphpanel  combo[itemId= "mode"]'},
		{ref : 'zoomGraphComboTimeline',selector : 'zoomgraphpanel  combo[itemId="timeline"]'},
		{ref : 'zoomGraphComboFromhr',selector : 'zoomgraphpanel combo[itemId= "fromhr"]'},
		{ref : 'zoomGraphComboTohr',selector : 'zoomgraphpanel combo[itemId= "tohr"]'},
		{ref : 'zoomGraphFromDate',selector : 'zoomgraphpanel datefield[itemId= "from"]'},
		{ref : 'zoomGraphToDate',selector : 'zoomgraphpanel datefield[itemId= "to"]'},
		{ref : 'zoomGraphComboShow',selector : 'zoomgraphpanel combo[itemId= "priority"]'},
		{ref:'zoomGraphPanel',selector:'zoomgraphpanel'},
		{
			selector: "addwindow",
			ref: "addWindow"
		},{
			selector: "configwindow",
			ref: "configWindow"
		},{
			selector: "sharingwindow",
			ref: "sharingWindow"
		},{
			selector: "floatingcontainer",
			ref: "floatingContainer"
		}],
	commonUrl:null,
	newWinId:null,
	init : function() {
		me=this;
		//var mainPanel=Ext.getCmp('main');
		setInterval("execute()",refreshFrequency);
		this.control({
			'main' : {
				render : this.renderMain
			},
			'zoomgraphpanel combo[itemId= "mode"]':{
				select:this.displayZoomGraph
			},
			'zoomgraphpanel combo[itemId= "timeline"]':{
				select:this.timelineChangeHandler
			},
			'zoomgraphpanel datefield[itemId= "from"]':{
				select:this.timelineDateChangeHandler
			},
			'zoomgraphpanel datefield[itemId= "to"]':{
				select:this.timelineDateChangeHandler
			},
			'zoomgraphpanel combo[itemId= "fromhr"]':{
				select:this.timelineDateChangeHandler
			},
			'zoomgraphpanel combo[itemId= "tohr"]':{
				select:this.timelineDateChangeHandler
			},
			'zoomgraphpanel combo[itemId= "priority"]':{
				select:this.displayZoomGraph
			},
			'zoomgraphpanel button[itemId="timelineAny"]':{
				render: function(component){
					var me=this;
					component.getEl().on('click', function(e){
						me.displayZoomGraph();
					});
				}
			},
			'zoomgraphpanel tool[itemId=minimizePanelDiv]':{
				click:this.bigGraphOnClick
			},
			'configwindow' : {
				'afterrender':function(){
					refreshEnable = false;
					this.loadTiersForSystem();
					Ext.getCmp('iconAutomaticScrollStop').hide();
					//Ext.getCmp('iconAutomaticScrollRun').show();
					Ext.getCmp('iconAutomaticScrollRun').hide();
					Ext.getCmp('iconAutomaticScrollJumpToTop').hide();
					jumpScroll();
					//this.newSelection();
				}
			},
			'sharingwindow' : {
				'afterrender':function(){
					this.loadDataForSharing();
					Ext.getCmp('iconAutomaticScrollStop').hide();
					//Ext.getCmp('iconAutomaticScrollRun').show();
					Ext.getCmp('iconAutomaticScrollRun').hide();
					Ext.getCmp('iconAutomaticScrollJumpToTop').hide();
					jumpScroll();
				}
			},
			'addwindow' : {
				'afterrender':function(){
					var serviceName = '-1';
					if(!Ext.isEmpty(Ext.getCmp('service')))
						serviceName = Ext.getCmp('service').getValue();

					if(serviceName!=null && serviceName!='-1')
					{
						this.getCompTypesForServices();
					}
					else
					{
						this.getLayerForComp();
						this.getCompName();
						//this.getCompNameValue();
						this.getMeasureForTest();
					}
				}
			},
			'addwindow combo[id="componentName"]':{
				select:this.getLayerForCompName
			},
			'addwindow combo[id="componentType"]':{
				select:function(){
					this.getLayerForComp();
					this.getCompName();
					//this.getCompNameValue();
					//this.getMeasureForTest();
				}
			},
            'configwindow button[id="update"]': {
                "click": this.clickUpdate
            },
            'configwindow button[id="add"]': {
                "click": this.addfn
            },
            'configwindow button[id="modify"]': {
                "click": this.ModifyMeasureDisplayName
            },
			'configwindow button[id="delete"]': {
                "click": this.deletefn
            },
			/*'configwindow radiogroup[id="Configuration"]': {
                "change": this.radiofn
			},*/
		/*	'configwindow radiogroup[id="Configuration"]': {
                "change": function(){
					this.getServiceName();
					this.specificFunction();

				}
			},*/
			'addwindow button[id="addbtn"]': {
				"click": this.appendData
			},
			'addwindow button[id="ok"]': {
				"click": this.popupClose
			},
			'modifywindow button[id="modifyOK"]': {
				"click": this.modifyPopupClose
			},
			/*'configwindow combo[id="service"]': {
                "select": function(combo,record,eOpts){
					this.getComponentForService(combo,record,eOpts);
					this.getInfoForService(combo,record,eOpts);
				}
			},*/
			'configwindow combo[id="serviceType"]': {
                "select":function(){
					this.getCompTypesForServiceType();
					this.getInfoForComp(); // table structure
					this.tableEmpty();
				}
			},
			'configwindow combo[id="filter"]': {
                "select": function(){
					this.getCompName();
					this.getInfoForComp();
				}
			},
			'addwindow combo[id="layer"]': {
				"change": this.getTestForLayer
			},
			'addwindow combo[id="test"]': {
				"change": this.getMeasureForTest
			},
			'addwindow combo[id="measure"]': {
				"change": this.measureDisplayName
			},
		/*	'addwindow combo[id="specifyTo"]': {
                "change": this.getCompNameValue
			},*/
			'configwindow radiogroup[id="Category"]': {
				"change": this.radioChangeFunction
			},
			'configwindow combo[id="service"]': {
                "change":function(){
					this.getServiceTypesForMainCategory();
					//this.getCompTypesForServiceType();
					//this.getInfo();
					//this.getInfoForCompOnChange();
					//this.getInfoForComp();
				}
			},
			'configwindow combo[id="serviceset"]': {
               			"change":function(){
					this.loadDataForUserConfig();
				}
			},
			'sharingwindow combo[id="sharingService"]': {
                		"change":function(){
					//this.getServiceTypesForMainCategory();
					this.loadUsersForService();
				}
			},
			'sharingwindow button[id="updateSharing"]': {
                "click": this.updateSharing
            }
			/*'configwindow radiogroup[id="Aggregate"]': {
				"change": this.radioAggregateChangeFunction
			},*/
		});
	},
	renderMain:function(main,eOpts){
		Ext.getCmp('main').setLoading(true,true);
		Ext.Ajax.request({
			//url : '/final/monitor/servicesBusinessDashboard.jsp?monCmd=serviceList&from=MainDashboard&action=service&isServiceBusiDash=true',
			url:refreshURLValue,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				if (!Ext.isEmpty( jsonText))
				{
					var jsonData = Ext.decode(jsonText);

					delete jsonText;
					Ext.destroy(jsonText);
					jsonText = null;
					this.showResult(jsonData);

					delete jsonData;
					Ext.destroy(jsonData);
					jsonData = null;
				}

				Ext.getCmp('main').setLoading(false);
				if($j('#main-innerCt').height() > $j('#main-body').height()){			//autoscroll hide/show functionality
					Ext.getCmp('iconAutomaticScrollRun').hide();
					Ext.getCmp('removeLineForTvMode').hide();
					Ext.getCmp('iconAutomaticScrollJumpToTop').hide();
				}else{
					Ext.getCmp('iconAutomaticScrollRun').hide();
					Ext.getCmp('removeLineForTvMode').hide();
					Ext.getCmp('iconAutomaticScrollJumpToTop').hide();
				}
			},
			failure : function(){
				if (!Ext.isEmpty(this))
					this.showResult(null);
				else
					window.location.href="/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isServiceBusiDash=true&isFromMenu=true";
			}
		});
		refreshEnable=true;
	},
	showResult: function( resultData )
	{
		
		var resultObj = this.getMain();
		var resultMainObj = this.getMainConId();

		//resultObj.show();
		//resultObj.removeAll();
		if ( !Ext.isEmpty( resultData ))
		{
			resultObj.show();

			/*var resultItems=resultObj.items.items;
			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				//resultObj.remove(resultItems[item]);
				resultItems[item].destroy()
			}*/

			resultObj.removeAll();

			if ( !Ext.isEmpty( resultData.errMsg ))
			{
				if ( !Ext.isEmpty( resultMainObj))
				{
					resultMainObj.setVisible(false);
				}

				var temp='<div style="margin:15% 0 auto 0;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+resultData.errMsg+'</div></div>';
				var newPanel = {
					xtype:'container',
					layout: 'fit',
					style:{'border':'0px solid blue'},
					height:'100%',
					width:'100%',
					html: temp
				};
				resultObj.suspendEvents(true);
				resultObj.add(newPanel);
				resultObj.resumeEvents();
				//resultObj.doLayout();
			}
			else if ( !Ext.isEmpty( resultData.servicesBusinessData ))
			{
				var servicesItemsArray=resultData.servicesBusinessData;
				if(!Ext.isEmpty(servicesItemsArray))
				{
					globalServicesItemsArray = servicesItemsArray;
					servicesLength = globalServicesItemsArray.length;

					if(servicesLength > splitLen)
					{
						var newPanel= {
							id:'mainConId',
							name:'mainConId',
							//style:{'border':'0px solid red'},
							xtype:'container',
							padding:0,
							layout:'column',
							width:'100%',
							items:[
								{
									xtype:'component',
									cls:'servicesHeader',
									html:titleFirst,
									width:140,
								},
								{
									xtype:'component',
									cls:'demandHeader',
									html:titleDemand,
									columnWidth:.27
								},
								{
									xtype:'component',
									cls:'consumptionHeader',
									html:titleConsumption,
									columnWidth:.28
								},
								{
									xtype:'component',
									cls:'qualityHeader',
									html:titleQuality,
									columnWidth:.25
								},
								{
									xtype:'component',
									cls:'healthHeader',
									html:titleHealth,
									columnWidth:.2
								}
							]
						};
						resultObj.suspendEvents(true);
						resultObj.add(newPanel);
						resultObj.resumeEvents(true);

						mainStyleFlg=false;
						var bodyPanelID=Ext.getCmp('bodyPanel');
						var chartCount = 0;
						//for(var item=0; item< servicesItemsArray.length ; item++)
						for(var item=0; item< splitLen ; item++)
						{
							var me=this;
							var serviceitemJson=servicesItemsArray[item];
							//var dataRowObj = this.getDataConId();
							//alert(dataRowObj);
							var sty='';
							var styColor='';
							if(mainStyleFlg)
							{
								sty='ServiceDashRow';
								styColor=(strSkin == "Light")?"#fafafa":"#393939";
								mainStyleFlg=false;
							}
							else
							{
								sty='';
								styColor=(strSkin == "Light")?"#ffffff":"#444444";
								mainStyleFlg=true;
							}

							var newPanel = {
								id:'dataConId'+item,
								name:'dataConId'+item,
								xtype:'panel',
								//style:{'border':'5px solid blue'},
								//baseCls:sty,
								bodyStyle:{'background':styColor},
								layout:'column',
								width:'100%',
								height:145,
								items:[
									{
										xtype:'panel',
										cls:'columnServices',
										bodyStyle:{'background':'none'},
										html:'<div style="width:140px;word-wrap: break-word; overflow-x:auto;text-wrap:suppress">'+this.getServicesOrTiers(serviceitemJson)+'</div>',
										width:140,
										align:'center',
										padding:'0 0 0 0',
										height:145
									},
									{
										//id:'dComId'+item,
										xtype:'scrollpanel',
										//xtype:'container',
										cls:'columnDemand',
										bodyStyle:{'background':'none'},
										//style:{'border':'1px solid red'},
										html:this.getDemandAndQuality(serviceitemJson,'Demand'),
										columnWidth:.27,
										scroll:true,
										autoScroll:true,
										padding:0,
										height:145,
										sij:serviceitemJson,
										parId:'dataConId'+item,

										listeners:{
											 'afterrender': function(thisObj){
												var serviceDemandDataArr=thisObj.sij.serviceDemandData;
												if(!Ext.isEmpty(serviceDemandDataArr))
												{
													for(var sditem=0; sditem< serviceDemandDataArr.length ; sditem++)
													{
														var serviceDemandOrQualityItemJson=serviceDemandDataArr[sditem];

														if(!Ext.isEmpty( serviceDemandOrQualityItemJson.minMaxTable ))
														{
															var minMaxTableObj=serviceDemandOrQualityItemJson.minMaxTable;
															if(!Ext.isEmpty( minMaxTableObj.ChartName ))
															{
																if( !Ext.isEmpty( minMaxTableObj.chartOption) && minMaxTableObj.chartOption.indexOf("highchart") > -1)
																{
																	chartCount = chartCount+1;

																	var bothUrl='../servlet/com.egurkha.monitor.DashboardTimelineMeasures?'+minMaxTableObj.ChartURL;

																	var chart_width=240;
																	var chart_height=120;
																	try
																	{
																		if(Ext.isChrome)
																		{
																			chart_width=Ext.getCmp(thisObj.parId).getWidth()/4;
																		}
																		else
																		{
																			chart_width=jQuery('#'+minMaxTableObj.ChartId).width();
																		}
																		//chart_width=jQuery('#'+minMaxTableObj.ChartId).width()+20;
																		chart_height=jQuery('#'+minMaxTableObj.ChartId).height();
																		if(Ext.isChrome)
																		{
																			chart_width = chart_width-50;
																		}
																		else
																		{
																			chart_width = chart_width;
																		}
																	}
																	catch (e)
																	{
																		if(Ext.isChrome)
																		{
																			chart_width=240;
																		}
																		else
																		{
																			chart_width=210;
																		}
																		chart_height=120;
																	}

																	if(chart_width==null || chart_width=="")
																	{
																		if(Ext.isChrome)
																		{
																			chart_width=240;
																		}
																		else
																		{
																			chart_width=210;
																		}
																	}

																	if(chart_height==null || chart_height=="")
																		chart_height=120;

																	//bigHighChart(bothUrl,thisObj.id,140,chart_width-30,bothUrl,false,"bottom");

																	bigHighChart(bothUrl,minMaxTableObj.ChartId,chart_height,chart_width,bothUrl,false,"bottom");
																}
															}
														}
													}
												}
											}
										}
									},
									{
										xtype:'component',
										cls:'columnDemand',
										padding:0,
										html:this.getConsumption(serviceitemJson),
										columnWidth:.28,
										height:145,
										scroll:true,
										autoScroll:true,
										sij:serviceitemJson,
										listeners: {
											'afterrender': function(thisObj){
												var serviceConsumptionDataArr=thisObj.sij.serviceConsumptionData;
												if(!Ext.isEmpty(serviceConsumptionDataArr))
												{
													for(var item=0; item< serviceConsumptionDataArr.length ; item++)
													{
														var serviceConsumptionDataJson=serviceConsumptionDataArr[item];
														if ( !Ext.isEmpty( serviceConsumptionDataJson.consumptionInnerDataArr ))
														{
															var consumptionInnerDataArr=serviceConsumptionDataJson.consumptionInnerDataArr;
															if(!Ext.isEmpty(consumptionInnerDataArr))
															{
																for(var citem=0; citem< consumptionInnerDataArr.length ; citem++)
																{
																	var consumptionInnerData=consumptionInnerDataArr[citem];
																	if(!Ext.isEmpty(consumptionInnerData.divId))
																	{
																		if(!Ext.isEmpty(consumptionInnerData.highChartData))
																		{
																			var jsonPieData=null;
																			jsonPieData=consumptionInnerData.highChartData;
																			jsonPieData['customMsg'] = 'yes';
																			jsonPieData['formatTip'] = 'yes';
																			jsonPieData['rumPie'] = 'yes';
																			jsonPieData['isShowToolTip'] = false;
																			jsonPieData['dataLabels'] = false;
																			var pieChart = {};
																			pieChart = jQuery.extend(true, {}, createPie(consumptionInnerData.divId,85,90), pieChart);
																			pieChart.setData(jsonPieData,'','','donut');
																			pieChart.drawChart();
																			pieChart.highchart.tooltip.enabled = false;
																		}
																		/*else
																		{
																		if  ( FusionCharts( consumptionInnerData.fcId ) )
																				FusionCharts( consumptionInnerData.fcId ).dispose();
																		var myChart = new FusionCharts( consumptionInnerData.movie,consumptionInnerData.fcId, consumptionInnerData.graphWidth, consumptionInnerData.graphHeight,"0","1");
																		myChart.setXMLData(consumptionInnerData.dataXML);
																		myChart.setTransparent(true);
																		myChart.render(consumptionInnerData.divId);
																		}*/
																	}
																}
															}
														}
													}
												}
											}
										}
									},
									{
										//id:'qComId'+item,
										xtype:'panel',
										cls:'columnDemand',
										bodyStyle:{'background':'none'},
										padding:0,
										html:this.getDemandAndQuality(serviceitemJson,'Quality'),
										columnWidth:.25,
										height:145,
										scroll:true,
										autoScroll:true,
										sij:serviceitemJson,
										parId:'dataConId'+item,
										listeners:{
											 'afterrender': function(thisObj){
												var serviceDemandDataArr=thisObj.sij.serviceQualityData;
												if(!Ext.isEmpty(serviceDemandDataArr))
												{
													for(var sditem=0; sditem< serviceDemandDataArr.length ; sditem++)
													{
														var serviceDemandOrQualityItemJson=serviceDemandDataArr[sditem];

														if(!Ext.isEmpty( serviceDemandOrQualityItemJson.minMaxTable ))
														{
															var minMaxTableObj=serviceDemandOrQualityItemJson.minMaxTable;
															if(!Ext.isEmpty( minMaxTableObj.ChartName ))
															{
																if( !Ext.isEmpty( minMaxTableObj.chartOption) && minMaxTableObj.chartOption.indexOf("highchart") > -1)
																{
																	chartCount = chartCount+1;
																	var bothUrl='../servlet/com.egurkha.monitor.DashboardTimelineMeasures?'+minMaxTableObj.ChartURL;

																	var chart_width=240;
																	var chart_height=120;
																	try
																	{
																		if(Ext.isChrome)
																		{
																			chart_width=Ext.getCmp(thisObj.parId).getWidth()/4;
																		}
																		else
																		{
																			chart_width=jQuery('#'+minMaxTableObj.ChartId).width();
																		}
																		//chart_width=jQuery('#'+minMaxTableObj.ChartId).width()+20;
																		chart_height=jQuery('#'+minMaxTableObj.ChartId).height();
																		if(Ext.isChrome)
																		{
																			chart_width = chart_width-50;
																		}
																		else
																		{
																			chart_width = chart_width+30;
																		}
																	}
																	catch (e)
																	{
																		if(Ext.isChrome)
																		{
																			chart_width=240;
																		}
																		else
																		{
																			chart_width=210;
																		}
																		chart_height=120;
																	}

																	if(chart_width==null || chart_width=="")
																	{
																		if(Ext.isChrome)
																		{
																			chart_width=240;
																		}
																		else
																		{
																			chart_width=210;
																		}
																	}

																	if(chart_height==null || chart_height=="")
																		chart_height=120;

																	//bigHighChart(bothUrl,thisObj.id,140,chart_width-35,bothUrl,false,"bottom");

																	bigHighChart(bothUrl,minMaxTableObj.ChartId,chart_height,chart_width,bothUrl,false,"bottom");
																}
															}
														}
													}
												}
											}
										}
									},
									{
										xtype:'scrollpanel',
										bodyStyle:{'background':'none'},
										cls:'columnDemand',
										padding:0,
										scroll:true,
										autoScroll:true,
										html:this.getHealth(serviceitemJson),
										columnWidth:.2,
										height:145
									}
								]
							};

							/*var bodyPanel={
									xtype:'scrollpanel',
									autoScroll:true,
									layout:'vbox',
									flex:1.0,
									style:{'border':'1px solid red'},
									scroll:false,
									//items:[newPanel]
							};*/

							//bodyPanelID.add(newPanel);
							resultObj.suspendEvents(true);
							resultObj.add(newPanel);
							resultObj.resumeEvents();
							//resultObj.add(bodyPanel);
						}

						isScroll = true;
					}
					else
					{
						var newPanel= {
							id:'mainConId',
							name:'mainConId',
							//style:{'border':'0px solid red'},
							xtype:'container',
							padding:0,
							layout:'column',
							width:'100%',
							items:[
								{
									xtype:'component',
									cls:'servicesHeader',
									html:titleFirst,
									width:140,
								},
								{
									xtype:'component',
									cls:'demandHeader',
									html:titleDemand,
									columnWidth:.27
								},
								{
									xtype:'component',
									cls:'consumptionHeader',
									html:titleConsumption,
									columnWidth:.28
								},
								{
									xtype:'component',
									cls:'qualityHeader',
									html:titleQuality,
									columnWidth:.25
								},
								{
									xtype:'component',
									cls:'healthHeader',
									html:titleHealth,
									columnWidth:.2
								}
							]
						};
						resultObj.suspendEvents(true);
						resultObj.add(newPanel);
						resultObj.resumeEvents(true);
						var flg=false;
						var bodyPanelID=Ext.getCmp('bodyPanel');
						var chartCount = 0;
						for(var item=0; item< servicesItemsArray.length ; item++)
						{
							var me=this;
							var serviceitemJson=servicesItemsArray[item];
							//var dataRowObj = this.getDataConId();
							//alert(dataRowObj);
							var sty='';
							var styColor='';
							if(flg)
							{
								sty='ServiceDashRow';
								styColor=(strSkin == "Light")?"#fafafa":"#393939";
								flg=false;
							}
							else
							{
								sty='';
								styColor=(strSkin == "Light")?"#ffffff":"#444444";
								flg=true;
							}

							
							var newPanel = {
								id:'dataConId'+item,
								name:'dataConId'+item,
								xtype:'panel',
								//style:{'border':'5px solid blue'},
								//baseCls:sty,
								bodyStyle:{'background':styColor},
								layout:'column',
								width:'100%',
								height:145,
								items:[
									{
										xtype:'panel',
										cls:'columnServices',
										bodyStyle:{'background':'none'},
										html:'<div style="width:140px;word-wrap: break-word; overflow-x:auto;text-wrap:suppress">'+this.getServicesOrTiers(serviceitemJson)+'</div>',
										width:140,
										align:'center',
										padding:'0 0 0 0',
										height:145
									},
									{
										//id:'dComId'+item,
										xtype:'scrollpanel',
										//xtype:'container',
										cls:'columnDemand',
										bodyStyle:{'background':'none'},
										//style:{'border':'1px solid red'},
										html:this.getDemandAndQuality(serviceitemJson,'Demand'),
										columnWidth:.27,
										scroll:true,
										autoScroll:true,
										padding:0,
										height:145,
										sij:serviceitemJson,
										parId:'dataConId'+item,

										listeners:{
											 'afterrender': function(thisObj){
												var serviceDemandDataArr=thisObj.sij.serviceDemandData;
												if(!Ext.isEmpty(serviceDemandDataArr))
												{
													for(var sditem=0; sditem< serviceDemandDataArr.length ; sditem++)
													{
														var serviceDemandOrQualityItemJson=serviceDemandDataArr[sditem];

														if(!Ext.isEmpty( serviceDemandOrQualityItemJson.minMaxTable ))
														{
															var minMaxTableObj=serviceDemandOrQualityItemJson.minMaxTable;
															if(!Ext.isEmpty( minMaxTableObj.ChartName ))
															{
																if( !Ext.isEmpty( minMaxTableObj.chartOption) && minMaxTableObj.chartOption.indexOf("highchart") > -1)
																{
																	chartCount = chartCount+1;

																	var bothUrl='../servlet/com.egurkha.monitor.DashboardTimelineMeasures?'+minMaxTableObj.ChartURL;

																	var chart_width=240;
																	var chart_height=120;
																	try
																	{
																		if(Ext.isChrome)
																		{
																			chart_width=Ext.getCmp(thisObj.parId).getWidth()/4;
																		}
																		else
																		{
																			chart_width=jQuery('#'+minMaxTableObj.ChartId).width();
																		}
																		//chart_width=jQuery('#'+minMaxTableObj.ChartId).width()+20;
																		chart_height=jQuery('#'+minMaxTableObj.ChartId).height();
																		if(Ext.isChrome)
																		{
																			chart_width = chart_width-50;
																		}
																		else
																		{
																			chart_width = chart_width;
																		}
																	}
																	catch (e)
																	{
																		if(Ext.isChrome)
																		{
																			chart_width=240;
																		}
																		else
																		{
																			chart_width=210;
																		}
																		chart_height=120;
																	}

																	if(chart_width==null || chart_width=="")
																	{
																		if(Ext.isChrome)
																		{
																			chart_width=240;
																		}
																		else
																		{
																			chart_width=210;
																		}
																	}

																	if(chart_height==null || chart_height=="")
																		chart_height=120;

																	//bigHighChart(bothUrl,thisObj.id,140,chart_width-30,bothUrl,false,"bottom");

																	bigHighChart(bothUrl,minMaxTableObj.ChartId,chart_height,chart_width,bothUrl,false,"bottom");
																}
															}
														}
													}
												}
											}
										}
									},
									{
										xtype:'component',
										cls:'columnDemand',
										padding:0,
										html:this.getConsumption(serviceitemJson),
										columnWidth:.28,
										scroll:true,
										autoScroll:true,
										height:145,
										sij:serviceitemJson,
										listeners: {
											'afterrender': function(thisObj){
												var serviceConsumptionDataArr=thisObj.sij.serviceConsumptionData;
												if(!Ext.isEmpty(serviceConsumptionDataArr))
												{
													for(var item=0; item< serviceConsumptionDataArr.length ; item++)
													{
														var serviceConsumptionDataJson=serviceConsumptionDataArr[item];
														if ( !Ext.isEmpty( serviceConsumptionDataJson.consumptionInnerDataArr ))
														{
															var consumptionInnerDataArr=serviceConsumptionDataJson.consumptionInnerDataArr;
															if(!Ext.isEmpty(consumptionInnerDataArr))
															{
																for(var citem=0; citem< consumptionInnerDataArr.length ; citem++)
																{
																	var consumptionInnerData=consumptionInnerDataArr[citem];
																	if(!Ext.isEmpty(consumptionInnerData.divId))
																	{
																		if(!Ext.isEmpty(consumptionInnerData.highChartData))
																		{
																			var jsonPieData=null;
																			jsonPieData=consumptionInnerData.highChartData;
																			jsonPieData['customMsg'] = 'yes';
																			jsonPieData['formatTip'] = 'yes';
																			jsonPieData['rumPie'] = 'yes';
																			jsonPieData['isShowToolTip'] = false;
																			jsonPieData['dataLabels'] = false;
																			var pieChart = {};
																			pieChart = jQuery.extend(true, {}, createPie(consumptionInnerData.divId,85,90), pieChart);
																			pieChart.setData(jsonPieData,'','','donut');
																			pieChart.drawChart();
																			pieChart.highchart.tooltip.enabled = false;
																		}
																		/*else
																		{
																		if  ( FusionCharts( consumptionInnerData.fcId ) )
																				FusionCharts( consumptionInnerData.fcId ).dispose();
																		var myChart = new FusionCharts( consumptionInnerData.movie,consumptionInnerData.fcId, consumptionInnerData.graphWidth, consumptionInnerData.graphHeight,"0","1");
																		myChart.setXMLData(consumptionInnerData.dataXML);
																		myChart.setTransparent(true);
																		myChart.render(consumptionInnerData.divId);
																		}*/
																	}
																}
															}
														}
													}
												}
											}
										}
									},
									{
										//id:'qComId'+item,
										xtype:'panel',
										cls:'columnDemand',
										bodyStyle:{'background':'none'},
										padding:0,
										html:this.getDemandAndQuality(serviceitemJson,'Quality'),
										columnWidth:.25,
										height:145,
										scroll:true,
										autoScroll:true,
										sij:serviceitemJson,
										parId:'dataConId'+item,
										listeners:{
											 'afterrender': function(thisObj){
												var serviceDemandDataArr=thisObj.sij.serviceQualityData;
												if(!Ext.isEmpty(serviceDemandDataArr))
												{
													for(var sditem=0; sditem< serviceDemandDataArr.length ; sditem++)
													{
														var serviceDemandOrQualityItemJson=serviceDemandDataArr[sditem];

														if(!Ext.isEmpty( serviceDemandOrQualityItemJson.minMaxTable ))
														{
															var minMaxTableObj=serviceDemandOrQualityItemJson.minMaxTable;
															if(!Ext.isEmpty( minMaxTableObj.ChartName ))
															{
																if( !Ext.isEmpty( minMaxTableObj.chartOption) && minMaxTableObj.chartOption.indexOf("highchart") > -1)
																{
																	chartCount = chartCount+1;
																	var bothUrl='../servlet/com.egurkha.monitor.DashboardTimelineMeasures?'+minMaxTableObj.ChartURL;

																	var chart_width=240;
																	var chart_height=120;
																	try
																	{
																		if(Ext.isChrome)
																		{
																			chart_width=Ext.getCmp(thisObj.parId).getWidth()/4;
																		}
																		else
																		{
																			chart_width=jQuery('#'+minMaxTableObj.ChartId).width();
																		}
																		//chart_width=jQuery('#'+minMaxTableObj.ChartId).width()+20;
																		chart_height=jQuery('#'+minMaxTableObj.ChartId).height();
																		if(Ext.isChrome)
																		{
																			chart_width = chart_width-50;
																		}
																		else
																		{
																			chart_width = chart_width+30;
																		}
																	}
																	catch (e)
																	{
																		if(Ext.isChrome)
																		{
																			chart_width=240;
																		}
																		else
																		{
																			chart_width=210;
																		}
																		chart_height=120;
																	}

																	if(chart_width==null || chart_width=="")
																	{
																		if(Ext.isChrome)
																		{
																			chart_width=240;
																		}
																		else
																		{
																			chart_width=210;
																		}
																	}

																	if(chart_height==null || chart_height=="")
																		chart_height=120;

																	//bigHighChart(bothUrl,thisObj.id,140,chart_width-35,bothUrl,false,"bottom");

																	bigHighChart(bothUrl,minMaxTableObj.ChartId,chart_height,chart_width,bothUrl,false,"bottom");
																}
															}
														}
													}
												}
											}
										}
									},
									{
										xtype:'scrollpanel',
										bodyStyle:{'background':'none'},
										cls:'columnDemand',
										padding:0,
										scroll:true,
										autoScroll:true,
										html:this.getHealth(serviceitemJson),
										columnWidth:.2,
										height:145
									}
								]
							};

							/*var bodyPanel={
									xtype:'scrollpanel',
									autoScroll:true,
									layout:'vbox',
									flex:1.0,
									style:{'border':'1px solid red'},
									scroll:false,
									//items:[newPanel]
							};*/

							//bodyPanelID.add(newPanel);
							resultObj.suspendEvents(true);
							resultObj.add(newPanel);
							resultObj.resumeEvents();
							//resultObj.add(bodyPanel);
						}
					}
					if( chartCount == 0 )
					{
						if(!Ext.isEmpty(Ext.ComponentQuery.query('#showLegend')[0]))
						{
							Ext.ComponentQuery.query('#showLegend')[0].hide();
							Ext.ComponentQuery.query('#showLegend')[0].setValue(isChecked);
						}
					}
					else
					{
						if(!Ext.isEmpty(Ext.ComponentQuery.query('#showLegend')[0]))
						{
							var showLegend = resultData.showLegend;
							var isChecked = (showLegend == 'false' || showLegend == 'no' )?0:1;
							Ext.ComponentQuery.query('#showLegend')[0].show();
							Ext.ComponentQuery.query('#showLegend')[0].setValue(isChecked);
						}
					}
				}
			}
			else
			{
				if(!Ext.isEmpty(resultObj) && !Ext.isEmpty(resultMainObj))
				{
					try
					{
						resultMainObj.setVisible(false);
						var temp='<div style="margin:auto;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+noFound+'</div></div>';
						var newPanel = {
							xtype:'container',
							layout: 'fit',
							height:'100%',
							width:'100%',
							html: temp
						};
						resultObj.suspendEvents(true);
						resultObj.add(newPanel);
						resultObj.resumeEvents();
						//resultObj.doLayout();
					}
					catch (e)
					{
						window.location.href="/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isServiceBusiDash=true&isFromMenu=true";
					}
				}
				else
					window.location.href="/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isServiceBusiDash=true&isFromMenu=true";
			}
		}
		else
		{
			if(!Ext.isEmpty(resultObj) && !Ext.isEmpty(resultMainObj))
			{
				try
				{
					resultMainObj.setVisible(false);
					var temp='<div style="margin:auto;text-align:center;border:0px solid red"><div class="iconInformation" style="margin:auto;text-align:center"></div><div style="text-align:center" >'+noFound+'</div></div>';
					var newPanel = {
						xtype:'container',
						layout: 'fit',
						height:'100%',
						padding:0,
						width:'100%',
						html: temp
					};
						resultObj.suspendEvents(true);
					resultObj.add(newPanel);
					resultObj.resumeEvents();
				}
				catch (e)
				{
					window.location.href="/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isServiceBusiDash=true&isFromMenu=true";
				}

				//resultObj.doLayout();
			}
			else
				window.location.href="/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isServiceBusiDash=true&isFromMenu=true";
		}
		//resultObj.doLayout();
		
	},
	bulkDataLoad: function( startcnt,endcnt )
	{
		var resultObj = this.getMain();

		isScroll = false;

		var servicesItemsArray=globalServicesItemsArray;
		if(!Ext.isEmpty(servicesItemsArray))
		{
			var chartCount = 0;
			//console.log("---bulkDataLoad start time --->",new Date());
			Ext.suspendLayouts();
			//for(var item=0; item< servicesItemsArray.length ; item++)
			for(var item=startcnt;item<endcnt;item++)
			{
				var serviceitemJson=servicesItemsArray[item];

				var sty='';
				var styColor='';
				if(mainStyleFlg)
				{
					sty='ServiceDashRow';
					styColor=(strSkin == "Light")?"#fafafa":"#393939";
					mainStyleFlg=false;
				}
				else
				{
					sty='';
					styColor=(strSkin == "Light")?"#ffffff":"#444444";
					mainStyleFlg=true;
				}


				var newPanel = {
					id:'dataConId'+item,
					name:'dataConId'+item,
					xtype:'panel',
					//style:{'border':'5px solid blue'},
					//baseCls:sty,
					bodyStyle:{'background':styColor},
					layout:'column',
					width:'100%',
					height:145,
					items:[
						{
							xtype:'panel',
							cls:'columnServices',
							bodyStyle:{'background':'none'},
							html:'<div style="width:140px;word-wrap: break-word; overflow-x:auto;text-wrap:suppress">'+this.getServicesOrTiers(serviceitemJson)+'</div>',
							width:140,
							align:'center',
							padding:'0 0 0 0',
							height:145
						},
						{
							//id:'dComId'+item,
							xtype:'scrollpanel',
							//xtype:'container',
							cls:'columnDemand',
							bodyStyle:{'background':'none'},
							//style:{'border':'1px solid red'},
							html:this.getDemandAndQuality(serviceitemJson,'Demand'),
							columnWidth:.27,
							scroll:true,
							autoScroll:true,
							padding:0,
							height:145,
							sij:serviceitemJson,
							parId:'dataConId'+item,

							listeners:{
								 'afterrender': function(thisObj){
									var serviceDemandDataArr=thisObj.sij.serviceDemandData;
									if(!Ext.isEmpty(serviceDemandDataArr))
									{
										for(var sditem=0; sditem< serviceDemandDataArr.length ; sditem++)
										{
											var serviceDemandOrQualityItemJson=serviceDemandDataArr[sditem];

											if(!Ext.isEmpty( serviceDemandOrQualityItemJson.minMaxTable ))
											{
												var minMaxTableObj=serviceDemandOrQualityItemJson.minMaxTable;
												if(!Ext.isEmpty( minMaxTableObj.ChartName ))
												{
													if( !Ext.isEmpty( minMaxTableObj.chartOption) && minMaxTableObj.chartOption.indexOf("highchart") > -1)
													{
														chartCount = chartCount+1;

														var bothUrl='../servlet/com.egurkha.monitor.DashboardTimelineMeasures?'+minMaxTableObj.ChartURL;

														var chart_width=240;
														var chart_height=120;
														try
														{
															if(Ext.isChrome)
															{
															chart_width=Ext.getCmp(thisObj.parId).getWidth()/4;
															}
															else
															{
																chart_width=jQuery('#'+minMaxTableObj.ChartId).width();
															}
															//chart_width=jQuery('#'+minMaxTableObj.ChartId).width()+20;
															chart_height=jQuery('#'+minMaxTableObj.ChartId).height();
															if(Ext.isChrome)
															{
															chart_width = chart_width-50;
															}
															else
															{
																chart_width = chart_width;
															}
														}
														catch (e)
														{
															if(Ext.isChrome)
															{
																chart_width=240;
															}
															else
															{
																chart_width=210;
															}
															chart_height=120;
														}

														if(chart_width==null || chart_width=="")
														{
															if(Ext.isChrome)
															{
																chart_width=240;
															}
															else
															{
																chart_width=210;
															}
														}

														if(chart_height==null || chart_height=="")
															chart_height=120;

														//bigHighChart(bothUrl,thisObj.id,140,chart_width-30,bothUrl,false,"bottom");

														bigHighChart(bothUrl,minMaxTableObj.ChartId,chart_height,chart_width,bothUrl,false,"bottom");
													}
												}
											}
										}
									}
								}
							}
						},
						{
							xtype:'component',
							cls:'columnDemand',
							padding:0,
							html:this.getConsumption(serviceitemJson),
							scroll:true,
							autoScroll:true,
							columnWidth:.28,
							height:145,
							sij:serviceitemJson,
							listeners: {
								'afterrender': function(thisObj){
									var serviceConsumptionDataArr=thisObj.sij.serviceConsumptionData;
									if(!Ext.isEmpty(serviceConsumptionDataArr))
									{
										for(var item=0; item< serviceConsumptionDataArr.length ; item++)
										{
											var serviceConsumptionDataJson=serviceConsumptionDataArr[item];
											if ( !Ext.isEmpty( serviceConsumptionDataJson.consumptionInnerDataArr ))
											{
												var consumptionInnerDataArr=serviceConsumptionDataJson.consumptionInnerDataArr;
												if(!Ext.isEmpty(consumptionInnerDataArr))
												{
													for(var citem=0; citem< consumptionInnerDataArr.length ; citem++)
													{
														var consumptionInnerData=consumptionInnerDataArr[citem];
														if(!Ext.isEmpty(consumptionInnerData.divId))
														{
															if  ( FusionCharts( consumptionInnerData.fcId ) )
																	FusionCharts( consumptionInnerData.fcId ).dispose();
															var myChart = new FusionCharts( consumptionInnerData.movie,consumptionInnerData.fcId, consumptionInnerData.graphWidth, consumptionInnerData.graphHeight,"0","1");
															myChart.setXMLData(consumptionInnerData.dataXML);
															myChart.setTransparent(true);
															myChart.render(consumptionInnerData.divId);
														}
													}
												}
											}
										}
									}
								}
							}
						},
						{
							//id:'qComId'+item,
							xtype:'panel',
							cls:'columnDemand',
							bodyStyle:{'background':'none'},
							padding:0,
							html:this.getDemandAndQuality(serviceitemJson,'Quality'),
							columnWidth:.25,
							height:145,
							scroll:true,
							autoScroll:true,
							sij:serviceitemJson,
							parId:'dataConId'+item,
							listeners:{
								 'afterrender': function(thisObj){
									var serviceDemandDataArr=thisObj.sij.serviceQualityData;
									if(!Ext.isEmpty(serviceDemandDataArr))
									{
										for(var sditem=0; sditem< serviceDemandDataArr.length ; sditem++)
										{
											var serviceDemandOrQualityItemJson=serviceDemandDataArr[sditem];

											if(!Ext.isEmpty( serviceDemandOrQualityItemJson.minMaxTable ))
											{
												var minMaxTableObj=serviceDemandOrQualityItemJson.minMaxTable;
												if(!Ext.isEmpty( minMaxTableObj.ChartName ))
												{
													if( !Ext.isEmpty( minMaxTableObj.chartOption) && minMaxTableObj.chartOption.indexOf("highchart") > -1)
													{
														chartCount = chartCount+1;
														var bothUrl='../servlet/com.egurkha.monitor.DashboardTimelineMeasures?'+minMaxTableObj.ChartURL;

														var chart_width=240;
														var chart_height=120;
														try
														{
															if(Ext.isChrome)
															{
																chart_width=Ext.getCmp(thisObj.parId).getWidth()/4;
															}
															else
															{
																chart_width=jQuery('#'+minMaxTableObj.ChartId).width();
															}
															//chart_width=jQuery('#'+minMaxTableObj.ChartId).width()+20;
															chart_height=jQuery('#'+minMaxTableObj.ChartId).height();
															if(Ext.isChrome)
															{
																chart_width = chart_width-50;
															}
															else
															{
																chart_width = chart_width+30;
															}
														}
														catch (e)
														{
															if(Ext.isChrome)
															{
																chart_width=240;
															}
															else
															{
																chart_width=210;
															}
															chart_height=120;
														}

														if(chart_width==null || chart_width=="")
														{
															if(Ext.isChrome)
															{
																chart_width=240;
															}
															else
															{
																chart_width=210;
															}
														}

														if(chart_height==null || chart_height=="")
															chart_height=120;

														//bigHighChart(bothUrl,thisObj.id,140,chart_width-35,bothUrl,false,"bottom");

														bigHighChart(bothUrl,minMaxTableObj.ChartId,chart_height,chart_width,bothUrl,false,"bottom");
													}
												}
											}
										}
									}
								}
							}
						},
						{
							xtype:'scrollpanel',
							bodyStyle:{'background':'none'},
							cls:'columnDemand',
							padding:0,
							scroll:true,
							autoScroll:true,
							html:this.getHealth(serviceitemJson),
							columnWidth:.2,
							height:145
						}
					]
				};

				/*var bodyPanel={
						xtype:'scrollpanel',
						autoScroll:true,
						layout:'vbox',
						flex:1.0,
						style:{'border':'1px solid red'},
						scroll:false,
						//items:[newPanel]
				};*/

				//bodyPanelID.add(newPanel);
				resultObj.suspendEvents(true);
				resultObj.add(newPanel);
				resultObj.resumeEvents();
				//resultObj.add(bodyPanel);
			}
			//console.log("---bulkDataLoad end time--->",new Date());
			if( chartCount == 0 )
			{
				if(!Ext.isEmpty(Ext.ComponentQuery.query('#showLegend')[0]))
				{
					Ext.ComponentQuery.query('#showLegend')[0].hide();
					Ext.ComponentQuery.query('#showLegend')[0].setValue(isChecked);
				}
			}
			else
			{
				if(!Ext.isEmpty(Ext.ComponentQuery.query('#showLegend')[0]))
				{
					var showLegend = resultData.showLegend;
					var isChecked = (showLegend == 'false' || showLegend == 'no' )?0:1;
					Ext.ComponentQuery.query('#showLegend')[0].show();
					Ext.ComponentQuery.query('#showLegend')[0].setValue(isChecked);
				}
			}
			Ext.resumeLayouts(true);

			if(endcnt != servicesLength && endcnt < servicesLength)
			{
				isScroll = true;
				startcount = endcnt;
			}
			else 
			{
				globalServicesItemsArray = null;
				delete globalServicesItemsArray;
				servicesLength = null;
				startcount = null;
				mainStyleFlg=false;
			}
		}
	},
	getServicesOrTiers:function(serviceitemJson)
	{
		var tempHtml="";
		if(!Ext.isEmpty(serviceitemJson.service_name))
		{
			//tempHtml='<div style="float:left;height:162px;" >';
				var service_url = serviceitemJson.service_url;
					if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
						service_url = service_url + "&com.eg.CSRF_NONCE="+csrfToken;
				tempHtml=tempHtml+'<table style="margin-top:30px" width="90%" align="center" border="0" borderColor="red" cellpadding="0" cellspacing="0">';
				tempHtml=tempHtml+'<tr>';
					tempHtml=tempHtml+'<td  align="center" >';
						tempHtml=tempHtml+'<a  href="'+service_url+'">';
					if(!Ext.isEmpty(serviceitemJson.showImage))
					{
						//tempHtml=tempHtml+'<div class="'+serviceitemJson.service_image+'" style="border:0px solid red;display:inline-block"><div  class="state_'+serviceitemJson.service_state+'" style="position:relative;top:46px;left:20px;border:0px solid red"></div></div>';
						tempHtml=tempHtml+'<div class="'+serviceitemJson.service_image+'" style="border:0px solid red;display:inline-block"><div  class="state20_'+serviceitemJson.service_state+'" style="position:relative;top:38px;left:15px;border:0px solid red"></div></div>';
					}
						tempHtml=tempHtml+'</a>';
					tempHtml=tempHtml+'</td>';
				tempHtml=tempHtml+'</tr>';
				tempHtml=tempHtml+'<tr>';
					tempHtml=tempHtml+'<td width="100%" valign="top" align="center">';
					//serviceitemJson.service_dash_url
						tempHtml=tempHtml+'<div class="business_dashTitlefont"><a href="'+service_url+'" title="'+serviceitemJson.service_disp_name+'">';
						//tempHtml=tempHtml+serviceitemJson.service_disp_name+serviceitemJson.service_disp_site;
						tempHtml=tempHtml+serviceitemJson.service_disp_name;
						tempHtml=tempHtml+'</a></div>';
					tempHtml=tempHtml+'</td>';
				tempHtml=tempHtml+'</tr>';
				tempHtml=tempHtml+'</table>';
			//tempHtml=tempHtml+'</div>';
		}
		else if(!Ext.isEmpty(serviceitemJson.server_type))
		{
			var server_url = serviceitemJson.server_url;
					if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
						server_url = server_url + "&com.eg.CSRF_NONCE="+csrfToken;
			//tempHtml='<div style="float:left;height:162px;" class="bold serviceborderLeftShade associateWidth0 ">';
				tempHtml=tempHtml+'<table style="margin-top:30px" width="100%" align="center" border="0" borderColor="red" cellpadding="0" cellspacing="5">';
				tempHtml=tempHtml+'<tr>';
					tempHtml=tempHtml+'<td  align="center" >';
						tempHtml=tempHtml+'<a  style="font-size:18px;" href="'+server_url+'">';
					if(!Ext.isEmpty(serviceitemJson.showImage))
					{

								//tempHtml=tempHtml+'<div style="width:48px;height:45px;margin:0px auto;background:url('+serviceitemJson.server_state_img+')" align="center" valign="middle" >';
									//tempHtml=tempHtml+'<img src="'+serviceitemJson.server_type_img+'" border="0" alt="'+serviceitemJson.server_type_disp+'" align="center" width="48" height="45" hspace="0" vspace="0">';
								//tempHtml=tempHtml+'</div>';
								tempHtml=tempHtml+'<div style="margin:5px auto 0px auto;display:inline-block;width:48px;height:48px;" align="left"><div style="position:relative;top:0px;left:0px;border:0px solid red;"><img src="'+serviceitemJson.server_type_img+'" alt="'+serviceitemJson.server_type_disp+'"/><div style="position:absolute;top:28px;left:28px;" class="state20_'+serviceitemJson.server_state_str+'"></div></div></div>';
					}
						tempHtml=tempHtml+'</a>';
					tempHtml=tempHtml+'</td>';
				tempHtml=tempHtml+'</tr>';
				tempHtml=tempHtml+'<tr>';
					tempHtml=tempHtml+'<td width="100%" valign="top" align="center">';
						tempHtml=tempHtml+'<div style="width:120px; overflow:hidden;text-overflow:ellipsis;border:0px solid blue;white-space:nowrap;" class="business_dashTitlefont"><a style=""  href="'+server_url+'"  title="'+serviceitemJson.server_type_disp+'">';
						tempHtml=tempHtml+serviceitemJson.server_type_disp;
						tempHtml=tempHtml+'</a></div>';
					tempHtml=tempHtml+'</td>';
				tempHtml=tempHtml+'</tr>';
				tempHtml=tempHtml+'</table>';
			//tempHtml=tempHtml+'</div>';
		}
		return tempHtml;
	},
	getDemandAndQuality: function(serviceItemJson,option)
	{
		var tempHtml="";
		var serviceDemandDataArr="";
		if(!Ext.isEmpty(option) && option=='Quality')
		{
			serviceDemandDataArr=serviceItemJson.serviceQualityData;
		}
		else if(!Ext.isEmpty(option) && option=='Demand')
		{
			serviceDemandDataArr=serviceItemJson.serviceDemandData;
		}

		if ( !Ext.isEmpty( serviceDemandDataArr ) && !Ext.isEmpty( serviceDemandDataArr[0].ErrMsg ))
		{
			tempHtml=tempHtml+'<div class="centerDiv"><div class="iconInformation" style="margin:5% auto 0px auto"></div><div class="commonErrorMsgText" >'+serviceDemandDataArr[0].ErrMsg+'</div></div>';
		}
		else if(!Ext.isEmpty(serviceDemandDataArr))
		{
			//tempHtml=tempHtml+'<div>';
			//tempHtml=tempHtml+'<div >';
				tempHtml=tempHtml+'<table border="0" borderColor="green" cellpadding="0" cellspacing="0" width="100%" >';
					tempHtml=tempHtml+'<tr>';
			for(var sditem=0; sditem< serviceDemandDataArr.length ; sditem++)
			{
				var serviceDemandOrQualityItemJson=serviceDemandDataArr[sditem];

				if(!Ext.isEmpty( serviceDemandOrQualityItemJson.minMaxTable ))
				{
					var minMaxTableObj=serviceDemandOrQualityItemJson.minMaxTable;
					if(!Ext.isEmpty( minMaxTableObj.ChartName ))
					{
						tempHtml=tempHtml+'<td valign="middle" align="center" width="100%">';
						//tempHtml=tempHtml+'<table border="0" borderColor="red" width="'+minMaxTableObj.ChartTdWidth+'">';
						tempHtml=tempHtml+'<table border="0" width="100%">';
							tempHtml=tempHtml+'<tr>';
								tempHtml=tempHtml+'<td align="center" valign="middle" >';
								if(!Ext.isEmpty( minMaxTableObj.chartOption ) && !Ext.isEmpty( minMaxTableObj.chartTimeline ))
								{
									if(!Ext.isEmpty( minMaxTableObj.ChartURLForLM ))
									{
										tempHtml=tempHtml+'<div class="component-list-left-font" style="width:100%;margin-top:4px;">'+minMaxTableObj.ChartName+'</div><center><div id="'+minMaxTableObj.ChartId+'" onclick="javascript:goToPage(\''+minMaxTableObj.ChartURLForLM+'\')"style="width:100%;height:90%;" ></div></center>';
									}
									else
									{
										tempHtml=tempHtml+'<div class="component-list-left-font" style="width:100%;margin-top:4px;">'+minMaxTableObj.ChartName+'</div><center><div id="'+minMaxTableObj.ChartId+'" style="width:100%;height:90%;"></div></center>';
									}
								}
								else
								{
									if(!Ext.isEmpty( minMaxTableObj.ChartURLForLM ))
									{
										tempHtml=tempHtml+'<b>'+minMaxTableObj.ChartName+'</b><br><br>';
										tempHtml=tempHtml+'<img  src="../servlet/com.egurkha.monitor.DashboardTimelineMeasures?'+minMaxTableObj.ChartURL+'" onclick="javascript:goToPage(\''+minMaxTableObj.ChartURLForLM+'\')" class="'+minMaxTableObj.ChartClass+'" />';
									}
									else
									{
										tempHtml=tempHtml+'<b>'+minMaxTableObj.ChartName+'</b><br><br>';
										tempHtml=tempHtml+'<img  src="../servlet/com.egurkha.monitor.DashboardTimelineMeasures?'+minMaxTableObj.ChartURL+'" class="'+minMaxTableObj.ChartClass+'" />';
									}
								}
								tempHtml=tempHtml+'</td>';
							tempHtml=tempHtml+'</tr>';
						if(!Ext.isEmpty( minMaxTableObj.ChartAvg ))
						{
							tempHtml=tempHtml+'<tr>';
								tempHtml=tempHtml+'<td colspan="3" align="center" valign="middle" >';
									tempHtml=tempHtml+'<table cellpadding="3" class="sys_bus_datatable" cellspacing="0" border="0" class="tableborder" width="85%" >';
										tempHtml=tempHtml+'<tr id="measureGraphTitle">';
											tempHtml=tempHtml+'<td align="center" class="tdborder2" style="font-weight:normal;">'+minMaxTableObj.ChartState+'</td>';
											tempHtml=tempHtml+'<td align="center" class="tdborder2" style="font-weight:normal;">'+minMaxTableObj.ChartAvg+'</td>';
											tempHtml=tempHtml+'<td align="center" class="tdborder2" style="font-weight:normal;">'+minMaxTableObj.ChartMax+'</td>';
											tempHtml=tempHtml+'<td align="center" class="tdborder2" style="font-weight:normal;">'+minMaxTableObj.ChartMin+'</td>';
										tempHtml=tempHtml+'</tr>';
										tempHtml=tempHtml+'<tr>';
											tempHtml=tempHtml+'<td align="center" width="10px" class="tdborder">';
												tempHtml=tempHtml+'<table cellpadding="0" cellspacing="0" border="0" >';
													tempHtml=tempHtml+'<tr>';
														tempHtml=tempHtml+'<td  id="'+minMaxTableObj.ChartStateVal+'bot_bg" title="'+minMaxTableObj.ChartStateDisp+'" class="linesquare_white" height="8"><img src = "/final/monitor/eg_images/spacer.gif" width = "8" height = "8" border="0"></td>';
													tempHtml=tempHtml+'</tr>';
												tempHtml=tempHtml+'</table>';
											tempHtml=tempHtml+'</td>';
											tempHtml=tempHtml+'<td align="center" class="tdborder">'+minMaxTableObj.ChartAvgVal+'</td>';
											tempHtml=tempHtml+'<td align="center" class="tdborder">'+minMaxTableObj.ChartMaxVal+'</td>';
											tempHtml=tempHtml+'<td align="center" class="tdborder">'+minMaxTableObj.ChartMinVal+'</td>';
										tempHtml=tempHtml+'</tr>';
									tempHtml=tempHtml+'</table>';
								tempHtml=tempHtml+'</td>';
							tempHtml=tempHtml+'</tr>';
						}
						tempHtml=tempHtml+'</table>';
						tempHtml=tempHtml+'</td>';
					}
					else if(!Ext.isEmpty( minMaxTableObj.minMaxTableHeadersArray ) && !Ext.isEmpty( minMaxTableObj.minMaxTableDataArray ) && Ext.isEmpty( serviceDemandOrQualityItemJson.more_then_one ))
					{
						/*-- Sub Heading --*/
						var minMaxTableHeadersArray = minMaxTableObj.minMaxTableHeadersArray;
						var measHeaderObject=minMaxTableHeadersArray[0];
						if(!Ext.isEmpty( measHeaderObject ))
						{

							tempHtml=tempHtml+'<td valign="top" width="100%" style="padding:0px;vertical-align:top">';
							tempHtml=tempHtml+'<table class="sys_bus_datatable" border="0" borderColor="red" cellpadding="0" cellspacing="0" width="100%" >';
								tempHtml=tempHtml+'<thead>';
								tempHtml=tempHtml+'<tr>';
								tempHtml=tempHtml+'<th class="columnInnerTableHeader" colspan="2" align="center" >'+measHeaderObject.name+'</th>';
						}

						var minMaxTableDataArray = minMaxTableObj.minMaxTableDataArray;
						var cpv=0;

						if(!Ext.isEmpty(minMaxTableDataArray) && !Ext.isEmpty(minMaxTableHeadersArray) && minMaxTableDataArray.length>0 && minMaxTableHeadersArray.length>0)
						{
							try
							{
								cpv=minMaxTableDataArray.length/minMaxTableHeadersArray.length;

								if(!Ext.isEmpty(cpv))
								{
									var scpv=""+cpv;
									if(!Ext.isEmpty(scpv) && scpv.indexOf(".")>-1)
									{
										cpv = 0;
									}
								}

								if(cpv==null || cpv==undefined || cpv=='undefined')
								{
									cpv = 0;
								}
							}
							catch (e)
							{
								cpv = 0;
							}
						}

						for(var sdi=1; sdi< minMaxTableHeadersArray.length ; sdi++)
						{
							measHeaderObject=minMaxTableHeadersArray[sdi];
								tempHtml=tempHtml+'<th class="columnInnerTableHeader" align="right" style="height:22px;font-family:arial;font-size:11px;text-align:right;" nowrap colspan="'+cpv+'">'+measHeaderObject.name+'</th>';
						}
								tempHtml=tempHtml+'</tr>';
								tempHtml=tempHtml+'</thead>';
								tempHtml=tempHtml+'<tbody>';

						for(var sdi=0; sdi< minMaxTableDataArray.length ; sdi++)
						{
							minMaxTableDataObject=minMaxTableDataArray[sdi];
							if(!Ext.isEmpty( minMaxTableDataObject.value0 ))
							{
								tempHtml=tempHtml+'<tr>';
											tempHtml=tempHtml+'<td align="center" class="columnInnerRow2" width="4px">';
													tempHtml=tempHtml+'<div style="margin-left:5px;margin-right:5px;float:left;" class="'+minMaxTableDataObject.value0+'" title="'+minMaxTableDataObject.value0_tip+'"></div>';
									tempHtml=tempHtml+'</td>';

									if(!Ext.isEmpty( minMaxTableDataObject.value0_url ))
									{
										var minMaxTableDataObjectValue0_url = minMaxTableDataObject.value0_url;
										if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
											minMaxTableDataObjectValue0_url = minMaxTableDataObjectValue0_url + "&com.eg.CSRF_NONCE="+csrfToken;
										tempHtml=tempHtml+'<td style="padding-left:0px;" align="left" class="columnInnerRow2" ><a href="javascript:void(0);" class="ServiceDashboardLink" onclick="javascript:goToPage(\''+minMaxTableDataObjectValue0_url+'\')"><span class="'+minMaxTableDataObject.value1_mouse+'">'+minMaxTableDataObject.value0_disp+'</span></a>';
									}
									else
									{
										tempHtml=tempHtml+'<td style="padding-left:0px;" align="left" class="columnInnerRow2" ><a href="javascript:void(0);" class="ServiceDashboardLink" style="cursor:default;"><span class="'+minMaxTableDataObject.value1_mouse+'">'+minMaxTableDataObject.value0_disp+'</span></a>';
									}

									tempHtml=tempHtml+'</td>';
							}

							if(!Ext.isEmpty( minMaxTableDataObject.value1 ))
							{
								if(minMaxTableDataObject.value1=='-')
								{
									//444
									tempHtml=tempHtml+'<td align="right" class="columnInnerRow2" title="'+minMaxTableDataObject.value1_tip+'" style="width:40px;" colspan="'+cpv+'"><span>-</span>';
									tempHtml=tempHtml+'</td>';
								}
								else if(minMaxTableDataObject.value1!='-')
								{
									//555
									if(!Ext.isEmpty( minMaxTableDataObject.value1_url ))
									{
										var minMaxTableDataObjectValue1_url = minMaxTableDataObject.value1_url;
										if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
											minMaxTableDataObjectValue1_url = minMaxTableDataObjectValue1_url + "&com.eg.CSRF_NONCE="+csrfToken;
										
										tempHtml=tempHtml+'<td align="right" class="columnInnerRow2" style="width:40px;font-weight:bold;" colspan="'+cpv+'"><a href="javascript:void(0);" class="ServiceDashboardLink" onclick="javascript:goToPage(\''+minMaxTableDataObjectValue1_url+'\')"><span id="'+minMaxTableDataObject.value1_state+'link" class="'+minMaxTableDataObject.value1_mouse+'" title="'+minMaxTableDataObject.value1_tip+'" ><b>'+minMaxTableDataObject.value1+'</b></span></a>';
									}
									else
									{
										tempHtml=tempHtml+'<td align="right" class="columnInnerRow2" style="width:40px;font-weight:bold;" colspan="'+cpv+'"><a href="javascript:void(0);" class="ServiceDashboardLink" style="cursor:default;"><span id="'+minMaxTableDataObject.value1_state+'link" class="'+minMaxTableDataObject.value1_mouse+'" title="'+minMaxTableDataObject.value1_tip+'" >'+minMaxTableDataObject.value1+'</span></a>';
									}
									tempHtml=tempHtml+'</td>';
								}
							}

							if(!Ext.isEmpty( minMaxTableDataObject.value1_endTR ) && minMaxTableDataObject.value1_endTR=='true')
							{
								tempHtml=tempHtml+'</tr>';
							}
						}

						if(!Ext.isEmpty( serviceDemandOrQualityItemJson.endTable ) && serviceDemandOrQualityItemJson.endTable=='true')
						{
							tempHtml=tempHtml+'</table>';
						tempHtml=tempHtml+'</td>';
						}
					}
					else if(!Ext.isEmpty( minMaxTableObj.minMaxTableDataArray ) && !Ext.isEmpty( serviceDemandOrQualityItemJson.more_then_one ))
					{
						//cccccc
						tempHtml=tempHtml+'<td valign="top" style="width:100%;">';
							tempHtml=tempHtml+'<table cellpadding="0" cellspacing="0" width="100%">';
						var minMaxTableDataArray = minMaxTableObj.minMaxTableDataArray;
						for(var sdi=0; sdi< minMaxTableDataArray.length ; sdi++)
						{
							minMaxTableDataObject=minMaxTableDataArray[sdi];
							if(!Ext.isEmpty( minMaxTableDataObject.value0 ) && Ext.isEmpty( minMaxTableDataObject.value0_info ))
							{
								//666
								tempHtml=tempHtml+'<tr>';
									tempHtml=tempHtml+'<td valign="top" width="100%" >';
										tempHtml=tempHtml+'<table border="0" style="padding:0px" class="sys_bus_datatable" borderColor="orange" width="100%">';
											tempHtml=tempHtml+'<tr>';
												tempHtml=tempHtml+'<td align="center" class="columnInnerRow" width="10">';
																	tempHtml=tempHtml+'<div style="margin-left:5px;margin-right:5px;float:left;" class="'+minMaxTableDataObject.value0+'"></div>';
												tempHtml=tempHtml+'</td>';

												if(!Ext.isEmpty( minMaxTableDataObject.value0_url ))
												{
													var minMaxTableDataObjectValue0_url = minMaxTableDataObject.value0_url;
													if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
														minMaxTableDataObjectValue0_url = minMaxTableDataObjectValue0_url + "&com.eg.CSRF_NONCE="+csrfToken;

													tempHtml=tempHtml+'<td align="left"  class="columnInnerRow"  style="width:85%;padding-left:0px"><a href="javascript:void(0);" class="ServiceDashboardLink" onclick="javascript:goToPage(\''+minMaxTableDataObjectValue0_url+'\')"><span class="'+minMaxTableDataObject.value0_mouse+'" title="'+minMaxTableDataObject.value0_d_tip+'">'+minMaxTableDataObject.value0_disp+'</span></a>';
												}
												else
												{
													tempHtml=tempHtml+'<td align="left"  class="columnInnerRow"  style="width:85%;padding-left:0px"><a href="javascript:void(0);" class="ServiceDashboardLink" style="cursor:default;"><span class="'+minMaxTableDataObject.value0_mouse+'" title="'+minMaxTableDataObject.value0_d_tip+'">'+minMaxTableDataObject.value0_disp+'</span></a>';
												}
												tempHtml=tempHtml+'</td>';
							}
							else if(!Ext.isEmpty( minMaxTableDataObject.value0 ) && !Ext.isEmpty( minMaxTableDataObject.value0_info ) && minMaxTableDataObject.value0_info=='true')
							{
								///777
								tempHtml=tempHtml+'<tr>';
									tempHtml=tempHtml+'<td align="center" class="columnInnerRow" >';
										tempHtml=tempHtml+'<table cellpadding="0" cellspacing="0" border="0" >';
											tempHtml=tempHtml+'<tr>';
												tempHtml=tempHtml+'<td  id="'+minMaxTableDataObject.value0+'bot_bg" title="'+minMaxTableDataObject.value0_tip+'" class="linesquare_white" height="8"><img src = "/final/monitor/eg_images/spacer.gif" width = "8" height = "8" border="0"></td>';
											tempHtml=tempHtml+'</tr>';
										tempHtml=tempHtml+'</table>';
									tempHtml=tempHtml+'</td>';

									if(!Ext.isEmpty( minMaxTableDataObject.value0_url ))
									{
										var minMaxTableDataObjectValue0_url = minMaxTableDataObject.value0_url;
										if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
											minMaxTableDataObjectValue0_url = minMaxTableDataObjectValue0_url + "&com.eg.CSRF_NONCE="+csrfToken;
										tempHtml=tempHtml+'<td align="left" class="columnInnerRow" onclick="goToPage('+minMaxTableDataObjectValue0_url+')"><span class="'+minMaxTableDataObject.value0_mouse+'" >'+minMaxTableDataObject.value0_disp+'</span>';
									}
									else
									{
										tempHtml=tempHtml+'<td align="left" class="columnInnerRow"><span class="'+minMaxTableDataObject.value0_mouse+'" style="cursor:default;" >'+minMaxTableDataObject.value0_disp+'</span>';
									}
									tempHtml=tempHtml+'</td>';
							}

							if(!Ext.isEmpty( minMaxTableDataObject.value1 ))
							{
								//888
								if(minMaxTableDataObject.value1=='-')
								{
												tempHtml=tempHtml+'<td align="right" width="40" class="columnInnerRow"  ><span id="'+minMaxTableDataObject.value1_state+'link">-</span>';
												tempHtml=tempHtml+'</td>';
								}
								else if(minMaxTableDataObject.value1!='-')
								{
									if(!Ext.isEmpty( minMaxTableDataObject.value1_url ))
									{
										var minMaxTableDataObjectValue1_url = minMaxTableDataObject.value1_url;
										if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
											minMaxTableDataObjectValue1_url = minMaxTableDataObjectValue1_url + "&com.eg.CSRF_NONCE="+csrfToken;

										tempHtml=tempHtml+'<td align="right" width="40" class="columnInnerRow"   ><a href="javascript:void(0);" class="ServiceDashboardLink" onclick="javascript:goToPage(\''+minMaxTableDataObjectValue1_url+'\')"><span id="'+minMaxTableDataObject.value1_state+'link" class="'+minMaxTableDataObject.value1_mouse+'"><b>'+minMaxTableDataObject.value1+'</b></span></a>';
									}
									else
									{
												tempHtml=tempHtml+'<td align="right" width="40" class="columnInnerRow"  ><a href="javascript:void(0);" class="ServiceDashboardLink" style="cursor:default;"><span id="'+minMaxTableDataObject.value1_state+'link" class="'+minMaxTableDataObject.value1_mouse+'"><b>'+minMaxTableDataObject.value1+'</b></span></a>';
									}
												tempHtml=tempHtml+'</td>';
								}
							}

							if(!Ext.isEmpty( minMaxTableDataObject.value1_endTR ) && minMaxTableDataObject.value1_endTR=='true')
							{
								tempHtml=tempHtml+'</tr>';
							}

							if(!Ext.isEmpty( minMaxTableDataObject.more_then_one_End ) && minMaxTableDataObject.more_then_one_End=='true')
							{
								tempHtml=tempHtml+'</tr>';
							tempHtml=tempHtml+'</table>';
						tempHtml=tempHtml+'</td>';
					tempHtml=tempHtml+'</tr>';
							}
						}

						if(!Ext.isEmpty( serviceDemandOrQualityItemJson.endTable ) && serviceDemandOrQualityItemJson.endTable=='true')
						{
						tempHtml=tempHtml+'</table>';
						tempHtml=tempHtml+'</td>';
						}
					}
				}
			}
				tempHtml=tempHtml+'</tr>';
				tempHtml=tempHtml+'</table>';
			//tempHtml=tempHtml+'</div>';
			//tempHtml=tempHtml+'</div>';
		}
		return tempHtml;
	},
	getConsumption:function(serviceItemJson)
	{
		var tempHtml="";
		var serviceConsumptionDataArr=serviceItemJson.serviceConsumptionData;

		tempHtml=tempHtml+'<div style="border:0px solid red;text-align:center;margin:auto;padding:2 0 0 0;height:132px;width:100%" >';
			tempHtml=tempHtml+'<table border="0" borderColor="black" cellpadding="0" cellspacing="0" width="100%" style="table-layout:fixed">';
				tempHtml=tempHtml+'<tr>';
				if(!Ext.isEmpty(serviceConsumptionDataArr))
				{
					for(var item=0; item< serviceConsumptionDataArr.length ; item++)
					{
						var serviceConsumptionDataJson=serviceConsumptionDataArr[item];
						if ( !Ext.isEmpty( serviceConsumptionDataJson.consumptionErrMsg ))
						{
							//1111
								tempHtml=tempHtml+'<td align="center" valign="middle" height="135" style="text-align:center">';
									tempHtml=tempHtml+'<center><div class="iconInformation" style="margin:3 0 auto 0"></div><div class="commonErrorMsgText" style="margin:3 0 20 0">'+serviceConsumptionDataJson.consumptionErrMsg+'</div></center>';
								tempHtml=tempHtml+'</td>';
						}
						else if ( !Ext.isEmpty( serviceConsumptionDataJson.consumptionInnerDataArr ))
						{
							var consumptionInnerDataArr=serviceConsumptionDataJson.consumptionInnerDataArr;
							if(!Ext.isEmpty(consumptionInnerDataArr))
							{
								var totalCon=consumptionInnerDataArr.length;
								var width = "93px";
								if(totalCon >= 4)
									width = "110px";
								for(var citem=0; citem< consumptionInnerDataArr.length ; citem++)
								{
									//2222---Consumption------------
									var consumptionInnerData=consumptionInnerDataArr[citem];
									tempHtml=tempHtml+'<td valign="top" align="center" style="text-align:center;margin:auto;width:'+width+'">';
										tempHtml=tempHtml+'<table border="0" borderColor="red" cellpadding="0" cellspacing="0"  width="100%" style="height:122px">';
									if(!Ext.isEmpty(consumptionInnerData.consumptionInnerErrMsg))
									{
											tempHtml=tempHtml+'<tr>';
												tempHtml=tempHtml+'<td align="center" valign="middle" width="33%" style="width:33%;height:110px;text-align:center">';
													tempHtml=tempHtml+'<center><div style="margin:18% 0 auto 0"><div class="iconInformation" style="text-align:center;margin:auto;width:100%"></div><div class="commonErrorMsgText" style="margin:auto;width:45px;" class=" commonErrorMsgText">'+consumptionInnerData.consumptionInnerErrMsg+'</div></div></center>';
												tempHtml=tempHtml+'</td>';
											tempHtml=tempHtml+'</tr>';
									}
									else if(!Ext.isEmpty(consumptionInnerData.chartValue))
									{

										if(consumptionInnerData.chartStateInner.startsWith('cpu_'))
										{
											var consumptionInnerDataTolayerModelUrl = '';
											if(!Ext.isEmpty(consumptionInnerData.layerModelUrl))
											{
												consumptionInnerDataTolayerModelUrl = consumptionInnerData.layerModelUrl;
												if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
													consumptionInnerDataTolayerModelUrl = consumptionInnerDataTolayerModelUrl + "&com.eg.CSRF_NONCE="+csrfToken;
											}
												tempHtml=tempHtml+'<tr>';
													tempHtml=tempHtml+'<td width="33%" align="center" valign="middle" height="auto" style="padding-top:25px;text-align:left;border:0px solid orange">';
														tempHtml=tempHtml+'<center><div class="cpu_Main" style="border:0px solid blue;padding:7px 0px 0px 0px">';

													if(!Ext.isEmpty(consumptionInnerDataTolayerModelUrl))
														{
															tempHtml=tempHtml+'<a onclick="javascript:goToPage(\''+consumptionInnerDataTolayerModelUrl+'\')" href="javascript:void(0);" class="type_comps" title="'+consumptionInnerData.toolTip+'">';
														}
														else
														{
															tempHtml=tempHtml+'<a href="javascript:void(0);"  class="type_comps" style="cursor:default;" title="'+consumptionInnerData.toolTip+'">';
														}
															tempHtml=tempHtml+'<div style="margin:0px auto;border:0px solid red;" class="'+consumptionInnerData.chartStateOuter+'">';
															tempHtml=tempHtml+'<div class="cpu_GRAY" style="border:0px solid green;height:'+consumptionInnerData.chartValue+'%"></div>';
															tempHtml=tempHtml+'</div></a>';
														tempHtml=tempHtml+'</div>';

														tempHtml=tempHtml+'<div style="border:0px solid blue">';

														if(!Ext.isEmpty(consumptionInnerDataTolayerModelUrl))
														{
															tempHtml=tempHtml+'<a onclick="javascript:goToPage(\''+consumptionInnerDataTolayerModelUrl+'\')" href="javascript:void(0);"  class="type_comps">';
														}
														else
														{
															tempHtml=tempHtml+'<a href="javascript:void(0);"  class="type_comps" style="cursor:default;">';
														}
															tempHtml=tempHtml+'<span style="padding-top:0px;display:inline-block;margin-bottom:-10px" class="matric_values" title="'+consumptionInnerData.consumptionDisplayTip+'">'+consumptionInnerData.consumptionDisplayValue+'</span></a>';

														tempHtml=tempHtml+'</div></center>';
													tempHtml=tempHtml+'</td>';
												tempHtml=tempHtml+'</tr>';
											}
											else if(consumptionInnerData.chartStateInner.startsWith('mem_'))
											{
												//4444
												var consumptionInnerDataTolayerModelUrl = '';
												if(!Ext.isEmpty(consumptionInnerData.layerModelUrl))
												{
													consumptionInnerDataTolayerModelUrl = consumptionInnerData.layerModelUrl;
													if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
														consumptionInnerDataTolayerModelUrl = consumptionInnerDataTolayerModelUrl + "&com.eg.CSRF_NONCE="+csrfToken;
												}
												tempHtml=tempHtml+'<tr>';
													tempHtml=tempHtml+'<td align="center" valign="middle" height="auto" style="padding-top:20px;border:0px solid red">';
														tempHtml=tempHtml+'<div class="mem_Main" style="border:0px solid blue;padding:13px 9px 7px 7px">';

														if(!Ext.isEmpty(consumptionInnerDataTolayerModelUrl))
														{
															tempHtml=tempHtml+'<a onclick="javascript:goToPage(\''+consumptionInnerDataTolayerModelUrl+'\')" href="javascript:void(0);"  class="type_comps" title="'+consumptionInnerData.toolTip+'">';
														}
														else
														{
															tempHtml=tempHtml+'<a href="javascript:void(0);"  class="type_comps" style="cursor:default;" title="'+consumptionInnerData.toolTip+'">';
														}
															tempHtml=tempHtml+'<div style="border:0px solid red;margin:0px auto" class="'+consumptionInnerData.chartStateOuter+'">';
															tempHtml=tempHtml+'<div class="mem_GRAY" style="border:0px solid green;height:'+consumptionInnerData.chartValue+'%"></div>';
															tempHtml=tempHtml+'</div></a>';
														tempHtml=tempHtml+'</div>';

														tempHtml=tempHtml+'<div style="border:0px solid blue">';
														if(!Ext.isEmpty(consumptionInnerDataTolayerModelUrl))
														{
															tempHtml=tempHtml+'<a onclick="javascript:goToPage(\''+consumptionInnerDataTolayerModelUrl+'\')" href="javascript:void(0);"  class="type_comps">';
														}
														else
														{
															tempHtml=tempHtml+'<a href="javascript:void(0);"  class="type_comps" style="cursor:default;">';
														}
															tempHtml=tempHtml+'<span  class="matric_values" style="padding-top:6px;display:inline-block;margin-bottom:-10px" title="'+consumptionInnerData.consumptionDisplayTip+'">'+consumptionInnerData.consumptionDisplayValue+'</span></a>';
														tempHtml=tempHtml+'</div>';
													tempHtml=tempHtml+'</td>';
												tempHtml=tempHtml+'</tr>';
											}
									}
									else if(!Ext.isEmpty(consumptionInnerData.consumptionWithoutIcon))
									{
										var consumptionInnerDataTolayerModelUrl = '';
										if(!Ext.isEmpty(consumptionInnerData.layerModelUrl))
										{
											consumptionInnerDataTolayerModelUrl = consumptionInnerData.layerModelUrl;
											if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
												consumptionInnerDataTolayerModelUrl = consumptionInnerDataTolayerModelUrl + "&com.eg.CSRF_NONCE="+csrfToken;
										}
										tempHtml=tempHtml+'<tr>';
											tempHtml=tempHtml+'<td align="center" valign="middle" height="auto" style="padding-top:30px;">';
												//tempHtml=tempHtml+'<div class="mem_Main" style="border:0px solid blue;padding:13px 9px 7px 7px">';
												tempHtml=tempHtml+'<div  class="ServiceMemoryBox" style="padding:20px 9px 7px 7px">';
												if(!Ext.isEmpty(consumptionInnerDataTolayerModelUrl))
												{
													tempHtml=tempHtml+'<a onclick="javascript:goToPage(\''+consumptionInnerDataTolayerModelUrl+'\')" href="javascript:void(0);"  class="type_comps" title="'+consumptionInnerData.toolTip+'">';
												}
												else
												{
													tempHtml=tempHtml+'<a href="javascript:void(0);"  class="type_comps" style="cursor:default;" title="'+consumptionInnerData.toolTip+'">';
												}
													var fontClass="";
													if (consumptionInnerData.consumptionBigDisplayValue.length<3)
													{
														fontClass="ServiceMemoryTxtBig";
													}
													else if (consumptionInnerData.consumptionBigDisplayValue.length>=5)
													{
														fontClass="ServiceMemoryTxtSmall";
													}
													else
													{
														fontClass="ServiceMemoryTxtNormal";
													}
													tempHtml=tempHtml+'<div class="'+fontClass+'" style="margin:auto">';
														//tempHtml=tempHtml+'<div class="mem_GRAY" style="border:0px solid green;height:'+consumptionInnerData.chartValue+'%"></div>';
														tempHtml=tempHtml+consumptionInnerData.consumptionBigDisplayValue;

													tempHtml=tempHtml+'</div></a>';
												tempHtml=tempHtml+'<div style="border:0px solid blue">';
												if(!Ext.isEmpty(consumptionInnerDataTolayerModelUrl))
												{
													tempHtml=tempHtml+'<a onclick="javascript:goToPage(\''+consumptionInnerDataTolayerModelUrl+'\')" href="javascript:void(0);"  class="type_comps">';
												}
												else
												{
													tempHtml=tempHtml+'<a href="javascript:void(0);"  class="type_comps" style="cursor:default;">';
												}
													//tempHtml=tempHtml+'<span  class="matric_values" style="padding-top:6px;display:inline-block;margin-bottom:-10px" title="'+consumptionInnerData.consumptionDisplayTip+'">'+consumptionInnerData.consumptionDisplayValue+'</span></a>';
													tempHtml=tempHtml+'<span  class="matric_values" style="display:inline-block;" title="'+consumptionInnerData.consumptionDisplayTip+'">'+consumptionInnerData.consumptionDisplayUnit+'</span></a>';
												tempHtml=tempHtml+'</div>';
											tempHtml=tempHtml+'</div>';
											tempHtml=tempHtml+'</td>';
										tempHtml=tempHtml+'</tr>';
									}
									else if(!Ext.isEmpty(consumptionInnerData.consumptionDisplayTip))
									{
										if(!Ext.isEmpty(consumptionInnerData.divId))
										{
											//5555
											var consumptionInnerDataTolayerModelUrl = '';
											if(!Ext.isEmpty(consumptionInnerData.layerModelUrl))
											{
												consumptionInnerDataTolayerModelUrl = consumptionInnerData.layerModelUrl;
												if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
													consumptionInnerDataTolayerModelUrl = consumptionInnerDataTolayerModelUrl + "&com.eg.CSRF_NONCE="+csrfToken;
											}
											tempHtml=tempHtml+'<tr>';
												tempHtml=tempHtml+'<td align="center" valign="middle" style="text-align:center;padding-top:7px;border:0px solid green">';
													tempHtml=tempHtml+'<div class="matric_values">';
														if(!Ext.isEmpty(consumptionInnerDataTolayerModelUrl))
														{
															tempHtml=tempHtml+'<a onclick="javascript:goToPage(\''+consumptionInnerDataTolayerModelUrl+'\')" href="javascript:void(0);" class="'+consumptionInnerData.class_mouse+'" title="'+consumptionInnerData.toolTip+'">';
														}
														else
														{
															tempHtml=tempHtml+'<a href="javascript:void(0);" class="'+consumptionInnerData.class_mouse+'" style="cursor:default;" title="'+consumptionInnerData.toolTip+'">';
														}

														tempHtml=tempHtml+'<div id="'+consumptionInnerData.divId+'"  style="height:100%;"></div>';
														/*tempHtml=tempHtml+'<script type="text/javascript">';
															tempHtml=tempHtml+'if  ( FusionCharts( "'+consumptionInnerData.fcId+'" ) )';
																	tempHtml=tempHtml+'FusionCharts( "'+consumptionInnerData.fcId+'" ).dispose();';
															tempHtml=tempHtml+'var myChart = new FusionCharts( "/final/FusionCharts/swf/Doughnut2D.swf","'+consumptionInnerData.fcId+'", "99%", "64","0","1");';
															tempHtml=tempHtml+'myChart.setXMLData("'+consumptionInnerData.dataXML+'");';
															tempHtml=tempHtml+'myChart.setTransparent(true);';
															tempHtml=tempHtml+'myChart.render("'+consumptionInnerData.divId+'");';
														tempHtml=tempHtml+'</script>';*/
														tempHtml=tempHtml+'</a>';
													tempHtml=tempHtml+'</div>';

													tempHtml=tempHtml+'<div style="font-weight:bold;clear:both;width:100%;text-align:center;margin-left:0%;margin-top:2px">';

													if(!Ext.isEmpty(consumptionInnerDataTolayerModelUrl))
													{
														tempHtml=tempHtml+'<a onclick="javascript:goToPage(\''+consumptionInnerDataTolayerModelUrl+'\')" href="javascript:void(0);" class="'+consumptionInnerData.class_mouse+'">';
													}
													else
													{
														tempHtml=tempHtml+'<a href="javascript:void(0);" class="'+consumptionInnerData.class_mouse+'" style="cursor:default;" >';
													}

													tempHtml=tempHtml+'<span  class="matric_values" title="'+consumptionInnerData.consumptionDisplayTip+'">'+consumptionInnerData.consumptionDisplayValue+'</span></a>';

													tempHtml=tempHtml+'</div>';

												tempHtml=tempHtml+'</td>';
											tempHtml=tempHtml+'</tr>';
										}
										else
										{
											tempHtml=tempHtml+'<tr>';
												tempHtml=tempHtml+'<td align="center" valign="middle" width="100%" style="padding-left:15px;text-align:center">';
													tempHtml=tempHtml+'<div class="matric_values">';
													tempHtml=tempHtml+'<span  class="consumptionPercentText" title="'+consumptionInnerData.consumptionDisplayTip+'">'+consumptionInnerData.consumptionDisplayValue+'</span>';
													tempHtml=tempHtml+'</div>';
												tempHtml=tempHtml+'</td>';
											tempHtml=tempHtml+'</tr>';
										}
									}
											tempHtml=tempHtml+'<tr>';
												tempHtml=tempHtml+'<th align="center" valign="middle" style="padding-left:0px;text-align:center">';
												tempHtml=tempHtml+'<center><div style="border:0px solid red" class="matric_values consumptionText" title="'+consumptionInnerData.consumptionInnerTip+'">'+consumptionInnerData.consumptionInnerDisplay+'</div></center>';
												tempHtml=tempHtml+'</th>';
											tempHtml=tempHtml+'</tr>';
										tempHtml=tempHtml+'</table>';
									tempHtml=tempHtml+'</td>';
								}

								/*if(totalCon<3)
								{
									for(var citem=totalCon; citem< 3 ; citem++)
									{
										tempHtml=tempHtml+'<td valign="top" align="center" style="text-align:center;margin:auto;width:93px">&nbsp;';
										tempHtml=tempHtml+'</td>';
									}
								}*/
							}
						}
					}
				}
				tempHtml=tempHtml+'</tr>';
			tempHtml=tempHtml+'</table>';
		tempHtml=tempHtml+'</div>';
		return tempHtml;
	},
	getHealth: function(serviceItemJson)
	{
		var tempHtml="";
		var serviceTierHealthDataArr=serviceItemJson.serviceTierHealthData;
		//tempHtml=tempHtml+'<div style="float:left;padding:0px;height:162px;display:inline-block;" >';
				tempHtml=tempHtml+'<table border="0" class="sys_bus_datatable" borderColor="red" cellpadding="0" cellspacing="0" width="100%" >';
		if(!Ext.isEmpty(serviceTierHealthDataArr))
		{
			for(var item=0; item< serviceTierHealthDataArr.length ; item++)
			{
				var serviceTierHealthDataJson=serviceTierHealthDataArr[item];
				if(!Ext.isEmpty(serviceTierHealthDataJson))
				{
					var serviceTierHealthUrl = '';
					if(!Ext.isEmpty(serviceTierHealthDataJson.tierClickURL))
					{
						serviceTierHealthUrl = serviceTierHealthDataJson.tierClickURL;
						if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
							serviceTierHealthUrl = serviceTierHealthUrl + "&com.eg.CSRF_NONCE="+csrfToken;
					}
					tempHtml=tempHtml+'<tr>';
					tempHtml=tempHtml+'<td width="12%" class="columnInnerRow" >';
						tempHtml=tempHtml+'<div style="float:left;margin-left:7px;margin-right:4px;margin" class="'+serviceTierHealthDataJson.tierStyle+'"></div>';
					tempHtml=tempHtml+'</td>';
					tempHtml=tempHtml+'<td class="columnInnerRow" >';
						tempHtml=tempHtml+'<a href="'+serviceTierHealthUrl+'" class="ServiceDashboardLink" title="'+serviceTierHealthDataJson.tierTip+'">'+serviceTierHealthDataJson.tierDisplay+'</a>';
					tempHtml=tempHtml+'</td>';
				tempHtml=tempHtml+'</tr>';
				}
			}
		}
			tempHtml=tempHtml+'</table>';
		//tempHtml=tempHtml+'</div>';
		return tempHtml;
	},
	chartType:function(chartOption,chartTimeline)
	{
		var HIGH_CHART = "highcharts";
		var EASY_CHART = "easychart";

		var chartOption = chartOption;
		var chartTimeline = chartTimeline;
		var chartOpt = chartOption;
		chartOption=(chartOption==null || chartOption.trim().length ==0)?"easycharts":chartOption;
		chartOption = chartOption.toLowerCase();
		if(!Ext.isEmpty(chartOption) && chartOption.indexOf("easy") == -1)
		{
			chartOpt = getChartValue(chartTimeline,chartOption,null,null,null,null,null)
		}
		else
			chartOpt = EASY_CHART;

		return chartOpt;
	},
	refreshPageInterval: function(refreshURL)
	{
		me=this;
		Ext.Ajax.request({
			url : refreshURL,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				if ( !Ext.isEmpty( jsonText ) )
				{
					var jsonData = Ext.decode(jsonText);

					delete jsonText;
					Ext.destroy(jsonText);
					jsonText = null;
					if(flag == true){
						jumpScroll();
						beforeContinueScroll();
						Ext.getCmp('iconAutomaticScrollRun').hide();
					}
					this.showResult(jsonData);

					delete jsonData;
					Ext.destroy(jsonData);
					jsonData = null;
				}
			},
			failure : function(){
				if (!Ext.isEmpty(this))
					this.showResult(null);
				else
					window.location.href="/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isServiceBusiDash=true&isFromMenu=true";
			}
		});
	},
	refresh:function(refreshURL){
		//document.location = refreshURL;
		var showLegend = '';
		if(Ext.ComponentQuery.query('#showLegend')[0])
			showLegend = Ext.ComponentQuery.query('#showLegend')[0].getValue();

		refreshURL = refreshURL+"&showLegend="+showLegend;
		this.refreshPageInterval(refreshURL);
	},
	zoomLoaded:function(){
		var imgPanel=this.getZoomGraphImgPanel();
		if(!Ext.isEmpty(imgPanel)){
			imgPanel.handleScrollBars(imgPanel);
		}
	},
	zoomClose:function(){
		this.bigGraphOnClick();
	},
	bigGraphOnClick : function(){
		var zoomGraphPanel =this.getZoomGraphPanel();
		if(!Ext.isEmpty(zoomGraphPanel)){
			zoomGraphPanel.destroy();
			if(!Ext.isEmpty(this.newWinId)){
				this.newWinId.destroy();
			}
		}
		this.getMain().show();
	},
	timelineChangeHandler:function(combo){
		var timelineValue=combo.getValue();
		if(timelineValue=="Any"){
			this.enableDisableDateFields(true);
		}else{
			this.enableDisableDateFields(false);
		}

		var format=currentDateFormat_js;
		var starttime="";
		var startTimeField=this.getZoomGraphFromDate();
		if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(startTimeField.getValue())){
				starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
		}
		var endtime="";
		var endTimeField=this.getZoomGraphToDate();
		if(!Ext.isEmpty(endTimeField) && !Ext.isEmpty(endTimeField.getValue())){
			endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
		}
		var startHr="";
		var fromCombo=this.getZoomGraphComboFromhr();
		if(!Ext.isEmpty(fromCombo) && !Ext.isEmpty(fromCombo.getValue())){
			startHr=fromCombo.getValue();
		}
		var endHr="";
		var toCombo=this.getZoomGraphComboTohr();
		if(!Ext.isEmpty(toCombo) && !Ext.isEmpty(toCombo.getValue())){
			endHr=toCombo.getValue();
		}
		var paramValues='F=getTimeJSON&P0=['+timelineValue+']&P1=['+starttime+']&P2=['+endtime+']&P3=['+startHr+']&P4=['+endHr+']&P5=['+format+']&C=1&calljson=true';
		Ext.Ajax.request({
			url: remoteURL,
			scope:this,
			method: 'POST',
			params: paramValues,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonDataOut = Ext.decode(jsonText);
					this.setTime(jsonDataOut.getTime);
				}
			}
		});
	},
	timelineDateChangeHandler:function(combo){
		var timelineValue="Any";
		var timelineCombo=this.getZoomGraphComboTimeline();
		if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
			timelineValue=timelineCombo.getValue();
		}

		var format=currentDateFormat_js;
		var starttime="";
		var startTimeField=this.getZoomGraphFromDate();
		if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(startTimeField.getValue())){
			starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
		}
		var endtime="";
		var endTimeField=this.getZoomGraphToDate();
		if(!Ext.isEmpty(endTimeField) && !Ext.isEmpty(endTimeField.getValue())){
			endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
		}
		var startHr="";
		var fromCombo=this.getZoomGraphComboFromhr();
		if(!Ext.isEmpty(fromCombo) && !Ext.isEmpty(fromCombo.getValue())){
			startHr=fromCombo.getValue();
		}
		var endHr="";
		var toCombo=this.getZoomGraphComboTohr();
		if(!Ext.isEmpty(toCombo) && !Ext.isEmpty(toCombo.getValue())){
			endHr=toCombo.getValue();
		}
		var paramValues='F=getTimeJSON&P0=['+timelineValue+']&P1=['+starttime+']&P2=['+endtime+']&P3=['+startHr+']&P4=['+endHr+']&P5=['+format+']&C=1&calljson=true';
		Ext.Ajax.request({
			url: remoteURL,
			scope:this,
			method: 'POST',
			params: paramValues,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonDataOut = Ext.decode(jsonText);
					this.setTimeDateTimeChange(jsonDataOut.getTime);
				}
			}
		});
	},
	enableDisableDateFields:function(enable){
		var startTimeField=this.getZoomGraphFromDate();
		var endTimeField=this.getZoomGraphToDate();
		var fromCombo=this.getZoomGraphComboFromhr();
		var toCombo=this.getZoomGraphComboTohr();
		if(enable){
			startTimeField.setDisabled(false);
			endTimeField.setDisabled(false);
			fromCombo.setDisabled(false);
			toCombo.setDisabled(false);
		}else{
			startTimeField.setDisabled(true);
			endTimeField.setDisabled(true);
			fromCombo.setDisabled(true);
			toCombo.setDisabled(true);
		}
	},
	setTime:function(timeVal){
		var startTimeField=this.getZoomGraphFromDate();
		var endTimeField=this.getZoomGraphToDate();
		var fromCombo=this.getZoomGraphComboFromhr();
		var toCombo=this.getZoomGraphComboTohr();

		var arrOptions = timeVal.split('\t');
		time_line_obj=new Object();
		time_line_obj.starttime=arrOptions[0];
		startTimeField.setValue(arrOptions[6]);
		time_line_obj.endtime=arrOptions[1];
		endTimeField.setValue(arrOptions[7]);

		if(!Ext.isEmpty(arrOptions[2]) && arrOptions[2].length==1)
		{
			time_line_obj.starthr="0"+arrOptions[2];
			fromCombo.setValue("0"+arrOptions[8]);
		}
		else
		{
			time_line_obj.starthr=arrOptions[2];
			fromCombo.setValue(arrOptions[8]);
		}

		if(!Ext.isEmpty(arrOptions[2]) && arrOptions[3].length==1)
		{
			time_line_obj.endhr="0"+arrOptions[3];
			toCombo.setValue("0"+arrOptions[9]);
		}
		else
		{
			time_line_obj.endhr=arrOptions[3];
			toCombo.setValue(arrOptions[9]);
		}
		this.displayZoomGraph();
	},
	setTimeDateTimeChange:function(timeVal){
		var startTimeField=this.getZoomGraphFromDate();
		var endTimeField=this.getZoomGraphToDate();
		var fromCombo=this.getZoomGraphComboFromhr();
		var toCombo=this.getZoomGraphComboTohr();

		var arrOptions = timeVal.split('\t');
		time_line_obj=new Object();
		time_line_obj.starttime=arrOptions[0];
		startTimeField.setValue(arrOptions[6]);
		time_line_obj.endtime=arrOptions[1];
		endTimeField.setValue(arrOptions[7]);
		if(!Ext.isEmpty(arrOptions[2]) && arrOptions[2].length==1)
		{
			time_line_obj.starthr="0"+arrOptions[2];
			fromCombo.setValue("0"+arrOptions[8]);
		}
		else
		{
			time_line_obj.starthr=arrOptions[2];
			fromCombo.setValue(arrOptions[8]);
		}

		if(!Ext.isEmpty(arrOptions[2]) && arrOptions[3].length==1)
		{
			time_line_obj.endhr="0"+arrOptions[3];
			toCombo.setValue("0"+arrOptions[9]);
		}
		else
		{
			time_line_obj.endhr=arrOptions[3];
			toCombo.setValue(arrOptions[9]);
		}
	},
	displayZoomGraph : function(){
		var zoomGraphPanel =this.getZoomGraphPanel();
		if(!Ext.isEmpty(zoomGraphPanel) && !Ext.isEmpty(zoomGraphPanel.jsonData)){
			var jsonData=zoomGraphPanel.jsonData;
			var mode="";
			var show="";
			var starttime="";
			var endtime="";
			var startHr=""
			var endHr="";
			var time_line="";
			var dateError = '';

			var timelineCombo=this.getZoomGraphComboTimeline();
			if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
				time_line=timelineCombo.getValue();
			}

			var modeCombo=this.getZoomGraphComboMode();
			if(!Ext.isEmpty(modeCombo) && !Ext.isEmpty(modeCombo.getValue())){
				mode=modeCombo.getValue();
			}
			var showCombo=this.getZoomGraphComboShow();
			if(!Ext.isEmpty(showCombo) && !Ext.isEmpty(showCombo.getValue())){
				show=showCombo.getValue();
			}
			var startTimeField=this.getZoomGraphFromDate();
			if(!Ext.isEmpty(startTimeField)){
				if(!Ext.isEmpty(startTimeField.getValue())){
					if(!Ext.isEmpty(time_line) && time_line=="Any" && !Ext.isEmpty(time_line_obj))
					{
						starttime=time_line_obj.starttime;
					}
					else
					{
						starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
					}
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						starttime=time_line_obj.starttime;
					}else{
						starttime=Ext.Date.format(startTimeField.getValue(),mgr_dateFormat);
					}
				}
			}
			var endTimeField=this.getZoomGraphToDate();
			if(!Ext.isEmpty(endTimeField)){
				if(!Ext.isEmpty(endTimeField.getValue())){
					if(!Ext.isEmpty(time_line) && time_line=="Any" && !Ext.isEmpty(time_line_obj))
					{
						endtime=time_line_obj.endtime;
					}
					else
					{
						endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
					}
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						endtime=time_line_obj.endtime;
					}else{
						endtime=Ext.Date.format(endTimeField.getValue(),mgr_dateFormat);
					}
				}
			}

			var fromCombo=this.getZoomGraphComboFromhr();
			if(!Ext.isEmpty(fromCombo)){
				if(!Ext.isEmpty(fromCombo.getValue())){
					if(!Ext.isEmpty(time_line) && time_line=="Any" && !Ext.isEmpty(time_line_obj))
					{
						startHr=time_line_obj.starthr;
					}
					else
					{
						startHr=fromCombo.getValue();
					}
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						startHr=time_line_obj.starthr;
					}else{
						startHr=fromCombo.getValue();
					}
				}
			}

			var toCombo = this.getZoomGraphComboTohr();
			if(!Ext.isEmpty(toCombo)){
				if(!Ext.isEmpty(toCombo.getValue())){
					if(!Ext.isEmpty(time_line) && time_line=="Any" && !Ext.isEmpty(time_line_obj))
					{
						endHr=time_line_obj.endhr;
					}
					else
					{
						endHr=toCombo.getValue();
					}
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						endHr=time_line_obj.endhr;
					}else{
						endHr=toCombo.getValue();
					}
				}
			}
			var dateError = startTimeField.getName();
			if(starttime > endtime){
				Ext.Msg.alert('Error', dateError);
				return;
			}
			if(starttime == endtime){
				if(startHr >= endHr){
					Ext.Msg.alert('Error', dateError);
						return;
				}
			}

			var graphUrl="";
			if(!Ext.isEmpty(this.commonUrl)){
				graphUrl=this.commonUrl;
			}
			else if(!Ext.isEmpty(main_commonUrl)){
				graphUrl=main_commonUrl;
			}

			var me=this;
			var imgPath=graphUrl.substring(0,graphUrl.indexOf("?"));
			var imgParam=graphUrl.substring(graphUrl.indexOf("?")+1,graphUrl.length);
			if(imgParam.indexOf("&priority=")<0)
			{
				imgParam=imgParam+"&priority="+show;
			}
			var queryParam = imgParam.split('&');

			var new_url='';
			for(var k=0;k<queryParam.length;k++)
			{
				var param_value=queryParam[k];
				if(!Ext.isEmpty(param_value)){
					var pvtoken=param_value.split("=");
					if(!Ext.isEmpty(pvtoken) && pvtoken[0]=='mode'){
						new_url=new_url+"&mode="+mode;
					}
					else if(!Ext.isEmpty(pvtoken) && pvtoken[0]=='starttime'){
						new_url=new_url+"&starttime="+starttime;
					}
					else if(!Ext.isEmpty(pvtoken) && pvtoken[0]=='endtime'){
						new_url=new_url+"&endtime="+endtime;
					}
					else if(!Ext.isEmpty(pvtoken) && pvtoken[0]=='starthr'){
						new_url=new_url+"&starthr="+startHr;
					}
					else if(!Ext.isEmpty(pvtoken) && pvtoken[0]=='endhr'){
						new_url=new_url+"&endhr="+endHr;
					}
					else if(!Ext.isEmpty(pvtoken) && (pvtoken[0]=='time_line' || pvtoken[0]=='timeLine')){
						new_url=new_url+"&time_line="+time_line;
					}
					else if(!Ext.isEmpty(pvtoken) && pvtoken[0]=='priority'){
						new_url=new_url+"&priority="+show;
					}
					else
					{
						new_url=new_url+"&"+param_value;
					}
				}
			}

			var pageUrl = "/final/monitor/egDashBoardTimeline.jsp?graphType=Measuregraph&"+new_url+"&isZoomGraph=true&come_from=cview&graphId="+this.graphId;

			var scrWid=documentView.getWidth();
			var scrHei=documentView.getHeight();
			pageUrl=pageUrl+"&screenWidth="+scrWid+"&screenHeight="+scrHei;

			Ext.Ajax.request({
				url : pageUrl,
				scope:this,
				success: function(response){
					var jsonText = response.responseText;
					if ( !Ext.isEmpty( jsonText ) )
					{
						var jsonData = Ext.decode(jsonText);
						zoomGraphPanel.removeAll();
						zoomGraphPanel.createItems(jsonData);
					}
				},
				failure:function(){
					//alert('---problem---');
				}
			});
		}
	},
	displayBigGraph : function(thisObj){
		var graphUrl="";
		graphUrl =thisObj;
		this.commonUrl=graphUrl;
		main_commonUrl=graphUrl;

		var me=this;
		var imgPath=graphUrl.substring(0,graphUrl.indexOf("?"));
		var imgParam=graphUrl.substring(graphUrl.indexOf("?")+1,graphUrl.length);

		var zoomGraphPanel = Ext.create('utilities.ZoomGraphPanel',{
			//xtype:'panel',
			//style:{'border':'5px solid blue'},
			header:false,
			//width:'100%',
			region:'center',
			margin:'30 0 0 0',
			//monitorResize: true,
			margin:0,
		});

		var pageUrl = "/final/monitor/egDashBoardTimeline.jsp?graphType=Measuregraph&"+imgParam+"&isZoomGraph=true&come_from=cview&graphId="+this.graphId;

		var scrWid=documentView.getWidth();
		var scrHei=documentView.getHeight();
		pageUrl=pageUrl+"&screenWidth="+scrWid+"&screenHeight="+scrHei;

		Ext.Ajax.request({
			url : pageUrl,
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				if ( !Ext.isEmpty( jsonText ) )
				{
					var jsonData = Ext.decode(jsonText);
					zoomGraphPanel.createItems(jsonData);
					var resultObj = me.getMain();
					var newWin=Ext.create('Ext.window.Window', {
						title:'Graph',
						layout: 'fit',
						 height: 550,
						 width: '95%',
						 closable: true
					}).show();
					me.newWinId=newWin;
					newWin.add(zoomGraphPanel);
					resultObj.add(newWin);

				}
			},
			failure:function(){
				//alert('---problem---');
			}
		});
	},
	loadTiersForSystem :function()
	{
		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp=Tiers&titleText=service&selectType=layer&isDetailPage='+isDetailPage;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				Ext.getCmp('filter').setValue('Not Applicable !');
				Ext.getCmp('service').setValue('-1');

			/*	if(!Ext.isEmpty(jsonData.compDispNameObject.compDispNameArray)){
					var filterByComponent = Ext.getCmp('filter').getStore();
						filterByComponent.loadRawData(jsonData.compDispNameObject.compDispNameArray);
				}*/
				if(isServRmvReordr && (isDetailPage=='false'))
				{
						Ext.getCmp('serviceset').show();
						if(!Ext.isEmpty(jsonData.ServSettingsObj.ServSettingsArray))
						{
							var serviceSettings = Ext.getCmp('serviceset').getStore();
							serviceSettings.loadRawData(jsonData.ServSettingsObj.ServSettingsArray);
							if(Ext.getCmp('serviceset')!=null && Ext.getCmp('serviceset')!='')
								Ext.getCmp('serviceset').setValue(jsonData.ServSettingsObj.ServSettingsArray[0].valueField);
						}
				}

				if(!Ext.isEmpty(jsonData.displayServiceObject.displayServiceArray)){
					var serviceName = Ext.getCmp('service').getStore();
					serviceName.loadRawData(jsonData.displayServiceObject.displayServiceArray);
				}

				this.getServiceTypesForMainCategory();
				this.newSelection();
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	loadDataForSharing :function()
	{
		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp=Sharing&titleText=service&isDetailPage='+isDetailPage;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				Ext.getCmp('sharingService').setValue('-1');

				if(!Ext.isEmpty(jsonData.displayServiceObject.displayServiceArray))
				{
					var serviceName = Ext.getCmp('sharingService').getStore();
					serviceName.loadRawData(jsonData.displayServiceObject.displayServiceArray);
				}

				Ext.getCmp('sharingOption').setValue('-1');

				if(!Ext.isEmpty(jsonData.optionsArray))
				{
					var sharingOptionSt = Ext.getCmp('sharingOption').getStore();
					sharingOptionSt.loadRawData(jsonData.optionsArray);
				}

				Ext.getCmp('sharingUsers').setValue('-1');

				if(!Ext.isEmpty(jsonData.userServiceArray))
				{
					var userServices = Ext.getCmp('sharingUsers').getStore();
					userServices.loadRawData(jsonData.userServiceArray);
				}
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	loadDataForUserConfig:function()
	{
		var selectedVal = Ext.getCmp('serviceset').getValue();
		if((isServRmvReordr) && selectedVal!=null && selectedVal=='User Service Settings')
		{
			Ext.getCmp('service').hide();
			Ext.getCmp('Category').hide();
			Ext.getCmp('serviceType').hide();
			Ext.getCmp('filter').hide();
			Ext.getCmp('dataviewId').hide();
			Ext.getCmp('tableView').hide();
			Ext.getCmp('servicesmullist').show();
			Ext.getCmp('add').hide();
			isUserConfig=true;
			var urlUserServs='/final/monitor/serviceBusinessConfigp.jsp?serviceComp=userConfig&titleText=service&isDetailPage='+isDetailPage;
			Ext.Ajax.request({
			url : urlUserServs,
			method : 'POST',
			scope:this,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var itemSelObj = Ext.getCmp('servicesmullist');

					itemSelObj.fromField.store.removeAll();
					itemSelObj.toField.store.removeAll();

					if(jsonData.associatedServices != null)
					{
						itemSelObj.fromField.store.add(jsonData.associatedServices);
					}
					if(jsonData.disassociatedServices != null)
					{
						itemSelObj.toField.store.add(jsonData.disassociatedServices);
					}
				},
				failure : function()
				{
					//alert("failure");
				}
			});
		}
		else 
		{
			Ext.getCmp('servicesmullist').hide();
			Ext.getCmp('service').show();
			Ext.getCmp('Category').show();
			Ext.getCmp('serviceType').show();
			Ext.getCmp('filter').show();
			Ext.getCmp('dataviewId').show();
			Ext.getCmp('tableView').show();
			var tmpsrv = Ext.getCmp('service').getValue();
			var tmpsrvTyp = Ext.getCmp('filter').getValue();
			if(tmpsrv !=null && (tmpsrv!='-1')) 
			{
				Ext.getCmp('add').show();
			}
			if(tmpsrvTyp !=null && (tmpsrvTyp!='Not Applicable !'&& tmpsrvTyp!='-1')) 
			{
				Ext.getCmp('add').show();
			}
		}
	},
	loadUsersForService :function(combo,newValue,oldValue,eOpts)
	{
		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('sharingService')))
			serviceName = Ext.getCmp('sharingService').getValue();

		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp=Sharing&isDetailPage='+isDetailPage+'&serviceName='+encodeURI(serviceName);

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				Ext.getCmp('sharingOption').setValue('-1');

				if(!Ext.isEmpty(jsonData.optionsArray))
				{
					var sharingOptionSt = Ext.getCmp('sharingOption').getStore();
					sharingOptionSt.loadRawData(jsonData.optionsArray);
				}

				Ext.getCmp('sharingUsers').setValue('-1');

				if(!Ext.isEmpty(jsonData.userServiceArray))
				{
					var userServices = Ext.getCmp('sharingUsers').getStore();
					userServices.loadRawData(jsonData.userServiceArray);
				}
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	updateSharing :function()
	{
		var selectedService = '-1';
		if(!Ext.isEmpty(Ext.getCmp('sharingService')))
			selectedService = Ext.getCmp('sharingService').getValue();

		var sharingOptionVal = '';
		var sharingOptionObj=Ext.getCmp('sharingOption');
		if(!Ext.isEmpty(sharingOptionObj))
		{
			sharingOptionVal = sharingOptionObj.getValue();
		}

		if(sharingOptionVal==null || sharingOptionVal==undefined || sharingOptionVal=='-1')
		{
			sharingOptionVal="";
		}

		var selectedUserNames = '';
		var userServiceNames = '';
		var sharingUserObj=Ext.getCmp('sharingUsers');
		if(!Ext.isEmpty(sharingUserObj))
		{
			selectedUserNames = sharingUserObj.getValue();
			var splitUserNames=selectedUserNames;
			var store_data=sharingUserObj.getStore();
			if(!Ext.isEmpty(store_data) && !Ext.isEmpty(splitUserNames))
			{
				for(var m=0;m<splitUserNames.length;m++)
				{
					var selected_user=splitUserNames[m];
					for(var k=0;k<store_data.getCount();k++)
					{
						var store_user=store_data.getAt(k).data.value;
						if(store_user==selected_user)
						{
							var services_name=store_data.getAt(k).data.services;
							userServiceNames=userServiceNames+selected_user+"~!~"+services_name+"^!^";
							//break;
						}
					}
				}
			}
		}
	
		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp=updateSharing&isDetailPage='+isDetailPage+'&serviceName='+encodeURI(selectedService)+'&userNames='+encodeURI(selectedUserNames)+'&userServiceNames='+encodeURI(userServiceNames)+'&sharingOption='+sharingOptionVal;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				if(!Ext.isEmpty(jsonData.sharing) && jsonData.sharing=='success')
				{
					var VWidth = Ext.Element.getViewportWidth( );
					var sharingIdObj=Ext.getCmp('sharingId');
					if(!Ext.isEmpty(sharingIdObj))
					{
						sharingIdObj.enable(true);
						this.getSharingWindow().destroy();
						var shareMod=Ext.getCmp('shareMod');
						if(!Ext.isEmpty(shareMod)){
							shareMod.destroy();
						}
						sharingIdObj.conId.hide();
						this.renderMain();
					}
				}
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	getServiceTypesForMainCategory: function (combo,newValue,oldValue,eOpts) {

		//var mainCategory = Ext.getCmp('Aggregate').getValue().Aggregate;
		var subCategory = Ext.getCmp('Category').getValue().Category;

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		var typeHeaderObj = Ext.getCmp('typeHeader');
		var testHeaderObj = Ext.getCmp('testHeader');
		var meaHeaderObj = Ext.getCmp('meaHeader');
		var disHeaderObj = Ext.getCmp('disHeader');
		if(serviceName !=null && serviceName!=undefined && serviceName!='-1')
		{
			typeHeaderObj.show();
			typeHeaderObj.setWidth(150);
			testHeaderObj.setWidth(160);
			meaHeaderObj.setWidth(150);
			disHeaderObj.setWidth(106);
		}
		else
		{
			typeHeaderObj.hide();
			testHeaderObj.setWidth(195);
			meaHeaderObj.setWidth(185);
			disHeaderObj.setWidth(186);
		}

	//	alert(serviceName);
		//var urlTier1='/final/monitor/serviceBusinessConfigp.jsp?mainCategory='+mainCategory+'&subCategory='+subCategory+'&serviceName=-1&getServiceTypes=true&isDetailPage=true';

		var urlTier1='/final/monitor/serviceBusinessConfigp.jsp?subCategory='+subCategory+'&getServiceTypes=true&isDetailPage='+isDetailPage+'&serviceName='+encodeURI(serviceName);

		Ext.Ajax.request({
			url : urlTier1,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				Ext.getCmp('serviceType').show();
				if(!Ext.isEmpty(jsonData.hiddenFields.displayField))
				{
					Ext.getCmp('serviceType').setValue(jsonData.hiddenFields.displayField);
					Ext.getCmp('serviceType').hide();
				}
				else
				{
					Ext.getCmp('serviceType').setValue('-1');
					Ext.getCmp('serviceType').show();
				}

				if(!Ext.isEmpty(jsonData.tempObject.tempArray)){
					var serviceType = Ext.getCmp('serviceType').getStore();
					serviceType.loadRawData(jsonData.tempObject.tempArray);
				}
				this.getCompTypesForServiceType();
				this.getInfo();
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},

	getCompTypesForServiceType: function () {
		//Ext.getCmp('modify').show();

		//var mainCategory = Ext.getCmp('Aggregate').getValue().Aggregate;
		var subCategory = Ext.getCmp('Category').getValue().Category;

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		var serviceType = '-1';
		if(!Ext.isEmpty(Ext.getCmp('serviceType')))
			serviceType = Ext.getCmp('serviceType').getValue();

		//var urlTier='/final/monitor/serviceBusinessConfigp.jsp?mainCategory='+mainCategory+'&subCategory='+subCategory+'&serviceName=-1&serviceType='+serviceType+'&getCompTypes=true&basedOnServiceTypes=true&isDetailPage=true';

		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?subCategory='+subCategory+'&serviceName='+encodeURI(serviceName)+'&serviceType='+serviceType+'&getCompTypes=true&basedOnServiceTypes=true&isDetailPage='+isDetailPage;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				Ext.getCmp('filter').setValue('-1');

				if(!Ext.isEmpty(jsonData.compDispNameObject.compDispNameArray))
				{
					var filterByComponent = Ext.getCmp('filter').getStore();
					filterByComponent.loadRawData(jsonData.compDispNameObject.compDispNameArray);
				}

				if(serviceName=='-1')
				{
					Ext.getCmp('filter').show();
				}
				else
				{
					if(isDetailPage==true || isDetailPage=='true')
					{
						Ext.getCmp('filter').show();
					}
					else
					{
						Ext.getCmp('filter').hide();
					}
				}
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	getCompTypesForServices: function () {

		//var mainCategory = Ext.getCmp('Aggregate').getValue().Aggregate;
		var subCategory = Ext.getCmp('Category').getValue().Category;

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		var serviceType = '-1';
		if(!Ext.isEmpty(Ext.getCmp('serviceType')))
			serviceType = Ext.getCmp('serviceType').getValue();

		//var urlTier='/final/monitor/serviceBusinessConfigp.jsp?mainCategory='+mainCategory+'&subCategory='+subCategory+'&serviceName=-1&serviceType='+serviceType+'&getCompTypes=true&basedOnServiceTypes=true&isDetailPage=true';

		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?subCategory='+subCategory+'&serviceName='+encodeURI(serviceName)+'&serviceType='+serviceType+'&getCompTypes=true&basedOnServiceTypes=true&isDetailPage='+isDetailPage;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				Ext.getCmp('componentType').setValue('-1');

				if(!Ext.isEmpty(jsonData.compDispNameObject.compDispNameArray))
				{
					var filterByType = Ext.getCmp('componentType').getStore();
					filterByType.loadRawData(jsonData.compDispNameObject.compDispNameArray);
				}

			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	getInfoForComp: function () {
		//Ext.getCmp('tableView').hide();
	//	if(!Ext.isEmpty(Ext.getCmp('Aggregate')))
	//		var mainCategory = Ext.getCmp('Aggregate').getValue().Aggregate;
		if(!Ext.isEmpty(Ext.getCmp('Category')))
			var measurePerform = Ext.getCmp('Category').getValue().Category;

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		var serviceType = '-1';
		if(!Ext.isEmpty(Ext.getCmp('serviceType')))
			serviceType = Ext.getCmp('serviceType').getValue();

		var serviceComp = '-1' ;
		if(!Ext.isEmpty(Ext.getCmp('filter')))
		{
			serviceComp = Ext.getCmp('filter').getValue();

			if (serviceComp != '-1' && serviceComp != 'Not Applicable !')
			{
				Ext.getCmp('add').show();
			}
		}

		//var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp=Generic_server &measurePerform='+measurePerform+'&serviceName=-1&selectType=info&serviceType=End-to-End &isDetailPage=true&mainCategory='+mainCategory;

		//if(serviceName !=null && serviceName!=undefined && serviceName!='-1')
		//{

			var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&measurePerform='+measurePerform+'&serviceName='+serviceName+'&selectType=info&serviceType='+serviceType+'&isDetailPage='+isDetailPage;

			Ext.Ajax.request({
				url : urlTier,
				method : 'POST',
				scope:this,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var filterByValue = Ext.getCmp('filter').getValue();

					if(!Ext.isEmpty(jsonData.treeData))
					{
						var monTree = Ext.getCmp('tableView');
						var typeHeaderObj = Ext.getCmp('typeHeader');
						var testHeaderObj = Ext.getCmp('testHeader');
						var meaHeaderObj = Ext.getCmp('meaHeader');
						var disHeaderObj = Ext.getCmp('disHeader');
						if(serviceName !=null && serviceName!=undefined && serviceName!='-1')
						{
							typeHeaderObj.show();
							typeHeaderObj.setWidth(150);
							testHeaderObj.setWidth(160);
							meaHeaderObj.setWidth(150);
							disHeaderObj.setWidth(106);
						}
						else
						{
							typeHeaderObj.hide();
							testHeaderObj.setWidth(195);
							meaHeaderObj.setWidth(185);
							disHeaderObj.setWidth(186);
						}
					//	Ext.getCmp('modify').show();

						monTree.update(jsonData.treeData);
						monTree.show();
					}
					else
					{
						var errorPanelOne = {
							xtype : 'errorpanel',
							width : '100%',
							height : 500,
							margin : 5,
							padding:200,
							style:{'text-align':'center'},
							imageCls:'iconInformation',
							errorMsg :'<div><b>No Data</b></div>',
						};
						//this.add(errorPanel);
						var monTree = Ext.getCmp('tableView');
						monTree.removeAll();
						monTree.update(errorPanelOne);
						monTree.show();
					}

					if(filterByValue == '-1')
					{
						var monTree = Ext.getCmp('tableView');
						monTree.removeAll();
						monTree.update('');
						monTree.show();
					}
				},
				failure : function(){
					//alert("failure");
				}
			});
		//}
		//else if(serviceName!=null && serviceName!=undefined && serviceName!='-1')
	//	{
			//this.getInfoForService();
	//	}
		//else if(serviceType!=null && serviceType!=undefined && serviceType=='-1')
		//{
		//	var monTree = Ext.getCmp('tableView');
	//		if(!Ext.isEmpty(monTree))
		//		monTree.hide();
		//}

	},
	getInfoForService: function () {

	/*	if(!Ext.isEmpty(Ext.getCmp('Aggregate')))
		{
			var mainCategory = Ext.getCmp('Aggregate').getValue().Aggregate;
		}*/
		if(!Ext.isEmpty(Ext.getCmp('Category')))
			var measurePerform = Ext.getCmp('Category').getValue().Category;

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		var serviceType = '-1';
		if(!Ext.isEmpty(Ext.getCmp('serviceType')))
		{
			serviceType = Ext.getCmp('serviceType').getValue();
		}

		var serviceComp = '-1' ;
		//if(!Ext.isEmpty(Ext.getCmp('filter')))
			//serviceComp = Ext.getCmp('filter').getValue();

		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&measurePerform='+measurePerform+'&serviceName='+encodeURI(serviceName)+'&selectType=InfoForService&serviceType='+serviceType+'&isDetailPage='+isDetailPage;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				if(serviceName != '-1')
				{
					if(!Ext.isEmpty(jsonData.treeData)){
						var monTree = Ext.getCmp('tableView');
						monTree.removeAll();
						var typeHeaderObj = Ext.getCmp('typeHeader');
						var testHeaderObj = Ext.getCmp('testHeader');
						var meaHeaderObj = Ext.getCmp('meaHeader');
						var disHeaderObj = Ext.getCmp('disHeader');
						if(!Ext.isEmpty(typeHeaderObj))
						{
							typeHeaderObj.show();
							typeHeaderObj.setWidth(150);
							testHeaderObj.setWidth(160);
							meaHeaderObj.setWidth(150);
							disHeaderObj.setWidth(106);
						}
						
						monTree.update(jsonData.treeData);
						monTree.show();
						//Ext.getCmp('modify').show();
						Ext.getCmp('add').show();
					}
					else
					{
						var errorPanel = {
							xtype : 'errorpanel',
							width : '100%',
							height : 500,
							margin : 5,
							padding:200,
							style:{'text-align':'center'},
							imageCls:'iconInformation',
							errorMsg :'<div><b>No Data</b></div>',
						}
						//this.add(errorPanel);
						Ext.getCmp('add').hide();
						var monTree = Ext.getCmp('tableView');
						monTree.removeAll();
						monTree.update(errorpanel);
						monTree.show();
					}
				}
				else
				{
					Ext.getCmp('add').hide();
					var monTree = Ext.getCmp('tableView');
					var typeHeaderObj = Ext.getCmp('typeHeader');
					var testHeaderObj = Ext.getCmp('testHeader');
					var meaHeaderObj = Ext.getCmp('meaHeader');
					var disHeaderObj = Ext.getCmp('disHeader');
					if(!Ext.isEmpty(typeHeaderObj))
					{
						typeHeaderObj.hide();
						testHeaderObj.setWidth(195);
						meaHeaderObj.setWidth(185);
						disHeaderObj.setWidth(186);
					}
					monTree.removeAll();
					monTree.hide();
				}
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	getLayerForCompName: function(){
		var serviceComp = '-1' ;
		if(!Ext.isEmpty(Ext.getCmp('componentName')))
		{
			var v = Ext.getCmp('componentName').getValue();
			if(v=='-1' && !Ext.isEmpty(Ext.getCmp('filter')))
			{
				serviceComp = Ext.getCmp('filter').getValue();
			}
			else
			{
				var record = Ext.getCmp('componentName').findRecord(Ext.getCmp('componentName').valueField || Ext.getCmp('componentName').displayField, v);
				var index = Ext.getCmp('componentName').store.indexOf(record);
				serviceComp = Ext.getCmp('componentName').getStore().getAt(index).get('typeField');
			}

			var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&selectType=layer&isDetailPage='+isDetailPage;

			Ext.Ajax.request({
				url : urlTier,
				method : 'POST',
				scope:this,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					Ext.getCmp('layer').setValue('-1');

					if(!Ext.isEmpty(jsonData.dispLayerNameObject.dispLayerNameArray)){
						var layerForComp = Ext.getCmp('layer').getStore();
						layerForComp.loadRawData(jsonData.dispLayerNameObject.dispLayerNameArray);
					}
					//this.getTestForLayer();
				},
				failure : function()
				{
					//alert("failure");
				}
			});
		}
	},
	getLayerForComp: function () {
		var serviceComp = '-1' ;
		if(!Ext.isEmpty(Ext.getCmp('filter')))
			serviceComp = Ext.getCmp('filter').getValue();

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		if(serviceName!='-1')
		{
			if(!Ext.isEmpty(Ext.getCmp('componentType')))
				serviceComp = Ext.getCmp('componentType').getValue();
		}

		if(serviceName == '-1')
		{
			var typeHeaderObj = Ext.getCmp('typeHeader');
			var testHeaderObj = Ext.getCmp('testHeader');
			var meaHeaderObj = Ext.getCmp('meaHeader');
			var disHeaderObj = Ext.getCmp('disHeader');
			if(!Ext.isEmpty(typeHeaderObj))
			{
				typeHeaderObj.hide();
				testHeaderObj.setWidth(195);
				meaHeaderObj.setWidth(185);
				disHeaderObj.setWidth(186);
				Ext.getCmp('componentType').hide();
				Ext.getCmp('componentName').hide();
			}
		}

		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&selectType=layer&isDetailPage='+isDetailPage;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				Ext.getCmp('layer').setValue('-1');

				if(!Ext.isEmpty(jsonData.dispLayerNameObject.dispLayerNameArray)){
					var layerForComp = Ext.getCmp('layer').getStore();
					layerForComp.loadRawData(jsonData.dispLayerNameObject.dispLayerNameArray);
				}
				this.getTestForLayer();
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	getTestForLayer:function (combo,newValue,oldValue,eOpts) {
		var serviceComp = '-1';
		if(!Ext.isEmpty(Ext.getCmp('filter')))
			serviceComp = Ext.getCmp('filter').getValue();
		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		if(serviceName!='-1')
		{
			if(!Ext.isEmpty(Ext.getCmp('componentType')))
				serviceComp = Ext.getCmp('componentType').getValue();
		}

		var compLayer = Ext.getCmp('layer').getValue();
		var selectedSubject = Ext.getCmp('Category').getValue().Category;

		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&serviceName='+serviceName+'&selectedSubject='+selectedSubject+'&compLayer='+compLayer+'&selectType=test&isDetailPage='+isDetailPage;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				//Ext.getCmp('test').setValue('-1');

				var testName = Ext.getCmp('test');
				if(!Ext.isEmpty(testName))
				{
					testName.setValue('-1');
				}

				if(!Ext.isEmpty(jsonData.dispTestNameArrayObject)){
					if(!Ext.isEmpty(jsonData.dispTestNameArrayObject.dispTestNameArray)){
						if(!Ext.isEmpty(testName))
						{
							var testForLayer = testName.getStore();
							testForLayer.loadRawData(jsonData.dispTestNameArrayObject.dispTestNameArray);
						}
					}
				}
				this.getMeasureForTest();
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	getMeasureForTest: function (combo,newValue,oldValue,eOpts) {

		var selectedSubject = Ext.getCmp('Category').getValue().Category;
		//var mainCategory = Ext.getCmp('Aggregate').getValue().Aggregate;

		var serviceComp = '-1';
		if(!Ext.isEmpty(Ext.getCmp('filter')))
			serviceComp = Ext.getCmp('filter').getValue();

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		if(serviceName!='-1')
		{
			if(!Ext.isEmpty(Ext.getCmp('componentType')))
				serviceComp = Ext.getCmp('componentType').getValue();
		}

		var compLayer = Ext.getCmp('layer').getValue();

		var testName = Ext.getCmp('test').getValue();

		var serviceType = '-1';
		if(!Ext.isEmpty(Ext.getCmp('serviceType')))
			serviceType = Ext.getCmp('serviceType').getValue();

		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&serviceName='+serviceName+'&selectedSubject='+selectedSubject+'&testName='+testName+'&compLayer='+compLayer+'&selectType=measure&serviceType='+serviceType+'&isDetailPage='+isDetailPage;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				//if(!Ext.isEmpty(Ext.getCmp('measure')))
				//{
					//Ext.getCmp('measure').setValue('Please choose a measure');
				//}

				var measureObj = Ext.getCmp('measure');
				if(!Ext.isEmpty(measureObj))
				{
					measureObj.setValue('-1');
				}

				if(!Ext.isEmpty(jsonData.dispMeasureArrayObjectOne)){
					if(!Ext.isEmpty(jsonData.dispMeasureArrayObjectOne.dispMeasureArrayOne)){
						var measureForTest = Ext.getCmp('measure').getStore();
						measureForTest.loadRawData(jsonData.dispMeasureArrayObjectOne.dispMeasureArrayOne);
					}
				}
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	getServiceName: function (combo,newValue,oldValue,eOpts) {

		var monTree = Ext.getCmp('tableView');
		if(!Ext.isEmpty(monTree)){
			monTree.update('');
			monTree.hide();
			var typeHeaderObj = Ext.getCmp('typeHeader');
			var testHeaderObj = Ext.getCmp('testHeader');
			var meaHeaderObj = Ext.getCmp('meaHeader');
			var disHeaderObj = Ext.getCmp('disHeader');
			if(!Ext.isEmpty(typeHeaderObj))
			{
				typeHeaderObj.hide();
				testHeaderObj.setWidth(195);
				meaHeaderObj.setWidth(185);
				disHeaderObj.setWidth(186);
			}
		}

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		//var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp=-1&selectType=component&serviceName=New_Service&isDetailPage=true';		//original
		if(serviceName == -1 || serviceName =="undefined" )
		{
			this.loadTiersForSystem();
		}
		else
		{
			var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp=serviceName&sName='+serviceName+'&titleText=service&selectType=&perform=&isDetailPage='+isDetailPage;

			Ext.Ajax.request({
				url : urlTier,
				method : 'POST',
				scope:this,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					/*if(!Ext.isEmpty(jsonData.dispMeasureArrayObjectTwo.dispMeasureArrayTwo)){
						var filterByComponent = Ext.getCmp('filter').getStore();
						filterByComponent.loadRawData(jsonData.dispMeasureArrayObjectTwo.dispMeasureArrayTwo);
					}
					if(!Ext.isEmpty(jsonData.treeData)){
					var monTree = Ext.getCmp('tableView');
					monTree.update(jsonData.treeData);
					monTree.show();
					}*/
				},
				failure : function()
				{
					//alert("failure");
				}
			});
		}
	},
	getComponentForService: function (combo,newValue,oldValue,eOpts) {
		//Ext.getCmp('modify').show();

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		var serviceComp = '-1';
		if(!Ext.isEmpty(Ext.getCmp('filter')))
			serviceComp = Ext.getCmp('filter').getValue();

		//var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&selectType=component&serviceName='+serviceName+'&isDetailPage=true'; //original

		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp=serviceName&sName='+serviceName+'&titleText=service&selectType=&perform=&isDetailPage='+isDetailPage;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				Ext.getCmp('filter').setValue('-1');

				if(!Ext.isEmpty(jsonData.dispMeasureArrayObjectTwo.dispMeasureArrayTwo)){
					var filterByComponent = Ext.getCmp('filter').getStore();
					filterByComponent.loadRawData(jsonData.dispMeasureArrayObjectTwo.dispMeasureArrayTwo);
				}
				//this.getInfoForService();
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	addfn: function (button) {
		var filterValue = Ext.getCmp('filter').getValue();
		var serviceTypeValue = Ext.getCmp('serviceType').getValue();
		var serviceValue = Ext.getCmp('service').getValue();

		var configValue = Ext.getCmp('service').getValue();

		if(configValue == '-1')
			configValue='Default';
		else
			configValue='Specific';

		if(configValue == 'Default')
		{
			if(serviceTypeValue == '-1'|| serviceTypeValue == null ||serviceTypeValue == -1)
			{
				Ext.Msg.show({
					 title:'Alert',
					 msg: pcast,
					 buttons: Ext.Msg.OK,
					 icon: Ext.Msg.WARNING
				});
				return;
			}

			if(filterValue == '-1' || filterValue == pcact)
			{
				Ext.Msg.show({
					 title:'Alert',
					 msg: pcact,
					 buttons: Ext.Msg.OK,
					 icon: Ext.Msg.WARNING
				});
				return;
			}

			if(filterValue != '-1' && serviceTypeValue != '-1')
			{
				if(Ext.isEmpty(Ext.getCmp('addwindow')))
				{
					//Ext.getCmp('componentName').show();
					Ext.create('servicesBusinessDash.view.Addwindow').show();
				}
				else
				{
					Ext.getCmp('addwindow').destroy();
					Ext.create('servicesBusinessDash.view.Addwindow').show();
				}
				//this.getLayerForComp();
				//this.getSpecifyTo();
				//this.getMeasureForTest();

				//if(configValue == 'Specific')
					//Ext.getCmp('specifyTo').show();
			}
		}
		else if(configValue == 'Specific')
		{
		/*	if(serviceValue == '-1')
			{
				Ext.Msg.show({
						 title:'Alert',
						 msg: 'Please choose a service',
						 buttons: Ext.Msg.OK,
						 icon: Ext.Msg.WARNING
					});
			}*/

			/*if (filterValue == '-1')
			{
				Ext.Msg.show({
					title:'Alert',
					msg: pcact,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
			}
			else
			{*/
				if(Ext.isEmpty(Ext.getCmp('addwindow')))
				{
					Ext.create('servicesBusinessDash.view.Addwindow').show();
					Ext.getCmp('componentType').show();
					Ext.getCmp('componentName').show();
					this.getCompName();
					this.getLayerForComp();
					//this.getSpecifyTo();

					//if(configValue == 'Specific')
					// Ext.getCmp('specifyTo').show();
				}
				else
				{
					Ext.getCmp('addwindow').destroy();
					Ext.create('servicesBusinessDash.view.Addwindow').show();
					Ext.getCmp('componentType').show();
					Ext.getCmp('componentName').show();
					this.getCompName();
					this.getLayerForComp();
					//this.getSpecifyTo();

					//if(configValue == 'Specific')
					// Ext.getCmp('specifyTo').show();
				}
			//}
		}
	},
	measureDisplayName: function (combo,newValue,oldValue,eOpts) {
		if(!Ext.isEmpty(Ext.getCmp('displayName'))){
			var record = combo.getStore().findRecord('valueField',newValue);

			var value = Ext.getCmp('measure').getValue();
			if(value == '-1'|| value == pcam)
			{
				Ext.getCmp('displayName').setValue('');
			}
			else if(!Ext.isEmpty(record) && value != '-1')
			{
				Ext.getCmp('displayName').setValue(record.get('displayField'));
			}
		}
	},

	/*getCompNameValue: function (combo, newValue, oldValue, eOpts ) {
		if(newValue == 'CName' || newValue == 'Both')
		{
			Ext.getCmp('componentName').show();
		}
		else
		{
			Ext.getCmp('componentName').hide();
		}

	},*/
	ModifyMeasureDisplayName:function (button) {

		var rr = document.getElementById("infotbl");
		var i,count_selected=0,sel_inx=0;
		var testMeasureDisp = "";
		for(i=0;i<rr.rows.length;i++)
		{
			var classs = $j(rr.rows[i]).attr('class');
			if (classs !=null && classs !=undefined && classs == 'selected')
			{
				testMeasureDisp = testMeasureDisp+","+ $j(rr.rows[i]).attr('id');
				sel_inx=i;
				count_selected++;
			}
		}

		if(count_selected==0 || count_selected>1)
		{
			//alert("<egui:intnl text='monitor.serviceDashboard.Select any one of the row to change display name'/>");
			if(count_selected==0)
			{
				Ext.Msg.show({
					title:'Alert',
					msg: psaim,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
			}
			else if(count_selected>1)
			{
				Ext.Msg.show({
					title:'Alert',
					msg: sao,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
			}
			return false;
		}

		testMeasureDisp = testMeasureDisp.substring(1);

		var test_with_measure_tokens=testMeasureDisp.split(":");
		var temp_meas_disp_name="";
		var temp_meas_func="";
		if(test_with_measure_tokens.length==6)
		{
			temp_meas_disp_name = test_with_measure_tokens[4];
			temp_meas_func = test_with_measure_tokens[5];
		}
		else if(test_with_measure_tokens.length==5)
		{
			temp_meas_disp_name = test_with_measure_tokens[3];
			temp_meas_func = test_with_measure_tokens[4];
		}
		else
		{
			temp_meas_disp_name = test_with_measure_tokens[2];
			temp_meas_func = test_with_measure_tokens[3];
		}

		//var mainCategory = Ext.getCmp('Aggregate').getValue().Aggregate;
		var subCategory = Ext.getCmp('Category').getValue().Category;

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		var serviceComp = '-1';
		if(!Ext.isEmpty(Ext.getCmp('filter')))
			serviceComp = Ext.getCmp('filter').getValue();

		var serviceType = '-1';
		if(!Ext.isEmpty(Ext.getCmp('serviceType')))
				serviceType = Ext.getCmp('serviceType').getValue();
		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?meaDispName='+temp_meas_disp_name+'&meaFun='+temp_meas_func+'&modifyMeasure=true&selectedInx='+sel_inx+'&serviceName='+encodeURI(serviceName)+'&serviceType='+serviceType+'&subCategory='+subCategory+'&isDetailPage='+isDetailPage+'&serviceComp='+serviceComp;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				if(Ext.isEmpty(Ext.getCmp('modifywindow')))
				{
					Ext.create('servicesBusinessDash.view.modifyWindow').show();
				}
				else
				{
					Ext.getCmp('modifywindow').destroy();
					Ext.create('servicesBusinessDash.view.modifyWindow').show();
				}
				Ext.getCmp('displayName').setValue(temp_meas_disp_name);
				Ext.getCmp('functionName').setValue({functionName:jsonData.functionValue});

			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	modifyPopupClose: function (button) {

		var rr = document.getElementById("infotbl");
		var i,count_selected=0,sel_inx=0;
		var testMeasureDispOne='';

		for(i=0;i<rr.rows.length;i++)
		{
			var classs = $j(rr.rows[i]).attr('class');
			if (classs !=null && classs !=undefined && classs == 'selected')
			{
				testMeasureDispOne = testMeasureDispOne+","+ $j(rr.rows[i]).attr('id');
				sel_inx=i;
				count_selected++;
			}
		}

		var testMeasureDisp = $j(rr.rows[sel_inx]).attr('id');
		if (sel_inx!=null && testMeasureDisp!=null && testMeasureDisp!='')
		{
			var modify_id="";
			var new_mea_disp_name=Ext.getCmp('displayName').getValue();

			if (new_mea_disp_name==null || new_mea_disp_name=="" || this.checkSpecialCharacter(new_mea_disp_name)) {
				Ext.Msg.show({
							 title:'Alert',
							 msg: tipSpe,
							 buttons: Ext.Msg.OK,
							 icon: Ext.Msg.WARNING
						});
				return false;
			}

			var temp_meas_func=Ext.getCmp('functionName').getValue().functionName;
			var test_with_measure_tokens=testMeasureDisp.split(":");
			if(new_mea_disp_name!=null && temp_meas_func!=null && test_with_measure_tokens!=null)
			{
				if(test_with_measure_tokens.length==6)
				{
					modify_id=test_with_measure_tokens[0]+":"+test_with_measure_tokens[1]+":"+test_with_measure_tokens[2]+":"+test_with_measure_tokens[3]+":"+new_mea_disp_name+":"+temp_meas_func;
				}
				else if(test_with_measure_tokens.length==5)
				{
					modify_id=test_with_measure_tokens[0]+":"+test_with_measure_tokens[1]+":"+test_with_measure_tokens[2]+":"+new_mea_disp_name+":"+temp_meas_func;
				}
				else
				{
					modify_id=test_with_measure_tokens[0]+":"+test_with_measure_tokens[1]+":"+new_mea_disp_name+":"+temp_meas_func;
				}

				if(modify_id!=null && modify_id!=undefined && modify_id!="")
				{
					$j(rr.rows[sel_inx]).attr('id',modify_id);
					Ext.getCmp('modifywindow').close();
					this.updatefn();
				}
			}
			else
			{
				Ext.getCmp('modifywindow').close();
			}
		}
		else
		{
			Ext.getCmp('modifywindow').close();
		}
	},
	clickUpdate:function(button)
	{
		if(isServRmvReordr && isUserConfig)
		{
			var itemSelObj = Ext.getCmp('servicesmullist');
			var fromFieldObj = itemSelObj.fromField.store;
			var toFieldObj = itemSelObj.toField.store;
			var assocServ = '';
			var skipServ = '';
			for (var s=0; s < fromFieldObj.getCount();s++)
			{
				var newVal = fromFieldObj.getAt(s).get('valueField');
				if(newVal!=null && newVal!='' && newVal!='undefined')
					assocServ += newVal+',';
			}
			for (var s=0; s < toFieldObj.getCount();s++)
			{
				var newVal = toFieldObj.getAt(s).get('valueField');
				if(newVal!=null && newVal!='' && newVal!='undefined')
					skipServ += newVal+',';
			}
			Ext.Ajax.request({
			url : '/final/monitor/serviceBusinessConfigp.jsp?serviceComp=userConfig&isUserServices=true'+"&assocServ="+encodeURI(assocServ)+"&skipServices="+encodeURI(skipServ)+"&com.eg.CSRF_NONCE="+csrfToken,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(!Ext.isEmpty(jsonData.userServConfigs) && jsonData.userServConfigs=='Updated')
				{
					var VWidth = Ext.Element.getViewportWidth( );
					var userConfigObj=Ext.getCmp('configId');
					if(!Ext.isEmpty(userConfigObj))
					{
						userConfigObj.enable(true);
						this.getConfigWindow().destroy();
						var configMod=Ext.getCmp('configMod');
						if(!Ext.isEmpty(configMod)){
							configMod.destroy();
						}
						userConfigObj.winCon.hide();
						this.renderMain();
					}
				}
			},
			failure : function(){
				//alert("failure");
			}
			});
		}
		else
		{
			var serviceComp = '-1';
			if(!Ext.isEmpty(Ext.getCmp('filter')))
				serviceComp = Ext.getCmp('filter').getValue();
			var selectedSubject = Ext.getCmp('Category').getValue().Category;
			var measurePerform = Ext.getCmp('Category').getValue().Category;
			var serviceName = '-1';
			if(!Ext.isEmpty(Ext.getCmp('service')))
				serviceName = Ext.getCmp('service').getValue();
			if(serviceName!='-1')
			{
				if(!Ext.isEmpty(Ext.getCmp('componentType')))
					serviceComp = Ext.getCmp('componentType').getValue();
			}
			var serviceType = '-1';
			if(!Ext.isEmpty(Ext.getCmp('serviceType')))
				serviceType = Ext.getCmp('serviceType').getValue();
			var combinedMeasure = $j('#hiddenResult').val();
			//var mainCategory = Ext.getCmp('Aggregate').getValue().Aggregate;
			var topTiers=$j("#DefaultTiers").val();
			if(topTiers == undefined || topTiers == -1)
			{
				topTiers="";
			}
			var jj = $j('#infotbl tr.ids').val();
			var rr = document.getElementById("infotbl");
			var i;
			var testMeasureDisp = "";
			if(!Ext.isEmpty(rr))
			{
				for(i=0;i<rr.rows.length;i++)
				{
					testMeasureDisp = testMeasureDisp+","+ $j(rr.rows[i]).attr('id');
				}
				testMeasureDisp = testMeasureDisp.substring(1);
			}
			var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&multiselect='+encodeURI(testMeasureDisp)+'&selectedSubject='+selectedSubject+'&serviceName='+serviceName+'&selectType=Update&topTiers='+topTiers+'&measurePerform='+measurePerform+'&serviceType='+serviceType+'&isDetailPage='+isDetailPage;
			var strDetailsPage='<%=isDetailPage%>';
			Ext.Ajax.request({
				url : urlTier,
				method : 'POST',
				scope:this,
				success : function(response, opts){
					//if(serviceName==null || serviceName==undefined || serviceName=='-1')
					//{
						this.getInfoForCompNew();
					//}
					//else if(serviceTypes==null || serviceTypes==undefined || serviceTypes=='-1' || serviceComp=='-1' || (strDetailsPage=='true' && serviceComp!='-1'))
					//{
						this.getInfoForServiceNew(true);
					//}
					$j('#hiddenResult').val('');
				},
				failure : function()
				{
					//alert("failure");
				}
			});
		}
	},
	updatefn:function (button) {

		var serviceComp = '-1';
		if(!Ext.isEmpty(Ext.getCmp('filter')))
			serviceComp = Ext.getCmp('filter').getValue();

		var selectedSubject = Ext.getCmp('Category').getValue().Category;
		var measurePerform = Ext.getCmp('Category').getValue().Category;

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		if(serviceName!='-1')
		{
			if(!Ext.isEmpty(Ext.getCmp('componentType')))
				serviceComp = Ext.getCmp('componentType').getValue();
		}

		var serviceType = '-1';
		if(!Ext.isEmpty(Ext.getCmp('serviceType')))
			serviceType = Ext.getCmp('serviceType').getValue();

		var combinedMeasure = $j('#hiddenResult').val();
		//var mainCategory = Ext.getCmp('Aggregate').getValue().Aggregate;
		var topTiers=$j("#DefaultTiers").val();

		if(topTiers == undefined || topTiers == -1)
		{
			topTiers="";
		}

		var jj = $j('#infotbl tr.ids').val();
		var rr = document.getElementById("infotbl");
		var i;
		var testMeasureDisp = "";
		if(!Ext.isEmpty(rr))
		{
			for(i=0;i<rr.rows.length;i++)
			{
				testMeasureDisp = testMeasureDisp+","+ $j(rr.rows[i]).attr('id');
			}
			testMeasureDisp = testMeasureDisp.substring(1);
		}

		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&multiselect='+encodeURI(testMeasureDisp)+'&selectedSubject='+selectedSubject+'&serviceName='+encodeURI(serviceName)+'&selectType=Update&topTiers='+topTiers+'&measurePerform='+measurePerform+'&serviceType='+serviceType+'&isDetailPage='+isDetailPage;

		var strDetailsPage='<%=isDetailPage%>';

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				//if(serviceName==null || serviceName==undefined || serviceName=='-1')
				//{
					this.getInfoForCompNew();
				//}
				//else if(serviceTypes==null || serviceTypes==undefined || serviceTypes=='-1' || serviceComp=='-1' || (strDetailsPage=='true' && serviceComp!='-1'))
				//{
					this.getInfoForServiceNew(false);
				//}
				$j('#hiddenResult').val('');
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	deletefn:function(button) {

		//var  configValue =  Ext.getCmp('Configuration').getValue().Config;
		//var mainCategory = Ext.getCmp('Aggregate').getValue().Aggregate;
		var configValue = Ext.getCmp('service').getValue();

		if(configValue == '-1')
			configValue='Default';
		else
			configValue='Specific';

		var measurePerform = Ext.getCmp('Category').getValue().Category;
		var topTiers="";

		var serviceComp = '-1';
		if(!Ext.isEmpty(Ext.getCmp('filter')))
			serviceComp = Ext.getCmp('filter').getValue();

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		var serviceType = '-1';
		if(!Ext.isEmpty(Ext.getCmp('serviceType')))
			serviceType = Ext.getCmp('serviceType').getValue();

		if( serviceType == '-1')
		{
			Ext.Msg.show({
				title:'Alert',
				msg: pcast,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			});
		}
		var jj = $j('#infotbl tr.ids').val();
		var rr = document.getElementById("infotbl");
		var i;
		var testMeasureDisp = "";

		if(Ext.isEmpty(rr))
		{
			if(configValue == 'Default' && serviceType == '-1')
			{
				Ext.Msg.show({
					title:'Alert',
					msg: pcast,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				return false;
			}
			else if(configValue == 'Specific' && serviceName == '-1')
			{
				Ext.Msg.show({
					title:'Alert',
					msg: pcas,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				return false;
			}
		}
		else
		{
			var count_selected=0,sel_inx=0;
			if(!Ext.isEmpty(rr.rows))
			{
				for(i=0;i<rr.rows.length;i++)
				{
					var classs = $j(rr.rows[i]).attr('class');
					if (classs !=null && classs !=undefined && classs == 'selected')
					{
						//testMeasureDisp = testMeasureDisp+","+ $j(rr.rows[i]).attr('id');
						//sel_inx=i;
						count_selected++;
					}
				}
			}
			if((count_selected==0 || count_selected>1))
			{
				if(count_selected==0)
				{
					Ext.Msg.show({
						title:'Alert',
						msg: psaid,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					});
				}
				else if(count_selected>1)
				{
					Ext.Msg.show({
						title:'Alert',
						msg: saod,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					});
				}
				return false;
			}
			for(i=0;i<rr.rows.length;i++)
			{
				var classs = $j(rr.rows[i]).attr('class');
				if (classs !=null && classs !=undefined && classs == 'selected')
				{
					testMeasureDisp = testMeasureDisp+","+ $j(rr.rows[i]).attr('id');
				}
			}
		}


		testMeasureDisp = testMeasureDisp.substring(1);
		var tempTestMeasureDisp = testMeasureDisp.toString();

		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&multiselect='+tempTestMeasureDisp+'&serviceName='+encodeURI(serviceName)+'&selectType=multidelet&topTiers='+topTiers+'&perform=Delete&selectedSubject='+measurePerform+'&isDetailPage='+isDetailPage+'&serviceType='+serviceType+'&measurePerform='+measurePerform;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				//this.getInfo();
				this.getLatestInfo();
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	newSelection:function(){

		var ss = $j('#infotbl tr');

		var testMeasureDispOne='';
		$j('body').on('click','#infotbl tr',function(){
			//Ext.getCmp('delete').show();
			//Ext.getCmp('modify').show();
			$j(this).toggleClass("selected");
			$j('#infotbl').tableDnD();

			var rr = document.getElementById("infotbl");
			var i,count_selected=0;

			for(i=0;i<rr.rows.length;i++)
			{
				var classs = $j(rr.rows[i]).attr('class');
				if (classs !=null && classs !=undefined && classs == 'selected')
				{
					count_selected++;
				}
			}

			if(count_selected > 0)
			{
				Ext.getCmp('delete').show();
				Ext.getCmp('modify').show();
			}
			else
			{
				Ext.getCmp('delete').hide();
				Ext.getCmp('modify').hide();
			}
		});
	},

	getCompName: function () {

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		var serviceComp = '-1';

		if(serviceName=='-1')
		{
			if(!Ext.isEmpty(Ext.getCmp('filter')))
				serviceComp = Ext.getCmp('filter').getValue();
		}
		else
		{
			if(!Ext.isEmpty(Ext.getCmp('componentType')))
				serviceComp = Ext.getCmp('componentType').getValue();
		}

		var serviceType = '-1';
		if(!Ext.isEmpty(Ext.getCmp('serviceType')))
			serviceType = Ext.getCmp('serviceType').getValue();


		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&selectType=component&serviceName='+encodeURI(serviceName)+'&isDetailPage='+isDetailPage+'&serviceType='+serviceType;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				if(!Ext.isEmpty(Ext.getCmp('componentName')))
				{
					Ext.getCmp('componentName').setValue('-1');
					if(!Ext.isEmpty(jsonData.componentObject)){
						var compNameValue = Ext.getCmp('componentName').getStore();
						compNameValue.loadRawData(jsonData.componentObject.componentArray);
					}
				}
				else
				{
					if(!Ext.isEmpty(Ext.getCmp('componentName')))
					{
						Ext.getCmp('componentName').setValue('-1');
					}
				}
			},

		});
	},
	checkSpecialCharacter: function (name) {
        var splChar = "%#&+:,'$=\"";

        for (var i = 0; i < name.length; i++) {
            check_char = splChar.indexOf(name.charAt(i))
            //Returns value 1 if the special character listed in splChar is found
            if (check_char >= 0) {
                return true;
            }
        }
        return false;
    },
	appendData: function (button) {			// add function for Add window

		var testName = Ext.getCmp('test').getValue();
		var layerName = Ext.getCmp('layer').getValue();
		var compValue=Ext.getCmp('componentName').getValue();

		var configValue = Ext.getCmp('service').getValue();

		if(configValue == '-1')
			configValue='Default';
		else
			configValue='Specific';
		var serviceMeasure=Ext.getCmp('measure').getValue();
		var temp_val="";
		if(layerName == undefined || layerName == -1)
		{
			Ext.Msg.show({
						 title:'Alert',
						 msg: pcal,
						 buttons: Ext.Msg.OK,
						 icon: Ext.Msg.WARNING
					});
			return false;
		}
		if(testName == undefined || testName == -1)
		{
			Ext.Msg.show({
						 title:'Alert',
						 msg: pcat,
						 buttons: Ext.Msg.OK,
						 icon: Ext.Msg.WARNING
					});
			return false;
		}

		if(serviceMeasure == undefined || serviceMeasure == -1 || serviceMeasure == pcam)
		{
			Ext.Msg.show({
						 title:'Alert',
						 msg: pcam,
						 buttons: Ext.Msg.OK,
						 icon: Ext.Msg.WARNING
					});
			return false;
		}

		var serviceComp=Ext.getCmp('filter').getValue();
		if(configValue != '-1')
		{
			serviceComp=Ext.getCmp('componentType').getValue();
			if(serviceComp != '-1')
			{
				if(serviceComp!=null && serviceComp!=undefined && serviceComp!='-1')
				{
					temp_val = "CT^"+serviceComp+":";
				}
			}
		}

		var compName=Ext.getCmp('componentName').getValue();
		if(compName != '-1')
		{
			if(compName!=null && compName!=undefined && compName!='-1')
			{
				if(compName.indexOf(":")>-1)
					compName=compName.substring(0,compName.indexOf(":"));

				if(compName !="-1")
					temp_val = temp_val+"CN^"+compName+":";
			}
		}

		var testDispName =  Ext.getCmp('test').getValue();
		var measDispName =  Ext.getCmp('measure').getValue();
		var serviceDispName=Ext.getCmp('displayName').getValue();

		if (serviceDispName==null || serviceDispName=="" || this.checkSpecialCharacter(serviceDispName)) {
			Ext.Msg.show({
						 title:'Alert',
						 msg: tipSpe,
						 buttons: Ext.Msg.OK,
						 icon: Ext.Msg.WARNING
					});
			return false;
		}

		var multiselect = $j("#associated").val();

		if(serviceMeasure == undefined || serviceMeasure == -1)
		{
			temp_val = temp_val+testName+":"+serviceMeasure;
		}
		else
		{
			temp_val = temp_val+testName+":"+serviceMeasure+":"+serviceDispName;
		}

		var TestFunc= Ext.getCmp('function').getValue().functionName;
		temp_val = temp_val+":"+TestFunc;

		var rr = document.getElementById("infotbl");
		var i;
		var testMeasureDisp = "";

		if(!Ext.isEmpty(rr))
		{
			for(i=0;i<rr.rows.length;i++)
			{
				testMeasureDisp = testMeasureDisp+","+ $j(rr.rows[i]).attr('id');
			}
		}
		testMeasureDisp = testMeasureDisp.substring(1);

		var combinedMeasure = $j('#hiddenResult').val();

		combinedMeasure = combinedMeasure+","+temp_val;
		$j('#hiddenResult').val(combinedMeasure);
		combinedMeasure = $j('#hiddenResult').val();
		if(testMeasureDisp != null && testMeasureDisp != undefined && testMeasureDisp != "" )
		{
			if(testMeasureDisp.indexOf(temp_val) == -1)
			{
				var appRow = "";
				if(serviceComp != '-1')
				{
					appRow = "<tr id='"+temp_val+"' height='30px'><td width='25%'>"+serviceComp+"</td><td width='25%'>"+testDispName+"</td><td width='25%'>"+measDispName+"</td><td width='25%'>"+serviceDispName+"</td></tr>";
				}
				else
				{
					appRow = "<tr id='"+temp_val+"' height='30px'><td width='30%'>"+testDispName+"</td><td width='30%'>"+measDispName+"</td><td width='30%'>"+serviceDispName+"</td></tr>";
				}

				var rowCount = $j('#infotbl tr').length;
				if(rowCount == 0)
				{

					$j('#infotbl').append(appRow);
				}
				else
				{
					$j('#infotbl tr:last').after(appRow);
				}

				isAddClicked = true;
				//this.measureForDelete();
			}
			else
			{
				isAddClicked = true;
				//this.measureForDelete();
			}
			this.measureForDelete();
		}
		else if(testMeasureDisp == null ||  testMeasureDisp == "" || testMeasureDisp.indexOf(serviceMeasure) == -1)
		{
			var appRow = "";
			if(serviceComp != '-1')
			{
				appRow = "<tr id='"+temp_val+"' height='30px'><td width='25%'>"+serviceComp+"</td><td width='25%'>"+testDispName+"</td><td width='25%'>"+measDispName+"</td><td width='25%'>"+serviceDispName+"</td></tr>";
			}
			else
			{
				appRow = "<tr id='"+temp_val+"' height='30px'><td width='30%'>"+testDispName+"</td><td width='30%'>"+measDispName+"</td><td width='30%'>"+serviceDispName+"</td></tr>";
			}
			//var appRow = "<tr id='"+temp_val+"' height='30px'><td width='30%'>"+testDispName+"</td><td width='30%'>"+measDispName+"</td><td width='30%'>"+serviceDispName+"</td></tr>";
			var rowCount = $j('#infotbl tr').length;
			if(rowCount == 0)
				$j('#infotbl').append(appRow);
			else
				$j('#infotbl tr:last').after(appRow);

			isAddClicked = true;
			this.measureForDelete();
		}
		this.getMeasureForTest();
		Ext.getCmp('displayName').setValue('');
	},
	popupClose: function (button) {

		var testName = Ext.getCmp('test').getValue();
		var serviceMeasure=Ext.getCmp('measure').getValue();

		if(serviceMeasure == null || serviceMeasure =="" || serviceMeasure == "-1" || serviceMeasure == pcam)
		{
			var combinedMeasure = $j('#hiddenResult').val();
			this.updatefn();
			//hideElement("propertyDiv");
		}
		else
		{
			var temp_val="";
			if(testName == undefined || testName == -1)
			{
				Ext.Msg.show({
						 title:'Alert',
						 msg: pcat,
						 buttons: Ext.Msg.OK,
						 icon: Ext.Msg.WARNING
					});
				return false;
			}
			if(serviceMeasure == undefined || serviceMeasure == -1)
			{
				Ext.Msg.show({
						 title:'Alert',
						 msg: pcam,
						 buttons: Ext.Msg.OK,
						 icon: Ext.Msg.WARNING
					});
				return false;
			}

			var configValue = Ext.getCmp('service').getValue();

			//var componentSpecFul=Ext.getCmp('specifyTo').getValue();
			var serviceComp=Ext.getCmp('filter').getValue();
			if(configValue != '-1')
			{
				serviceComp=Ext.getCmp('componentType').getValue();
				if(serviceComp != '-1')
				{
					if(serviceComp!=null && serviceComp!=undefined && serviceComp!='-1')
					{
						temp_val = "CT^"+serviceComp+":";
					}
				}
			}
			var compName=Ext.getCmp('componentName').getValue();
			if(compName != '-1')
			{
				if(compName!=null && compName!=undefined && compName!='-1')
				{
					if(compName.indexOf(":")>-1)
						compName=compName.substring(0,compName.indexOf(":"));

					if(compName !="-1")
						temp_val = "CN^"+compName+":";
				}
			}

			var testDispName =  Ext.getCmp('test').getValue();
			var measDispName =  Ext.getCmp('measure').getValue();

			var serviceDispName=Ext.getCmp('displayName').getValue();

			if (serviceDispName==null || serviceDispName=="" || this.checkSpecialCharacter(serviceDispName)) {
				Ext.Msg.show({
							 title:'Alert',
							 msg: tipSpe,
							 buttons: Ext.Msg.OK,
							 icon: Ext.Msg.WARNING
						});
				return false;
			}

			if(serviceMeasure == undefined || serviceMeasure == -1)
			{
				temp_val = temp_val+testName+":"+serviceMeasure;
			}
			else
			{
				temp_val = temp_val+testName+":"+serviceMeasure+":"+serviceDispName;
			}

			var TestFunc= Ext.getCmp('function').getValue().functionName;
			temp_val = temp_val+":"+TestFunc;

			var rr = document.getElementById("infotbl");
			var i;
			var testMeasureDisp = "";
			if(!Ext.isEmpty(rr))
			{
				for(i=0;i<rr.rows.length;i++)
				{
					testMeasureDisp = testMeasureDisp+","+ $j(rr.rows[i]).attr('id');
				}
			}

			testMeasureDisp = testMeasureDisp.substring(1);
			var combinedMeasure = $j('#hiddenResult').val();
			combinedMeasure = combinedMeasure+","+temp_val;
			$j('#hiddenResult').val(combinedMeasure);
			if(testMeasureDisp != null && testMeasureDisp != undefined && testMeasureDisp != "" )
			{
				if(testMeasureDisp.indexOf(temp_val) == -1)
				{
					var appRow = "";
					if(configValue != '-1')
					{
						appRow = "<tr id='"+temp_val+"' height='30px'><td width='25%'>"+serviceComp+"</td><td width='25%'>"+testDispName+"</td><td width='25%'>"+measDispName+"</td><td width='25%'>"+serviceDispName+"</td></tr>";
					}
					else
					{
						appRow = "<tr id='"+temp_val+"' height='30px'><td width='30%'>"+testDispName+"</td><td width='30%'>"+measDispName+"</td><td width='30%'>"+serviceDispName+"</td></tr>";
					}
					var rowCount = $j('#infotbl tr').length;
					if(rowCount == 0)
						$j('#infotbl').append(appRow);
					else
						$j('#infotbl tr:last').after(appRow);

					isAddClicked = true;
					this.measureForDelete();
				}
				else
				{
					isAddClicked = true;
					this.measureForDelete();
				}
			}
			else if(testMeasureDisp == null ||  testMeasureDisp == "" || testMeasureDisp.indexOf(temp_val) == -1)
			{
				var appRow = "";
				if(configValue != '-1')
				{
					appRow = "<tr id='"+temp_val+"' height='30px'><td width='25%'>"+serviceComp+"</td><td width='25%'>"+testDispName+"</td><td width='25%'>"+measDispName+"</td><td width='25%'>"+serviceDispName+"</td></tr>";
				}
				else
				{
					appRow = "<tr id='"+temp_val+"' height='30px'><td width='30%'>"+testDispName+"</td><td width='30%'>"+measDispName+"</td><td width='30%'>"+serviceDispName+"</td></tr>";
				}
				
				var rowCount = $j('#infotbl tr').length;
				if(rowCount == 0)
					$j('#infotbl').append(appRow);
				else
					$j('#infotbl tr:last').after(appRow);

				isAddClicked = true;
				this.measureForDelete();
			}
			Ext.getCmp('addwindow').hide();
		}
		Ext.getCmp('addwindow').hide();
		this.updatefn();
	},
	measureForDelete: function () {

		var serviceComp = '-1' ;
		if(!Ext.isEmpty(Ext.getCmp('filter')))
			serviceComp = Ext.getCmp('filter').getValue();

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		var serviceType = '-1';
		if(!Ext.isEmpty(Ext.getCmp('serviceType')))
			serviceType = Ext.getCmp('serviceType').getValue();

		var selectedSubject = Ext.getCmp('Category').getValue().Category;
		var testName = Ext.getCmp('test').getValue();
		var compLayer = Ext.getCmp('layer').getValue();
		//var mainCategory = Ext.getCmp('Aggregate').getValue().Aggregate;

		var hiddenResult = $j('#hiddenResult').val();

		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&serviceName='+serviceName+'&selectedSubject='+selectedSubject+'&testName='+testName+'&compLayer='+compLayer+'&selectType=measureupdate&pagefrom=multidelete&hiddenResult='+hiddenResult+'&isDetailPage='+isDetailPage+'&serviceType='+serviceType;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				if(!Ext.isEmpty(Ext.getCmp('measure')))
				{
					Ext.getCmp('measure').setValue('Please choose a measure');
					//Ext.getCmp('measure').setValue('-1');
				}

				if(!Ext.isEmpty(jsonData.dispMeasureArrayObject.dispMeasureArray))
				{
					var measureForTest = Ext.getCmp('measure').getStore();
					measureForTest.loadRawData(jsonData.dispMeasureArrayObject.dispMeasureArray);
				}
				this.updatefn();
			},
			failure : function()
			{
				//alert("failure");
			}
		});
	},
	radioChangeFunction: function () {
		//var configValue = Ext.getCmp('Configuration').getValue().Config;


		var configValue = Ext.getCmp('service').getValue();

		if(configValue == '-1')
			configValue='Default';
		else
			configValue='Specific';

		/*var monTree = Ext.getCmp('tableView');
		if(!Ext.isEmpty(monTree)){
			monTree.update('');
			monTree.hide();
		}*/


		if(configValue == 'Default')
		{
			//this.getCompTypesForServiceType();
			this.getServiceTypesForMainCategory();
			var monTree = Ext.getCmp('tableView');
			monTree.removeAll();
			monTree.update('');
			monTree.show();

		}
		else if (configValue == 'Specific')
		{
			this.getServiceTypesForMainCategory();
			this.getInfoForService();
		}
	},
	getInfo: function () {

		var configValue = Ext.getCmp('service').getValue();

		if(configValue == '-1')
		{
			this.updatefn();
			this.getInfoForComp();
		}
		else
		{
			this.getInfoForService();
		}
	},
	getLatestInfo: function () {
		var configValue = Ext.getCmp('service').getValue();
		if(configValue == '-1')
		{
			this.getInfoForComp();
		}
		else
		{
			this.getInfoForService();
		}
	},
	tableEmpty : function () {
		var serviceName = Ext.getCmp('service').getValue();
		if( serviceName == '-1')
		{
			var monTree = Ext.getCmp('tableView');
			monTree.removeAll();
			monTree.update('');
			monTree.show();
		}
	},
	getInfoForCompNew: function () {

		if(!Ext.isEmpty(Ext.getCmp('Category')))
			var measurePerform = Ext.getCmp('Category').getValue().Category;

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		var serviceType = '-1';
		if(!Ext.isEmpty(Ext.getCmp('serviceType')))
			serviceType = Ext.getCmp('serviceType').getValue();

		var serviceComp = '-1' ;
		if(!Ext.isEmpty(Ext.getCmp('filter')))
		{
			serviceComp = Ext.getCmp('filter').getValue();

			if (serviceComp != '-1' && serviceComp != 'Not Applicable !')
			{
				Ext.getCmp('add').show();
			}
		}
		var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&measurePerform='+measurePerform+'&serviceName='+encodeURI(serviceName)+'&selectType=info&serviceType='+serviceType+'&isDetailPage='+isDetailPage;

		Ext.Ajax.request({
			url : urlTier,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var filterByValue = '';
				if(!Ext.isEmpty(Ext.getCmp('filter')))
					filterByValue = Ext.getCmp('filter').getValue();

				if(!Ext.isEmpty(jsonData.treeData))
				{
					var monTree = Ext.getCmp('tableView');
				//	Ext.getCmp('modify').show();

					monTree.update(jsonData.treeData);
					monTree.show();
				}
				else
				{
					var errorPanelOne = {
						xtype : 'errorpanel',
						width : '100%',
						height : 500,
						margin : 5,
						padding:200,
						style:{'text-align':'center'},
						imageCls:'iconInformation',
						errorMsg :'<div><b>No Data</b></div>',
					};
					//this.add(errorPanel);
					var monTree = Ext.getCmp('tableView');
					monTree.removeAll();
					monTree.update(errorPanelOne);
					monTree.show();
				}
			},
			failure : function(){
				//alert("failure");
			}
		});
	},
	getInfoForServiceNew: function (fromFlag) {

		me=this;
		if(!Ext.isEmpty(Ext.getCmp('Category')))
			var measurePerform = Ext.getCmp('Category').getValue().Category;

		var serviceName = '-1';
		if(!Ext.isEmpty(Ext.getCmp('service')))
			serviceName = Ext.getCmp('service').getValue();

		var serviceType = '-1';
		if(!Ext.isEmpty(Ext.getCmp('serviceType')))
			serviceType = Ext.getCmp('serviceType').getValue();

		var serviceComp = '-1' ;
		if(!Ext.isEmpty(Ext.getCmp('filter')))
			serviceComp = Ext.getCmp('filter').getValue();

			var urlTier='/final/monitor/serviceBusinessConfigp.jsp?serviceComp='+serviceComp+'&measurePerform='+measurePerform+'&serviceName='+encodeURI(serviceName)+'&selectType=InfoForService&serviceType='+serviceType+'&isDetailPage='+isDetailPage;

			Ext.Ajax.request({
				url : urlTier,
				method : 'POST',
				scope:this,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					if(!Ext.isEmpty(jsonData.treeData)){
						var monTree = Ext.getCmp('tableView');
						monTree.removeAll();
						monTree.update(jsonData.treeData);
						monTree.show();
						//Ext.getCmp('modify').show();
					}
					else
					{
						var errorPanel = {
							xtype : 'errorpanel',
							width : '100%',
							height : 500,
							margin : 5,
							padding:200,
							style:{'text-align':'center'},
							imageCls:'iconInformation',
							errorMsg :'<div><b>No Data</b></div>',
						}
						//this.add(errorPanel);
						var monTree = Ext.getCmp('tableView');
						monTree.removeAll();
						monTree.update(errorpanel);
						monTree.show();
					}

					if(fromFlag)
					{
						var task = new Ext.util.DelayedTask(function() {
							var configIdObj=Ext.getCmp('configId');
							if(!Ext.isEmpty(configIdObj) && configIdObj.winCon!=null && configIdObj.winCon!=undefined)
							{
								configIdObj.winCon.hide();
								configIdObj.winCon=null;
								configIdObj.enable(true);
								$j('body').off( "click",'#infotbl tr'); 
								me.getConfigWindow().destroy();
								var configMod=Ext.getCmp('configMod');
								if(!Ext.isEmpty(configMod)){
									configMod.destroy();
								}
								me.renderMain();
							}
						});
						task.delay(500);
					}
				},
				failure : function()
				{
					//alert("failure");
				}
			});
	}
});