Ext.define('servicesBusinessDash.view.ConfigWindow',{
	extend:'Ext.window.Window',
	alias:'widget.configwindow',
	//requires:['Ext.form.RadioGroup','Ext.form.field.Radio'],
	//requires:['ScrollPanel'],
	//title:titleConfig,
	bodyBorder:false,
	id:'configwindow',
	cls:'tabsetsettingsWindow measure-graph-panel',	
	frame:true,
	header:false,
	autoScroll:true,
	//closable:true,
	//width:610,
	//height:470,
	flotable:false,
	floating:false,
	bodyPadding:10,
	autoScroll:false,
	scroll:false,
	buttonAlign : 'center',
	defaults:{
			labelSeparator:'',
			margin:'8 0 0 0'
	},
	items: [
	{
			xtype:'combo',
			cls:'dropdown',
			name:'serviceset',
			id:'serviceset',
			labelWidth: 180,
			width:480,
			editable:false,
			fieldLabel:setngLbl,
			hidden:true,
			displayField:'displayField',
			valueField:'valueField',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['displayField','valueField'],
			})
	},
	{
			xtype:'combo',
			cls:'dropdown',
			name:'service',
			id:'service',
			labelWidth: 180,
			width:470,
			editable:false,
			fieldLabel:appliesTo,
			displayField:'displayField',
			valueField:'valueField',
			queryMode:'local',
			//hidden:true,
			store:Ext.create('Ext.data.Store',{
				fields:['displayField','valueField'],
			
			})
	},{
			xtype: 'radiogroup',
			baseCls:'radiobt',
			fieldLabel:column,
			itemId: 'Category',
			id:'Category',
			labelWidth: 180,
			items: [
				{
					xtype: 'radiofield',
					boxLabel: demand,
					checked: true,
					name:'Category',
					inputValue:'Demand',
					width:100
				},
				{
					xtype: 'radiofield',
					boxLabel:consumption ,
					name:'Category',
					inputValue:'Consumption',
					width:120
				},
				{
					xtype: 'radiofield',
					boxLabel:quality ,
					name:'Category',
					inputValue:'Quality',
					width:100
				},
			]
	},
	{
				xtype:'combo',
				cls:'dropdown',
				name:'serviceType',
				id:'serviceType',
				labelWidth:180,
				width:470,
				editable:false,
				fieldLabel:serviceTypeLabel,
				displayField:'displayField',
				valueField:'valueField',
				queryMode:'local',
				store:Ext.create('Ext.data.Store',{
					fields:['displayField','valueField'],
				})
		
	},
	{
				xtype:'combo',
				cls:'dropdown',
				name:'filter',
				id:'filter',
				labelWidth: 180,
				width:470,
				editable:false,
				fieldLabel:filterByLabel,
				displayField:'displayField',
				valueField:'valueField',
				queryMode:'local',
				store:Ext.create('Ext.data.Store',{
					fields:['displayField','valueField'],
				
				}),
			
	},
	{
			xtype:'container',
			border:true,
			//layout:'fit',
			padding:0,
			cls:'dataview',
			name:'dataviewId',
			id:'dataviewId',
			margin:'8 0 0 0',
			cls:'panelWithoutHeader',
			items:[
				{
					xtype:'container',
					layout:'hbox',
					margin:0,
					width:590,
					items:[{
							xtype:'container',
							id:'typeHeader',
							width:150,
							cls:'header_col first',
							html:typeLabel
						},{
							xtype:'container',
							width:160,
							id:'testHeader',
							cls:'header_col',
							html:testLabel
						},{
							xtype:'container',
							width:150,
							id:'meaHeader',
							cls:'header_col',
							html:measureLabel
						},{
							xtype:'container',
							width:105,
							id:'disHeader',
							cls:'header_col last',
							html:displayLabel
						}]
				},
				{
					xtype:'panel',
					height:160,
					autoScroll:true,
					//style:{'border':'1px solid red'},
					scroll:true,
					id:'tableView',
					layout:'vbox',
					itemId:'tableView'
				}
			]
	},
	{
		xtype: 'itemselector',
		cls:'multiselect',
		id:'servicesmullist',
		hidden:true,
		buttonsText: {
			add: btnRmvTxt,
			remove: btnAddTxt,
			top:btnMvTop,
			up: btnMvUp,
			down: btnMvDwn,
			bottom:btnMvBtm
		},
		store: new Ext.data.Store({
			fields: ['displayField','valueField'],
			data: []
		}),
		queryMode : 'local',
		displayField: 'displayField',
		valueField: 'valueField',
		height: 250,
		margin:'10 10 10 50',
		width: 450,
		fromTitle: fromTitleTxt,
		toTitle: toTitleTxt,
	
		setupItems: function() {
			var me = this;

			me.fromField = me.createList(me.fromTitle);
			me.toField = me.createList(me.toTitle);

			return {
				border: false,
				layout: {
					type: 'hbox',
					align: 'stretch'
				},
				items: [
					{
						xtype: 'container',
						margins: '0 10',
						padding:0,
						style:{'padding':'0px !important'},
						layout: {
							type: 'vbox',
							pack: 'center'
						},
						items: me.createCustomButtons('left')
					},
					me.fromField,
					{
						xtype: 'container',
						margins: '0 10',
						padding:0,
						layout: {
							type: 'vbox',
							pack: 'center'
						},
						items: me.createCustomButtons('center')
					},
					me.toField
				]
			};
		},

		createCustomButtons: function(position){
			var me = this,
				buttons = [];

			if (!me.hideNavIcons) {
				Ext.Array.forEach(me.buttons, function(name) {
					if ((name == 'add' || name == 'remove') && position == 'center')
					{
						buttons.push({
							xtype: 'button',
							tooltip: me.buttonsText[name],
							handler: me['on' + Ext.String.capitalize(name) + 'BtnClick'],
							cls: Ext.baseCSSPrefix + 'form-itemselector-btn',
							iconCls: Ext.baseCSSPrefix + 'form-itemselector-' + name,
							navBtn: true,
							scope: me,
							width:16,
							height:16,
							style:{'padding':'0px !important'},
							margin: '4 0 0 0'
						});
					}
					else if (name != 'add' && name != 'remove' && position == 'left')
					{
						buttons.push({
							xtype: 'button',
							tooltip: me.buttonsText[name],
							handler: me['on' + Ext.String.capitalize(name) + 'BtnClick'],
							cls: Ext.baseCSSPrefix + 'form-itemselector-btn',
							iconCls: Ext.baseCSSPrefix + 'form-itemselector-' + name,
							navBtn: true,
							scope: me,
							width:16,
							height:16,
							style:{'padding':'0px !important'},
							margin: '4 0 0 0'
						});
					}
				});
			}
			return buttons;
		},
	
		onTopBtnClick : function() {
			var list = this.fromField.boundList,
				store = list.getStore(),
				selected = this.getSelections(list);

			store.suspendEvents();
			store.remove(selected, true);
			store.insert(0, selected);
			store.resumeEvents();
			list.refresh();
			this.syncValue();
			list.getSelectionModel().select(selected);
		},

		onBottomBtnClick : function() {
			var list = this.fromField.boundList,
				store = list.getStore(),
				selected = this.getSelections(list);

			store.suspendEvents();
			store.remove(selected, true);
			store.add(selected);
			store.resumeEvents();
			list.refresh();
			this.syncValue();
			list.getSelectionModel().select(selected);
		},

		onUpBtnClick : function() {
			var list = this.fromField.boundList,
				store = list.getStore(),
				selected = this.getSelections(list),
				rec,
				i = 0,
				len = selected.length,
				index = 0;

			// Move each selection up by one place if possible
			store.suspendEvents();
			for (; i < len; ++i, index++) {
				rec = selected[i];
				index = Math.max(index, store.indexOf(rec) - 1);
				store.remove(rec, true);
				store.insert(index, rec);
			}
			store.resumeEvents();
			list.refresh();
			this.syncValue();
			list.getSelectionModel().select(selected);
		},

		onDownBtnClick : function() {
			var list = this.fromField.boundList,
				store = list.getStore(),
				selected = this.getSelections(list),
				rec,
				i = selected.length - 1,
				index = store.getCount() - 1;

			// Move each selection down by one place if possible
			store.suspendEvents();
			for (; i > -1; --i, index--) {
				rec = selected[i];
				index = Math.min(index, store.indexOf(rec) + 1);
				store.remove(rec, true);
				store.insert(index, rec);
			}
			store.resumeEvents();
			list.refresh();
			this.syncValue();
			list.getSelectionModel().select(selected);
		} 
	}
	],
	dockedItems:[
	{
		 xtype: 'toolbar',
		ui:'footer',
		layout:{
			pack:'center'
		 },
		defaults:{
			xtype:'button'
		 },
        dock: 'bottom',
        items: [{
				text:updateLabe,
				cls:'quickMenuWhiteButton',
				action: 'Update',
				id:'update',
				margin:'6 0 0 5',
			},{
				text:addLabel,
				cls:'quickMenuWhiteButton',
				action: 'Add',
				id:'add',
				margin:'6 0 0 5',
				hidden:true
			},{
				text:modifyLabel,
				cls:'quickMenuWhiteButton',
				action: 'Modify',
				id:'modify',
				margin:'6 0 0 5',
				//disabled:true 
				hidden:true
				
			},{
				text:deleteLabel,
				cls:'quickMenuWhiteButton',
				action: 'Delete',
				margin:'6 0 0 5',
				hidden:true, 
				id:'delete'
			}]		
	}			
	],
	
	initComponent : function() {
		this.callParent();
		
	},
	/*listeners:{
        close:function(){
			servicesBusinessDash.app.getController('Main').updatefn();
			servicesBusinessDash.app.getController('Main').renderMain();
		}
	}*/
});




