Ext.define('servicesGroup.controller.Main', {
    extend: 'Ext.app.Controller',
    requires:['servicesGroup.view.ServiceUsers'],
    views:['servicesGroup.view.Main','servicesGroup.view.BlockPanel','servicesGroup.view.serviceGroupComponent'],
//    stores:['servicesGroup.store.ServiceUsers'],
    refs:[{
    	ref:'blockPanel',
		selector:'blockpanel'
    },{
    	ref:'listPanel',
		selector:'listpanel'
    },{
    	ref:'main',
    	selector:'main'
    },{
    	ref:'serviceusers',
    	selector:'serviceusers'
    }],

    init: function(){
    //setInterval("execute()",refreshFrequency);
	   this.control({
       		'blockpanel customtrigger' : {
       			specialkey: this.triggerClick
       		},
			'listpanel customtrigger' : {
       			specialkey: this.triggerClick
       		},
       		'blockpanel':{
       			render : function(){
					var urlStr='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceGroup&action=serviceGroup&serviceGroup='+requestParams.serviceGroup;
					if(requestParams!=null && requestParams!=undefined && requestParams.searchString!=null && requestParams.searchString!=undefined && requestParams.searchString!='null')
					{
						urlStr='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceGroup&action=search&serviceGroup='+requestParams.serviceGroup+'&searchString='+requestParams.searchString;
					}
       				Ext.Ajax.request({
       					url:urlStr,
       					method : 'POST',
       					scope:this,
       					success : function(response, opts){
       						var jsonText = response.responseText;
       						var jsonData = Ext.decode(jsonText);

       						if(!Ext.isEmpty(jsonData.error)){
       								var searchNoList =  Ext.create('utilities.ErrorPanel',{
										style:{'border':'0px !important'},
										border:false,
										margin:'0 10 0 10',
							errorMsg : '<div style="text-align:center;margin:14% auto"><img src="/final/images/clear.png" class="iconInformation" /><br/><div class="list-empty-text">'+jsonData.error+'</div></div>'
						});
						this.add(searchNoList);
       						}
       						else{
       							this.getBlockPanel().removeAll();
       							/*this.getBlockPanel().addTool({
       								xtype : 'button',
       								text:requestParams.backButtonText,
       								action:'back',
       								cls:'back-btn',
       								iconCls:'back-btn-icon'
       							});*/
								this.getBlockPanel().populateBlockPanel(jsonData,"",false);
								this.getBlockPanel().down('customtrigger').setTrigStatus(true);
								setInterval("execute()",jsonData.screenLabels['refreshFrequency']);
       						}
       					},
       					failure : function(){alert("failure");}
       				});
       			}
       		},

       		'blockpanel button[action=association]' : {
       			click: this.loadAssociations,
       		},

			'listpanel button[action=association]' : {
       			click: this.loadAssociations,
       		},

       		'serviceusers':{
       			cellclick :{
       				fn : function( thisss, td, cellIndex, record, tr, rowIndex, e, eOpts ){

       				if(cellIndex==0 && e.target.outerHTML.substring(0,2)=='<a'){
       					var controller=servicesGroup.app.getController('Main');
       					controller.populateCommon(e.target.innerText);
       				}
       			}
       			}
       		},
       		'blockpanel button[action=back]':{
       			click:this.backButtonHandler
       		},
       		'listpanel button[action=back]':{
       			click:this.backButtonHandler
       		}
	   });
	},

	triggerClick:function(field, e){
		if (e.getKey() == e.ENTER) {
			this.getPanel().down('customtrigger').setTrigStatus(true);
			this.populateCommon(field.getValue());
		}
	},

	backButtonHandler:function(btn){
		var treeSession=requestParams.treeSession;
		var backButtonFunction="";
		treeSession=(!Ext.isEmpty(treeSession))? treeSession:"";
		if(treeSession.indexOf("showDashboard")>0 )
		{
			backButtonFunction=treeSession;
		}
		if(this.getPanel().down('serviceusers')){
			window.history.go(0);
			return;
		}
		if(backButtonFunction.length>0)
		{
			document.location=backButtonFunction;
		}
		else
		{
			if(!Ext.isEmpty(requestParams.refresh) && requestParams.refresh=="true")
			{
				window.history.go(-2);
			}
			else
			{
				window.history.go(-1);
			}
		}

	},
	populateAssociation : function(){
		 Ext.Ajax.request({
			url : "/final/servlet/com.eg.EgMonitorController?monCmd=userServices&from=serviceGroup",
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
			//	jsonData.error = 'Nothing to display';
				//testing of error message to be done.
				if(!Ext.isEmpty(jsonData.error)){
					this.getBlockPanel().removeAll();
					var noServiceGroup =  this.errorPanel(jsonData.error);
					this.getBlockPanel().add(noServiceGroup);
				}
				else{
					this.getBlockPanel().removeAll();

					this.getBlockPanel().add({
						xtype : 'serviceusers' ,
						columnWidth: 1,
						screenLabels : jsonData.screenLabels,
						data : jsonData
					  });
					//this.getBlockPanel().child('serviceusers').getStore().loadRawData(jsonData);

				}
			}
		});
	},

	populateCommon:function(value){
		var searchValue;
		if(this.getPanel().down('customtrigger')!=null && this.getPanel().down('customtrigger')!=undefined)
		{
			if(this.getPanel().down('customtrigger').getTrigStatus()){
				searchValue = value;
			}
			else{
				searchValue = '';
			}
			if(value=='')
				this.getPanel().down('customtrigger').setTrigStatus(false);
		}

		var urlStr='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&action=search&from=serviceGroup&searchString='+searchValue+'&Go.x=7&Go.y=12';
		if((searchValue==null || searchValue=="") && requestParams!=null && requestParams!=undefined && requestParams.searchString!=null && requestParams.searchString!=undefined && requestParams.searchString!='null')
		{
			urlStr='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceGroup&action=search&searchString='+requestParams.searchString+'&Go.x=7&Go.y=12';
		}

		Ext.Ajax.request({
			url :  urlStr,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				//this.getPanel().removeAll();
				if(this.getPanel().getXType() == 'blockpanel'){
					if(!Ext.isEmpty(jsonData.screenLabels.error)){
						this.getPanel().populateBlockPanel(jsonData,value,true);
							var searchNoList =  Ext.create('utilities.ErrorPanel',{
							style:{'border':'0px !important'},
							border:false,
							margin:'0 10 0 10',
							errorMsg : '<div style="text-align:center;margin:14% auto"><img src="/final/images/clear.png" class="iconInformation" /><br/><div class="list-empty-text">No Service Groups found</div></div>'
						});
						this.getPanel().add(searchNoList);
						//this.getPanel().add(noServiceGroup);
					}
					else{
						this.getPanel().removeAll();
						this.getPanel().populateBlockPanel(jsonData,value,false);
					}
				}
				else{

					this.getPanel().removeAll();
					this.getPanel().tools = [];
					this.getPanel().loadServiceGroupList(jsonData,value,Ext.isEmpty(jsonData.screenLabels.error));
				}
			},
			failure : function(){alert("failure");}
		});
	},

	errorPanel:function(errorMsg){
		return {
			//cls:'errorPanelTop',
			border : false,
			width : '100%',
			//height : 500,
			//style:{'border':'1px solid red'},
			margin : 5,
			//padding:200,
			html : '<div style="border:0px solid blue;width:200px;text-align:center;margin:18% 0 auto 40%"><div class="iconInformation" style="margin-left:80px"></div><div class="list-empty-text service-testing">'+errorMsg+'</div></div>'
		};
	},

	refresh:function(refreshURL){
		var blockPanel=this.getPanel();
		if(!Ext.isEmpty(blockPanel)){
			if(blockPanel.down('serviceusers')){
				this.populateAssociation();
			}
			else{
				if(!Ext.isEmpty(this.getPanel()))
				{
					var searchText="";
					if(this.getPanel().down('customtrigger')!=null)
					{
						searchText=this.getPanel().down('customtrigger').value;
					}
					this.populateCommon(searchText);
				}
			}
		}
	},

	loadAssociations:function(){
		Ext.getCmp('iconAutomaticScrollRun').hide();
		Ext.Element.select('.removeLineForTvMode').hide();
		Ext.getCmp('iconAutomaticScrollJumpToTop').hide();

		var me = this;
		Ext.Ajax.request({
			url : "/final/servlet/com.eg.EgMonitorController?monCmd=userServices&from=serviceGroup",
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);


				Ext.getCmp('serviceGroupTrigger').hide();

				if(Ext.getCmp('customTrigger')!=null)
				{
					Ext.getCmp('customTrigger').hide();
				}
				Ext.getCmp('backbuttonId').show();



				var panel = me.getPanel();
				if(!Ext.isEmpty(jsonData.error)){
					panel.removeAll();
					var noServiceGroup =  this.errorPanel(jsonData.error);
					panel.add(noServiceGroup);
				}
				else{
					panel.removeAll();
					if(!Ext.isEmpty(panel.getDockedComponent('serviceGroupToolbar')))
					{
						panel.removeDocked(panel.getDockedComponent('serviceGroupToolbar'),true);
					}

					panel.setTitle(jsonData.screenLabels["title"]? jsonData.screenLabels["title"] : "");
					panel.add({
						xtype : 'serviceusers' ,
						columnWidth: 1,
						screenLabels : jsonData.screenLabels,
						data : jsonData
					});
					setInterval("execute()",jsonData.screenLabels['refreshFrequency']);
				}
			}
		});
	},

	getPanel:function(){
		var panel;
		if(!Ext.isEmpty(this.getBlockPanel()))
			panel = this.getBlockPanel();
		else if(!Ext.isEmpty(this.getListPanel()))
			panel = this.getListPanel();
		return panel;
	},

	 displayError:function(error){
		//this.getPanel().removeAll();
		this.getPanel().addTool({
			xtype : 'button',
			text:requestParams.backButtonText,
			hidden: hideBackButton,
			action:'back',
			cls:'back-btn',
			iconCls:'back-btn-icon'
		});
		//var noServiceGroup = this.errorPanel(error);
		//this.getPanel().add(noServiceGroup);
			var searchNoList =  Ext.create('utilities.ErrorPanel',{
							style:{'border':'0px !important'},
							border:false,
							margin:'20 10 10 10',
							errorMsg : '<div style="text-align:center;margin:14% auto"><img src="/final/images/clear.png" class="iconInformation" /><br/><div class="list-empty-text">'+error+'</div></div>'
						});
						this.getPanel().add(searchNoList);
		if(!Ext.isEmpty(this.getPanel().mask)){
			this.getPanel().mask.hide();
		}
	}
});