Ext.define('servicesGroup.view.BlockPanel', {
	extend : 'utilities.ScrollPanel',
	requires : ['Ext.layout.container.Column','servicesGroup.view.serviceGroupComponent','servicesGroup.view.customTrigger','servicesGroup.view.ListPanel'],
	alias : 'widget.blockpanel',
	bodyCls:' services-borderzero service-testing',
	cls:'outerpanel',
	frame:true,
	border:true,
	id:'blockPanelId',
	layout: {
        type: 'vbox',
        align: 'stretch'
    },
	//margin:10,
	//padding : 10,
	url : null,
	mask: null,
	items : [],
	initComponent : function(){
		this.callParent();
	},
	listeners:{
		boxready:function(){

		}
	},
	populateBlockPanel : function(jsonData,searchValue,isEmpty){
		this.removeAll();
		this.setTitle(jsonData.screenLabels["ServiceText"]? jsonData.screenLabels["ServiceText"] : "Service Groups");
		var triggerObject = Ext.getCmp('serviceGroupTrigger');

		var showIcons=(jsonData.error!=null || jsonData.errorObj.error!=null)?true:false;
		if(Ext.isEmpty(triggerObject)){
			this.addTool([
			{
				xtype : 'button',
				cls:'iconAutomaticScrollRun',
				id:'iconAutomaticScrollRun',
				//text:'Click to Automatic Scroll 111',
				margin: '0px 4px 0px 4px',
				ui: 'action',
				hidden:true,
				border:true,
				style: {
					border: '0px'
				},
				handler:function(){
					scrollFlag=true;
					pageScroll();
					Ext.getCmp('iconAutomaticScrollRun').hide();
					//Ext.getCmp('iconAutomaticScrollStop').show();
				},
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							autoDestroy:true,
							html: 'Auto Scroll'
						});
					}
				}
			},{
				xtype : 'button',
				cls:'iconAutomaticScrollStop',
				id:'iconAutomaticScrollStop',
				margin: '0px 4px 0px 4px',
				ui: 'action',
				hidden:true,
				style: {
					border: '1px'
				},
				handler:function(){
					scrollFlag=false;
					stopScroll();
					Ext.getCmp('iconAutomaticScrollStop').hide();
					//Ext.getCmp('iconAutomaticScrollRun').show();
				},
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							autoDestroy:true,
							html: 'Pause'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				cls:'removeLineForTvMode',
				hidden:true,
			},{
				xtype : 'button',
				cls:'iconAutomaticScrollJumpToTop',
				id:'iconAutomaticScrollJumpToTop',
				margin: '0px 4px 0px 4px',
				ui: 'action',
				hidden:true,
				style: {
					border: '0px'
				},
				handler:function(){
					scrollFlag=false;
					jumpScroll();
					Ext.getCmp('iconAutomaticScrollStop').hide();
					//Ext.getCmp('iconAutomaticScrollRun').show();
				},
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							autoDestroy:true,		//
							html: 'Jump to top'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				cls:'removeLineForTvMode',
				hidden:true,
			},
			{
				xtype : 'customtrigger',
				id:'serviceGroupTrigger',
				cls : 'whitedropdown_search component-list-right-panel-header-right',
				emptyText : jsonData.screenLabels["searchText"] ? jsonData.screenLabels["searchText"] : "",
				value : searchValue,
				hidden:showIcons,
				onTriggerClick : function(e){
					var controller=servicesGroup.app.getController('Main');
					this.setTrigStatus(true);
					controller.populateCommon(this.getValue());
				}
			},{
				xtype: 'tbseparator',
				hidden:showIcons,
			},{
				xtype : 'button',
				id:'customTrigger',
				cls:'iconAssociation',
				hidden : (isEmpty || showIcons),
				action: 'association',
				tooltip : associationsToolTip,
				 style: {
					margin: '0px 0px 0px 0px',
					border: '0px'
				}
			},{
				xtype: 'tbseparator',
				id:'customTriggerSeparator',
				hidden:showIcons,
				hidden: hideBackButton
			},{
				xtype:'button',
				text:requestParams.backButtonText,
				action:'back',
				cls:'backbutton',
				id:'backbuttonId',
				height:22,
				iconCls:'iconBack',
				hidden: hideBackButton
				//iconCls:'back-btn-icon'
			},]);
		}
		else{
			if(isEmpty){
				this.down('button[id=customTrigger]').hide();
				//this.down('tbseparator[id=customTriggerSeparator]').hide();
			}
			else{
				this.down('button[id=customTrigger]').show();
				//this.down('tbseparator[id=customTriggerSeparator]').show();
			}
		}

		if(!isEmpty)
		{
			var serviceGroupHolder = Ext.create('utilities.ScrollPanel',{
				layout : 'column',
				bodyCls:'service-testing',
				border : false,
				margin:10,
			});
			var blockArray = new Array();
			for(var i=0;i<jsonData.serviceData.length;i++){
				blockArray.push({
					xtype:'serviceGroupComponent',
					jsonData : jsonData.serviceData[i],
					width:255,
					padding:'0 0 0 0'
				});
			}
			serviceGroupHolder.add(blockArray);
			this.add(serviceGroupHolder);

			/*  ADDEd FOR GRID AND LISTVIEW */
				var meBlockPanel=this;
				Ext.defer(function(){
					servicesGroupListBtn = Ext.create('Ext.container.Container',{
					layout: {
						type: 'hbox'
					},
					width: 100,
					margin:'0 0 3 10',
					//text:'Group View',
					renderTo:'servicesGroupView',
					items: [{
							xtype: 'button',
							cls:'iconGroupViewDisable removeButtonCurve',

						},{
							xtype: 'button',
							cls:'iconListView removeButtonCurve',
							action:'servicegroupGroupViewChange',
							 listeners: {
								afterrender: function () {
									Ext.create('Ext.tip.ToolTip', {
										target: this.id,
										anchor: 'top',
										cls: 'yellowTip',
										trackMouse: true,
										html: listViewToolTip
									});
								}
							},
							 handler: meBlockPanel.servicegroupGroupViewChange
						}]
					});
					},500);

			if(jsonData.screenLabels["ServiceText"])
			{
				var htm = '<div style="float:left;text-transform: uppercase;">'+jsonData.screenLabels["ServiceText"]+'</div><div style="float:left;margin-top:-3px" id="servicesGroupView"></div>';
				this.setTitle(htm);
			}
			else
			{
				this.setTitle('<div style="float:left;">Service Groups</div><div style="float:left;margin-top:-3px" id="servicesGroupView"></div>');
				var searchNoList =  Ext.create('utilities.ErrorPanel',{
							flex:1,
							layout:{
								type:'fit',
							},
							style:{'border':'0px !important'},
							border:false,
							margin:'0 10 10 10',
						errorMsg : '<div style="text-align:center;margin:14% auto"><img src="/final/images/clear.png" class="iconInformation" /><br/><div class="list-empty-text">No service groups found</div></div>',
							listeners:{
								boxready:function(){
									var scrollRun = Ext.getCmp('iconAutomaticScrollRun');
									if (!Ext.isEmpty(scrollRun) )
									{
										scrollRun.hide();
									}
									ScrollJumpToTop = Ext.getCmp('iconAutomaticScrollJumpToTop');
									if (!Ext.isEmpty(ScrollJumpToTop) )
									{
										ScrollJumpToTop.hide();
									}
									Ext.Element.select('.removeLineForTvMode').hide();
								}
							}
				});
				this.add(searchNoList);
				this.doLayout();
			}
			delete servicesGroupListBtn;
		}
		this.doLayout();
		if ($('#blockPanelId-body')[0].scrollHeight > $('#blockPanelId-body').innerHeight())
			{
				//Ext.Element.select('.removeLineForTvMode').show();
				//Ext.getCmp('iconAutomaticScrollRun').show();
				//Ext.getCmp('iconAutomaticScrollJumpToTop').show();
			}
			else
			{
				Ext.getCmp('iconAutomaticScrollRun').hide();
				Ext.Element.select('.removeLineForTvMode').hide();
				Ext.getCmp('iconAutomaticScrollJumpToTop').hide();
			}
		if(!Ext.isEmpty(this.mask)){
			this.mask.hide();
		}
	},
servicegroupGroupViewChange: function()
	{

localStorage.setItem('serviceoptionallistpanel', '2');

		if(Ext.isEmpty(requestParams.treeOpen) || requestParams.treeOpen==="null" ){
			requestParams.treeOpen=false;
		}else if(requestParams.treeOpen==="true"){
			requestParams.treeOpen=true;
		}else{
			requestParams.treeOpen=false;
		}
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
	var servicesGroup=Ext.getCmp('servicesGroup');

	var contentPanel={
				xtype:'listpanel',
				bodyCls: 'service-testing',
				mask: mask,
				region: 'center',
				url: '/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceGroup&action=serviceGroup',
			};


	servicesGroup.removeAll();
	servicesGroup.add(contentPanel);
	servicesGroup.doLayout();
	//Ext.widget('optionallistpanel',{region:'center',flex:4,url : '/final/monitor/zones.jsp'}).show();
	}
});

