var getDiv=0;
var scrollFlag=false;

Ext.define('servicesGroup.view.ListPanel', {
	extend: 'utilities.OuterPanel',
	requires : ['servicesGroup.view.ListComponent'],
	alias : 'widget.listpanel',
	layout : 'fit',
	cls:'outerpanel',
	margin:0,
	frame:true,
	border:true,
	id:'listPanelId',
	showDashboard:false,
	autoDestroy:true,
	url : null,
	autoScroll:true,
	layout:{
		type:'vbox',
		align:'stretch',
	},
	listeners:{
		boxready:function(){

		}
	},
	mask:null,
	items : [],
	initComponent : function(){
		var me = this;
		var urlStr=me.url;
		if(requestParams!=null && requestParams!=undefined && requestParams.searchString!=null && requestParams.searchString!=undefined && requestParams.searchString!='null')
		{
			urlStr='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceGroup&action=search&serviceGroup='+requestParams.serviceGroup+'&searchString='+requestParams.searchString;
		}

		Ext.Ajax.request({
			url :urlStr,
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(!Ext.isEmpty(jsonData.errorObj.error)){

					this.tools = [];
					//this.removeAll(true);
					servicesGroup.app.getController('Main').displayError(jsonData.errorObj.error);
					this.setTitle('Services Groups');
					Ext.defer(function(){
					servicesGroupListBtn = Ext.create('Ext.container.Container',{
					layout: {
						type: 'hbox'
					},
					width: 100,
					margin:'-3 0 3 10',
					//text:'Group View',
					renderTo:'servicesGroupView',
					items: [{
							xtype: 'button',
							cls:'iconGroupView removeButtonCurve',
							listeners: {
								afterrender: function () {
									Ext.create('Ext.tip.ToolTip', {
										target: this.id,
										anchor: 'top',
										cls: 'yellowTip',
										trackMouse: true,
										html: 'Grid View'
									});
								}
							},
							handler: me.servicegroupViewChange
						},{
							xtype: 'button',
							cls:'iconListViewDisable removeButtonCurve',
						}]
					});
					},500);

		if(jsonData.screenLabels["ServiceText"]){
			var htm = '<div style="float:left;text-transform: uppercase;">Service Groups</div><div style="float:left;margin-top:-3px" id="servicesGroupView"></div>';
			me.setTitle(htm);
		}else{
			me.setTitle('<div style="float:left;text-transform: uppercase;">Service Groups</div><div style="float:left;margin-top:-3px" id="servicesGroupView"></div>');
			}
		delete servicesGroupListBtn;

				}
				else{
					this.tools = [];
					this.removeAll(true);
					this.loadServiceGroupList(jsonData,'',Ext.isEmpty(jsonData.screenLabels.error));
				}
				if ($('#listPanelId-body')[0].scrollHeight > $('#listPanelId-body').innerHeight())
				{
					//Ext.Element.select('.removeLineForTvMode').show();
					//Ext.getCmp('iconAutomaticScrollRun').show();
					//Ext.getCmp('iconAutomaticScrollJumpToTop').show();
				}
				else
				{
					var scrollRun = Ext.getCmp('iconAutomaticScrollRun');
					if (!Ext.isEmpty(scrollRun) )
					{
						scrollRun.hide();
					}
					ScrollJumpToTop = Ext.getCmp('iconAutomaticScrollJumpToTop');
					if (!Ext.isEmpty(ScrollJumpToTop) )
					{
						ScrollJumpToTop.hide();
					}
					Ext.Element.select('.removeLineForTvMode').hide();
				}
			},
			failure : function(){alert("failure");}
		});
		this.callParent();
	},

	loadServiceGroupList: function(jsonData,searchValue,hideAssociation){
		var me = this;
		var listTrigger = Ext.getCmp('serviceGroupTrigger');
		if(Ext.isEmpty(listTrigger)){
			this.addTool([
			{
				xtype : 'button',
				cls:'iconAutomaticScrollRun',
				id:'iconAutomaticScrollRun',
				//text:'Click to Automatic Scroll 111',
				margin: '0px 4px 0px 4px',
				ui: 'action',
				hidden:true,
				border:true,
				style: {
					border: '0px'
				},
				handler:function(){
					scrollFlag=true;
					pageScroll();
					Ext.getCmp('iconAutomaticScrollRun').hide();
					//Ext.getCmp('iconAutomaticScrollStop').show();
				},
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							autoDestroy:true,
							html: 'Auto Scroll'
						});
					}
				}
			},{
				xtype : 'button',
				cls:'iconAutomaticScrollStop',
				id:'iconAutomaticScrollStop',
				margin: '0px 4px 0px 4px',
				ui: 'action',
				hidden:true,
				style: {
					border: '1px'
				},
				handler:function(){
					scrollFlag=false;
					stopScroll();
					Ext.getCmp('iconAutomaticScrollStop').hide();
					//Ext.getCmp('iconAutomaticScrollRun').show();
				},
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							autoDestroy:true,
							html: 'Pause'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				cls:'removeLineForTvMode',
				hidden:true,
			},{
				xtype : 'button',
				cls:'iconAutomaticScrollJumpToTop',
				id:'iconAutomaticScrollJumpToTop',
				margin: '0px 4px 0px 4px',
				ui: 'action',
				hidden:true,
				style: {
					border: '0px'
				},
				handler:function(){
					scrollFlag=false;
					jumpScroll();
					Ext.getCmp('iconAutomaticScrollStop').hide();
					//Ext.getCmp('iconAutomaticScrollRun').show();
				},
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							autoDestroy:true,		//
							html: 'Jump to top'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				cls:'removeLineForTvMode',
				hidden:true,
			},
			{
				xtype : 'customtrigger',
				cls : 'whitedropdown_search',
				id:'serviceGroupTrigger',
				emptyText : jsonData.screenLabels["searchText"] ? jsonData.screenLabels["searchText"] : "",
				value : searchValue,
				onTriggerClick : function(e){
					var controller=servicesGroup.app.getController('Main');
					this.setTrigStatus(true);
					controller.populateCommon(this.getValue());
				}
			},{
				xtype: 'tbseparator'
			},{
				xtype : 'button',
				id:'customTrigger',
				cls:'iconAssociation',
				hidden : !hideAssociation,
				action: 'association',
				tooltip : 'Associations',
				style: {
					margin: '0px 0px 0px 0px',
					border: '0px'
				}
			},{
				xtype: 'tbseparator',
				id:'customTriggerSeparator',
				hidden: hideBackButton
			},{
				xtype:'button',
				text:requestParams.backButtonText,
				action:'back',
				cls:'backbutton',
				id:'backbuttonId',
				height:22,
				iconCls:'iconBack',
				hidden: hideBackButton
				//iconCls:'back-btn-icon'
			}]);

			me.addDocked({
				xtype : 'toolbar',
				itemId:'serviceGroupToolbar',
				cls : 'component-list-right-panel-header component-list-right-panel-header-right',
				layout : 'hbox',
				margin:0,
				padding:0,
				flex : 1,
				hidden:!hideAssociation,
				items : [{
					xtype : 'label',
					text : 'Service Group Name',
					width :200,
					padding:'2px 5px 2px 10px'
				},{
					xtype:'label',
					width:2,
					height:22,
					padding:0,
					cls:'service_header',
					style:'left:200px !important;',
				}, {
					xtype : 'label',
					text : 'Services Associated with Group',
					padding:'2px 5px 2px 6px',
					flex:1
				}]
			});
		}
		else{
			if(!hideAssociation){
				this.down('button[id=customTrigger]').hide();
				//this.down('tbseparator[id=customTriggerSeparator]').hide();
				//this.down('toolbar[itemId=serviceGroupToolbar]').hide();
			}
			else{
				this.down('button[id=customTrigger]').show();
				//this.down('tbseparator[id=customTriggerSeparator]').show();
				//this.down('toolbar[itemId=serviceGroupToolbar]').show();
			}
		}
//alert('LIST----');

		Ext.defer(function(){
					servicesGroupListBtn = Ext.create('Ext.container.Container',{
					layout: {
						type: 'hbox'
					},
					width: 100,
					margin:'0 0 3 10',
					//text:'Group View',
					renderTo:'servicesGroupView',
					items: [{
							xtype: 'button',
							cls:'iconGroupView removeButtonCurve',
							listeners: {
								afterrender: function () {
									Ext.create('Ext.tip.ToolTip', {
										target: this.id,
										anchor: 'top',
										cls: 'yellowTip',
										trackMouse: true,
										html: 'Grid View'
									});
								}
							},
							handler: me.servicegroupViewChange
						},{
							xtype: 'button',
							cls:'iconListViewDisable removeButtonCurve',
						}]
					});
					},500);

		if(jsonData.screenLabels["ServiceText"]){
			var htm = '<div style="float:left;text-transform: uppercase;">'+jsonData.screenLabels["ServiceText"]+'</div><div style="float:left;margin-top:-3px" id="servicesGroupView"></div>';
			me.setTitle(htm);
		}else{
			me.setTitle('<div style="float:left;text-transform: uppercase;">Service Groups</div><div style="float:left;margin-top:-3px" id="servicesGroupView"></div>');
			}
		delete servicesGroupListBtn;

		if(!Ext.isEmpty(jsonData.screenLabels.error)){
			me.removeAll();
			var searchNoList =  Ext.create('utilities.ErrorPanel',{
				style:{'border':'0px !important'},
				border:false,
				margin:'0 10 0 10',
				errorMsg : '<div style="text-align:center;margin:14% auto"><img src="/final/images/clear.png" class="iconInformation" /><br/><div class="list-empty-text">No Service Groups found</div></div>',
				listeners:{
					boxready:function(){
						var scrollRun = Ext.getCmp('iconAutomaticScrollRun');
						if (!Ext.isEmpty(scrollRun) )
						{
							scrollRun.hide();
						}
						ScrollJumpToTop = Ext.getCmp('iconAutomaticScrollJumpToTop');
						if (!Ext.isEmpty(ScrollJumpToTop) )
						{
							ScrollJumpToTop.hide();
						}
						Ext.Element.select('.removeLineForTvMode').hide();
					}
				}
			});
			me.add(searchNoList);
		} else {
			var listPanelContents = Ext.create('utilities.ScrollPanel', {
				layout:{
					type:'vbox',
					align:'stretch'
				},
				cls : 'list-panel-contents',
				bodyCls:'service-testing services-borderzero',
				border : false,
				items : [],
				id:'listPanelInner',

				handlePercentWidthsAfterScroll:function(){
					//for the inner div
					$('.jspPane').css({
						'width': '100%'
					});

					$('.jspPane > .x-box-inner').css({
						'width': '100%'
					});

					//for the presentation div
					$('.jspPane > .x-box-inner > div').css({
						'width': '100%'
					});

					$('.jspPane .list-component').css({
						'width': '100%'
					});
					//body
					$('.jspPane .list-component > div').css({
						'width': '100%'
					});
					//presentation
					$('.jspPane .list-component > div > div').css({
						'width': '100%'
					});
					$('.jspPane .list-component > div > div > div').css({
						'width': '100%'
					});

					$('.jspPane .component-list-right').each(function() {
						var wd=$(this).outerWidth(true);
						wd+=-10;
						$(this).css({
							'width':wd+'px'
						});
						var rightPanel=$(this).find('.x-panel-body');
						rightPanel.css({
							'width':wd+'px'
						});
						var rightPanels=rightPanel.find('.x-panel-header');
						$(rightPanels).each(function(){
							var wt=$(this).outerWidth(true);
							wt+=-10;
							$(this).css({
								'width':wt+'px'
							});
						});
					});
				}
			});

			var rootComponentArray = jsonData["serviceData"];
			for(var componentCounter = 0 ; componentCounter < rootComponentArray.length ; componentCounter++){
			var servListCls='servicelist-component';
			if(componentCounter%2==0)
			{
				servListCls='servicegroupalt';
			}
				var listComponent = Ext.create('servicesGroup.view.ListComponent',{
					rootComponent : rootComponentArray[componentCounter],
					cls : servListCls,
				});
				listPanelContents.add(listComponent);
			}
			me.add(listPanelContents);
		}
		if(!Ext.isEmpty(me.mask)){
			me.mask.hide();
		}
		this.doLayout();
	},
	servicegroupViewChange: function()
	{
		divArray=null;

localStorage.setItem('serviceoptionallistpanel', '1');
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
	var servicesGroup=Ext.getCmp('servicesGroup');


	var contentPanel={
					xtype:'blockpanel',
					bodyCls: 'service-testing',
					mask: mask,
					region: 'center',
					url: '/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=serviceGroup&action=serviceGroup',
					};
			//var Mainpanel=[contentPanel];
	servicesGroup.removeAll();
	servicesGroup.add(contentPanel);
	servicesGroup.doLayout();
	//Ext.widget('optionallistpanel',{region:'center',flex:4,url : '/final/monitor/zones.jsp'}).show();
	}
});
