var errorPanel = false;
Ext.define('sessionSimulation.controller.Main', {
    extend: 'Ext.app.Controller',
    views:['sessionSimulation.view.SessionSimulation','sessionSimulation.view.Main'],
	refs:[
	{
		ref:'main',
		selector:'main'
	},
	{
		ref:'myTimeWindow',
		selector:'floatingContainer'
	},
	{
		ref:'myTimelinePanel',
		selector:'floatingContainer > panel'
	},
	{
		ref : 'transactionComboMode',
		selector : 'floatingContainer > panel > combo[itemId= "mode"]'
	},
	{
		ref : 'transactionComboTimeline',
		selector : 'floatingContainer > panel > combo[itemId= "timeline"]'
	},
	{
		ref : 'transactionComboFromhr',
		selector : 'floatingContainer > panel > combo[itemId= "fromhr"]'
	},
	{
		ref : 'transactionComboTohr',
		selector : 'floatingContainer > panel > combo[itemId= "tohr"]'
	},
	{
		ref : 'transactionComboFrommin',
		selector : 'floatingContainer > panel > combo[itemId= "frommin"]'
	},
	{
		ref : 'transactionComboTomin',
		selector : 'floatingContainer > panel > combo[itemId= "tomin"]'
	},
	{
		ref : 'transactionFromDate',
		selector : 'floatingContainer > panel > datefield[itemId= "from"]'
	},
	{
		ref : 'transactionToDate',
		selector : 'floatingContainer > panel > datefield[itemId= "to"]'
	},
	{
		ref:'transactionsPanelToolbar',
		selector:'floatingContainer > panel'
	},
	],
	transactionMeasuresChartURL:"/final/servlet/com.egurkha.TransactionMeasures",
	time_line_obj:null,
	chart_url:null,
	siteName:null,
	init: function() {
		if(!toolBarHide)
			setInterval("execute()",refreshFrequency);
		this.control({
			'main':{
				'render':this.loadDashboard
			},
			'main > toolbar > button[id= "backBt"]':{
				click:this.backButtonHandler
			},
			'transactionschartpanel button[id= "settingBt"]':{
				click:this.settingClick
			},		  
			'floatingContainer > panel > combo[itemId= "timeline"]':{
				select:this.timelineChangeHandler // Date 
			},
			'floatingContainer > panel > button[action = "transactionGraphBtn"]':{
				click:this.displayGraph
			},
			'transactionschartpanel':{
				'afterrender':this.onChartsPanelRender
			},
			'main combo[id="compCombo"]':{
				'change':this.onCompChange
			},
			'main combo[id="scriptCombo"]':{
				'change':this.onScriptChange
			}
		})
	},
	refresh:function()
	{		
		try
		{
			Ext.getBody().mask('Loading...');
			
			this.loadDashboard;
			/*Ext.Ajax.request({
				url : refreshUrl,			
				method: 'POST',
				async: false,
				success: function(response)
				{
					publicJsonData = Ext.decode(response.responseText);
					var viewMain = Ext.getCmp('viewMain');
					if(!Ext.isEmpty(viewMain))
					{
						viewMain.update();	
					}
					Ext.getBody().unmask();
				},
				failure:function(){
					Ext.getBody().unmask();
				}
			});*/
		}
		catch (e)
		{
			Ext.getBody().unmask();
		}
	},
	onScriptChange:function(combo)
	{
		try
		{
			var compCombo = Ext.getCmp("compCombo");
			var compComboValue = '';

			if(!compComboHide && compCombo != undefined && compCombo != 'undefined' && compCombo != null)
			{
				compComboValue = compCombo.getValue();
				if(compComboValue.indexOf(":NULL") != -1)
					compComboValue = compComboValue.substring(0,compComboValue.indexOf(":NULL"));
			}
			else if(compComboHide && selComp != null)
			{
				compComboValue = selComp;
				if(compComboValue.indexOf(":NULL") != -1)
					compComboValue = compComboValue.substring(0,compComboValue.indexOf(":NULL"));
			}
			selectedInfo = combo.getValue();
			parent.sess_sim_script=selectedInfo;
			var selectedMsmtTime = "";
			var tyui = combo.getStore().data.items;
			for(var t=0;t<tyui.length;t++)
			{
				if(tyui[t].data.value == selectedInfo)
					selectedMsmtTime = tyui[t].data.msmtTime;
			}

			var scriptChangeUrl = sessURL;
			scriptChangeUrl = scriptChangeUrl +"&scriptChange=true";
			
			if(selectedInfo != '')
			{
				if(scriptChangeUrl.indexOf("selectedScript=") > -1)
				{
					if(scriptChangeUrl.indexOf("selectedScript=") > -1)
					{
						scriptChangeUrl=scriptChangeUrl.replace(/(selectedScript=).*?(&)/,'$1' + selectedInfo + '$2');
					}
				}
				else
				{
					var urlData = scriptChangeUrl.split("?");
					var secUrl = urlData[0]+"?"+"selectedScript="+selectedInfo+"&"+urlData[1];
					scriptChangeUrl = secUrl;
				}
			}
			if(selectedMsmtTime != '')
			{
				if(scriptChangeUrl.indexOf("selectedMsmtTime=") > -1)
				{
					if(scriptChangeUrl.indexOf("selectedMsmtTime=") > -1)
					{
						scriptChangeUrl=scriptChangeUrl.replace(/(selectedMsmtTime=).*?(&)/,'$1' + selectedMsmtTime + '$2');
					}
				}
				else
				{
					var urlData = scriptChangeUrl.split("?");
					var secUrl = urlData[0]+"?"+"selectedMsmtTime="+selectedMsmtTime+"&"+urlData[1];
					scriptChangeUrl = secUrl;
				}
			}
			if(compComboValue != '')
			{
				//scriptChangeUrl = scriptChangeUrl +"&compName="+compComboValue;
				if(scriptChangeUrl.indexOf("compName=") > -1)
				{
					if(scriptChangeUrl.indexOf("compName=") > -1)
					{
						scriptChangeUrl=scriptChangeUrl.replace(/(compName=).*?(&)/,'$1' + compComboValue + '$2');
					}
				}
				else
				{
					var urlData = scriptChangeUrl.split("?");
					var secUrl = urlData[0]+"?"+"compName="+compComboValue+"&"+urlData[1];
					scriptChangeUrl = secUrl;
				}
			}
			if(compType != '')
			{
				if(scriptChangeUrl.indexOf("compType=") > -1)
				{
					scriptChangeUrl=scriptChangeUrl.replace(/(compType=).*?(&)/,'$1' + compType + '$2');
				}
				else
				{
					var urlData = scriptChangeUrl.split("?");
					var secUrl = urlData[0]+"?"+"compType="+compType+"&"+urlData[1];
					scriptChangeUrl = secUrl;
				}
			}
			refreshUrl = scriptChangeUrl;
			Ext.getBody().mask('Loading...');
			
			Ext.Ajax.request({
				url : scriptChangeUrl,			
				method: 'POST',
				async: false,
				success: function(response)
				{
					publicJsonData = Ext.decode(response.responseText);
					var viewMain = Ext.getCmp('viewMain');
					if(!Ext.isEmpty(viewMain))
					{
						viewMain.update();	
					}
					try
					{
						var visComp = Ext.getCmp('compCombo').isVisible();
						var visScript = Ext.getCmp('scriptCombo').isVisible();
						if(visComp && visScript)
							Ext.getCmp('spacerId').setWidth(460);	
						else if(!visComp && !visScript)
							Ext.getCmp('spacerId').setWidth(970);	
						else
							Ext.getCmp('spacerId').setWidth(720);	
					}
					catch (w)
					{
					}	
                    
					Ext.getBody().unmask();
				},
				failure:function(){
					Ext.getBody().unmask();
				}
			});
		}
		catch (e)
		{
			Ext.getBody().unmask();
		}
	},
	onCompChange:function(combo)
	{
		selComp = combo.getValue();
		parent.sess_sim_comp=selComp;
		var t_c = selComp;
		if(t_c.indexOf(":NULL") != -1)
			t_c = t_c.substring(0,t_c.indexOf(":NULL"));
		var tyui = combo.getStore().data.items;
		for(var t=0;t<tyui.length;t++)
		{
			if(tyui[t].data.value == selComp)
			{
				comboUrl = tyui[t].data.url;
				compType = tyui[t].data.compType;
				parent.sess_sim_compType = tyui[t].data.compType;
			}
		}
		
		var c_url = comboUrl+"&combochange=true&compName="+t_c;
		var dataUrl = comboUrl+"&compName="+t_c;
		sessURL = dataUrl;
		selectedInfo ='';

		refreshUrl = c_url;
		Ext.getBody().mask('Loading...');
		try
		{
			Ext.Ajax.request({
				//url : sessURL,
				url : c_url,
				method: 'POST',
				async: false,
				success: function(response)
				{
					publicJsonData = Ext.decode(response.responseText);
					if(!Ext.isEmpty(publicJsonData))
					{					
						isMultiScript = publicJsonData.MultiScript;
					}
					if(isMultiScript)
					{		
						Ext.getCmp("scriptCombo").setVisible(isMultiScript);
						if(selectedInfo == "" || selectedInfo ==null || selectedInfo == undefined)
						{
							selectedInfo = publicJsonData.MultiScriptCombo[0].value;
							selectedMsmtTime = publicJsonData.MultiScriptCombo[0].msmtTime;
						}
						else
						{	
							var isHaveScript = false;
							var scriptCheck = publicJsonData.MultiScriptCombo;
							for(var t=0;t<scriptCheck.length;t++)
							{
								if(scriptCheck[t].value == selComp)
								{
									selectedMsmtTime = scriptCheck[t].msmtTime;
									isHaveScript = true;
								}
							}
							if(!isHaveScript)
							{
								selectedInfo = publicJsonData.MultiScriptCombo[0].value;
								selectedMsmtTime = publicJsonData.MultiScriptCombo[0].msmtTime;
							}
						}
						Ext.getCmp("scriptCombo").getStore().loadData(publicJsonData.MultiScriptCombo);
						Ext.defer(function()
						{
							Ext.getCmp("scriptCombo").setValue(selectedInfo);
						},5);

						dataUrl = dataUrl +"&selectedScript="+selectedInfo+"&selectedMsmtTime="+selectedMsmtTime;
						refreshUrl = dataUrl;					
						Ext.Ajax.request({
							url : dataUrl,
							method: 'POST',
							async: false,
							success: function(response)
							{
								publicJsonData = Ext.decode(response.responseText);
							}
						});
					}
					else
					{		
						Ext.getCmp("scriptCombo").setVisible(isMultiScript);
						Ext.Ajax.request({
							url : c_url,
							method: 'POST',
							async: false,
							success: function(response)
							{
								publicJsonData = Ext.decode(response.responseText);
							}
						});
					}
					
					var viewMain = Ext.getCmp('viewMain');
					if(!Ext.isEmpty(viewMain))
					{
						viewMain.update();	
					}
					try
					{
						var visComp = Ext.getCmp('compCombo').isVisible();
						var visScript = Ext.getCmp('scriptCombo').isVisible();
						if(visComp && visScript)
							Ext.getCmp('spacerId').setWidth(460);	
						else if(!visComp && !visScript)
							Ext.getCmp('spacerId').setWidth(970);	
						else
							Ext.getCmp('spacerId').setWidth(720);	
					}
					catch (w)
					{
					}	
					Ext.getBody().unmask();
				},
				failure:function(){
					Ext.getBody().unmask();
				}
			});
		}
		catch (e)
		{
			Ext.getBody().unmask();
		}
	},
	backButtonHandler:function(){

		if(isFromList == 'true')
		{
			if(from == 'componentList' || from == 'MainDashboard' || from == 'list')
			{
				document.location = listBackUrl;
			}
			else
				window.history.go(-1);
		}
		else if(isFromLayerModel == 'true')
		{
			document.location = layerBackUrl;
		}
		else if(isFromMetricsPage == 'true')
		{
			try
			{
				var backUrl='/final/monitor/comparisonDashboard.jsp?isFromMenu=true';
				for (var a in metricBackObj )
				{
					backUrl +='&'+a+'='+metricBackObj[a];
				}
				document.location = backUrl;
			}
			catch (e)
			{
				alert(e)
			}
		}
		else if(fromp="ctxLogonDashboard" && isFromInfraHome == 'true')
		{
			try
			{
				var backUrl='/final/monitor/comparisonDashboard.jsp?isFromInfraHome=true';
				for (var a in metricBackObj )
				{
					backUrl +='&'+a+'='+metricBackObj[a];
				}
				document.location = backUrl;
			}
			catch (e)
			{
				alert(e)
			}
		}
		else if(fromp="ctxLogonDashboard" && isFromMenu == 'true')
		{
			try
			{
				var backUrl='/final/monitor/comparisonDashboard.jsp?isFromMenu=true';
				for (var a in metricBackObj )
				{
					backUrl +='&'+a+'='+metricBackObj[a];
				}
				document.location = backUrl;
			}
			catch (e)
			{
				alert(e)
			}
		}
		else
		{
			window.history.go(-1);
		}
		
	},
	timelineChangeHandler:function(combo){
		var timelineValue=combo.getValue();
		if(timelineValue=="Any"){
		this.enableDisableDateFields(true);
		}else{
		this.enableDisableDateFields(false);
		}
		var chartToolbar=this.getTransactionsPanelToolbar();
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		var remoteURL=chartPanel.jsonData.HiddenFields.remoteURL;
		var format=chartPanel.jsonData.HiddenFields.currentDateFormat;

		var starttime="";
		var startTimeField=chartToolbar.getComponent("from");
		if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(startTimeField.getValue())){
			starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
		}

		var endtime="";
		var endTimeField=chartToolbar.getComponent("to");
		if(!Ext.isEmpty(endTimeField) && !Ext.isEmpty(endTimeField.getValue())){
			endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
		}

		var startHr="";
		var fromCombo=chartToolbar.getComponent("fromhr");
		if(!Ext.isEmpty(fromCombo) && !Ext.isEmpty(fromCombo.getValue())){
			startHr=fromCombo.getValue();
		}			  

		var endHr="";
		var toCombo=chartToolbar.getComponent("tohr");
		if(!Ext.isEmpty(toCombo) && !Ext.isEmpty(toCombo.getValue())){
			endHr=toCombo.getValue();
		}

		//Get Minutes
		var startMin="";
		var fromMinCombo=chartToolbar.getComponent("frommin");
		if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo.getValue())){
			startMin=fromMinCombo.getValue();
		}			

		var endMin="";
		var toMinCombo=chartToolbar.getComponent("tomin");
		if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo.getValue())){
			endMin=toMinCombo.getValue();
		}
		var paramValues='F=getTimeJSON&P0=['+timelineValue+']&P1=['+starttime+']&P2=['+endtime+']&P3=['+startHr+']&P4=['+endHr+']&P5=['+format+']&P6=['+startMin+']&P7=['+endMin+']&C=1&calljson=true';

		Ext.Ajax.request({
			url: remoteURL,
			scope:this,
			method: 'POST',
			params: paramValues,
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				this.setTime(jsonData.getTime,timelineValue);
				}
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	setTime:function(timeVal,timelineValue){	
		var arrOptions = timeVal.split('\t');
		var frHr="",toHr="";
		var frMin="",toMin="";
		time_line_obj=new Object();
		time_line_obj.starttime=arrOptions[0];
		var startdt ="",enddt="";
		if(timelineValue=="Any"){
			startdt = Ext.Date.format(arrOptions[6],mgrDateFormat);
			enddt = Ext.Date.format(arrOptions[7],mgrDateFormat);
		}
		else
		{
			startdt = new Date(arrOptions[6]);
			enddt = new Date(arrOptions[7]);
			startdt = Ext.Date.format(arrOptions[6],mgrDateFormat);
			enddt = Ext.Date.format(arrOptions[7],mgrDateFormat);
		}
		if(startdt == "Invalid Date" || startdt =="" )
			startdt = arrOptions[6];
		if(enddt == "Invalid Date" || enddt =="" )
			enddt = arrOptions[7];
		var tmp_start_date="",tmp_end_date="";
		tmp_start_date= Ext.Date.format(startdt,mgrDateFormat);
		tmp_end_date = Ext.Date.format(enddt,mgrDateFormat);
		startdt = (tmp_start_date == "")?startdt:tmp_start_date;
		enddt = (tmp_end_date == "")?enddt:tmp_end_date;
		this.getTransactionsPanelToolbar().getComponent("from").setValue(startdt);

		time_line_obj.endtime=arrOptions[1];
		this.getTransactionsPanelToolbar().getComponent("to").setValue(enddt);
		time_line_obj.starthr=arrOptions[2];
		if(timelineValue=="Any"){
			frHr = arrOptions[8];
			toHr = arrOptions[9];
		}
		else
		{
			frHr = arrOptions[8];
			toHr = arrOptions[9];
		}

		frMin = arrOptions[10];
		toMin = arrOptions[11];
		this.getTransactionsPanelToolbar().getComponent("frommin").setValue(frMin);
		this.getTransactionsPanelToolbar().getComponent("tomin").setValue(toMin);			
		this.getTransactionsPanelToolbar().getComponent("fromhr").setValue(frHr);
		time_line_obj.endhr=arrOptions[3];
		this.getTransactionsPanelToolbar().getComponent("tohr").setValue(toHr);
		var chartToolbar=this.getTransactionsPanelToolbar();
	},
	enableDisableDateFields:function(enable){
		var chartToolbar=this.getTransactionsPanelToolbar();
		var startTimeField=chartToolbar.getComponent("from");
		var endTimeField=chartToolbar.getComponent("to");
		var fromCombo=chartToolbar.getComponent("fromhr");
		var toCombo=chartToolbar.getComponent("tohr");

		if(enable){
			startTimeField.setDisabled(false);
			endTimeField.setDisabled(false);
			fromCombo.setDisabled(false);
			toCombo.setDisabled(false);
		}else{
			startTimeField.setDisabled(true);
			endTimeField.setDisabled(true);
			fromCombo.setDisabled(true);
			toCombo.setDisabled(true);
		}
	},
	settingClick:function(image){
		var timlinePos=Ext.getCmp("settingBt").getPosition();
		var winObj = Ext.getCmp('timeWindow');
		winObj.showAt([timlinePos[0]-680,timlinePos[1]+20]);
	},
	onChartsPanelRender:function(panel){
		this.displayGraphInitially(panel.jsonData);
	},
	displayGraphInitially:function(jsonData){	    	  
		var  mode=jsonData.HiddenFields.mode
		var  starttime=jsonData.HiddenFields.starttime
		var  endtime=jsonData.HiddenFields.endtime
		var  starthr=jsonData.HiddenFields.startHr
		var  endhr=jsonData.HiddenFields.endHr
		var  time_line=jsonData.HiddenFields.timeline
		var  startmin = jsonData.HiddenFields.startMin
		var  endmin = 	 jsonData.HiddenFields.endMin
		var cdate = this.getCurrentDateTime();
		var chartOption = "highcharts";

		if(!Ext.isEmpty(starttime) && !Ext.isEmpty(endtime))
		{
			starttime=Ext.Date.format(new Date(starttime),mgrDateFormat);
			endtime=Ext.Date.format(new Date(endtime),mgrDateFormat);	
		}
		this.transactionMeasuresParam={
			site:jsonData.HiddenFields.siteName,
			comp:jsonData.HiddenFields.compName,
			test:jsonData.HiddenFields.testForTab,
			measure:jsonData.HiddenFields.measurelst,
			gformat:"graph",
			GraphSize:"true",
			monitorSkin:jsonData.HiddenFields.monitorSkin,
			mode:'2D',
			starttime:starttime,
			endtime:endtime,
			starthr:starthr,
			startmin:startmin,

			endhr:endhr,
			endmin:endmin,
			time_line:time_line,
			all_trans_names:jsonData.HiddenFields.all_trans_names,
			msmt_host:jsonData.HiddenFields.mHost,
			isAreaChart:false,
			isLogonType:false
		};
		if(!Ext.isEmpty(jsonData.HiddenFields)){
			var cdate = this.getCurrentDateTime();
			var chartOption = "highcharts";
			if(chartOption != null){
				if(chartOption.indexOf("highchart") > -1)
				{
					this.getTransactionComboMode().hide();
					this.createHighStockChart(this.transactionMeasuresChartURL,this.transactionMeasuresParam);
				}
				else
				{
					this.getTransactionComboMode().hide();
					var chartPnl=this.getTransactionsChartPanel();
					Ext.Ajax.request({
						url : this.transactionMeasuresChartURL,
						params:this.transactionMeasuresParam,
						scope:this,
						success: function(response){
							this.createGraphs(response);
						},
						failure:function(){
							//window.parent.location.href="/final/servlet/com.egurkha.Logout";
						}
					});
				}
			}
		}
	},
	createHighStockChart:function(url,param){
		var seriesOptions = [],
		yAxisOptions = [],
		seriesCounter = 0;
		var title = "";
		var colors = "";
		var fmts = "";
		var axisTitle = "";
		var min = "";
		var max = "";
		var xmax = "";
		var xmin = "";
		var lineWidth = "";
		var TotalTd = 0;
		var cell_count=0;
		var itemsArray=[];
		var tdValues="";
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		var measures=chartPanel.jsonData.HiddenFields.measurelst;
		var measure_list_value=measures.split(",");
		var tab="emulated";

		var firstCmp = Ext.getCmp('firstid');
		var midCmp = Ext.getCmp('midid');
		var lastCmp = Ext.getCmp('lastid');

		if(!Ext.isEmpty(errorPanel) && errorPanel==true)
		{
			chartPanel.update("");
			if(!Ext.isEmpty(firstCmp))
			chartPanel.remove(firstCmp);
			if(!Ext.isEmpty(midCmp))
			chartPanel.remove(midCmp);
			if(!Ext.isEmpty(lastCmp))
			chartPanel.remove(lastCmp);
		}
		var me = this;
		var chartPnl=Ext.getCmp('transactionschartpanelid');
		Ext.Ajax.request(
		{
			url : url,
			params:param,
			scope:this,
			timeout:6000000,
			success: function(response) 
			{	
				if(response.status == 200 && !Ext.isEmpty(response))
				{
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var data=Ext.decode(jsonText);
						if(!Ext.isEmpty(data))
						{
							var chartData=[];
							var htmlStr1='';
							var htmlStr2='';
							var htmlStrMid='';
							var itemsArray=[];
							var highChartUrls = new Array();
							var highChartIds = new Array();
							var highChartFmts = new Array();
							var highChartXmax = new Array();
							var highChartXmin = new Array();
							var highChartMax = new Array();
							var highChartAxislabel = new Array();
							var highChartSeriesOptions = new Array();
							var highChartTotalTd = new Array();
							var highChartColor = new Array();
							var highChartTitle = new Array();
							var size = 0;
							var tmp_div_size_of_td = 0;
							var itemInc = 0;
							for(var inc in data)
							{
								if(inc.indexOf("chart") > -1)
								size = size+1;
							}
							me.createDivforHighChart(size);
							if(size > 0 )
							{
								var styleAttrbs=new Object();
								styleAttrbs['fontFamily']='Arial';
								styleAttrbs['fontSize']='11px';
								
								styleAttrbs['axisLabelGridColor']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
								styleAttrbs['axisLabelColor']= ( strSkin == 'Light' )?'#969696':'#c6c6c6';
								styleAttrbs['axisLabelFontFmy']='Arial';
								styleAttrbs['axisLabelFontSize']='11px';
								styleAttrbs['axisLabelLineColor']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
								styleAttrbs['axisLabelMinorGrid']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
								styleAttrbs['axisLabelTickColor']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
								styleAttrbs['axisTitleColor']= ( strSkin == 'Light' )?'#606060':'#c0c0c0';
								styleAttrbs['axisTitleFontFmy']='Arial';
								styleAttrbs['axisTitleFontSize']='11px';


								styleAttrbs['TooltipFontFmy']='Arial';//'LucidaGrandeBold';
								styleAttrbs['TooltipFontSize']='11px';
								styleAttrbs['TooltipBgColor']= ( strSkin == 'Light' )?'white':'#161616';
								styleAttrbs['TooltipBorderColor']= ( strSkin == 'Light' )?'black':'#0c0c0c';

								styleAttrbs['legendFontFmy']='Arial';
								styleAttrbs['legendFontSize']='12px';
								styleAttrbs['legendColor']= ( strSkin == 'Light' )?'#2a292a':'#c6c6c6';
								styleAttrbs['titleFontClr']=( strSkin == 'Light' )?'#2a292a':'#c6c6c6';
								styleAttrbs['titleFontFmy']='Roboto-Bold';
								styleAttrbs['titleFontSize']='13px';
								styleAttrbs['lineThickness']='2';

								var styleObj = data["styles"];
								for(var mainKey in data)
								{
									var dataOfKey = data[mainKey];
									if( mainKey != "styles" && mainKey != 'chartKey' && dataOfKey.indexOf("^eg^") == -1)
									{
										for ( var key in dataOfKey )
										{
											if(!isNaN(key))
											{
												title = dataOfKey[key]['title'];
												fmts = dataOfKey[key]['fmts'];
												axisTitle = dataOfKey[key]['axislabel'];
												xmax = dataOfKey[key]['xmax'];
												xmin = dataOfKey[key]['xmin'];
												max = dataOfKey[key]['max'];
												colors = dataOfKey[key]['color'],
												lineWidth = dataOfKey[key]['lineWidth'],
												seriesOptions[key] =
												{
													name: dataOfKey[key]['name'],
													data: dataOfKey[key]['data'],
													color: dataOfKey[key]['color'],
													dataGrouping: {
													enabled: false
													}
												};
											}
											highChartColor.push(colors);
										}
										highChartTitle.push(title);
										highChartFmts.push(fmts);
										highChartXmax.push(xmax);
										highChartXmin.push(xmin);
										highChartMax.push(max);
										highChartAxislabel.push(axisTitle);
										highChartSeriesOptions.push(seriesOptions);
										highChartTotalTd.push(TotalTd);

										if(TotalTd == 3 || TotalTd ==1 ) 
										{
											var Legend_Total = seriesOptions.length;
											var tdValues="<table align='center'cellpadding='3' cellspacing='5'  style='height:100%'><tr><td align='center'><table><tr>";
											var padRight="";
											if(Legend_Total!=null && Legend_Total!='')
											{
												for(var z=0;z<Legend_Total;z++)
												{
													if (z!=(Legend_Total-1))
													{
														padRight="15px";
													}
													else
													{
														padRight="0px";
													}
													var LegendTdName    =seriesOptions[z].name;
													if(LegendTdName!=null && LegendTdName.indexOf("^")>-1)
													{
														var trans_name_temp=LegendTdName.substring(0,LegendTdName.lastIndexOf("^"));
														//var color_code_temp=LegendTdName.substring(LegendTdName.lastIndexOf("^")+1);
														tdValues=tdValues+"<td  align='center'>";
														tdValues=tdValues+"<table cellpadding='3' cellspacing='1' border='0'>";
														tdValues=tdValues+"<tr>";
														//tdValues=tdValues+"<td width = '10' style='background:#"+color_code_temp+"' class='linesquare_white' height='10'><img src = '/final/monitor/eg_images/spacer.gif' width = '10' height = '10' border = '0'></td></tr></table></td>";
														tdValues=tdValues+"<td nowrap style='width:40px;padding-right:10px; height:10px' >"+trans_name_temp+"</td>";
													}
													else
													{
														tdValues=tdValues+"<td  align='center'>";
														tdValues=tdValues+"<table cellpadding='3' cellspacing='1' border='0'>";
														tdValues=tdValues+"<tr>";
														tdValues=tdValues+"<td width = '10' style='vetical-align:top' class='linesquare_white' height='5'><div style='background:"+highChartColor[z]+";height:8px;width:8px' ><div></td></tr></table></td>";
														tdValues=tdValues+"<td nowrap class='font_normal11' style='height:20px;padding-left:5px;padding-right:"+padRight+";' >"+LegendTdName+"</td>";
													}
													if(z == 5){													
//														tdValues=tdValues+"</tr><tr>";
														tdValues=tdValues+"</tr></table></td></tr><tr><td align='center'><table><tr>";
													}
												}
											}
											tdValues = tdValues+"</tr><table></td></tr></table>";
											var legContainer = Ext.get('legends');
											if(!Ext.isEmpty(legContainer))
											{
											Ext.getCmp('legends').update(tdValues);
											}
										}
										if(!Ext.isEmpty(chartPnl.isNotAreaChart))
											loadTransHCGrap(seriesOptions,TotalTd,axisTitle,fmts,'',max,xmax,xmin,lineWidth,styleAttrbs,true,chartPanel);
										else
											loadTransHCGrap(seriesOptions,TotalTd,axisTitle,fmts,'',max,xmax,xmin,lineWidth,styleAttrbs,false,chartPanel);
										Ext.getCmp('transchart'+TotalTd).setTitle('<span style="margin-top:20px;display:block;text-align:center" class="font_bold13 fontStyleRobot">'+title+'</span>');
										TotalTd = TotalTd+1;
										itemInc = itemInc+1;
										if(!Ext.isEmpty(chartPanel.getEl()) && chartPanel.getEl() != null && chartPanel.getEl() != 'undefined')
										{
											chartPanel.getEl().unmask();
										}
									}
									else
									{
										if(  mainKey != "styles" && mainKey != 'chartKey' && dataOfKey.indexOf("^eg^") > -1 )
										{
											var myImgHtml = '<div style="margin:7% 20% auto 30%"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></div>';
											if( itemInc < size )
											{
												var timTitle = dataOfKey.substring(4);
												Ext.getCmp('transchart'+itemInc).setTitle('<span style="margin-top:20px;display:block;text-align:center" class="font_bold13 fontStyleRobot">'+timTitle+'</span>');
												Ext.getCmp('transchart'+itemInc).update(myImgHtml);
												itemInc = itemInc+1;
											}
										}
									}
								}
								errorPanel = false;
							}
							else
							{
							this.displayErrorMsg();
							}
							errorPanel = false;
						}
						else
						{
						this.displayErrorMsg();
						}
						errorPanel = false;
					}
					else
					{
						this.displayErrorMsg();
					}
				}
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	getCurrentDateTime:function(){
		var endHr="";
		var startHr="";
		var starttime="";
		var endtime="";
		var time_line ="";
		var retDate = "";
		var chartToolbar=this.getTransactionsPanelToolbar();
		var timelineCombo=chartToolbar.getComponent("timeline");
		if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
			  time_line=timelineCombo.getValue();
		  }
		 var startTimeField=chartToolbar.getComponent("from");
		  if(!Ext.isEmpty(startTimeField)){
			  if(!startTimeField.isDisabled()  && !Ext.isEmpty(startTimeField.getValue())){
				  starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
			  }else{
				  if(!Ext.isEmpty(time_line_obj)){
					  starttime=time_line_obj.starttime;
				  }else{
					  starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
				  }
			  }
		  }
		  
		  var endTimeField=chartToolbar.getComponent("to");
		  if(!Ext.isEmpty(endTimeField)){
			  if(!endTimeField.isDisabled()  && !Ext.isEmpty(endTimeField.getValue())){
			  endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
			  }else{
				  if(!Ext.isEmpty(time_line_obj)){
					  endtime=time_line_obj.endtime;
				  }else{
					  endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
				  }
			  }
		  }
		
		var fromCombo=chartToolbar.getComponent("fromhr");
		if(!Ext.isEmpty(fromCombo))
			{
			  if(!fromCombo.isDisabled() && !Ext.isEmpty(fromCombo.getValue())){
				startHr=fromCombo.getValue();
				 
			  }else{
				  if(!Ext.isEmpty(time_line_obj)){
					  startHr=time_line_obj.starthr;
					   
				  }else{
						startHr=fromCombo.getValue();
					}
			}
		}

		  var toCombo=chartToolbar.getComponent("tohr");
		  if(!Ext.isEmpty(toCombo)){
			  if(!toCombo.isDisabled() && !Ext.isEmpty(toCombo.getValue())){
				  endHr=toCombo.getValue();
			}else{
				  if(!Ext.isEmpty(time_line_obj)){
						endHr=time_line_obj.endhr;
				  }else{
						endHr=toCombo.getValue();
				  }
			  }
		  }
		if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(endTimeField)){
			starttime = Ext.Date.dateFormat(startTimeField.getValue(), 'm/d/Y');
			endtime = Ext.Date.dateFormat(endTimeField.getValue(), 'm/d/Y');
			retDate = time_line+":"+starttime+":"+startHr+":"+endtime+":"+endHr;
		}
		return retDate;
	},
	displayGraph:function(){
		var cdate = this.getCurrentDateTime();
		var chartOption = "highcharts";
		if(chartOption.indexOf("highchart") > -1)
		{
			this.getTransactionComboMode().hide();
		}
		else
		{
			this.getTransactionComboMode().hide();
		}
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		if(!Ext.isEmpty(chartPanel) && !Ext.isEmpty(chartPanel.jsonData)){
			var jsonData=chartPanel.jsonData;
			var mode="";
			var starttime="";
			var endtime="";
			var startHr="";
			var startMin="";
			var endHr="";
			var endMin="";
			var time_line="";
			var dateError = '';
			var chartToolbar=this.getTransactionsPanelToolbar();
			var modeCombo=chartToolbar.getComponent("mode");
			if(!Ext.isEmpty(modeCombo) && !Ext.isEmpty(modeCombo.getValue())){
				mode=modeCombo.getValue();
			}
			var startTimeField=chartToolbar.getComponent("from");
			if(!Ext.isEmpty(startTimeField)){
				if(!startTimeField.isDisabled()  && !Ext.isEmpty(startTimeField.getValue())){
				starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						starttime=time_line_obj.starttime;
					}else{
						starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
					}
				}
			}

			var endTimeField=chartToolbar.getComponent("to");
			if(!Ext.isEmpty(endTimeField)){
				if(!endTimeField.isDisabled()  && !Ext.isEmpty(endTimeField.getValue())){
				endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						endtime=time_line_obj.endtime;
					}else{
						endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
					}
				}
			}

			var fromCombo=chartToolbar.getComponent("fromhr");
			if(!Ext.isEmpty(fromCombo)){
				if(!fromCombo.isDisabled() && !Ext.isEmpty(fromCombo.getValue())){
					startHr=fromCombo.getValue();
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						startHr=time_line_obj.starthr;
					}else{
						startHr=fromCombo.getValue();
					}
				}
			}

			var toCombo=chartToolbar.getComponent("tohr");
			if(!Ext.isEmpty(toCombo)){
				if(!toCombo.isDisabled() && !Ext.isEmpty(toCombo.getValue())){
					endHr=toCombo.getValue();
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						endHr=time_line_obj.endhr;
					}else{
						endHr=toCombo.getValue();
					}
				}
			}			

			//Get Minutes
			var startMin="";
			var fromMinCombo=chartToolbar.getComponent("frommin");
			if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo.getValue())){
				startMin=fromMinCombo.getValue();
			}			

			var endMin="";
			var toMinCombo=chartToolbar.getComponent("tomin");
			if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo.getValue())){
				endMin=toMinCombo.getValue();
			}

			//

			// var timeLineCombo=this.getTransactionChartComboTimeline();
			var timeLineCombo=this.getTransactionComboTimeline();
			if(timeLineCombo.getValue() =="Any"){
				var dateError = startTimeField.getName();
				var currentDateError = endTimeField.getName()
				var startTime = startTimeField.getValue();
				var endTime = endTimeField.getValue();
				var curTime = curDateTime;
				var currentMgrDate = new Date(curTime);

				var starttime= formatDate(startTime, "MM/dd/yyyy");
				var endtime= formatDate(endTime, "MM/dd/yyyy");

				if(dateValidation(starttime,endtime,parseInt(startHr),parseInt(endHr),0,0)==-1)
				{
					//var msg ="From date should be lesser than to date";
					Ext.Msg.alert('Error', dateError);
					return;
				}


				/*if((startTime > currentMgrDate )|| (endTime > currentMgrDate)){
				Ext.Msg.alert('Error', currentDateError);
				return;
				}
				if(startTimeField.getValue() > endTimeField.getValue()){
				Ext.Msg.alert('Error', dateError);
				return;
				}
				else if(startTimeField.getValue().getDate()==endTimeField.getValue().getDate()&&startTimeField.getValue().getMonth()==endTimeField.getValue().getMonth()&&startTimeField.getValue().getFullYear()==endTimeField.getValue().getFullYear()){
				if(startHr>=endHr){
				Ext.Msg.alert('Error', dateError);
				return;
				}
				}*/
			}

			this.anyStartTime=starttime;
			this.anyEndTime=endtime;
			this.anyStartHr=startHr;
			this.anyEndHr=endHr;
			var timelineCombo=chartToolbar.getComponent("timeline");
			if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
				time_line=timelineCombo.getValue();
			}
			//var chartPanel=this.getTransactionsChartPanel();
			var chartPanel=Ext.getCmp('transactionschartpanelid');

			var cdate = this.getCurrentDateTime();
			var chartOption = "highcharts";
			//var mgr_dateFormat = 'M d, Y';
			this.transactionMeasuresParam={
				startTrans:'',
				site:jsonData.HiddenFields.siteName,
				comp:jsonData.HiddenFields.compName,
				test:jsonData.HiddenFields.testForTab,
				measure:jsonData.HiddenFields.measurelst,
				gformat:"graph",
				chartType:chartOption,
				GraphSize:"true",
				monitorSkin:jsonData.HiddenFields.monitorSkin,
				mode:'2D',
				starttime:startTimeField.getRawValue(),
				endtime:endTimeField.getRawValue(),
				starthr:startHr,
				endhr:endHr,
				startmin:startMin,
				endmin:endMin,
				time_line:time_line,
				all_trans_names:jsonData.HiddenFields.all_trans_names,
				msmt_host:jsonData.HiddenFields.mHost,
				endTrans:'',
				//isAreaChart:true,
				isAreaChart:false,
				isLogonType:false
			};

			// this.getTransactionChartComboMode().show();
			if(chartOption.indexOf("highchart") > -1)
			{
				this.createHighStockChart(this.transactionMeasuresChartURL,this.transactionMeasuresParam);
				// this.getTransactionChartComboMode().hide();
				this.getTransactionComboMode().hide();
			}
			else
			{
				// this.getTransactionChartComboMode().hide();
				this.getTransactionComboMode().hide();
				chartPanel.getEl().mask("Loading...");
					Ext.Ajax.request({
					url : this.transactionMeasuresChartURL,
					params: this.transactionMeasuresParam,
					method:'get',
					scope:this,
					success: function(response){
						var chartPnl=Ext.getCmp('transactionschartpanelid');
						chartPnl.getEl().unmask();
						this.createGraphs(response);
					},
					failure:function(){
						var chartPnl=Ext.getCmp('transactionschartpanelid');
						chartPnl.getEl().unmask();
					}
				});
			}
		}
	},
	displayErrorMsg:function(){
		errorPanel = true;
		//var chartPanel=this.getTransactionsChartPanel();
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		
		var htmlStr='<table width="100%" height="100%"><tr style="text-align:center;" width="100%" height="100%"><td width="100%" height="100%">';
		//htmlStr+='<img hspace = "0" vspace = "0" border = "0" align = "center" valign="middle" src="/final/monitor/eg_images/'+chartPanel.jsonData.HiddenFields.monitorSkin+'/nographformeasure.gif">';
		htmlStr+='<div style="text-align:center"><div class="iconInformation" style="margin:0px auto"></div><div class="font_normal11">No measure available for the current selection</div></div>'
		htmlStr+='</td></tr></table>';
		chartPanel.setLoading(false);
		chartPanel.removeAll();
		//chartPanel.setHeight(Ext.getBody().getViewSize().height-280);
		var errPanel=Ext.create('Ext.panel.Panel',
			{
				//height:180,
				layout:'fit',
				//id:'errID',
				height:Ext.getBody().getViewSize().height-330,
				html:htmlStr
		});
		chartPanel.add(errPanel);
		//chartPanel.update(htmlStr);
	},
	createDivforHighChart:function(size){
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		var imgDiv = '';
		//if(this.tab=='emulated')
		tmp_div_size_of_td=size;
		//else
		//tmp_div_size_of_td=(size/2);
		var inc = 0;
		var chartPane = '',legendPanel = '';
		chartPanel.removeAll();
		var scrollPanel=Ext.create('utilities.ScrollPanel',{
		layout:{type:'vbox',align:'stretch'},
		padding:'0',
		height:'100%',
		scroll:true,
		autoScroll:true,
		items:[
				{
					xtype:'container',
					margin:'0 10 10 10',
					layout:{type:'vbox',pack:'middle'},
					scroll:true,
					autoScroll:true,
					id:'legends'
				},
				{
					xtype : 'container',
					//height:525,
					border:true,
					flex:1,
					padding:'0 10 10 10',
					scroll:true,
					autoScroll:true,
					cls:'chartPanelTable',
					layout: {
							type: 'table',
							columns: 2,// The total column count must be specified here
							tableAttrs: {
									style: {
										width: '100%'
									}
								}
						},
					id:'midid',
					//height:380,
					
					items:this.getItems(size)
				}]
		});
		chartPanel.add(scrollPanel);
		/*--Adding Legend--*/
		/* var chartToolbar=this.getTransactionsChartPanel().getDockedItems()[1];
		chartToolbar.remove(Ext.getCmp('legends'));
		chartToolbar.add('->',{xtype:'container',id:'legends'});*/

	},
	getItems:function(size){
		var skinBg="";
		var items=[];
		for(var y=1;y<size+1;y++){
			i = y-1;
			var borderright="";
			var borderbottom="";
			if (strSkin=="Dark")
			{
				skinBg="#404040";
				borderright="1px solid #515151 !important";
				borderbottom="1px solid #515151 !important";
			}
			else if (strSkin=="Light")
			{
				skinBg="#ffffff";
				borderright="1px solid #f2f2f2 !important";
				borderbottom="1px solid #f2f2f2 !important";
			}
			var idName ='transchart'+i; 
			if(size % 2 === 0){
				if (y != 0 && y%2 === 0)
				{
					borderright="0px solid #f2f2f2 !important";				
				}
			}else{
				if (y != 0 && y === size+1)
				{
					borderright="0px solid #f2f2f2 !important";				
				}
			}

			items.push({
				xtype: 'panel',
				ui:'newPlainPanel',
				height:315,
				//style:{background: skinBg+'!important',borderRight:borderright, borderBottom: borderbottom},
				style:{background: skinBg+'!important'},
				frame:true,
				border:true,
				padding:'0 0 0 0',
				title:'',
				id:idName
			})
		}
		return items;
	},
	loadDashboard: function()
	{

		var scriptNameSetImage = parent.window.scriptNameSetImage;
		parent.window.scriptNameSetImage = null;
		
		var infoUrl = sessURL;
		var dataUrl = sessURL;
		refreshUrl = sessURL;
		if(sessURL != null && sessURL.indexOf("firstRequstCombo") == -1)
		{
			infoUrl = infoUrl+"&firstRequstCombo=true";
		}
		Ext.Ajax.request({
			url : infoUrl,
			method: 'POST',
			async: false,
			success: function(response)
			{
				infoJsonData = Ext.decode(response.responseText);
				
				if(!Ext.isEmpty(infoJsonData))
				{					
					isMultiScript = infoJsonData.MultiScript;
					//isMultiScript = infoJsonData.MultiScript;
				}				
				if(isMultiScript)
				{					
					var visComp = Ext.getCmp('compCombo').isVisible();
					if(!visComp)
					{
						Ext.getCmp('compCombo').show();
					}
					if( scriptNameSetImage == null || scriptNameSetImage == "" || scriptNameSetImage == undefined)
					{
						if(selectedInfo == "" || selectedInfo ==null || selectedInfo == undefined)
						{
							selectedInfo = infoJsonData.MultiScriptCombo[0].value;
							selectedMsmtTime = infoJsonData.MultiScriptCombo[0].msmtTime;
						}
						else
						{
							var tyui = infoJsonData.MultiScriptCombo;
							for(var t=0;t<tyui.length;t++)
							{
								if(tyui[t].value == selectedInfo)
									selectedMsmtTime = tyui[t].msmtTime;
							}
							if(selectedMsmtTime == "" || selectedMsmtTime ==null || selectedMsmtTime == undefined)
							{
								selectedInfo = infoJsonData.MultiScriptCombo[0].value;
								selectedMsmtTime = infoJsonData.MultiScriptCombo[0].msmtTime;
							}
						}
					}
					else
					{
						selectedInfo = scriptNameSetImage;
						scriptNameSetImage = null;
						var tyui = infoJsonData.MultiScriptCombo;
						for(var t=0;t<tyui.length;t++)
						{
							if(tyui[t].value == selectedInfo)
								selectedMsmtTime = tyui[t].msmtTime;
						}
						if(selectedMsmtTime == "" || selectedMsmtTime ==null || selectedMsmtTime == undefined)
						{
							selectedInfo = infoJsonData.MultiScriptCombo[0].value;
							selectedMsmtTime = infoJsonData.MultiScriptCombo[0].msmtTime;
						}
					}

					Ext.getCmp("scriptCombo").getStore().loadData(infoJsonData.MultiScriptCombo);
					Ext.defer(function()
					{
						Ext.getCmp("scriptCombo").setValue(selectedInfo);
					},5);

					dataUrl = dataUrl +"&selectedScript="+selectedInfo+"&selectedMsmtTime="+selectedMsmtTime;
					refreshUrl = dataUrl;					
					Ext.Ajax.request({
						url : dataUrl,
						method: 'POST',
						async: false,
						success: function(response)
						{
							publicJsonData = Ext.decode(response.responseText);
						}
					});
				}
				else
				{					
					Ext.getCmp("scriptCombo").setVisible(isMultiScript);
					Ext.Ajax.request({
						url : sessURL,
						method: 'POST',
						async: false,
						success: function(response)
						{
							publicJsonData = Ext.decode(response.responseText);
						}
					});
				}
			}
		});
	}

});