Ext.define('sessionSimulation.view.Main', {
	extend: 'Ext.panel.Panel',
	alias : 'widget.main',
	layout: {
		type:'vbox',
		align:'stretch'
	},
	scroll:false,
	id:'viewMain',
	//title:title,
	cls:'outerpanel',
	autoScroll:false,
	margin:margin,
	//style:{'overflow-x':'hidden !important'},
	requires: ['sessionSimulation.view.SessionSimulation'],
	listeners:{
		'render':function(panel){
			Ext.EventManager.onWindowResize(function(w, h){
					//panel.doComponentLayout();
					document.location.reload();
				});
			
		},
		'afterrender':function(){
			if(!Ext.isEmpty(publicJsonData))
			{
				try
				{
					var simulationData = publicJsonData.Result;
					var time = simulationData[2].time;
					if(time != null && time.trim().length > 0)
					{
						publicmsmt = '<span style="font-weight:500">Measurement time: </span>'+time;
						Ext.getCmp('msmtLabel').setText(publicmsmt,false);
					}
				}
				catch (ee)
				{
				}
			}
			try
			{
				var visComp = Ext.getCmp('compCombo').isVisible();
				var visScript = Ext.getCmp('scriptCombo').isVisible();
				if(visComp && visScript)
					Ext.getCmp('spacerId').setWidth(460);	
				else if(!visComp && !visScript)
					Ext.getCmp('spacerId').setWidth(970);	
				else
					Ext.getCmp('spacerId').setWidth(720);	
			}
			catch (w)
			{
			}			
		}
	},
	update:function()
	{	
		var msmtLabel = "";
		if(!Ext.isEmpty(publicJsonData))
		{
			try
			{
				var simulationData = publicJsonData.Result;
				var time = simulationData[2].time;
				if(time != null && time.trim().length > 0)
				{
					msmtLabel = '<span style="font-weight:500">Measurement time: </span>'+time;
					Ext.getCmp('msmtLabel').setText(msmtLabel,false);
				}
				else
					Ext.getCmp('msmtLabel').setText("");
			}
			catch (ee)
			{
			}
		}
		try
		{
			Ext.getCmp('mainSet').removeAll(true);	
		}
		catch (e)
		{
		}
		Ext.getCmp('mainSet').add({
			xtype:'sessionsimulation'
		});	
	},
	dockedItems: [{
        xtype: 'toolbar',
		//style:{'background':'#f6f6f6 !important'},
		cls:'sessionOuterPanelTitle',
        dock: 'top',
		padding:5,
		border:true,
		hidden:toolBarHide,
        items: [{
			xtype:'container',
			html:title
		},
		'->',
		{
			xtype: 'button',
			cls:'backbutton',
			iconCls:'iconBack',
			text:'Back',
			id:'backBt'
        }]
    }],
	items:[
	{
		xtype:'container',
		//height:35,
		padding:'10 0',
		margin:'0 20',
		//hidden:!toolBarHide,
		id:'toolSet',
		border:true,
		//style:{'border':'1px solid red !important'},
		layout: {
			type: 'hbox',
			align: 'stretch'
		},
		listeners:{
			beforerender:function(e)
			{
				if(!compComboHide)
				{
					this.add(
					{
						xtype:'combo',
						flex:0.35,
						fieldLabel:'Component:',
						cls:'dropdown',
						id:'compCombo',
						//hidden:compComboHide,
						labelSeparator:'',
						//width:250,
						labelWidth:80,
						margin:'0 15 0 0',
						labelStyle:"white-space:nowrap;text-align:center;font-weight:500;margin-right:10px;padding:0px",
						displayField : 'name',
						valueField : 'value',
						queryMode : 'local',
						store:Ext.create('Ext.data.Store',{
							data : emuCompCombo,
							fields:['name','value','url','compType'],
						}),
						value:selComp
					},
					{
						xtype:'combo',
						flex:0.4,
						fieldLabel:scriptName+":",
						cls:'dropdown',
						id:'scriptCombo',
						labelSeparator:'',
						hidden:false,
						//width:250,
						labelWidth:34,
						margin:'0 0 0 0',
						labelStyle:"white-space:nowrap;text-align:center;font-weight:500;margin-right:10px;padding:0px",
						displayField : 'displayName',
						valueField : 'value',
						queryMode : 'local',
						store:Ext.create('Ext.data.Store',{
							data : [],
							fields:['displayName','value','msmtTime'],
						}),
						value:""
					},					
					{
						xtype : 'label',
						flex:1,
						//hidden:!toolBarHide,
						//cls : 'zone-toolbar-title',
						style:{'font-size':'13px','text-align':'right','line-height':'22px'},
						id:'msmtLabel',
						margin:'0 0 0 0'
					}	
					);
				}
				else
				{
					this.add({
						xtype : 'label',
						flex:0.25,
						id:'compCombo',
						margin:'2 10 0 0',
						//labelStyle: {'white-space':'nowrap;'},						
						html:'<div style="width:100%;font-size:13px;font-weight:500;text-overflow:ellipsis;overflow: hidden;white-space: nowrap;">Component: <span style="font-weight:normal;" data-qtip="'+compName+'">'+compName+'</span></div>'
					},
					{
						xtype:'combo',
						flex:0.3,
						fieldLabel:scriptName+":",
						cls:'dropdown',
						id:'scriptCombo',
						labelSeparator:'',
						hidden:false,
						labelWidth:34,
						labelAlign:'left',
						margin:'0 0 0 0',
						labelStyle:"white-space:nowrap;text-align:center;font-weight:500;margin-right:10px;padding:0px",
						displayField : 'displayName',
						valueField : 'value',
						queryMode : 'local',
						store:Ext.create('Ext.data.Store',{
							data : [],
							fields:['displayName','value','msmtTime'],
						}),
						value:""
					},
					{
						xtype : 'label',
						flex:1,
						//hidden:!toolBarHide,
						//cls : 'zone-toolbar-title',
						style:{'font-size':'13px','text-align':'right'},
						id:'msmtLabel',
						margin:'2 3 0 0'
					});
				}
			}
		}
	},
	{
		xtype:'container',
		id:'mainSet',
		layout: {
			type:'vbox',
			align:'stretch'
		},
		flex:1,
		items:[{
			flex:1,
			xtype:'sessionsimulation'
		}]
	}
	]
});
