
function setImageName(info, iconName) {
	try
	{
		info = parent.filterEncode(info);
	}
	catch (e)
	{
		try
		{
			info = parent.parent.filterEncode(info);
		}
		catch (w)
		{
			//alert(w)
		}		
	}

    var urlStr = "/final/monitor/sessionSimulationData.jsp?setImageValue=true&serviceName=" + serviceName + "&compName=" + compName + "&port=" + port + "&info=" + encodeURIComponent(info) + "&iconName=" + iconName;

    urlStr = URLParamChange(urlStr, false);
    try {
        parent.window.scriptNameSetImage = Ext.getCmp('scriptCombo').getValue();
    } catch (e) {
        parent.window.scriptNameSetImage = null;
    }
    Ext.Ajax.request({
        url: urlStr,
        method: 'POST',
        async: false,
        success: function (response) {
            var jsondata = Ext.decode(response.responseText);
            Ext.getCmp("imgSelect").close();
            document.location.reload();
        }
    });
}

function openLink(url, toolBarHide) {
    if (toolBarHide)
        window.parent.location.href = url;
    else
        window.location.href = url;
}

function URLParamChange(url, isTrue) {
    var urlStr = url;
    if (urlStr != null) {
        try {
            var compCombo = Ext.getCmp('compCombo');
            var compComboValue = "";
            if (!compComboHide && compCombo != undefined && compCombo != 'undefined' && compCombo != null) {
                compComboValue = compCombo.getValue();
                if (compComboValue.indexOf(":NULL") != -1)
                    compComboValue = compComboValue.substring(0, compComboValue.indexOf(":NULL"));
            } else if (compComboHide && selComp != null) {
                compComboValue = selComp;
                if (compComboValue.indexOf(":NULL") != -1)
                    compComboValue = compComboValue.substring(0, compComboValue.indexOf(":NULL"));
            }

            if (urlStr.indexOf("compName=") > -1) {
                var subLastParam = urlStr.substring(urlStr.lastIndexOf("&") + 1);
                if (subLastParam.indexOf("compName=") > -1) {
                    urlStr = urlStr.substring(0, urlStr.lastIndexOf("&"));
                    var urlData = urlStr.split("?");
                    var secUrl = urlData[0] + "?" + "compName=" + compComboValue + "&" + urlData[1]
                    urlStr = secUrl;
                } else {
                    urlStr = urlStr.replace(/(compName=).*?(&)/, '$1' + compComboValue + '$2');
                }
            } else {
                var urlData = urlStr.split("?");
                var secUrl = urlData[0] + "?" + "compName=" + compComboValue + "&" + urlData[1]
                urlStr = secUrl;
            }


            if (urlStr.indexOf("compType=") > -1) {
                var subLastParam = urlStr.substring(urlStr.lastIndexOf("&") + 1);
                if (subLastParam.indexOf("compType=") > -1) {
                    urlStr = urlStr.substring(0, urlStr.lastIndexOf("&"));
                    var urlData = urlStr.split("?");
                    var secUrl = urlData[0] + "?" + "compType=" + compType + "&" + urlData[1]
                    urlStr = secUrl;
                } else {
                    urlStr = urlStr.replace(/(compType=).*?(&)/, '$1' + compType + '$2');
                }
            } else {
                var urlData = urlStr.split("?");
                var secUrl = urlData[0] + "?" + "compType=" + compType + "&" + urlData[1]
                urlStr = secUrl;
            }
        } catch (e) {
            return urlStr;
        }
        try {
            var scriptCombo = Ext.getCmp('scriptCombo').getValue();
            if (scriptCombo != undefined && scriptCombo != null && scriptCombo.trim().length > 0) {
                if (isTrue)
                    scriptCombo = scriptCombo + ":";
                if (urlStr.indexOf("scriptName=") > -1) {
                    urlStr = urlStr.replace(/(scriptName=).*?(&)/, '$1' + scriptCombo + '$2');
                } else {
                    var urlData = urlStr.split("?");
                    var secUrl = urlData[0] + "?" + "scriptName=" + scriptCombo + "&" + urlData[1]
                    urlStr = secUrl;
                }
            }
        } catch (ee) {
            return urlStr;
        }
    }

    return urlStr;
}
function wordTruncate( str, max, sep ) {
	max = max || 10;
	var len = str.length;
	if(len > max){
		sep = sep || "...";
		var seplen = sep.length;
		if(seplen > max) { return str.substr(len - max) }

		var n = -0.5 * (max - len - seplen);
		var center = len/2;
		return str.substr(0, center - n) + sep + str.substr(len - center + n);
	}
	return str;
}
function wrap(text, width) {
    text.each(function () {
        var text = d3.select(this),
            words = text.text().split(/\s+/).reverse(),
            word,
            line = [],
            lineNumber = 0,
            lineHeight = 1.1, // ems
            y = text.attr("y"),
            dy = parseFloat(0.1),
            tspan = text.text(null).append("tspan").attr("x", 0).attr("y", y).attr("dy", dy + "em");
        while (word = words.pop()) {
            line.push(word);
            tspan.text(line.join(" "));
            if (tspan.node().getComputedTextLength() > width) {
                line.pop();
                tspan.text(line.join(" "));
                line = [word];
                tspan = text.append("tspan").attr("x", 0).attr("y", y).attr("dy", ++lineNumber * lineHeight + dy + "em").text(word);
            }
        }
    });
}


function openWindowGraph() {
    try {
        parent.document.getElementById('isSessionWindowOpen').value = 'true';
    } catch (e) {}

    graphDataURL = URLParamChange(graphDataURL, true);

    Ext.Ajax.request({
        url: graphDataURL,
        scope: this,
        async: true,
        success: function (response) {
            var jsonText = response.responseText;
            if (!Ext.isEmpty(jsonText)) {
                var jsondata1 = Ext.decode(jsonText);
                var sessionSimulationGrapWindow = Ext.getCmp('sessionSimulationGrapWindow');
                if (!Ext.isEmpty(sessionSimulationGrapWindow))
                    sessionSimulationGrapWindow.removeAll(true);

                if (jsondata1 != null && jsondata1 != undefined) {
                    Ext.create('Ext.window.Window', {
                        title: graphTitle,
                        height: '85%',
                        cls: 'logonWindowShadow',
                        id: 'sessionSimulationGrapWindow',
                        modal: true,
                        shadow: 'sides',
                        shadowOffset: 50,
                        padding: '0 10 10 10',
                        header: {
                            padding: '5 10 3 10',
                            margin: 0
                        },
                        resizable: false,
                        width: '80%',
                        layout: 'fit',
                        items: [{
                            xtype: 'transactionschartpanel',
                            id: 'transactionschartpanelid',
                            jsonData: jsondata1,
                            margin: '0 1 0 0',
                            padding: 0,
                            border: true,
                            isNotAreaChart: false
                        }],
                        listeners: {
                            'close': function (win) {
                                try {
                                    parent.document.getElementById('isSessionWindowOpen').value = 'false';
                                } catch (e) {}

                                if (Ext.getCmp("timeWindow")) {
                                    Ext.getCmp("timeWindow").hide();
                                }
                            }
                        },
                    }).show()
                }
            }
        },
        failure: function () {
            //alert("failure")
        }
    });
}

function getScreenshotID(info, msmt_time, state, defaultTrans) {
    if (info == undefined || Ext.isEmpty(info) || msmt_time == undefined || Ext.isEmpty(msmt_time) || state == undefined)
        return "";

    var testName = "";
    var compType = "";
    var msmtHost = "";
    var lastInfoForSuccessSS = "";
    var isSuccessScreenshotRequired = "";
    try {
        if (info == 'Total') {
            var simulationData = publicJsonData.Result;
            testName = publicJsonData.TestName;
			var TransactionsBase = simulationData[1].Transactions;
           		var errorText = TransactionsBase[0].ERROR;	
			
			if(errorText == undefined || Ext.isEmpty(errorText))
			{			
				for (var a in TransactionsBase) {
					var df = TransactionsBase[a];
					if (df.Transaction_State != 'GOOD') {						
						info = df.Transaction_Name;
						break;
					}
				}
			}			
        }
        compType = publicJsonData.compType;
        msmtHost = publicJsonData.msmtHost;
        lastInfoForSuccessSS = publicJsonData.lastInfoForSuccessSS;
        isSuccessScreenshotRequired = publicJsonData.isSuccessScreenshotRequired;

    } catch (e) {}


    if (state === "GOOD") {
        if (lastInfoForSuccessSS != info || !isSuccessScreenshotRequired) {
            return "";
        }
    }
	
	try
	{
		info = parent.filterEncode(info);
	}
	catch (e)
	{
		try
		{
			info = parent.parent.filterEncode(info);
		}
		catch (w)
		{
			//alert(w)
		}		
	}

    var screenshotID = "";
    var urlStr = "/final/monitor/sessionSimulationData.jsp?getScreenshotID=true&info=" + encodeURIComponent(info) + "&msmt=" + msmt_time + "&compType=" + compType + "&msmtHost=" + msmtHost;

    if (testName != "")
        urlStr = "/final/monitor/sessionSimulationData.jsp?getScreenshotID=true&info=" + encodeURIComponent(info) + "&msmt=" + msmt_time + "&test=" + testName + "&compType=" + compType + "&msmtHost=" + msmtHost;

    Ext.Ajax.request({
        url: urlStr,
        method: 'POST',
        async: false,
        success: function (response) {
            var jsondata = Ext.decode(response.responseText);
            if (!Ext.isEmpty(jsondata.ScreenshotID) && jsondata.ScreenshotID != null && jsondata.ScreenshotID != undefined)
                screenshotID = jsondata.ScreenshotID;
        }
    });

    return screenshotID;
}

function openScreenShot(d, ScreenshotID) {
    if (Ext.isEmpty(ScreenshotID) || ScreenshotID == null || ScreenshotID == undefined)
        return;

    var tieleEle = "Screenshot of Transaction Failure";
    try {
        if (d.Transaction_State == "GOOD")
            tieleEle = "Screenshot of Transaction Success";
    } catch (e) {
        if (d.State == "GOOD")
            tieleEle = "Screenshot of Transaction Success";
    }

    try {
        Ext.create('Ext.window.Window', {
            title: tieleEle,
            height: '80%',
            cls: 'logonWindowShadow',
            modal: true,
            shadow: 'sides',
            shadowOffset: 50,
            padding: '0 10 10 10',
            header: {
                padding: '5 10 3 10',
                margin: 0
            },

            resizable: false,
            width: '80%',
            items: [{
                xtype: 'component',
                style: {
                    'align': 'center'
                },
                listeners: {
                    'render': function (panel) {
                        Ext.EventManager.onWindowResize(function (w, h) {
                            panel.doComponentLayout();
                        });
                    }
                },
                autoEl: {
                    tag: 'iframe',
                    frameborder: false,
                    width: '100%',
                    height: '100%',
                    style: {
                        'align': 'center'
                    },
                    src: '/final/monitor/SEUM/screenshots/' + encodeURI(ScreenshotID) + ".jpg"
                }
            }]
        }).show();
    } catch (e) {}
}

Ext.define("sessionSimulation.view.SessionSimulation", {
    extend: "Ext.panel.Panel",
    alias: "widget.sessionsimulation",
    margin: 0,
    //title:'Session Simulation Topology',
    header: false,
    ui: 'eg-x-panel',
    id: 'main',
    flex:1,
    bodyPadding: '0 10 10 90',
    requires: ['Ext.draw.Draw', 'Ext.draw.Sprite', 'Ext.draw.Matrix', 'Ext.Element', 'Ext.draw.CompositeSprite'],
    layout: {
        type: "fit"
    },
    width: Ext.getBody().getViewSize().width,
    height: Ext.getBody().getViewSize().height - 10,
    style: {
        'overflow-x': 'hidden !important'
    },
    autoScroll: true,
    scroll: false,
    listeners: {
        'boxready':function(panel){
            loadSimulation(panel);
        },
        'resize': function (panel, width, height, oldWidth, oldHeight, eOpts) {
         
            if(!Ext.isEmpty(oldWidth)){
                loadSimulation(panel);
            }

        }
    }
});
function loadSimulation(panel){
    
    try {
        var simulationData = publicJsonData.Result;
        //var simulationData = Ext.decode('{"Result":[]}');
        var isNoData = false;
        var isOnlyTotal = false;
        var defaultTransactions, TransactionsBase, Transactions, err;
        try {
            defaultTransactions = simulationData[0].DefaultTrans;
            TransactionsBase = simulationData[1].Transactions;
            Transactions = TransactionsBase;
            isNoData = true;
            if (TransactionsBase[0].ERROR == "No data found" && defaultTransactions.length > 0)
                isOnlyTotal = true;
            if (TransactionsBase[0].ERROR == "No data found")
                isNoData = false;
        } catch (eere) {
            isNoData = false;
        }
        //  panel.setHeight(Ext.getBody().getViewSize().height - 10);

        if (isNoData == true) {
          
            var selectedIcon = '',
                width = $(window).width() - 240;
            height = document.body.clientHeight; //needs to change
            boxwidth = 170;
            boxheight = 150;
            chartarea = Math.round(width - (boxwidth * 2)),
                diff = Math.round(chartarea / boxwidth);

            var chunkArry = _.chunk(Transactions, diff);
            var reverseMyData = _.forEach(chunkArry, function (arr, i) {
                if ((i % 2) == 1) {
                    _.reverse(arr);
                }
            });
            //var pathRowData = [];
            var pathColData = [];

            // var svgArea = $('#svgviewbox').width();
            // var rowWidth = $('row').width();
            
            var grid = d3.select("#"+panel.body.id)
                .append("svg")
                .attr("id", "svgviewbox")
                .attr("preserveAspectRatio", "xMinYMin")
                .data(reverseMyData)
                .attr("width", $("#"+panel.body.id).width())
                //.attr("height", "90%")
                //.attr("height", 650)
                .attr("height", function (d, i) {
                    d.x = boxwidth;
                    d.y = (i * (boxheight + 67));
                    d.width = boxwidth * d.length;
                    d.height = boxheight;
                    if (reverseMyData.length == 1) {
                        return (d.height * reverseMyData.length) + 330;
                    } else {
                        if (Transactions.length > 10) {
                            return (d.height * reverseMyData.length) + 330;
                        } else {
                            return (d.height * reverseMyData.length) + 250;
                        }
                    }
                });

            /*------Default Transactions Block------------*/
            var highlight = grid.append("g").attr('id', (TransactionsBase.length <= diff) ? 'horizontalView' : 'verticalView');
            /*-----------Skin colors----------------*/

            var currSkin = "";
            if (strSkin == "Light") {
                currSkin = "#f2f2f2";
            } else {
                currSkin = "#575757";
            }
            //horizontalView highlightBox
            var totalWidth = "",
                outerHeight = 90,
                padding = 10;
            highlight.each(function (d, i) {
                if (TransactionsBase.length <= diff) {

                   
                    var boxWidth = [],
                        prev = 0,
                        defaultWidth = 120;
                    defaultTransactions.forEach(function (d, i) {
                        var label = d.DispName.toUpperCase(),
                            tm = new Ext.util.TextMetrics(),
                            n = d3.max([tm.getWidth(label), defaultWidth]);
                        boxWidth.push(n + padding);

                    });
                   
                    totalWidth = _.sum(boxWidth);
                    var outBox = highlight.append("rect")
                        .attr("width", totalWidth)
                        .attr("height", outerHeight)
                        .attr("rx", 10)
                        .attr("ry", 10)
                        .attr("class", "svgDefaultTransactions svgDefaultTransactionsOuter")
                        .attr("stroke-width", 2)
                        .attr("transform", "translate(0,0)");

                    var outBoxBbox = outBox.node().getBBox();

                    var highlightBox = highlight.selectAll("g")
                        .data(defaultTransactions)
                        .enter()
                        .append("g")
                        .attr("transform", function (d, i) {
                            if (i == 0) {
                                return "translate(0,0)";
                            } else {
                                var wid = boxWidth[i - 1];
                                prev = prev + wid;
                                return "translate(" + prev + ",0)";
                            }

                        }).attr("class", "dataview");



                    var rect = highlightBox.append("rect")
                        .attr("width", function (d, i) {
                            return boxWidth[i] - 1;
                        })
                        .attr("height", 90)
                        .attr("rx", 10)
                        .attr("ry", 10)
                        .attr("class", "empty")
                        .attr("fill", 'transparent')
                        .attr("x", function (d, i) {
                            {
                                return 0;
                            }
                        }).attr("y", function (d, i) {
                            {
                                return 0;
                            }
                        });
                    //separator  
                    highlightBox.append("line")
                        .attr("x1", 0)
                        .attr("y1", 10)
                        .attr("x2", 0)
                        .attr("class", "svgDivider")
                        .attr("stroke-width", function (d, i) {
                            return '1';
                        })
                        .attr("y2", (outerHeight - 10))
                        .attr("x", 0)
                        .attr("transform", function (d, i) {
                            return "translate(" + boxWidth[i] + ",0)";
                        });

                    highlightBox.append("text")
                        .attr("x", function (d, i) {
                            return boxWidth[i] / 2;
                        }).attr("y", function (d, i) {
                            return outBoxBbox.y + 30;
                        }).attr("text-anchor", "middle")
                        .attr("class", "newFont_bold13 svgBodyFontColor lbl")
                        .attr('data-qtip', function (d) {
                            return d.DispName;
                        })
                        .text(function (d) {
                            return d.DispName;
                        }).attr('text-anchor', 'middle');
                    //.call(wrap,150);

                    var outBbox = outBox.node().getBBox().width;
                    var valueField = highlightBox.append("text")
                        .attr('data-qtip', function (d) {
                            return d.Val
                        })
                        .attr("transform", function (d, i) {
                            return "translate(0,10)";
                        })
                        .attr("y", function (d, i) {
                            if (d.DispName == "Response time" || d.DispName == "Transaction processing time") {
                                return (outerHeight / 2) + 10;
                            } else {
                                return (outerHeight / 2) + 6;
                            }
                        })
                        .attr("x", function (d, i) {
                            if (d.DispName == "Response time" || d.DispName == "Transaction processing time") {
                                return boxWidth[i] / 2 - 16;
                            } else {
                                return boxWidth[i] / 2;
                            }
                        })
                        .attr("text-anchor", "middle")
                        .attr("class", function (d, i) {
                            if (defaultTransactions.length == 4) {
                                if (i == 0)
                                    return "newFont_normal12 svgBodyFontColor lbllocation";
                                else if (i == 1)
                                    return "newFont_normal12 svgBodyFontColor lbl ";
                                else if (i == 2)
                                    return "mouse newFont_normal20 svgTextState_" + d.State;
                                else if (i == 3)
                                    return "dynWidth mouse newFont_normal20 svgTextState_" + d.State;
                            } else {
                                if (i == 0)
                                    return "newFont_normal12 svgBodyFontColor lbl";
                                else if (i == 1)
                                    return "newFont_bold20 svgTextState_" + d.State;
                                else if (i == 2)
                                    return "dynWidth mouse newFont_normal20 svgTextState_" + d.State;
                            }
                        }).text(function (d, i) {
                            if (i == 0) {
                                var elipsedText = Ext.String.ellipsis(d.Val, 20, true);
                                return elipsedText;
                            } else {
                                if (defaultTransactions.length == 4) {
                                    if (i == 2)
                                        return "";
                                    else {
                                        if (i == (defaultTransactions.length - 1))
                                            return d.Val + "s";
                                        else {
                                            var elipsedText = Ext.String.ellipsis(d.Val, 20, true);
                                            return elipsedText;
                                        }
                                    }
                                } else {
                                    if (i == 1)
                                        return "";
                                    else {
                                        if (i == (defaultTransactions.length - 1))
                                            return d.Val + "s";
                                        else {
                                            var elipsedText = Ext.String.ellipsis(d.Val, 20, true);
                                            return elipsedText;
                                        }
                                    }
                                }
                            }
                        }).attr('text-anchor', 'middle').on("click", function (d, i) {
                            if (d.defaultTrans_link != undefined && d.defaultTrans_link != null) {
                                return openLink(d.defaultTrans_link, toolBarHide);
                            }
                        });

                    highlightBox.append("svg:image")
                        .attr('width', function (d, i) {
                            if (d.DispName == "Location") {
                                return 16;
                            } else if (d.DispName == "Response time" || d.DispName == "Simulated by" || d.DispName == "Transaction processing time") {
                                return null;
                            } else {
                                return 20;
                            }
                        })
                        .attr('height', function (d, i) {
                            if (d.DispName == "Location") {
                                return 16;
                            } else if (d.DispName == "Response time" || d.DispName == "Simulated by" || d.DispName == "Transaction processing time") {
                                return null;
                            } else {
                                return 20;
                            }
                        })
                        .attr("xlink:href", function (d, i) {
                            if (d.DispName == "Location") {
                                return "/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconLocation.svg";
                            } else {
                                if (d.DispName == "Response time" || d.DispName == "Simulated by" || d.DispName == "Transaction processing time") {
                                    return "";
                                } else {
                                    return "/final/monitor/eg_scripts/sessionSimulation/svg/availability_" + d.State + ".svg";
                                }

                            }
                        })
                        .attr("class", "mouse stateicon")
                        .attr("x", function (d, i) {
                            if (d.DispName == "Location") {
                                var labelHeight = d3.select(d3.select(this).node().parentNode).select('.lbllocation').node().getBBox();
                                return (labelHeight.x - 16);
                            } else {
                                return (boxWidth[i] / 2) - 20;
                            }

                        })
                        .attr("y", function (d, i) {
                            if (i == 0) {
                                if (d.DispName == "Location") {
                                    var labelHeight = d3.select(d3.select(this).node().parentNode).select('.lbllocation').node().getBBox();
                                    return (labelHeight.y + 7);

                                }

                            } else {
                                if (d.DispName == "Response time" || d.DispName == "Simulated by" || d.DispName == "Transaction processing time") {
                                    return 0;
                                } else {
                                    return (outerHeight / 2) + 3;
                                }

                            }

                        })
                        .on("click", function (d) {
                            var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                            if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                if (d.defaultTrans_link != undefined && d.defaultTrans_link != null) {
                                    return openLink(d.defaultTrans_link, toolBarHide);
                                } else if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                    return openScreenShot(d, screenshotID);
                                } else {
                                    return openWindowGraph();
                                }
                            }

                        });

                    highlightBox.append("svg:image")
                        .attr("width", function (d, i) {
                            if (d.DispName == "Simulated by" || d.DispName == "Location") {
                                return null;
                            } else {
                                return 16;
                            }
                        })
                        .attr("height", function (d, i) {
                            if (d.DispName == "Simulated by" || d.DispName == "Location") {
                                return null;
                            } else {
                                return 16;
                            }
                        })
                        .attr("xlink:href", function (d, i) {
                            if ((defaultTransactions.length == 4 && (i == 2 || i == 3)) || (defaultTransactions.length == 3 && (i == 1 || i == 2))) {
                                if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                    var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                                    if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                        return "/final/monitor/eg_scripts/sessionSimulation/svg/iconSnapshot.svg";
                                    } else if (d.State == "GOOD") {
                                        return "/final/monitor/eg_scripts/sessionSimulation/svg/iconGraph.svg";
                                    }
                                }
                            }
                        })
                        .attr("class", "mouse icon")
                        .attr("x", function (d, i) {
                            if (d.DispName == "Response time" || d.DispName == "Transaction processing time") {
                                var labelHeight = d3.select(d3.select(this).node().parentNode).select('.dynWidth').node().getBBox();
                                return (labelHeight.x + labelHeight.width + 16);
                            } else {
                                return (boxWidth[i] / 2) + 14;
                            }
                        })
                        .attr("y", function (d, i) {
                            return (outerHeight / 2) + 5;
                        })
                        .on("click", function (d, i) {
                            var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                            if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                    return openScreenShot(d, screenshotID);
                                } else {
                                    return openWindowGraph();
                                }
                            }
                        });

                } else {


                    /*var shadow = highlight.append("rect")
                        .attr("id", "drop-shadow")
                        //.attr("width", 121)
                        //.attr("height", 12)
                        .attr("rx", 10)
                        .attr("ry", 10)
                        .attr("fill", currSkin)
                        //.attr("stroke","rgb(239,239,239)")
                        .attr("transform", "translate(0,0)");*/

                    var outBox =
                        highlight.append("rect")
                        .attr("rx", 10)
                        .attr("ry", 10)
                        .attr("class", "svgDefaultTransactions svgDefaultTransactionsOuter")
                        .attr("stroke-width", 2).attr("transform", "translate(2,0)");

                    //console.log("defaultTransactions-=-=-=996>>", defaultTransactions)
                    var height = 0;
                    var boxWidth = 119;
                    var rectHeight = 80;
                    var padding_g = 20;
                    var statePadding = 20;
                    var highlightBox = highlight.selectAll("g")
                        .data(defaultTransactions)
                        .enter()
                        .append("g")
                        .attr("transform", function (d, i) {
                            return "translate(" + boxWidth / 2 + "," + rectHeight * i + ")";
                        });
                    highlightBox.append('rect')
                        .attr("width", boxWidth)
                        .attr("height", rectHeight)
                        .attr("fill", "transparent")
                        .attr("transform", function (d, i) {
                            if (i == 0) {
                                rectHeight = 1;
                            }
                            return "translate(" + (-boxWidth / 2 + 12) + "," + rectHeight * i + ")";
                        });
                    highlightBox.append('rect')
                        .attr("width", boxWidth - 20)
                        .attr("height", rectHeight)

                        .attr("class", "vseparator")
                        .attr("transform", function (d, i) {
                            if (i == 0) {
                                rectHeight = 1;
                            }
                            return "translate(" + ((-boxWidth / 2) + 12) + "," + rectHeight * i + ")";
                        });

                    //displayName
                    var displayName = highlightBox.append("text")
                        .attr("transform", function (d, i) {
                            var label = d.DispName.toUpperCase(),
                                tm = new Ext.util.TextMetrics();


                            if (boxWidth > tm.getWidth(label)) {
                                d.yPosition = (padding_g + 10);
                                return "translate(0," + (padding_g + 10) + ")";
                            } else {
                                d.yPosition = padding_g;
                                return "translate(0," + (padding_g) + ")";
                            }


                        })
                        //.attr("transform", function(d){ return "translate(55," + d.yaxis + ")";})
                        .attr("x", 0)
                        .attr("y", 0)
                        .attr("width", 123)
                        .attr("text-anchor", "middle")
                        .attr("class", "newFont_bold13 svgBodyFontColor displayNameLabel")
                        .attr('data-qtip', function (d) {
                            return d.DispName;
                        })
                        .text(function (d) {
                            return d.DispName;
                        })
                        .call(wrap, 100);

                    //var bbox = highlightBox.node().getBBox().width;
                    var locationPadding = 3;
                    highlightBox.append("text")
                        .attr('data-qtip', function (d) {
                            return d.Val
                        })
                        .attr("transform", function (d, i) {
                            var labelDim = d3.select(d3.select(this).node().parentNode).select('.displayNameLabel').node().getBBox();
                            if (d.State) {
                                return "translate(-12," + (padding_g + labelDim.height + statePadding) + ")";
                            } else {
                                if (d.DispName == "Location") {
                                    return "translate(" + locationPadding + "," + (padding_g + labelDim.height + 20) + ")";
                                } else {
                                    return "translate(0," + (padding_g + labelDim.height + 20) + ")";
                                }

                            }
                        })
                        .attr("x", 0)
                        .attr("y", 0)
                        //.attr("width",300)
                        .attr("text-anchor", "middle")
                        .attr("class", function (d, i) {
                            if (defaultTransactions.length == 4) {
                                if (i == 0) {
                                    return "newFont_normal12 svgBodyFontColor lbllocation";
                                } else if (i == 1) {
                                    return "newFont_normal12 svgBodyFontColor";
                                } else if (i == 2) {
                                    return "mouse newFont_normal20 stateText svgTextState_" + d.State;
                                } else if (i == 3) {
                                    return "dynWidth mouse stateText newFont_normal20 svgTextState_" + d.State;
                                }
                            } else {
                                if (i == 0) {
                                    return "newFont_normal12 svgBodyFontColor lbllocation";
                                } else if (i == 1) {
                                    return "newFont_bold20 stateText svgTextState_" + d.State;
                                } else if (i == 2) {
                                    return "dynWidth mouse stateText newFont_normal20 svgTextState_" + d.State;
                                }
                            }
                        })
                        .text(function (d, i) {
                            if (d.DispName == "Location") {
                                {
                                    var elipsedText = Ext.String.ellipsis(d.Val, 20, true);
                                    return elipsedText;
                                }
                            } else {
                                if (defaultTransactions.length == 4) {
                                    if (i == 0) {
                                        return d.Val;
                                    } else if (i == 1) {
                                        {
                                            var elipsedText = Ext.String.ellipsis(d.Val, 20, true);
                                            return elipsedText;
                                        }
                                    } else if (i == 2) {
                                        return "";
                                    } else if (i == 3) {
                                        return d.Val + "s";
                                    }
                                } else {
                                    if (i == 0) {
                                        {
                                            var elipsedText = Ext.String.ellipsis(d.Val, 20, true);
                                            return elipsedText;
                                        }
                                    } else if (i == 1) {
                                        {
                                            return "";
                                        }
                                    } else if (i == 2) {
                                        return d.Val + "s";
                                    }
                                }
                            }
                        })
                        .on("click", function (d, i) {
                            if (i == 1 || i == 2 || i == 3) {
                                return openLink(d.defaultTrans_link, toolBarHide);
                            } else {
                                return "";
                            }
                        });


                    //State Icon
                    highlightBox.filter(function (d, i) {
                            return (d.State && d.DispName != "Transaction processing time")
                        }).append("svg:image")
                        .attr('width', function (d, i) {
                            return 20;
                        })
                        .attr('height', function (d, i) {
                            return 20;
                        })
                        .attr("xlink:href", function (d, i) {

                            if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                return "/final/monitor/eg_scripts/sessionSimulation/svg/availability_" + d.State + ".svg";
                            }


                        })
                        //.attr("class","state_HIGH")
                        .attr("x", function (d) {
                            var labelDim = d3.select(d3.select(this).node().parentNode).select('.displayNameLabel').node().getBBox();
                            return (labelDim.x + 10);
                        })
                        .attr("y", function (d) {
                            var labelDim = d3.select(d3.select(this).node().parentNode).select('.displayNameLabel').node().getBBox();

                            if (d.State) {
                                //console.log('d.yPosition', d.yPosition);
                                return (padding_g + labelDim.height);
                            }
                        })
                        .attr("class", "mouse stateIcon")
                        .on("click", function (d) {
                            var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                            if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                if (d.defaultTrans_link != undefined && d.defaultTrans_link != null) {
                                    return openLink(d.defaultTrans_link, toolBarHide);
                                } else if (d.State === "HIGH") {
                                    return openScreenShot(d, screenshotID);
                                } else {
                                    return openWindowGraph();
                                }
                            }
                        });




                    highlightBox.append("svg:image")
                        .attr("width", function (d, i) {
                            if (d.DispName == "Simulated by" || d.DispName == "Location") {
                                return 16;
                            } else {
                                return 18;
                            }
                        })
                        .attr("height", function (d, i) {
                            if (d.DispName == "Simulated by" || d.DispName == "Location") {
                                return 16;
                            } else {
                                return 16;
                            }
                        })
                        .attr("xlink:href", function (d, i) {
                            if (i == 0) {
                                if (d.DispName == "Location") {
                                    return "/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconLocation.svg";
                                }
                            } else if ((defaultTransactions.length == 4 && (i == 2 || i == 3)) || (defaultTransactions.length == 3 && (i == 1 || i == 2))) {
                                if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                    var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                                    if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                        return "/final/monitor/eg_scripts/sessionSimulation/svg/iconSnapshot.svg";
                                    } else if (d.State == "GOOD") {
                                        return "/final/monitor/eg_scripts/sessionSimulation/svg/iconGraph.svg";
                                    }
                                }
                            }

                        })
                        .attr("class", "mouse")
                        .attr("x", function (d, i) {
                            if (d.DispName == "Location") {
                                var labelHeight = d3.select(d3.select(this).node().parentNode).select('.lbllocation').node().getBBox();
                                return ((labelHeight.x + locationPadding) - 18);
                            } else {
                                if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                    var labelDim = d3.select(d3.select(this).node().parentNode).select('.stateText').node().getBBox();

                                    var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                                    if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                        //snapICON

                                        return labelDim.width + 8;
                                    } else {
                                        //graphICON
                                        if (d.DispName == "Transaction processing time") {
                                            return (labelDim.x + labelDim.width);
                                        } else {
                                            return (labelDim.x + labelDim.width) + 8;
                                        }

                                    }
                                }
                            }
                        })
                        .attr("y", function (d, i) {
                            if (i == 0) {
                                if (d.DispName == "Location") {
                                    var labelHeight = d3.select(d3.select(this).node().parentNode).select('.lbllocation').node().getBBox();
                                    return (padding_g + labelHeight.height + 6);

                                }

                            } else {
                                if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {


                                    var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                                    if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                        //snapICON
                                        var stateDim = d3.select(d3.select(this).node().parentNode).select('.stateIcon').node().getBBox();
                                        //console.log('stateDIM', stateDim)
                                        return stateDim.y + 2;
                                    } else if (d.State == "GOOD") {
                                        var labelDim = d3.select(d3.select(this).node().parentNode).select('.displayNameLabel').node().getBBox();

                                        //graphICON

                                        return (padding_g + labelDim.height + statePadding) - 16;
                                    }
                                }
                            }
                        })
                        .on("click", function (d) {
                            var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                            //console.log("screenshotID--1231->>>", screenshotID);
                            if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                if (d.State === "HIGH") {
                                    return openScreenShot(d, screenshotID);
                                } else {
                                    //alert(123)
                                    return openWindowGraph();
                                }
                            }
                        });
                    //.attr("y","80");
                    var verticalView = d3.select('#verticalView').node().getBBox();
                    //console.log('ver', height);
                    //shadow.attr('height', verticalView.height).attr('width', 119);
                    outBox.attr('height', (verticalView.height + 6)).attr('width', 119);
                }

                //setting in center highlightBox;

                var panelBody = $('#main-body').width() / 2 - 10;
                var svgHeight = $('#svgviewbox').height(); //TODO needs to reformat all logics 
                var hightboxY = (svgHeight - outerHeight) - 40;


                // alert('totalWidth'+totalWidth)

                d3.select(this).attr("transform", function () {
                    if (TransactionsBase.length <= diff) {

                        if (screen.width <= 1366) {
                            return "translate(" + (width / 2 - totalWidth / 2) + "," + hightboxY + ")";

                        } else {

                            return "translate(" + (((width / 2) - (totalWidth / 2)) + 30) + "," + hightboxY + ")";
                        }
                    } else {
                        return "translate(0,160)";
                    }

                });

            });




            /*------Marker Arrow and Line------------*/

            var marker = grid.append('defs')
                .append('marker').attr('id', 'arrow')
                .attr('viewBox', '0 0 3 6')
                //.style("fill", "#e9e9ea")
                .attr('class', 'svgArrowColor')
                .attr('refX', 0)
                .attr('refY', 3)
                .attr('markerWidth', 3)
                .attr('markerHeight', 3)
                .attr('orient', 'auto');
            marker.append('path')
                .attr("d", 'M0,0,3,3,0,6Z'); 

            var marker2 = grid.append('defs')
                .append('marker').attr('id', 'arrowleft')
                .attr('viewBox', '0 0 3 6')
                // .style("fill", "#e9e9ea")
                .attr('class', 'svgArrowColor')
                .attr('refX', 1)
                .attr('refY', 3)
                .attr('markerWidth', 3)
                .attr('markerHeight', 3)
                .attr('orient', 'auto').append('path')
                .attr("d", 'M3,6,0,3,3,0Z');

            /*------Circle ------------*/
            var circle = grid.append('defs')
                .append('marker').attr('id', 'circle')
                .attr('viewBox', '0 0 19 19')
                //.style("fill", "#e9e9ea")
                .attr('class', 'svgArrowColor')
                .attr('refX', 11)
                .attr('refY', 10)
                .attr('markerWidth', 6)
                .attr('markerHeight', 6)
                .attr('orient', 'auto').append('circle')
                .attr("cx", 10)
                .attr("cy", 10)
                .attr("r", 5)

            counter = 1;
            bj = Math.round(boxwidth);
            var x = d3.scaleLinear().range([bj, 0]);
            var x2 = d3.scaleLinear().range([0, bj]);

            /*------Transactions ------------*/

            var mainGrp = grid.append("g").attr('id', 'simulationView');
            var transGroup = mainGrp.append("g")
                .attr("id", "transactions")
                .attr("transform", function (d, i) {
                    if (TransactionsBase.length <= diff) {
                        if (TransactionsBase.length <= 4) {

                            if (screen.width <= 1365) {
                                return "translate(0,-60)";
                            } else if (screen.width == 1366) {
                                return "translate(0,-60)";
                            } else {
                                return "translate(0,-60)";
                            }
                        } else {
                            if (screen.width <= 1366) {
                                if (TransactionsBase.length <= 5 && !toolBarHide)
                                    return "translate(0,-60)";
                                else
                                    return "translate(0,0)";
                            } else {
                                return "translate(0,0)";
                            }
                        }
                    } else {
                        if (TransactionsBase.length <= 4) {
                            if (screen.width <= 1366) {
                                return "translate(0,0)";
                            } else {
                                return "translate(0,0)";
                            }
                        } else {
                            if (screen.width <= 1366) {
                                if (TransactionsBase.length <= 5 && !toolBarHide)
                                    return "translate(0,-60)";
                                else
                                    return "translate(0,0)";
                            } else {
                                return "translate(0,0)";
                            }
                        }
                    }
                })
                .each(function () {
                    d3.select(this).append("svg:image") // <-B
                        .attr("width", 64)
                        .attr("height", 64)
                        .attr("transform", function (d, i) {
                            if (TransactionsBase.length <= diff) {
                                return "translate(" + 50 + "," + 182 + ")";
                            } else {
                                return "translate(45,35)";
                            }

                        })
                        .attr("xlink:href", function (d) {
                            return "/final/monitor/eg_scripts/sessionSimulation/svg/transactions.svg";
                        });

                    var transArrow = d3.select(this).append("path") // <-A
                        //.attr("stroke", "#ffffff")
                        //.style("stroke", "#E9E8E9")
                        .attr('class', 'svgLineColor')
                        .style("stroke-width", "4")
                        .style("opacity", 1)
                        //.attr("d","M70,125L232,125" )
                        .attr("d", "M70,125L176,125")
                        .attr('transform', function (d, i) {

                            if (TransactionsBase.length <= diff) {
                                return "translate(" + 10 + "," + 150 + ")";
                            } else {
                                return 'translate(10,0)';
                            }

                        })
                        .attr('marker-end', 'url(#arrow)');

                    var vtransArrow = d3.select(this).append("path")
                        //.style("stroke", "#E9E8E9")
                        .attr('class', 'svgLineColor')
                        .style("stroke-width", "4")
                        .style("opacity", 1)
                        .attr("d", "M31 0 v5 5")
                        .attr('transform', function (d, i) {

                            if (TransactionsBase.length <= diff) {
                                return "translate(" + 51 + "," + 265 + ")";
                            } else {
                                return 'translate(51,115)';
                            }

                        });

                    var transText = d3.select(this).append("text") // <-A
                        //.attr("stroke", "#ffffff")
                        //.data(Transactions)
                        .attr("x", "40")
                        .attr("y", "110")
                        .attr("class", "newFont_normal12 svgBodyFontColor")
                        .attr('transform', function (d, i) {
                            if (TransactionsBase.length <= diff) {
                                return "translate(" + 6 + "," + 150 + ")";
                            } else {
                                return 'translate(6,0)';
                            }
                        })
                        .text(function (d, i) {
                            return "Transactions";
                        });
                })

            /*------Row Data start------------*/
            var row = mainGrp.selectAll(".row")
                .data(reverseMyData)
                .enter();
            var rowbox = row.append("g")
                .attr("class", function (d, i) {
                    return "row" + i;
                })
                .attr("transform", function (d, i) {
                    d.x = boxwidth;
                    d.y = (i * (boxheight + 67));
                    d.width = boxwidth * d.length;
                    d.height = boxheight;
                    if (TransactionsBase.length <= diff) {
                        if (TransactionsBase.length <= 4) {
                            if (screen.width <= 1366) {
                                return "translate(" + d.x + "," + (d.y + 90) + ")";
                            } else {
                                return "translate(" + d.x + "," + (d.y + 90) + ")";
                            }
                        } else {
                            if (screen.width <= 1366) {
                                return "translate(" + d.x + "," + (d.y + 90) + ")";
                            } else {
                                return "translate(" + d.x + "," + (d.y + 150) + ")";
                            }
                        }
                    } else {
                        return "translate(" + d.x + "," + d.y + ")";

                    }
                });
            var jj = chartarea;
            rowbox.each(function (d, i) {

                if (i == 0) {
                    jj = d.width - d.x;
                }
                /*var len = d.length;
                var actWidth = d.width - d.x;
                var diffWidth = chartarea - actWidth;
                var dWidth = chartarea;*/
                d.forEach(function (elObj, k) {
                    //same y position for both 
                    if ((i % 2) == 1) {
                        elObj.direction = 'left';
                        //width-x(d.value)
                        // (chartarea - boxwidth * ((d.length) - k))
                        // elObj.x =(chartarea - boxwidth * ((d.length) - k));
                        elObj.id = 'columnID' + k;
                        elObj.x = jj - boxwidth * ((d.length) - k) + d.x;
                        elObj.id = i;
                        elObj.y = boxheight / 2;
                        if (diff >= d.length) {
                            if (elObj.x < diff) {
                                elObj.first = true;
                            }
                        }
                        pathColData.push({
                            x: elObj.x,
                            y: elObj.y
                        });
                    } else {
                        elObj.x = boxwidth * k;
                        elObj.id = 'columnID' + k;
                        elObj.direction = 'right';
                        elObj.y = boxheight / 2;
                        if (diff >= d.length) {
                            if (elObj.x == jj) {
                                elObj.last = true;
                            } else if (elObj.x == 0) {
                                elObj.jfirst = true;
                            }
                        }

                        pathColData.push({
                            x: elObj.x,
                            y: elObj.y
                        });
                    }
                    if (elObj.x >= (chartarea - boxwidth)) {
                        elObj.collast = true;
                    }

                });
                counter = 1;
                //windowResize();
            });
            d3.selection.prototype.moveUp = function () {
                return this.each(function () {
                    this.parentNode.appendChild(this);
                });
            };
            var column = rowbox.selectAll(".square")
                .data(function (d, i) {
                    return d;
                }).enter();

            var columnbox = column.insert('g', ":first-child")
                .attr("class", "square").attr("transform", function (d, i) {

                    return "translate(" + (d.x + 40) + ",0)";
                }).attr("id", function (d, i) {

                    return d.id;
                });

            columnbox.append('rect')
                .attr("height", function (d, i) {
                    return boxwidth
                })
                .attr("width", function (d, i) {
                    return boxheight
                })
                .attr("fill", "none");

            columnbox.append('circle')
                .attr("r", function (d, i) {
                    return 43;
                })
                .attr("cx", function (d, i) {
                    return 75;
                }).attr("cy", function (d, i) {
                    return d.y + 8;
                })
                //.attr("stroke", "#E9E8E9")
                .attr('class', 'svgLineColor')
                .attr("stroke-width", "4")
                .attr("fill", "none");
            var gT = columnbox.append('g')
                .attr("transform", function (d, i) {
                    return "translate(" + 100 + "," + 110 + ")";
                });

            columnbox.append('rect')
                .attr("width", 22)
                .attr("height", 8)
                .attr("class", "svgCircleOvercolor")
                .attr("transform", function (d, i) {
                    if (d.direction == "right") {
                        return "translate(90, 117)";
                    } else {
                        return "translate(45, 117)";
                    }

                });

            var gT = columnbox.append('g')
                .attr("transform", function (d, i) {
                    return "translate(" + 80 + "," + 155 + ")";
                }).attr('class', 'g_text');

            gT.append('text')
                .attr("text-anchor", "middle")
                .attr('data-qtip', function (d) {
                    return d.Transaction_Name;
                })
                .text(function (d) {
                    if (d.Transaction_Name.length > 20) {
                        var substringText = wordTruncate(d.Transaction_Name,20);
                        return substringText;
                    }
                    return d.Transaction_Name;
                })
                .attr('y', '0')
                .attr("class", function (d, i) {
                    return "mouse newFont_normal12 svgBodyFontColor";
                })
                .on('click', function (d) {
                    if (d3.event.defaultPrevented) return;
                    if (timer) clearTimeout(timer);
                    timer = setTimeout(function () {
                        if (toolBarHide)
                            window.parent.location.href = d.Transaction_link;
                        else
                            window.location.href = d.Transaction_link;
                    }, 250);
                });

            /*--------Transaction state------------*/
            var achr = gT
                .append('a')
                .attr("class", function (d, i) {
                    return "mouse";
                });

            achr.append('svg:image')
                .attr("width", 20)
                .attr("height", 20)
                .attr("xlink:href", function (d) {
                    if (!Ext.isEmpty(d.Transaction_Avail_State) && d.Transaction_Avail_State != null && d.Transaction_Avail_State != undefined)
                        return "/final/monitor/eg_scripts/sessionSimulation/svg/state_symbol_" + d.Transaction_Avail_State + ".svg";
                })
                .attr("transform", function (d, i) {
                    return "translate(-36,6)"
                })
                .on("click", function (d) {
                    return openLink(d.Transaction_link, toolBarHide);
                });




            achr.append('text')
                .attr("text-anchor", "middle")
                .attr("class", function (d, i) {
                    if (d.Transaction_Avail_State == "GOOD") {
                        return "newFont_normal12 svgBodyFontColor";
                    } else {
                        return "newFont_normal12 svgBodyFontColor";
                    }
                })
                .text(function (d) {
                    if (d.sta_val == "Yes") {
                        return "Success";
                    } else {
                        return "Failed";
                    }

                })
                .attr("transform", function (d, i) {
                    if (d.Transaction_Avail_State == "GOOD") {
                        return "translate(4,20)";
                    } else {
                        return "translate(-2,20)";
                    }
                })
                .on("click", function (d) {
                    return openLink(d.Transaction_link, toolBarHide);
                });



            achr.append("svg:image")
                .attr("width", 16)
                .attr("height", 16)
                .attr("xlink:href", function (d, i) {
                    var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.Transaction_Avail_State);
                    if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-")
                        return "/final/monitor/eg_scripts/sessionSimulation/svg/iconSnapshot.svg";
                })
                //.attr("class","state_HIGH")
                .attr("transform", function (d, i) {
                    if (d.Transaction_Avail_State == "GOOD")
                        return "translate(30,8)";
                    else
                        return "translate(20,8)";
                })
                .attr("class", "mouse")
                .on("click", function (d) {
                    var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.Transaction_Avail_State);
                    //console.log("screenshotID--1730->>>", screenshotID);
                    return openScreenShot(d, screenshotID);
                });
            //.attr("y","80");  

            /*--------Transaction value state------------*/
            var tranval = achr.append("g")
                .attr("transform", function (d, i) {
                    return "translate(-35,0)"
                });

            tranval.append('svg:image')
                .attr("class", "transval")
                .attr("width", 20)
                .attr("height", 20)
                .attr("xlink:href", function (d, i) {
                    if (!Ext.isEmpty(d.Transaction_Val_State) && d.Transaction_Val_State != null && d.Transaction_Val_State != undefined)
                        return "/final/monitor/eg_scripts/sessionSimulation/svg/state_symbol_" + d.Transaction_Val_State + ".svg";
                })
                .attr("transform", function (d, i) {
                    return "translate(-2,26)";
                })
                .on("click", function (d) {
                    return openLink(d.Transaction_link, toolBarHide);
                });

            //`//alert(parseInt(d3.select('#transval').style("width")));	

            /*var stateIconSmallW = parseInt(d3.select('#transval').style("width"));
            if (isNaN(stateIconSmallW))
                stateIconSmallW = 18;*/

            tranval.append('text')
                .attr("text-anchor", "start")
                //.attr("id", "transVal")
                //.attr("class","font_normal11 svgBodyFontColor")
                //svgTextState_"+d.Transaction_Val_State
                .attr("class", function (d, i) {
                    return "newFont_bold12 svgBodyFontColor transval";
                })
                .text(function (d) {
                    return d.Transaction_Val + d.Transaction_Val_Unit;
                })
                .attr("transform", function (d, i) {
                    return "translate(16,40)";
                })
                .on("click", function (d) {
                    return openLink(d.Transaction_link, toolBarHide);
                });




            /*gT.append('text')
    .attr("text-anchor", "middle")
    //.attr("class","font_normal11 svgBodyFontColor")
    .attr("class", function(d,i){
        return "font_bold11 svgUnitFontColor"
    })
    .text(function (d) {
        return d.Transaction_Val_Unit
    })
    .attr("x",function(d){
        ////alert(d3.select('#transVal').node());
        var currTrans = d.Transaction_Val
        var currTextElementWidth=currTrans.length*3.7
        return currTextElementWidth
    });*/



            var line = d3.line();
            var curvePath = d3.select("#curve");

            function positionLink(d, bool) {
                var sweep = bool ? 0 : 1;
                return "M0 217 A75 75 0 1 " + sweep + " 0,0";
            }
            var link = d3.linkRadial()
                .angle(function (d) {
                    return d.x;
                })
                .radius(function (d) {
                    return d.y;
                });
            columnbox.filter(function (d, i) {
                return (d.first || d.last);

            }).each(
                function (d, i) {
                    /*----------curve line----------------*/
                    var lineCurve = d3.select(this).append('path')
                        .attr("fill", "none")
                        .attr("id", function () {

                            return "curve" + d.index;
                        })
                        .attr('class', 'svgLineColor line')
                        .attr("stroke-width", "4px")
                        .attr("refX", "2")
                        .attr("refY", "6")
                        .attr("pathLength", 250)
                        .attr("d", function (d, i) {
                            return positionLink([d], d.last);
                        }).attr("transform", function (d, i) {
                            if (d.last == true) {
                                if (d.collast == true) {
                                    return "translate(" + (boxwidth - 35) + "," + 125 + ")";
                                } else {
                                    return "translate(" + (boxwidth - 35) + "," + 125 + ")";
                                }

                            } else {
                                return "translate(" + (67) + "," + 125 + ")";
                            }

                        });
                    if (d.index != Transactions.length) {

                        if (d.direction == "right") {

                            d3.select(this).append('path')
                                .attr("d", 'M13,0,6.5,6.5,0,0Z')
                                //.attr('fill', '#fff')
                                .attr('class', 'svgBreakColor')
                                .attr("transform", "translate(236.8, 220)");

                            var marker3 = d3.select(this).append('path')
                                .attr("d", 'M13,0,6.5,6.5,0,0Z')
                                .attr('class', 'svgArrowColor curvearrow')
                                .attr("transform", "translate(236, 219) rotate(-2)");
                            /*var whiteBox = d3.select(this).append('line')
                                .attr("x1", 5)
                                .attr("x2", 30)
                                .attr("y1", 5)
                                .attr('class', 'svgBreakColor')
                                //.attr("stroke","#ffffff")
                                .attr("y2", 10)
                                .attr("stroke-width", 2)
                                .attr("transform", "translate(217, 221)")*/
                        } else {
                            d3.select(this).append('path')
                                .attr("d", 'M13,0,6.5,6.5,0,0Z')
                                //.attr('fill', '#fff')
                                .attr('class', 'svgBreakColor')
                                .attr("transform", "translate(-48, 223)");

                            var marker3 = d3.select(this).append('path')
                                .attr("d", 'M13,0,6.5,6.5,0,0Z')
                                .attr('class', 'svgArrowColor curvearrow')
                                .attr("transform", "translate(-47, 220) rotate(3)");
                            /*var whiteBox = d3.select(this).append('line')
                                .attr("x1", 5)
                                .attr("x2", 30)
                                .attr("y1", 5)
                                .attr('class', 'svgBreakColor')
                                .attr("stroke","#000")
                                .attr("y2", 10)
                                .attr("stroke-width", 2)
                                .attr("transform", "translate(-48, 225)")*/
                        }
                    }
                }
            )
            var lineGenerator = d3.line();
            columnbox
                //.filter(function (d, i) {
                //  return !d.collast;
                //})
                .each(function (d, i) {
                    var linePath = d3.select(this).append("path")
                        //.style("stroke", "#E9E8E9")
                        .attr('class', 'svgLineColor')
                        .style("stroke-width", "4")
                        .style("opacity", 1)
                        .attr("d", function (d) {

                            if (d.direction == "right") {
                                x1 = (boxwidth / 2) - 82;
                                x2 = d.y + boxwidth - 80;
                                y1 = boxheight - 25;
                                y2 = boxheight - 25;
                                if (d.collast) {
                                    x1 = (boxwidth / 2) - 45;
                                    x2 = d.y + boxwidth - 90;
                                }

                            } else {
                                x1 = (boxwidth / 2) - 45;
                                x2 = d.y + boxwidth - 131;
                                y1 = boxheight - 25;
                                y2 = boxheight - 25;
                                if (d.collast) {
                                    x1 = (boxwidth / 2) - 45;
                                    x2 = d.y + boxwidth - 190;
                                }
                            }
                            return lineGenerator([
                                [x1, y1],
                                [x2, y2]
                            ]);
                        });

                    /*-----------Arrow directions----------------------*/
                    //var curvePath=d3.select("#curve");

                    if (d.direction == "right") {
                        if (d.collast == true && d.last == true) {
                            //linePath.attr('marker-end', '');
                            //linePath.attr('marker-end', '');
                            if (d.index == Transactions.length) {
                                //changed by dinesh
                                linePath.attr('d', 'M3,125L165,125');
                                linePath.attr('marker-end', 'url(#circle)');
                                d3.select("#curve" + d.index).style("display", "none");
                                //curvePath.style("display", "none");
                            } else {
                                //changed by dinesh
                                linePath.attr('d', 'M3,125L145,125');
                                linePath.attr('marker-start', '');
                            }
                        } else if (d.last == true) {
                            if (d.index == Transactions.length) {
                                if (Transactions.length == 1)
                                    linePath.attr('d', 'M-15,125L165,125');
                                else
                                    linePath.attr('d', 'M3,125L165,125');
                                linePath.attr('marker-end', 'url(#circle)');
                                //curvePath.style("display", "none");
                                d3.select("#curve" + d.index).style("display", "none");
                            } else {
                                linePath.attr('d', 'M42,125L175,125');
                                linePath.attr('transform', 'translate(-40, 0)');
                                linePath.attr('marker-start', '');
                            }
                            //curvePath.style("display", "none");
                        } else {
                            if (d.index == Transactions.length) {
                                //linePath.attr('d', 'M55,125L165,125');
                                linePath.attr('d', 'M3,125L125,125'); /*----changed vijay------*/

                                if (d.jfirst == true)
                                    linePath.attr('transform', 'translate(50, 0)'); /*----changed vijay------*/
                                else
                                    linePath.attr('transform', 'translate(0, 0)'); /*----changed vijay------*/

                                linePath.attr('marker-end', 'url(#circle)');
                                //curvePath.style("display", "none");
                            } else {

                                linePath.attr('marker-end', 'url(#arrow)');
                                //linePath.attr('d', 'M55,125L203,125');
                                ////alert(rowbox.attr("class"));
                                if (reverseMyData.length > 2) {
                                    if (d.index == 1) {
                                        linePath.attr('d', 'M-15,125L165,125');
                                    } else {
                                        if (d.jfirst == true)
                                            linePath.attr('d', 'M55,125L175,125');
                                        //linePath.attr('d', 'M12,125L175,125');
                                    }

                                } else if (d.index == 1) {
                                    linePath.attr('d', 'M-16,125L165,125');
                                }
                            }
                        }
                    } else {
                        if (d.collast == true && d.last == true) {
                            if (d.index == Transactions.length) {
                                linePath.attr('d', 'M3,125L165,125');
                                linePath.attr('marker-end', 'url(#circle)');
                                //curvePath.style("display", "none");
                            } else {
                                linePath.attr('d', 'M40,125L145,125');
                                linePath.attr('marker-end', '');
                            }


                        } else if (d.last == true) {
                            if (d.index == Transactions.length) {
                                linePath.attr('d', 'M3,125L165,125');
                                linePath.attr('marker-end', 'url(#circle)');
                                //curvePath.style("display", "none");
                            } else {
                                linePath.attr('d', 'M45,125L145,125');
                                linePath.attr('marker-end', '');
                            }
                        } else if (d.first == true) {
                            if (d.index == Transactions.length) {
                                linePath.attr('d', 'M-20,125L146,125');
                                linePath.attr('marker-start', 'url(#circle)');
                                d3.select("#curve" + d.index).style("display", "none");
                                //d3.select("#curve").style("display", "none");
                            } else {
                                linePath.attr('d', 'M56,125L145,125');
                                linePath.attr('marker-start', '');
                            }
                        } else {
                            if (d.index == Transactions.length) {
                                linePath.attr('d', 'M-20,125L146,125');
                                linePath.attr('marker-start', 'url(#circle)');
                                //curvePath.style("display", "none");
                            } else {
                                linePath.attr('d', 'M-21,125L145,125');
                                linePath.attr('marker-start', 'url(#arrowleft)');

                            }
                        }
                    }

                    var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.Transaction_State);

                    d3.select(this).append('svg:image')
                        .attr("width", 27)
                        .attr("height", 27)
                        .attr("transform", function (d, i) {
                            var circle = d3.select(this.parentNode).select('circle').node().getBBox();
                            var x = (45 + 18);
                            var y = circle.height + 25;
                            return "translate(" + x + "," + y + ")";
                        })
                        .attr("class", function () {
                            return "mouse stateIcon";
                        })
                        .attr("xlink:href", function (d) {
                            return "/final/monitor/eg_scripts/sessionSimulation/svg/state_" + d.Transaction_State + ".svg";
                        })
                        .on("click", function (d) {
                            return openLink(d.Transaction_link, toolBarHide);
                        });


                    d3.select(this).append('svg:image')
                        .attr('width', 30)
                        .attr('height', 30)
                        .attr('class', 'mouse transactionImages')
                        .attr("transform", function (d, i) {
                            var x = (45 + 15);
                            var y = (45 + 18);
                            return "translate(" + x + "," + y + ")"
                        })
                        .attr("xlink:href", function (d) {
                            return "/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/" + d.Transaction_Image + ".svg"
                        })
                        .on("click", function (d) {
                            return popupWindow(d.Info_Name);
                        });
                });
        } else if (isOnlyTotal) {

              var selectedIcon = '',
                width = $(window).width() - 240;
            height = document.body.clientHeight; //needs to change
            boxwidth = 170;
            boxheight = 150;
            chartarea = Math.round(width - (boxwidth * 2)),
                diff = Math.round(chartarea / boxwidth);

            var chunkArry = _.chunk(Transactions, diff);
            var reverseMyData = _.forEach(chunkArry, function (arr, i) {
                if ((i % 2) == 1) {
                    _.reverse(arr);
                }
            });
            //var pathRowData = [];
            var pathColData = [];

            // var svgArea = $('#svgviewbox').width();
            // var rowWidth = $('row').width();
            
            var grid = d3.select("#"+panel.body.id)
                .append("svg")
                .attr("id", "svgviewbox")
                .attr("preserveAspectRatio", "xMinYMin")
                .data(reverseMyData)
                .attr("width", $("#"+panel.body.id).width())
                //.attr("height", "90%")
                //.attr("height", 650)
                .attr("height", function (d, i) {
                    d.x = boxwidth;
                    d.y = (i * (boxheight + 67));
                    d.width = boxwidth * d.length;
                    d.height = boxheight;
                    if (reverseMyData.length == 1) {
                        return (d.height * reverseMyData.length) + 330;
                    } else {
                        if (Transactions.length > 10) {
                            return (d.height * reverseMyData.length) + 330;
                        } else {
                            return (d.height * reverseMyData.length) + 250;
                        }
                    }
                });

            /*------Default Transactions Block------------*/
            var highlight = grid.append("g").attr('id', (TransactionsBase.length <= diff) ? 'horizontalView' : 'verticalView');
            /*-----------Skin colors----------------*/

            var currSkin = "";
            if (strSkin == "Light") {
                currSkin = "#f2f2f2";
            } else {
                currSkin = "#575757";
            }
            //horizontalView highlightBox
            var totalWidth = "",
                outerHeight = 90,
                padding = 10;
            highlight.each(function (d, i) {
                if (TransactionsBase.length <= diff) {

                   
                    var boxWidth = [],
                        prev = 0,
                        defaultWidth = 120;
					
                    defaultTransactions.forEach(function (d, i) {
                        var label = d.DispName.toUpperCase(),
                            tm = new Ext.util.TextMetrics(),
                            n = d3.max([tm.getWidth(label), defaultWidth]);
                        boxWidth.push(n + padding);

                    });
                   
                    totalWidth = _.sum(boxWidth);
                    var outBox = highlight.append("rect")
                        .attr("width", totalWidth)
                        .attr("height", outerHeight)
                        .attr("rx", 10)
                        .attr("ry", 10)
                        .attr("class", "svgDefaultTransactions svgDefaultTransactionsOuter")
                        .attr("stroke-width", 2)
                        .attr("transform", "translate(0,0)");

                    var outBoxBbox = outBox.node().getBBox();

                    var highlightBox = highlight.selectAll("g")
                        .data(defaultTransactions)
                        .enter()
                        .append("g")
                        .attr("transform", function (d, i) {
                            if (i == 0) {
                                return "translate(0,0)";
                            } else {
                                var wid = boxWidth[i - 1];
                                prev = prev + wid;
                                return "translate(" + prev + ",0)";
                            }

                        }).attr("class", "dataview");



                    var rect = highlightBox.append("rect")
                        .attr("width", function (d, i) {
                            return boxWidth[i] - 1;
                        })
                        .attr("height", 90)
                        .attr("rx", 10)
                        .attr("ry", 10)
                        .attr("class", "empty")
                        .attr("fill", 'transparent')
                        .attr("x", function (d, i) {
                            {
                                return 0;
                            }
                        }).attr("y", function (d, i) {
                            {
                                return 0;
                            }
                        });
                    //separator  
                    highlightBox.append("line")
                        .attr("x1", 0)
                        .attr("y1", 10)
                        .attr("x2", 0)
                        .attr("class", "svgDivider")
                        .attr("stroke-width", function (d, i) {
                            return '1';
                        })
                        .attr("y2", (outerHeight - 10))
                        .attr("x", 0)
                        .attr("transform", function (d, i) {
                            return "translate(" + boxWidth[i] + ",0)";
                        });

                    highlightBox.append("text")
                        .attr("x", function (d, i) {
                            return boxWidth[i] / 2;
                        }).attr("y", function (d, i) {
                            return outBoxBbox.y + 30;
                        }).attr("text-anchor", "middle")
                        .attr("class", "newFont_bold13 svgBodyFontColor lbl")
                        .attr('data-qtip', function (d) {
                            return d.DispName;
                        })
                        .text(function (d) {
                            return d.DispName;
                        }).attr('text-anchor', 'middle');
                    //.call(wrap,150);

                    var outBbox = outBox.node().getBBox().width;
                    var valueField = highlightBox.append("text")
                        .attr('data-qtip', function (d) {
                            return d.Val
                        })
                        .attr("transform", function (d, i) {
                            return "translate(0,10)";
                        })
                        .attr("y", function (d, i) {
                            if (d.DispName == "Response time" || d.DispName == "Transaction processing time") {
                                return (outerHeight / 2) + 10;
                            } else {
                                return (outerHeight / 2) + 6;
                            }
                        })
                        .attr("x", function (d, i) {
                            if (d.DispName == "Response time" || d.DispName == "Transaction processing time") {
                                return boxWidth[i] / 2 - 16;
                            } else {
                                return boxWidth[i] / 2;
                            }
                        })
                        .attr("text-anchor", "middle")
                        .attr("class", function (d, i) {
                            if (defaultTransactions.length == 4) {
                                if (i == 0)
                                    return "newFont_normal12 svgBodyFontColor lbllocation";
                                else if (i == 1)
                                    return "newFont_normal12 svgBodyFontColor lbl ";
                                else if (i == 2)
                                    return "mouse newFont_normal20 svgTextState_" + d.State;
                                else if (i == 3)
                                    return "dynWidth mouse newFont_normal20 svgTextState_" + d.State;
                            } else {
                                if (i == 0)
                                    return "newFont_normal12 svgBodyFontColor lbl";
                                else if (i == 1)
                                    return "newFont_bold20 svgTextState_" + d.State;
                                else if (i == 2)
                                    return "dynWidth mouse newFont_normal20 svgTextState_" + d.State;
                            }
                        }).text(function (d, i) {
                            if (i == 0) {
                                var elipsedText = Ext.String.ellipsis(d.Val, 20, true);
                                return elipsedText;
                            } else {
                                if (defaultTransactions.length == 4) {
                                    if (i == 2)
                                        return "";
                                    else {
                                        if (i == (defaultTransactions.length - 1))
                                            return d.Val + "s";
                                        else {
                                            var elipsedText = Ext.String.ellipsis(d.Val, 20, true);
                                            return elipsedText;
                                        }
                                    }
                                } else {
                                    if (i == 1)
                                        return "";
                                    else {
                                        if (i == (defaultTransactions.length - 1))
                                            return d.Val + "s";
                                        else {
                                            var elipsedText = Ext.String.ellipsis(d.Val, 20, true);
                                            return elipsedText;
                                        }
                                    }
                                }
                            }
                        }).attr('text-anchor', 'middle').on("click", function (d, i) {
                            if (d.defaultTrans_link != undefined && d.defaultTrans_link != null) {
                                return openLink(d.defaultTrans_link, toolBarHide);
                            }
                        });

                    highlightBox.append("svg:image")
                        .attr('width', function (d, i) {
                            if (d.DispName == "Location") {
                                return 16;
                            } else if (d.DispName == "Response time" || d.DispName == "Simulated by" || d.DispName == "Transaction processing time") {
                                return null;
                            } else {
                                return 24;
                            }
                        })
                        .attr('height', function (d, i) {
                            if (d.DispName == "Location") {
                                return 16;
                            } else if (d.DispName == "Response time" || d.DispName == "Simulated by" || d.DispName == "Transaction processing time") {
                                return null;
                            } else {
                                return 22;
                            }
                        })
                        .attr("xlink:href", function (d, i) {
                            if (d.DispName == "Location") {
                                return "/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconLocation.svg";
                            } else {
                                if (d.DispName == "Response time" || d.DispName == "Simulated by" || d.DispName == "Transaction processing time") {
                                    return null;
                                } else {
                                    return "/final/monitor/eg_scripts/sessionSimulation/svg/availability_" + d.State + ".svg";
                                }

                            }
                        })
                        .attr("class", "mouse stateicon")
                        .attr("x", function (d, i) {
                            if (d.DispName == "Location") {
                                var labelHeight = d3.select(d3.select(this).node().parentNode).select('.lbllocation').node().getBBox();
                                return (labelHeight.x - 16);
                            } else {
								 if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                    var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                                    if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                     
										return (boxWidth[i] / 2) - 22;
                                    } else {
                                  
										return (boxWidth[i] / 2) - 11;
                                    }
                                }
                                
                            }

                        })
                        .attr("y", function (d, i) {
                            if (i == 0) {
                                if (d.DispName == "Location") {
                                    var labelHeight = d3.select(d3.select(this).node().parentNode).select('.lbllocation').node().getBBox();
                                    return (labelHeight.y + 7);

                                }

                            } else {
                                if (d.DispName == "Response time" || d.DispName == "Simulated by" || d.DispName == "Transaction processing time") {
                                    return null;
                                } else {
                                    return (outerHeight / 2) + 3;
                                }

                            }

                        })
                        .on("click", function (d) {
                            var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                            if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                if (d.defaultTrans_link != undefined && d.defaultTrans_link != null) {
                                    return openLink(d.defaultTrans_link, toolBarHide);
                                } else if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                    return openScreenShot(d, screenshotID);
                                } else {
                                    return openWindowGraph();
                                }
                            }

                        });

                    highlightBox.append("svg:image")
                        .attr("width", function (d, i) {
                            if (d.DispName == "Simulated by" || d.DispName == "Location") {
                                return null;
                            } else {
                                return 16;
                            }
                        })
                        .attr("height", function (d, i) {
                            if (d.DispName == "Simulated by" || d.DispName == "Location") {
                                return null;
                            } else {
                                return 16;
                            }
                        })
                        .attr("xlink:href", function (d, i) {
                            if ((defaultTransactions.length == 4 && (i == 2 || i == 3)) || (defaultTransactions.length == 3 && (i == 1 || i == 2))) {
                                if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                    var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                                    if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                        return "/final/monitor/eg_scripts/sessionSimulation/svg/iconSnapshot.svg";
                                    } else if (d.State == "GOOD") {
                                        return "/final/monitor/eg_scripts/sessionSimulation/svg/iconGraph.svg";
                                    }
                                }
                            }
                        })
                        .attr("class", "mouse icon")
                        .attr("x", function (d, i) {
                            if (d.DispName == "Response time" || d.DispName == "Transaction processing time") {
                                var labelHeight = d3.select(d3.select(this).node().parentNode).select('.dynWidth').node().getBBox();
                                return (labelHeight.x + labelHeight.width + 16);
                            } else {
                                return (boxWidth[i] / 2) + 14;
                            }
                        })
                        .attr("y", function (d, i) {
                            return (outerHeight / 2) + 5;
                        })
                        .on("click", function (d, i) {
                            var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                            if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                    return openScreenShot(d, screenshotID);
                                } else {
                                    return openWindowGraph();
                                }
                            }
                        });

                } else {


                    /*var shadow = highlight.append("rect")
                        .attr("id", "drop-shadow")
                        //.attr("width", 121)
                        //.attr("height", 12)
                        .attr("rx", 10)
                        .attr("ry", 10)
                        .attr("fill", currSkin)
                        //.attr("stroke","rgb(239,239,239)")
                        .attr("transform", "translate(0,0)");*/

                    var outBox =
                        highlight.append("rect")
                        .attr("rx", 10)
                        .attr("ry", 10)
                        .attr("class", "svgDefaultTransactions svgDefaultTransactionsOuter")
                        .attr("stroke-width", 2).attr("transform", "translate(2,0)");

                    //console.log("defaultTransactions-=-=-=996>>", defaultTransactions)
                    var height = 0;
                    var boxWidth = 119;
                    var rectHeight = 80;
                    var padding_g = 20;
                    var statePadding = 20;
                    var highlightBox = highlight.selectAll("g")
                        .data(defaultTransactions)
                        .enter()
                        .append("g")
                        .attr("transform", function (d, i) {
                            return "translate(" + boxWidth / 2 + "," + rectHeight * i + ")";
                        });
                    highlightBox.append('rect')
                        .attr("width", boxWidth)
                        .attr("height", rectHeight)
                        .attr("fill", "transparent")
                        .attr("transform", function (d, i) {
                            if (i == 0) {
                                rectHeight = 1;
                            }
                            return "translate(" + (-boxWidth / 2 + 12) + "," + rectHeight * i + ")";
                        });
                    highlightBox.append('rect')
                        .attr("width", boxWidth - 20)
                        .attr("height", rectHeight)

                        .attr("class", "vseparator")
                        .attr("transform", function (d, i) {
                            if (i == 0) {
                                rectHeight = 1;
                            }
                            return "translate(" + ((-boxWidth / 2) + 12) + "," + rectHeight * i + ")";
                        });

                    //displayName
                    var displayName = highlightBox.append("text")
                        .attr("transform", function (d, i) {
                            var label = d.DispName.toUpperCase(),
                                tm = new Ext.util.TextMetrics();


                            if (boxWidth > tm.getWidth(label)) {
                                d.yPosition = (padding_g + 10);
                                return "translate(0," + (padding_g + 10) + ")";
                            } else {
                                d.yPosition = padding_g;
                                return "translate(0," + (padding_g) + ")";
                            }


                        })
                        //.attr("transform", function(d){ return "translate(55," + d.yaxis + ")";})
                        .attr("x", 0)
                        .attr("y", 0)
                        .attr("width", 123)
                        .attr("text-anchor", "middle")
                        .attr("class", "newFont_bold13 svgBodyFontColor displayNameLabel")
                        .attr('data-qtip', function (d) {
                            return d.DispName;
                        })
                        .text(function (d) {
                            return d.DispName;
                        })
                        .call(wrap, 100);

                    //var bbox = highlightBox.node().getBBox().width;
                    var locationPadding = 3;
                    highlightBox.append("text")
                        .attr('data-qtip', function (d) {
                            return d.Val
                        })
                        .attr("transform", function (d, i) {
                            var labelDim = d3.select(d3.select(this).node().parentNode).select('.displayNameLabel').node().getBBox();
                            if (d.State) {
                                return "translate(-12," + (padding_g + labelDim.height + statePadding) + ")";
                            } else {
                                if (d.DispName == "Location") {
                                    return "translate(" + locationPadding + "," + (padding_g + labelDim.height + 20) + ")";
                                } else {
                                    return "translate(0," + (padding_g + labelDim.height + 20) + ")";
                                }

                            }
                        })
                        .attr("x", 0)
                        .attr("y", 0)
                        //.attr("width",300)
                        .attr("text-anchor", "middle")
                        .attr("class", function (d, i) {
                            if (defaultTransactions.length == 4) {
                                if (i == 0) {
                                    return "newFont_normal12 svgBodyFontColor lbllocation";
                                } else if (i == 1) {
                                    return "newFont_normal12 svgBodyFontColor";
                                } else if (i == 2) {
                                    return "mouse newFont_normal20 stateText svgTextState_" + d.State;
                                } else if (i == 3) {
                                    return "dynWidth mouse stateText newFont_normal20 svgTextState_" + d.State;
                                }
                            } else {
                                if (i == 0) {
                                    return "newFont_normal12 svgBodyFontColor lbllocation";
                                } else if (i == 1) {
                                    return "newFont_bold20 stateText svgTextState_" + d.State;
                                } else if (i == 2) {
                                    return "dynWidth mouse stateText newFont_normal20 svgTextState_" + d.State;
                                }
                            }
                        })
                        .text(function (d, i) {
                            if (d.DispName == "Location") {
                                {
                                    var elipsedText = Ext.String.ellipsis(d.Val, 20, true);
                                    return elipsedText;
                                }
                            } else {
                                if (defaultTransactions.length == 4) {
                                    if (i == 0) {
                                        return d.Val;
                                    } else if (i == 1) {
                                        {
                                            var elipsedText = Ext.String.ellipsis(d.Val, 20, true);
                                            return elipsedText;
                                        }
                                    } else if (i == 2) {
                                        return "";
                                    } else if (i == 3) {
                                        return d.Val + "s";
                                    }
                                } else {
                                    if (i == 0) {
                                        {
                                            var elipsedText = Ext.String.ellipsis(d.Val, 20, true);
                                            return elipsedText;
                                        }
                                    } else if (i == 1) {
                                        {
                                            return "";
                                        }
                                    } else if (i == 2) {
                                        return d.Val + "s";
                                    }
                                }
                            }
                        })
                        .on("click", function (d, i) {
                            if (i == 1 || i == 2 || i == 3) {
                                return openLink(d.defaultTrans_link, toolBarHide);
                            } else {
                                return "";
                            }
                        });


                    //State Icon
                    highlightBox.filter(function (d, i) {
                            return (d.State && d.DispName != "Transaction processing time")
                        }).append("svg:image")
                        .attr('width', function (d, i) {
                            return 20;
                        })
                        .attr('height', function (d, i) {
                            return 20;
                        })
                        .attr("xlink:href", function (d, i) {

                            if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                return "/final/monitor/eg_scripts/sessionSimulation/svg/availability_" + d.State + ".svg";
                            }


                        })
                        //.attr("class","state_HIGH")
                        .attr("x", function (d) {
                            var labelDim = d3.select(d3.select(this).node().parentNode).select('.displayNameLabel').node().getBBox();
                            return (labelDim.x + 10);
                        })
                        .attr("y", function (d) {
                            var labelDim = d3.select(d3.select(this).node().parentNode).select('.displayNameLabel').node().getBBox();

                            if (d.State) {
                                //console.log('d.yPosition', d.yPosition);
                                return (padding_g + labelDim.height);
                            }
                        })
                        .attr("class", "mouse stateIcon")
                        .on("click", function (d) {
                            var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                            if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                if (d.defaultTrans_link != undefined && d.defaultTrans_link != null) {
                                    return openLink(d.defaultTrans_link, toolBarHide);
                                } else if (d.State === "HIGH") {
                                    return openScreenShot(d, screenshotID);
                                } else {
                                    return openWindowGraph();
                                }
                            }
                        });




                    highlightBox.append("svg:image")
                        .attr("width", function (d, i) {
                            if (d.DispName == "Simulated by" || d.DispName == "Location") {
                                return 16;
                            } else {
                                return 18;
                            }
                        })
                        .attr("height", function (d, i) {
                            if (d.DispName == "Simulated by" || d.DispName == "Location") {
                                return 16;
                            } else {
                                return 16;
                            }
                        })
                        .attr("xlink:href", function (d, i) {
                            if (i == 0) {
                                if (d.DispName == "Location") {
                                    return "/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconLocation.svg";
                                }
                            } else if ((defaultTransactions.length == 4 && (i == 2 || i == 3)) || (defaultTransactions.length == 3 && (i == 1 || i == 2))) {
                                if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                    var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                                    if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                        return "/final/monitor/eg_scripts/sessionSimulation/svg/iconSnapshot.svg";
                                    } else if (d.State == "GOOD") {
                                        return "/final/monitor/eg_scripts/sessionSimulation/svg/iconGraph.svg";
                                    }
                                }
                            }

                        })
                        .attr("class", "mouse")
                        .attr("x", function (d, i) {
                            if (d.DispName == "Location") {
                                var labelHeight = d3.select(d3.select(this).node().parentNode).select('.lbllocation').node().getBBox();
                                return ((labelHeight.x + locationPadding) - 18);
                            } else {
                                if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                    var labelDim = d3.select(d3.select(this).node().parentNode).select('.stateText').node().getBBox();

                                    var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                                    if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                        //snapICON

                                        return labelDim.width + 8;
                                    } else {
                                        //graphICON
                                        if (d.DispName == "Transaction processing time") {
                                            return (labelDim.x + labelDim.width);
                                        } else {
                                            return (labelDim.x + labelDim.width) + 8;
                                        }

                                    }
                                }
                            }
                        })
                        .attr("y", function (d, i) {
                            if (i == 0) {
                                if (d.DispName == "Location") {
                                    var labelHeight = d3.select(d3.select(this).node().parentNode).select('.lbllocation').node().getBBox();
                                    return (padding_g + labelHeight.height + 6);

                                }

                            } else {
                                if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {


                                    var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                                    if (screenshotID != undefined && screenshotID != null && screenshotID.trim().length > 0 && screenshotID != "-") {
                                        //snapICON
                                        var stateDim = d3.select(d3.select(this).node().parentNode).select('.stateIcon').node().getBBox();
                                        //console.log('stateDIM', stateDim)
                                        return stateDim.y + 2;
                                    } else if (d.State == "GOOD") {
                                        var labelDim = d3.select(d3.select(this).node().parentNode).select('.displayNameLabel').node().getBBox();

                                        //graphICON

                                        return (padding_g + labelDim.height + statePadding) - 16;
                                    }
                                }
                            }
                        })
                        .on("click", function (d) {
                            var screenshotID = getScreenshotID(d.Info_Name, d.msmt_time, d.State);
                            //console.log("screenshotID--1231->>>", screenshotID);
                            if (!Ext.isEmpty(d.State) && d.State != null && d.State != undefined) {
                                if (d.State === "HIGH") {
                                    return openScreenShot(d, screenshotID);
                                } else {
                                    //alert(123)
                                    return openWindowGraph();
                                }
                            }
                        });
                    //.attr("y","80");
                    var verticalView = d3.select('#verticalView').node().getBBox();
                    //console.log('ver', height);
                    //shadow.attr('height', verticalView.height).attr('width', 119);
                    outBox.attr('height', (verticalView.height + 6)).attr('width', 119);
                }

                //setting in center highlightBox;

                var panelBody = $('#main-body').width() / 2 - 10;
                var svgHeight = $('#svgviewbox').height(); //TODO needs to reformat all logics 
                var hightboxY = (outerHeight/2) + (($('#svgviewbox').height()/2) - 90);


                // alert('totalWidth'+totalWidth)

                d3.select(this).attr("transform", function () {
                    if (TransactionsBase.length <= diff) {

                        if (screen.width <= 1366) {
                            return "translate(" + (width / 2 - totalWidth / 2) + "," + hightboxY + ")";

                        } else {

                            return "translate(" + (((width / 2) - (totalWidth / 2)) + 30) + "," + hightboxY + ")";
                        }
                    } else {
                        return "translate(0,160)";
                    }

                });

            });





        } else {
            panel.add([{
                xtype: 'container',
                layout: 'fit',
                html: '<table width="100%" height="100%" align="center"><tr><td style="text-align:center"><img src="/final/images/clear.png" class="iconInformation"/></br><span class="eg_errorsmall">No Simulation Data!</span></td></tr></table>'
            }])
        }

        $('.x-textmetrics').remove();
        $('#' + panel.body.id).append('<div style="position:fixed;font-size:11px;font-weight:500;bottom:20px;left:'+ ($('#' + panel.body.id).width() - 55) + 'px">*All measures are in seconds</div>');
        //panel.setHeight(Ext.getBody().getViewSize().height - 10);
    } catch (e) {
        ////console.log(e)
        //alert(e)
    }
}
/*-----window resize---------------*/

/*-------new popupwindow------------*/
var itemsArry = [{
    "html": "<img src='/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconAccessDesktop.svg'/>",
    "id": "iconAccessDesktop",

}, {
    "html": "<img src='/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconBrowseOpenItems.svg'/>",
    "id": "iconBrowseOpenItems"
}, {
    "html": "<img src='/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconLogout.svg'/>",
    "id": "iconLogout"
}, {
    "html": "<img src='/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconOpenFolder.svg'/>",
    "id": "iconOpenFolder"
}, {
    "html": "<img src='/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconDownloadCatalog.svg'/>",
    "id": "iconDownloadCatalog"
}, {
    "html": "<img src='/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconRegistration.svg'/>",
    "id": "iconRegistration"
}, {
    "html": "<img src='/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconSubmitContacts.svg'/>",
    "id": "iconSubmitContacts"
}, {
    "html": "<img src='/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconUserLogin.svg'/>",
    "id": "iconUserLogin"
}, {
    "html": "<img src='/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconTradeAccess.svg'/>",
    "id": "iconTradeAccess"
}, {
    "html": "<img src='/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconPerformTrade.svg'/>",
    "id": "iconPerformTrade"
}, {
    "html": "<img src='/final/monitor/eg_scripts/sessionSimulation/svg/" + strSkin + "/iconTransaction.svg'/>",
    "id": "iconTransaction"
}];

function popupWindow(transName) {
    Ext.create('Ext.window.Window', {
        id: 'imgSelect',
        title: 'Image Selection',
        height: 300,
        width: 600,
        cls: 'logonWindowShadow',
        shadow: 'sides',
        shadowOffset: 50,
        padding: '0 10',
        layout: {
            type: 'vbox',
            align: 'stretch'
        },
        resizable: false,
        buttonAlign: 'center',
        floatable: true,
        ghost: false,
        header: {
            padding: '5 10 3 10',
            margin: 0
        },
        bodyPadding: 10,
        items: [{
            xtype: 'container',
            flex: 1,
            cls: 'transNameContianer',
            layout: {
                type: 'table',
                columns: 10,
                tdAttrs: {

                    style: {
                        'text-align': 'center'
                    },
                },
                tableAttrs: {
                    style: {
                        width: '100%'
                    }
                }
            },
            defaults: {

                xtype: 'container',
                height: '100%',
                width: '100%',
                padding: 10,

                listeners: {
                    'render': function (panel) {

                        panel.getEl().on('click', function () {
                            $(".transNameContianer tr td").removeClass('selected');
                            panel.getEl().up('td').radioCls('selected');
                            selectedIcon = panel.id;

                        });
                    }
                }
            },
            // height: 200,
            id: 'imageSelect',
            items: itemsArry
        }],
        dockedItems: [{
            xtype: 'toolbar',
            dock: 'bottom',
            padding: '5 0 5 0',
            items: ['->', {
                xtype: 'button',
                text: 'Submit',

                cls: 'button20',
                listeners: {
                    "click": function (img) {
                        var me = this;
                        setImageName(transName, selectedIcon);
                    }
                }
            }, '->']
        }],


    }).show();
}
/*-------Main Body Svg------------*/