Ext.define('floatingContainer',
{
	alias:'widget.floatingContainer',
	extend: 'Ext.window.Window'
}
);

Ext.define('sessionSimulation.view.TransactionsChartPanel', {
	extend : 'utilities.ScrollPanel',
	alias : 'widget.transactionschartpanel',
	jsonData:null,
	itemId : 'transactionschartpanel',
	id:'transactionschartpanel',
	//	autoScroll:true,
	layout:'fit',
	timeLine:"",
	padding:0,
	//collapsible:true,
	//cls:'datapanel',
	ui:'eg-x-panel',
	requires:['utilities.ScrollPanel'],
	frame:false,
	border:false,
	//height:670,
	element:null,
	tools:[
	{
		xtype:'button',
		iconCls:'iconTimeline',
		id:'settingBt',
		listeners: {
			afterrender: function () {
				Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'Settings'
				});
			}
		},
		style:{
			background:'none',border:'0px'
		}
	}	
	],
	collapsed:false,
	collapsible: true,
	hideCollapseTool:true,
	initComponent : function() {
		var jsonData=this.jsonData;
		/*if(jsonData!=undefined && jsonData!=null && !Ext.isEmpty(jsonData.GraphScreenLabels["GraphHeader"])){
			this.title=jsonData.GraphScreenLabels["GraphHeader"];
		}*/
		this.setAutoScroll(true);
		var toolBox = this.createTimePanel(jsonData);
		if (Ext.isEmpty(Ext.getCmp('timeWindow')))
		{
			new Ext.create('floatingContainer',{
				id:'timeWindow',
				title:'Settings',
				width:705,
				height:80,
				flotable:true,
				closeAction:'hide',
				//floating:false,
				//resizable: false,
				padding:'6 6 6 6',
				items:[{
					xtype: 'panel',
					layout:'hbox',
					padding:13,
					ui:'footer',
					items: toolBox
				}]

			});
		}
		this.callParent();
	},
	createTimePanel:function(jsonData){
		if(!Ext.isEmpty(jsonData.graphFilters && jsonData.graphFilters.length>0)){
			var filterArray=new Array();
			for(var i=0;i<jsonData.graphFilters.length;i++){
				var filterData=jsonData.graphFilters[i];
				var filterComp=null;
				switch(filterData.type){
					case "combo": 
					filterComp=this.createCombo(filterData);
					break;
					case "date": 
					filterComp=this.createDateField(filterData);
					break;
					case "button":
					filterComp={
						xtype:'button',
						text:filterData.label,
						action:'transactionGraphBtn',
						margin:'0 0 0 2',
						width:60,
						height:20,
						cls:'button20'
						//cls : 'component-list-right-panel-header-button'
					}
					break;
				}
				if(!Ext.isEmpty(filterComp)){
					filterArray.push(filterComp);
				}
			}
			/*if(filterArray.length>0){
			this.dockedItems= [{
			xtype: 'SettingsForm',
			id:'transactiontool',
			ui:'footer',
			margin:0,
			padding:10,
			dock: 'top',
			items: filterArray
			}]
			}*/
			return filterArray;
		}
	},
	//ovverride function to apply scroll bars to the chart div 
	handleScrollBars:function(c){
		var panelId=c.body.id;
		this.element=$('#'+panelId+' > #chartsDiv').jScrollPane();
	},

	createCombo:function(comboData){
		var comboStore = Ext.create('Ext.data.Store',{
			fields:['value','name'],
			proxy:{
				type: 'memory',
				reader: {
					type: 'json',
					root:'options'
				}
			},
			data:comboData
		});

		var compCombo={
			xtype:'combo',
			editable : false,
			margin:'0 5 0 0',
			store:comboStore,
			cls : 'dropdown',
			displayField:'name',
			valueField:'value',
			trigerAction:'all',
			fieldLabel:comboData.label,
			value:comboData.selectedValue,
			itemId:comboData.combo
		};

		if(comboData.combo=="timeline"){
			compCombo.labelWidth=55;
			compCombo.width=145;
			compCombo.defaultListConfig={
			maxHeight: 200
			};
			this.timeLine=comboData.selectedValue;
		}
		else if(comboData.combo=="fromhr" || comboData.combo=="tohr")
		{
			compCombo.labelWidth=20;
			compCombo.width=75;
			compCombo.defaultListConfig={
				minWidth: 55,
				loadingHeight: 55,
				maxHeight: 200
			};
			if(this.timeLine!="Any"){
				compCombo.disabled=true;
			}
		}
		//add minutes
		else if(comboData.combo=="frommin" || comboData.combo=="tomin")
		{
			compCombo.labelWidth=20;
			compCombo.width=75;
			compCombo.hidden=true;
			compCombo.defaultListConfig={
				minWidth: 55,
				loadingHeight: 55,
				maxHeight: 200
			};
			if(this.timeLine!="Any"){
				compCombo.disabled=true;
			}
		}
		//

		else if(comboData.combo=="mode"){
			compCombo.labelWidth=40;
			compCombo.width=100;
			compCombo.defaultListConfig={
				minWidth: 10,
				loadingHeight:90
			};
		}
		return compCombo;
	},

	createDateField:function(fieldData){
		var dateField={
			xtype:'datefield',
			cls : 'datepicker',
			fieldLabel:fieldData.label,
			format:'M d, Y',					// Kaliraj
			value:fieldData.value,
			labelWidth:50,
			width:210,
			margin:'0 5 0 0',
			itemId:fieldData.field,
			name : fieldData.dateError,
			editable : false
		}
		if(fieldData.field=="from"){
			dateField.labelWidth=35;
			dateField.padding="4 0 0 0";
			dateField.width=150;
		}else if(fieldData.field=="to"){
			dateField.labelWidth=20;
			dateField.width=135;
		}
		if(this.timeLine!="Any"){
			dateField.disabled=true;
		}
		return dateField;
	}
});