function createTooltip(a) {
    a.tip = Ext.create("Ext.tip.ToolTip", {
        target: a.el,
        width: "60%",
        shadow: "frame",
        cls: "tableToolTip",
        traceMouse: true,
        shadowOffset: 30,
        margin: 0,
        padding: 0,
        delegate: a.itemSelector,
        traceMouse: false,
        anchor: "top",
        listeners: {
            beforeshow: function (b) {
                var c = b.html;
                if (Ext.isEmpty(c)) {
                    return false;
                }
            }
        }
    });
}
var store = Ext.create('Ext.data.Store', {
        storeId: 'thresholdStore',
        fields: ['COLUMN_0', 'COLUMN_1', 'COLUMN_2', 'COLUMN_3', 'COLUMN_4', 'COLUMN_5', 'COLUMN_6','COLUMN_href'],
        data: [{},{},{},{},{},{},{}]
    });


Ext.QuickTips.init();
var threshold1 = Ext.create('utilities.CustomGrid', {
        id: 'UserViewGrid',
        name: 'UserViewGrid',
        cls: 'gridSkin',
		flex:1,
        border: false,
	    forceFit: false,
		padding:0,
		margin:'0 10 0 10',
		height:'auto',
		scroll:true,
		autoScroll: true,
		emptyText: '<div style="height:350px;padding:100px 0px" align="center"><div class="iconInformation"></div>No Event found</div>',
        store: store,
		style: {
			"z-index": "1"
		},
		viewConfig: {
			 deferEmptyText: false,
			listeners: {
				render: createTooltip
			}
		},
		columns: [{
			dataIndex:'COLUMN_0',
			header: '',
			padding:0,
			margin:0,
			width:30,
			menuDisabled:true,
			renderer: function(value){
				if(value=="HIGH"){
					value="alarmCritical";
				}
				else if(value=="LOW"){
					value="alarmMinor";
				}
				else if(value=="INTERMEDIATE"){
					value="alarmMajor";
				}
				else{
					value=="alarmUnknown"
				}
				return '<div class="'+value+'" style="border:0px solid red;margin-top:-2px;cursorointer"></div>';
				}
		},{
			dataIndex: 'COLUMN_1',
			header:cmpTypeLbl ,
			menuDisabled:true,
			//padding:2,
			flex:2,
			renderer:function(value, metaData, record, row, col){
				var address=record.get('COLUMN_href');
				return "<a href='"+address+"'>"+value+"</a>"}
		},{
			dataIndex:'COLUMN_2',
			header: cmpNameLbl,
			menuDisabled:true,
			//padding:2,
			flex:2,
			renderer:function(value, metaData, record, row, col){
				var address=record.get('COLUMN_href');
				return "<a href='"+address+"'>"+value+"</a>"}
		},{
			dataIndex: 'COLUMN_3',
			header: testNameLbl,
			menuDisabled:true,
			//padding:2,
			flex:2,
			renderer:function(value, metaData, record, row, col){
				var address=record.get('COLUMN_href');
				return "<a href='"+address+"'>"+value+"</a>"}
		},{
			dataIndex: 'COLUMN_4',
			header: descriptionLbl,
			menuDisabled:true,
			//padding:2,
			flex:3,
			renderer:function(value, metaData, record, row, col){
				var address=record.get('COLUMN_href');
				return "<a href='"+address+"'>"+value+"</a>"}
		},{
			dataIndex: 'COLUMN_5',
			header: layerlbl,
			menuDisabled:true,
			//padding:2,
			flex:2,
			renderer:function(value, metaData, record, row, col){
				var address=record.get('COLUMN_href');
				return "<a href='"+address+"'>"+value+"</a>"}
		},{
			dataIndex: 'COLUMN_6',
			header: startTimeLbl,
			menuDisabled:true,
			//padding:2,
			flex:2,
			renderer:function(value, metaData, record, row, col){
				var address=record.get('COLUMN_href');
				return "<a href='"+address+"'>"+value+"</a>"}
		}]

});

Ext.define('supermanagerMessageApp.view.userViewDetails',{
	extend:'Ext.panel.Panel',
	alias:'widget.userviewdetails',
	frame: false,
	border:false,
	margin:0,
	padding:0,
	layout:{
		type:'vbox',
		align:'stretch'
	},
	scroll:false,
	autoScroll:true,
	items:[threshold1]
});
