Ext.define('userdetails.controller.Main', {
    extend: 'Ext.app.Controller',
    views: ['Main'],
    refs: [
    	{selector: 'main',ref: 'main'},
    	{selector: 'userdesktopdata', ref:'userdesktopdata'},
    	{selector: 'userdata', ref: 'userdata'},
    	{selector: 'maximizeview', ref: 'maximizeview'},
    	{selector: 'vmdata', ref: 'vmdata'}
    ],
    init: function ()
    {
    	appCnt = this;
        this.control({

            'main':
            {
                'afterrender': this.afterMainRendered
            },
			'main button[id="backbtn"]':
			{
					'click':this.onBackBtnClick
			},
			'userdesktopdata':
			{
				'beforeshow': this.beforeUserDesktopDataShow,
				'boxready': this.loadDialCharts
			},
			'vmdata':
			{
				'beforeshow':this.beforeVMDataShow,
				'boxready': this.loadDialCharts
			},
			'userdata':
			{
				'boxready': this.loadDialCharts
			},
			'maximizeview':
			{
				'afterrender': this.afterMaximizedViewRendered
			},
			'maximizeview button[id="timelinesubmit"]':
			{
				'click': this.timelineSubmit
			}
    });
    },
	refreshSearchDetails : function()
	{
		var meC=this;		
		if (maxiView)
		{
			if(!Ext.isEmpty(maximizedFunction) && maximizedFunction!=null)
			{
				if(maximizedFunction=='showMaximizedBar')
				{
					if(maxChartName=='area')
					{
						this.timelineSubmit();
					}
					else
					{
						var params1 = defaultParams;
						Ext.Ajax.request({
							url:  '/final/servlet/com.eg.EgMonitorResultDispatcher',
							params: params1+"&resultpage=globalsearch",
							scope: this,
							method:'POST',
							success: function (response) 
							{
								if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
								{
									var jsonText = response.responseText;
									publicJson = Ext.decode(jsonText);
									var curViewPort=  Ext.getCmp('searchDetailsViewPort');
									curViewPort.removeAll();
									curViewPort.add({
											xtype:'main'
										});
									
									curViewPort.doLayout();

									if(maxChartId.length >9)
									{
										maxChartId = maxChartId.substring(9);
									}
									if(!Ext.isEmpty(publicJson['RESULT']['BAR_METRICS']) &&  publicJson['RESULT']['BAR_METRICS'].hasOwnProperty(maxChartId))
									{
										var barChartObjct=FusionCharts.items['maxviewchart_'+maxChartId];
										if(barChartObjct!=null)
										{
											barChartObjct.setDataXML(publicJson['RESULT']['BAR_METRICS'][maxChartId]['XML_DATA']);
										}
									}
								}
							
							}
						});	
					}
				}
				else if(maximizedFunction=='showMaximizedView')
				{
					maxChartName='';
					meC.timelineSubmit( )
				}
			}
		}
		else
		{
			var params1 = defaultParams;
			Ext.Ajax.request({
				url:  '/final/servlet/com.eg.EgMonitorResultDispatcher',
				params: params1+"&resultpage=globalsearch",
				scope: this,
				method:'POST',
				success: function (response) 
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJson = Ext.decode(jsonText);
						var curViewPort=  Ext.getCmp('searchDetailsViewPort');
						curViewPort.removeAll();
						curViewPort.add({
								xtype:'main'
							});
						
						curViewPort.doLayout();
						
					}
				
				}
			});
		}
	},
    selectPriority: function()
    {
    	var timeline = Ext.getCmp('er_timeline').dataArray;
    	var startDate = formatDate(new Date(getDateFromFormat(Ext.getCmp('er_stdate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
    	var startHr = Ext.getCmp('er_sthr').getValue();
    	var endDate =formatDate(new Date(getDateFromFormat(Ext.getCmp('er_enddate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
    	var endHr = Ext.getCmp('er_endhr').dataArray;
    	var timelineQStr = encodeURIComponent(Ext.getCmp('er_timeline').getValue()+"#"+startDate+' '+startHr+':'+stmin+'#'+endDate+' '+endHr+':'+enmin);
    	var tmpArray = Ext.getCmp('Maximize').dataArray;

    	var getInnerArray = tmpArray[3];

    	var comp = getInnerArray[0];
    	var test = getInnerArray[1];
    	var meas = getInnerArray[2];
    	var ddTestMeas = getInnerArray[3];
    	initLdgMask.show();
    	Ext.Ajax.request({
		    		url: '/final/servlet/com.eg.EgMonitorResultDispatcher',
		    		params: defaultParams+'&resultpage=globalsearch&drilldown=true&drilldowncomp='+encodeURIComponent(comp)+'&drilldowntest='+encodeURIComponent(test)+'&drilldownmeasure='+encodeURIComponent(meas)+'&drilldowntestmeasure='+encodeURIComponent(ddTestMeas)+'&priority='+encodeURI(Ext.getCmp('priority').getValue())+'&graph=bar&timeline='+timelineQStr,
		    		method: 'POST',
		    		success: function( response )
		    		{
		    			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
		    			{
		    				initLdgMask.hide();
		    				var jsonText = response.responseText;
		    				var jsonData = Ext.decode( jsonText );
		    				var xmlData = jsonData['XML_DATA'];
		    				//xmlData = "<chart  showValues='0' palette='0' showBorder='0' bgColor='F3F3F6' staggerLines='3' numVDivLines='10' plotGradientColor='' numDivLines='10' adjustDiv='1' vDivLineIsDashed='1' legendShadow='1' vDivLineDashGap='10px' dashed='1' divLineIsDashed='1' legendPosition='BOTTOM' plotFillAlpha='70' reverseLegend='1' interactiveLegend='1'><categories><category label='12:55' /><category label='13:00' /><category label='13:05' /><category label='13:10' /><category label='13:16' /><category label='13:21' /><category label='13:26' /><category label='13:31' /><category label='13:36' /><category label='13:41' /><category label='13:46' /><category label='13:51' /></categories><dataset seriesName=' excalib7001 ' color='#996600' showValues='0'><set value='0.0247' /><set value='0.0274' /><set value='0.0251' /><set value='0.0264' /><set value='0.0271' /><set value='0.0258' /><set value='0.0223' /><set value='0.0298' /><set value='0.0274' /><set value='0.0230' /><set value='0.0259' /><set value='0.0239' /></dataset><dataset seriesName=' excalib7001 ' color='#996699' showValues='0'><set value='0.0247' /><set value='0.0274' /><set value='0.0251' /><set value='0.0264' /><set value='0.0271' /><set value='0.0258' /><set value='0.0223' /><set value='0.0298' /><set value='0.0274' /><set value='0.0230' /><set value='0.0259' /><set value='0.0239' /></dataset><trendlines><line startValue='42000' color='91C728' displayValue='Target' showOnTop='1'/></trendlines><styles><definition> <style name='CanvasAnim' type='animation' param='_xScale' start='0' duration='1' /></definition><application><apply toObject='Canvas' styles='CanvasAnim' /></application></styles></chart>";
		    				if ( xmlData != '-' )
		    				{
		    					var myChart = new FusionCharts('/final/FusionCharts/swf/Bar2D.swf','chart2', '100%', '100%','0','1');
								myChart.setXMLData(xmlData);
								myChart.setTransparent(true);
								myChart.render('fusionChart');
		    				}
		    				else
		    				{
		    					Ext.select('#fusionChart').update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style=""></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>');
		    				}
		    			}
		    		}
		    	});
    },
	dateDiff: function( fromDate,toDate )
    {
        var oneDay=24*60*60*1000;   //hours*mins*seconds*millisecs
        var fromDate=new Date(fromDate);
        var toDate=new Date(toDate);
        var diffDays = Math.round(Math.abs(fromDate.getTime()-toDate.getTime())/(oneDay));
        return diffDays;
    },
    timelineSubmit: function()
    {
    	var timeline = Ext.getCmp('er_timeline').getValue();
    //	var startDate = Ext.Date.format(Ext.getCmp('er_stdate').getValue(), 'm/d/Y');
    	var startDate = formatDate(new Date(getDateFromFormat(Ext.getCmp('er_stdate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");

    	var startHr = Ext.getCmp('er_sthr').dataArray;
    //	var endDate = Ext.Date.format(Ext.getCmp('er_enddate').getValue(), 'm/d/Y');
    	var endDate = formatDate(new Date(getDateFromFormat(Ext.getCmp('er_enddate').dataArray, mgrDisplayDateFormat)), "MM/dd/yyyy");
    	var endHr = Ext.getCmp('er_endhr').dataArray;
		
		//Date validation		 
		if(timeline.toLowerCase() == 'any')
		{
			if(new Date(startDate) > new Date(endDate))
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: "Start date should be lesser than end date",
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
			
				return false;
			}
			if(new Date(startDate).valueOf() == new Date(endDate).valueOf())
			{    
				if(startHr > endHr)
				{
					Ext.MessageBox.show({
					title: 'Alert',
					msg: "Start date should be lesser than end date",
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
				
					return false;
				}
			}
		}
		var today = new Date();
		var diffDays = this.dateDiff(new Date(startDate),new Date(endDate));
	 
		var currentDate = today.getMonth() + "/" + today.getDay() + "/" + today.getYear();
		if(today < new Date(startDate) )
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: "From and To Date should be lesser than Current date",
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}
		if( diffDays > 14 )
		{
			Ext.MessageBox.show({
			title: 'Alert',
			msg: "Timeline allowed only for two weeks",
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
			});
			return false;
		}
	 
    	var dataArray = Ext.getCmp('Maximize').dataArray;	
    	if ( !Ext.isEmpty( dataArray ) )
    	{
    		var getType = dataArray[2];
    		if ( getType == 'line_chart')
    		{
    			var imgURL = dataArray[1];
				if(imgURL!=null && imgURL.indexOf("endtime")>0)
				{
					imgURL = imgURL.replace(/(endtime=)[^\&]+/, '$1' + encodeURIComponent(endDate));
				}
				else
				{
					imgURL += "&endtime="+endDate;
				}
				if(imgURL!=null && imgURL.indexOf("starttime")>0)
				{
					imgURL = imgURL.replace(/(starttime=)[^\&]+/, '$1' + encodeURIComponent(startDate));
				}
				else
				{
					imgURL += "&starttime="+startDate;
				}
				if(imgURL!=null && imgURL.indexOf("starthr")>0)
				{
					imgURL = imgURL.replace(/(starthr=)[^\&]+/, '$1' + encodeURIComponent(startHr));
				}
				else
				{
					imgURL += "&starthr="+startHr;
				}
				if(imgURL!=null && imgURL.indexOf("endhr")>0)
				{
					imgURL = imgURL.replace(/(endhr=)[^\&]+/, '$1' + encodeURIComponent(endHr));
				}
				else
				{
					imgURL += "&endhr="+endHr;
				}
				if(imgURL!=null && imgURL.indexOf("height")>0)
				{
					imgURL = imgURL.replace(/(height=)[^\&]+/, '$1' + ( Ext.getCmp('Maximize').getHeight() - 50 ));
				}
				else
				{
					imgURL += "&height="+( Ext.getCmp('Maximize').getHeight() - 50 );
				}
				if(imgURL!=null && imgURL.indexOf("width")>0)
				{
					imgURL = imgURL.replace(/(width=)[^\&]+/, '$1' + (Ext.getCmp('Maximize').getWidth() - 20 ));				
				}
				else
				{
					imgURL += "&width="+(Ext.getCmp('Maximize').getWidth() - 20 );
				}
    			var er_mode = Ext.getCmp('er_mode').getValue();
				imgURL +='&mode='+er_mode+'&tline='+timeline;
				
				var timelineChart = getOption(timeline,Ext.getCmp('er_stdate').getValue(),startHr,Ext.getCmp('er_enddate').getValue(),endHr);
				
				if (timeline.toLowerCase() == '3 weeks' || timeline.toLowerCase() == '4 weeks' || timeline.toLowerCase() == '1 month')
				{
					timelineChart = 'easy';
				}
				if(!Ext.isEmpty(timelineChart) && timelineChart.indexOf("easy") > -1)
				{
					Ext.get('chartMaximize').update('<table width="550px" height="200px"><tr><td align="center" valign="middle"><img  src="' + imgURL + '" border="0" /></td></tr></table>'); 
				}
				else
				{			
					setHighChart(imgURL,"chartMaximize","maxLegend",Ext.getCmp('Maximize').getHeight()-110,Ext.getCmp('Maximize').getWidth()-40,'',true,null,null,"line",'up');
				}
				Ext.get('configMod').animate({duration: 700,to: {y: -200}});
    		}
    		else if ( getType == 'area_chart' )
    		{
				var imgURL = dataArray[1];
    			var er_mode = Ext.getCmp('er_mode').getValue();
				var timeperiod = startDate+" "+startHr+":00|"+endDate+" "+endHr+":00";
				if(imgURL.indexOf('TimePeriod')>0)
				{
					imgURL = imgURL.replace(/(TimePeriod=)[^\&]+/, '$1' + encodeURIComponent(timeperiod));
				}
				if(imgURL.indexOf('Timeline')>0)
				{
					imgURL = imgURL.replace(/(Timeline=)[^\&]+/, '$1' + timeline);
				}
				imgURL +="&mode="+er_mode;    			
			
				
				var timelineChart = getOption(timeline,Ext.getCmp('er_stdate').getValue(),startHr,Ext.getCmp('er_enddate').getValue(),endHr);
				if (timeline.toLowerCase() == '3 weeks' || timeline.toLowerCase() == '4 weeks' || timeline.toLowerCase() == '1 month')
				{
					timelineChart = 'easy';
				}			
				if(!Ext.isEmpty(timelineChart) && timelineChart.indexOf("easy") > -1)
				{
					/*if(!Ext.isEmpty(Ext.get('chartMaximize')))
					{
						Ext.get('chartMaximize').remove();
					}*/
					Ext.get('chartMaximize').update('<table width="100%" height="360px"><tr><td align="center" valign="middle"><img  src="' + imgURL + '" border="0" /></td></tr></table>');    				
				}
				else
				{
					setHighChart(imgURL,"chartMaximize","maxLegend",Ext.getCmp('Maximize').getHeight()-110,Ext.getCmp('Maximize').getWidth()-40,'',true,null,null,"line",'up');
				}
				Ext.get('configMod').animate({duration: 700,to: {y: -200}});    			
    		}
    	}
    },
    afterMaximizedViewRendered: function()
    {
    	 this.showConfigDropdown();
         Ext.getBody().on('click',function()
         {
         	Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		 },null,{delegate:'#closeSettings'});

		Ext.Ajax.request({
	      	url: '/final/servlet/com.eg.EgMonitorRequestDispatcher',
	      	method: 'POST',
	      	params: 'comesFrom=globalsearch&period=H&time=1 hour',
	      	success: function( response )
	      	{
	      		if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
	      		{
	      			var jsonText = response.responseText;
	      			var jsonData = Ext.decode( jsonText );
	      			var timelineDetails = jsonData['timelinedetails'];
	      			var selectedValues = timelineDetails['timelineSelections'];
	      			if ( !Ext.isEmpty( jsonData ) )
	      			{
	      				Ext.getCmp('er_timeline').suspendEvents(true);
	      				Ext.getCmp('er_timeline').getStore().loadRawData(timelineDetails['timeline']);
	      				Ext.getCmp('er_timeline').setValue(selectedValues['selectedTimeline']);
	      				Ext.getCmp('er_timeline').resumeEvents();
	      				Ext.getCmp('er_stdate').setValue(selectedValues['selectedStartDate']);
	      				Ext.getCmp('er_sthr').setValue(selectedValues['selectedStartHour']);
	      				Ext.getCmp('er_enddate').setValue(selectedValues['selectedEndDate']);
	      				Ext.getCmp('er_endhr').setValue(selectedValues['selectedEndHour']);
	      				Ext.getCmp('er_timeline').fireEvent('select', Ext.getCmp('er_timeline'));
	      				Ext.getCmp('er_mode').setValue('2D');
	      			}
	      		}
	      	}
      });
    },
	showConfigDropdown:function(){
			var tpl = new Ext.XTemplate('<div style="float:left;margin:-2px 0px 0px 4px;color:#f7f7f7" class="settingsfont"><b>'+defaultSettings+'</b></div><div style="text-align:right;float:right;"><div class="iconClose3" id="closeSettings"></div></div>');
				//config dropdown modesx
				Ext.create('Ext.container.Container',{
				width:580,
				padding:5,
				//layout:'vbox',
				id:'configMod',
				cls:'configMode_popup',
				//html:tpl.apply(),
				items:[
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'526px'}
					},
					{
						xtype:'container',
						html:tpl.apply(),
						style:{'top':'0px','margin':'2px'}
					},
					{
						xtype:'panel',
						cls:'configMode_popup_inner',
						defaults: {
							labelAlign: 'top',
							margin: '8 5 8 10',
							labelSeparator: ''
						},
						items:[
							{
								xtype:'timeline',
								parent: this
							},
							{
								xtype: 'button',
								cls: 'button20',
								margin: '0px 0px 8px 250px',
								id: 'timelinesubmit',
								text: goBtn,
								handler: function()
								{
									appCnt.timelineSubmit();
								}
							}
						]
					}
				],
				renderTo:'Maximize-body',
			});
		},

    showMaximizedView: function( dataArray )
    {		
        maxiView = true;
        maximizedFunction='showMaximizedView';
        //maxChartId=id;
		var isHighChart = false;
		var isAxisTimeReq = true;
		var legendPos = "right";
		var getMainWidth = this.getMain().getWidth();
    	var getMainHeight = this.getMain().getHeight();	    
		if (dataArray[2]!=null && dataArray[2]=='BAR_CHART')
		{
			this.showMaximizedBar(dataArray[0],dataArray[1],dataArray[2],dataArray[4]);
		}
		else
		{
			var getTitle = dataArray[0];
			var genURL = dataArray[1]+'&height='+(getMainHeight-150)+'&width='+(getMainWidth-130);
			var tmpDataArray = new Array();
			var type = dataArray[2];
			var graphFormat = dataArray[3];		
			tmpDataArray[tmpDataArray.length] = getTitle;
			tmpDataArray[tmpDataArray.length] = genURL;
			tmpDataArray[tmpDataArray.length] = type;
			tmpDataArray[tmpDataArray.length] = graphFormat;		
			var imgSrcUrl = '';
			var isHighChart = false;
			if(graphFormat!=null && graphFormat.toLowerCase()=='highcharts')
				isHighChart = true;
			if(isHighChart)
			{
				imgSrcUrl = '<div id="chartMaximize" style="margin-top:10px"></div>';
			}
			else
			{
				imgSrcUrl = '<div id="imgDiv" style="margin:16px"><img id="graphImage" src="'+maxChartId+'" /></div>';
			}
			Ext.widget('maximizeview', {
					title: getTitle,
					width: getMainWidth,
					height: getMainHeight+10,
					id : 'Maximize',
					dataArray: tmpDataArray,				
					items:[
						{
							xtype:'container',
							id:'maxLegend'
						},
						{
						xtype:'container',
						margin:'10 0 0 0',
						html:imgSrcUrl,
					}],
					listeners:{
						show:function(){
							setHighChart(genURL,"chartMaximize","maxLegend",getMainHeight-110,getMainWidth-40,'',isAxisTimeReq,legendPos,true);
						}
					}
			}).show();
		}
    },
    showMaximizedBar: function( title, xmldata ,chartName,id)
    {				
		maxiView=true;
		maximizedFunction='showMaximizedBar';
		maxChartName=chartName;
		maxChartId=id;
		var getId = '';
		var swfPath = '';
		if ( chartName == 'BAR_CHART' )
		{
			getId = 'bar-block-'+id;
			swfPath = '/final/FusionCharts/swf/Bar2D.swf';
		}		
		//var dataArray = Ext.getCmp(getId).dataArray;
		var getMainWidth = this.getMain().getWidth();
		var getMainHeight = this.getMain().getHeight();
		var getTitle = title;
		var xmlData = xmldata;		
		Ext.widget('maximizeview', {
				title: getTitle,
				width: getMainWidth,
				scroll:true,
				autoScroll:true,
				height: getMainHeight,
				//dataArray: dataArray,
				
				html:xmlData,
				id : 'Maximize', //style="height:200px;width:600px;margin:2 2 0 2"
				//html:'<div style="margin-top:40px;border:0px solid red;width:'+getMainWidth+'px;height:'+getMainHeight+'px;" id="fusionChart" >'+xmlData+'</div>'
		}).show();

		if( chartName == 'BAR_CHART' )
		{
			Ext.getCmp('settings-plugin').hide();
		}
		if ( xmlData != '-' )
		{
			/*if(fusionChartsApiEnabled)
			{
				var chartRndrId='maxviewchart_'+id;
				if (FusionCharts(chartRndrId) != null) 
					 FusionCharts(chartRndrId).dispose();
				var myChart = new FusionCharts(swfPath,chartRndrId, '100%', '100%','0','1');
				myChart.setXMLData(xmlData);
				myChart.setTransparent(true);
				myChart.render('fusionChart');					
			}
			else
			{*/
				try
				{
					 var getMainWidth = this.getMain().getWidth()-150,
						getMainHeight = Ext.get('Maximize-body').getHeight( ) ;					 

					 xmlData['userSearch']=true;
					 
					var barChart = {};
					barChart = jQuery.extend(true, {}, getHighChartsBarInstance('Maximize-body', (getMainHeight-100), getMainWidth), barChart);
					barChart.setData(xmlData, currentDateFormat, '','bar');
					
					barChart.drawChart();
				}
				catch (barChartEx)
				{
					console.log(barChartEx);
				}
			//}
		}
		else
		{
			Ext.select('#Maximize-body').update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style=""></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>')
		}
		isMaximizedView = true;
    },
    loadDialCharts: function( obj )
    {
    	var loadId = 'userdesktopdialgraphpnl';
    	if ( obj.id.indexOf('userdesktopdata') == -1 )
    	{
    		loadId = 'userdialgraphpnl';
    	}
    	if ( obj.id.indexOf('vmdata') > -1 )
    	{
    		loadId = 'vmdialgraphpnl';
    	}
    	var dialValues = Ext.getCmp(loadId).dataArray;
    	if ( !Ext.isEmpty( dialValues ) )
    	{
    		for ( var key in dialValues )
    		{
    			if ( dialValues[key]['XML_DATA'] != undefined )
    			{
    				var xmlData = dialValues[key]['XML_DATA'];
    				if ( xmlData != '-' )
    				{
						/*if(fusionChartsApiEnabled)
						{
							var chartRndrId='dialchart-'+key;
							if (FusionCharts(chartRndrId) != null) 
							 FusionCharts(chartRndrId).dispose();

							var myChart = new FusionCharts('/final/FusionCharts/swf/AngularGauge.swf',chartRndrId, '100%', '100%','0','1');
							myChart.setXMLData(xmlData);
							myChart.setTransparent(true);
							myChart.render('dial-block-'+key);
						}
						else
						{*/
							getHighChartsGuage(('dial-block-'+key),xmlData);
						//}
    				}
    				else
    				{
    					Ext.select('#dial-block-'+key).update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style=""></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>')
    				}
    			}
    		}
    	}    	
    	this.loadBarCharts( obj );
    },   
    loadBarCharts: function( obj )
    {
    	var loadId = 'userdesktopbargraphpnl';
    	if ( obj.id.indexOf('userdesktopdata') == -1 )
    	{
    		loadId = 'userbargraphpnl';
    	}
    	if ( obj.id.indexOf('vmdata') > -1 )
    	{
    		loadId = 'vmbargraphpnl';
    	}
    	var barValues = Ext.getCmp(loadId).dataArray;
    	if ( !Ext.isEmpty( barValues ) )
    	{
    		for ( var key in barValues )
    		{
    			if ( barValues[key]['XML_DATA'] != undefined )
    			{
					var chartRndrId='barchart-'+key;
			       
    				var xmlData = barValues[key]['XML_DATA'];
					var barObj = Ext.getCmp('bar-block-'+key);
					var dataArray = barObj.dataArray;
    				var detailsArr = new Array();
    				detailsArr[detailsArr.length] = barValues[key]['COMPONENT_DETAILS'];
    				detailsArr[detailsArr.length] = barValues[key]['TEST'];
    				detailsArr[detailsArr.length] = barValues[key]['MEASURE'];
    				detailsArr[detailsArr.length] = barValues[key]['COMBINED_TEST_MEASURES'];
    				dataArray[1] = xmlData;
    				dataArray[2] = 'BAR_CHART';
    				dataArray[3] = detailsArr;					
    				dataArray[4] = barObj;					
    				if ( xmlData != "-" )
    				{
						/*if (FusionCharts(chartRndrId) != null) 
							 FusionCharts(chartRndrId).dispose();
						//Ext.getCmp('barMaximizedId'+key).setVisible(true);
						if(fusionChartsApiEnabled)
						{							
							var myChart = new FusionCharts('/final/FusionCharts/swf/Bar2D.swf',chartRndrId, '100%', '100%','0','1');
							myChart.setXMLData(xmlData);
							myChart.setTransparent(true);
							myChart.render('barChart-'+key);
						}
						else
						{*/
							try
							{								
								 var getMainWidth = this.getMain().getWidth(),
									getMainHeight = this.getMain().getHeight();
								var barGraphHeight=xmlData['barGraphHeight'];								
								//Ext.get('barChart-'+key).setHeight(getMainHeight-300);
								//barGraphHeight=parseInt(barGraphHeight)-75;
								var barChart = {};
								barChart = jQuery.extend(true, {}, getHighChartsBarInstance('barChart-'+key,barGraphHeight, 600), barChart);
								barChart.setData(xmlData, currentDateFormat, dataArray, 'bar');
								barChart.drawChart();
							}
							catch (barChartEx)
							{
								console.log(barChartEx);
							}
						//}
    				}
    				else
    				{		
						//Ext.getCmp('barMaximizedId'+key).setVisible(false);
    					Ext.select('#barChart-'+key).update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style=""></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>')
    				}
    				Ext.getCmp('bar-block-'+key).dataArray = dataArray;
    				Ext.getCmp('bar-block-'+key).doLayout();
    			}
    		}
    	}
    },
    beforeUserDesktopDataShow: function()
    {
    	var screenLabels = publicJson['RESULT']['screenLabels'];
    	if ( screenLabels != undefined )
    	{
	    	var userdesktopObj = this.getUserdesktopdata();
	    	var userSummaryBlockObj = userdesktopObj.getComponent('block1panel').getComponent('usersummaryblock');
	    	var userSummaryBlockTitleObj = userSummaryBlockObj.getComponent('usersummarytitle');
	    	userSummaryBlockTitleObj.update('<b>'+screenLabels['monitor.common.User Summary']+'</b>');
	    	Ext.getCmp('ipAddressLbl').setText(screenLabels['monitor.common.ipAddres']+":");
	    	Ext.getCmp('osTypeLbl').setText(screenLabels['monitor.common.OS']+":");
    	}
    },
    beforeVMDataShow: function() // Not sure when this case is met. - Jaiwin
    {
    	var screenLabels = publicJson['RESULT']['screenLabels'];
    	if ( screenLabels != undefined )
    	{
    		Ext.get('vmsummarytitle').update('<b>'+screenLabels['monitor.common.VM Summary']+'</b>');
    		Ext.get('ipAddressLbl1').update('<b>'+screenLabels['monitor.common.ipAddres']+'</b>:');
    		Ext.get('osTypeLbl1').update('<b>'+screenLabels['monitor.common.OS']+'</b>:');
    	}
    },
	afterMainRendered: function()
	{
		var resultObj = publicJson['RESULT'];
		if ( resultObj != undefined )
		{
			var title = resultObj['TITLE'];
			var getView = resultObj['VIEW'];
			this.getMain().setTitle(title);
			if ( getView == 'USER')
			{
				this.showUser( resultObj );
			}
			else if ( getView == 'DESKTOP' )
			{
				if(showBackBtn == 'false' || showBackBtn == false)
					Ext.getCmp('backbtn').hide();
				this.showUserDesktop( resultObj );
//				if ( resultObj['VM_ICONS_CLS'] != undefined && resultObj['VM_ICONS_CLS'] == 'TRUE' )
//				{
//					this.getMain().setIconCls('iconUserIndex');
//				}
			}
			else if ( getView == 'VM' )
			{
				//this.getMain().setIconCls('icon-globe');
				this.showVM( resultObj );
			}
		}
	},
	showUser: function ( resultData )
	{
		this.getUserdata().show();
		var blockValues = resultData['BLOCK_VALUES'];
		var blockObj = Ext.getCmp('userblockpanel');		
		var key;
    	for ( key in blockValues )
    	{
    		var blockVal = blockValues[key];
    		var title = blockVal['TITLE'];
    		var imageClass = blockVal['IMAGE_CLASS_NAME'];			
    		var measureVal = blockVal['MEASURE_VALUE'];
    		var ddLink = blockVal['DD_LINK'];
    		var ddTitle = blockVal['DD_TITLE'];
			var layerLink = blockVal['LAYERMODEL_LINK'];
    		var genHTML = '';
    		var genHTML1 = '';  
			if (measureVal!=null && measureVal!='' && measureVal!=undefined && measureVal!="-")
			{
				if(layerLink!=undefined && layerLink!=null && layerLink!="")
				{
					if ( ddLink!=null && ddLink!='' && ddLink!=undefined)
					{
						if(!Ext.isEmpty(csrfToken) && csrfToken!=undefined && csrfToken!=null)
							ddLink = ddLink+"&com.eg.CSRF_NONCE="+csrfToken;

						genHTML = '<img src="/final/images/clear.png" class="iconDiagnosis" style="cursor:pointer;vertical-align:middle;padding:0px 10px;position:relative;left:10px" onclick="javascript:openDD(\''+ddLink+'\');"/>';
					}
				}
			}
			if (measureVal!=null && measureVal!='' && measureVal!=undefined && measureVal!="-")
			{
				if(layerLink!=undefined && layerLink!=null && layerLink!="")
				{
					genHTML1 = '<table width="100%"><tr><td align="right" class="font_bold" style="cursor:pointer;line-height:15px"><span onclick="javascript:wayToLayerModel(\''+layerLink+'\');">'+title+'</span>';

					if ( genHTML != undefined && genHTML!=null && genHTML!="")
					{
						genHTML1 +=genHTML;
					}
					genHTML1 +='</td></tr></table>';
				}
				else
				{
					genHTML1 = '<table width="100%"><tr><td align="right" class="font_bold" style="cursor:default;line-height:15px"><span>'+title+'</span>';

					if ( genHTML != undefined && genHTML!=null && genHTML!="")
					{
						genHTML1 +=genHTML;
					}
					genHTML1 +='</td></tr></table>';
				}
			}
			else
			{
				genHTML1 = '<table width="100%"><tr><td align="right" class="font_bold">'+title+'</td></tr></table>';
			}
			
			if (measureVal!=null && measureVal!='' && measureVal!=undefined && measureVal!="-")
			{
				var measureHTML = "";
				if(layerLink!=undefined && layerLink!=null && layerLink!="")
				{
					measureHTML = '<div style="cursor:pointer;line-height:15px" onclick="javascript:wayToLayerModel(\''+layerLink+'\');"><table width="100%" ><tr><td align="right"><b style="font-size:24px;text-align:right">'+measureVal+'</b></td></tr></table></div>';
				}
				else
				{
					measureHTML = '<div style="cursor:default;line-height:15px"><table width="100%" ><tr><td align="right"><b style="font-size:24px;text-align:right">'+measureVal+'</b></td></tr></table></div>';
				}
			}
			else
			{
				var measureHTML = '<div><table width="100%" ><tr><td align="right"><b style="font-size:24px;text-align:right">'+measureVal+'</b></td></tr></table></div>';
			}
    		blockObj.add(
    			{
    				xtype: 'container',
		        	id: 'block'+key,
		        	itemId: 'block'+key,
					cls:'searchSeperatorLine',
					padding:0,
					height:108,
					border:true,
					style:{'border':'#000 1px solid'},
		        	layout: 'vbox',
		        	items:[
		        		{
		        			xtype: 'label',
		        			margin: 8,
							width:'100%',
		        			html: '<div>'+measureHTML+'</div>'
		        		},
		        		{
		        			xtype: 'container',
		        			layout: 'hbox',
							width:'100%',
		        			items:[
		        				{
		        					xtype: 'container',
		        					flex:.3,
		        					margin:6,
		        					html: '<div class="'+imageClass+'"></div>'
		        				},
								{
		        					xtype: 'container',
		        					flex:.3,
		        					margin:10,
		        					html: '<div style="float:left">'+genHTML1+'</div>'
		        				}
		        				
		        			]
		        		}
		        	]
    			}
    		);
    	}
		if(Ext.getCmp('block'+key[0])){
			Ext.getCmp('block'+key[0]).addCls('lastChild');
		}
    	blockObj.doLayout();
    	var ddValues = resultData['DD_METRICS'];
    	for ( var key in ddValues )
    	{
    		var ddTitle = ddValues[key]['TITLE'];
    		var ddMesval =  ddValues[key]['VALUE'];
    		var imageClass = '';
    		blockObj.add(
    			{
    				xtype: 'container',
		        	id: 'ddblock'+key,
		        	itemId: 'ddblock'+key,
		        	cls: 'searchSeperatorLine',
		        	layout: 'vbox',
//		        	width: 215,
		        	height: 140,
		        	
		        	items:[
		        		{
		        			xtype: 'label',
		        			margin: '8px',
							width:'100%',
		        			html: '<div style="font-weight:bold;">'+ddTitle+'</div>'
		        		},
		        		{
		        			xtype: 'container',
		        			layout: 'hbox',
		        			items:[
		        				{
		        					xtype: 'container',
		        					flex:.3,
		        					margin:6,
		        					html: '<div class="'+imageClass+'"></div>'
		        				},
		        				{
		        					xtype: 'label',
		        					flex:.7,
		        					margin:10,
		        					html: '<b style="font-size:18px">'+ddMesval+'</b>'
		        				}
		        			]
		        		}
		        	]
    			}
    		);
    	}
	if(Ext.getCmp('ddblock'+key[0])){
		Ext.getCmp('ddblock'+key[0]).addCls('lastChild');
		}
    	blockObj.doLayout();
    	var getItems = blockObj.items.length;
    	if ( ( getItems / 4 ) > 1 )
    	{
    		var genHt = Math.ceil(( getItems / 4 ));
	    	var tmpHeight = blockObj.getHeight() * genHt;
	    	tmpHeight = Math.round(tmpHeight);
    	}
    	this.genDialCharts('userdialgraphpnl', resultData);
    	this.loadLineMetrics('userlinegraphpnl', resultData);
    	this.loadBarMetrics('userbargraphpnl', resultData);

	},
	showUserDesktop: function ( resultData )
	{
		this.getUserdesktopdata().show();
		var ipAddress = 'N/A';
		var osType = 'N/A';
		var loggedInfo = '';
		var summaryTxt = 'Desktop Summary';
		var summaryImageClass = 'summaryDesktop';
		if ( resultData['SUMMARY'] != undefined )
		{
			var userSummaryResult = resultData['SUMMARY'];
			if ( userSummaryResult['IP_ADDRESS'] != undefined )
			{
				ipAddress = userSummaryResult['IP_ADDRESS'];
			}
			if ( userSummaryResult['OS_TYPE'] != undefined )
			{
				osType = userSummaryResult['OS_TYPE'];
			}
			if ( userSummaryResult['loggedInfo'] != undefined )
			{
				Ext.getCmp('loggedInfo').setText(userSummaryResult['loggedInfo']);
			}
			if ( userSummaryResult['summaryInfo'] != undefined )
			{
				summaryTxt = userSummaryResult['summaryInfo'];
			}
			if ( userSummaryResult['summaryImageClass'] != undefined )
			{
				summaryImageClass = userSummaryResult['summaryImageClass'];
			}
		}
		var getInnerHTML = Ext.get('summary-div').dom.innerHTML;
		Ext.get('summary-div').update(Ext.String.format(getInnerHTML, summaryImageClass));
		Ext.getCmp('usersummarytitle').update('<div class="title"><b>'+summaryTxt+'</b></div>');
		Ext.getCmp('ipAddress').update(ipAddress);
		Ext.getCmp('ipAddress').tip = ipAddress;
		Ext.getCmp('ipAddress').fireEvent('afterrender', Ext.getCmp('ipAddress'));
		var tmpOSType = Ext.String.ellipsis(osType, 40);
		Ext.getCmp('osType').update(tmpOSType);
		Ext.getCmp('osType').tip = osType;
		Ext.getCmp('osType').fireEvent('afterrender', Ext.getCmp('osType'));
		var blockValues = resultData['BLOCK_VALUES'];
		var blockObj = Ext.getCmp('block1panel');
		var key;
    	for ( key in blockValues )
    	{
    		var blockVal = blockValues[key];
    		var title = blockVal['TITLE'];
			if(title !=null && title.indexOf('%') > -1)
				title=title.substring(0,title.indexOf('('))
    		var imageClass = blockVal['IMAGE_CLASS_NAME'];			
    		var measureVal = blockVal['MEASURE_VALUE'];
    		var ddLink = blockVal['DD_LINK'];
    		var ddTitle = blockVal['DD_TITLE'];
			var layerLink = blockVal['LAYERMODEL_LINK'];
    		var genHTML = '';
    		var genHTML1 = '';
			if (measureVal!=null && measureVal!='' && measureVal!=undefined && measureVal!="-")
			{
				if(layerLink!=undefined && layerLink!=null && layerLink!="")
				{
					if ( ddLink!=null && ddLink!='' && ddLink!=undefined)
					{
						if(!Ext.isEmpty(csrfToken) && csrfToken!=undefined && csrfToken!=null)
							ddLink = ddLink+"&com.eg.CSRF_NONCE="+csrfToken;

						genHTML = '<img src="/final/images/clear.png" class="iconDiagnosis" style="cursor:pointer;vertical-align:middle;padding:0px 10px;position:relative;left:10px" onclick="javascript:openDD(\''+ddLink+'\');"/>';
						//genHTML1 = '<table width="100%"><tr><td align="right"><a href="javascript:void(0);" class="font_bold" onclick="javascript:openDD(\''+ddLink+'\');">'+title+'</a></td></tr></table>';
					}
				}
			}
			if (measureVal!=null && measureVal!='' && measureVal!=undefined && measureVal!="-")
			{
				if(layerLink!=undefined && layerLink!=null && layerLink!="")
				{
					genHTML1 = '<table width="100%"><tr><td align="right" class="font_bold" style="cursor:pointer;line-height:15px"><span onclick="javascript:wayToLayerModel(\''+layerLink+'\');">'+title+'</span>';
					if ( genHTML != undefined )
					{
						genHTML1 +=genHTML;
					}
					genHTML1 +='</td></tr></table>';
				}
				else
				{
					genHTML1 = '<table width="100%"><tr><td align="right" class="font_bold" style="cursor:default;line-height:15px"><span >'+title+'</span>';
					if ( genHTML != undefined )
					{
						genHTML1 +=genHTML;
					}
					genHTML1 +='</td></tr></table>';
				}

			}
			else
			{
				genHTML1 = '<table width="100%"><tr><td align="right" class="font_bold">'+title+'</td></tr></table>';
			}
			
			if (measureVal!=null && measureVal!='' && measureVal!=undefined && measureVal!="-")
			{
				var measureHTML = "";
				if(layerLink!=undefined && layerLink!=null && layerLink!="")
				{
					measureHTML = '<div style="cursor:pointer;line-height:15px" onclick="javascript:wayToLayerModel(\''+layerLink+'\');"><table width="100%" ><tr><td align="right"><b style="font-size:24px;text-align:right">'+measureVal+'</b></td></tr></table></div>';
				}
				else
				{
					measureHTML = '<div style="cursor:default;line-height:15px" ><table width="100%" ><tr><td align="right"><b style="font-size:24px;text-align:right">'+measureVal+'</b></td></tr></table></div>';
				}
			}
			else
			{
				var measureHTML = '<div><table width="100%" ><tr><td align="right"><b style="font-size:24px;text-align:right">'+measureVal+'</b></td></tr></table></div>';
			}
    		blockObj.add(
    			{
    				xtype: 'container',
		        	id: 'block'+key,
		        	itemId: 'block'+key,
					cls:'searchSeperatorLine',
					padding:0,
					border:true,
					style:{'border':'#000 1px solid'},
		        	layout: 'vbox',
		        	items:[
		        		{
		        			xtype: 'label',
		        			margin: 8,
							width:'100%',
		        			html: '<div>'+measureHTML+'</div>'
		        		},
		        		{
		        			xtype: 'container',
		        			layout: 'hbox',
							width:'100%',
		        			items:[
		        				{
		        					xtype: 'container',
		        					flex:.3,
		        					margin:6,
		        					html: '<div class="'+imageClass+'"></div>'
		        				},
								{
		        					xtype: 'container',
		        					flex:.3,
		        					margin:10,								
		        					html: '<div style="float:left">'+genHTML1+'</div>'
		        				}
		        				
		        			]
		        		}
		        	]
    			}
    		);

    	}
		if(Ext.getCmp('block'+key[0])){
			Ext.getCmp('block'+key[0]).addCls('lastChild');
		}
    	blockObj.doLayout(); // Need to check this case for design - Jaiwin
    	var ddValues = resultData['DD_METRICS'];
    	for ( var key in ddValues )
    	{
    		var ddTitle = ddValues[key]['TITLE'];
    		var ddMesval =  ddValues[key]['VALUE'];
    		var imageClass = '';
    		blockObj.add(
    			{
    				xtype: 'container',
		        	id: 'ddblock'+key,
		        	itemId: 'ddblock'+key,
		        	//cls: 'block1',
		        	layout: 'vbox',
//		        	width: 215,
		        	height: 140,
		        	items:[
		        		{
		        			xtype: 'label',
		        			margin: '8px',
		        			html: '<div style="font-weight:bold;">'+ddTitle+'</div>'
		        		},
		        		{
		        			xtype: 'container',
		        			layout: 'hbox',
		        			items:[
		        				{
		        					xtype: 'container',
		        					flex:.3,
		        					margin:6,
		        					html: '<div class="'+imageClass+'"></div>'
		        				},
		        				{
		        					xtype: 'label',
		        					flex:.7,
		        					margin:10,
		        					html: '<b style="font-size:18px">'+ddMesval+'</b>'
		        				}
		        			]
		        		}
		        	]
    			}
    		);
    	}
    	blockObj.doLayout();
    	var getItems = blockObj.items.length;
    	if ( ( getItems / 4 ) > 1 )
    	{
    		var genHt = Math.ceil(( getItems / 4 ));
	    	var tmpHeight = blockObj.getHeight() * genHt;
	    	tmpHeight = Math.round(tmpHeight);
	    	blockObj.setHeight(tmpHeight);
    	}
    	this.genDialCharts('userdesktopdialgraphpnl', resultData);
    	this.loadLineMetrics('userdesktoplinegraphpnl', resultData);
    	this.loadBarMetrics('userdesktopbargraphpnl', resultData);
	},
	showVM: function( resultData )
	{
		this.getVmdata().show();
		var ipAddress = 'N/A';
		var osType = 'N/A';
		var loggedInfo = '';
		var summaryTxt = '';
		var summaryImageClass = '';
		if ( resultData['SUMMARY'] != undefined )
		{
			var vmSummaryResult = resultData['SUMMARY'];
			if ( vmSummaryResult['IP_ADDRESS'] != undefined )
			{
				ipAddress = vmSummaryResult['IP_ADDRESS'];
			}
			if ( vmSummaryResult['OS_TYPE'] != undefined )
			{
				osType = vmSummaryResult['OS_TYPE'];
			}
			if ( vmSummaryResult['summaryImageClass'] != undefined )
			{
				summaryImageClass = vmSummaryResult['summaryImageClass'];
			}
			var getInnerHTML = Ext.get('summary-div').dom.innerHTML;
			//Ext.get('summary-div').update(Ext.String.format(getInnerHTML, summaryImageClass));
			//Ext.get('summary-div').update('<div style="margin:auto;text-align:center"><img src="/final/images/component_icons/System.png" height="55" width="58"/></div>');
			Ext.get('ipAddress1').update(ipAddress);
			Ext.get('ipAddress1').update('<div title="'+ipAddress+'">'+ipAddress+'</div>');
			var tmpOSType = Ext.String.ellipsis(osType, 40);
			Ext.get('osType1').update('<div title="'+osType+'">'+tmpOSType+'</div>');
		}
		var vmObj = Ext.getCmp('vmblock1panel');
		var tableValues = resultData['TABLE_VALUES'];
		var tableTitle = resultData['TABLE_TITLE'];
		var tableHTML = '';
		for ( var i = 0; i < tableValues.length; i+=2 )
		{
			var tableValue = tableValues[i];
			var state = tableValue['STATE'];
			var measName = tableValue['MEASURE_NAME'];
			var unit = tableValue['UNIT'];
			var value = tableValue['VALUE'];
			state = state.toUpperCase();
			var secondHTML = '';
			var ddHTML1 = '<td class="x-grid-cell" width="30px"><div class="x-grid-cell-inner">&nbsp;</div></td>';
			if ( i < ( tableValues.length - 1 ) )
			{
				var state1 = tableValues[i+1]['STATE'];
				var measName1 = tableValues[i+1]['MEASURE_NAME'];
				var unit1 = tableValues[i+1]['UNIT'];
				var value1 = tableValues[i+1]['VALUE'];
				state1 = state1.toUpperCase();
				secondHTML = '<td class="x-grid-cell" width="30px"><div class="x-grid-cell-inner"><div class="state_'+state1+'" style="border:0px solid red;"></div></div></td><td class="x-grid-cell"><div class="x-grid-cell-inner" >'+measName1+'&nbsp;'+unit1+'</div></td><td class="x-grid-cell" width="75px"><div class="x-grid-cell-inner" >'+value1+'</div></td>';
				if ( tableValues[i+1]['DD'] != undefined )
				{
					var ddTITLE1 = tableValues[i+1]['DD']['DD_TITLE'];
					var ddLink1 = tableValues[i+1]['DD']['DD_LINK'];

					if ( ddLink1!=null && ddLink1!='' && ddLink1!=undefined)
					{
						if(!Ext.isEmpty(csrfToken) && csrfToken!=undefined && csrfToken!=null)
							ddLink1 = ddLink1+"&com.eg.CSRF_NONCE="+csrfToken;

						ddHTML1 = '<td class="x-grid-cell" width="30px"><div class="x-grid-cell-inner"><div class="iconDiagnosis2" style="cursor:pointer" onclick="javascript:openDD(\''+ddLink1+'\');" title="'+ddTITLE1+'"></div></div></td>';
					}
				}
			}
			else
			{
				secondHTML = '<td class="x-grid-cell" width="30px"><div class="x-grid-cell-inner"><div style="border:0px solid red;"></div></div></td><td class="x-grid-cell"><div class="x-grid-cell-inner" width="75px">&nbsp;</div></td><td class="x-grid-cell"><div class="x-grid-cell-inner">&nbsp;</div></td>';
			}
			secondHTML += ddHTML1;
			var ddHTML = '<td class="x-grid-cell" width="30px"><div class="x-grid-cell-inner">&nbsp;</div></td>';
			if ( tableValue['DD'] != undefined )
			{
				var ddTITLE = tableValue['DD']['DD_TITLE'];
				var ddLink = tableValue['DD']['DD_LINK'];
				if ( ddLink!=null && ddLink!='' && ddLink!=undefined)
					{
						if(!Ext.isEmpty(csrfToken) && csrfToken!=undefined && csrfToken!=null)
							ddLink = ddLink+"&com.eg.CSRF_NONCE="+csrfToken;

						ddHTML = '<td class="x-grid-cell" width="30px"><div class="x-grid-cell-inner"><div class="iconDiagnosis2" style="cursor:pointer" onclick="javascript:openDD(\''+ddLink+'\');"></div></div></td>';
					}
			}
			tableHTML += '<tr class="x-grid-row">';
			tableHTML += '<td class="x-grid-cell" width="30px"><div class="x-grid-cell-inner"><div class="state_'+state+'" style="border:0px solid red;"></div></div></td><td class="x-grid-cell"><div class="x-grid-cell-inner" >'+measName+'&nbsp;'+unit+'</div></td><td class="x-grid-cell" width="75px"><div class="x-grid-cell-inner" >'+value+'</div></td>'+ddHTML+secondHTML;
			tableHTML += '</tr>';
		}
		tableHTML = '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">'+tableHTML+'</table>';
		vmObj.add(
			{
				xtype: 'container',
				html: '<div class="x-table"><table border="0" width="75%" cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer"><tr class="x-grid-row"><th class=" x-grid-cell"><div class="x-grid-cell-inner"  style="overflow:visible;text-align:left;"><b>'+tableTitle+'</b></div></th></tr><tr><tr>'+tableHTML+'</tr></table></div>'
		});
		vmObj.doLayout();
		this.genDialCharts('vmdialgraphpnl', resultData);
		this.loadLineMetrics('vmlinegraphpnl', resultData);
    	this.loadBarMetrics('vmbargraphpnl', resultData);
	},
	genDialCharts: function( id , resultData )
	{
		var dialObj = Ext.getCmp(id);
    	var dialValues = resultData['DIAL_METRICS'];
		if ( !Ext.isEmpty( dialValues ) )
		{
			dialObj.add(
			{
				xtype: 'panel',
				id: 'dialpanel',
				cls:'block1',				
				border:true,
				//minHeight:150,
				//height:350,
				flex:1,
				frame:true,
				layout:'column',
				defaults:
				{
					margin:'10 0 10 10',
					columnWidth:.25
				}
			});
			var dialPanelObj = Ext.getCmp('dialpanel');
    		for ( var key in dialValues )
    		{
    			var dialTitle = dialValues[key]['TITLE'];
    			var xmlData = dialValues[key]['XML_DATA'];
				var htmlString = '';
				if (xmlData!=null && xmlData!='' && xmlData!='-')
				{
					var goToPageTmp=xmlData["goToPage"];
					if(goToPageTmp!=undefined && goToPageTmp!=null && goToPageTmp!="")
					{
						htmlString = '<div id="dial-block-'+key+'" style="cursor:pointer;margin-top:0px;height:130px;"></div>';
					}
					else
					{
						htmlString = '<div id="dial-block-'+key+'" style="cursor:default;margin-top:0px;height:130px;"></div>';
					}
				}
				else
				{
					htmlString = '<div id="dial-block-'+key+'" style="cursor:default;margin-top:0px;height:130px;"></div>';
				}
    			dialPanelObj.add(
    			{
    				xtype: 'container',
					listeners:{
						afterrender:function(){
							if(this.id == 'dialblock3'){
								$('#dialblock3').removeClass('searchSeperatorLine');
							}
						}
					},
		        	id: 'dialblock'+key,
		        	itemId: 'dialblock'+key,
		        	cls:'searchSeperatorLine',
					title:dialTitle,
					border:true,
					frame:true,
					
		        	height: 150,
					defaults:{
						//margin:4
					},
		        	items:[
							{
		        			xtype:'label',
							width:'100%',
							//height:'100%',
							labelAlign:'center',
							html:'<div class="font_bold" style="text-align:center">'+dialTitle+'</div>',
							},
							{
								xtype: 'container',
								html: htmlString
		        			}
		        	]
    			});
    		}
			if(Ext.getCmp('dialblock'+key[0])){
				Ext.getCmp('dialblock'+key[0]).addCls('lastChild');
			}
			
    		
	    	var getItems = dialObj.items.length;
	    	if ( ( getItems / 4 ) > 1 )
	    	{
	    		var genHt = Math.ceil(( getItems / 4 ));
		    	var tmpHeight = dialObj.getHeight() * genHt;
		    	tmpHeight = Math.round(tmpHeight);
		    	dialObj.setHeight(tmpHeight);
	    	}
    		dialObj.dataArray = dialValues;
    		dialObj.fireEvent('boxready', dialValues);
			dialPanelObj.doComponentLayout();

    	}
	},
	loadLineMetrics: function( id, resultData)
	{		
		var highChartUrls = new Array();
		var highChartIds = new Array();
		var legendIds = new Array();
		var highChartHeight = new Array();
		var highChartWidth = new Array();
		var highChartMaxUrl = new Array();
		var lineObj = Ext.getCmp(id);
    	var lineValues = resultData['LINE_METRICS'];
		var isAxisTimeReq = false;
		var legendPos = "bottom";
		var j=0;		
    	if ( !Ext.isEmpty( lineValues ) )
    	{
    		for ( var key in lineValues )
    		{
    			var lineTitle = lineValues[key]['TITLE'];
    			var imgURL = lineValues[key]['IMAGE_URL'];
				var graphFormat = lineValues[key]['GRAPH_FORMAT'];
				var type = lineValues[key]['Type'];
    			var tmpArray = new Array();
    			tmpArray[tmpArray.length] = lineValues[key]['COMPONENT_DETAILS'];
    			tmpArray[tmpArray.length] = lineValues[key]['TEST'];
    			tmpArray[tmpArray.length] = lineValues[key]['MEASURE'];
    			var imgHeight = 235;
    			var imgWidth = 630;
    			var dataArray = new Array();
    			dataArray[0] = lineTitle;
    			dataArray[1] = imgURL;
    			dataArray[2] = type;
    			dataArray[3] = graphFormat;
    			dataArray[4] = tmpArray;
				var imgDiv = '',isTitleHidden = false;
				if(!Ext.isEmpty(graphFormat))
				{
					if(graphFormat.indexOf("highchart") > -1)
					{
						imgDiv = '<div id="desktopChart'+key+'"></div>';
						highChartIds.push('desktopChart'+key);
						legendIds.push('legend'+key);
						highChartUrls.push(imgURL);
						highChartHeight.push(imgHeight);
						//highChartWidth.push((this.getWidth() - 10 ));
						isTitleHidden = true;
						highChartMaxUrl.push('highchartlineblock'+key);
					}

				}
    			lineObj.add(
    			{
    				xtype: 'panel',
		        	id: 'lineblock'+key,
		        	itemId: 'lineblock'+key,
		        	cls: 'datapanel',
		        	dataArray: dataArray,
					border:true,
					frame:true,
					title:lineTitle,
		        	width: 450,
		        	height: 230,
					/*tools:[{
						xtype:'button',
						cls:'iconMaximize',
						style:{'border':'none'},
						handler: function()
						{
							maximizedView('highchart'+this.up('panel').id);
						}
					}],*/
		        	items:[
		        			{
								xtype:'container',
								width: '100%',
								id:'legend'+key
							},
		        			{
		        			xtype: 'container',
		        			layout: 'hbox',
		        			width: '100%',
							height: 190,
							margin:'0px 0px 0px 0px',
							id:'desktopChart'+key,
		        			items:[
		        				{
		        					xtype: 'container',
									//flex:.7,
									height:'100%',
									width: '100%',
		        					margin:'0px 5px 0px 0px',
		        					dataArray: imgURL,
									MaxData:dataArray,
		        					html: imgDiv,
		        					listeners:{
		        							'afterrender': function()
		        							{
		        								var URL = this.dataArray;												
												if(!Ext.isEmpty(graphFormat))
												{
													if(graphFormat.indexOf("highchart") > -1){

														setHighChart(highChartUrls[j],highChartIds[j],legendIds[j],190,imgWidth,this.MaxData,isAxisTimeReq,legendPos,false,"line",'up');
													}
													else
													{
														this.update('<img src="'+URL+'&height='+imgHeight+'&width='+( this.getWidth() - 10 )+'&mode=2D" />');
													}
												}
		        								j = j+1;
		        							}
		        					}
		        				}
		        			]
		        		}
		        	]
    			});
    		}
    		lineObj.doLayout();
		}
		var areaValues = resultData['AREA_METRICS'];
		if ( !Ext.isEmpty( areaValues ) )
		{
			var highChartUrls1 = new Array();
			var highChartIds1 = new Array();
			var legendIds1 = new Array();
			var highChartHeight1 = new Array();
			var highChartWidth1 = new Array();
			var highChartMaxUrl1 = new Array();
			var jk=0;
			for ( var key in areaValues )
			{
				var lineTitle = areaValues[key]['TITLE'];
				var imgURL = areaValues[key]['areaChartURL'];				
				var type = areaValues[key]['Type'];		
				var graphFormat = areaValues[key]['GRAPH_FORMAT'];
				var tmpArray = new Array();
				tmpArray[tmpArray.length] = areaValues[key]['COMPONENT_DETAILS'];
				tmpArray[tmpArray.length] = areaValues[key]['TEST'];
				tmpArray[tmpArray.length] = areaValues[key]['MEASURE'];			
				//var imgHeight = 170;
				var imgHeight = 235;
				var imgWidth = 630;
				var dataArray = new Array();				
				dataArray[0] = lineTitle;
				dataArray[1] = imgURL;
				dataArray[2] = type;
				dataArray[3] = graphFormat;
				dataArray[4] = tmpArray;
				var imgDiv = '',isTitleHidden = false;
				if(!Ext.isEmpty(graphFormat))
				{
					if(graphFormat.indexOf("highchart") > -1)
					{
						imgDiv = '<div id="areaDesktopChart'+key+'"></div>';
						highChartIds1.push('areaDesktopChart'+key);
						highChartUrls1.push(imgURL);
						legendIds1.push('arealegend'+key);
						highChartHeight1.push(imgHeight);
						highChartMaxUrl1.push('highchartareablock'+key);
					}

				}				
				lineObj.add(
				{
					xtype: 'panel',
					id: 'areablock'+key,
					itemId: 'areablock'+key,
					dataArray: dataArray,
					cls: 'datapanel',
					border:true,
					frame:true,
					title:lineTitle,
					width: 450,
					height: 230,
					/*tools:[{
						xtype:'button',
						cls:'iconMaximize',
						style:{'border':'none'},
						handler: function()
						{
							maximizedView('highchart'+this.up('panel').id);
						}
					}],*/
					items:[
						{
							xtype:'container',
							width: '100%',
							id:'arealegend'+key
						},
						{
							xtype: 'container',
							layout: 'hbox',
							width: '100%',
							height: 190,
							margin:'0px 0px 0px 0px',
							id:'areaDesktopChart'+key,
							items:[
								{
									xtype: 'container',
									//flex:.7,
									height:'100%',
									width: '100%',
									margin:'0px 5px 0px 0px',
									dataArray: imgURL,
									MaxData:dataArray,
									html: imgDiv,
									listeners:{
											'afterrender': function()
											{
												var URL = this.dataArray;
												if(!Ext.isEmpty(graphFormat))
												{
													if(graphFormat.indexOf("highchart") > -1){

														setHighChart(highChartUrls1[jk],highChartIds1[jk],legendIds1[jk],190,imgWidth,this.MaxData,isAxisTimeReq,legendPos,false,"area",'up');
													}
													else
													{
														this.update('<img src="'+URL+'&height='+imgHeight+'&width='+( this.getWidth() - 10 )+'&mode=2D" />');
													}
												}
												jk = jk+1;
											}
									}
								}
							]
						}
					]
				});
			}

		}
		lineObj.doLayout();
	
		var getItems = lineObj.items.length;
		if ( ( getItems / 2 ) > 1 )
		{
			var genHt = Math.ceil(( getItems / 2 ));
			var tmpHeight = 250 * genHt;
			tmpHeight = Math.round(tmpHeight);
			lineObj.setHeight(tmpHeight);
		}
    	
	},	
	loadBarMetrics: function( id, resultData )
	{
		var barObj = Ext.getCmp(id);
    	var barValues = resultData['BAR_METRICS'];
		if ( !Ext.isEmpty( barValues ) )
		{
			for ( var key in barValues )
			{
				var barTitle = barValues[key]['TITLE'];
				var dataArray = new Array();
    			dataArray[0] = barTitle;
				barObj.add(
				{
    				xtype: 'panel',
		        	id: 'bar-block-'+key,
		        	itemId: 'bar-block-'+key,
		        	layout:
					{
						type:'vbox',
						align:'stretch',
					},
					flex:1,
		        	cls: 'datapanel',

		        	dataArray: dataArray,
					border:true,
					frame:true,
					scroll:true,
					autoScroll:true,
					title:barTitle,
					barId:key,
		        	width: 600,
		        	height: 240,
					/*tools:[{
						xtype:'button',
						cls:'iconMaximize',
						id:'barMaximizedId'+key,
						style:{'border':'none'},
						handler: function()
						{							
							maximizedBar('bar',this.up('panel').barId);
						}
					}],*/
		        	items:[		        		
		        		{
							xtype: 'container',		        					
							scroll:true,
							autoScroll:true,
							flex:1,
							cls:'barchartclasss',
							//autoScroll : true,
							//scroll : true,
							html: '<div id="barChart-'+key+'" style="height:200px;width:600px;"></div>'
		        		}
		        	]
				});
			}
			barObj.dataArray = barValues;
			barObj.fireEvent('boxready', barValues);
			barObj.doLayout();
			var getItems = barObj.items.length;
	    	if ( ( getItems / 2 ) > 1 )
	    	{
	    		var genHt = Math.ceil(( getItems / 2 ));
		    	var tmpHeight = 255 * genHt;
		    	tmpHeight = Math.round(tmpHeight);
		    	barObj.setHeight(tmpHeight);
	    	}
		}
	},
    userdetailsDefaultLoad: function ()
    {
//      this.getUserdata().loadDefaultData();
	},
	onBackBtnClick:function()
	{		
		var searchObj = window.parent.getSearchBoxObj();
		var searchParam=searchValue;
		if(searchParam==null || searchParam=='' || searchParam==undefined)
			searchParam='*';
		var searchCmbObj = window.parent.getSearchComboObj();

		if(searchObj!=null && searchObj!="" && !Ext.isEmpty(searchObj) && searchObj!=undefined)
		{
			document.location="/final/monitor/eGSearch.jsp?searchuser="+searchCmbObj.getValue()+" "+searchParam;
		}
		else if(!Ext.isEmpty(userSearchParams) && userSearchParams!=null && userSearchParams!=undefined && userSearchParams.indexOf('searchuser')!=-1)
		{
			document.location='/final/monitor/eGSearch.jsp?'+userSearchParams;
		}
		else
		{
			window.history.back();
		}
	},
	maximizedView: function ()
	{		
        maxiView=true;
        maximizedFunction='maximizedView';
		var urlForMaximize = publicJsonData['urlForMaximize'];
        var getMainWidth = this.getMain().getWidth(),
            getMainHeight = this.getMain().getHeight();
			Ext.widget('maximizeview', {
				width: getMainWidth,
				height: getMainHeight,
				id : 'Maximize',
				html:'<div style="margin:6px"><img src='+urlForMaximize+' width='+(getMainWidth-120)+' height= '+(getMainHeight-220)+' /></div>'

			}).show();

	},

	BarOnclick:function(i)
	{
		var br_path = publicJsonData['path'];
		var barGrps = publicJsonData['BarGraph'];
		var bartitle = publicJsonData['bartitle'];
		var getMainWidth = this.getMain().getWidth(),
            getMainHeight = this.getMain().getHeight();

			Ext.widget('maximizeview', {
				width: getMainWidth,
				height: getMainHeight,

				html:'<div style="margin:8px"><font size="5"><b><center>' + bartitle[i] + '</center></b></font></div><div id="Maximize' + i +'" style="float:left;margin:4px;"></div>'

			}).show();

			var bargraph = new FusionCharts(br_path, "Gauge" + i,(getMainWidth-20), (getMainHeight-20), "0", "1");
                bargraph.setDataXML(barGrps[i]);
                bargraph.setTransparent(true);
                bargraph.render("Maximize" + i);

	},
	AreaOnclick:function(i)
	{		
		var areaGrps = publicJsonData['areagraphdata'];
		var a_path = publicJsonData['a_path'];
        var areatitle = publicJsonData['areatitle'];
		 var getMainWidth = this.getMain().getWidth(),
            getMainHeight = this.getMain().getHeight();

			Ext.widget('maximizeview', {
				width: getMainWidth,
				height: getMainHeight,

				html:'<div style="margin:8px"><font size="5"><b><center>' + areatitle[i] + '</center></b></font></div><div id="areachart_max' + i + '" style="margin:4px;"></div>'

			}).show();

			var areachart_fv = new FusionCharts(a_path, "ChartId" + i, (getMainWidth-65), (getMainHeight-65), "0", "1");
                areachart_fv.setDataXML(areaGrps[i]);
                areachart_fv.setTransparent(true);
                areachart_fv.render("areachart_max" + i);

	},
});