/*--------------------------------------------------|
| virtualtree 2.05 | www.destroydrop.com/javascript/tree/ |
|---------------------------------------------------|
| Copyright (c) 2002-2003 Geir Landr               |
|                                                   |
| This script can be used freely as long as all     |
| copyright messages are intact.                    |
|                                                   |
| Updated: 17.04.2003                               |
|--------------------------------------------------*/


// Node object
function Node(id, pid, name, url, title, target, icon, iconOpen, open, isHost) {
	this.id = id;
	this.pid = pid;
	this.name = name;
	this.url = url;
	this.title = title;
	this.target = target;
	this.icon = icon;
	this.iconOpen = iconOpen;
	this._io = open || false;
	this._is = false;
	this._ls = false;
	this._hc = false;
	this._ai = 0;
	this._p;
	this.isHost=isHost;
};

// Node object overloaded
function Node(id, pid, name, url, title, target, icon, iconOpen, open, isHost,_hc,_ls) {
	this.id = id;
	this.pid = pid;
	this.name = name;
	this.url = url;
	this.title = title;
	this.target = target;
	this.icon = icon;
	this.iconOpen = iconOpen;
	this._io = open || false;
	this._is = false;
	this._ls = _ls || false;
	this._hc = _hc || false;
	this._ai = 0;
	this._p;
	this.isHost=isHost;
};

// Tree object
function virtualtree(objName) {
	this.config = {
		target					: null,
		folderLinks				: true,
		useSelection			: true,
		useCookies				: true,
		useLines				: true,
		useIcons				: true,
		useStatusText		: false,
		closeSameLevel		: true,
		inOrder					: false
	}

	this.icon = {
		root					: '/final/monitor/eg_images/Tree/map_zone.gif',
		folder				: '/final/monitor/eg_images/Tree/folder.gif',
		folderOpen		: '/final/monitor/eg_images/Tree/folderopen.gif',
		node					: '/final/monitor/eg_images/Tree/page.gif',
		empty				: '/final/monitor/eg_images/Tree/empty.gif',
		line					: '/final/monitor/eg_images/Tree/line.gif',
		join					: '/final/monitor/eg_images/Tree/join.gif',
		joinBottom		: '/final/monitor/eg_images/Tree/joinbottom.gif',
		plus					: '/final/monitor/eg_images/Tree/plus.gif',
		plusBottom		: '/final/monitor/eg_images/Tree/plusbottom.gif',
		minus				: '/final/monitor/eg_images/Tree/minus.gif',
		minusBottom	: '/final/monitor/eg_images/Tree/minusbottom.gif',
		nlPlus				: '/final/monitor/eg_images/Tree/nolines_plus.gif',
		nlMinus				: '/final/monitor/eg_images/Tree/nolines_minus.gif'
	};

	this.obj = objName;
	this.aNodes = [];
	this.aIndent = [];
	this.root = new Node(-1);
	this.selectedNode = null;
	this.selectedFound = false;
	this.completed = false;
};

// Adds a new node to the node array
virtualtree.prototype.add = function(id, pid, name, url, title, target, icon, iconOpen, open,isHost) 
{
	this.aNodes[this.aNodes.length] = new Node(id, pid, name, url, title, target, icon, iconOpen, open,isHost);
	var treeRefreshDiv=window.parent.document.getElementById("treeRefreshDiv");
	var str='';
};
// Adds a new node to the node array---over loaded
virtualtree.prototype.add = function(id, pid, name, url, title, target, icon, iconOpen, open,isHost,_hc,_ls) 
{
	this.aNodes[this.aNodes.length] = new Node(id, pid, name, url, title, target, icon, iconOpen, open,isHost,_hc,_ls);
	var treeRefreshDiv=window.parent.document.getElementById("treeRefreshDiv");
	var str='';
};
// Open/close all nodes
virtualtree.prototype.openAll = function() {
	this.oAll(true);
};

virtualtree.prototype.closeAll = function() {
	this.oAll(false);
};
// Outputs the tree to the page
virtualtree.prototype.toString = function() {
	var allString = new Array();
	allString.push('<div class="dtree">\n');
	if (document.getElementById) {
		if (this.config.useCookies) this.selectedNode = this.getSelected();
		allString.push(this.addNode(this.root));
	} else 
	{
		allString.push('Browser not supported.');
	}
	allString.push('</div>');
	if (!this.selectedFound) this.selectedNode = null;
	this.completed = true;
	return allString.join('');
};
// Creates the tree structure
virtualtree.prototype.addNode = function(pNode) {
	var str = '';
	var allString = new Array();
	var n=0;
	if (this.config.inOrder) n = pNode._ai;
	else if(pNode.id>=0)
	{
		n=pNode.id;
	}
	for (n; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == pNode.id) {
			var cn = this.aNodes[n];
			cn._p = pNode;
			cn._ai = n;
			//this.setCS(cn);
			if (!cn.target && this.config.target) cn.target = this.config.target;
			if (cn._hc && !cn._io && this.config.useCookies) cn._io = this.isOpen(cn.id);
			if (!this.config.folderLinks && cn._hc) cn.url = null;
			if (this.config.useSelection && cn.id == this.selectedNode && !this.selectedFound) {
					cn._is = true;
					this.selectedNode = n;
					this.selectedFound = true;
			}
			//str += this.node(cn, n);
			allString.push(this.node(cn, n));
			if (cn._ls) break;
		}
	}
	//return str;
	return allString.join('');
};

// Creates the node icon, url and text
virtualtree.prototype.node = function(node, nodeId) {

	var allString = new Array();
	allString.push('<div class="dTreeNode">' + this.indent(node, nodeId));
	if (this.config.useIcons) {

		if (!node.icon) node.icon = (this.root.id == node.pid) ? this.icon.root : ((node._hc) ? this.icon.folder : this.icon.node);

		if (!node.iconOpen) node.iconOpen = (node._hc) ? this.icon.folderOpen : this.icon.node;

		if (this.root.id == node.pid) {

			node.icon = this.icon.root;

			node.iconOpen = this.icon.root;

		}

		allString.push('<img id="i' + this.obj + nodeId + '" src="' + ((node._io) ? node.iconOpen : node.icon) + '" alt="" />');
	}

	if (node.url) {

		allString.push('<a id="s' + this.obj + nodeId + '" class="' + ((this.config.useSelection) ? ((node._is ? 'nodeSel' : 'node')) : 'node') + '" href="' + node.url + '"');
		if (node.title) 
		{
			allString.push(' title="' + node.title + '"');
		}

		if (node.target) 
		{
			allString.push(' target="' + node.target + '"');
		}

		if (this.config.useStatusText) 
		{
			allString.push(' onmouseover="window.status=\'' + node.name + '\';return true;" onmouseout="window.status=\'\';return true;" ');
		}

		if (this.config.useSelection && ((node._hc && this.config.folderLinks) || !node._hc))
		{
			allString.push(' onclick="javascript: ' + this.obj + '.s(' + nodeId + ');"');
		}

		allString.push('>');

	}

	else if ((!this.config.folderLinks || !node.url) && node._hc && node.pid != this.root.id)
	{
		allString.push('<a href="javascript: ' + this.obj + '.o(' + nodeId + ');" class="node">');
	}

	allString.push(node.name);

	if (node.url || ((!this.config.folderLinks || !node.url) && node._hc)) 
	{
		allString.push('</a>');
	}

	allString.push('</div>');

	if (node._hc) {

		allString.push('<div id="d' + this.obj + nodeId + '" class="clip" style="display:' + ((this.root.id == node.pid || node._io) ? 'block' : 'none') + ';">');

		allString.push(this.addNode(node));

		allString.push('</div>');

	}

	this.aIndent.pop();
	return allString.join('');
};



// Adds the empty and line icons

virtualtree.prototype.indent = function(node, nodeId) {

	var str = '';
	var allString = new Array();
	if (this.root.id != node.pid) {

		for (var n=0; n<this.aIndent.length; n++)
		{
			allString.push('<img src="' + ( (this.aIndent[n] == 1 && this.config.useLines) ? this.icon.line : this.icon.empty ) + '" alt="" />');
		}

		(node._ls) ? this.aIndent.push(0) : this.aIndent.push(1);

		if (node._hc) {

			allString.push('<a href="javascript: ' + this.obj + '.o(' + nodeId + ');"><img id="j' + this.obj + nodeId + '" src="');

			if (!this.config.useLines) 
			{
				allString.push((node._io) ? this.icon.nlMinus : this.icon.nlPlus);
			}
			else 
			{
				allString.push(( (node._io) ? ((node._ls && this.config.useLines) ? this.icon.minusBottom : this.icon.minus) : ((node._ls && this.config.useLines) ? this.icon.plusBottom : this.icon.plus ) ));
			}

			allString.push('" alt="" /></a>');

		}
		else
		{
			allString.push('<img src="' + ( (this.config.useLines) ? ((node._ls) ? this.icon.joinBottom : this.icon.join ) : this.icon.empty) + '" alt="" />');
		}
	}
	return allString.join('');

};



// Checks if a node has any children and if it is the last sibling

virtualtree.prototype.setCS = function(node) {

	var lastId;
	var start=0;
	if(node.id>=0)
		start=node.id;
	for (var n=start; n<this.aNodes.length; n++) {

		if (this.aNodes[n].pid == node.id) node._hc = true;

		if (this.aNodes[n].pid == node.pid) lastId = this.aNodes[n].id;

	}

	if (lastId==node.id) node._ls = true;

};



// Returns the selected node
virtualtree.prototype.getSelected = function() {

	var sn = this.getCookie('cs' + this.obj);

	return (sn) ? sn : null;

};



// Highlights the selected node
virtualtree.prototype.s = function(id) {

	var eRoot = document.getElementById("s" + this.obj + 0);
	if(eRoot != null)eRoot.className = "node";

	if (!this.config.useSelection) return;

	var cn = this.aNodes[id];

	if (cn._hc && !this.config.folderLinks) return;

	if (this.selectedNode != id) {

		if (this.selectedNode || this.selectedNode==0) {

			eOld = document.getElementById("s" + this.obj + this.selectedNode);
			if(eOld != null)
				eOld.className = "node";

		}

		eNew = document.getElementById("s" + this.obj + id);
		if(eNew != null)
			eNew.className = "nodeSel";

		this.selectedNode = id;

		if (this.config.useCookies) this.setCookie('cs' + this.obj, cn.id);

	}

};



// Toggle Open or close
virtualtree.prototype.o = function(id) 
{
	var cn = this.aNodes[id];
	var treeIdValue=window.parent.document.getElementById("opentree"+id);
	if(treeIdValue!=null)
	{
		treeIdValue.value=""+(!cn._io);
	}
	if(cn.url!=null && cn.url!='')
	{
		var ind=cn.url.indexOf("'");
		var ind2=cn.url.indexOf(",");
		var sub=cn.url.substring(ind,ind2);
		sub=sub.substring(1);
		sub=sub.substring(0,sub.length-1);
		if(sub!=null && sub!='')
		{
			document.getElementById("openNode").value=sub;
		}
	}
	this.nodeStatus(!cn._io, id, cn._ls);
	cn._io = !cn._io;
	if (this.config.closeSameLevel) this.closeLevel(cn);
	if (this.config.useCookies) this.updateCookie();
	if(cn.isHost&&cn._io)
	{
		this.openAllChildren(cn);
	}
};

// Open or close all nodes

virtualtree.prototype.oAll = function(status) {

	for (var n=0; n<this.aNodes.length; n++) {

		if (this.aNodes[n]._hc && this.aNodes[n].pid != this.root.id) {

			this.nodeStatus(status, n, this.aNodes[n]._ls)

			this.aNodes[n]._io = status;

		}

	}

	if (this.config.useCookies) this.updateCookie();

};



// Opens the tree to a specific node

virtualtree.prototype.openTo = function(nId, bSelect, bFirst) {

	if (!bFirst) {

		for (var n=0; n<this.aNodes.length; n++) {

			if (this.aNodes[n].id == nId) {
				nId=n;

				break;

			}

		}

	}

	var cn=this.aNodes[nId];

	if (cn.pid==this.root.id || !cn._p) return;

	cn._io = true;

	cn._is = bSelect;

	if (this.completed && cn._hc) this.nodeStatus(true, cn._ai, cn._ls);

	if (this.completed && bSelect) this.s(cn._ai);

	else if (bSelect) this._sn=cn._ai;

	this.openTo(cn._p._ai, false, true);

};

// Opens the tree to a specific node Choose not selected (new added)

virtualtree.prototype.openToNodeChoose = function(nId, bSelect, bFirst) {

	if (!bFirst) {
		for (var n=0; n<this.aNodes.length; n++) {

			if (this.aNodes[n].id == nId) {
				nId=n;
				break;

			}

		}

	}

	var cn=this.aNodes[nId];
	
	if (cn.pid==this.root.id || !cn._p) return;

	cn._io = false;

	cn._is = bSelect;
	if (this.completed && cn._hc)
	{
		this.nodeStatus(true, cn._ai, cn._ls);
			this.aNodes[nId]._io = true;
	}

	this.openToNodeChoose(cn._p._ai, false, true);

};

//Opens all the childern for the tree to a specific node is a Host (newly added method) on 12-Sep-2008
virtualtree.prototype.openToNodeAllChildren = function(id)
{
	var cn = this.aNodes[id];
	if(cn.isHost&&cn._io)
	{
		this.openAllChildren(cn);
	}
}
// Closes all nodes on the same level as certain node

virtualtree.prototype.closeLevel = function(node) {

	for (var n=0; n<this.aNodes.length; n++) {

		if (this.aNodes[n].pid == node.pid && this.aNodes[n].id != node.id && this.aNodes[n]._hc) {

			this.nodeStatus(false, n, this.aNodes[n]._ls);

			this.aNodes[n]._io = false;

			this.closeAllChildren(this.aNodes[n]);

		}

	}

}

// open all children of a node
virtualtree.prototype.openAllChildren = function(node) 
{
	for (var n=0; n<this.aNodes.length; n++) 
	{
		if (this.aNodes[n].pid == node.id && this.aNodes[n]._hc) 
		{
			if (!this.aNodes[n]._io) 
			{
				this.nodeStatus(true, n, this.aNodes[n]._ls);
			}
			this.aNodes[n]._io = true;
			this.openAllChildren(this.aNodes[n]);	
		}
	}
}




// Closes all children of a node
virtualtree.prototype.closeAllChildren = function(node) {
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == node.id && this.aNodes[n]._hc) {
			if (this.aNodes[n]._io) this.nodeStatus(false, n, this.aNodes[n]._ls);
			this.aNodes[n]._io = false;
			this.closeAllChildren(this.aNodes[n]);		
		}
	}
}

// Change the status of a node(open or closed)
virtualtree.prototype.nodeStatus = function(status, id, bottom) {
	eDiv	= document.getElementById('d' + this.obj + id);
	eJoin	= document.getElementById('j' + this.obj + id);
	if (this.config.useIcons) {
		eIcon	= document.getElementById('i' + this.obj + id);
		eIcon.src = (status) ? this.aNodes[id].iconOpen : this.aNodes[id].icon;
	}
	eJoin.src = (this.config.useLines)?
	((status)?((bottom)?this.icon.minusBottom:this.icon.minus):((bottom)?this.icon.plusBottom:this.icon.plus)):
	((status)?this.icon.nlMinus:this.icon.nlPlus);
	eDiv.style.display = (status) ? 'block': 'none';
};

// [Cookie] Clears a cookie
virtualtree.prototype.clearCookie = function() {
	var now = new Date();
	var yesterday = new Date(now.getTime() - 1000 * 60 * 60 * 24);
	this.setCookie('co'+this.obj, 'cookieValue', yesterday);
	this.setCookie('cs'+this.obj, 'cookieValue', yesterday);
};

// [Cookie] Sets value in a cookie
virtualtree.prototype.setCookie = function(cookieName, cookieValue, expires, path, domain, secure) {
	document.cookie =
		escape(cookieName) + '=' + escape(cookieValue)
		+ (expires ? '; expires=' + expires.toGMTString() : '')
		+ (path ? '; path=' + path : '')
		+ (domain ? '; domain=' + domain : '')
		+ (secure ? '; secure' : '');
};

// [Cookie] Gets a value from a cookie
virtualtree.prototype.getCookie = function(cookieName) {
	var cookieValue = '';
	var posName = document.cookie.indexOf(escape(cookieName) + '=');
	if (posName != -1) {
		var posValue = posName + (escape(cookieName) + '=').length;
		var endPos = document.cookie.indexOf(';', posValue);
		if (endPos != -1) cookieValue = unescape(document.cookie.substring(posValue, endPos));
		else cookieValue = unescape(document.cookie.substring(posValue));
	}
	return (cookieValue);
};

// [Cookie] Returns ids of open nodes as a string
virtualtree.prototype.updateCookie = function() {
	var str = '';
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n]._io && this.aNodes[n].pid != this.root.id) {
			if (str) str += '.';
			str += this.aNodes[n].id;
		}
	}
	this.setCookie('co' + this.obj, str);
};


// [Cookie] Checks if a node id is in a cookie
virtualtree.prototype.isOpen = function(id) {
	var aOpen = this.getCookie('co' + this.obj).split('.');
	for (var n=0; n<aOpen.length; n++)
		if (aOpen[n] == id) return true;
	return false;
};

// If Push and pop is not implemented by the browser
if (!Array.prototype.push) {
	Array.prototype.push = function array_push() {
		for(var i=0;i<arguments.length;i++)
			this[this.length]=arguments[i];
		return this.length;
	}
};

if (!Array.prototype.pop) {
	Array.prototype.pop = function array_pop() {
		lastElement = this[this.length-1];
		this.length = Math.max(this.length-1,0);
		return lastElement;
	}
};

virtualtree.prototype.selectRoot = function() {
	var eId  = document.getElementById("s" + this.obj + 0);
	if(eId != null)eId.className = "nodeSel";
};

virtualtree.prototype.openTreeOnRefresh=function()
{
	var treeRefreshDiv=window.parent.document.getElementById("treeRefreshDiv");

	for (var n=0;n<this.aNodes.length ;n++ )
	{
		try
		{
			var treeIdValue=window.parent.document.getElementById("opentree"+n);
			if(treeIdValue!=null)
			{
				if(treeIdValue.value=="true")
				{
					node=this.aNodes[n];
					if(node.isHost )
					{
						this.nodeStatus(true, n, node._ls);
						node._io = true;
						this.openAllChildren(node);
					}
					else
					{
						this.nodeStatus(true, n, node._ls);
						node._io = true;
					}
				}
			}
		}
		catch(Exception)
		{}
	}
}


virtualtree.prototype.initTree=function()
{
	var treeRefreshDiv=window.parent.document.getElementById("treeRefreshDiv");
	var str='';
	for (var n=1;n<this.aNodes.length;n++ )
	{
		var node=this.aNodes[n];
		str+='<input type="hidden" id="opentree'+n+'" value="false"/>';
	}
	if(treeRefreshDiv!=null && treeRefreshDiv!='undefined')
	{
		if(treeRefreshDiv.innerHTML=="" || treeRefreshDiv.innerHTML==" " || treeRefreshDiv.innerHTML=="&nbsp;")
		{
			treeRefreshDiv.innerHTML=str;
		}
	}
}