var rootComponentArray = null;
var compLength = '';
var splitLen = 50;
var startcount = '';
Ext.define('zones.controller.Main', {
    extend: 'Ext.app.Controller',
    views:['zones.view.Main','zones.view.ZonesDashboard','zones.view.ListPanel','zones.view.ZoneUsers','zones.view.ListComponent'],
    stores:['zones.store.ZoneUsers'],
    refs:[{
    	ref:'main',
		selector:'main'
    },{
    	ref:'problemAnalysis',
		selector:'problemanalysis'
    },{
    	ref:'infrastructureHealthView',
		selector:'infrastructurehealthview'
    },{
    	ref:'listPanel',
		selector:'listpanel'
	},{
    	ref:'listPanelToolbar',
		selector:'listpanel>toolbar'
    },{
    	ref:'optionalListPanel',
		selector:'optionallistpanel'
    },{
    	ref:'optionalListPanelToolbar',
		selector:'optionallistpanel>toolbar'
    },{
    	ref:'zonesDashboard',
		selector:'zonesdashboard'
    },{
    	ref:'zoneTreePanel',
    	selector:'zonestreepanel'
    },{
    	ref:'zoneTree',
    	selector:'zonestreepanel > panel'
    },{
    	ref:'measures',
    	selector:'measures'
    },{
    	ref:'measureAndAnalysis',
    	selector:'measureandanalysis'
    },{
    	ref:'listComponent',
    	selector:'listcomponent'
    },{
    	ref:'optionalListComponent',
    	selector:'optionallistcomponent'
    },{
    	ref:'zoneUsers',
    	selector:'zoneusers'
    },{
    	ref:'listPanelTrigger',
    	selector:'listpanel trigger'
    },{
    	ref:'optionalListPanelTrigger',
    	selector:'optionallistpanel trigger'
    },{
    	ref:'configWindow',
    	selector:'configwindow'

    },{
    	ref:'componentsPanelCombo',
		selector:'dashboardgeneralmeasuresgridpanel[itemId="components"] combo'
    },{
    	ref:'aggregatesPanelCombo',
		//selector:'dashboardgeneralmeasuresgridpanel[itemId="aggregates"] combo'
		selector:'dashboardgeneralmeasuresaggregatepanel[itemId="aggregates"] combo'
    },{
    	ref:'healthViewData',
    	selector:'infrastructurehealthviewdata'
    }],

    init: function() {
	setInterval("execute()",refreshFrequency);
	   this.control({
       		'listpanel trigger' : {
       			specialkey: this.zonesSearchKeyPress,
       			click:this.zonesSearch
       		},
       		'listpanel button[action=association]' : {
       			click: this.displayListPanelAssociations
       		},
       		'optionallistpanel trigger' : {
       			specialkey: this.zonesSearchKeyPress,
       			click:this.zonesSearch
       		},
       		'optionallistpanel button[action=association]' : {
       			click: this.displayOptionalListAssociations
       		},
       		'measuresgrid': {
		   		render: this.onMeasuresRender
       		},
       		'problemanalysiscomponents':{
       			render:this.problemAnalysisComponentsRender
       		},
       		'listcomponent button[action=zonedetail]':{
       			click: this.displayZoneDetails
       		},
       		'optionallistcomponent button[action=zonedetail]':{
       			click: this.displayZoneDetails
       		},
       		'listpanel button[action=back]':{
       			click:this.backButtonHandler
       		},
       		'optionallistpanel button[action=back]':{
       			click:this.backButtonHandler
       		},
       		'zonestreepanel':{
       			beforerender:function(){
       				if(requestParams.refresh!==true){
       					Ext.state.Manager.clear('zones-tree-panel-stateId');
       				}
       			},
				expand:function(){
       				window.parent.zonetreeOpenval=true;
       			},
				collapse:function(){
					window.parent.zonetreeOpenval=false;
				}
       		},
			'zonestreepanel > panel':{
				afterrender:this.treeLoad,
				itemclick:this.treeItemClick
			},
       		'measureandanalysis':{
       			beforerender:function(){
       				if(requestParams.refresh===true){
       					this.getMeasureAndAnalysis().setActiveTab(requestParams.insideTab);
       				}
       			}
       		},
       		'configwindow':{
				'render': this.itemset
			},
			'infrastructurehealthview trigger':
			{
				specialkey: this.searchKeyPress,
				click : this.searchData
			}
	   });
	},

	searchKeyPress:function(field,e){
		if (e.getKey() == e.ENTER) {
			if(!Ext.isEmpty(sortKey) && sortKey != null && sortKey != undefined){
				sortKey = "";
				sortState = "";
			}
			this.searchData(field);
		}
	},

	searchData:function(field){
		if(field == null || field == undefined || field.value == null || field.value == undefined)
			return;

		var searchText = field.value;
		if(!Ext.isEmpty(searchText) && searchText != null && searchText != undefined)
		{
			if(searchText == '(' || searchText == ')' || searchText == '\\' || searchText == '?' || searchText == '[')
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: 'Please enter the valid search pattern',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
			else
			{
				var jsondata = this.getController('ZonesDashboard').jsonData;
				var selectedInfraStructure = "";

				if(!Ext.isEmpty(zonelasInfrastructureMenuSelection) && zonelasInfrastructureMenuSelection != null && zonelasInfrastructureMenuSelection != undefined)
					selectedInfraStructure = zonelasInfrastructureMenuSelection;
				else
					selectedInfraStructure = jsondata['selectedInfraStructure'];

				if(!Ext.isEmpty(selectedInfraStructure))
				{
					var healthViewData = null;
					if(selectedInfraStructure == 'components')
					{
						healthViewData = jsondata.healthView.components;
					}
					else if(selectedInfraStructure == 'aggregates')
					{
						healthViewData = jsondata.healthView.aggregates;
					}
					else if(selectedInfraStructure == 'segments')
					{
						healthViewData = jsondata.healthView.segments;
					}
					else if(selectedInfraStructure == 'serviceGroups')
					{
						healthViewData = jsondata.healthView.serviceGroups;
					}
					else if(selectedInfraStructure == 'services')
					{
						healthViewData = jsondata.healthView.services;
					}
					else if(selectedInfraStructure == 'zones')
					{
						healthViewData = jsondata.healthView.zones;
					}

					if(!Ext.isEmpty(healthViewData) && healthViewData != null && healthViewData != undefined){
						var finalHealthViewData = new Array();
						var value = null;
						for(var k=0;k<healthViewData.length;k++)
						{
							if(selectedInfraStructure == 'components' || selectedInfraStructure == 'aggregates')
								value = healthViewData[k].compType;
							else
								value = healthViewData[k].displayName;

							value = value.toLowerCase();
							if((value == searchText.toLowerCase()) || (value.indexOf(searchText.toLowerCase()) >= 0))
							{
								finalHealthViewData.push(healthViewData[k]);
								
							}
						}
						if(!Ext.isEmpty(finalHealthViewData) && finalHealthViewData != null)
							this.getHealthViewData().createMenuItems(selectedInfraStructure,finalHealthViewData,jsondata.screenLabels);
						else{
							Ext.MessageBox.show({
								title: 'Alert',
								msg: 'No '+selectedInfraStructure+' Found for the search text - '+searchText,
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
							field.setValue('');
						}
					}
				}
			}
		}
		else
		{
			var jsondata = this.getController('ZonesDashboard').jsonData;
			var selectedInfraStructure = "";

			if(!Ext.isEmpty(zonelasInfrastructureMenuSelection) && zonelasInfrastructureMenuSelection != null && zonelasInfrastructureMenuSelection != undefined)
				selectedInfraStructure = zonelasInfrastructureMenuSelection;
			else
				selectedInfraStructure = jsondata['selectedInfraStructure'];
			if(!Ext.isEmpty(selectedInfraStructure))
			{
				var healthViewData = null;
				if(selectedInfraStructure == 'components')
				{
					healthViewData = jsondata.healthView.components;
				}
				else if(selectedInfraStructure == 'aggregates')
				{
					healthViewData = jsondata.healthView.aggregates;
				}
				else if(selectedInfraStructure == 'segments')
				{
					healthViewData = jsondata.healthView.segments;
				}
				else if(selectedInfraStructure == 'serviceGroups')
				{
					healthViewData = jsondata.healthView.serviceGroups;
				}
				else if(selectedInfraStructure == 'services')
				{
					healthViewData = jsondata.healthView.services;
				}
				else if(selectedInfraStructure == 'zones')
				{
					healthViewData = jsondata.healthView.zones;
				}

				if(!Ext.isEmpty(healthViewData) && healthViewData != null && healthViewData != undefined){
					this.getHealthViewData().createMenuItems(selectedInfraStructure,healthViewData,jsondata.screenLabels);
				}
			}
		}

	},

	zonesSearchKeyPress:function(field, e){
		if (e.getKey() == e.ENTER) {
			zoneSearchText = field.getValue();
			var searchUrl = '/final/servlet/com.eg.EgMonitorController?from=zoneList&monCmd=zoneList&action=search&treeFlag=false&Go.x=0&Go.y=0&searchString='+field.getValue()+'&treeOpen='+!this.getZoneTreePanel().getCollapsed();
			this.showResultData(searchUrl);
			//window.location = '/final/servlet/com.eg.EgMonitorController?from=zoneList&monCmd=zoneList&action=search&treeFlag=false&Go.x=0&Go.y=0&searchString='+field.getValue()+'&treeOpen='+!this.getZoneTreePanel().getCollapsed();
		}
	},

	zonesSearch:function(field){
		zoneSearchText = field.getValue();
		var searchUrl = '/final/servlet/com.eg.EgMonitorController?from=zoneList&monCmd=zoneList&action=search&treeFlag=false&Go.x=0&Go.y=0&searchString='+field.getValue()+'&treeOpen='+!this.getZoneTreePanel().getCollapsed();
		this.showResultData(searchUrl);
		//window.location = '/final/servlet/com.eg.EgMonitorController?from=zoneList&monCmd=zoneList&action=search&treeFlag=false&Go.x=0&Go.y=0&searchString='+field.getValue()+'&treeOpen='+!this.getZoneTreePanel().getCollapsed();
	},

	treeItemClick:function(view, record, item, index, event)
	{
		if(!Ext.isEmpty(record.raw.link))
		{
			var zonelink = record.raw.link;
			if(!Ext.isEmpty(zonelink) && zonelink.indexOf('monCmd=zoneList')>-1)
			{
				this.showResultData(zonelink);
			}
			else
			{
				if(zonelink.indexOf('outsideZone=true')>-1)
				{
					this.getZoneTreePanel().currentNode = record.data.text;
					this.getZoneTree().expandNode(record);
					this.displayZoneDetails(view,record);
				}
				else
				{
					document.location = zonelink;
				}
			}
			//document.location = record.raw.link;

		}
		else
		{
			this.getZoneTreePanel().currentNode = record.data.text;
			this.getZoneTree().expandNode(record);
			this.displayZoneDetails(view,record);
		}
	},

	treeLoad:function(treePanel){
		var selectedTreeNode = this.getZoneTreePanel().currentNode;
		if(!Ext.isEmpty(requestParams) && requestParams.refresh == 'true'){
			selectedTreeNode = requestParams.selectedTreeNode;
			this.getZoneTreePanel().currentNode = requestParams.selectedTreeNode;
		}
		if(!Ext.isEmpty(selectedTreeNode))
		{
			var myNode;
			var myRoot = treePanel.getRootNode();
			if(myRoot.raw.text===selectedTreeNode)
			{
				myNode=myRoot;
				treePanel.getSelectionModel().select(myNode);
			}
			else
			{
				myNode=myRoot.findChild('text',selectedTreeNode);
				if(!Ext.isEmpty(myNode) && myNode != null && myNode != undefined)
					treePanel.getSelectionModel().select(myNode);
			}

			if(!Ext.isEmpty(myNode) && myNode != null && myNode != undefined){
				var selectedNodeDepth=myNode.getDepth();
				var selected=myNode;
				for(var i=0; i < selectedNodeDepth; i++){
					if(selected.isLeaf()){
						selected.parentNode.expand();
					}
					else{
						selected.expand();
					}
					selected=selected.parentNode;
				}
			}
		}

		if(!Ext.isEmpty(openNodes)&& openNodes != null && openNodes != undefined){
			var myNode;
			var myRoot = treePanel.getRootNode();
			for(i=0;i<openNodes.length;i++){
				var nodeName = openNodes[i];
				if(!Ext.isEmpty(nodeName) && nodeName != null && nodeName != undefined){
					if(myRoot.raw.text===nodeName)
						myNode=myRoot;
					else
						myNode=myRoot.findChild('text',nodeName);

					if(!Ext.isEmpty(myNode) && myNode != null && myNode != undefined){
						myNode.expand();
					}
				}
			}
		}
	},

	itemset:function(window,e){
		this.getConfigWindow().controllername=this.self.getName();
	},
	backButtonHandler:function(btn){
		var treeSession=requestParams.treeSession;
		var backButtonFunction="";
		treeSession=(!Ext.isEmpty(treeSession))? treeSession:"";
		 if(fromPage!=null && fromPage.toLowerCase()=='mydashboard')
		{
			document.location=myDashboardBackUrl;
		}
		else
		{
			if(treeSession.indexOf("showDashboard")>0 )
			{
				backButtonFunction=treeSession;
			}
			if(this.getZoneUsers()){
				window.history.go(0);
				return;
			}
			if(backButtonFunction.length>0)
			{
				document.location=backButtonFunction;
			}
			else
			{
				if(!Ext.isEmpty(requestParams.refresh) && requestParams.refresh=="true")
				{
					window.history.go(-2);
				}
				else
				{
					window.history.go(-1);
				}
			}
		}
	},

	displayListPanelAssociations : function(){
		this.getListPanel().removeAll();
        Ext.Ajax.request({
				url : "/final/servlet/com.eg.EgMonitorController?monCmd=userZones&selectNode=zone&selectedParam=zone&openNode=null&treeFlag=false&currentTab=association&setAssociate=&frompage=egTreeUserServices",
				scope : this,
				timeout:1280000,
				success : function(response) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
				//	jsonData.error = 'Nothing to display';
					//testing of error message to be done.

					Ext.getCmp('zonelistpanelsearch').hide();
					if(Ext.getCmp('assSeparatorId')!=null){
						Ext.getCmp('assSeparatorId').hide();
					}
					if(Ext.getCmp('zoneAssociationId')!=null){
						Ext.getCmp('zoneAssociationId').hide();
					}
					Ext.getCmp('zonelistpanelbackbtn').show();

					if(!Ext.isEmpty(jsonData.error)){

						tempContPanel.add({
		        			xtype:'errorpanel',
							cls:'error-panel',
							margin:'10',
							flex:1,
							frame:true,
							imageCls:'iconInformation',
							padding:'0',
							bodyStyle:{'margin-top':'15%'},
							style:{'text-align':'center'},
		        			errorMsg : jsonData.error

		        	   })
					}
					else{
						this.getListPanel().setTitle(zoneAssociationsTxt);
						if(!Ext.isEmpty(this.getListPanelToolbar())){
							this.getListPanelToolbar().hide();
						}

						this.getListPanel().add({
		                	xtype : 'zoneusers' ,
		                	screenLabels : jsonData.screenLabels,
		                	data : jsonData
		                  });
				//		this.getListPanel().child('zoneusers').getStore().loadRawData(jsonData);

					}
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
    },

	displayOptionalListAssociations : function(){
		this.getOptionalListPanel().removeAll();
        Ext.Ajax.request({
				url : "/final/servlet/com.eg.EgMonitorController?monCmd=userZones&selectNode=zone&selectedParam=zone&openNode=null&treeFlag=false&currentTab=association&setAssociate=&frompage=egTreeUserServices",
				scope : this,
				timeout:1280000,
				success : function(response) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
				//	jsonData.error = 'Nothing to display';
					//testing of error message to be done.

					Ext.getCmp('zonelistpanelsearch').hide();
					if(Ext.getCmp('assSeparatorId')!=null){
						Ext.getCmp('assSeparatorId').hide();
					}
					if(Ext.getCmp('zoneAssociationId')!=null){
						Ext.getCmp('zoneAssociationId').hide();
					}
					Ext.getCmp('zonelistpanelbackbtn').show();

					if(!Ext.isEmpty(jsonData.error)){
						tempContPanel.add({
		        			xtype:'errorpanel',
							cls:'error-panel',
							margin:'10',
							flex:1,
							frame:true,
							imageCls:'iconInformation',
							padding:'0',
							bodyStyle:{'margin-top':'15%'},
							style:{'text-align':'center'},
		        			errorMsg : jsonData.error
		        	   })
					}
					else{
						this.getOptionalListPanel().setTitle(zoneAssociationsTxt);
						//this.getOptionalListPanelToolbar().hide();
						this.getOptionalListPanel().add({
		                	xtype : 'zoneusers' ,
		                	screenLabels : jsonData.screenLabels,
		                	data : jsonData
		                  });
						//this.getOptionalListPanel().child('zoneusers').getStore().loadRawData(jsonData);
					}
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
    },

	displayZoneDetails:function(btn,record){
		var zoneName = null;
		var currentTab = null;
		var aggregateTab = false;
		var state = '';

		var listPanel = this.getCurrentListPanel();

		if(Ext.isEmpty(btn) || btn.getXType() == 'treeview'){
			zoneName = record.raw.text;
			currentTab = 'system';
			aggregateTab = record.raw.aggregateTab;
			state = record.raw.iconCls;
			state = state.substring(state.indexOf('_')+1);
		}
		else if(btn.getXType() == 'button'){
			zoneName = btn.name;
			currentTab = 'details';
			aggregateTab = btn.aggregateTab;
			state = btn.state;
		}

		var treePanel = this.getZoneTreePanel();
		var treeOpen = !treePanel.getCollapsed();

		var url = "&treeOpen="+treeOpen;
		if(!Ext.isEmpty(treePanel.currentNode))
			url += '&openNode=' + treePanel.currentNode;

		if(!Ext.isEmpty(listPanel)){
			listPanel.removeAll();
			var docked = listPanel.getDockedItems();
			if(!Ext.isEmpty(docked)){
				for(i = 0; i < docked.length; i++){
					docked[i].hide();
				}
			}

			listPanel.hide();
			if(!Ext.isEmpty(listPanel.up('main').down('zonesdashboard[id=zoneDashboardId]')))
				listPanel.up('main').down('zonesdashboard[id=zoneDashboardId]').destroy();

			listPanel.up('main').add({
				xtype:'zonesdashboard',
				aggregateTab:aggregateTab,
				currentTab:currentTab,
				currentZone:zoneName,
				zoneState:state,
				treeUrl:url,
				region:'center',
				flex:4
			});
		}
	},

	displayZoneDetailsFromAssociation:function(rec){
		var treePanel=this.getZoneTreePanel();
		var treeOpen=!treePanel.getCollapsed();
		var url=rec.get('link')+"&treeOpen="+treeOpen;
		return url;
	},

	problemAnalysisComponentsRender:function(cmp){
		cmp.on('hourComboChange',this.problemAnalysisHourChange,this);
	},

	problemAnalysisHourChange:function(obj){
		var duration=obj.newValue;
		if(!Ext.isEmpty(this.getProblemAnalysis())){
			this.getProblemAnalysis().refreshData(false,duration);
		}
	},

	onMeasuresRender:function(grid){
		grid.getStore().on('load',this.measuresStoreLoadHandler,this);
	},

	measuresStoreLoadHandler:function(store,records){
		var tabpanel=this.getMeasureAndAnalysis();
		if(store.getCount()==0){
			var comp=tabpanel.items.getAt(0);
			if(comp.xtype!='errorpanel'){
				var measuresGrid=this.getMeasures();
				var title=measuresGrid.screenLabels["zones.zonehome.Measure At-A-Glance"];
				var errorMessage=measuresGrid.screenLabels["zones.segments.noDataMsg"]?measuresGrid.screenLabels["zones.segments.noDataMsg"]:"No measures for the configured Metrics";
				tabpanel.child('#measures').tab.hide();
				tabpanel.insert(0,{
					xtype:'errorpanel',
					cls:'error-panel',
					margin:'10',
					flex:1,
					frame:true,
					imageCls:'iconInformation',
					padding:'0',
					bodyStyle:{'margin-top':'15%'},
					style:{'text-align':'center'},
					title:title,
					errorMsg:errorMessage
				});
				tabpanel.setActiveTab(0);
			}
		}else{
			var comp=tabpanel.items.getAt(0);
			if(comp.xtype=='errorpanel'){
				tabpanel.remove(comp);
				tabpanel.child('#measures').tab.show();
				tabpanel.setActiveTab(0);
			}

		}
	},

	refresh:function(refreshURL)
	{
		if(Ext.isEmpty(this.getConfigWindow()))
		{
			var listPanel = this.getCurrentListPanel();
			var zonesDashboard = this.getZonesDashboard();
			var treePanel = this.getZoneTreePanel();
			var treeCollapsed = !treePanel.getCollapsed();
			var trigger = null;
			var aggregateTab = null;

			if(!Ext.isEmpty(zonesDashboard))
			{
				aggregateTab = zonesDashboard.aggregateTab;
				var activeTab = zonesDashboard.getActiveTab();
				var currentTab = 0;
				var tab = null;
				var comboVal = '', aggregateComp = '';
				var insidetab = '';
				switch(activeTab.itemId)
				{
					case "system":  currentTab = 0;
									tab = 'system';
									break;
					case "components":currentTab = 1;
									tab = 'components';
									comboVal = this.getComponentsPanelCombo().value;
									break;
					case "aggregates":currentTab = 2;
									tab = 'aggregates';
									//aggregateComp = this.getAggregatesPanelCombo().value;
									break;
					case "details":currentTab = 3;
									tab = 'details';
									insidetab = this.getMeasureAndAnalysis().getActiveTab().getItemId();
									break;
				}

				var myParam;
				if(!Ext.isEmpty(this.getZoneTreePanel().currentNode))
				{
					myParam = this.getZoneTreePanel().currentNode;
				}
				else
				{
					myParam='';
				}


				compSelectedValue=comboVal;
				var currentObject=this;
				var url='/final/servlet/com.eg.EgMonitorController?from=MainDashboard&monCmd=zoneList&action=zone';

				Ext.Ajax.request({
					url:url,
					timeout:1280000,
					success:function(response)
					{
						var jsonData= response.responseText;
						var zoneName = "";
						if(!Ext.isEmpty(zonesDashboard) && !Ext.isEmpty(zonesDashboard.currentZone))
							zoneName = zonesDashboard.currentZone;
						var currentTab = tab;
						var aggregateTab = aggregateTab;
						var state = '';
						var listPanel = currentObject.getCurrentListPanel();

						var treePanel = currentObject.getZoneTreePanel();
						var treeOpen = !treePanel.getCollapsed();

						var url = "&treeOpen="+treeOpen;
						if(!Ext.isEmpty(treePanel.currentNode))
							url += '&openNode=' + treePanel.currentNode;

						if(!Ext.isEmpty(listPanel))
						{
							listPanel.removeAll();
							var docked = listPanel.getDockedItems();
							if(!Ext.isEmpty(docked))
							{
								for(i = 0; i < docked.length; i++){
									docked[i].hide();
								}
							}

							if(!Ext.isEmpty(currentTab) && currentTab=='details')
							{
								var detailsvalue = Ext.getCmp('zonesdetails');
								if(!Ext.isEmpty(detailsvalue))
								{
									urlForRefresh = urlForRefresh1;
									if(!Ext.isEmpty(urlForRefresh) && urlForRefresh.indexOf('Refreshing=true') < 0)
										urlForRefresh = urlForRefresh+"&Refreshing=true";
									currentObject.refreshDetails(urlForRefresh);
								}
							}
							else
							{
								if(!Ext.isEmpty(urlForRefresh) && urlForRefresh.indexOf('Refreshing=true') < 0)
									urlForRefresh = urlForRefresh+"&Refreshing=true";

								if(!Ext.isEmpty(currentTab) && currentTab=='aggregates')
								{
									listPanel.up('main').down('zonesdashboard[id=zoneDashboardId]').down('dashboardgeneralmeasuresaggregatepanel[itemId='+currentTab+']').loadTab(urlForRefresh,'zonesAgg');
								}
								else if(!Ext.isEmpty(currentTab) && currentTab=='system')
								{
									listPanel.up('main').down('zonesdashboard[id=zoneDashboardId]').down('dashboardgeneralmeasuresgridpanel[itemId='+currentTab+']').loadTab(urlForRefresh,'zonesSys',Reftot,RefpageVal,ReftotalPageno);
								}
								else if(!Ext.isEmpty(currentTab) && currentTab=='components')
								{
									listPanel.up('main').down('zonesdashboard[id=zoneDashboardId]').down('dashboardgeneralmeasuresgridpanel[itemId='+currentTab+']').loadTab(urlForRefresh,'zonesComp',Reftot,RefpageVal,ReftotalPageno);
								}
							}
							
							currentObject.refreshTree();						
						}
					},
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				});

			}
			else if(!Ext.isEmpty(listPanel))
			{
				if(listPanel.getXType() == 'listpanel')
					trigger = this.getListPanelTrigger();
				else
					trigger = this.getOptionalListPanelTrigger();

				this.refreshListPanel(refreshURL,listPanel,trigger);
			}

			listPanel = null;
			delete listPanel;

			zonesDashboard = null;
			delete zonesDashboard;

			treePanel = null;
			delete treePanel;

			treeCollapsed = null;
			delete treeCollapsed;

			trigger = null;
			delete trigger;

			aggregateTab = null;
			delete aggregateTabb;
		}
	},
	refreshDetails:function(url)
	{
		var jsonData;
		var me = this;
		if(autoRefreshURL!=null && autoRefreshURL!=undefined && autoRefreshURL!="")
		{
			url = autoRefreshURL;
		}

		if(!Ext.isEmpty(sortKey) && sortKey != null && sortKey != undefined && sortKey != "null")
			url += "&sortKey="+sortKey+"&sortState="+sortState;

		Ext.Ajax.request({
			url : url,
			timeout:1280000,
			success: function(response)
			{
				if(!Ext.isEmpty(me.getMeasures()))
				{
					me.getMeasures().refreshData(true);
				}
				if(!Ext.isEmpty(me.getProblemAnalysis()))
				{
					me.getProblemAnalysis().refreshData(true);
				}
				var searchField = Ext.getCmp('searchBox');
				if(!Ext.isEmpty(searchField.getValue())){
					me.searchData(searchField);
				}
				else
				{
					var infHealthController=me.getController('ZonesDashboard');
					infHealthController.infrastructureHealthViewRender(url);
				}

				if(!Ext.isEmpty(me.getMain().down('dashboardsummary')))
				{
					me.getMain().down('dashboardsummary').refreshData();
				}
				if(!Ext.isEmpty(me.getMain().down('dashboardsummarychart')))
				{
					me.getMain().down('dashboardsummarychart').refreshData();
				}
			},
			failure:function()
			{
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	load:function(ButtonUrl)
	{
		if(Ext.isEmpty(this.getConfigWindow()))
		{
			var listPanel = this.getCurrentListPanel();
			var zonesDashboard = this.getZonesDashboard();
			var treePanel = this.getZoneTreePanel();
			var treeCollapsed = !treePanel.getCollapsed();
			var trigger = null;
			var aggregateTab = null;
			if(!Ext.isEmpty(zonesDashboard))
			{
				aggregateTab = zonesDashboard.aggregateTab;
				var activeTab = zonesDashboard.getActiveTab();
				var currentTab = 0;
				var tab = null;
				var comboVal = '', aggregateComp = '';
				var insidetab = '';
				switch(activeTab.itemId)
				{
					case "system":  currentTab = 0;
									tab = 'system';
									break;
					case "components":currentTab = 1;
									tab = 'components';
									comboVal = this.getComponentsPanelCombo().value;
									break;
					case "aggregates":currentTab = 2;
									tab = 'aggregates';
									//aggregateComp = this.getAggregatesPanelCombo().value;
									break;
					case "details":currentTab = 3;
									tab = 'details';
									insidetab = this.getMeasureAndAnalysis().getActiveTab().getItemId();
									break;
				}
				var myParam;
				if(!Ext.isEmpty(this.getZoneTreePanel().currentNode))
				{
					myParam = this.getZoneTreePanel().currentNode;
				}
				else
				{
					myParam='';
				}
				compSelectedValue=comboVal;
				var currentObject=this;
				var url='/final/servlet/com.eg.EgMonitorController?from=MainDashboard&monCmd=zoneList&action=zone';
				Ext.Ajax.request({
					url:url,
					timeout:1280000,
					success:function(response)
					{
						var jsonData= response.responseText;
						var zoneName = "";
						if(!Ext.isEmpty(zonesDashboard) && !Ext.isEmpty(zonesDashboard.currentZone))
							zoneName = zonesDashboard.currentZone;
						var currentTab = tab;
						var aggregateTab = aggregateTab;
						var state = '';
						var listPanel = currentObject.getCurrentListPanel();
						var treePanel = currentObject.getZoneTreePanel();
						var treeOpen = !treePanel.getCollapsed();
						var url = "&treeOpen="+treeOpen;
						if(!Ext.isEmpty(treePanel.currentNode))
							url += '&openNode=' + treePanel.currentNode;
						if(!Ext.isEmpty(listPanel))
						{
							listPanel.removeAll();
							var docked = listPanel.getDockedItems();
							if(!Ext.isEmpty(docked))
							{
								for(i = 0; i < docked.length; i++){
									docked[i].hide();
								}
							}
							if(!Ext.isEmpty(currentTab) && currentTab=='details')
							{
								var detailsvalue = Ext.getCmp('zonesdetails');
								if(!Ext.isEmpty(detailsvalue))
								{
									currentObject.loadDetails(ButtonUrl);
								}
							}
							else
							{
								if(!Ext.isEmpty(urlForRefresh) && urlForRefresh.indexOf('Refreshing=true') < 0)
									urlForRefresh = urlForRefresh+"&Refreshing=true";
								if(!Ext.isEmpty(currentTab) && currentTab=='aggregates')
								{
									listPanel.up('main').down('zonesdashboard[id=zoneDashboardId]').down('dashboardgeneralmeasuresaggregatepanel[itemId='+currentTab+']').loadTab(urlForRefresh,'zonesAgg');
								}
								else if(!Ext.isEmpty(currentTab) && currentTab=='system')
								{
									listPanel.up('main').down('zonesdashboard[id=zoneDashboardId]').down('dashboardgeneralmeasuresgridpanel[itemId='+currentTab+']').loadTab(urlForRefresh,'zonesSys');
								}
								else if(!Ext.isEmpty(currentTab) && currentTab=='components')
								{
									listPanel.up('main').down('zonesdashboard[id=zoneDashboardId]').down('dashboardgeneralmeasuresgridpanel[itemId='+currentTab+']').loadTab(urlForRefresh,'zonesComp');
								}
							}
							currentObject.refreshTree();
						}
					},
			failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				});
			}
			else if(!Ext.isEmpty(listPanel))
			{
				if(listPanel.getXType() == 'listpanel')
					trigger = this.getListPanelTrigger();
				else
					trigger = this.getOptionalListPanelTrigger();
				this.refreshListPanel(refreshURL,listPanel,trigger);
			}
			listPanel = null;
			delete listPanel;
			zonesDashboard = null;
			delete zonesDashboard;
			treePanel = null;
			delete treePanel;
			treeCollapsed = null;
			delete treeCollapsed;
			trigger = null;
			delete trigger;
			aggregateTab = null;
			delete aggregateTabb;
		}
	},
	loadDetails:function(ButtonUrl)
	{
		var jsonData;
		var me = this;
		var	url='/final/servlet/com.eg.EgMonitorController?from=MainDashboard&monCmd=zoneList&action=zone';
		Ext.Ajax.request({
			url : url,
			timeout:1280000,
			success: function(response)
			{
				var infHealthController=me.getController('ZonesDashboard');
				infHealthController.infrastructureHealthViewload(url);
			},
			failure:function()
			{
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	reload:function(loadURLVal)
	{
		if(Ext.isEmpty(this.getConfigWindow()))
		{
			var listPanel = this.getCurrentListPanel();
			var zonesDashboard = this.getZonesDashboard();
			var treePanel = this.getZoneTreePanel();
			var treeCollapsed = !treePanel.getCollapsed();
			var trigger = null;
			var aggregateTab = null;
			if(!Ext.isEmpty(zonesDashboard))
			{
				aggregateTab = zonesDashboard.aggregateTab;
				var activeTab = zonesDashboard.getActiveTab();
				var currentTab = 0;
				var tab = null;
				var comboVal = '', aggregateComp = '';
				var insidetab = '';
				switch(activeTab.itemId)
				{
					case "system":  currentTab = 0;
									tab = 'system';
									break;
					case "components":currentTab = 1;
									tab = 'components';
									comboVal = this.getComponentsPanelCombo().value;
									break;
					case "aggregates":currentTab = 2;
									tab = 'aggregates';
									//aggregateComp = this.getAggregatesPanelCombo().value;
									break;
					case "details":currentTab = 3;
									tab = 'details';
									insidetab = this.getMeasureAndAnalysis().getActiveTab().getItemId();
									break;
				}
				var myParam;
				if(!Ext.isEmpty(this.getZoneTreePanel().currentNode))
				{
					myParam = this.getZoneTreePanel().currentNode;
				}
				else
				{
					myParam='';
				}
				compSelectedValue=comboVal;
				var currentObject=this;
				var url='/final/servlet/com.eg.EgMonitorController?from=MainDashboard&monCmd=zoneList&action=zone';
				Ext.Ajax.request({
					url:url,
					timeout:1280000,
					success:function(response)
					{
						var jsonData= response.responseText;
						var zoneName = "";
						if(!Ext.isEmpty(zonesDashboard) && !Ext.isEmpty(zonesDashboard.currentZone))
							zoneName = zonesDashboard.currentZone;
						var currentTab = tab;
						var aggregateTab = aggregateTab;
						var state = '';
						var listPanel = currentObject.getCurrentListPanel();
						var treePanel = currentObject.getZoneTreePanel();
						var treeOpen = !treePanel.getCollapsed();
						var url = "&treeOpen="+treeOpen;
						if(!Ext.isEmpty(treePanel.currentNode))
							url += '&openNode=' + treePanel.currentNode;
						if(!Ext.isEmpty(listPanel))
						{
							listPanel.removeAll();
							var docked = listPanel.getDockedItems();
							if(!Ext.isEmpty(docked))
							{
								for(i = 0; i < docked.length; i++){
									docked[i].hide();
								}
							}
							if(!Ext.isEmpty(currentTab) && currentTab=='details')
							{
								var detailsvalue = Ext.getCmp('zonesdetails');
								if(!Ext.isEmpty(detailsvalue))
								{
									currentObject.reloadDetails(loadURLVal);
								}
							}
							else
							{
								if(!Ext.isEmpty(urlForRefresh) && urlForRefresh.indexOf('Refreshing=true') < 0)
									urlForRefresh = urlForRefresh+"&Refreshing=true";
								if(!Ext.isEmpty(currentTab) && currentTab=='aggregates')
								{
									listPanel.up('main').down('zonesdashboard[id=zoneDashboardId]').down('dashboardgeneralmeasuresaggregatepanel[itemId='+currentTab+']').loadTab(urlForRefresh);
								}
								else if(!Ext.isEmpty(currentTab) && currentTab=='system')
								{
									listPanel.up('main').down('zonesdashboard[id=zoneDashboardId]').down('dashboardgeneralmeasuresgridpanel[itemId='+currentTab+']').loadTab(urlForRefresh,'zonesSys',Reftot,RefpageVal,ReftotalPageno);
								}
								else if(!Ext.isEmpty(currentTab) && currentTab=='components')
								{
									listPanel.up('main').down('zonesdashboard[id=zoneDashboardId]').down('dashboardgeneralmeasuresgridpanel[itemId='+currentTab+']').loadTab(urlForRefresh,'zonesComp');
								}
							}
							currentObject.refreshTree();
						}
					},
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				});
			}
			else if(!Ext.isEmpty(listPanel))
			{
				if(listPanel.getXType() == 'listpanel')
					trigger = this.getListPanelTrigger();
				else
					trigger = this.getOptionalListPanelTrigger();
				this.refreshListPanel(refreshURL,listPanel,trigger);
			}
			listPanel = null;
			delete listPanel;
			zonesDashboard = null;
			delete zonesDashboard;
			treePanel = null;
			delete treePanel;
			treeCollapsed = null;
			delete treeCollapsed;
			trigger = null;
			delete trigger;
			aggregateTab = null;
			delete aggregateTabb;
		}
	},
	reloadDetails:function(loadURLVal)
	{
		var jsonData;
		var me = this;
		var url = loadURLVal;
		if(loadURLVal==null || loadURLVal==undefined || loadURLVal=="")
			url='/final/servlet/com.eg.EgMonitorController?from=MainDashboard&monCmd=zoneList&action=zone';
		Ext.Ajax.request({
			url : url,
			timeout:1280000,
			success: function(response)
			{
				var infHealthController=me.getController('ZonesDashboard');
				infHealthController.infrastructureHealthViewReload(url);
			},
			failure:function()
			{
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	refreshListPanel:function(refreshURL, zoneslistpanel, trigger){
		var treePanel=this.getZoneTreePanel();
		var treeCollapsed=!treePanel.getCollapsed();

		if(zoneslistpanel.child('zoneusers')){
			if(zoneslistpanel===this.getListPanel()){
				this.displayListPanelAssociations();
			}
			else if(zoneslistpanel===this.getOptionalListPanel()){
				this.displayOptionalListAssociations();
			}
			this.refreshTree();
		}
		else{
			var searchText=trigger.value;
			if(requestParams.action==="search"){
				document.location = '/final/servlet/com.eg.EgMonitorController?from=zoneList&monCmd=zoneList&action=search&treeFlag=false&Go.x=0&Go.y=0&searchString='+searchText+"&treeOpen="+treeCollapsed+"&refresh=true";
			}
			else{
				var url=refreshURL+"&searchString="+searchText+"&treeOpen="+treeCollapsed+"&refresh=true";
				this.showResultData(url);
				//document.location=url;

				url = null;
				delete url;
			}
		}

		treePanel = null;
		delete treePanel;

		treeCollapsed= null;
		delete treeCollapsed;

	},
	showResultData:function(url)
	{
		var choosePanel = this.getListPanel();
		if(Ext.isEmpty(choosePanel))
			choosePanel = this.getOptionalListPanel();
		var chooseXType = choosePanel;
		choosePanel = choosePanel.xtype;

		var zonesDashboard = this.getZonesDashboard();
		var listPanelContents = Ext.getCmp('listPanelContents');
		var zonestreepanel=Ext.getCmp('zonestreepanel');

		var listView = 'zones.view.ListComponent';
		if(!Ext.isEmpty(choosePanel) && choosePanel=='optionallistpanel')
		{
			listView = 'zones.view.OptionalListComponent';
			listPanelContents = Ext.getCmp('componentPanel');
		}
		var zoneDashboardId = Ext.getCmp('zoneDashboardId');
		if(!Ext.isEmpty(zoneDashboardId))
		{
			zoneDashboardId.destroy();
		}
		if(Ext.isEmpty(listPanelContents))
		{
			Ext.Ajax.request({
					//url:'/final/servlet/com.eg.EgMonitorController?from=MainDashboard&monCmd=zoneList&action=zone',
					url:url,
					timeout:1280000,
					success:function(response)
					{
						var zoneMain=Ext.getCmp('zoneMain');
						var listpanel = Ext.getCmp('listpanel');
						if(!Ext.isEmpty(listpanel))
							zoneMain.remove(listpanel);

						var optionallistpanel = Ext.getCmp('optionallistpanel');
						if(!Ext.isEmpty(optionallistpanel))
							zoneMain.remove(optionallistpanel);
						showDashboard = false;
						var contentPanel={
							xtype:'listpanel',
							id:'listpanel',
							region:'center',
							flex:4,
							url : '/final/monitor/zones.jsp'
						};
						zoneMain.add(contentPanel);
					},
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
			});

		}
		else
		{
			if(!Ext.isEmpty(url) && url.indexOf('searchString')<0)
			{
				Ext.getCmp('zonelistpanelsearch').setValue('');
			}
			else
			{
				var urlArray = url.split("&");
				var tempUrl="";
				for(var i=0;i<urlArray.length;i++)
				{
					var name = urlArray[i]+'&';
					if(!Ext.isEmpty(name) && name.indexOf('action')>-1)
					{
						var name1 = name.substring(0,name.indexOf("="));
						var value = name.substring(name.indexOf("=")+1,name.length);
						name = name1+"=search&";
					}
					tempUrl=tempUrl+name;
				}
				if(!Ext.isEmpty(tempUrl))
					url = tempUrl;
			}

			var me = this;
			Ext.Ajax.request({ //for getting session data from model
				url:url,
				timeout:1280000,
				success:function(response)
				{
					var jsonData = response.responseText;

					Ext.Ajax.request({
						url:'/final/monitor/zones.jsp',
						timeout:1280000,
						success:function(response)
						{
							var jsonDataResult = response.responseText;
							var jsonDataRes = Ext.decode(jsonDataResult);
							//var rootComponentArray = jsonDataRes["RootItem"];
							rootComponentArray = jsonDataRes["RootItem"];

							if(!Ext.isEmpty(rootComponentArray))
							{
								compLength = rootComponentArray.length;
								/*var resultItems=listPanelContents.items.items;

								for(var item=resultItems.length-1; item>-1 ; item--)
								{
									resultItems[item].destroy();
								}*/
								listPanelContents.removeAll();
								me.refreshTree();//refresh tree

								var getCurrentListPanel = me.getCurrentListPanel().getXType();
								var docked = null;
								if(getCurrentListPanel == 'listpanel')
								{
									docked = me.getListPanel().getDockedItems();
									if(!Ext.isEmpty(docked))
									{
										for(i = 0; i < docked.length; i++)
										{
											if(i==1)
												docked[i].show();
										}
									}
								}


								Ext.suspendLayouts();
								/*for(var componentCounter = 0 ; componentCounter < rootComponentArray.length ; componentCounter++)
								{
									var listComponent = Ext.create(listView,{
											rootComponent : rootComponentArray[componentCounter]
										});
									listPanelContents.add(listComponent);
									listComponent = null;
									Ext.destroy(listComponent);
								}*/
								if(compLength > splitLen)
								{
									for(var componentCounter = 0 ; componentCounter < splitLen ; componentCounter++){
										var listComponent = Ext.create(listView,{
											rootComponent : rootComponentArray[componentCounter]
										});
										listPanelContents.add(listComponent);
									}
									me.getMain().doLayout();
									isScroll = true;
								}
								else
								{
									for(var componentCounter = 0 ; componentCounter < rootComponentArray.length ; componentCounter++)
									{
										var listComponent = Ext.create(listView,{
												rootComponent : rootComponentArray[componentCounter]
											});
										listPanelContents.add(listComponent);
										me.getMain().doLayout();
										listComponent = null;
										delete listComponent;
									}
								}
								Ext.resumeLayouts(true);

								resultItems = null;
								delete resultItems;
							}
							else
							{
								var getCurrentListPanel = me.getCurrentListPanel().getXType();
							//	var getCurrentListPanelValue = null;
								var docked = null;
								if(!Ext.isEmpty(getCurrentListPanel))
								{
									if(getCurrentListPanel == 'listpanel')
									{
										docked = me.getListPanel().getDockedItems();
										if(!Ext.isEmpty(docked))
										{
											for(i = 0; i < docked.length; i++)
											{
											//console.log(docked[i]);
												if(i==1)
													docked[i].hide();
											}
										}
									}

									var resultItems=listPanelContents.items.items;
									for(var item=resultItems.length-1; item>-1 ; item--)
									{
										resultItems[item].destroy();
									}
									listPanelContents.removeAll();
									
								}
								var backCL = '';
								if(strSkin == "Dark")
									var backCL = '#252525';

								var temp_error  = Ext.create('utilities.ErrorPanel',{
									cls:'error-panel',
										margin:'20% 0 auto 0',
										//flex:1,
										layout:'fit',
										width:'100%',
										height:Ext.getBody().getViewSize().height-80,
										//flex:1,
										scroll:false,
										autoScroll:false,
										border:false,
										frame:false,
										imageCls:'iconInformation',
										padding:'0',
										bodyStyle:{'margin-top':'15%'},
										style:{'text-align':'center','background-color':backCL+'!important'},
										errorMsg : jsonDataRes.SearchNoListFoundText
								});
								listPanelContents.add(temp_error);
								/*listPanelContents.add({
									xtype:'errorpanel',
										cls:'error-panel',
										margin:'20% 0 auto 0',
										//flex:1,
										layout:'fit',
										width:'100%',
										height:Ext.getBody().getViewSize().height-80,
										//flex:1,
										scroll:false,
										autoScroll:false,
										border:false,
										frame:false,
										imageCls:'iconExclamation',
										padding:'0',
										bodyStyle:{'margin-top':'15%'},
										style:{'text-align':'center'},
										errorMsg : jsonDataRes.SearchNoListFoundText
								});	*/	

									
										
							//	listPanelContents.update('<center><div class="iconExclamation" style="margin:20% 0 auto 0"></div><div class="commonErrorMsgText">'+jsonDataRes.SearchNoListFoundText+'</div></center>'};
								
								getCurrentListPanel = null;
								delete getCurrentListPanel;

								docked = null;
								delete docked;
							}

							jsonDataResult = null;
							Ext.destroy(jsonDataResult);

							jsonDataRes = null;
							Ext.destroy(jsonDataRes);

							//rootComponentArray = null;
							//Ext.destroy(rootComponentArray);

						}
					});

					jsonData = null;
					Ext.destroy(jsonData);
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}

		choosePanel = null;
		delete choosePanel;

		chooseXType = null;
		delete chooseXType;

		zonesDashboard =null;
		delete zonesDashboard;

		zonestreepanel = null;
		delete zonestreepanel;

		zoneDashboardId = null;
		delete zoneDashboardId;

	},
	refreshTree:function()
	{
		var zonestreepanel=Ext.getCmp('zonestreepanel');
		Ext.Ajax.request({ //for refreshing tree
			url : "/final/monitor/zoneTree.jsp?tree=ZoneTreeModel&width=208&str=sessionID&node=Zone&treeTitle=Zones Navigation",
			method : 'POST',
			timeout:1280000,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				jsonData["expanded"] = true;
				jsonData["cls"] = "list-tree-root-expand-collapse";
				var treePanelStore = Ext.create('Ext.data.TreeStore', {
					id:'treestore',
					root : jsonData
				});
				var treePanel = Ext.create('utilities.TreeScrollPanel',{		//
					store : treePanelStore,
					cls:'treePanelDesign',
					margin:'8 0 0 8',
					border : true,
					frame:true,
					scroll:false,
					autoScroll:true,
					iconCls:'zone22_GRAY',
					//title : me.treePanelTitle,
					title:Zones,
					stateId:'zones-tree-panel-stateId',
					rootVisible : true,
					useArrows:true,
					id:'select',
					listeners:{
						beforeItemExpand:function(node){
							var nodeName = node.raw.text;
							if(openNodes != null && openNodes.indexOf(nodeName) == -1)
								openNodes.push(nodeName);
						},
						afterItemCollapse: function(node){
							var nodeName = node.raw.text;
							if(openNodes != null && openNodes.length > 0){
								var index = openNodes.indexOf(nodeName);
								openNodes.splice(index,1);
							}
						}
					}
				});
				var old_tree = Ext.getCmp('id');
				zonestreepanel.remove(old_tree,true);
				zonestreepanel.add(treePanel);

				treePanelStore = null;
				delete treePanelStore;

				jsonText = null;
				delete jsonText;

				jsonData = null;
				delete jsonData;

				treePanel = null;
				Ext.destroy(treePanel);

				old_tree = null;
				delete old_tree;

			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	getCurrentListPanel:function(){
		var listPanel = null;
		if(!Ext.isEmpty(this.getListPanel())){
			listPanel = this.getListPanel();
		}
		else if(!Ext.isEmpty(this.getOptionalListPanel())){
			listPanel = this.getOptionalListPanel();
		}
		return listPanel;
	},
	bulkDataLoad: function(startcnt,endcnt,listView)
	{
		var jsondata = rootComponentArray;
		isScroll = false;
		var me = '', listPanel = '';
		if(listView != null && listView != '' && listView == 'zones.view.ListComponent')
		{
			me = Ext.getCmp('listpanel');
			listPanel = Ext.getCmp('listPanelContents');
		}
		else
		{
			me = Ext.getCmp('optionallistpanel');
			listPanel = Ext.getCmp('componentPanel');
		}
		Ext.suspendLayouts();
		for(var t=startcnt;t<endcnt;t++){
			var listComponent = Ext.create(listView,{
						rootComponent : jsondata[t]
			});
			listPanel.add(listComponent);
		}
		me.add(listPanel);
		Ext.resumeLayouts(true);
		if(endcnt != compLength && endcnt < compLength)
		{
			isScroll = true;
			startcount = endcnt;
		}
		else 
		{
			rootComponentArray = null;
			delete rootComponentArray;
			compLength = null;
			startcount = null;
		}
	}
});