var container="";
var zonelasInfrastructureMenuSelection="";
Ext.define('zones.controller.ZonesDashboard', {
    extend: 'Ext.app.Controller',
    views:['zones.view.ZonesDashboard','zones.view.ConfigWindow','zones.view.ZonesDetails','zones.view.DashboardSummary','zones.view.InfrastructureHealthView'],
	stores:['SortRetain'],
    jsonData:null,

    refs:[{
    	ref:'systemPanel',
		selector:'dashboardgeneralmeasuresgridpanel[itemId="system"]'
    },{
    	ref:'componentsPanel',
		selector:'dashboardgeneralmeasuresgridpanel[itemId="components"]'
    },{
    	ref:'aggregatesPanel',
		selector:'dashboardgeneralmeasuresaggregatepanel[itemId="aggregates"]'
    },{
    	ref:'healthViewMenu',
		selector:'infrastructurehealthviewmenu'
    },{
    	ref:'zoneDashboard',
		selector:'zonesdashboard'
    },{
    	ref:'healthViewData',
    	selector:'infrastructurehealthviewdata'
    },{
    	ref:'infrastructureHealthView',
    	selector:'infrastructurehealthview'
   },{
    	ref:'dashboardMaintainanceButton',
    	selector:'zonesdashboard > tabbar > button[action="maintainance"]'
    },{
    	ref:'configWindowRadio',
    	selector:'configwindow > form > radio'
    },{
    	ref:'configWindow',
    	selector:'configwindow'
    },{
    	ref:'measuresAndAnalysis',
    	selector:'measureandanalysis'
    },{
    	ref:'configWindowForm',
    	selector:'configwindow > form'
    }],

    init: function() {
	   this.control({
		   'zonesdashboard': {
		   		tabchange: function(tabpanel){
					tabSettingRef=tabpanel;
					showDashboard = null;
					this.loadActiveTabData(tabpanel);
				},
		   		afterrender:function(tabpanel){ 
					var tmpCurrTab = '';
					if(!Ext.isEmpty(tabpanel) && tabpanel!=null && tabpanel!=undefined && (!Ext.isEmpty(tabpanel.getActiveTab()) && tabpanel.getActiveTab()!=null && tabpanel.getActiveTab()!=undefined) && (!Ext.isEmpty(tabpanel.getActiveTab().itemId) && tabpanel.getActiveTab().itemId!=undefined))
						tmpCurrTab = tabpanel.getActiveTab().itemId;
					else
						tmpCurrTab = 'details';
					tabpanel.setActiveTab(tmpCurrTab);
					this.zonesDashboardAfterRenderHandler(tabpanel);
				},
				beforetabchange: this.renewSortState							// Prem
       		},
			'measureandanalysis':{
				beforetabchange: this.renewSortState,							// Prem
				tabchange:function(tabpanel){
					tabpanel.currentTab = tabpanel.getActiveTab().itemId;
					if(!Ext.isEmpty(tabpanel.down('measuresgrid')) && !Ext.isEmpty(tabpanel.down('measuresgrid').getStore().sorters.items[0])){
						tabpanel.down('measuresgrid').getStore().sorters.items = [];
						tabpanel.down('measuresgrid').getStore().load();
					}
				}
			},
       		'dashboardgeneralmeasuresgridpanel[itemId="components"] > panel > toolbar > combobox':{
       			change:this.componentsComboChange
       		},
			'dashboardgeneralmeasuresgridpanel[itemId="components"] > toolbar > combobox':{
       			change:this.componentsComboChange
       		},
       		'dashboardgeneralmeasuresaggregatepanel[itemId="aggregates"] > panel > toolbar > combobox':{
       			change:this.aggregatesComboChange
       		},
			'dashboardgeneralmeasuresaggregatepanel[itemId="aggregates"] > toolbar > combobox':{
       			change:this.aggregatesComboChange
       		},
			'dashboardgeneralmeasuresgridpanel[itemId="system"] > panel > toolbar > combobox':{
       			change:this.systemsComboChange
       		},
			'dashboardgeneralmeasuresgridpanel[itemId="system"] > toolbar > combobox':{
       			change:this.systemsComboChange
       		},
			'dashboardgeneralmeasuresgrid':{									// Prem
				sortchange : this.getSortDetails,
				render : this.retainColumnSort
       		},
			'measuresgrid':{
				sortchange : this.getSortDetails,
				render : this.retainColumnSort
       		},																	// Prem
       		'zonesdashboard > tabbar > button[action="maintainance"]':{
       			click:this.windowgenerate
       		},
       		'infrastructurehealthview':{
				'afterrender':this.infrastructureHealthViewRender
			},
			'infrastructurehealthviewmenu > button':{
				//'click':this.healthViewMenuClick,
				'afterrender':function(button){
					var htmlContent = '<a href="javascript:void(0);" class="infra-health mouse"><span class="left">'
						 // +'<div id = "menuItem'+button.itemNumber+'" class="flashobj"></div>'
						  +'<div id = "menuItem'+button.itemNumber+'" ></div>'
						  +'</span>'
						  +'<span class="right menu-title">'+button.contentText+'<br/>'+button.contentTotal+'</span></a>';
					if(button.highChartData!=null && button.highChartData!=undefined && button.highChartData.DataSet!=null && button.highChartData.DataSet!=undefined)
					{
						button.update(htmlContent);

						var container = button;
						var jsonPieData=null;
						jsonPieData=button.highChartData;
						jsonPieData['customMsg'] = 'yes';
						jsonPieData['formatTip'] = 'yes';
						jsonPieData['rumPie'] = 'yes';
						jsonPieData['dataLabels'] = false;
						jsonPieData['fromPage'] ='ZonePage';
						var pieChart = {};
						if (!Ext.isEmpty(pieChart))
						{
							pieChart = jQuery.extend(true, {}, createPie(button.idString,80,90), pieChart);
							pieChart.setData(jsonPieData,'','','donut');
							button.chartObj=pieChart;
							pieChart.drawChart();
						}
						htmlContent = null ;
						delete htmlContent;
					}
					/*else // Fusion chart - support
					{
					FusionCharts.setCurrentRenderer('javascript');
					button.update(htmlContent);

					FusionCharts.debugMode.enable = true;
					FusionCharts.debugMode.outputTo(console.log);

					if(FusionCharts("infraItemId_"+button.itemNumber))
						FusionCharts("infraItemId_"+button.itemNumber).dispose();
					var healthChart = new FusionCharts('/final/FusionCharts/swf/Doughnut2D.swf','infraItemId_'+button.itemNumber, '90', '60', '0', '1');
					healthChart.setDataXML(button.xmlData);
					healthChart.setTransparent(true);
					healthChart.render(button.idString);
					}*/
				}
			},
			'configwindow':{
				'render': this.itemset,
				 'close':this.refreshcall
			},
			'configwindow > form > combo':{
				'select':this.combo
			},
			'configwindow > form > radiogroup':{
				'change':this.radio
			},
			'configwindow > toolbar > button[action="submit"]':{
				click:this.buttonclick
			},
			'zonesdashboard > tabbar > button[action="back"]':{
       			click:this.backButtonHandler
       		}
	   });
	},

	renewSortState:function(thisObj,opts){									// Prem
		this.getSortRetainStore().getProxy().clear();
	},																		// Prem

	retainColumnSort:function(thisObj,opts){								// Prem
		var store = this.getSortRetainStore();
		store.load();
		var panelId = null;
		if(!Ext.isEmpty(thisObj.up('dashboardgeneralmeasuresaggregatepanel')) && !Ext.isEmpty(thisObj.up('dashboardgeneralmeasuresaggregatepanel').itemId)){
			panelId = thisObj.up('dashboardgeneralmeasuresaggregatepanel').itemId;
		}
		else if(!Ext.isEmpty(thisObj.up('dashboardgeneralmeasuresgridpanel'))){
			panelId = thisObj.up('dashboardgeneralmeasuresgridpanel').itemId;
		}
		else{
			panelId = 'measures';
		}
		var record = store.findRecord('panelId',panelId);
		if(!Ext.isEmpty(record)){
			thisObj.store.sort(record.get('dataIndex'),record.get('direction'));
		}
	},																		// Prem

	getSortDetails:function(ct, column, direction, eOpts){					// Prem
		var objFlag = true;
		var panelId = null;
		if(!Ext.isEmpty(ct.up('dashboardgeneralmeasuresaggregatepanel')) && !Ext.isEmpty(ct.up('dashboardgeneralmeasuresaggregatepanel').itemId)){
			panelId = ct.up('dashboardgeneralmeasuresaggregatepanel').itemId;
		}
		else if(!Ext.isEmpty(ct.up('dashboardgeneralmeasuresgridpanel'))){
			panelId = ct.up('dashboardgeneralmeasuresgridpanel').itemId;
		}
		else{
			panelId = 'measures';
		}
		var object = {
			panelId:panelId,
			dataIndex:column.dataIndex,
			direction:direction
		}
		var store = this.getSortRetainStore();
		if(store.getCount() != 0){
			store.each(function(record){
				if(record.get('panelId') == object.panelId){
					record.set(object);
					objFlag = false;
					return false;
				}
			},this);
		}
		if(objFlag)
			store.add(object);
		store.sync();
		store.commitChanges();
	},																		// Prem

	refreshcall:function(configwindow,opts){
		/*var flag=this.getConfigWindow().refresher;
		var conname=this.getConfigWindow().controllername;
		var url='../servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone';
		var me=this;
		Ext.Function.defer(function(){
			if(flag)
				me.getController(conname).refresh(url);
		},100);*/

		this.getComponentsPanel().loadTab(null,'zonesComp',Reftot,RefpageVal,ReftotalPageno);		// Prem
		this.getSystemPanel().loadTab(null,'zonesSys',Reftot,RefpageVal,ReftotalPageno);			// Prem
	},
	backButtonHandler:function(btn){
		
		var fromPageView=requestParams.fromPageView;
		var values=(!Ext.isEmpty(requestParams.fromHomepage))? requestParams.fromHomepage:"";

		var treeSession=requestParams.treeSession;
		var backButtonFunction="";
		treeSession=(!Ext.isEmpty(treeSession))? treeSession:"";
		/*if(treeSession.indexOf("showDashboard")>0  || treeSession.indexOf("zoneDash")>0)
		{
			backButtonFunction=treeSession;
		}*/
		if(fromPage!=null && fromPage.toLowerCase()=='mydashboard')
		{
			document.location=myDashboardBackUrl;
		}
		else if(isfromZoneMenu && (requestParams.parentZone ==null || requestParams.parentZone == 'null' || requestParams.parentZone == undefined || requestParams.parentZone == 'undefined' || requestParams.parentZone ==''))
		{
			document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone&isFromMenu=true';
		}
		else if(isfromZoneMenu || (isfromZoneMenu && ((requestParams.parentZone !=null && requestParams.parentZone != 'null' && requestParams.parentZone != undefined && requestParams.parentZone != 'undefined' && requestParams.parentZone !='') ||(requestParams.zoneName !=null && requestParams.zoneName != 'null' && requestParams.zoneName != undefined && requestParams.zoneName != 'undefined' && requestParams.zoneName !=''))))
		{
			document.location='/final/monitor/zoneDash.jsp?selectNode=Zone$cap$'+requestParams.parentZone+'&selectedParam='+requestParams.parentZone+'&currentTab=details&zoneName='+requestParams.parentZone+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.fromHomepage+'&fromZoneMenu='+isfromZoneMenu;
			return;
		}
		else if(!Ext.isEmpty(values) && requestParams.parentZone != null && requestParams.parentZone != 'null' && requestParams.zoneName != null && requestParams.parentZone != requestParams.zoneName)
		{
			document.location='/final/monitor/zoneDash.jsp?selectNode=Zone$cap$'+requestParams.parentZone+'&selectedParam='+requestParams.parentZone+'&currentTab=details&zoneName='+requestParams.parentZone+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.fromHomepage;
		}
		else if(!Ext.isEmpty(values) && (requestParams.parentZone ==null || requestParams.parentZone == 'null' || requestParams.parentZone == undefined || requestParams.parentZone == 'undefined' || requestParams.parentZone ==''))
		{
			document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
		}
		else if(backButtonFunction.length>0)
		{
			if(treeSession.indexOf("zoneDash")>0 && !Ext.isEmpty(requestParams.parentZone) && requestParams.parentZone!='' && requestParams.parentZone!='null' && requestParams.parentZone!='undefined' && requestParams.parentZone!=requestParams.zoneName)
			{
				document.location='/final/monitor/zoneDash.jsp?selectNode=Zone$cap$'+requestParams.parentZone+'&selectedParam='+requestParams.parentZone+'&currentTab=details&zoneName='+requestParams.parentZone+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.fromHomepage;
			}
			else if(!Ext.isEmpty(values) && requestParams.parentZone!=requestParams.zoneName)
			{
				//window.history.go(-3);
				document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
			}
			else
			{		
				//var searchType = parent.getSearchComboObj().getValue();	
				//var searchValue = parent.getSearchBoxObj().getValue();	
				var searchType = '';
				var searchValue = '';
				try{
					searchType = parent.getSearchComboObj().getValue();
					searchValue = parent.getSearchBoxObj().getValue();
				}
				catch(e)
				{
					searchType = parent.parent.getSearchComboObj().getValue();
					searchValue = parent.parent.getSearchBoxObj().getValue();
				}
				if (requestParams.from=='MainDashboard')
				{					
					if (searchType!=null && searchType=='zone' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=zoneList&action=globalsearch&searchString='+searchValue;
					}
					else
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone&isFromMenu=true';
					}
				}
				else
				{
					if (searchType!=null && searchType=='zone' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=zoneList&action=globalsearch&searchString='+searchValue;
					}
					else if(searchValue!=null && searchValue=="*")
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone&isFromMenu=true';
					}
					else
					{
						window.history.go(-1);
					}
				}
			}
		}
		else if(!Ext.isEmpty(requestParams.parentZone) && requestParams.parentZone!='' && requestParams.parentZone!='null' && requestParams.parentZone!='undefined'  && requestParams.parentZone!=requestParams.zoneName)
		{
			if (fromPageView!=null && fromPageView!=undefined && fromPageView!="" && fromPageView=='HomeZone')
			{
				document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
			}
			else if(requestParams.fromZoneMenu != null && requestParams.fromZoneMenu != undefined && requestParams.fromZoneMenu != "" && (requestParams.fromZoneMenu == "true" || requestParams.fromZoneMenu == "yes"))
			{
				document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone&isFromMenu=true';
			}
			else
			{
				document.location='/final/monitor/zoneDash.jsp?selectNode=Zone$cap$'+requestParams.parentZone+'&selectedParam='+requestParams.parentZone+'&currentTab=details&zoneName='+requestParams.parentZone+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage='+requestParams.fromHomepage;
			}
		}
		else
		{
			if(!Ext.isEmpty(values) && values!='undefined')
			{
				//window.history.go(-5);
				if (fromPageView!=null && fromPageView!='null' && fromPageView!="" && fromPageView!=undefined && fromPageView=='ZoneMap')
				{
					document.location='/final/monitor/zoneMap.jsp?isFromMenu=true';
				}
				else if (fromPageView!=null && fromPageView!='null' && fromPageView!="" && fromPageView!=undefined && fromPageView=='Zone')
				{
					document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone&isFromMenu=true';
				}
				else if(isfromZoneMenu)
				{
					document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone&isFromMenu=true';
				}
				else
				{
					document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
				}
				
			}
			else if(!Ext.isEmpty(requestParams.refresh) && requestParams.refresh=="true")
			{
				window.history.go(-2);
			}
			else
			{
				//window.history.go(-4);
				//var searchType = parent.getSearchComboObj().getValue();	
				//var searchValue = parent.getSearchBoxObj().getValue();	
				var searchType = '';
				var searchValue = '';
				try{
					searchType = parent.getSearchComboObj().getValue();
					searchValue = parent.getSearchBoxObj().getValue();
				}
				catch(e)
				{
					searchType = parent.parent.getSearchComboObj().getValue();
					searchValue = parent.parent.getSearchBoxObj().getValue();
				}
				if (searchType!=null && searchType=='zone' && searchValue!=null && searchValue!="" && !Ext.isEmpty(searchValue) && searchValue!="*")
				{
					document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=zoneList&action=globalsearch&searchString='+searchValue;
				}
				else
				{
					if (fromPageView!=null && fromPageView!='null' && fromPageView!="" && fromPageView!=undefined && fromPageView=='ZoneMap')
					{
						document.location='/final/monitor/zoneMap.jsp?isFromMenu=true';
					}
					else
					{
						document.location='/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone&isFromMenu=true';
					}
				}
			}
		}
	},
	zonesDashboardAfterRenderHandler:function(tabpanel){
		this.loadActiveTabData(tabpanel);
	},

	itemset:function(window,e){
		window.add(window.setData("",""));
	},
	combo:function(combo,newvalue,opt){
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
		var testfun='';
		//if(descMeasureUnit=='Yes')
		testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		var name=combo.getName();
		var val=combo.getValue();
		var componentType;
		if(selectedTab=='Component' || selectedTab=='Aggregate')
			componentType=this.getConfigWindowForm().getForm().getValues()['serviceComp'];
		if(name=='serviceComp')
			this.getConfigWindow().setData(selectedTab,perform,componentType,"","","",descMeasureUnit,testfun,"", name, val);
		if(name=='compLayer')
		{
			var compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			this.getConfigWindow().setData(selectedTab,perform,componentType,compname,"","",descMeasureUnit,testfun,"", name, val);
		}
		else if(name=='serviceTest')
			{
				var compname;
				if(perform=='Add')
					compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
				else
					compname='';
				var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
				this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,"",descMeasureUnit,testfun,"", name, val);

			}
		else if(name=='serviceMeasure')
			{
				var compname;
				if(perform=='Add')
					compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
				else
					compname='';
				var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
				var measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
				var dispName=newvalue[0].data.name;
				this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName, name, val);
			}
		else{}
	},

	radio:function(radio,newvalue,oldvalue,opts){
		var name='';
		var componentType='';
		var compname='';
		var testName='';
		var measureName='';
		var dispName='';
		var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
		var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
		var descMeasureUnit='';
		var testfun='';
		if(perform=='Add')
		{
			//descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
			//if(descMeasureUnit=='Yes')
			testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
		}
		if(radio.getName()=='Does the Test have Descriptors ?'||radio.getName()=='Function')
		{
			if(perform=='Add')
				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
			if(selectedTab=='Component' || selectedTab=='Aggregate')
				componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
			testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
			measureName=this.getConfigWindowForm().getForm().findField('serviceMeasure').getValue();
			dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
			name=radio.name;
		}
		this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
	},

	buttonclick:function(button,e,opts)
	{
		var flag=false;
		var me=this;
		var url='/final/monitor/serviceDashboardConfigP.jsp';
		var params='selectType=Update';
		var json=this.getConfigWindow().jsonData.Window.fields;
		var labels=this.getConfigWindow().jsonData.Window.screenlabels[0];
		for(var i=0;i<json.length;i++)
		{
			if(json[i].type=='combo')
			{
				var name=json[i].name;
				if(this.getConfigWindowForm().getForm().findField(name).getValue()==-1)
				{
					Ext.Msg.alert("",labels[name]);
					flag=true;
					break;
				}
				else
				{
					if(name=='serviceTest')
						name='testName';
					params+='&'+name+'='+json[i].selected;
				}
			}
			else
			{
				if(json[i].type=='textfield')
				{
					var dispName=this.getConfigWindowForm().getForm().findField('serviceDispName').getValue();
					flag=true;

					// Changes For ?,',- and Numbers charcters Support - Starts Here
					while(true){
						if(dispName.indexOf("?") != -1)
							dispName = dispName.replace('?','qqsstt');
						if(dispName.indexOf("'") != -1)
							dispName = dispName.replace("'","sinCour");
						if(dispName.indexOf("-") != -1)
							dispName = dispName.replace("-","minSym");

						if(dispName.indexOf("?") == -1 && dispName.indexOf("'") == -1 && dispName.indexOf("'") == -1)
							break;
					}

					if(dispName.length<1)
						Ext.Msg.alert("","Please enter display name");
					//else if(this.hasNumbers(dispName))
					//	Ext.Msg.alert("","Number not allowed");
					else if( this.hasSpecialCharacters(dispName) )
					{
						if(this.hasNumbers(dispName))
						{
							params+='&'+json[i].name+'='+dispName;
							flag=false;
						}
						else
							Ext.Msg.alert("","Special characters not allowed");
					}
					else
					{
						params+='&'+json[i].name+'='+dispName;
						flag=false;
					}
					// Changes For ?,',- and Numbers charcters Support - Ends Here
				}
				else
				{
					if(json[i].selected=='Component')
						json[i].selected='Application';
					params+='&'+json[i].name+'='+json[i].selected;
				}
			}
		}
		if(flag==false)
		{
			Ext.Ajax.request({
	       	    url: url,
	       	    params:params,
	       	    method : 'POST',
				timeout:280000,
	       	    scope:this,
	       	    success: function(response) {
	       	    	//Ext.Msg.alert("Success","Done");
	       	    	var selectedTab=this.getConfigWindowForm().getForm().getValues()['selectedTab'];
	       			var perform=this.getConfigWindowForm().getForm().getValues()['perform'];
	       	    	var dispName="";
	       	    	var measureName=-1;
	       	    	var testName=this.getConfigWindowForm().getForm().findField('serviceTest').getValue();
	       	    	var compname='';
	       	    	var componentType='';
	       	    	var descMeasureUnit='';
	       			var testfun='';
	       	    	if(perform=='Add')
	       			{
	       				//descMeasureUnit=this.getConfigWindowForm().getForm().getValues()['descMeasureUnit'];
	       				//if(descMeasureUnit=='Yes')
	       				testfun=this.getConfigWindowForm().getForm().getValues()['TestFunc'];
	       				compname=this.getConfigWindowForm().getForm().findField('compLayer').getValue();
						Ext.Msg.alert("","Measure Added Successfully");
	       			}
					else if(perform=='Delete')
					{
						Ext.Msg.alert("","Measure Deleted Successfully");
					}
	       	    	if(selectedTab=='Component' || selectedTab=='Aggregate')
	       	    		componentType=this.getConfigWindowForm().getForm().findField('serviceComp').getValue();
	       	    	this.getConfigWindow().setData(selectedTab,perform,componentType,compname,testName,measureName,descMeasureUnit,testfun,dispName,name, "");
	       	    },
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
			if(flag==false)
			{
				Ext.Function.defer(function(){
					me.setValues(flag);
				},350);
			}
	},
	setValues:function(flag){
		if(flag==false)
		{
			var json1=this.getConfigWindow().jsonData.Window.fields;
			var f=false;
			for(var i=0;i<json1.length;i++)
			{
				if(json1[i].type=='combo')
				{
					if(json1[i].selected!='Not Applicable!')
							f=true;
					if(!f && this.getConfigWindowForm().getForm().getValues()['perform']=='Delete')
					{
						this.getConfigWindowForm().getForm().findField(json1[i].name).setValue(-1);
					}
				}
				f=false;
			}
		}
	},
	hasNumbers:function(t)
	{
		var regex = /\d/g;
		return regex.test(t);
	},
	hasSpecialCharacters:function(t)
	{
		return  /[^a-zA-Z ]/g.test(t);
	},
	loadActiveTabData:function(tabpanel){
		var activeTab = tabpanel.getActiveTab();
		tabpanel.currentTab = activeTab.itemId;
		tabpanel.aggregateTab = requestParams.aggregateTab;

		var zoneNameEncode = encodeURI(tabpanel.currentZone);
		var url = activeTab.url;
		url += "&selectNode=Zone$cap$"+zoneNameEncode+"&selectedParam="+zoneNameEncode+"&currentTab="+tabpanel.currentTab+"&aggregateTab="+tabpanel.aggregateTab;
		if(tabpanel.currentTab == 'components' && !Ext.isEmpty(requestParams.appCurrentHost)){
			url += '&appCurrentHost='+requestParams.appCurrentHost;
		}
		if(tabpanel.currentTab == 'aggregates' && !Ext.isEmpty(requestParams.aggregateComp)){
			url += '&aggregateComp='+requestParams.aggregateComp;
		}
		else if(tabpanel.currentTab == 'details'){
			url += "&monCmd=zoneDashboard&zoneName="+zoneNameEncode;
			zoneName = zoneNameEncode;
			zoneState = tabpanel.zoneState;
		}

		var fh_values=(!Ext.isEmpty(requestParams.fromHomepage))? requestParams.fromHomepage:"";
		url= url+'&fromHomepage='+fh_values+'&fromDashboard='+fromDashboard+'&parentZone='+requestParams.parentZone;
		
		if(selectedSystemCompType !=null && selectedSystemCompType != 'null' && selectedSystemCompType !='')
			url = url + "&appCurrentHost="+selectedSystemCompType;

		url += tabpanel.treeUrl;
		if(!Ext.isEmpty(csrfToken) && csrfToken!=null && csrfToken!=undefined)
			url = url+"&com.eg.CSRF_NONCE="+csrfToken;
		var maintainanceBtn = this.getDashboardMaintainanceButton();
		maintainanceBtn.setVisible(false);
		RefpageVal = "";
		switch(activeTab.itemId){
			case "system":{
				activeTab.loadTab(url,'zonesSys');
				if(isAllComponentAccess)
				{
					maintainanceBtn.setVisible(true);
				}
				else
				{
					maintainanceBtn.setVisible(false);
				}
				break;
			}
			case "components":{
				activeTab.loadTab(url,'zonesComp');
				if(isAllComponentAccess)
				{
					maintainanceBtn.setVisible(true);
				}
				else
				{
					maintainanceBtn.setVisible(false);
				}
				break;
			}
			case "aggregates":{
				activeTab.loadTab(url,'zonesAgg');
				if(isAllComponentAccess)
				{
					maintainanceBtn.setVisible(true);
				}
				else
				{
					maintainanceBtn.setVisible(false);
				}
				break;
			}
			case "details":{
				activeTab.loadTab(url,'zonesDet');
				maintainanceBtn.setVisible(false);
				break;
			}
		}
		//activeTab.loadTab(url);
	},

	componentsComboChange:function(combo){
		var hostType = combo.getValue();
		var componentsUrl = this.getComponentsPanel().url;
		var zone = this.getZoneDashboard().currentZone;
		var url = componentsUrl+'&selectNode=Zone$cap$'+encodeURI(zone)+'&selectedParam='+encodeURI(zone)+'&appCurrentHost='+hostType;
		var fh_values=(!Ext.isEmpty(requestParams.fromHomepage))? requestParams.fromHomepage:"";
		url= url+'&fromHomepage='+fh_values+'&fromDashboard='+fromDashboard+'&parentZone='+requestParams.parentZone;

		this.getComponentsPanel().loadTab(url,'zonesComp');
	},

	aggregatesComboChange:function(combo){
		var hostType = combo.getValue();
		var aggregatesUrl = this.getAggregatesPanel().url;
		var zone = this.getZoneDashboard().currentZone;
		var url = aggregatesUrl+'&selectNode=Zone$cap$'+encodeURI(zone)+'&selectedParam='+encodeURI(zone)+'&aggregateComp='+hostType;
		var fh_values=(!Ext.isEmpty(requestParams.fromHomepage))? requestParams.fromHomepage:"";
		url= url+'&fromHomepage='+fh_values+'&fromDashboard='+fromDashboard+'&parentZone='+requestParams.parentZone;

		this.getAggregatesPanel().loadTab(url,'zonesAgg');
	},
	systemsComboChange:function(combo){
		var hostType = combo.getValue();
		var systemsUrl = this.getSystemPanel().url;
		var zone = this.getZoneDashboard().currentZone;
		var url = systemsUrl+'&selectNode=Zone$cap$'+encodeURI(zone)+'&selectedParam='+encodeURI(zone)+'&appCurrentHost='+hostType;
		var fh_values=(!Ext.isEmpty(requestParams.fromHomepage))? requestParams.fromHomepage:"";
		url= url+'&fromHomepage='+fh_values+'&fromDashboard='+fromDashboard+'&parentZone='+requestParams.parentZone;

		this.getSystemPanel().loadTab(url,'zonesSys');
	},
	infrastructureHealthViewRender:function(){
		if(requestParams.fromHomepage == null || requestParams.fromHomepage =='null' || requestParams.fromHomepage == 'undefined' || requestParams.fromHomepage == undefined || requestParams.fromHomepage == '')
		{
			isfromZoneMenu = 'true';
		}
		var fromPageView=requestParams.fromPageView;
		var refUrl = '/final/monitor/zoneInfrastructureHealthView.jsp?currentTab='+requestParams.currentTab+'&aggregateTab='+requestParams.aggregateTab+'&openNode='+requestParams.openNode+'&treeFlag='+requestParams.treeFlag+'&fromHomepage='+requestParams.fromHomepage;
		var tempZone = (requestParams.selectedParam!='null' && requestParams.selectedParam!='')?requestParams.selectedParam:zoneNameMain;
		var tempParentZone = (requestParams.parentZone!='null' && requestParams.parentZone!='')?requestParams.parentZone:zoneNameMain;

		var Url = refUrl +'&zoneName='+encodeURI(tempZone)+'&parentZone='+encodeURI(tempParentZone)+'&fromZoneMenu='+isfromZoneMenu;
		if(selectedState != null && selectedState != undefined && selectedState != "" && selectedHealthName != null && selectedHealthName != undefined && selectedHealthName!= "")
		{
			Url = Url+'&selectedState='+selectedState+'&selectedHealthName='+selectedHealthName;
		}

		Url = Url+'&fromPageView='+fromPageView;
		//if(fromPageView == '' || fromPageView != 'HomeZone')
			//Url = Url+'&fromZoneMenu=true';

		Ext.Ajax.request({
			url : Url,
			scope:this,
			method : 'POST',
			timeout:280000,
			success: function(response)
			{
		        var jsonText = response.responseText;
		        var jsonData=Ext.decode(jsonText);
		        this.jsonData=null;
		        this.jsonData=jsonData;
				if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.healthView))
				{
		        	this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
					var selectedInfraStructure = jsonData['selectedInfraStructure'];
		        		var healthViewData = null;
					switch(selectedInfraStructure){
						case "zones": healthViewData=this.jsonData.healthView.zones;
										break;
						case "services": healthViewData=this.jsonData.healthView.services;
										break;
						case "serviceGroups" : healthViewData=this.jsonData.healthView.serviceGroups;
										break;
						case "segments": healthViewData=this.jsonData.healthView.segments;
										break;
						case "aggregates": healthViewData=this.jsonData.healthView.aggregates;
										break;
						case "components": healthViewData=this.jsonData.healthView.components;
										break;
						case "virtual_components": healthViewData=this.jsonData.healthView.virtual_components;
										break;
					}					
					if(healthViewData!=null)
						this.getHealthViewData().createMenuItems(selectedInfraStructure,healthViewData,jsonData.screenLabels);
					//this.getHealthViewData().createMenuItems("components",jsonData.healthView.components,jsonData.screenLabels);	//default show components view
					if (zonelasInfrastructureMenuSelection == 'components' )
					{
						this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
						this.getHealthViewData().createMenuItems("components",jsonData.healthView.components,jsonData.screenLabels);
					}
					else if(zonelasInfrastructureMenuSelection == 'services' )
					{
						this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
						this.getHealthViewData().createMenuItems("services",jsonData.healthView.services,jsonData.screenLabels);
					}
					else if(zonelasInfrastructureMenuSelection == 'segments' )
					{
						this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
						this.getHealthViewData().createMenuItems("segments",jsonData.healthView.segments,jsonData.screenLabels);
					}
					else if(zonelasInfrastructureMenuSelection == 'zones' )
					{
						this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
						this.getHealthViewData().createMenuItems("zones",jsonData.healthView.zones,jsonData.screenLabels);
					}
					else if(zonelasInfrastructureMenuSelection == 'aggregates' )
					{
						this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
						this.getHealthViewData().createMenuItems("aggregates",jsonData.healthView.aggregates,jsonData.screenLabels);
					}

					if(!Ext.isEmpty(jsonData.screenLabels))
					{
		        		this.getInfrastructureHealthView().setTitle(jsonData.screenLabels["Infrastructure Health"]);

		        	}
					if(Ext.isEmpty(zonelasInfrastructureMenuSelection))
					{
						if(!Ext.isEmpty(jsonData.selectedInfraStructure))
						{
							var defaultButton = this.getHealthViewMenu().child('button[action='+jsonData.selectedInfraStructure+']');
							defaultButton.fireEvent('click',defaultButton);
							var selectedInfraStructure = jsonData['selectedInfraStructure'];
							var healthViewMenu = this.getHealthViewMenu();
							if(!Ext.isEmpty(selectedInfraStructure))
							{
								for(var menu=0;menu<healthViewMenu.items.getCount();menu++)
								{
									var menuBtn=healthViewMenu.items.getAt(menu);
									if(!Ext.isEmpty(menuBtn.id) && menuBtn.action==selectedInfraStructure)
									{
										menuBtn.removeCls('non-selected-menu');
										menuBtn.addCls('selected-menu');
									}
									else
									{
										menuBtn.removeCls('selected-menu');
										menuBtn.addCls('non-selected-menu');
									}
									menuBtn = null;
									delete menuBtn;
									
								}
							}
						}
					}
					else
					{
						var defaultButton = this.getHealthViewMenu().child('button[action='+zonelasInfrastructureMenuSelection+']');
							defaultButton.fireEvent('click',defaultButton);
					}
		        }
		    },
			failure:function()
			{
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},

	infrastructureHealthViewload:function(url)
	{
		var fromPageView=requestParams.fromPageView;

		var refUrl = '/final/monitor/zoneInfrastructureHealthView.jsp?currentTab='+requestParams.currentTab+'&aggregateTab='+requestParams.aggregateTab+'&openNode='+requestParams.openNode+'&treeFlag='+requestParams.treeFlag+'&fromHomepage='+requestParams.fromHomepage;
		var tempZone = (requestParams.selectedParam!='null' && requestParams.selectedParam!='')?requestParams.selectedParam:zoneNameMain;
		var tempParentZone = (requestParams.parentZone!='null' && requestParams.parentZone!='')?requestParams.parentZone:zoneNameMain;
		var Url = refUrl +'&zoneName='+tempZone+'&parentZone='+tempParentZone+'&fromZoneMenu='+isfromZoneMenu;
		if(selectedState != null && selectedState != undefined && selectedState != "" && selectedHealthName != null && selectedHealthName != undefined && selectedHealthName != "")
		{
			Url = Url+'&selectedState='+selectedState+'&selectedHealthName='+selectedHealthName;
		}

		Url = Url+'&fromPageView='+fromPageView;

		Ext.Ajax.request({
			url : Url,
			scope:this,
			method : 'POST',
			timeout:280000,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				this.jsonData=null;
				this.jsonData=jsonData;
				if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.healthView))
				{
					if (zonelasInfrastructureMenuSelection == 'components' )
					{
						this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
						this.getHealthViewData().createMenuItems("components",jsonData.healthView.components,jsonData.screenLabels);	//default show components view
					}
					else if (zonelasInfrastructureMenuSelection == 'services' )
					{
						this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
						this.getHealthViewData().createMenuItems("services",jsonData.healthView.services,jsonData.screenLabels);
					}
					else if (zonelasInfrastructureMenuSelection == 'segments' )
					{
						this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
						this.getHealthViewData().createMenuItems("segments",jsonData.healthView.segments,jsonData.screenLabels);
					}
					else if (zonelasInfrastructureMenuSelection == 'zones' )
					{
						this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
						this.getHealthViewData().createMenuItems("zones",jsonData.healthView.zones,jsonData.screenLabels);
					}
					else if (zonelasInfrastructureMenuSelection == 'aggregates' )
					{
						this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
						this.getHealthViewData().createMenuItems("aggregates",jsonData.healthView.aggregates,jsonData.screenLabels);
					}
					if(!Ext.isEmpty(jsonData.screenLabels))
					{
						this.getInfrastructureHealthView().setTitle(jsonData.screenLabels["Infrastructure Health"]);
					}
					if(Ext.isEmpty(zonelasInfrastructureMenuSelection))
					{
						if(!Ext.isEmpty(jsonData.selectedInfraStructure))
						{
							var defaultButton = this.getHealthViewMenu().child('button[action='+jsonData.selectedInfraStructure+']');
							defaultButton.fireEvent('click',defaultButton);
						}
					}
					else
					{
						var defaultButton = this.getHealthViewMenu().child('button[action='+zonelasInfrastructureMenuSelection+']');
						defaultButton.fireEvent('click',defaultButton);
					}
				}
			},
			failure:function()
			{
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	infrastructureHealthViewReload:function(url)
	{
		var refUrl = '/final/monitor/zoneInfrastructureHealthView.jsp?currentTab='+requestParams.currentTab+'&aggregateTab='+requestParams.aggregateTab+'&openNode='+requestParams.openNode+'&treeFlag='+requestParams.treeFlag+'&fromHomepage='+requestParams.fromHomepage;
		var tempZone = (requestParams.selectedParam!='null' && requestParams.selectedParam!='')?requestParams.selectedParam:zoneNameMain;
		var tempParentZone = (requestParams.parentZone!='null' && requestParams.parentZone!='')?requestParams.parentZone:zoneNameMain;
		var Url = refUrl +'&zoneName='+tempZone+'&parentZone='+tempParentZone;
		if(selectedState != null && selectedState != undefined && selectedState != "" && selectedHealthName != null && selectedHealthName != undefined && selectedHealthName != "")
		{
			Url = Url+'&selectedState='+selectedState+'&selectedHealthName='+selectedHealthName;
		}
		Ext.Ajax.request({
			url : Url,
			scope:this,
			method : 'POST',
			timeout:1280000,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				this.jsonData=null;
				this.jsonData=jsonData;
				if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.healthView))
				{
					if(Ext.isEmpty(zonelasInfrastructureMenuSelection))
					{
						if(!Ext.isEmpty(jsonData.selectedInfraStructure))
						{
							var defaultButton = this.getHealthViewMenu().child('button[action='+jsonData.selectedInfraStructure+']');
							defaultButton.fireEvent('click',defaultButton);
						}
					}
					else
					{
						this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
						if (zonelasInfrastructureMenuSelection == 'components' )
						{
							this.getHealthViewData().createMenuItems("components",jsonData.healthView.components,jsonData.screenLabels);
						}
						else if(zonelasInfrastructureMenuSelection == 'services' )
						{
							this.getHealthViewData().createMenuItems("services",jsonData.healthView.services,jsonData.screenLabels);
						}
						else if (zonelasInfrastructureMenuSelection == 'segments' )
						{
							this.getHealthViewData().createMenuItems("segments",jsonData.healthView.segments,jsonData.screenLabels);
						}
						else if (zonelasInfrastructureMenuSelection == 'zones' )
						{
							this.getHealthViewData().createMenuItems("zones",jsonData.healthView.zones,jsonData.screenLabels);
						}
						else if (zonelasInfrastructureMenuSelection == 'aggregates' )
						{
							this.getHealthViewData().createMenuItems("aggregates",jsonData.healthView.aggregates,jsonData.screenLabels);
						}
					}
				}
			},
			failure:function()
			{
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	healthViewMenuClick:function(btn)
	{
		zonelasInfrastructureMenuSelection = btn.action;
		var jsonData=null;
		var healthViewMenu=this.getHealthViewMenu();
		for(var menu=0;menu<healthViewMenu.items.getCount();menu++)
		{
			var menuBtn=healthViewMenu.items.getAt(menu);
			menuBtn.removeCls('selected-menu');
			menuBtn.addCls('non-selected-menu');
		}

		var searchField = Ext.getCmp('searchBox');
		if(!Ext.isEmpty(searchField.getValue())){
			searchField.setValue('');
		}
		switch(btn.action)
		{
			case "zones": jsonData=this.jsonData.healthView.zones;
						  break;
			case "services": jsonData=this.jsonData.healthView.services;
							 break;
			case "serviceGroups" : jsonData=this.jsonData.healthView.serviceGroups;
							 break;
			case "segments": jsonData=this.jsonData.healthView.segments;
							 break;
			case "aggregates": jsonData=this.jsonData.healthView.aggregates;
							 break;
			case "components": jsonData=this.jsonData.healthView.components;
							 break;
		}
		btn.addCls('selected-menu');
		this.getHealthViewData().createMenuItems(btn.action,jsonData,this.jsonData.screenLabels);
	},

	setDashboard:function(thisObj,opts){
		var aggTabFlag = thisObj.up('zonesdashboard').aggregateTab;
		if(aggTabFlag == true){
			this.getZoneDashboard().child('[itemId=aggregates]').tab.show();
		}
		else{
			this.getZoneDashboard().child('[itemId=aggregates]').tab.hide();
		}
	},
	windowgenerate : function(button,evt)
	{
		var VWidth = Ext.Element.getViewportWidth( );
		if(!this.getConfigWindow())
		{
			var win=Ext.create('zones.view.ConfigWindow');
			win.show();
			container = Ext.create('Ext.container.Container',{
				padding:'10px 10px 0px 10px',
				floating:true,
				frame:true,
				width:515,
				hidden:true,
				//height:500,
				floatable:true,
				//id:'configMod',
				cls:'configMode_popup',
				items:[
					{
						xtype:'container',
						cls:'alarmTooltipArrow1',
						style:{'top':'-17px','left':'414px'}
					},
					{
						xtype:'container',
						margin:'-4px 0px 0px 4px',
						html:'<div class="settingsfont" style="float:left;color:#f7f7f7;text-transform:uppercase;margin-top:-5px;">'+zoneSettingsTxt+'</div><div style="text-align:right;float:right;margin-top:-7px;"><div class="iconClose3"></div></div>',
					},
					win
				]
			});

			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
				   top:40,
					left: VWidth -615
				}
			});

			container.showAt(VWidth -615,5000);
			Ext.select('.iconClose3').on('click',function(){
				Ext.create('Ext.fx.Anim', {
					target: container,
					duration: 500,
					from: {
						left: VWidth -615,
						top:40
					},
					to: {
					   top:-500,
						left: VWidth -615
					},
					callback: function(){
						container.hide();
						zones.app.getController("ZonesDashboard").loadActiveTabData(tabSettingRef);
					}
				});
			},this);

			Ext.getBody().on('click',function(event){
				var tarid = event.target.id;
				if(tarid != undefined && tarid != null && ((tarid.toLowerCase().indexOf("gridview") != -1) || (tarid.toLowerCase().indexOf("tabbar") != -1) || (tarid.toLowerCase().indexOf("toolbar") != -1) || (tarid.toLowerCase().indexOf("filter") != -1)))
				{
					container.hide();
				}
			});
		}
		else if(container.isHidden())
		{
			var win=this.getConfigWindow();
			Ext.create('Ext.fx.Anim', {
				target: container,
				duration: 500,
				from: {

					left: VWidth -615,
					top:-500
				},
				to: {
				   top:40,
					left: VWidth -615
				}
			});

			container.showAt(VWidth -615,5000);
		}
		else
		{
			container.hide();
			zones.app.getController("ZonesDashboard").loadActiveTabData(tabSettingRef);

		}
	}
});