Ext.define('zones.view.DashboardSummaryChart', {
	extend: 'Ext.panel.Panel',
	alias:'widget.dashboardsummarychart',
	autoDestroy:true,
	border:false,
	margin:'0 0 0 10',
	padding:0,
	onRender:function(){
		this.refreshData();
		this.callParent();
	},

	refreshData:function(){
		this.removeAll();
		var zonesUrl = "";
		if(zoneNamefr != null && zoneNamefr != undefined ){
			zonesUrl = "/final/monitor/ZoneFusionChartGraphReload.jsp?chartToLoad=LinearGauge&pageName=zoneDashboard&zoneName="+zoneNamefr;
		}else{
			zonesUrl = "/final/monitor/ZoneFusionChartGraphReload.jsp?chartToLoad=LinearGauge&pageName=zoneDashboard";
		}
		Ext.Ajax.request({
			url : zonesUrl,
			scope:this,
		    success: function(response){
		        var jsonText = response.responseText;
		        var jsonData=Ext.decode(jsonText);
				var barJson =  new Array();
				var tpl = new Ext.XTemplate('<div class="current-status" style="margin-left:0px;height:11px;margin-bottom:7px;margin-top:1px">'+currentStatus+'</div><div id="currentStatusBar" style="border:1px solid #6b6b6b;height:25px">',
						'<tpl for=".">',
							'<span style="width:{len};height:23px;" class="{classname}"><b style="visibility:hidden">{len}</b></span>',
						'</tpl>',
					'</div>');
		        //var chartHtml='<div class="current-status" style="padding-left:15px;height:11px;margin-top:4px">Current Status</div>';

				//var chartHtml = '<div style="width:100%;border:0px solid green;" id="linearChartContainer"></div><table width="100%" style="margin:0 0 0 15px"><tr>';
				var chartHtml = '<table width="100%" style="margin:6px 0 0 0px"><tr>';
		        for(var i=0;i<jsonData.statesData.length;i++){
		        	var text=jsonData.statesData[i].name;
					var cssClass=jsonData.statesData[i].cssClass;
					var cssClassIcon=jsonData.statesData[i].cssClassIcon;
					var percentage=jsonData.statesData[i].percentage;
					var link=jsonData.statesData[i].link;

					var str_percentage=""+percentage;
					if(str_percentage!=null && str_percentage.indexOf("<")>-1)
					{
						str_percentage = percentage;
						percentage = 0.0;
					}
					else if(percentage!=null && percentage!="")
					{
						percentage = Math.abs(percentage);
					}

					if(!Ext.isEmpty(link))
					{
						if(str_percentage!=null && str_percentage!="" && str_percentage.indexOf("<")>-1)
						{
							chartHtml +='<td><a href="'+link+'"><span style="float:left;margin-right: 4px;" data-qclass="yellowTip" data-qtip="'+text+" - "+str_percentage+'" class="'+cssClassIcon+'"></span><span >'+str_percentage+'</span></a></td>';
						}
						else
						{
							chartHtml +='<td><a href="'+link+'"><span style="float:left;margin-right: 4px;" data-qclass="yellowTip" data-qtip="'+text+" - "+percentage+' %" class="'+cssClassIcon+'"></span><span >'+percentage+' %</span></a></td>';
						}
					}
					else
					{
						if(str_percentage!=null && str_percentage!="" && str_percentage.indexOf("<")>-1)
						{
							chartHtml +='<td><span style="float:left;margin-right:4px" data-qclass="yellowTip" data-qtip="'+text+" - "+str_percentage+'" class="'+cssClassIcon+'"></span><span >'+str_percentage+'</span></td>';
						}
						else
						{
							chartHtml +='<td><span style="float:left;margin-right:4px" data-qclass="yellowTip" data-qtip="'+text+" - "+percentage+' %" class="'+cssClassIcon+'"></span><span >'+percentage+' %</span></td>';
						}
					}
					var p=percentage+'%';
					barJson.push({ len : p , classname : cssClass });
					text = null;
					delete text;

					link = null;
					delete link;

					cssClass = null;
					delete cssClass;

					p = null;
					delete p;

					percentage = null;
					delete percentage;
		        }

		        chartHtml+='</tr></table>';
		        //this.update(chartHtml);
				var generatedHtml = tpl.apply(barJson);
				this.update(generatedHtml+''+chartHtml);
				chartHtml = null;
				delete chartHtml;
				var bar = Ext.get('currentStatusBar');
				if(!Ext.isEmpty(bar)){
				bar.setWidth('0%');
				bar.setSize('100%',25, {duration:1000, easing:'bounceOut'});
				}

				/*
				if (FusionCharts("linearChartId"))
					FusionCharts("linearChartId").dispose();

				var linearChart = new FusionCharts('/final/FusionCharts/swf/HLinearGauge.swf', 'linearChartId', '100%', '30', '0', '1' );
				linearChart.setXMLData(jsonData.chartData.xmlData);
				linearChart.setTransparent(true);
				linearChart.render('linearChartContainer');
				*/

				linearChart = null;
				delete linearChart;

				jsonData = null;
				Ext.destroy(jsonData);
		    }
		});
	}
});