Ext.define('zones.view.InfrastructureHealthViewMenu', {
	extend: 'Ext.panel.Panel',
	alias:'widget.infrastructurehealthviewmenu',
	id:'infrastructurehealthviewmenu',
	scroll:true,
	autoScroll:true,
	internalScrollPosition:0,
	initialInnerHeight:0,
	border:true,
	cls:'border-right',
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		//hidden:true,
		id:'menuDock',
		buttonAlign:'center',
		padding:'0 0 0 80',
	}],
	layout: {
		type: 'vbox',
		align: 'stretch',
		defaultMargins:0,
		pack:'start'
	},
	createMenuItems:function(componentList){
		if(!Ext.isEmpty(componentList))
		{
			this.removeAll();
			itemsArray=new Array();
			var menu = null;
			for(var item=0;item<componentList.length;item++)
			{
				var xmlData=componentList[item].xmlData;
				var highChartData = componentList[item].highChartData;
				var placeHolder = Ext.fly('infrastructurehealthviewmenu-body');
				var containerInner = placeHolder.getComputedHeight( ),
				containerWidth = placeHolder.getComputedWidth( );
				setButtonHeight = containerInner/3; // Setting height of button dynamically
				menu={
						xtype:'button',
						cls:'menu-button non-selected-menu',
						//height:Math.round(setButtonHeight)+20,
						height:Math.round(setButtonHeight),
						width:containerWidth,
						padding:'0 0 0 0',
						overCls:'hover-menu',
						xmlData:xmlData,
						highChartData:highChartData,
						itemNumber:item,
						//contentText:"<div style='float:left;margin-left:-8px;margin-top:12px'>"+componentList[item].text+"</div> <div style='float:right;margin-top:12px'>"+componentList[item].total+"</div>",
						contentText:"<div style='float:left;margin-left:0px;'>"+componentList[item].text+"</div> <div style='float:right;'>"+componentList[item].total+"</div>",
						contentTotal:'',
						elementTotal:componentList[item].total,
						idString:'menuItem'+item,
						action:componentList[item].id,
						chartObj:null,
						onMouseDown:function()
						{				// For InfraStructure Menu Button Click
							donutClickFlag=false;
							zones.app.getController('ZonesDashboard').healthViewMenuClick(this);
							if(donutClickFlag == true)
							{
								alert("clicked");
								donutSliceClick();
							}
							else
							{
								selectedState = "";
								selectedHealthName = "";
								executeButton();
							}
					},
				};
				if ( componentList[item].id == zonelasInfrastructureMenuSelection )
				{
					menu.cls='menu-button selected-menu';
				}
				else if(item==componentList.length-1 && zonelasInfrastructureMenuSelection == '' ){
					menu.cls='menu-button selected-menu';
				}
				itemsArray.push(menu);

				xmlData = null;
				delete xmlData;

				placeHolder = null;
				delete placeHolder;

				containerWidth = null;
				delete containerWidth;

				setButtonHeight = null;
				delete setButtonHeight;
			}
			this.add(itemsArray);
			this.doLayout();
							/*----------------Slide up and down---------------------*/

/*
							var menuButtonHeight = menu.height; // Height of a button
							var upBT = Ext.getCmp('upArrow'); //Up Arrow
							var downBT = Ext.getCmp('downArrow'); //down Arrow
							var animationContainer = Ext.get('infrastructurehealthviewmenu-innerCt'); // this container will move up and down
							var totalHeightofbutton = componentList.length * menuButtonHeight; // Total Height of button currently using
							var placeHolder = Ext.get('infrastructurehealthviewmenu-body'); // Visible potion
							var containerInner = placeHolder.getComputedHeight( ); // Visible potion Height
							if( containerInner < totalHeightofbutton){
								Ext.getCmp('menuDock').hidden= false;
								var upbtEn = upBT.setDisabled(false);
									if(upbtEn){
										upbtEn.on('click',function(){
											var leftSpace = totalHeightofbutton - containerInner;
											animationContainer.animate({
												to:{'top': -leftSpace }
											});
											downBT.setDisabled(false);
											upbtEn.setDisabled(true);
											return false;
										},this);
									};
									if(downBT){
											downBT.on('click',function(){
												animationContainer.animate({
												to:{'top': 0}
												});
												upbtEn.setDisabled(false);
												downBT.setDisabled(true);
												return false;
											},this);
		}
							}
							else{
								upBT.hide();
								downBT.hide();
								}
		*/
							/*---------------- Slide up and down---------------------*/
		}
	},
	initComponent: function () {
		this.callParent();
	},
});