Ext.define('zones.view.Main', {
	extend: 'Ext.panel.Panel',
	requires : ['Ext.layout.container.Border','zones.view.ListPanel','zones.view.ZonesTreePanel','zones.view.OptionalListPanel','zones.view.Paging'],
	alias:'widget.main',
	id : 'zoneMain',
	name : 'zoneMain',
	border:false,
	frame:false,
	autoDestroy:true,
	url:'/final/monitor/zones.jsp',
	layout: {
		type: 'border'
	},
	showDashboard:false,
	optionalListFlag:false,
	activeTab:0,

	initComponent : function() {
		if(Ext.isEmpty(requestParams.treeOpen) || requestParams.treeOpen==="null" ){
			requestParams.treeOpen=false;
		}else if(requestParams.treeOpen==="true"){
			requestParams.treeOpen=true;
		}else{
			requestParams.treeOpen=false;
		}
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}

		/*var  locStrVal=localStorage.getItem('optionallistpanel');

		if((optionalListFlag===true || locStrVal=='1') && locStrVal!='2')
		{
			localStorage.setItem('optionallistpanel','1'); //This enables the optional view
		}*/

		//if(localStorage.getItem('optionallistpanel')=='1')
		if(optionalListFlag)
		{
			var contentPanel={
					xtype:'optionallistpanel',
					id:'optionallistpanel',
					region:'center',
					flex:5,
					mask : mask,
					url : this.url
			};
		}
		else
		{
			var contentPanel={
				xtype:'listpanel',
				id:'listpanel',
				//bodyCls:'bottom-right-radius list-panel-body-cls',
				region:'center',
				flex:5,
				mask : mask,
				url : this.url
			};
		}

		if(this.showDashboard===true){
			mask.hide();
		}
		this.items=[{
			xtype:'zonestreepanel',
			border : false,
			header : false,
			region:'west',
			cls:'removeTreeLeftBorder',
			collapsed: !requestParams.treeOpen,
			url : "/final/monitor/zoneTree.jsp?tree=ZoneTreeModel&width=208&str=sessionID&node=Zone&treeTitle=Zones Navigation",
			split: true,
			collapseMode :'mini',
			collapsible: true,
			//flex:1,
			width: 250,
			maxWidth:350,
			minWidth : 150
		},contentPanel];
		this.callParent();
	}
});


/*  Script for automatic scroll options start here   */

var divCount = 2;
var gettingComponentDivId=0;
var scrolldelay;

function pageScroll() {
	var pane=Ext.getCmp('listpanel');
	if (!Ext.isEmpty(pane))
	{
		var getMainBody = pane.body;
		var divHeight = 0;
		for (i=1;i<=divCount ;i++ )
		{
			gettingComponentDivId++;
			var gettingDivId ='dddd'+gettingComponentDivId;

			var divID = Ext.get(gettingDivId);
			var domm = '';
			if(!Ext.isEmpty(divID) && divID!=null && divID!=undefined)
				domm = divID.dom;
			divHeight+=domm.offsetHeight
		}
		//getMainBody.scrollBy(0,divHeight);
		getMainBody.scroll('bottom', divHeight, true);
		scrolldelay = setTimeout('pageScroll()', 3000);
		if($('#listpanel-body').scrollTop() + $('#listpanel-body').innerHeight()>=$('#listpanel-body')[0].scrollHeight)
		{
			gettingComponentDivId=0;
			getDiv=0;
			if (window.parent.tvModePlayAction!=undefined && window.parent.tvModePlayAction=='pause')
			{
				stopScroll();
				setTimeout('startTvModePlayAction()',3000);
			}
			else
			{
				clearTimeout(scrolldelay);
				scrolldelay = setTimeout('beforeContinueScroll()',3000);
			}
		}
	}
	else if (!Ext.isEmpty(Ext.getCmp('optionallistpanel')))
	{
		var getMainBody = Ext.getCmp('optionallistpanel').body;

		//getMainBody.scrollBy(0,275);
		getMainBody.scroll('bottom', 275, true);
		scrolldelay = setTimeout('pageScroll()', 3000);
		if($('#optionallistpanel-body').scrollTop() + $('#optionallistpanel-body').innerHeight()>=$('#optionallistpanel-body')[0].scrollHeight)
		{
			if (window.parent.tvModePlayAction!=undefined && window.parent.tvModePlayAction=='pause')
			{
				stopScroll();
				setTimeout('startTvModePlayAction()',3000);
			}
			else
			{
				clearTimeout(scrolldelay);
				scrolldelay = setTimeout('beforeContinueScroll()',3000);
			}
		}
	}

}

function startTvModePlayAction(){
	jumpScroll();
	window.parent.startTvModePlayAction();
}

function beforeContinueScroll(){
	var pane=Ext.getCmp('listpanel');
	if (!Ext.isEmpty(pane))
	{
		$('#listpanel-body').scrollTop(0);
		scrolldelay = setTimeout('pageScroll()',3000);
	}
	else if (!Ext.isEmpty(Ext.getCmp('optionallistpanel')))
	{
		$('#optionallistpanel-body').scrollTop(0);
		scrolldelay = setTimeout('pageScroll()',3000);
	}
}

function stopScroll(){
	clearTimeout(scrolldelay);
}

function jumpScroll(){
	var pane=Ext.getCmp('listpanel');
	if (!Ext.isEmpty(pane))
	{
		clearTimeout(scrolldelay);
		gettingComponentDivId=0;
		$('#listpanel-body').scrollTop(0); // horizontal and vertical scroll targets
	}
	else if (!Ext.isEmpty(Ext.getCmp('optionallistpanel')))
	{
		clearTimeout(scrolldelay);
		$('#optionallistpanel-body').scrollTop(0); // horizontal and vertical scroll targets
	}
}
	scrolldelay = null;
	delete scrolldelay;

/*  Script for automatic scroll options  end here   */



