Ext.define('zones.view.Measures', {
	extend: 'Ext.panel.Panel',
	requires:['zones.view.MeasuresGrid','zones.store.Measures'],
	alias:'widget.measures',
	autoDestroy:true,
	itemId:'measures',
	border:true,
	flex:1,

	layout:{
		type:'vbox',
		align:'stretch'
	},

	//forceFit : true,
	//store:'zones.store.Measures',
	screenLabels:null,
	//bodyCls : 'bottom-left-radius bottom-right-radius zoneDashboardWhiteBg',

	onRender : function(){
		this.callParent();
		this.refreshData(true);
	},

	refreshData : function(updateLabels){
		/*if(!Ext.isEmpty(this.getEl())){
			this.getEl().mask("Loading...","maskCenter");
		}*/
		Ext.Ajax.request({
			url : '/final/monitor/zoneMinMax.jsp',
			scope:this,
		    success: function(response){
		        var jsonText = response.responseText;
		        var jsonData=Ext.decode(jsonText);
				if(!Ext.isEmpty(jsonData.measures))
				{
					var measureColumns=new Array();
					if(!Ext.isEmpty(updateLabels) && updateLabels === true){
						if(!Ext.isEmpty(jsonData)){
							var screenLabels=jsonData.screenLabels;
							measureColumns.push(screenLabels["zones.common.Measure"]?screenLabels["zones.common.Measure"]:"Measure");
							measureColumns.push(screenLabels["zones.common.Test"]?screenLabels["zones.common.Test"]:"Test");
							measureColumns.push(screenLabels["zones.zonehome.Component"]?screenLabels["zones.zonehome.Component"]:"Component");
							measureColumns.push(screenLabels["zones.zonehome.Value"]?screenLabels["zones.zonehome.Value"]:"Value");
							this.updateLabels(screenLabels);
						}
					}

					var measureStore=Ext.create('zones.store.Measures',{
						data:jsonData
					});
					var measureConfig={store:measureStore};
					if(measureColumns.length>0){
						measureConfig.columnLabels=measureColumns;
					}
					var measureGrid=Ext.create('zones.view.MeasuresGrid',measureConfig);
					this.removeAll();
					this.add(measureGrid);
				}
				else
				{
					var activeTab = "";
					if(!Ext.isEmpty(this.up('tabpanel')) && this.up('tabpanel')!=null && this.up('tabpanel')!=undefined)
					{	
						activeTab = this.up('tabpanel').getActiveTab();
						this.up('tabpanel').remove(activeTab);
					}
				}
				/*if(!Ext.isEmpty(this.getEl())){
					this.getEl().unmask();
				}*/
		    }
		});
	},

	updateLabels:function(screenLabels){
		this.setTitle(screenLabels["zones.zonehome.Measure At-A-Glance"]?screenLabels["zones.zonehome.Measure At-A-Glance"]:"Measure At-A-Glance");
	}
});
