Ext.define('zones.view.MeasuresGrid', {
	extend: 'utilities.CustomGrid',
	alias:'widget.measuresgrid',
	autoDestroy:true,
	border:false,
	forceFit:false,
	autoScroll:true,
	scroll:true,
	flex:1,
	cls:'gridSkin',
	columnLabels:["Measure","Test","Component","Value"],

	initComponent : function(){

		this.columns=[{
			header:this.columnLabels[0],
			menuDisabled: true,
			dataIndex:'measure',
			flex:3,
			scope:this,
			renderer:function(value,metaData,record,rowIndex,colIndex){
				if(this.columns[colIndex].getVisibleIndex() % 2 != 0){
					//metaData.tdCls='odd-col';
				}
				return '<img style="vertical-align:middle;display:inline-block;margin-right:10px;margin-top:-2px;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="state_footer_'+record.get('state')+'"/> <a href="'+record.get('links')+'">'+record.get('min_max')+' '+value+'</a>';
			}
		},{
			header:this.columnLabels[1],
			menuDisabled: true,
			dataIndex:'test',
			flex:2,
			scope:this,
			renderer:function(value,metaData,record,rowIndex,colIndex){
				if(this.columns[colIndex].getVisibleIndex() % 2 != 0){
					//metaData.tdCls='odd-col';
				}
				return '<a href="'+record.get('links')+'">'+value+'</a>';
			}
		},{
			header:this.columnLabels[2],
			menuDisabled: true,
			dataIndex:'componentName',
			flex:4,
			scope:this,
			renderer:function(value,metaData,record,rowIndex,colIndex){
				if(this.columns[colIndex].getVisibleIndex() % 2 != 0){
					//metaData.tdCls='odd-col';
				}
				return '<a href="'+record.get('links')+'">'+value+'<i>'+record.get('componentIndex')+'</i></a>';

			}
		},{
			header:this.columnLabels[3],
			menuDisabled: true,
			dataIndex:'value',
			flex:1,
			scope:this,
			sortable:false,
			renderer:function(value,metaData,record,rowIndex,colIndex){
				if(this.columns[colIndex].getVisibleIndex() % 2 != 0){
					//metaData.tdCls='odd-col';
				}
				return '<a href="'+record.get('links')+'">'+value+' '+record.get('valueUnit')+'</a>';
			}
		}];
		this.listeners={
				scope:this,
				'columnhide':function(){
					this.getView().refresh();
				},
				'columnshow':function(){
					this.getView().refresh();
				}
		};
		this.callParent();
	},

	afterRender:function(grid){
		this.callParent();
		//handled the logic if dynamic columns are less that the total width
		var totalWidth=this.getWidth();
		var totalColumnsWidth=0;
		for(var col=0;col<this.columns.length;col++){
			var colWidth=this.columns[col].getWidth();
			totalColumnsWidth+=colWidth;
		}

		if(totalColumnsWidth<totalWidth){
			for(var col=0;col<this.columns.length;col++){
				if(col==2)
					this.columns[col].flex=2;
				else if(col==3)
					this.columns[col].flex=0.7;
				else
					this.columns[col].flex=1;
			}
			this.doLayout();
		}
	}
});