Ext.define('zones.view.ProblemAnalysis', {
	extend: 'Ext.form.Panel',
	alias:'widget.problemanalysis',
	autoDestroy:true,
	requires:['zones.view.ProblemAnalysisProblems','zones.view.ProblemAnalysisComponents','zones.store.ProblemAnalysisProblems','zones.store.ProblemAnalysisComponents'],
	screenLabels:null,
	flex:1,
	bodyCls:'zoneDashboardWhiteBg',
	layout:{
		type:'hbox',
		align:'stretch'
	},
	border:true,

//	items:[{
//		xtype:'problemanalysisproblems',
//		flex:1
//	},{
//		xtype:'problemanalysiscomponents',
//		flex:1
//	}],

	onRender : function(){
		this.callParent();
		this.refreshData(true);
	},

	refreshData : function(updateLabels,duration){
		/*if(!Ext.isEmpty(this.getEl())){
			this.getEl().mask("Loading...","maskCenter");
		}*/
		var url='/final/monitor/zoneProblemAnalysis.jsp';
		if(!Ext.isEmpty(duration)){
			url=url+'?duration='+duration
		}
		else
		{
			var problemanalysiscomponents = this.down('problemanalysiscomponents');
			if(!Ext.isEmpty(problemanalysiscomponents))
			{
				duration = problemanalysiscomponents.duration;
				if(!Ext.isEmpty(duration))
					url=url+'?duration='+duration
			}
		}
		Ext.Ajax.request({
			url : url,
			scope:this,
		    success: function(response){
		        var jsonText = response.responseText;
		        var jsonData=Ext.decode(jsonText);
		        if(!Ext.isEmpty(jsonData)){

					var screenLabels=jsonData.screenLabels;
	        		this.screenLabels=screenLabels;
		        }
		        if(!Ext.isEmpty(jsonData.problemAnalysis.problems) || !Ext.isEmpty(jsonData.problemAnalysis.components)){
		        	var errorPanel=Ext.getCmp('analysis-error-panel');
		        	if(!Ext.isEmpty(errorPanel)){
		        		var tabpanel=this.findParentByType('tabpanel');
		        		tabpanel.remove(errorPanel);
		        	}
		        	var tabpanel=this.findParentByType('tabpanel');
		        	tabpanel.child('#eventanalysis').tab.show();
		        	var eventTab=tabpanel.child('#eventanalysis');

		        	var prblmColLabels=new Array();
		        	var compColLabels=new Array();
		        	var moreEventsLabel="";
			        if(!Ext.isEmpty(this.screenLabels)){
			        	if(!Ext.isEmpty(updateLabels) && updateLabels === true){
			        		var screenLabels=this.screenLabels;
			        		prblmColLabels.push(screenLabels["zones.zonehome.Layer"]?screenLabels["zones.zonehome.Layer"]:"Layer");
			        		prblmColLabels.push(screenLabels["zones.zonehome.Unresolved Problems"]?screenLabels["zones.zonehome.Unresolved Problems"]:"Unresolved Problems");
			        		prblmColLabels.push(screenLabels["zones.zonehome.Average Duration"]?screenLabels["zones.zonehome.Average Duration"]:"Average Duration");
			        		prblmColLabels.push(screenLabels["zones.zonehome.Maximum Duration"]?screenLabels["zones.zonehome.Maximum Duration"]:"Maximum Duration");

			        		moreEventsLabel=screenLabels["monitor.zonehome.Click here for more events"]?screenLabels["monitor.zonehome.Click here for more events"]:"Click here for more events";

			        		compColLabels.push(screenLabels["zones.zonehome.Type"]?screenLabels["zones.zonehome.Type"]:"Type");
			        		compColLabels.push(screenLabels["zones.zonehome.Name"]?screenLabels["zones.zonehome.Name"]:"Name");
			        		compColLabels.push(screenLabels["zones.zonehome.Events"]?screenLabels["zones.zonehome.Events"]:"Events");
			        	}
			        }
					//console.log(moreEventsLabel);
			        var problemStore=Ext.create('zones.store.ProblemAnalysisProblems',{
		        		data:jsonData
		        	});
			        //console.log(problemStore);

			        var prblmComfig={store:problemStore,flex:1};

			        if(prblmColLabels.length>0){
			        	prblmComfig.columnLabels=prblmColLabels;
			        }
			        if(!Ext.isEmpty(moreEventsLabel)){
			        	prblmComfig.moreEventsLabel=moreEventsLabel;
			        }

		        	var problemGrid=Ext.create('zones.view.ProblemAnalysisProblems',prblmComfig);

		        	var componentsTabTab=tabpanel.child('#measures');
			        var compStore=Ext.create('zones.store.ProblemAnalysisComponents',{
		        		data:jsonData
		        	});

			        var compComfig={store:compStore,flex:1,duration:jsonData.problemAnalysis.duration};		// Prem
			        if(compComfig.length>0){
			        	compComfig.columnLabels=compColLabels;
			        }

		        	var compGrid=Ext.create('zones.view.ProblemAnalysisComponents',compComfig);
		        	eventTab.removeAll();
		        	eventTab.add([problemGrid,compGrid]);
		        }else{
		        	this.showNoEventsMsg();
		        }

		        if(!Ext.isEmpty(this.screenLabels)){
		        	if(!Ext.isEmpty(updateLabels) && updateLabels === true){
		        		this.updateLabels(screenLabels);
		        	}
		        }
		       /* if(!Ext.isEmpty(this.getEl())){
		        	this.getEl().unmask();
		        }*/
		   }
		});
	},

	showNoEventsMsg:function(){
		var tabpanel=this.findParentByType('tabpanel');
		var errorMessage=this.screenLabels["zones.info.noEventsMsg"]?this.screenLabels["zones.info.noEventsMsg"]:noEventsAvailable;
		var errorPanel=Ext.getCmp('analysis-error-panel');
    	if(Ext.isEmpty(errorPanel)){
    		var errPanel=Ext.create('Ext.panel.Panel',{
    			id:'analysis-error-panel',
    			title:this.title,
				margin:0,
				height:150,
				//bodyCls:'top-left-radius top-right-radius',
				flex:1,
				frame:false,
				html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation"></div>'+errorMessage+'</td></tr></table>'
    		});
    		tabpanel.add(errPanel);
    		tabpanel.setActiveTab(errPanel);
    	}else{
    		tabpanel.setActiveTab(errorPanel);
    	}
    	tabpanel.child('#eventanalysis').tab.hide();
	},

	updateLabels:function(screenLabels){
		 this.setTitle(screenLabels["Event Analysis"]?screenLabels["Event Analysis"]:"Event Analysis");

	}
});