Ext.define('zones.view.ProblemAnalysisComponents', {
	extend: 'utilities.CustomGrid',
	alias:'widget.problemanalysiscomponents',
	autoDestroy:true,
	forceFit : false,
	border:false,
	autoScroll:true,
	scroll:true,
	duration:"",
	height:150,
	cls:'gridSkin border-left',
	margin:'0 0 0 10',
	//bodyCls : 'bottom-left-radius bottom-right-radius zoneDashboardWhiteBg',
	columnLabels:["Component Type","Component Name","Events"],
	hourStore:null,

    viewConfig: {
        getRowClass: function(record, index, rowParams, store) {
			if(record.get('componentType')=='hourCombo'){
				return "first-row";
			}
            return '';
        }
    },

	initComponent : function() {
    	this.hourStore= Ext.create('Ext.data.Store', {
			fields : [ 'value', 'name' ],
			data : [ {
						"value" : "1 hour",
						"name" : "1 "+hourLbl
					}, {
						"value" : "6 hours",
						"name" : "6 "+hoursLbl
					}, {
						"value" : "12 hours",
						"name" : "12 "+hoursLbl
					}, {
						"value" : "18 hours",
						"name" : "18 "+hoursLbl
					}, {
						"value" : "24 hours",
						"name" : "24 "+hoursLbl
					} ]
		});
		this.columns=[{
			header:CmpTypeLbl,
			dataIndex:'componentType',
			menuDisabled: true,
			sortable:false,
			resizable: true,
			flex:2,
			renderer:function(value,metaData,record,rowIndex){
			    if(value!='hourCombo'){
			    	return '<a href="'+record.get('address')+'">'+value+'</a>';
			    }else{
			    	return "";
			    }
			}
		},{
			header:CmpNameLbl,
			dataIndex:'componentName',
			menuDisabled: true,
			sortable:false,
			resizable: true,
			flex:1,
			renderer:function(value,metaData,record,rowIndex){
				if(record.get('componentType')!='hourCombo'){
					return '<a href="'+record.get('address')+'">'+value+'</a>';
				}else{
					metaData.style="overflow:visible;padding-top:5px;";
					return value;
				}
			}
		},{
			header:eventsLbl,
			menuDisabled: true,
			align:'center',
			dataIndex:'events',
			sortable:false,
			resizable: true,
			flex:1,
			renderer:function(value,metaData,record,rowIndex){
				if(record.get('componentType')=='hourCombo'){
					if(!Ext.isEmpty(Ext)){
						var divId = Ext.id();
						Ext.Function.defer(this.renderCombo,25,this,[divId]);
						return (Ext.String.format('<center><div id="{0}" style="position:absolute;"></div></center>',divId));
					}

					return value;
				}else{
					return value;
				}
			}
		}];
		this.callParent();
	},

	renderCombo : function(divId) {

				var comboInitialValue="1 hour";
				if(!Ext.isEmpty(this.duration)){
					comboInitialValue=this.duration;
				};

				if(!Ext.isEmpty(Ext.get(divId))){
					Ext.get(divId).update('');
					new Ext.form.ComboBox({
						fieldLabel : compEnvLbl,
						labelStyle:'',
						labelSeparator:'',
						style:{'white-space':'nowrap;'},
						labelAlign:'right',
						labelCls:'hourCombo-label',
						store : this.hourStore,
						editable:false,
						width:100,
						cls:'dropdown hourCombo',
						queryMode : 'local',
						displayField : 'name',
						valueField : 'value',
						renderTo : divId,
						value:comboInitialValue,
						listeners:{
							scope:this,
							'change':function(cmp,newValue,oldValue){
								this.fireEvent('hourComboChange',{'newValue':newValue});
							}
						}
					});
				}

	},

	afterRender:function(){
		this.getStore().on('load',this.storeLoadHandler,this);
		this.getStore().on('refresh',this.storeRefreshHandler,this);

		if(Ext.isEmpty(this.duration))				// Prem
			this.getStore().load();
		else
			this.getStore().reload();				// Prem

		this.callParent();
	},

	storeRefreshHandler:function(store){
		var index=store.find('events','hours',0,true,false);
		if(index>-1){
			store.removeAt(index);
			store.insert(0,{
				'componentType':'hourCombo',
				'events':'24 hours'
			});
		}
	},

	storeLoadHandler:function(store,records){
		store.insert(0,{
			'componentType':'hourCombo',
//			'componentName':'Components with most events in the last',
			'events':'24 hours'
		});
	}
});