Ext.define('zones.view.ProblemAnalysisProblems', {
	extend: 'utilities.CustomGrid',
	alias:'widget.problemanalysisproblems',
	autoDestroy:true,
	forceFit : true,
	border:false,
	cls:'gridSkin border-right',
	margin:'0 0 0 0',
	//cls:'problem-analysis-problems',
	//bodyCls : 'bottom-left-radius bottom-right-radius zoneDashboardWhiteBg',
	columnLabels:["Layer","Unresolved Problems","Average Duration","Maximum Duration"],
	moreEventsLabel:"Click here for more events",
    viewConfig: {
        getRowClass: function(record, index, rowParams, store) {
			if(record.get('layer').toLowerCase()=="summary"){
				return "row-bold";
			}
			else if ( record.get('layer').toLowerCase() == 'linklayer' )
			{
				return "first-row";
			}
            return '';
        }
    },

	initComponent : function() {
		this.columns=[{
			header:layerLbl,
			menuDisabled: true,
			dataIndex:'layer',
			resizable: true,
			flex:2,
			sortable:false,
			renderer: function(value, metaData, record, rowIndex)
			{
				if ( value == 'linklayer' )
				{
					return "";
				}
				else
				{
					return value;
				}
			}
		},{
			header:openAlarmsLbl,
			menuDisabled: true,
			sortable:false,
			flex:1,
			dataIndex:'unresolvedPrblms'
		},{
			header:avgDurationLbl,
			menuDisabled: true,
			dataIndex:'avgDur',
			resizable: true,
			flex:1,
			sortable:false,
			renderer: function(value, metaData, record, rowIndex)
			{
				if ( record.get('layer') == 'linklayer' )
				{
					var divId = Ext.id();
					var idx = this.store.find('layer','linklayer',0,true,false,false);
					return (Ext.String.format('<div id="{0}" style="position:absolute;right:0px;margin-right:25px;"><b><a href="/final/monitor/EgSiteInfraView.jsp?disphist=yes&fromePage=true" style="text-decoration:underline">'+this.moreEventsLabel+'&nbsp;<img src="/final/images/clear.png" border="0" class="iconTreeRightArrow" style="margin-bottom:-5px"></b></a></div>',divId));
				}
				else
				{
					return value;
				}
			}
		},{
			header:maxDurationLbl,
			menuDisabled: true,
			resizable: true,
			flex:1,
			sortable:false,
			dataIndex:'maxDur'
		}];
		this.callParent();
	},
	afterRender:function(){
		this.getStore().on('load',this.storeLoadHandlerForLink,this);
		this.getStore().load();
		this.callParent();
	},
	storeLoadHandlerForLink:function(store,records){
		//if (store.getCount() >= 4){
			store.insert(0, {'layer':'linklayer'});
		//}
	}
});