Ext.define('zones.view.ZonesDashboard', {
	extend: 'Ext.tab.Panel',
	alias:'widget.zonesdashboard',
	id:'zoneDashboardId',
	autoDestroy:true,
	//style:{'background-color':'#cccccc'},
	//bodyCls:'bottom-right-radius zone-dashboard-tab',
	aggregateTab:false,
	currentZone:null,
	currentTab:null,
	queryValue:null,
	comboValue:null,
	treeUrl:'',
	border:true,
	frame:true,
	padding:0,
	margin:'8 8 0 0',
	cls:'tablayout tabborder',
	flex:4,
	items:[],

	initComponent : function(){
		this.tabBar = {
			items:[{
				xtype: 'tbfill'
			},{
				xtype: 'button',
				cls:'iconBg dashboard-settings-btn',
				iconCls:'iconSettings',
				action: 'maintainance',
				margin:'3 0 0 0',
				hidden:true
			},{
				xtype:'tbseparator',
				margin:6
			},{
				xtype:'button',
				text: requestParams.backButtonText,
				action:'back',
				cls:'backbutton',
				margin:'2 4 2 4',
				iconCls:'iconBack'
				//iconCls:'back-btn-icon'
			}]
		}

		this.items = [];

		this.items.push({
			xtype:'dashboardgeneralmeasuresgridpanel',
			title:!Ext.isEmpty(requestParams.systemTabText)?requestParams.systemTabText:'System',
			url:"/final/monitor/zoneSystem.jsp?treeTitle=zone",
			itemId:'system',
			margin:0,
			cls:'gridHeadercenter',
			padding:0,
			frame:false,
			border:false,
			screenLabelPath:"monitor.zoneDashboard"
		},{
			xtype:'dashboardgeneralmeasuresgridpanel',
			title:!Ext.isEmpty(requestParams.componentsTabText)?requestParams.componentsTabText:'Components',
			itemId:'components',
			margin:0,
			cls:'gridHeadercenter',
			padding:0,
			frame:false,
			border:false,
			screenLabelPath:"monitor.zoneDashboard",
			url:"/final/monitor/zoneComponent.jsp?treeTitle=zone"
		});
		if(this.aggregateTab == true || this.aggregateTab == 'true'){
			this.items.push({
				//xtype:'dashboardgeneralmeasuresgridpanel',
				xtype:'dashboardgeneralmeasuresaggregatepanel',
				title:!Ext.isEmpty(requestParams.aggregatesTabText)?requestParams.aggregatesTabText:aggregatesTabName,
				itemId:'aggregates',
				margin:0,
				cls:'gridHeadercenter',
				padding:0,
				frame:false,
				border:false,
				scroll:true,
				autoScroll:true,
				height:'100%',
				style:{'overflow':'auto','background':'#fff'},
				screenLabelPath:"monitor.zoneDashboard",
				url:"/final/monitor/zoneAggregate.jsp?treeTitle=zone"
			});
		}
		this.items.push({
			xtype:'zonesdetails',
			title:!Ext.isEmpty(requestParams.detailsTabText)?requestParams.detailsTabText:'Details',
			itemId : 'details',
			margin:0,
			padding:0,
			frame:false,
			border:false,
			url : "/final/servlet/com.eg.EgMonitorController?from=ZoneDashboard"

		});

		if(this.currentTab == 'system')
			this.activeTab = 0;
		else if(this.currentTab == 'components')
			this.activeTab = 1;
		else if(this.currentTab == 'aggregates')
			this.activeTab = 2;
		else if(this.currentTab == 'details'){
			if(Ext.isEmpty(this.aggregateTab) || this.aggregateTab == false || this.aggregateTab == 'false')
				this.activeTab = 2;
			else
				this.activeTab = 3;
		}
		this.callParent();
	}
});