Ext.define('zones.view.ZonesTreePanel', {
	extend: 'Ext.panel.Panel',
	alias:'widget.zonestreepanel',
	autoDestroy:true,
	layout : 'fit',
//	cls : 'tree-panel',
	url : null,
	nodeId:null,
	currentNode:null,
	id:'zonestreepanel',
	//treePanelTitle : treePanelTitle,
	initComponent : function(){
		var me = this;
	
		if(requestParams.treeOpen && me.url!=undefined && me.url!=null && me.url!="")
		{
			var resultItems=me.items.items;

			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				if(resultItems[item].id=='select')
				{
					
				//	resultItems[item].destroy();
					resultItems[item].remove();
				}
			}

			me.getEl().mask("Loading..."); 
			holdRefresh=true;
			Ext.Ajax.request({
				url : me.url,
				method : 'POST',
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					jsonData["expanded"] = true;
					jsonData["cls"] = "list-tree-root-expand-collapse";
					var treePanelStore = Ext.create('Ext.data.TreeStore', {
						id:'treestore',
						root : jsonData
					});
					holdRefresh=false;
					var treePanel = Ext.create('utilities.TreeScrollPanel',{
						store : treePanelStore,
						cls:'treePanelDesign',
						margin:'8 0 0 8',
						border : true,
						frame:true,
						scroll:false,
						autoScroll:true,
						iconCls:'zone20_GRAY',
						//title : me.treePanelTitle,
						title:Zones,
						stateId:'zones-tree-panel-stateId',
						rootVisible : true,
						useArrows:true,
						id:'select',
						listeners:{
							beforeItemExpand:function(node){
								var nodeName = node.raw.text;
								openNodes.push(nodeName);
							},
							afterItemCollapse: function(node){
								var nodeName = node.raw.text;
								if(openNodes != null && openNodes.length > 0){
									var index = openNodes.indexOf(nodeName);
									openNodes.splice(index,1);
								}
							}
						}
					});
					me.add(treePanel);
					me.getEl().unmask(); 
				},
				failure : function(response, opts){
					//alert("Zone Tree Failure");
					me.getEl().unmask(); 
					holdRefresh=false;
				}
			});
		}
		this.callParent();
	},
	listeners:{
		expand:function(){
			var me = this;

			var resultItems=me.items.items;

			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				if(resultItems[item].id=='select')
				{
				//	resultItems[item].destroy();
					resultItems[item].remove();
				}
			}

			me.getEl().mask("Loading..."); 
			if(me.url!=undefined && me.url!=null && me.url!="")
			{
				holdRefresh=true;
				Ext.Ajax.request({
					url : me.url,
					method : 'POST',
					success : function(response, opts){
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						jsonData["expanded"] = true;
						jsonData["cls"] = "list-tree-root-expand-collapse";
						var treePanelStore = Ext.create('Ext.data.TreeStore', {
							id:'treestore',
							root : jsonData
						});
						holdRefresh=false;
						var treePanel = Ext.create('utilities.TreeScrollPanel',{
							store : treePanelStore,
							cls:'treePanelDesign',
							margin:'8 0 0 8',
							border : true,
							frame:true,
							scroll:false,
							autoScroll:true,
							iconCls:'zone20_GRAY',
							//title : me.treePanelTitle,
							title:Zones,
							stateId:'zones-tree-panel-stateId',
							rootVisible : true,
							useArrows:true,
							id:'select',
							listeners:{
								beforeItemExpand:function(node){
									var nodeName = node.raw.text;
									openNodes.push(nodeName);
								},
								afterItemCollapse: function(node){
									var nodeName = node.raw.text;
									if(openNodes != null && openNodes.length > 0){
										var index = openNodes.indexOf(nodeName);
										openNodes.splice(index,1);
									}
								}
							}
						});
						me.add(treePanel);

						me.getEl().unmask(); 
					},
					failure : function(response, opts){
						//alert("Zone Tree Failure");
						console.log("Zone Tree Load Failure");
						me.getEl().unmask();
						holdRefresh=false;
					}
				});
			}
		},
		collapse:function()
		{
			var me = this;

			var resultItems=me.items.items;

			for(var item=resultItems.length-1; item>-1 ; item--)
			{
				if(resultItems[item].id=='select')
				{
					//resultItems[item].destroy();
					resultItems[item].remove(true);
					
				}
			}

			holdRefresh=false;
		}
	}
});
