Ext.define('zonesMap.controller.Main',{
	extend : 'Ext.app.Controller',
	requires:['zonesMap.store.ZoneComponentsStore','zonesMap.view.ZoneComponentGrid','zonesMap.view.ZoneMapPanel','zonesMap.view.ZonesTreePanel'],
	views : ['zonesMap.view.Main','zonesMap.view.ErrorPanel'],
	stores : ['ZoneComponentsStore'],
	refs : [{
		ref : 'mainMap',
		selector : 'mainmap'
	}, {
		ref : 'mapPanel',
		selector : 'mainmap panel'
	},{
		ref : 'viewport',
		selector : 'viewport'
	},{
		ref:'zoneTreePanel',
		selector:'zonestreepanel'
	},{
		ref:'zoneTree',
		selector:'zonestreepanel treepanel'
	}],
	refreshFlag:false,
	ZoneComponentsStore:null,
	init : function() {
		this.ZoneComponentsStore=Ext.create('zonesMap.store.ZoneComponentsStore');
		setInterval("execute('"+params+"')",refreshFrequency);
		this.control({
			'mainmap zonemappanel panel' : {
				render : this.onMapPanelRender
			},
			'zonestreepanel button' : {
				click : this.expandTree
			},
			'zonemappanel button[action="back"]' : {
				click:this.backButtonHandler
			},
			'zonestreepanel button[action="open"]' : {
				click:function(){
					this.getZoneTree().expandAll();
				} //iconTreeCollapse; iconTreeExpand;
			},
			'zonestreepanel button[action="close"]' : {
				click:function(){
					this.getZoneTree().collapseAll();
				}
			},
			'zonestreepanel':{
				beforerender:function(){
					if(this.refreshFlag!==true){
						Ext.state.Manager.clear('zones-map-tree-panel-stateId');
					}
				}
			}
		});
	},
	backButtonHandler:function(btn){
		var treeSession=requestParams.treeSession;
		var backButtonFunction="";
		treeSession=(!Ext.isEmpty(treeSession))? treeSession:"";
		if(treeSession.indexOf("showDashboard")>0 )
		{
			backButtonFunction=treeSession;
		}
		if(backButtonFunction.length>0)
		{
			document.location=backButtonFunction;
		}
		else
		{
			if(!Ext.isEmpty(requestParams.refresh) && requestParams.refresh=="true")
			{
				window.history.go(-2);
			}
			else
			{
				window.history.go(-1);
			}
		}
	},
	expandTree : function(button){
		if(button.action == "open"){
		this.getZoneTree().expandAll();
		}else if(button.action == "close"){
			this.getZoneTree().collapseAll();
			this.getZoneTree().getRootNode().expand();
		}
	},
	onMapPanelRender : function(mapPanel) {
		var lat = 0;
		var lng = 0;
		try {
			var myLatLng = {lat: 31.952162, lng: 7.03125};
			map = new google.maps.Map(document.getElementById('zonemap'), {
				zoom: 2,
				center: myLatLng,
				mapTypeControlOptions: 
				{
				  mapTypeIds: [google.maps.MapTypeId.ROAD]
				},
				mapTypeId: MY_MAPTYPE_ID
			});

			/**
			 * To Apply Map Style
			 * 
			*/

			var customMapType = new google.maps.StyledMapType(featureOpts, styledMapOptions);
			map.mapTypes.set(MY_MAPTYPE_ID, customMapType);
			
			/** To get the current zoom level */
			google.maps.event.addListener(map, "zoomend", function() {
				zoomEnd = map.getZoom();
				lat = map.getCenter().lat();
				lng = map.getCenter().lng();
				if (zoomEnd < 2) {
					map.setCenter(myLatLng);
					map.setZoom(2);
				}
			});

			//this.ZoneComponentsStore.on('load',this.createGridPanel,this);
			this.getData();
		} catch (error) {
			var errUrl = "EgMonitorMapError.jsp?s_message=Sorry could not connect map";
			this.showError(errUrl);
		}
	},
	getDataAll : function(flag,refresh) {
		var treePanel=this.getZoneTreePanel();
		var treeCollapsed=!treePanel.getCollapsed();
		var mainPanel=this.getMainMap();
		var borderItems=mainPanel.getLayout().getLayoutItems();
		var treepanel=null;
		for(var i=0;i<borderItems.length;i++){
			var comp=borderItems[i];
			if(comp.region=="west"){
				treepanel=comp;
				break;
			}
		}
		if(!Ext.isEmpty(treepanel)) {
			if (!Ext.isEmpty(parentZone) && false ){
				url = "/final/monitor/Tree.jsp?Zone="+parentZone+"&all="+flag;
			}
			else{
				url = "/final/monitor/Tree.jsp?all="+flag;
			}
			if(fromMyDashboard!=null && fromMyDashboard=='true')
			{
				url=url+'&profileName='+myDashboardName+'&fromPage=mydashboard';
			}
			if(isAnonymousUser!=null && isAnonymousUser=='true')
			{
				url=url+'&anonymousUser=true';
			}
			mainPanel.remove(treepanel);
			if(!Ext.isEmpty(Ext.getCmp('tempTree')))
			{
				Ext.getCmp('tempTree').reset();
				Ext.getCmp('tempTree').destroy();
			}

			mainPanel.add({
				xtype : 'zonestreepanel',
				id:'tempTree',
				url : url,
				border : true,
				frame:false,
				header : false,
				collapsed: !treeCollapsed,
				cls:'removeTreeLeftBorder',
				region : 'west',
				split: true,
				collapsible : true,
				collapseMode :'mini',
				//width: 250,
				flex:1,
				maxWidth:350,
				minWidth : 150
			});
		}
		var url;
		if (!Ext.isEmpty(parentZone) && false){
			url = "/final/monitor/zoneMapCoordinate.jsp?Zone="+parentZone+"&all="+flag;
		}
		else{
			url = "/final/monitor/zoneMapCoordinate.jsp?all="+flag;
		}
		if(fromMyDashboard!=null && fromMyDashboard=='true')
		{
			url=url+'&profileName='+myDashboardName+'&fromPage=mydashboard';
		}
		if(isAnonymousUser!=null && isAnonymousUser=='true')
		{
			url=url+'&anonymousUser=true';
		}

		Ext.Ajax.request({
			url : url,
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				if(!Ext.isEmpty(jsonData) && jsonData.zoneArray != null && jsonData.zoneArray != undefined)
				{
					this.loadStateInfo(jsonData,flag,refresh);
					/*this.reloadStateInformation(
						jsonData.zoneArray,
						jsonData.stateArray,
						jsonData.latitudeArray,
						jsonData.longitudeArray,
						jsonData.southWestGeoCode,
						jsonData.northEastGeoCode,
						jsonData.centerGeoCode,
						jsonData.subZoneMapCount,
						jsonData.subZoneListCount,flag
						);*/
				}
				else
					map.clearOverlays();
			},
			failure:function(){
				map.clearOverlays();
			}
		});
	},
	getData : function() {
		var url;
		if (!Ext.isEmpty(parentZone)){
			url = "/final/monitor/zoneMapCoordinate.jsp?Zone="+parentZone;
			if(fromMyDashboard!=null && fromMyDashboard=='true')
			{
				url=url+'&profileName='+myDashboardName+'&fromPage=mydashboard';
			}
			if(isAnonymousUser!=null && isAnonymousUser=='true')
			{

				url=url+'&anonymousUser=true';
			}
		}
		else{
			url = "/final/monitor/zoneMapCoordinate.jsp";
			if(fromMyDashboard!=null && fromMyDashboard=='true')
			{
				url=url+'?profileName='+myDashboardName+'&fromPage=mydashboard';
			}
			if(isAnonymousUser!=null && isAnonymousUser=='true')
			{
				url=url+'&anonymousUser=true';
			}
		}

		Ext.Ajax.request({
			url : url,
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(!Ext.isEmpty(jsonData.zoneArray) && jsonData.zoneArray != null && jsonData.zoneArray != undefined)
				{
					this.loadStateInfo(jsonData);
					/*this.reloadStateInformation(
						jsonData.zoneArray,
						jsonData.stateArray,
						jsonData.latitudeArray,
						jsonData.longitudeArray,
						jsonData.southWestGeoCode,
						jsonData.northEastGeoCode,
						jsonData.centerGeoCode,
						jsonData.subZoneMapCount,
						jsonData.subZoneListCount);*/
				}
			}
		});
	},
	loadStateInfo:function(data,flag,refresh){
		if(map != undefined && map != null){
			var me = this;

			var center = data.centerGeoCode;
			var latitude = data.latitudeArray;
			var longitude = data.longitudeArray;
			var state = data.stateArray;
			var city = data.zoneArray;
			var subZoneMap = data.subZoneMapCount;

			var southWest = data.southWestGeoCode;
			var northEast = data.northEastGeoCode;
			
			if(latitude.length == 0 && longitude.length == 0)
			{
				//map.setZoom(0);
				//map.clearOverlays();
			}
			else
			{
				if(Ext.isEmpty(refresh))
				{
					var bounds = new google.maps.LatLngBounds();
					for ( var i = 0; i < latitude.length; i++) {
						var point = new google.maps.LatLng(latitude[i],
								longitude[i]);
						bounds.extend(point);
					}
					map.fitBounds(bounds);
					map.setCenter(bounds.getCenter());
					/*sw = new google.maps.LatLng(southWest[0], southWest[1]);
					ne = new google.maps.LatLng(northEast[0], northEast[1]);

					var bounds = new google.maps.LatLngBounds();
					bounds.extend(sw);
					bounds.extend(ne);
					map.fitBounds(bounds);

					if (lat == 0 && lng == 0 ) {
						map.setCenter(new google.maps.LatLng(center[0],
								center[1]));
					} else {
						map.setCenter(new google.maps.LatLng(lat, lng));
					}
					
					if(flag != null && flag!= undefined )
					{
						if(flag == true || flag == 'true')
							zoomLevel = 0;						
						else if(flag == false || flag == 'false'){
							zoomLevel = 0;
						}
					}*/
				}
				
				try
				{
					var _marArr = map.markersArr;
					for(var a in _marArr)
						_marArr[a].setMap(null);

					map.markersArr = [];
				}
				catch (e)
				{
					map.markersArr = [];
				}
				
				
				for ( var i = 0; i < latitude.length; i++) {
					var point = new google.maps.LatLng(latitude[i],
							longitude[i]);
					
					var icon = new Object();

					switch (state[i]) {
					case "GOOD":
						icon.url = "/final/images/"+strSkin+"/map_small_zone_GOOD.gif";
						break;
					case "HIGH":
						icon.url = "/final/images/"+strSkin+"/map_small_zone_HIGH.gif";
						break;
					case "LOW":
						icon.url = "/final/images/"+strSkin+"/map_small_zone_LOW.gif";
						break;
					case "INTERMEDIATE":
						icon.url = "/final/images/"+strSkin+"/map_small_zone_INTERMEDIATE.gif";
						break;
					case "UNKNOWN":
						icon.url = "/final/images/"+strSkin+"/map_small_zone_UNKNOWN.gif";
						break;
					}

					var cityname = city[i];
					var subZoneMapCount = subZoneMap[i];
					
					var queryString = 'zone=' + encodeURI(cityname) + '&subZone='
					+ encodeURI(subZoneMapCount);
					var url = "/final/monitor/alarmWindow.jsp?"+ queryString;

					var marker = new MarkerWithLabel({
						position: point,
						map: map,
						icon: icon.url,
						text:cityname,
						//labelContent:'<div style="border: 2px solid red;color:red">'+cityname+'</div>',
						info:url
					});
					
					map.markersArr.push(marker);

					google.maps.event.addListener(marker, "click", function() {
						if(infoWinArr != null && infoWinArr != undefined && infoWinArr.length > 0){
							for(var p=0;p<infoWinArr.length;p++){
								var ifW = infoWinArr[p];
								ifW.close();
							}
							infoWinArr = new Array();
						}
						Ext.Ajax.request({
							url : this.info,
							scope : this,
							success : function(response) {
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);
								if(!Ext.isEmpty(jsonData)){
									var screenLabels= jsonData.screenLabels;
									var componentArray = jsonData.componentArray;
									var errorObject = jsonData.errorObject;
									var infoHtml='';

									if(screenLabels != null && screenLabels != undefined){
										infoHtml+='';
										if(screenLabels.zoneName != undefined ){
											
											//infoHtml+="<div id='infobox' style='-webkit-box-shadow:none !important;box-shadow:none !important;border:none !important;	height:160px;width:490px;overflow:hidden'>";
											
											infoHtml+="<div id='infobox' style='-webkit-box-shadow:none !important;box-shadow:none !important;border:none !important;	height:150px;width:590px;overflow:hidden'>";
											
											infoHtml+="<table cellpadding='0' cellspacing='0' border='0' class='x-table ' style='list-style:none;margin:0px;padding:3px 0 10px 0;height:27px;' ><tr><td style='width:97%'><div style='font-size:14px;text-align:left;overflow:hidden;text-overflow:ellipsis;white-space: nowrap' ><div style='float:left'>Alerts for Zone :&nbsp;</div> <div style='float:left'><img data-qclass='yellowTip' data-qtip='"+screenLabels.zoneName +"' src='/final/images/clear.png' class='state_"+screenLabels.bulletImageSrc+"' width='15' height='15' border='0' /></div><div style='margin-top:1px;font-weight:100%'>&nbsp;"+screenLabels.zoneName +"</div></div></td> ";
										}
										var zubZone=screenLabels['subZoneMap'];
										var dashBoard=screenLabels['Dashboard'];
										var dashboardHrefLink='';
										var subLinkHrefLink='';
										if(fromMyDashboard!=null && fromMyDashboard=='true')
										{
											dashboardHrefLink="<a style='color: #000000;text-decoration:underline' href='javascript:void(0);' onclick='javascript:goToURL(\""+dashBoard+"\")'> "+screenLabels['admin.zoneMap.Dashboard']+"</a>";

											subLinkHrefLink="<a style='color: #000000;text-decoration:underline' href='javascript:void(0);' onclick='javascript:goToURL(\""+zubZone+"\")'>"+screenLabels['admin.zoneMap.Subzone Map']+"</a>";
										}
										else
										{
											dashboardHrefLink="<a style='color: #000000;text-decoration:underline' href='"+dashBoard+"'> "+screenLabels['admin.zoneMap.Dashboard']+"</a>";

											subLinkHrefLink="<a style='color: #000000;text-decoration:underline' href='"+zubZone+"'>"+screenLabels['admin.zoneMap.Subzone Map']+"</a>";
										}
										if(zubZone != undefined && zubZone != null && zubZone.trim() != '' ){
											infoHtml+="<td><div style='padding-right:13px;font-size:12px;text-align:right;overflow:hidden;text-overflow:ellipsis;white-space: nowrap' >"+subLinkHrefLink+"</a> </div></td>";
										}else{
											infoHtml+="<td>&nbsp;</td>";
										}
										
										infoHtml+="<td><div style='font-size:12px;text-align:right;margin-right:5px;overflow:hidden;text-overflow:ellipsis;white-space: nowrap' > "+dashboardHrefLink+" </div></td> ";
										infoHtml+="</tr></table>";
									
										if(componentArray != undefined && componentArray != null && componentArray.length > 0){
											infoHtml+="<table width='100%' style='border-left:1px solid #e3e3e3;border-right:1px solid #e3e3e3;border-bottom:1px solid #e3e3e3 '>";
											infoHtml+="<tr><td width='23%' style='color: #000000;background: #cdcdcd;padding:4px 0px 2px 10px;border-bottom:1px solid #adadad;border-top:1px solid #adadad;border-right:1px solid #adadad'>Component</td><td style='border-bottom:1px solid #adadad;border-top:1px solid #adadad;border-right:1px solid #adadad;color: #000000;background: #cdcdcd;padding:4px 0px 2px 10px' width='59%'>Description</td><td style='border-bottom:1px solid #adadad;border-top:1px solid #adadad;border-right:0px solid #adadad;color: #000000;background: #cdcdcd;padding:4px 0px 2px 10px' width='15%' >&nbsp;</td></tr></table>";

											infoHtml+="<div width='100%' style='overflow:auto;height:100px;border-left:1px solid #e3e3e3;border-right:1px solid #e3e3e3;border-bottom:1px solid #e3e3e3'><table width='100%' style='display:block;'>";
											for(var p=0;p<componentArray.length;p++){
												var row_det = componentArray[p];
												if(row_det != undefined && row_det != null ){
													
													infoHtml+="<tr >";
													infoHtml+="<td width='23%' style='border-bottom:1px solid #d3d3d3;border-top:1px solid #d3d3d3;color: #000000;padding:2px 0px 0px 10px;'><div style='width:120px;font-size:11px;text-align:left;margin-left:1px;'><div style='float:left;margin-top:0px;position:relative;'><img data-qclass='yellowTip' data-qtip='"+row_det.compName +"' src='/final/images/clear.png' class='state_"+row_det.rowId+"' width='15' height='15' border='0' /></div><div style='margin-top:2px;margin-left:17px;overflow:hidden;white-space:nowrap;text-overflow:ellipsis !important;' data-qclass='yellowTip' data-qtip='"+row_det.compName+"'>&nbsp; "+row_det.compName +"</div></div></td>";

													var hrefDrillDownURL='';

													if(fromMyDashboard!=null && fromMyDashboard=='true')
													{
														hrefDrillDownURL="<a style='color: #000000;' href='javascript:void(0);' onclick='javascript:goToURL(\""+row_det.compDescriptionLink+"\")'>"+row_det.compDescription+" </a>";
													}
													else
													{
														hrefDrillDownURL="<a style='color: #000000;' href='"+row_det.compDescriptionLink+"'>"+row_det.compDescription+" </a>";
													}

													infoHtml+="<td width='59%' style='border-bottom:1px solid #d3d3d3;border-top:1px solid #d3d3d3;color: #000000;padding:2px 0px 0px 10px'><div style='width:360px;font-size:11px;text-align:left;margin-left:0px;margin-top:3px;overflow:hidden;text-overflow:ellipsis !important;white-space:nowrap' data-qclass='yellowTip' data-qtip='"+row_det.qtipText+"'>"+hrefDrillDownURL+"</div></td>";
													
													infoHtml+="<td width='15%' style='border-bottom:1px solid #d3d3d3;border-top:1px solid #d3d3d3;color: #000000;padding:2px 0px 0px 10px;text-align:left;margin-left:0px'><table width='100%'><tr>";
													if(row_det.graphLink != undefined && row_det.graphLink != null && row_det.graphLink != '' && row_det.graphLink != '-'){
														infoHtml+="<td><div class='iconLineChart' style='float:left;margin-top:0px;margin-right:10px;margin-top:2px;cursor:pointer' onclick='javascript:loadPopup(&quot;"+row_det.graphLink+"&quot;);' data-qtip='Graph' data-qclass='yellowTip'></div></td>";
													}

													if(row_det.ddLink != undefined && row_det.ddLink != null && row_det.ddLink != '' && row_det.ddLink != '-'){
														infoHtml+="<td><div class='iconDiagnosis' style='margin-top:2px;float:left;margin-top:0px;cursor:pointer' onclick='javascript:loadPopup(&quot;"+row_det.ddLink+"&quot;);' data-qtip='Diagnosis' data-qclass='yellowTip'></div></td>";
													}

													infoHtml+="</tr></table></td>";
													infoHtml+="</tr>";
												}
											}
											infoHtml+="</table></div></td></tr></table>";
										}
										else
										{
											infoHtml+='<div style="display:table;height:82%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconExclamation"></div><div>No Alerts Found!</div></div></div>'
										}

										infoHtml+="</div>";

										var infowindow =new google.maps.InfoWindow({
											content: infoHtml,
										});
										infowindow.open(map, this);
										infoWinArr.push(infowindow);
									}
								}
							}
						});
					});
				}
			}
		}
	},
	/**
	 * Loads the State Information of the zone and Draws in the
	 * map
	 */
	reloadStateInformation : function(city, state, latitude,
			longitude, southWest, northEast, center,
			subZoneMap, subZoneList,flag) {
		
		if (errorMsg == "noError") {
			if (map != null) {
				if(latitude.length == 0 && longitude.length == 0){
					map.clearOverlays();
				}else{
					/** To set the map area to displayed on the map */
					sw = new GLatLng(southWest[0], southWest[1],
							true);
					ne = new GLatLng(northEast[0], northEast[1],
							true);
					bounds = new GLatLngBounds(sw, ne);
					if (latitude.length > 1) {
						zoomLevel = map.getBoundsZoomLevel(bounds);
					} else {
						zoomLevel = maxZoom;
					}
					if (zoomEnd == 0) {
						zoomLevel = zoomLevel;
					} else {
						zoomLevel = zoomEnd;
					}
					
					if(flag != null && flag!= undefined )
					{
						if(flag == true || flag == 'true')
							zoomLevel = 0;
					}
					map.clearOverlays();
					if (lat == 0 && lng == 0) {
						map.setCenter(new GLatLng(center[0],
								center[1]), zoomLevel);
					} else {
						map.setCenter(new GLatLng(lat, lng),
								zoomLevel);
					}
					for ( var i = 0; i < latitude.length; i++) {
						var point = new GLatLng(latitude[i],
								longitude[i]);
						baseIcon = new GIcon();
						baseIcon.iconSize = new GSize(27, 27);
						baseIcon.iconAnchor = new GPoint(14, 14);
						baseIcon.infoWindowAnchor = new GPoint(3, 3);
						var icon = new GIcon(baseIcon);
						/**
						 * To select the State Icon to be displayed
						 * for the zone
						 */
						switch (state[i]) {
						case "GOOD":
							icon.image = "/final/images/"+strSkin+"/map_small_zone_GOOD.gif";
							break;
						case "HIGH":
							icon.image = "/final/images/"+strSkin+"/map_small_zone_HIGH.gif";
							break;
						case "LOW":
							icon.image = "/final/images/"+strSkin+"/map_small_zone_LOW.gif";
							break;
						case "INTERMEDIATE":
							icon.image = "/final/images/"+strSkin+"/map_small_zone_INTERMEDIATE.gif";
							break;
						case "UNKNOWN":
							icon.image = "/final/images/"+strSkin+"/map_small_zone_UNKNOWN.gif";
							break;
						}

						var cityname = city[i];
						var subZoneMapCount = subZoneMap[i];
						var subZoneListCount = subZoneList[i];
						var mkr = this.call(point, icon, cityname,
								subZoneMapCount, subZoneListCount,
								state[i]);
						map.addOverlay(mkr);
						document.onmousemove = this.positiontip;
					}
				}

			} else {
				this.onMapPanelRender();
			}
		} else if (errorMsg == "noCoordinates") {
			var errUrl ="EgMonitorMapError.jsp?s_message=Zones not cofigured with location details";
			this.showError(errUrl);
		} else {
			var errUrl = "EgMonitorMapError.jsp?s_message=Sorry could not connect map";
			this.showError(errUrl);
		}
	},

	/**
	 * To Show the Alarm Information window, while clicking the
	 * icon on the map
	 */
	call : function(p, i, c, m, l, s) {
		var me = this;
		var queryString = 'zone=' + encodeURI(c) + '&subZone='
				+ encodeURI(m);
		var url = "/final/monitor/alarmWindow.jsp?"+ queryString;
		if(fromMyDashboard!=null && fromMyDashboard=='true')
		{
			url=url+'&profileName='+myDashboardName+'&fromPage=mydashboard';
		}
		if(isAnonymousUser!=null && isAnonymousUser=='true')
		{
			url=url+'&anonymousUser=true';
		}
		var marker = new GMarker(p, i);

		GEvent.addListener(marker, "click", function() {
			popupDivId = Ext.id();
			marker.openInfoWindow("<div class ='popup-style-gmap' style='width:515px;height:170px;overflow:hidden;' id='"+popupDivId+"'></div>");
				Ext.Function.defer(function(){
					var gmnoprints = $('#zonemap img[src*="//maps.gstatic.com/intl/en_ALL/mapfiles/iw3.png"]').attr('src',"/final/images/newInfoWindowBackground.png");
					var markerDivs = $('#'+popupDivId).parent().parent().parent().parent().children();

					$(markerDivs[6]).css("background-color","#ffffff");
					$(markerDivs[6]).css("border-color","#ffffff");
					$(markerDivs[7]).css("background-color","#ffffff");
					$(markerDivs[7]).css("border-color","#ffffff");
					$(markerDivs[8]).css("background-color","#ffffff");
					$(markerDivs[8]).css("border-color","#ffffff");

					Ext.Ajax.request({
						url : url,
						scope : this,
						success : function(response) {
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							if(!Ext.isEmpty(jsonData)){
								var screenLabels= jsonData.screenLabels;
								var errorObject = jsonData.errorObject;
								me.updateLabels(screenLabels);
							}
							if(errorObject["errormessage"] == "noError"){
							me.ZoneComponentsStore.loadRawData(jsonData);
							}else{
								if(me.subZone != ""){
									var dashboardHrefLink='';
									var subLinkHrefLink='';
									if(fromMyDashboard!=null && fromMyDashboard=='true')
									{
										dashboardHrefLink='<a href=\'javascript:void(0);\' onclick=\'javascript:goToURL("'+me.dashboardLink+'")\'>';
										subLinkHrefLink='&nbsp<a href=\'javascript:void(0);\' onclick=\'javascript:goToURL("'+me.subZoneLink+'")\'>';
									}
									else
									{
										dashboardHrefLink='<a href='+me.dashboardLink+'>';
										subLinkHrefLink="&nbsp<a href="+me.subZoneLink+">";
									}

								var tbar = {
												xtype: 'toolbar',
												ui:'dummyTheme',
												cls:'zoneMapToolbar',
												border:false,
												style:{'border':'none !important'},
												docked :'top',
												items : [{
															xtype : 'image',
															width:20,
															style : 'margin-right:5px;margin-left:9px;width:20px',
															cls : 'stateEffect_'+me.imageSrc
														},{
															xtype : 'label',
															text : me.zoneName,
															cls : 'zoneMap-toolbar-zonename'
														},'->',{
															xtype : 'label',
															html : dashboardHrefLink+me.dashboard+"&nbsp</a>",
															cls : 'zoneMap-toolbar-links'
														},{
															xtype : 'tbseparator'
														},{
															xtype : 'label',
															html : subLinkHrefLink+ me.subZone+"</a>",
															cls : 'zoneMap-toolbar-links'
												}]
							}
								}else{
									var dashboardHrefLink='';
									var subLinkHrefLink='';
									if(fromMyDashboard!=null && fromMyDashboard=='true')
									{
										dashboardHrefLink='<a href=\'javascript:void(0);\' onclick=\'javascript:goToURL("'+me.dashboardLink+'")\'>';
										subLinkHrefLink='&nbsp<a href=\'javascript:void(0);\' onclick=\'javascript:goToURL("'+me.subZoneLink+'")\'>';
									}
									else
									{
										dashboardHrefLink='<a href='+me.dashboardLink+'>';
										subLinkHrefLink="&nbsp<a href="+me.subZoneLink+">";
									}
									var tbar = {
											xtype: 'toolbar',
											cls:'zoneMapToolbar',
											border:false,
											style:{'border':'none !important'},
											flex:1,
											margin:0,
											items :[{
													xtype : 'image',
													width:20,
													style : 'margin-right:5px;margin-left:9px;width:20px',
													cls : 'stateEffect_'+me.imageSrc
												},{
													xtype : 'label',
													text : me.zoneName,
													cls : 'zoneMap-toolbar-zonename',
													style:{'margin-top':'-5px'}
												},'->',{
													xtype : 'label',
													html : dashboardHrefLink+me.dashboard+"</a>",
													cls : 'zoneMap-toolbar-links'
												}]
												}
								}
									 Ext.create('zonesMap.view.ErrorPanel',{
													renderTo : popupDivId,
													tbar: tbar,
													cls : 'zone_error_panel',
													height:160,
													items : [{
														xtype:'container',
														style:{'text-align':'center'},
														html:'<div style="margin:45% auto 0% auto !important;" class="zones-map-errorPanel-text"><img src="'+errorObject["errorImage"]+'"/> <br/>'+errorObject["errorMessage"]+'</div>'
													}
/*
														xtype : 'image',
														src : errorObject["errorImage"],
														flex : 2,
														width : '10%',
														cls : 'zones-map-errorPanel-image'
													},{
														xtype : 'label',
														text  : errorObject["errorMessage"],
														width :'18%',
														flex : 2,
														cls : 'zones-map-errorPanel-text'
													}*/
													]
													});

							}
						}
					});
				}, 1000);
		});

		GEvent.addListener(marker, "mouseover", function() {
		me.openTitleWindow(c, "auto", s, window.event);
		});

		GEvent.addListener(marker, "mouseout", function() {
			enabletip = false;
			if(tipobj.style.visibility == "visible")
			tipobj.style.visibility  = "hidden";
		});
		return marker;
	},

	updateLabels : function(screenLabels){
		this.imageSrc = screenLabels["bulletImageSrc"];
		this.zoneName = screenLabels["zoneName"];
		this.dashboard = screenLabels["admin.zoneMap.Dashboard"];
		this.subZone = screenLabels["admin.zoneMap.Subzone Map"];
		this.dashboardLink = screenLabels["Dashboard"];
		this.subZoneLink = screenLabels["subZoneMap"];
	},
	createGridPanel : function (store,records){
		var me=this;
		var dashboardHrefLink='';
		var subLinkHrefLink='';
		if(fromMyDashboard!=null && fromMyDashboard=='true')
		{
			dashboardHrefLink='<a href=\'javascript:void(0);\' onclick=\'javascript:goToURL("'+me.dashboardLink+'")\'>';
			subLinkHrefLink='&nbsp<a href=\'javascript:void(0);\' onclick=\'javascript:goToURL("'+me.subZoneLink+'")\'>';
		}
		else
		{
			dashboardHrefLink='<a href='+me.dashboardLink+'>';
			subLinkHrefLink="&nbsp<a href="+me.subZoneLink+">";
		}

		if(this.subZone != ""){
		var tbar = [{
			xtype:'toolbar',
			ui:'dummyTheme',
			cls:'zoneMapToolbar',
			border:false,
			style:{'border':'none !important'},
			flex:1,
			margin:0,
			items:[
				{
					xtype : 'image',
					width:20,
					style : 'margin-right:5px;margin-left:9px;width:20px',
					cls : 'stateEffect_'+this.imageSrc
				},{
					xtype : 'label',
					text : this.zoneName,
					cls : 'zoneMap-toolbar-zonename'
				},'->',{
					xtype : 'label',
					html : dashboardHrefLink+this.dashboard+"&nbsp</a>",
					cls : 'zoneMap-toolbar-links'
				},{
					xtype : 'tbseparator'
				},{
					xtype : 'label',
					html : subLinkHrefLink+ this.subZone+"</a>",
					cls : 'zoneMap-toolbar-links'
				}]
		}];
		}else{
			var tbar = [{
				xtype:'toolbar',
				cls:'zoneMapToolbar',
				flex:1,
				margin:0,
				items:[
					{
						xtype : 'image',
						width:20,
						style : 'margin-right:5px;margin-left:9px;width:20px',
						cls : 'stateEffect_'+this.imageSrc
					},{
						xtype : 'label',
						text : this.zoneName,
						cls : 'zoneMap-toolbar-zonename'
					},'->',{
						xtype : 'label',
						html : dashboardHrefLink+this.dashboard+"</a>",
						cls : 'zoneMap-toolbar-links'
					}
				]
			}];
		}
	if(document.getElementById('ZoneComponentGrid') == null){
		 var cmpGrid=Ext.getCmp('ZoneComponentGrid');
		 if(!Ext.isEmpty(cmpGrid)){
			 cmpGrid.destroy();
		 }
		 Ext.create('zonesMap.view.ZoneComponentGrid',{
						renderTo : popupDivId,
						border:false,
						scroll:false,
						autoScroll:false,
						margin:0,
						flex:1,
						layout:'fit',
//						style:{'border':'2px solid green'},
						tbar : tbar,
						store:this.ZoneComponentsStore
		 });
		}
	},
	showError : function(errUrl){
		var me = this;
		Ext.Ajax.request({
			url : errUrl,
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var errorPanel = Ext.create('Ext.panel.Panel',{
					border : false,
					html :  '<center><img style="margin-top:200px" src="'+jsonData.imageSrc+'"/><br/><b>'+jsonData.message+'</b></center>'
				});

				me.getViewport().removeAll();
				me.getViewport().add({
					xtype : 'panel',
					layout : 'fit',
					tbar : [{
						xtype : 'label',
						text : 'ZONE MAP',
						cls : 'zone-toolbar-title'
						}],
					items : errorPanel
			});
			}
			});

	},
	openTitleWindow : function(title, width, color, event) {
		var titleLength = title.length;
		//if (titleLength > 10) {
		//	title = title.substring(0, 10);
			//title = title + "...";
		//}
		event = event ? event : window.event;
		if (event == null) {
			event = window.event;
		}
		var s;
		// Set global flags based on browser type and version.
		isMinNS4 = (navigator.appName.indexOf("Netscape") >= 0 && parseFloat(navigator.appVersion) >= 4) ? (browser = "netscape")
				: 0;
		isMinIE4 = (document.all) ? 1 : 0;

		if (isMinIE4) {
			s = navigator.appVersion;
			s = s.substr(s.indexOf("MSIE")).substr(5);
			isMinIE5 = parseFloat(s) >= 5 ? (browser = "ie")
					: 0;
		}
		if (tipobj != null) {
			pointerobj.style.width = "0px";
			pointerobj.style.height = "0px";
			tipobj.style.background = "#fbfbfb";
			tipobj.style.position = "absolute";
			tipobj.style.padding= "2px";
			tipobj.style.zIndex = "100";
			if (typeof width != "undefined")
				tipobj.style.width = width + "px"
			if (document.all)
				tipobj.style.height = "24px";
			else
				tipobj.style.height = "24px";

			switch (color) {
			case "GOOD":
				tipobj.style.border = "2px solid #457e08";
				break;
			case "HIGH":
				tipobj.style.border = "2px solid #cc0000";
				break;
			case "LOW":
				tipobj.style.border = "2px solid #ff9401";
				break;
			case "INTERMEDIATE":
				tipobj.style.border = "2px solid #fe5500";
				break;
			case "UNKNOWN":
				tipobj.style.border = "2px solid #49909f";
				break;
			default:
				tipobj.style.border = "2px solid #3a3a3a";
			}

		}
		tipobj.innerHTML = "<center>" + title + "</center>";
		enabletip = true;
		return false;
	},
	positiontip : function(e) {
		if (enabletip) {
			var nondefaultpos = false

			var curx = (ns6) ? e.pageX : event.clientX
					+ ietruebody().scrollLeft;
			var cury = (ns6) ? e.pageY : event.clientY
					+ ietruebody().scrollTop;

			// Find out how close the mouse is to the corner of
			// the window
			var winwidth = ie && !window.opera ? ietruebody().clientWidth
					: window.innerWidth - 20;
			var winheight = ie && !window.opera ? ietruebody().clientHeight
					: window.innerHeight - 20;

			var rightedge = ie && !window.opera ? winwidth
					- event.clientX - offsetfromcursorX
					: winwidth - e.clientX - offsetfromcursorX;
			var bottomedge = ie && !window.opera ? winheight
					- event.clientY - offsetfromcursorY
					: winheight - e.clientY - offsetfromcursorY;

			var leftedge = (offsetfromcursorX < 0) ? offsetfromcursorX
					* (-1)
					: -1000;

			if (rightedge < tipobj.offsetWidth) {

				tipobj.style.left = curx - tipobj.offsetWidth
						+ "px";
				nondefaultpos = true
			} else if (curx < leftedge)
				tipobj.style.left = "5px";
			else {

				tipobj.style.left = curx + offsetfromcursorX
						- offsetdivfrompointerX + "px";
				pointerobj.style.left = curx
						+ offsetfromcursorX + "px";
			}

			// same concept with the vertical position
			if (bottomedge < tipobj.offsetHeight) {
				tipobj.style.top = cury - tipobj.offsetHeight
						- offsetfromcursorY + "px";
				nondefaultpos = true;
			} else {
				tipobj.style.top = cury + offsetfromcursorY
						+ offsetdivfrompointerY + "px";
				pointerobj.style.top = cury + offsetfromcursorY
						+ "px";
			}
				tipobj.style.visibility = "visible";
			if (!nondefaultpos)
				pointerobj.style.visibility = "visible";
			else
				pointerobj.style.visibility = "hidden";
		}
	},
	refresh : function(flag,refresh){
		if(requestParams.selectedTreeNode != null && requestParams.selectedTreeNode != 'null' && requestParams.selectedTreeNode != ''){
			var zoneTreeURL='/final/monitor/Tree.jsp?Zone='+parentZone;
			if(fromMyDashboard!=null && fromMyDashboard=='true')
			{
				zoneTreeURL=zoneTreeURL+'&profileName='+myDashboardName+'&fromPage=mydashboard';
			}
			if(isAnonymousUser!=null && isAnonymousUser=='true')
			{
				zoneTreeURL=zoneTreeURL+'&anonymousUser=true';
			}
			parentZone = requestParams.selectedTreeNode;
			var treePanel=this.getZoneTreePanel();
			var treeCollapsed=!treePanel.getCollapsed();
			var mainPanel=this.getMainMap();
			mainPanel.remove(treePanel);
			mainPanel.add({
				xtype : 'zonestreepanel',
				id:'tempTree',
				url : zoneTreeURL,
				border : true,
				frame:false,
				header : false,
				collapsed: !treeCollapsed,
				cls:'removeTreeLeftBorder',
				region : 'west',
				split: true,
				collapsible : true,
				collapseMode :'mini',
				//width: 250,
				flex:1,
				maxWidth:350,
				minWidth : 150
			});

			this.getData();
		}
		else{
			this.getDataAll(showSubZone,refresh);
		}
	},
	/*refreshPrev : function(flag){
		this.refreshFlag=true;
		var treePanel=this.getZoneTreePanel();
		var treeCollapsed=!treePanel.getCollapsed();
		var mainPanel=this.getMainMap();
		var borderItems=mainPanel.getLayout().getLayoutItems();
		var treepanel=null;
		for(var i=0;i<borderItems.length;i++){
			var comp=borderItems[i];
			if(comp.region=="west"){
				treepanel=comp;
				break;
			}
		}
		if(!Ext.isEmpty(treepanel)) {
			var treeUrl=treepanel.url;
			mainPanel.remove(treepanel);
			mainPanel.add({
				xtype : 'zonestreepanel',
				url : treeUrl,
				border : true,
				frame:false,
				header : false,
				collapsed: !treeCollapsed,
				cls:'removeTreeLeftBorder',
				region : 'west',
				split: true,
				collapsible : true,
				collapseMode :'mini',
				//width: 250,
				flex:1,
				maxWidth:350,
				minWidth : 150
			});
		}
		map.clearOverlays();
		this.getData();
	}*/
});
