Ext.define('zonesMap.view.ZonesTreePanel', {
	extend: 'Ext.panel.Panel',
	alias:'widget.zonestreepanel',
	layout : 'fit',
	url : null,
	margin:0,
	padding:0,
	bodyPadding:0,
	frame:true,
	border:true,
	flex:1,
	nodeId:null,
	//treePanelTitle : null,
	/*tbar : ['->',{
				xtype : 'button',
				text : 'Open all',
				action : 'open',
				ui : 'custom',
				width : 55,
				cls : 'treePane-Toolbar-Buttons'
		},{
			html  : '&nbsp|&nbsp',
			ui : 'custom'
		},{
			xtype : 'button',
			text : 'Close all',
			action : 'close',
			width : 55,
			ui : 'custom',
			cls : 'treePane-Toolbar-Buttons'
		},'->'],*/
	initComponent : function(){
		var me = this;
		var myFlag=false;
		var myFlagNode;
		
		var curUrl = me.url;
		curUrl = curUrl.substring(curUrl.indexOf("?")+1);
		var urlPram = curUrl.split('&');
		
		var f = false;
		for(var param in urlPram){
			var arParam = urlPram[param];
			var paramKey = arParam.substring(0,arParam.indexOf("="));
			var paramVal = arParam.substring(arParam.indexOf("=")+1);

			paramVal = paramVal.trim();
			if(paramVal == null || paramVal == 'null' )
				continue;

			if(paramKey == null || paramKey == 'null' )
				continue;

			if(paramKey.toLowerCase()=='zone' ){
				requestParams.selectedTreeNode = paramVal;
				f = true;
				break;
			}
		}
		if(f)
			curUrl = "/final/monitor/Tree.jsp?all=true";
		else
			curUrl =  me.url;

		Ext.Ajax.request({
			url : curUrl,
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				jsonData["expanded"] = true;
				jsonData["cls"] = "list-tree-root-expand-collapse";
				var treePanelStore = Ext.create('Ext.data.TreeStore', {
					root : jsonData,
					expanded: true
				});

				var treeTitle='<a href="'+jsonData.link+'">'+jsonData.text+'</a>';
				if(!Ext.isEmpty(jsonData.iconCls)){
					treeTitle='<div class="'+jsonData.iconCls+'"><span class="tree-title">'+treeTitle+'</span></div>';
				}
				var treePanel = Ext.create('utilities.ScrollableTreePanel',{
					itemId : 'treePanel',
					store : treePanelStore,
					selModel: Ext.create("Ext.selection.TreeModel", { mode : 'MULTI'}),
					cls:'treePanelDesign',

					layout : {
							align : 'stretch',
							type : 'vbox'
					},
					scroll: true,
					containerScroll: false,
					autoScroll: false,
					overflowY: 'scroll',
					border : true,
					frame:true,
					flex:1,
					maxWidth:350,
					minWidth : 150,
					width:250,
					margin:'8 0 0 8',
					iconCls:'zone22_GRAY',
					//title : me.treePanelTitle,
					title:'Zones',
					stateId:'zones-map-tree-panel-stateId',
					rootVisible : true,
					useArrows:true,
					collapsed : false,
					expanded: true,
					/* tools:[{
							xtype : 'button',
							action : 'open',
							ui : 'custom',
							cls:'iconTreeExpand',
							width :20
						},{
							html  : '&nbsp|&nbsp',
							ui : 'custom'
						},{
							xtype : 'button',
							cls:'iconTreeCollapse',
							action : 'close',
							width :20,
							ui : 'custom'
						}],*/
					/*tbar : ['->',{
						xtype : 'button',
						text : 'Expand All',
						action : 'open',
						ui : 'custom',
						//width : 55,
						cls : 'treePane-Toolbar-Buttons'
					},{
						html  : '&nbsp|&nbsp',
						ui : 'custom'
					},{
						xtype : 'button',
						text : 'Collapse All',
						action : 'close',
						//width : 55,
						ui : 'custom',
						cls : 'treePane-Toolbar-Buttons'
					},'->'],
					*/
					listeners : {
						afterrender : function(){
							if(!Ext.isEmpty(requestParams.selectedTreeNode))
							{
								var myNode;
								var myRoot = treePanel.getRootNode();
								if(myRoot.raw.text===requestParams.selectedTreeNode)
								{
									myNode=myRoot;
									treePanel.getSelectionModel().select(myNode);
								}
								else
								{
									myNode=myRoot.findChild('text',requestParams.selectedTreeNode);
									if(myNode===null)
									{
										myRoot.eachChild(function(child){
											var getChild=function(child){
												myNode=child.findChild('text',requestParams.selectedTreeNode);
												if(myNode===null){
													child.eachChild(function(innerChild){
														getChild(innerChild);
													});
												}
												else{
													treePanel.getSelectionModel().select(myNode);
												}
											}
											getChild(child);
										});

									}
									else
									{
										treePanel.getSelectionModel().select(myNode);
									}

								}
								if(!Ext.isEmpty(selectedNodeDepth)){
									var selectedNodeDepth=myNode.getDepth();
									var selected=myNode;
									for(var i=0; i < selectedNodeDepth; i++){
										if(selected.isLeaf()){
											selected.parentNode.expand();
										}
										else{
											selected.expand();
										}
										selected=selected.parentNode;
									}
								}
							}
						},
					itemclick:{
						fn:function(view, record, item, index, event)
						{
							var treeCollapsed=!treePanel.getCollapsed();
							var myRoot1 = treePanel.getRootNode();
							nodeId = record.data.text;
							treePanel.expandNode(record);
							this.nodeId = nodeId;
							var myLink=record.raw.link;
							if(fromMyDashboard!=null && fromMyDashboard=="true")
							{
								if(myRoot1.raw.text===nodeId){
									window.parent.location=myLink+"?treeOpen="+treeCollapsed+"&selected="+nodeId+"&fromPage=MyDashboard&backBtnUrl="+encodeURIComponent(myDashboardBackBtnParams);
								}
								else{
									window.parent.location=myLink+"&selected="+nodeId+"&fromPage=MyDashboard&backBtnUrl="+encodeURIComponent(myDashboardBackBtnParams);
								}
							}
							else
							{
								if(myRoot1.raw.text===nodeId){
									document.location=myLink+"?treeOpen="+treeCollapsed+"&selected="+nodeId;
								}
								else{
									document.location=myLink+"&selected="+nodeId;
								}
							}
						}
					}
				}
			});
			me.add(treePanel);
		}
	});

		this.callParent();
	}/*,
	 expandAll : function(){
		alert('hello');
	}*/
});
