/* See license.txt for terms of usage */

require.def("tabs/homeTab", [
    "domplate/domplate",
    "domplate/tabView",
    "core/lib",
    "core/cookies",
    "core/trace",
    "i18n!nls/homeTab",
    "text!tabs/homeTab.html",
    "preview/harModel"
],

function(Domplate, TabView, Lib, Cookies, Trace, Strings, HomeTabHtml, HarModel) { with (Domplate) {

//*************************************************************************************************
// Home Tab
var constLog
function HomeTab() {}
function HomeTab(cont) {//Trace.log("HomeTab ",cont);
constLog = cont}
HomeTab.prototype = Lib.extend(TabView.Tab.prototype,
/** @lends HomeTab */
{
    id: "Home",
    label: Strings.homeTabLabel,

    bodyTag:
        DIV({"class": "homeBody"}),

    onUpdateBody: function(tabView, body)
    {
		Trace.log("apppppppppppppppppppppp");
        body = this.bodyTag.replace({}, body);
		//Trace.log("onUpdateBody ",constLog);
        // Content of this tab is loaded by default (required above) since it's
        // the first thing displayed to the user anyway.
        // Also let's search and replace some constants in the template.
        body.innerHTML = HomeTabHtml.replace("@HAR_SPEC_URL@", tabView.harSpecURL, "g");

		//var inVal='{"log":{"pages":[{"id":"page_3","title":"Snapdeal.com - Online Shopping for Mobiles, Computers, Fashion, Books, Appliances in India","pageTimings":{"onLoad":13295,"onContentLoad":10348},"startedDateTime":"2013-10-18T22:22:28.383+12:00"},{"id":"page_4","title":"Mobiles - Online Mobile Store: Mobile Phones with Prices in India - Snapdeal.com","pageTimings":{"onLoad":13833,"_timeStamps":[{"time":2771,"label":"CSI\/tbsd_"},{"time":2788,"label":"CSI\/_tbnd"}],"onContentLoad":8145,"comment":"_timeStamps field contains timing data generated using console.timeStamp() method. See Firebug documentation: http:\/\/getfirebug.com\/wiki\/index.php\/Console_API"},"startedDateTime":"2013-10-18T22:22:53.987+12:00"},{"id":"page_5","title":"Buy Bluetooth Headset, Handsfree & Bluetooth Devices for Mobile Online - Snapdeal","pageTimings":{"onLoad":11320,"_timeStamps":[{"time":3769,"label":"CSI\/tbsd_"},{"time":3774,"label":"CSI\/_tbnd"}],"onContentLoad":8289,"comment":"_timeStamps field contains timing data generated using console.timeStamp() method. See Firebug documentation: http:\/\/getfirebug.com\/wiki\/index.php\/Console_API"},"startedDateTime":"2013-10-18T22:23:15.399+12:00"},{"id":"page_6","title":"Batteries for Mobile Phones - Buy Mobile Battery Online @ Best Price - Snapdeal.com","pageTimings":{"onLoad":11686,"_timeStamps":[{"time":7382,"label":"CSI\/tbsd_"},{"time":7385,"label":"CSI\/_tbnd"}],"onContentLoad":7569,"comment":"_timeStamps field contains timing data generated using console.timeStamp() method. See Firebug documentation: http:\/\/getfirebug.com\/wiki\/index.php\/Console_API"},"startedDateTime":"2013-10-18T22:23:35.069+12:00"}],"browser":{"name":"Firefox","version":"25.0.1"},"entries":[{"response":{"content":{"text":"","mimeType":"text\/html","size":70654},"headers":[],"bodySize":13923,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":766},"connection":"80","time":4006,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":359,"wait":3642,"receive":5},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/","headersSize":1501},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:28.383+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":107796},"headers":[],"bodySize":21905,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":310},"connection":"80","time":2587,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":2563,"receive":24},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/css\/j1s7\/snapdeal\/snapdeal.all.css","headersSize":304},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:32.537+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":11470},"headers":[],"bodySize":2925,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":309},"connection":"80","time":2167,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":2165,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/css\/j1s7\/snapdeal\/homePage.css","headersSize":300},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:32.537+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":86},"headers":[],"bodySize":38829,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":4364,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":2587,"wait":1760,"receive":17},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/eventImage\/11\/SSF_HP_2.jpg","headersSize":315},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:32.537+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":320318},"headers":[],"bodySize":90602,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":316},"connection":"80","time":4177,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":2586,"wait":1501,"receive":90},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/js\/j1s7\/snapdeal\/all2.js","headersSize":279},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:32.538+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":5577},"headers":[],"bodySize":1453,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":315},"connection":"80","time":2943,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":2586,"wait":357,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/js\/j1s7\/snapdeal\/homePage.js","headersSize":283},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:32.538+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":97},"headers":[],"bodySize":2129,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":304,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":303,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/snapdeal_logo.png?v=5","headersSize":357},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:35.223+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":100},"headers":[],"bodySize":6279,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":1883,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":3,"dns":3,"blocked":1,"wait":1874,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/sprite_hdr_oct13.png?v=4","headersSize":360},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:35.223+12:00"},{"response":{"content":{"text":"","mimeType":"application\/json","size":1479},"headers":[],"bodySize":1479,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":267},"connection":"80","time":327,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":327,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/getTopOffers","headersSize":1768},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:39.107+12:00"},{"response":{"content":{"text":"","mimeType":"application\/json","size":22115},"headers":[],"bodySize":22115,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":271},"connection":"80","time":1199,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":3,"dns":10,"blocked":0,"wait":1185,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/json\/getPersonalizationWidgetData?priority=1&pageType=HOME_PAGE&pogId=1&categoryId=1","headersSize":1840},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:39.107+12:00"},{"response":{"content":{"text":"","mimeType":"application\/json","size":31},"headers":[],"bodySize":31,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":268},"connection":"80","time":621,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":3,"dns":10,"blocked":0,"wait":608,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/json\/getPersonalizationWidgetData?priority=2&pageType=HOME_PAGE&pogId=1&categoryId=1","headersSize":1840},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:39.107+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":86},"headers":[],"bodySize":14977,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":320,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":314,"receive":6},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/homepage\/12\/dealod8dec.jpg","headersSize":315},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:39.108+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":97},"headers":[],"bodySize":13875,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":608,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":603,"receive":5},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/homepage\/12\/celebrityhandbags7dec.jpg","headersSize":326},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:39.108+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":88},"headers":[],"bodySize":10970,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":972,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":1,"dns":72,"blocked":0,"wait":895,"receive":4},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/homepage\/12\/GOSFGOLD7Dec.jpg","headersSize":317},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:39.108+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":97},"headers":[],"bodySize":603,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":755,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":6,"dns":132,"blocked":31,"wait":586,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i4.sdlcdn.com\/img\/storefront\/09\/homefurnishng_13Sep.png","headersSize":326},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:39.685+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":89},"headers":[],"bodySize":1837,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":757,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":169,"wait":588,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i4.sdlcdn.com\/img\/storefront\/12\/Laptop-icon.gif","headersSize":318},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:39.685+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":89},"headers":[],"bodySize":611,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":809,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":169,"wait":640,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i4.sdlcdn.com\/img\/storefront\/09\/coins_13Sep.png","headersSize":318},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:39.685+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":84},"headers":[],"bodySize":1071,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":809,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":169,"wait":640,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i4.sdlcdn.com\/img\/storefront\/09\/icon_3.gif","headersSize":313},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:39.685+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":92},"headers":[],"bodySize":865,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":809,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":169,"wait":640,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i4.sdlcdn.com\/img\/storefront\/11\/icon%20cricket.gif","headersSize":321},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:39.685+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":108},"headers":[],"bodySize":1286,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":762,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":7,"wait":755,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/c\/4\/64x75\/1007677_1374562948_image1-00044.jpg","headersSize":337},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.379+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":126},"headers":[],"bodySize":64540,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":1052,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":1032,"receive":19},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/product\/main\/64x75\/Scandisk_Cruzer_Blade_16GB_Pen_Drive_M_1_2x.jpg","headersSize":355},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.385+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":113},"headers":[],"bodySize":2401,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":700,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":700,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/a\/o\/64x75\/SDL420854308_1363074478_image1-b7847.jpg","headersSize":342},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.390+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":113},"headers":[],"bodySize":1523,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":737,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":737,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/c\/9\/64x75\/SDL103209769_1376052538_image1-d0110.jpg","headersSize":342},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.392+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":113},"headers":[],"bodySize":1493,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":731,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":731,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/c\/9\/64x75\/SDL167659316_1376283647_image1-32503.jpg","headersSize":342},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.393+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":108},"headers":[],"bodySize":1177,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":726,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":726,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/c\/9\/64x75\/1798273_1375938311_image1-ce14d.jpg","headersSize":337},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.395+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":113},"headers":[],"bodySize":1839,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":699,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":699,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/e\/q\/64x75\/SDL274624423_1372845609_image1-f0bf2.jpg","headersSize":342},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.396+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":113},"headers":[],"bodySize":2310,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":711,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":3,"dns":5,"blocked":0,"wait":703,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/d\/f\/64x75\/SDL438753889_1378362297_image1-744f8.jpg","headersSize":342},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.397+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":113},"headers":[],"bodySize":1788,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":715,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":3,"dns":4,"blocked":0,"wait":708,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/e\/9\/64x75\/SDL993930423_1382509581_image1-32208.jpg","headersSize":342},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.398+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":108},"headers":[],"bodySize":1160,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":704,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":3,"dns":2,"blocked":1,"wait":698,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/c\/5\/64x75\/1837900_1375097695_image1-7fb21.jpg","headersSize":337},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.399+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":113},"headers":[],"bodySize":1481,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":717,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":716,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/c\/2\/64x75\/SDL097700031_1373965168_image1-26e85.jpg","headersSize":342},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.400+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":113},"headers":[],"bodySize":1879,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":695,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":6,"dns":1,"blocked":0,"wait":688,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/d\/8\/64x75\/SDL192913241_1376649180_image1-b6ab7.jpg","headersSize":342},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.404+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":76},"headers":[],"bodySize":387,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":350,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":350,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/cod.gif","headersSize":336},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.409+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":100},"headers":[],"bodySize":845,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":351,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":351,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/homaPageLeftCategory\/previous_active.png","headersSize":356},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.410+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":96},"headers":[],"bodySize":845,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":918,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":2,"dns":310,"blocked":0,"wait":606,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/homaPageLeftCategory\/next_active.png","headersSize":352},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:40.412+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":93},"headers":[],"bodySize":41799,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":770,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":757,"receive":12},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/eventImage\/12\/Automotive_8DEc.jpg","headersSize":322},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:42.109+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":96},"headers":[],"bodySize":39751,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":1173,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":1172,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i4.sdlcdn.com\/img\/eventImage\/12\/menss_apparel_9dec.jpg","headersSize":325},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:42.109+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":95},"headers":[],"bodySize":36439,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":1187,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1172,"receive":15},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/eventImage\/12\/Appliances_9Dec_2.jpg","headersSize":324},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:42.110+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":98},"headers":[],"bodySize":42974,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":1233,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1207,"receive":26},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/eventImage\/12\/womens_footwear_9dec.jpg","headersSize":327},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:42.110+12:00"},{"response":{"content":{"text":"","mimeType":"application\/json","size":1479},"headers":[],"bodySize":1479,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":267},"connection":"80","time":400,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":400,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/getTopOffers","headersSize":1768},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:42.110+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":97},"headers":[],"bodySize":4599,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":724,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":5,"dns":0,"blocked":0,"wait":717,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/homepage\/topBannerSprite.png","headersSize":353},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:42.110+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":83},"headers":[],"bodySize":10002,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":497,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":59,"wait":434,"receive":4},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/eventImage\/12\/Canon.jpg","headersSize":312},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:42.199+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":82},"headers":[],"bodySize":8987,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":302},"connection":"80","time":1378,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":15,"dns":1,"blocked":59,"wait":1303,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/eventImage\/12\/Domo.jpg","headersSize":311},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:42.199+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":9371},"headers":[],"bodySize":2775,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":338},"connection":"80","time":514,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":58,"wait":456,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/getFooter","headersSize":1741},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:42.200+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":859},"headers":[],"bodySize":402,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":315},"connection":"80","time":498,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":58,"wait":440,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i4.sdlcdn.com\/js\/j1s7\/snapdeal\/subscription.js","headersSize":287},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:42.200+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":13646},"headers":[],"bodySize":3286,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":338},"connection":"80","time":463,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":73,"wait":390,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/load\/yellowStrip","headersSize":1748},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:43.209+12:00"},{"response":{"content":{"text":"","mimeType":"application\/x-javascript","size":10734},"headers":[],"bodySize":4583,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":454},"connection":"80","time":755,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":5,"dns":41,"blocked":75,"wait":630,"receive":4},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/static.chartbeat.com\/js\/chartbeat.js","headersSize":277},"serverIPAddress":"199.27.76.185","startedDateTime":"2013-10-18T22:22:43.209+12:00"},{"response":{"content":{"text":"","mimeType":"application\/x-javascript","size":174398},"headers":[],"bodySize":58733,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":445},"connection":"80","time":2554,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":6,"dns":99,"blocked":43,"wait":2406,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/connect.facebook.net\/en_US\/all.js#xfbml=1&appId=275135645938863","headersSize":274},"serverIPAddress":"23.209.47.139","startedDateTime":"2013-10-18T22:22:43.241+12:00"},{"response":{"content":{"text":"","mimeType":"application\/javascript","size":95421},"headers":[],"bodySize":29200,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":423},"connection":"80","time":1209,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":5,"dns":100,"blocked":43,"wait":1033,"receive":28},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/platform.twitter.com\/widgets.js","headersSize":272},"serverIPAddress":"93.184.216.139","startedDateTime":"2013-10-18T22:22:43.241+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":88},"headers":[],"bodySize":32839,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":302},"connection":"80","time":676,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":42,"wait":630,"receive":4},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/sprites2.png","headersSize":348},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:43.241+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":100},"headers":[],"bodySize":3057,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":431,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":42,"wait":389,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/snapdeal_logo_footer.gif","headersSize":360},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:43.241+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":363},"headers":[],"bodySize":43,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":140},"connection":"80","time":2626,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1121,"wait":1505,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/ping.chartbeat.net\/ping?h=snapdeal.com&p=%2F&u=6bmzrs6fd34bwxlm&d=snapdeal.com&g=3977&n=1&f=f04fd&c=0&x=0&y=2621&o=1348&w=677&j=45&R=1&W=0&I=0&E=0&e=0&r=&t=3hc701rbi5ylfp0v&V=17&D=vxvp3zvdysp9p695&i=Snapdeal.com%20-%20Online%20Shopping%20for%20Mobiles%2C%20Computers%2C%20Fashion%2C%20Books%2C%20Appliances%20in%20India&_","headersSize":592},"serverIPAddress":"184.73.201.34","startedDateTime":"2013-10-18T22:22:45.802+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":42835},"headers":[],"bodySize":15689,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":317},"connection":"80","time":2626,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1121,"wait":1505,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/js\/j1s7\/omniture\/sd_scode.js","headersSize":283},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:45.802+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":2600},"headers":[],"bodySize":2600,"httpVersion":"HTTP\/1.1","status":403,"redirectURL":"","statusText":"Forbidden","cookies":[],"headersSize":109},"connection":"80","time":1141,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":148,"wait":993,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/platform.twitter.com\/widgets\/follow_button.1384994725.html#_=1382091764991&id=twitter-widget-0&lang=en&screen_name=Snapdeal&show_count=false&show_screen_name=true&size=m","headersSize":359},"serverIPAddress":"93.184.216.139","startedDateTime":"2013-10-18T22:22:47.287+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":8371},"headers":[],"bodySize":3288,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":523},"connection":"80","time":858,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":3,"dns":0,"blocked":384,"wait":471,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.googleadservices.com\/pagead\/conversion.js","headersSize":286},"serverIPAddress":"74.125.236.89","startedDateTime":"2013-10-18T22:22:50.250+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":85},"headers":[],"bodySize":109,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":640,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":166,"wait":474,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/page-overlay.png","headersSize":345},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:50.468+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":104},"headers":[],"bodySize":23203,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":86},"connection":"8008","time":19,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":1,"dns":1,"blocked":5,"wait":8,"receive":4},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/platform.twitter.com:8008\/XX\/YY\/ZZ\/CI\/MGPGHGPGPFGHCDPFGGOGFGEH","headersSize":374},"serverIPAddress":"93.184.216.139","startedDateTime":"2013-10-18T22:22:50.629+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":114},"headers":[],"bodySize":15603,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":86},"connection":"8008","time":18,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":1,"dns":1,"blocked":5,"wait":9,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/platform.twitter.com:8008\/XX\/YY\/ZZ\/CI\/MGPGHGPGPFGHCDPFGGHGFHBGCHEGPFHHGG","headersSize":384},"serverIPAddress":"93.184.216.139","startedDateTime":"2013-10-18T22:22:50.629+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":340},"headers":[],"bodySize":76,"httpVersion":"HTTP\/1.1","status":302,"redirectURL":"http:\/\/googleads.g.doubleclick.net\/pagead\/viewthroughconversion\/992821011\/?random=1863887156&cv=7&fst=1382091771485&num=1&fmt=2&value=0&label=9Y7PCPX7twkQk_602QM&bg=ffffff&hl=en&guid=ON&u_h=768&u_w=1364&u_ah=740&u_aw=1364&u_cd=16&u_his=1&u_tz=720&u_java=false&u_nplug=3&u_nmime=5&frm=0&url=http%3A\/\/www.snapdeal.com\/&ctc_id=CAIVAgAAAB0CAAAA&ct_cookie_present=false&convclickts=0","statusText":"Found","cookies":[],"headersSize":857},"connection":"80","time":148,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":148,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.googleadservices.com\/pagead\/conversion\/992821011\/?random=1382091771485&cv=7&fst=1382091771485&num=1&fmt=2&value=0&label=9Y7PCPX7twkQk_602QM&bg=ffffff&hl=en&guid=ON&u_h=768&u_w=1364&u_ah=740&u_aw=1364&u_cd=16&u_his=1&u_tz=720&u_java=false&u_nplug=3&u_nmime=5&frm=0&url=http%3A\/\/www.snapdeal.com\/","headersSize":599},"serverIPAddress":"74.125.236.89","startedDateTime":"2013-10-18T22:22:52.232+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":25145},"headers":[],"bodySize":9603,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":341},"connection":"80","time":452,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":2,"dns":26,"blocked":64,"wait":351,"receive":9},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.googletagmanager.com\/gtm.js?id=GTM-K4B8ZM","headersSize":286},"serverIPAddress":"74.125.236.126","startedDateTime":"2013-10-18T22:22:52.232+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":668},"headers":[],"bodySize":43,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":668},"connection":"80","time":813,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":2,"dns":153,"blocked":64,"wait":594,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/jasper.112.2o7.net\/b\/ss\/jasper-snapdeal-prd\/1\/H.23.4\/s17838006646246?AQB=1&ndh=1&t=18%2F9%2F2013%2022%3A22%3A51%205%20-720&ce=UTF-8&ns=jasper&pageName=homePage%3Anew&g=http%3A%2F%2Fwww.snapdeal.com%2F&cc=INR&ch=homePage%3Anew&events=event2%2Cevent1%2Cevent19&c1=homepage&c12=homePage%3Anew&v12=homePage%3Anew&v15=avatar09a&c18=0.3%7Cproduction%2Cutmbreak&v21=D%3Ds_vi&v24=19&v35=3%3A30PM%7CFriday%7CWeekday&v42=SD%20India&c56=138535710322150352&v56=mobiles-mobiles-batteries&s=1364x768&c=16&j=1.7&v=N&k=Y&bw=1364&bh=677&p=Google%20Update%3BJava%20Deployment%20Toolkit%206.0.270.7%3BWindows%20Presentation%20Foundation%3B&AQE=1","headersSize":956},"serverIPAddress":"66.235.138.226","startedDateTime":"2013-10-18T22:22:52.232+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":8371},"headers":[],"bodySize":3288,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":523},"connection":"80","time":64,"pageref":"page_3","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":61,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.googleadservices.com\/pagead\/conversion.js","headersSize":286},"serverIPAddress":"74.125.236.89","startedDateTime":"2013-10-18T22:22:52.232+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":608014},"headers":[],"bodySize":63654,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":484},"connection":"80","time":1330,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1248,"receive":82},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/products\/mobiles-mobile-phones","headersSize":2024},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:53.987+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":107796},"headers":[],"bodySize":21905,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":310},"connection":"80","time":746,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":738,"receive":8},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/css\/j1s7\/snapdeal\/snapdeal.all.css","headersSize":334},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:55.493+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":66641},"headers":[],"bodySize":13983,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":310},"connection":"80","time":418,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":407,"receive":11},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/css\/j1s7\/snapdeal\/innerPages.css","headersSize":332},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:55.493+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":15005},"headers":[],"bodySize":2700,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":309},"connection":"80","time":1025,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1023,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/css\/j1s7\/jquery-slider\/jquery.ui.slider.css","headersSize":343},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:55.498+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":24338},"headers":[],"bodySize":5477,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":309},"connection":"80","time":426,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":423,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/css\/j1s7\/snapdeal\/allproduct.css","headersSize":332},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:55.498+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":32904},"headers":[],"bodySize":3951,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":309},"connection":"80","time":438,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":435,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/css\/j1s7\/snapdeal\/categoryStoreFrontLayout.css","headersSize":346},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:55.498+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":1161},"headers":[],"bodySize":551,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":307},"connection":"80","time":435,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":435,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/css\/j1s7\/snapdeal\/csfLayout.css","headersSize":331},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:55.498+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":42014},"headers":[],"bodySize":13282,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":521},"connection":"80","time":1126,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1025,"wait":88,"receive":13},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.googletagservices.com\/tag\/js\/gpt.js","headersSize":310},"serverIPAddress":"74.125.236.89","startedDateTime":"2013-10-18T22:22:55.498+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":92},"headers":[],"bodySize":1340,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":1319,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1025,"wait":294,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/snapdeal\/no-prod-alert-small.png","headersSize":351},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:55.498+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":87},"headers":[],"bodySize":2061,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":1334,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1025,"wait":309,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/snapdeal\/about-category.png","headersSize":346},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:55.498+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":320318},"headers":[],"bodySize":90602,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":316},"connection":"80","time":4975,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1024,"wait":3929,"receive":22},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/js\/j1s7\/snapdeal\/all2.js","headersSize":309},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:55.499+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":49592},"headers":[],"bodySize":7320,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":316},"connection":"80","time":1314,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1024,"wait":282,"receive":8},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/js\/j1s7\/layout\/layout1.js","headersSize":310},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:55.499+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":97},"headers":[],"bodySize":2129,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":356,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":356,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/snapdeal_logo.png?v=5","headersSize":357},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.813+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":97},"headers":[],"bodySize":999,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":356,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":356,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/search\/top-cat-arrow.gif?v=1","headersSize":357},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.813+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":100},"headers":[],"bodySize":6279,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":957,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":6,"dns":1,"blocked":0,"wait":947,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/sprite_hdr_oct13.png?v=4","headersSize":360},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.813+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":91},"headers":[],"bodySize":23394,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":302},"connection":"80","time":2151,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":6,"dns":0,"blocked":1,"wait":2129,"receive":15},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/icon_sprite.png","headersSize":351},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.813+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":84},"headers":[],"bodySize":161,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":603,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":6,"dns":0,"blocked":0,"wait":597,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/bread-arrow.gif","headersSize":344},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.814+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":65092},"headers":[],"bodySize":22162,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":406},"connection":"80","time":288,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":269,"receive":19},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/partner.googleadservices.com\/gpt\/pubads_impl_31.js","headersSize":321},"serverIPAddress":"74.125.236.173","startedDateTime":"2013-10-18T22:22:56.865+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":89},"headers":[],"bodySize":1100,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":308,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":308,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/fil_lft_top_shdw.png","headersSize":347},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.974+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":90},"headers":[],"bodySize":965,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":311,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":311,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/fil_lft_cntr_shdw.png","headersSize":348},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.974+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":78},"headers":[],"bodySize":1119,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":314,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":314,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/minus.gif","headersSize":336},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.974+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":89},"headers":[],"bodySize":1153,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":1203,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":1202,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/fil_lft_btm_shdw.png","headersSize":347},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.974+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":78},"headers":[],"bodySize":1119,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":504,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":195,"wait":309,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/minus.gif","headersSize":338},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.974+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":90},"headers":[],"bodySize":2521,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":504,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":194,"wait":310,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/fltr-icons.png","headersSize":350},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.975+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":94},"headers":[],"bodySize":252,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":639,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":3,"dns":0,"blocked":0,"wait":636,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/allproduct\/indian_rupee_symbol.png","headersSize":352},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.975+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":91},"headers":[],"bodySize":23394,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":302},"connection":"80","time":676,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":664,"receive":12},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/snapdeal\/sprite\/icon_sprite.png","headersSize":363},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:22:56.975+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":545},"headers":[],"bodySize":246,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":524},"connection":"80","time":211,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":210,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/pubads.g.doubleclick.net\/gampad\/ads?gdfp_req=1&correlator=2173993440900999&output=json_html&callback=window.parent.googletag.impl.pubads.setAdContentsBySlotForAsync&impl=fifs&json_a=1&iu_parts=129473952%2C728x90_Ad_Unit_1%2C200x200_Ad_Unit_2&enc_prev_ius=%2F0%2F1%2C%2F0%2F2&prev_iu_szs=728x90%2C200x200&cust_params=category%3Dmobiles%26pagetype%3Dcategory&cookie=ID%3D7af8ac7b0c4c02c4%3AT%3D1385722429%3AS%3DALNI_MYfXc5uk7WEBkQApMZFHFhGN458ew&lmt=1382091775&dt=1382091777282&cc=100&biw=1348&bih=677&oid=3&gut=v2&ifi=1&u_tz=720&u_his=2&u_h=768&u_w=1364&u_ah=740&u_aw=1364&u_cd=16&u_nplug=3&u_nmime=5&u_sd=1&flash=0&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-mobile-phones&ref=http%3A%2F%2Fwww.snapdeal.com%2F&adks=3193233708%2C497154745&vrg=31&vrp=31&ga_vid=875093472.1382091777&ga_sid=1382091777&ga_hid=897947859","headersSize":1176},"serverIPAddress":"74.125.236.186","startedDateTime":"2013-10-18T22:22:57.459+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":93},"headers":[],"bodySize":56344,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":2926,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":2920,"receive":6},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/storefront\/12\/Nokia_Lumia_520.jpg","headersSize":352},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.116+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":105},"headers":[],"bodySize":47489,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":1621,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1603,"receive":18},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/storefront\/12\/storefront_fiesta_theme_240.jpg","headersSize":364},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.116+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":92},"headers":[],"bodySize":46406,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":1364,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1348,"receive":16},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/storefront\/11\/Nokia_Quiz_240.jpg","headersSize":351},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.116+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":87},"headers":[],"bodySize":37308,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":303},"connection":"80","time":1890,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1879,"receive":11},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/storefront\/11\/Reglobe_A.jpg","headersSize":346},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.116+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":93},"headers":[],"bodySize":8841,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":1393,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1389,"receive":4},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/storefront\/11\/storeFront_gosf.png","headersSize":352},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.116+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":6260,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":539,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":538,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/d\/d\/166x194\/SDL474339345_1377761402_image1-a4305.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.125+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":104},"headers":[],"bodySize":4788,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":541,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":538,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/f\/2\/166x194\/xperia_c_blk_M_1_2x-336bf.jpg","headersSize":363},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.126+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":104},"headers":[],"bodySize":4872,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":555,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":555,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/f\/2\/166x194\/xperia_c_wht_M_1_2x-aadc6.jpg","headersSize":363},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.126+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":3253,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":537,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":537,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/SDL453761229_1375079390_image1-bf305.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.126+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":95},"headers":[],"bodySize":4452,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":1534,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1532,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/review\/stars_small.gif?v=1","headersSize":355},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.126+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":76},"headers":[],"bodySize":387,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":538,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":538,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/cod.gif","headersSize":336},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.126+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":80},"headers":[],"bodySize":626,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":555,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":555,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/freebie.gif","headersSize":340},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.126+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":89},"headers":[],"bodySize":1004,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":555,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":555,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/allproduct\/sel-menu-arrow.png","headersSize":347},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.126+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":81},"headers":[],"bodySize":1600,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":575,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":575,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/snapdeal\/pdp\/prev.png","headersSize":353},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.126+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":81},"headers":[],"bodySize":1631,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":1057,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":17,"dns":1,"blocked":0,"wait":1039,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/snapdeal\/pdp\/next.png","headersSize":353},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.126+12:00"},{"response":{"content":{"text":"","mimeType":"image\/x-png","size":115},"headers":[],"bodySize":28121,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":405},"connection":"80","time":2379,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":2368,"receive":10},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/d\/c\/166x194\/SDL849570801_1377258323_image1-38a2f.png","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.126+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":4625,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":587,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":586,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/f\/3\/166x194\/SDL407058756_1384697259_image1-80199.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.127+12:00"},{"response":{"content":{"text":"","mimeType":"image\/x-png","size":100},"headers":[],"bodySize":28416,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":405},"connection":"80","time":2682,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":2669,"receive":13},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/d\/g\/166x194\/Canvas_4_m_1_2x-c346c.png","headersSize":359},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.127+12:00"},{"response":{"content":{"text":"","mimeType":"image\/x-png","size":115},"headers":[],"bodySize":7894,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":404},"connection":"80","time":1173,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1172,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/d\/c\/166x194\/SDL692467157_1377240396_image1-76809.png","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.127+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":82},"headers":[],"bodySize":1539,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":2637,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":16,"dns":1,"blocked":0,"wait":2620,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/csf\/csf-prev-arrow.gif","headersSize":354},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.127+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":82},"headers":[],"bodySize":1540,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":1164,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":16,"dns":1,"blocked":0,"wait":1147,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/csf\/csf-next-arrow.gif","headersSize":354},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.127+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":5244,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":1419,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":16,"dns":0,"blocked":1,"wait":1400,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/e\/3\/166x194\/SDL125221037_1382190103_image1-e41dc.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.127+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":5720,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":1861,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":15,"dns":1,"blocked":1,"wait":1842,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/e\/3\/166x194\/SDL124335423_1382190101_image1-3063e.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.127+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":4942,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":1164,"pageref":"page_4","cache":{},"timings":{"send":1,"connect":15,"dns":0,"blocked":2,"wait":1146,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/SDL238623340_1375079337_image1-86bb4.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.127+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":5169,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":630,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":629,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/d\/y\/166x194\/SDL669951296_1380801009_image1-0a47a.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.128+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":5813,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":1448,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1445,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/g\/d\/166x194\/SDL668125910_1385716104_image1-68ad6.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.128+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":5931,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":1163,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":586,"wait":577,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/g\/d\/166x194\/SDL668211406_1385716098_image1-4ad7a.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.128+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":4535,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":1883,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1882,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/f\/v\/166x194\/1543728_1383305042_image1-a20b6.jpg","headersSize":369},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.128+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":6556,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":661,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":658,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/d\/w\/166x194\/1096171_1375079781_image1-21b9d.jpg","headersSize":369},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.128+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":6441,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":1481,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1163,"wait":317,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/1118480_1375079775_image1-1328a.jpg","headersSize":369},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.128+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":4600,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":672,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":668,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/SDL955371417_1375079492_image1-1f129.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.128+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":5412,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":2012,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":2010,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/1761064_1375079719_image1-276e2.jpg","headersSize":369},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.128+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":5963,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":1493,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1163,"wait":328,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/e\/r\/166x194\/SDL216211631_1381827305_image1-db44b.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.128+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":6016,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":2677,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":11,"dns":5,"blocked":1,"wait":2656,"receive":4},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/e\/r\/166x194\/SDL216165633_1381827304_image1-39a52.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.128+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":5287,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":2712,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":15,"dns":0,"blocked":2,"wait":2693,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/e\/r\/166x194\/SDL216286855_1381827302_image1-47593.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.128+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":116},"headers":[],"bodySize":5510,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":2415,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":535,"wait":1878,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/e\/d\/166x194\/SDL185815927_1381327111_image1-47679.jpeg","headersSize":375},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.129+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":5109,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":2234,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":2232,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/d\/7\/166x194\/SDL469279977_1372075032_image1-56bdf.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.129+12:00"},{"response":{"content":{"text":"","mimeType":"image\/x-png","size":110},"headers":[],"bodySize":27454,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":405},"connection":"80","time":2168,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":10,"dns":5,"blocked":1,"wait":2141,"receive":11},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/a\/d\/166x194\/new_micomax_a35_m_1_2x_ff-affad.png","headersSize":369},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.129+12:00"},{"response":{"content":{"text":"","mimeType":"image\/x-png","size":115},"headers":[],"bodySize":30618,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":405},"connection":"80","time":1508,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":4,"wait":1490,"receive":14},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/d\/l\/166x194\/SDL811402139_1371807658_image1-412ec.png","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.135+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":6673,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":2215,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":12,"wait":2201,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/d\/k\/166x194\/SDL174592288_1369725314_image1-e90e9.jpg","headersSize":374},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.135+12:00"},{"response":{"content":{"text":"","mimeType":"application\/json","size":74},"headers":[],"bodySize":74,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":232},"connection":"80","time":2302,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":2302,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/json\/get\/5?_=1382091782618","headersSize":2059},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:03.355+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":9371},"headers":[],"bodySize":2775,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":338},"connection":"80","time":915,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":373,"wait":542,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/getFooter","headersSize":2018},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:08.729+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":859},"headers":[],"bodySize":402,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":315},"connection":"80","time":915,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":373,"wait":542,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i4.sdlcdn.com\/js\/j1s7\/snapdeal\/subscription.js","headersSize":317},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:08.729+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":88},"headers":[],"bodySize":32839,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":302},"connection":"80","time":1806,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":373,"wait":1433,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/sprites2.png","headersSize":348},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:08.729+12:00"},{"response":{"content":{"text":"","mimeType":"application\/x-javascript","size":174398},"headers":[],"bodySize":58733,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":445},"connection":"80","time":1017,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":212,"wait":748,"receive":57},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/connect.facebook.net\/en_US\/all.js#xfbml=1&appId=275135645938863","headersSize":304},"serverIPAddress":"23.209.47.139","startedDateTime":"2013-10-18T22:23:10.534+12:00"},{"response":{"content":{"text":"","mimeType":"application\/javascript","size":95421},"headers":[],"bodySize":29200,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":423},"connection":"80","time":1495,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":3,"dns":13,"blocked":364,"wait":1089,"receive":26},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/platform.twitter.com\/widgets.js","headersSize":302},"serverIPAddress":"93.184.216.139","startedDateTime":"2013-10-18T22:23:10.535+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":100},"headers":[],"bodySize":3057,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":679,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":285,"wait":394,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/snapdeal_logo_footer.gif","headersSize":360},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:10.611+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":13646},"headers":[],"bodySize":3286,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":338},"connection":"80","time":692,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":286,"wait":404,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/load\/yellowStrip","headersSize":2025},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:10.612+12:00"},{"response":{"content":{"text":"","mimeType":"application\/x-javascript","size":10734},"headers":[],"bodySize":4583,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":452},"connection":"80","time":1310,"pageref":"page_4","cache":{},"timings":{"send":0,"connect":3,"dns":379,"blocked":290,"wait":634,"receive":4},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/static.chartbeat.com\/js\/chartbeat.js","headersSize":307},"serverIPAddress":"199.27.78.185","startedDateTime":"2013-10-18T22:23:10.612+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":218848},"headers":[],"bodySize":30499,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":484},"connection":"80","time":2149,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":2119,"receive":30},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/products\/mobiles-bluetooth","headersSize":2043},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:15.399+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":85},"headers":[],"bodySize":109,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":323,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":323,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/page-overlay.png","headersSize":345},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:16.555+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":107796},"headers":[],"bodySize":21905,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":310},"connection":"80","time":716,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":698,"receive":18},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/css\/j1s7\/snapdeal\/snapdeal.all.css","headersSize":330},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:18.235+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":66641},"headers":[],"bodySize":13983,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":310},"connection":"80","time":379,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":368,"receive":11},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/css\/j1s7\/snapdeal\/innerPages.css","headersSize":328},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:18.235+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":15005},"headers":[],"bodySize":2700,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":309},"connection":"80","time":722,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":720,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/css\/j1s7\/jquery-slider\/jquery.ui.slider.css","headersSize":339},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:18.235+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":24338},"headers":[],"bodySize":5477,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":309},"connection":"80","time":385,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":382,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/css\/j1s7\/snapdeal\/allproduct.css","headersSize":328},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:18.235+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":32904},"headers":[],"bodySize":3951,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":309},"connection":"80","time":397,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":396,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/css\/j1s7\/snapdeal\/categoryStoreFrontLayout.css","headersSize":342},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:18.235+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":1161},"headers":[],"bodySize":551,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":307},"connection":"80","time":400,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":399,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/css\/j1s7\/snapdeal\/csfLayout.css","headersSize":327},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:18.235+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":42014},"headers":[],"bodySize":13282,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":521},"connection":"80","time":812,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":721,"wait":74,"receive":17},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.googletagservices.com\/tag\/js\/gpt.js","headersSize":306},"serverIPAddress":"74.125.236.89","startedDateTime":"2013-10-18T22:23:18.236+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":320318},"headers":[],"bodySize":90602,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":316},"connection":"80","time":2701,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":721,"wait":1903,"receive":77},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/js\/j1s7\/snapdeal\/all2.js","headersSize":305},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:18.236+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":49592},"headers":[],"bodySize":7320,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":316},"connection":"80","time":1449,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":721,"wait":720,"receive":8},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/js\/j1s7\/layout\/layout1.js","headersSize":306},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:18.236+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":97},"headers":[],"bodySize":2129,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":369,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":369,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/snapdeal_logo.png?v=5","headersSize":357},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.186+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":97},"headers":[],"bodySize":999,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":373,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":373,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/search\/top-cat-arrow.gif?v=1","headersSize":357},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.186+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":100},"headers":[],"bodySize":6279,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":399,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":396,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/sprite_hdr_oct13.png?v=4","headersSize":360},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.186+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":91},"headers":[],"bodySize":23394,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":302},"connection":"80","time":1333,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":3,"dns":0,"blocked":0,"wait":1321,"receive":9},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/icon_sprite.png","headersSize":351},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.186+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":84},"headers":[],"bodySize":161,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":710,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":369,"wait":341,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/bread-arrow.gif","headersSize":344},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.186+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":65092},"headers":[],"bodySize":22162,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":406},"connection":"80","time":191,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":174,"receive":17},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/partner.googleadservices.com\/gpt\/pubads_impl_31.js","headersSize":317},"serverIPAddress":"74.125.236.173","startedDateTime":"2013-10-18T22:23:19.203+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":92},"headers":[],"bodySize":1340,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":375,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":375,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/snapdeal\/no-prod-alert-small.png","headersSize":347},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.223+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":87},"headers":[],"bodySize":2061,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":380,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":380,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/snapdeal\/about-category.png","headersSize":342},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.223+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":89},"headers":[],"bodySize":1100,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":378,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":378,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/fil_lft_top_shdw.png","headersSize":347},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.238+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":90},"headers":[],"bodySize":965,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":381,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":381,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/fil_lft_cntr_shdw.png","headersSize":348},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.238+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":78},"headers":[],"bodySize":1119,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":384,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":384,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/minus.gif","headersSize":336},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.238+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":89},"headers":[],"bodySize":1153,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":389,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":389,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/fil_lft_btm_shdw.png","headersSize":347},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.238+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":78},"headers":[],"bodySize":1119,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":661,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":321,"wait":340,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/minus.gif","headersSize":338},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.238+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":90},"headers":[],"bodySize":2521,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":674,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":347,"wait":327,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/fltr-icons.png","headersSize":350},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.238+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":94},"headers":[],"bodySize":252,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":388,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":387,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/allproduct\/indian_rupee_symbol.png","headersSize":352},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.238+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":91},"headers":[],"bodySize":23394,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":302},"connection":"80","time":1025,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1017,"receive":8},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/snapdeal\/sprite\/icon_sprite.png","headersSize":363},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:19.239+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":545},"headers":[],"bodySize":246,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":524},"connection":"80","time":176,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":176,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/pubads.g.doubleclick.net\/gampad\/ads?gdfp_req=1&correlator=2610548494409193&output=json_html&callback=window.parent.googletag.impl.pubads.setAdContentsBySlotForAsync&impl=fifs&json_a=1&iu_parts=129473952%2C728x90_Ad_Unit_1%2C200x200_Ad_Unit_2&enc_prev_ius=%2F0%2F1%2C%2F0%2F2&prev_iu_szs=728x90%2C200x200&cust_params=category%3Dmobiles%26pagetype%3Dcategory&cookie=ID%3D7af8ac7b0c4c02c4%3AT%3D1385722429%3AS%3DALNI_MYfXc5uk7WEBkQApMZFHFhGN458ew&lmt=1382091797&dt=1382091799779&cc=100&biw=1348&bih=677&oid=3&gut=v2&ifi=1&u_tz=720&u_his=3&u_h=768&u_w=1364&u_ah=740&u_aw=1364&u_cd=16&u_nplug=3&u_nmime=5&u_sd=1&flash=0&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth&ref=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-mobile-phones&adks=3193233708%2C497154745&vrg=31&vrp=31&ga_vid=1041868066.1382091800&ga_sid=1382091800&ga_hid=2146838697","headersSize":1202},"serverIPAddress":"74.125.236.186","startedDateTime":"2013-10-18T22:23:20.239+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":3439,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":319,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":319,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/1719059_1375098107_image1-6ba11.jpg","headersSize":365},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:25.056+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":5230,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":312,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":311,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/e\/l\/166x194\/SDL712771056_1381495438_image1-0a51b.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:25.056+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":3446,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":333,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":333,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/SDL865297680_1375099758_image1-af79d.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:25.056+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":2834,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":326,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":326,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/1226238_1375097884_image1-d86b1.jpg","headersSize":365},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:25.056+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":95},"headers":[],"bodySize":4452,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":344,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":342,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/review\/stars_small.gif?v=1","headersSize":355},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:25.056+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":76},"headers":[],"bodySize":387,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":346,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":345,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/cod.gif","headersSize":336},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:25.056+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":81},"headers":[],"bodySize":1600,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":349,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":349,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/snapdeal\/pdp\/prev.png","headersSize":353},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:25.057+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":81},"headers":[],"bodySize":1631,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":352,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":352,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/snapdeal\/pdp\/next.png","headersSize":353},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:25.058+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":6044,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":364,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":361,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/f\/d\/166x194\/SDL605594296_1382682223_image1-b11aa.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:25.058+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":4569,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":385,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":383,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/e\/2\/166x194\/SDL474171282_1382091972_image1-9e187.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:25.060+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":3086,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":699,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":697,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/e\/q\/166x194\/SDL822447404_1381819622_image1-860f8.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:25.061+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":9371},"headers":[],"bodySize":2775,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":338},"connection":"80","time":386,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":384,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/getFooter","headersSize":2007},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:27.379+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":859},"headers":[],"bodySize":402,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":315},"connection":"80","time":334,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":334,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i4.sdlcdn.com\/js\/j1s7\/snapdeal\/subscription.js","headersSize":313},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:27.379+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":88},"headers":[],"bodySize":32839,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":302},"connection":"80","time":1075,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":1074,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/sprites2.png","headersSize":348},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:27.379+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":13646},"headers":[],"bodySize":3286,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":338},"connection":"80","time":702,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":197,"wait":504,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/load\/yellowStrip","headersSize":2014},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:29.259+12:00"},{"response":{"content":{"text":"","mimeType":"application\/x-javascript","size":10734},"headers":[],"bodySize":4583,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":452},"connection":"80","time":1023,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":4,"dns":1,"blocked":198,"wait":815,"receive":5},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/static.chartbeat.com\/js\/chartbeat.js","headersSize":303},"serverIPAddress":"199.27.78.185","startedDateTime":"2013-10-18T22:23:29.259+12:00"},{"response":{"content":{"text":"","mimeType":"application\/x-javascript","size":174398},"headers":[],"bodySize":58733,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":445},"connection":"80","time":1131,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":197,"wait":863,"receive":71},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/connect.facebook.net\/en_US\/all.js#xfbml=1&appId=275135645938863","headersSize":300},"serverIPAddress":"23.209.47.139","startedDateTime":"2013-10-18T22:23:29.259+12:00"},{"response":{"content":{"text":"","mimeType":"application\/javascript","size":95421},"headers":[],"bodySize":29200,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":423},"connection":"80","time":1591,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":4,"dns":1,"blocked":198,"wait":1358,"receive":30},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/platform.twitter.com\/widgets.js","headersSize":298},"serverIPAddress":"93.184.216.139","startedDateTime":"2013-10-18T22:23:29.259+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":100},"headers":[],"bodySize":3057,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":671,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":197,"wait":474,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/snapdeal_logo_footer.gif","headersSize":360},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:29.259+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":424},"headers":[],"bodySize":43,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":140},"connection":"80","time":659,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":23,"wait":636,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/ping.chartbeat.net\/ping?h=snapdeal.com&p=%2Fproducts%2Fmobiles-bluetooth&u=6bmzrs6fd34bwxlm&d=snapdeal.com&g=3977&n=1&f=f04fd&c=0&x=0&y=2188&o=1348&w=677&j=45&R=1&W=0&I=0&E=0&e=0&v=%2Fproducts%2Fmobiles-mobile-phones&K=218::318&t=aoaqcqj5e8s3actm&V=17&D=8iliunargdt82gic&i=Buy%20Bluetooth%20Headset%2C%20Handsfree%20%26%20Bluetooth%20Devices%20for%20Mobile%20Online%20-%20Snapdeal&_","headersSize":679},"serverIPAddress":"184.73.201.34","startedDateTime":"2013-10-18T22:23:30.327+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":42835},"headers":[],"bodySize":15689,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":317},"connection":"80","time":588,"pageref":"page_5","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":581,"receive":6},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/js\/j1s7\/omniture\/sd_scode.js","headersSize":309},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:30.328+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":267052},"headers":[],"bodySize":45965,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":484},"connection":"80","time":4446,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":395,"wait":4012,"receive":39},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/products\/mobiles-batteries","headersSize":2106},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:35.069+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":85},"headers":[],"bodySize":109,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":283,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":282,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/page-overlay.png","headersSize":345},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:35.543+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":107796},"headers":[],"bodySize":21905,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":310},"connection":"80","time":559,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":550,"receive":9},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/css\/j1s7\/snapdeal\/snapdeal.all.css","headersSize":330},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:39.633+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":24338},"headers":[],"bodySize":5477,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":309},"connection":"80","time":301,"pageref":"page_6","cache":{},"timings":{"send":1,"connect":0,"dns":0,"blocked":0,"wait":297,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/css\/j1s7\/snapdeal\/allproduct.css","headersSize":328},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:39.633+12:00"},{"response":{"content":{"text":"","mimeType":"text\/css","size":15005},"headers":[],"bodySize":2700,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":309},"connection":"80","time":311,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":306,"receive":5},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/css\/j1s7\/jquery-slider\/jquery.ui.slider.css","headersSize":339},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:39.634+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":42014},"headers":[],"bodySize":13282,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":521},"connection":"80","time":634,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":559,"wait":62,"receive":13},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.googletagservices.com\/tag\/js\/gpt.js","headersSize":306},"serverIPAddress":"74.125.236.89","startedDateTime":"2013-10-18T22:23:39.634+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":75},"headers":[],"bodySize":3208,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":899,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":559,"wait":340,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/ajax-loader.gif","headersSize":330},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:39.634+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":320318},"headers":[],"bodySize":90602,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":316},"connection":"80","time":2338,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":559,"wait":1688,"receive":91},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/js\/j1s7\/snapdeal\/all2.js","headersSize":305},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:39.634+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":20322},"headers":[],"bodySize":6078,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":316},"connection":"80","time":898,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":559,"wait":306,"receive":33},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/js\/j1s7\/jquery\/jquery-ui-1.8.16-slider.js","headersSize":322},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:39.634+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":92},"headers":[],"bodySize":1340,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":536,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":536,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/snapdeal\/no-prod-alert-small.png","headersSize":347},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.883+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":87},"headers":[],"bodySize":2061,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":488,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":487,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i3.sdlcdn.com\/img\/snapdeal\/about-category.png","headersSize":342},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.883+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":97},"headers":[],"bodySize":2129,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":487,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":487,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/snapdeal_logo.png?v=5","headersSize":357},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.884+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":97},"headers":[],"bodySize":999,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":1122,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1122,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/search\/top-cat-arrow.gif?v=1","headersSize":357},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.884+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":100},"headers":[],"bodySize":6279,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":507,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":505,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/sprite_hdr_oct13.png?v=4","headersSize":360},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.884+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":91},"headers":[],"bodySize":23394,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":302},"connection":"80","time":2177,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":2167,"receive":10},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/icon_sprite.png","headersSize":351},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.884+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":84},"headers":[],"bodySize":161,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":535,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":535,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/bread-arrow.gif","headersSize":344},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.884+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":89},"headers":[],"bodySize":1100,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":535,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":535,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/fil_lft_top_shdw.png","headersSize":347},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.884+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":90},"headers":[],"bodySize":965,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":535,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":535,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/fil_lft_cntr_shdw.png","headersSize":348},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.884+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":78},"headers":[],"bodySize":1119,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":535,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":535,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/minus.gif","headersSize":336},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.884+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":89},"headers":[],"bodySize":1153,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":1311,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":1310,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/fil_lft_btm_shdw.png","headersSize":347},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.884+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":78},"headers":[],"bodySize":1119,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":1089,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":506,"wait":583,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/minus.gif","headersSize":338},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.885+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":90},"headers":[],"bodySize":2521,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":1096,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":535,"wait":561,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/fltr-icons.png","headersSize":350},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.885+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":94},"headers":[],"bodySize":252,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":535,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":535,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/allproduct\/indian_rupee_symbol.png","headersSize":352},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.885+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":94},"headers":[],"bodySize":525,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":1047,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":4,"dns":0,"blocked":0,"wait":1043,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/search\/searchIco-grey.png","headersSize":352},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.886+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":95},"headers":[],"bodySize":126,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":1092,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":533,"wait":559,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/gridView\/list-view-ico.png","headersSize":353},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.886+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":95},"headers":[],"bodySize":135,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":1090,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":533,"wait":557,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/snapdeal\/gridView\/grid-view-ico.png","headersSize":353},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.886+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":107},"headers":[],"bodySize":1323,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":302},"connection":"80","time":1044,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":485,"wait":559,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/filterCategory\/Dotted_sep_repeat_x.jpg","headersSize":367},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:40.886+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":65092},"headers":[],"bodySize":22162,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":406},"connection":"80","time":117,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":96,"receive":21},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/partner.googleadservices.com\/gpt\/pubads_impl_31.js","headersSize":317},"serverIPAddress":"74.125.236.173","startedDateTime":"2013-10-18T22:23:43.657+12:00"},{"response":{"content":{"text":"","mimeType":"application\/json","size":54},"headers":[],"bodySize":54,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":232},"connection":"80","time":767,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":766,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"POST","cookies":[],"url":"http:\/\/www.snapdeal.com\/json\/checkAuthentication","headersSize":2176},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.684+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":75},"headers":[],"bodySize":3208,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":308,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":306,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/ajax-loader.gif","headersSize":333},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.836+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":95},"headers":[],"bodySize":4452,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":315,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":314,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/review\/stars_small.gif?v=1","headersSize":355},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.837+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":95},"headers":[],"bodySize":1177,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":318,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":318,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/allproduct\/discount_arrow_small.gif","headersSize":353},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.837+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":76},"headers":[],"bodySize":387,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":322,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":322,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/cod.gif","headersSize":336},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.837+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":83},"headers":[],"bodySize":3804,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":330,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":328,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i1.sdlcdn.com\/img\/shipping\/fltr-icons.png","headersSize":341},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.837+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":3093,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":362,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":361,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/d\/b\/166x194\/SDL418212096_1376496122_image1-bc858.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.837+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":4300,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":338,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":337,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/SDL145658507_1375098585_image1-7a6a1.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.837+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":2961,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":345,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":343,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/d\/b\/166x194\/SDL423391590_1376496137_image1-cba14.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.837+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":2474,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":351,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":351,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/d\/t\/166x194\/SDL193200416_1380170577_image1-e01d5.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.837+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":5102,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":374,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":371,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/d\/l\/166x194\/SDL005138168_1371811379_image1-8c620.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.837+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":4597,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":388,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":386,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/d\/b\/166x194\/SDL518060999_1376496167_image1-662bd.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.838+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":4607,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":382,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":381,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/d\/b\/166x194\/SDL520842794_1376496139_image1-1cb6b.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.838+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":3981,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":782,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":781,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/1719056_1375098104_image1-37a97.jpg","headersSize":365},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.838+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":4568,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":417,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":416,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/1046753_1375098497_image1-1422a.jpg","headersSize":365},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.838+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":4475,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":436,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":433,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/d\/7\/166x194\/1046750_1375098492_image1-c76b0.jpg","headersSize":365},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.838+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":3366,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":441,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":440,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/d\/b\/166x194\/SDL422955023_1376496134_image1-01544.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.838+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":4453,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":823,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":821,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n2.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/1741211_1375096889_image1-0ce7b.jpg","headersSize":365},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.838+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":5463,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":791,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":790,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/d\/7\/166x194\/1044795_1375097819_image1-fe9c9.jpg","headersSize":365},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.838+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":3872,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":455,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":454,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/d\/b\/166x194\/SDL422055279_1376496136_image1-4f16d.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.838+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":4733,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":466,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":464,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/f\/c\/166x194\/SDL209076401_1382679033_image1-d9f50.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.838+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":5055,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":476,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":474,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/1266930_1375098556_image1-fa6f9.jpg","headersSize":365},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.839+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":2955,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":481,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":481,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n1.sdlcdn.com\/imgs\/a\/d\/b\/166x194\/SDL423161147_1376496154_image1-b3e18.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.839+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":4245,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":796,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":794,"receive":2},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/1046745_1375098572_image1-b3f6e.jpg","headersSize":365},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:43.839+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":110},"headers":[],"bodySize":2693,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":800,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":800,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n4.sdlcdn.com\/imgs\/a\/c\/5\/166x194\/1787718_1375096122_image1-764b2.jpg","headersSize":365},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:44.092+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":115},"headers":[],"bodySize":2950,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":403},"connection":"80","time":518,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":88,"wait":429,"receive":1},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/n3.sdlcdn.com\/imgs\/a\/d\/b\/166x194\/SDL422488723_1376496118_image1-02686.jpg","headersSize":370},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:44.094+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":783},"headers":[],"bodySize":251,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":526},"connection":"80","time":137,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":137,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/pubads.g.doubleclick.net\/gampad\/ads?gdfp_req=1&correlator=1250895814044273&output=json_html&callback=window.parent.googletag.impl.pubads.setAdContentsBySlotForAsync&impl=fifs&json_a=1&iu_parts=129473952%2C728x90_Ad_Unit_1%2C200x200_Ad_Unit_2&enc_prev_ius=%2F0%2F1%2C%2F0%2F2%2C%2F0%2F1&prev_iu_szs=728x90%2C200x200%2C728x90&cust_params=category%3Dmobiles%26pagetype%3Dcategory&cookie=ID%3D7af8ac7b0c4c02c4%3AT%3D1385722429%3AS%3DALNI_MYfXc5uk7WEBkQApMZFHFhGN458ew&lmt=1382091819&dt=1382091824059&cc=100&biw=1348&bih=677&oid=3&gut=v2&ifi=1&u_tz=720&u_his=4&u_h=768&u_w=1364&u_ah=740&u_aw=1364&u_cd=16&u_nplug=3&u_nmime=5&u_sd=1&flash=0&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries&ref=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth&adks=3193233708%2C497154745%2C3193233706&vrg=31&vrp=31&ga_vid=1450681779.1382091824&ga_sid=1382091824&ga_hid=1097379850","headersSize":1231},"serverIPAddress":"74.125.236.186","startedDateTime":"2013-10-18T22:23:45.145+12:00"},{"response":{"content":{"text":"","mimeType":"application\/xml","size":0},"headers":[],"bodySize":0,"httpVersion":"HTTP\/1.1","status":204,"redirectURL":"","statusText":"No Content","cookies":[],"headersSize":169},"connection":"80","time":886,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":886,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/json\/get\/promoWindowCategory?url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries","headersSize":2182},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:47.008+12:00"},{"response":{"content":{"text":"","mimeType":"","size":268},"headers":[],"bodySize":0,"httpVersion":"","status":0,"redirectURL":"","statusText":"Aborted","cookies":[],"headersSize":-1},"connection":"443","time":655,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":176,"dns":0,"blocked":13,"wait":466,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"https:\/\/l.snapdeal.com\/lg\/all?callback=jsonp1382091822181&_=1382091826891&u=138535710322150352&ref=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries<=7.142","headersSize":1614},"serverIPAddress":"46.137.206.41","startedDateTime":"2013-10-18T22:23:47.239+12:00"},{"response":{"content":{"text":"","mimeType":"","size":147},"headers":[],"bodySize":0,"httpVersion":"","status":0,"redirectURL":"","statusText":"Aborted","cookies":[],"headersSize":-1},"connection":"443","time":556,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":176,"dns":0,"blocked":13,"wait":367,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"https:\/\/l.snapdeal.com\/lg\/iuv?callback=callback&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries","headersSize":1493},"serverIPAddress":"46.137.206.41","startedDateTime":"2013-10-18T22:23:47.239+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":9371},"headers":[],"bodySize":2775,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":338},"connection":"80","time":556,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":12,"wait":544,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/getFooter","headersSize":2074},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:47.239+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":859},"headers":[],"bodySize":402,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":315},"connection":"80","time":556,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":12,"wait":544,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i4.sdlcdn.com\/js\/j1s7\/snapdeal\/subscription.js","headersSize":313},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:47.239+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":88},"headers":[],"bodySize":32839,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":302},"connection":"80","time":1245,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":10,"wait":1235,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/sprites2.png","headersSize":348},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:47.241+12:00"},{"response":{"content":{"text":"","mimeType":"","size":87},"headers":[],"bodySize":0,"httpVersion":"","status":0,"redirectURL":"","statusText":"Aborted","cookies":[],"headersSize":-1},"connection":"443","time":934,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":176,"dns":0,"blocked":11,"wait":747,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"https:\/\/i4.sdlcdn.com\/img\/storefront\/12\/suitcase.png","headersSize":341},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:47.241+12:00"},{"response":{"content":{"text":"","mimeType":"","size":91},"headers":[],"bodySize":0,"httpVersion":"","status":0,"redirectURL":"","statusText":"Aborted","cookies":[],"headersSize":-1},"connection":"443","time":991,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":175,"dns":1,"blocked":11,"wait":804,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"https:\/\/i4.sdlcdn.com\/img\/storefront\/11\/gadgets_icon.gif","headersSize":345},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:47.241+12:00"},{"response":{"content":{"text":"","mimeType":"","size":92},"headers":[],"bodySize":0,"httpVersion":"","status":0,"redirectURL":"","statusText":"Aborted","cookies":[],"headersSize":-1},"connection":"443","time":1158,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":175,"dns":1,"blocked":10,"wait":972,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"https:\/\/i2.sdlcdn.com\/img\/storefront\/11\/icon_hook_SSF.png","headersSize":346},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:47.242+12:00"},{"response":{"content":{"text":"","mimeType":"application\/x-javascript","size":174398},"headers":[],"bodySize":58733,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":445},"connection":"80","time":924,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":5,"wait":878,"receive":41},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/connect.facebook.net\/en_US\/all.js#xfbml=1&appId=275135645938863","headersSize":300},"serverIPAddress":"23.209.47.139","startedDateTime":"2013-10-18T22:23:47.889+12:00"},{"response":{"content":{"text":"","mimeType":"application\/javascript","size":95421},"headers":[],"bodySize":29200,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":423},"connection":"80","time":3023,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":5,"dns":1,"blocked":6,"wait":2975,"receive":36},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/platform.twitter.com\/widgets.js","headersSize":298},"serverIPAddress":"93.184.216.139","startedDateTime":"2013-10-18T22:23:47.889+12:00"},{"response":{"content":{"text":"","mimeType":"","size":72},"headers":[],"bodySize":0,"httpVersion":"","status":0,"redirectURL":"","statusText":"Aborted","cookies":[],"headersSize":-1},"connection":"443","time":597,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":5,"dns":1,"blocked":6,"wait":585,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"https:\/\/apis.google.com\/js\/plusone.js","headersSize":514},"serverIPAddress":"74.125.236.195","startedDateTime":"2013-10-18T22:23:47.889+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":13646},"headers":[],"bodySize":3286,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":338},"connection":"80","time":1586,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":4,"wait":1582,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.snapdeal.com\/load\/yellowStrip","headersSize":2081},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:47.890+12:00"},{"response":{"content":{"text":"","mimeType":"application\/x-javascript","size":10734},"headers":[],"bodySize":4583,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":452},"connection":"80","time":1296,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":5,"dns":1,"blocked":5,"wait":1280,"receive":5},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/static.chartbeat.com\/js\/chartbeat.js","headersSize":303},"serverIPAddress":"199.27.78.185","startedDateTime":"2013-10-18T22:23:47.890+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":100},"headers":[],"bodySize":3057,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":301},"connection":"80","time":519,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":5,"wait":514,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/sprite\/snapdeal_logo_footer.gif","headersSize":360},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:47.890+12:00"},{"response":{"content":{"text":"","mimeType":"","size":253},"headers":[],"bodySize":0,"httpVersion":"","status":0,"redirectURL":"","statusText":"Aborted","cookies":[],"headersSize":-1},"connection":"443","time":855,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":3,"dns":0,"blocked":0,"wait":852,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"https:\/\/s-static.ak.facebook.com\/connect\/xd_arbiter.php?version=28#channel=fe562fefb1ad58&channel_path=%2Fproducts%2Fmobiles-batteries%3Ffb_xd_fragment%23xd_sig%3Df20db34763ef11c%26&origin=http%3A%2F%2Fwww.snapdeal.com","headersSize":385},"serverIPAddress":"23.209.34.110","startedDateTime":"2013-10-18T22:23:49.927+12:00"},{"response":{"content":{"text":"","mimeType":"","size":412},"headers":[],"bodySize":0,"httpVersion":"","status":0,"redirectURL":"","statusText":"Aborted","cookies":[],"headersSize":-1},"connection":"443","time":2347,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":3,"dns":0,"blocked":1,"wait":2343,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"https:\/\/www.facebook.com\/connect\/ping?client_id=275135645938863&domain=www.snapdeal.com&origin=1&redirect_uri=http%3A%2F%2Fstatic.ak.facebook.com%2Fconnect%2Fxd_arbiter.php%3Fversion%3D28%23cb%3Df3bd7ed4a539a46%26domain%3Dwww.snapdeal.com%26origin%3Dhttp%253A%252F%252Fwww.snapdeal.com%252Ffe562fefb1ad58%26relation%3Dparent&response_type=token%2Csigned_request%2Ccode&sdk=joey","headersSize":696},"serverIPAddress":"66.220.152.19","startedDateTime":"2013-10-18T22:23:49.929+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":424},"headers":[],"bodySize":43,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":140},"connection":"80","time":421,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":421,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/ping.chartbeat.net\/ping?h=snapdeal.com&p=%2Fproducts%2Fmobiles-batteries&u=6bmzrs6fd34bwxlm&d=snapdeal.com&g=3977&n=1&f=f04fd&c=0&x=0&y=3021&o=1348&w=677&j=45&R=1&W=0&I=0&E=0&e=0&v=%2Fproducts%2Fmobiles-bluetooth&K=218::385&t=8cbyxhmijxw4z1x1&V=17&D=aoaqcqj5e8s3actm&i=Batteries%20for%20Mobile%20Phones%20-%20Buy%20Mobile%20Battery%20Online%20%40%20Best%20Price%20-%20Snapdeal.com&_","headersSize":679},"serverIPAddress":"184.73.201.34","startedDateTime":"2013-10-18T22:23:50.135+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":42835},"headers":[],"bodySize":15689,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":317},"connection":"80","time":731,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":719,"receive":12},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/js\/j1s7\/omniture\/sd_scode.js","headersSize":309},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:50.135+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":4},"headers":[],"bodySize":24,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":864},"connection":"80","time":486,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":486,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.vizury.com\/analyze\/analyze.php?account_id=VIZVRM98m=e200&catid=678&subcat1id=&subcat2id=ion=1&level=2","headersSize":1112},"serverIPAddress":"75.126.75.212","startedDateTime":"2013-10-18T22:23:51.644+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":42},"headers":[],"bodySize":60,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":183},"connection":"80","time":445,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":445,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.vizury.com\/analyze\/pixel.php?account_id=VIZVRM98","headersSize":989},"serverIPAddress":"75.126.75.212","startedDateTime":"2013-10-18T22:23:51.644+12:00"},{"response":{"content":{"text":"","mimeType":"application\/x-javascript","size":1900},"headers":[],"bodySize":1140,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":284},"connection":"80","time":912,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":113,"wait":799,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/b.scorecardresearch.com\/beacon.js","headersSize":365},"serverIPAddress":"165.254.34.233","startedDateTime":"2013-10-18T22:23:51.644+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":25145},"headers":[],"bodySize":9603,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":341},"connection":"80","time":213,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":202,"receive":10},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.googletagmanager.com\/gtm.js?id=GTM-K4B8ZM","headersSize":312},"serverIPAddress":"74.125.236.126","startedDateTime":"2013-10-18T22:23:51.644+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":8371},"headers":[],"bodySize":3288,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":523},"connection":"80","time":113,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":107,"receive":5},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.googleadservices.com\/pagead\/conversion.js","headersSize":312},"serverIPAddress":"74.125.236.89","startedDateTime":"2013-10-18T22:23:51.644+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":2600},"headers":[],"bodySize":2600,"httpVersion":"HTTP\/1.1","status":403,"redirectURL":"","statusText":"Forbidden","cookies":[],"headersSize":109},"connection":"80","time":308,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":308,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/platform.twitter.com\/widgets\/follow_button.1384994725.html#_=1382091831312&id=twitter-widget-0&lang=en&screen_name=Snapdeal&show_count=false&show_screen_name=true&size=m","headersSize":385},"serverIPAddress":"93.184.216.139","startedDateTime":"2013-10-18T22:23:51.645+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":505},"headers":[],"bodySize":76,"httpVersion":"HTTP\/1.1","status":302,"redirectURL":"http:\/\/www.google.com\/ads\/user-lists\/992821011\/?label=IRI1CMXusAkQk_602QM&fmt=1&num=1&cv=7&frm=0&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries&ref=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth&random=1899661676","statusText":"Found","cookies":[],"headersSize":773},"connection":"80","time":152,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":151,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/googleads.g.doubleclick.net\/pagead\/viewthroughconversion\/992821011\/?random=1382091831772&cv=7&fst=1382091831772&num=1&fmt=1&label=IRI1CMXusAkQk_602QM&guid=ON&u_h=768&u_w=1364&u_ah=740&u_aw=1364&u_cd=16&u_his=4&u_tz=720&u_java=false&u_nplug=3&u_nmime=5&data=pcat%3DMobiles%20%26%20Tablets%3Bsubcategory_name%3DBatteries%3Bpagetype%3DSubcategory&frm=0&url=http%3A\/\/www.snapdeal.com\/products\/mobiles-batteries&ref=http%3A\/\/www.snapdeal.com\/products\/mobiles-bluetooth","headersSize":870},"serverIPAddress":"74.125.236.89","startedDateTime":"2013-10-18T22:23:51.908+12:00"},{"response":{"content":{"text":"","mimeType":"image\/gif","size":1118},"headers":[],"bodySize":43,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":668},"connection":"80","time":539,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":539,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/jasper.112.2o7.net\/b\/ss\/jasper-snapdeal-prd\/1\/H.23.4\/s14722872451893?AQB=1&ndh=1&t=18%2F9%2F2013%2022%3A23%3A51%205%20-720&ce=UTF-8&ns=jasper&pageName=allProducts%3Amobiles%3Amobiles-batteries&g=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries&r=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth&cc=INR&ch=allProducts&events=event44%2Cevent19&c1=CategoryPage&v1=Grid&v4=false&c12=allProducts%3Amobiles%3Amobiles-batteries&v12=allProducts%3Amobiles%3Amobiles-batteries&c13=storefront%3Amobiles%3Amobiles-bluetooth&v13=storefront%3Amobiles%3Amobiles-bluetooth&v15=avatar09a&c18=0.3%7Cproduction%2Cutmbreak&v21=D%3Ds_vi&v24=19&v35=3%3A30PM%7CFriday%7CWeekday&c40=0&v42=SD%20India&c46=all%3Amobiles%3Amobiles-batteries&c56=138535710322150352&v56=mobiles-mobiles-batteries&c58=default&s=1364x768&c=16&j=1.7&v=N&k=Y&bw=1364&bh=677&p=Google%20Update%3BJava%20Deployment%20Toolkit%206.0.270.7%3BWindows%20Presentation%20Foundation%3B&pid=storefront%3Amobiles%3Amobiles-bluetooth&pidt=1&oid=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries&ot=A&AQE=1","headersSize":1432},"serverIPAddress":"66.235.138.226","startedDateTime":"2013-10-18T22:23:51.909+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":70038},"headers":[],"bodySize":19279,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":537},"connection":"80","time":1574,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":4,"dns":198,"blocked":23,"wait":1331,"receive":18},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/cdn.widgets.webengage.com\/js\/widget\/webengage-min-v-3.0.js","headersSize":433},"serverIPAddress":"54.240.190.147","startedDateTime":"2013-10-18T22:23:51.910+12:00"},{"response":{"content":{"text":"","mimeType":"text\/javascript","size":8371},"headers":[],"bodySize":3288,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":523},"connection":"80","time":80,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":75,"receive":5},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.googleadservices.com\/pagead\/conversion.js","headersSize":312},"serverIPAddress":"74.125.236.89","startedDateTime":"2013-10-18T22:23:51.910+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":808},"headers":[],"bodySize":371,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":538},"connection":"80","time":613,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":613,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/bs.serving-sys.com\/BurstingPipe\/ActivityServer.bs?cn=as&ActivityID=385019&ifrm=1&rnd=884035.5784170193","headersSize":535},"serverIPAddress":"63.241.108.124","startedDateTime":"2013-10-18T22:23:51.947+12:00"},{"response":{"content":{"text":"","mimeType":"image\/jpeg","size":154},"headers":[],"bodySize":308,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":680},"connection":"80","time":1058,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":1,"dns":271,"blocked":6,"wait":780,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/precisionmatch.demdex.net\/event?c_AdvId=ADVSD101&c_ADVSD101_PageType=Visit&&c_event=undefined&c_cb=1382091831197","headersSize":670},"serverIPAddress":"107.21.25.64","startedDateTime":"2013-10-18T22:23:51.947+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":494},"headers":[],"bodySize":76,"httpVersion":"HTTP\/1.1","status":302,"redirectURL":"http:\/\/www.google.com\/ads\/user-lists\/998991075\/?label=MAFpCNWA2AQQ48mt3AM&fmt=1&num=2&cv=7&frm=0&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries&ref=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth&random=2065198884","statusText":"Found","cookies":[],"headersSize":773},"connection":"80","time":169,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":169,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/googleads.g.doubleclick.net\/pagead\/viewthroughconversion\/998991075\/?random=1382091832064&cv=7&fst=1382091831772&num=2&fmt=1&label=MAFpCNWA2AQQ48mt3AM&guid=ON&u_h=768&u_w=1364&u_ah=740&u_aw=1364&u_cd=16&u_his=4&u_tz=720&u_java=false&u_nplug=3&u_nmime=5&data=pagetype%3DSubcategory%3Bpcat%3DMobiles%20%26%20Tablets%3Buse_case%3Dretail&frm=0&url=http%3A\/\/www.snapdeal.com\/products\/mobiles-batteries&ref=http%3A\/\/www.snapdeal.com\/products\/mobiles-bluetooth","headersSize":829},"serverIPAddress":"74.125.236.89","startedDateTime":"2013-10-18T22:23:52.151+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":104},"headers":[],"bodySize":23203,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":86},"connection":"8008","time":4,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":1,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/platform.twitter.com:8008\/XX\/YY\/ZZ\/CI\/MGPGHGPGPFGHCDPFGGOGFGEH","headersSize":374},"serverIPAddress":"93.184.216.139","startedDateTime":"2013-10-18T22:23:52.151+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":114},"headers":[],"bodySize":15603,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":86},"connection":"8008","time":5,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":1,"dns":0,"blocked":0,"wait":1,"receive":3},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/platform.twitter.com:8008\/XX\/YY\/ZZ\/CI\/MGPGHGPGPFGHCDPFGGHGFHBGCHEGPFHHGG","headersSize":384},"serverIPAddress":"93.184.216.139","startedDateTime":"2013-10-18T22:23:52.152+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":279},"headers":[],"bodySize":481,"httpVersion":"HTTP\/1.1","status":302,"redirectURL":"http:\/\/www.google.co.in\/ads\/user-lists\/992821011\/?label=IRI1CMXusAkQk_602QM&fmt=1&num=1&cv=7&frm=0&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries&ref=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth&random=1899661676&ipr=y","statusText":"Found","cookies":[],"headersSize":582},"connection":"80","time":360,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":2,"wait":358,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.google.com\/ads\/user-lists\/992821011\/?label=IRI1CMXusAkQk_602QM&fmt=1&num=1&cv=7&frm=0&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries&ref=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth&random=1899661676","headersSize":782},"serverIPAddress":"74.125.236.146","startedDateTime":"2013-10-18T22:23:52.277+12:00"},{"response":{"content":{"text":"","mimeType":"text\/plain","size":357},"headers":[],"bodySize":0,"httpVersion":"HTTP\/1.1","status":204,"redirectURL":"","statusText":"No Content","cookies":[],"headersSize":248},"connection":"80","time":432,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":432,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/b.scorecardresearch.com\/b?c1=2&c2=9729364&ns__t=1382091832741&ns_c=UTF-8&c8=Batteries%20for%20Mobile%20Phones%20-%20Buy%20Mobile%20Battery%20Online%20%40%20Best%20Price%20-%20Snapdeal.com&c7=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries&c9=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth","headersSize":677},"serverIPAddress":"165.254.34.233","startedDateTime":"2013-10-18T22:23:52.887+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":12},"headers":[],"bodySize":45,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":619},"connection":"80","time":835,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":3,"dns":221,"blocked":1,"wait":610,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/bs.serving-sys.com\/BurstingPipe\/ActivityServer.bs?cn=as&ActivityID=387186&rnd=502102.58374766714&Session=1","headersSize":538},"serverIPAddress":"63.241.108.124","startedDateTime":"2013-10-18T22:23:53.004+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":279},"headers":[],"bodySize":481,"httpVersion":"HTTP\/1.1","status":302,"redirectURL":"http:\/\/www.google.co.in\/ads\/user-lists\/998991075\/?label=MAFpCNWA2AQQ48mt3AM&fmt=1&num=2&cv=7&frm=0&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries&ref=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth&random=2065198884&ipr=y","statusText":"Found","cookies":[],"headersSize":582},"connection":"80","time":232,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":232,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.google.com\/ads\/user-lists\/998991075\/?label=MAFpCNWA2AQQ48mt3AM&fmt=1&num=2&cv=7&frm=0&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries&ref=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth&random=2065198884","headersSize":782},"serverIPAddress":"74.125.236.146","startedDateTime":"2013-10-18T22:23:53.007+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":287},"headers":[],"bodySize":76,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":369},"connection":"80","time":298,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":298,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.google.co.in\/ads\/user-lists\/992821011\/?label=IRI1CMXusAkQk_602QM&fmt=1&num=1&cv=7&frm=0&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries&ref=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth&random=1899661676&ipr=y","headersSize":572},"serverIPAddress":"74.125.200.94","startedDateTime":"2013-10-18T22:23:53.043+12:00"},{"response":{"content":{"text":"","mimeType":"text\/html","size":287},"headers":[],"bodySize":76,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":369},"connection":"80","time":163,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":1,"wait":162,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/www.google.co.in\/ads\/user-lists\/998991075\/?label=MAFpCNWA2AQQ48mt3AM&fmt=1&num=2&cv=7&frm=0&url=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-batteries&ref=http%3A%2F%2Fwww.snapdeal.com%2Fproducts%2Fmobiles-bluetooth&random=2065198884&ipr=y","headersSize":572},"serverIPAddress":"74.125.200.94","startedDateTime":"2013-10-18T22:23:55.091+12:00"},{"response":{"content":{"text":"","mimeType":"application\/x-javascript","size":59492},"headers":[],"bodySize":59492,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":361},"connection":"80","time":2465,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":1,"dns":666,"blocked":286,"wait":1512,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/s3-ap-southeast-1.amazonaws.com\/wk-static-files\/webengage\/11b564323\/v3.js?r=23034863","headersSize":351},"serverIPAddress":"203.83.220.249","startedDateTime":"2013-10-18T22:23:55.526+12:00"},{"response":{"content":{"text":"","mimeType":"image\/png","size":85},"headers":[],"bodySize":109,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":300},"connection":"80","time":286,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":0,"wait":286,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/i2.sdlcdn.com\/img\/snapdeal\/page-overlay.png","headersSize":345},"serverIPAddress":"23.209.59.143","startedDateTime":"2013-10-18T22:23:55.526+12:00"},{"response":{"content":{"text":"","mimeType":"application\/x-javascript","size":175},"headers":[],"bodySize":175,"httpVersion":"HTTP\/1.1","status":200,"redirectURL":"","statusText":"OK","cookies":[],"headersSize":363},"connection":"80","time":1010,"pageref":"page_6","cache":{},"timings":{"send":0,"connect":0,"dns":0,"blocked":325,"wait":685,"receive":0},"request":{"headers":[],"queryString":[],"bodySize":-1,"httpVersion":"HTTP\/1.1","method":"GET","cookies":[],"url":"http:\/\/geoservice.webengage.com\/geoip\/?jsoncallback=webengage.GEO.setGeoData","headersSize":444},"serverIPAddress":"107.20.208.124","startedDateTime":"2013-10-18T22:23:58.047+12:00"}],"creator":{"name":"Firebug","version":"1.12"},"version":"1.1"}}';
		//var inVal='';
        // Register click handlers.
        $("#appendPreview").click(Lib.bindFixed(this.onAppendPreview(constLog), this));
        $(".linkAbout").click(Lib.bind(this.onAbout, this));

        // Registers drag-and-drop event handlers. These will be responsible for
        // auto-loading all dropped HAR files.

		if(elementId != "" && elementId =="content")
		{
			var content = $("#content");
			content.bind("dragenter", Lib.bind(Lib.cancelEvent, Lib));
			content.bind("dragover", Lib.bind(Lib.cancelEvent, Lib));
			content.bind("drop", Lib.bind(this.onDrop, this));
		}
		/*if(elementId2 != "" && elementId2 =="contentTwo")
		{
			var content = $("#contentTwo");
			content.bind("dragenter", Lib.bind(Lib.cancelEvent, Lib));
			content.bind("dragover", Lib.bind(Lib.cancelEvent, Lib));
			content.bind("drop", Lib.bind(this.onDrop, this));
		}
		*/
        // Update validate checkbox and register event handler.
        this.validateNode = $("#validate");
        var validate = Cookies.getCookie("validate");
        if (validate)
            this.validateNode.attr("checked", (validate == "false") ? false : true);
        this.validateNode.change(Lib.bind(this.onValidationChange, this))

        // Load examples
        $(".example").click(Lib.bind(this.onLoadExample, this));
    },

    // * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
    // Events

    onAppendPreview: function(jsonString)
    {
		
        if (!jsonString)
            jsonString = $("#sourceEditor").val();

        if (jsonString)
            this.tabView.appendPreview(jsonString);
    },

    onAbout: function()
    {
        this.tabView.selectTabByName("About");
    },

    onValidationChange: function()
    {
        var validate = this.validateNode.attr("checked");
        Cookies.setCookie("validate", validate);
    },

    onLoadExample: function(event)
    {
        var e = Lib.fixEvent(event);
        var path = e.target.getAttribute("path");

        var href = document.location.href;
        var index = href.indexOf("?");
        document.location = href.substr(0, index) + "?path=" + path;

        // Show timeline and stats by default if an example is displayed.
        Cookies.setCookie("timeline", true);
        Cookies.setCookie("stats", true);
    },

    // * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

    onDrop: function(event)
    {
        var e = Lib.fixEvent(event);
        Lib.cancelEvent(e);

        try
        {
            this.handleDrop(event.originalEvent.dataTransfer);
        }
        catch (err)
        {
            Trace.exception("HomeTab.onDrop EXCEPTION", err);
        }
    },

    handleDrop: function(dataTransfer)
    {
        if (!dataTransfer)
            return false;

        var files = dataTransfer.files;
        if (!files)
            return;

        for (var i=0; i<files.length; i++)
        {
            var file = files[i];
            var ext = Lib.getFileExtension(file.name);
            if (ext.toLowerCase() != "har")
                continue;

            var self = this;
            var reader = this.getFileReader(file, function(text)
            {
                if (text)
                    self.onAppendPreview(text);
            });
            reader();
        }
    },

    getFileReader: function(file, callback)
    {
        return function fileReader()
        {
            if (typeof(file.getAsText) != "undefined")
            {
                callback(file.getAsText(""));
                return;
            }

            if (typeof(FileReader) != "undefined")
            {
                var fileReader = new FileReader();
                fileReader.onloadend = function() {
                    callback(fileReader.result);
                };
                fileReader.readAsText(file);
            }
        }
    },

    // * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

    loadInProgress: function(show, msg)
    {
        $("#sourceEditor").val(show ? (msg ? msg : Strings.loadingHar) : "");
    }
});

return HomeTab;

//*************************************************************************************************
}});
