<%@ include file="EgTrackerJSON.jsp" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ taglib prefix="egui" uri="../../WEB-INF/eg-taglib.tld" %>
<%@ page import = "net.sf.json.*"%>
<%@page import = "com.egurkha.util.StringUtils"%>
<%@page import = "com.egurkha.util.EgSorter"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootJSON = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject hiddenParams = new JSONObject();

	boolean isDouble = EgDbInfo.doubleByteEnabled;
	String s_insightName = request.getParameter("view_name");
	if(s_insightName != null){
		s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"'","~#~");
		s_insightName=com.egurkha.util.StringUtils.replace(s_insightName,"&","|amp|");
	}
	String  tier_position = request.getParameter("tier_position");
	String server_position = request.getParameter("server_position");
	String comboChange = request.getParameter("comboChange");

	int t_pos=0;
	int s_pos=0;

	if( tier_position!=null && server_position!=null )
	{
		t_pos = Integer.parseInt(tier_position);
		s_pos = Integer.parseInt(server_position);	
	}

	String sessionID = session.getId();								
	UserRegistry registry = UserRegistry.getInstance();
	User this_user = registry.getUser(sessionID);
	
	com.egurkha.ini.IniUI uiObj = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = uiObj.getDefaultLanguage();

	if (this_user!=null)
	{
		String userLang = this_user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);

	EgQInsightView insightView = this_user.getQInsightView(s_insightName);
	
	String monHomePage=this_user.getMonitorHomePage();
	String s_compType = "all";//request.getParameter("comp_type");
	String s_compName = "";//request.getParameter("comp_name");
	String s_serverName = "";//request.getParamete("server_name");

	rootJSON.put("selectedCompName",mappingInfo.getTextDescription("monitor.quickinsight.Choose a component"));

	if( t_pos!=0 && s_pos!=0)
	{
		boolean isServerUsed = insightView.isServerUsed(t_pos - 1,s_pos - 1);
		if(isServerUsed)
		{
			String arr_serverInfo[] = insightView.getServerInfo(t_pos - 1,s_pos - 1);
			s_serverName = arr_serverInfo[insightView.SERVER_NAME_IDX];
			s_compName = arr_serverInfo[insightView.SERVER_COMP_IDX];
			rootJSON.put("selectedCompName",s_compName);
			s_serverName=com.egurkha.util.StringUtils.replace(s_serverName,"~#~","'");
	        rootJSON.put("selectedServerName",s_serverName);
			rootJSON.put("isServerUsed","true");
		}
	}

	
	String s_tmp = request.getParameter("comp_name");
	if(s_tmp != null && !s_tmp.equalsIgnoreCase("Choose a component"))
	{
		s_compName = s_tmp;
		s_compName = s_compName.substring(0,s_compName.lastIndexOf(":"));
		if( s_compName.endsWith(":NULL"))
		{
			s_compName = s_compName.substring(0,s_compName.indexOf(":"));
		}
		rootJSON.put("servername",com.egurkha.util.StringUtils.replace(s_compName,"~#~","'"));	
	}
	
	
	s_tmp = request.getParameter("comp_type");
	if(s_tmp != null && !s_tmp.equalsIgnoreCase("Choose a component"))
	{
		s_compType = s_tmp;
		
	}
	
	Vector v_compTypes = new Vector(this_user.getServerTypes());
	v_compTypes.remove("Host_system");
	Collections.sort(v_compTypes);
	v_compTypes.insertElementAt("ALL",0);

	List l_servers = null;
	if(s_compType.equalsIgnoreCase("all"))
		l_servers = this_user.getServers(false);
	else 
		l_servers = this_user.getServersForType(s_compType);
	
	Vector v_components = new Vector(l_servers);
	
	
	 
	for(int i=0;i<v_components.size();i++)
	{
		String s_entry = (String)v_components.get(i);
		int ind  = s_entry.indexOf(":");
		s_entry = s_entry.substring(ind + 1) + ":" + s_entry.substring(0,ind);
		v_components.setElementAt(s_entry,i);
	}
	Collections.sort(v_components);
%>
<%

	IniUI iniui = IniUI.getInstance();//modified on 17/10/07
	String defaultLanguage = iniui.getDefaultLanguage();
	String language = this_user.getLanguage();
	language = (language==null || language.length()==0)?defaultLanguage:language;//"en_US"
	MappingNameSorter sorter = new MappingNameSorter(language);					
	ArrayList serverList = new ArrayList();
	String compType = "";
%>
<%
	JSONArray compTypeArray = new JSONArray();
	JSONObject compTypecombo = new JSONObject();
	
	String firstChoice = "";
	for(int i=0;i<v_compTypes.size();i++)
	{
		compType = (String)v_compTypes.get(i);
		if(compType.equalsIgnoreCase("ALL"))
		{
			firstChoice = compType;
		}
		else
		{
			serverList.add(compType);
		}
	}
	if(serverList!=null && serverList.size()>1)
	{
		if(s_compType.equalsIgnoreCase("ALL"))
		{
			rootJSON.put("selectedCompType",mappingInfo.getTextDescription("monitor.quickinsight.ALL"));
		}
	}
	else if(serverList!=null && serverList.size()==1)
	{
		String comp  = (String)serverList.get(0);
		rootJSON.put("selectedCompType",comp);
	}
	compTypecombo.put("displayField",mappingInfo.getTextDescription("monitor.quickinsight.ALL"));
	compTypecombo.put("valueField",firstChoice);	
	compTypeArray.add(compTypecombo);
	
	serverList = sorter.getSortedCompTypeList(serverList);
	String tempVal = "";
	String tempDis = "";
	EgName nameObject = null;
	for(int x=0; x<serverList.size(); x++)
	{
		nameObject = (EgName)serverList.get(x);
		tempVal = nameObject.getActualName();
		tempDis = nameObject.getLocalName();
		compTypecombo.put("displayField",tempDis);
		compTypecombo.put("valueField",tempVal);	
		compTypeArray.add(compTypecombo);
		if (tempVal.equals(s_compType))
			rootJSON.put("selectedCompType",tempVal);
		
	}
	
	JSONArray compNameArray = new JSONArray();
	JSONObject compNamecombo = new JSONObject();
	compNamecombo.put("displayField",mappingInfo.getTextDescription("monitor.quickinsight.Choose a component"));
	compNamecombo.put("valueField",-1);
	
	compNameArray.add(compNamecombo);

	String serverName="";
	if((comboChange == null || comboChange.equalsIgnoreCase("false")) && v_components != null && v_components.size() == 1)
	{
		String selectedcompname = (String)v_components.get(0);
		rootJSON.put("selectedCompName",selectedcompname);
		rootJSON.put("isSingleServer","true");
		String s_Name = selectedcompname.substring(0,selectedcompname.lastIndexOf(":"));
		if(s_Name.endsWith(":NULL"))
		{
			s_Name = s_Name.substring(0,s_Name.indexOf(":"));
		}
		rootJSON.put("selectedServerName",com.egurkha.util.StringUtils.replace(s_Name,"~#~","'"));
	}

	List testList = new ArrayList();
	Hashtable testNameHash = new Hashtable();

	for( int i=0 ; i<v_components.size(); i++)
	{
		String totalserversList = (String)v_components.get(i);
		serverName = totalserversList.substring(0,totalserversList.lastIndexOf(":"));
		if( serverName.endsWith(":NULL"))
		{
			serverName = serverName.substring(0,serverName.indexOf(":"));
		}
		String componentType = totalserversList.substring(totalserversList.lastIndexOf(":")+1);
		String ComponentName = mappingInfo.getComponentTypeDescription(componentType);

		testList.add(serverName);
		testNameHash.put(serverName,totalserversList);	
	}
	
	//Sorting Test
	if (testList != null && testList.size() > 1)
	{
		EgSorter esort = new EgSorter(testList, 1);
		testList = esort.sort(1, "String", "asc");
	}
	if(testList != null && testList.size()>0 && testNameHash != null && testNameHash.size()>0) 
	{
		for(int c=0; c<testList.size(); c++)
		{
			String testDispName = (String)testList.get(c);
			if(testNameHash.containsKey(testDispName))
			{
				String valueField = (String)testNameHash.get(testDispName);						
				compNamecombo = new JSONObject();						
				compNamecombo.put("valueField", valueField);
				compNamecombo.put("displayField",testDispName);
				compNameArray.add(compNamecombo);
			}
		}			
	}							
	rootJSON.put("compNameArray",compNameArray);						
	
	if( t_pos!=0)
	{
		String tiername = insightView.getTierName(t_pos-1);
		tiername=com.egurkha.util.StringUtils.replace(tiername,"~#~","'");
		rootJSON.put("tiernameVal",tiername);
	}
	screenLabels.put("monitor.quickinsight.Tier position",mappingInfo.getTextDescription("monitor.quickinsight.Tier position"));
	screenLabels.put("monitor.quickinsight.Server position",mappingInfo.getTextDescription("monitor.quickinsight.Server position"));
	screenLabels.put("monitor.quickinsight.Component type",mappingInfo.getTextDescription("monitor.quickinsight.Component type"));
	screenLabels.put("monitor.common.Component",mappingInfo.getTextDescription("monitor.common.Component"));
	screenLabels.put("monitor.quickinsight.Server display name",mappingInfo.getTextDescription("monitor.quickinsight.Server display name"));
	screenLabels.put("monitor.common.Update",mappingInfo.getTextDescription("monitor.common.Update"));
	screenLabels.put("monitor.common.Delete",mappingInfo.getTextDescription("monitor.common.Delete"));
	
	rootJSON.put("screenLabels",screenLabels);
	rootJSON.put("compType",compTypeArray);

	out.println(rootJSON.toString());
%>
<%
	if(monHomePage!=null && monHomePage.trim().length()>0 && monHomePage.equals("Quick Insight"))
	{
		if(request.getQueryString()!=null)
		{
			session.setAttribute("monitorLastSession","/final/monitor/qinsight/EgQInsightHome.jsp?currentLoadingPage=EgQInsightServer&"+request.getQueryString());
		}
		else
		{
			session.setAttribute("monitorLastSession","/final/monitor/qinsight/EgQInsightHome.jsp?currentLoadingPage=EgQInsightServer");
		}
	}
%>