<%
/*******************************************************************************
*	Name		:	segmentTopology.jsp
*	Author		:	Sandhya.K
*	Purpose		:	To select a segment and display the segment topology
*	Version		:	eG 3.0
*	Created On	:	21/11/2001
*	Modified	:	13/12/2001	kk			Restrict SEGMENT_ from appearing in segment names.
					27/12/2001	Sandhya		Display segments only if they are configured. 
					25/01/2002	Sandhya		Display list box only if more than one segment is configured.
					02/06/2003	Williams	For Version 3.0
					01/12/2003	Arun		Increased the width and height of the applets
					21/05/2004	Arun		Resized applet widths for use with non-flickering applets
					01/06/2015	Prantish	Topology with D3 JS
*******************************************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page errorPage="EgProbsM.jsp"%> 
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgStateZone" %>
<%@ page import="com.eg.EgTopoInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="egurkha.EgAspLite" %>
<%@ page import="java.util.*" %>
<%@ page import="com.egurkha.monitor.*" %>
<%@ page import = "com.eg.EgAlarmTable" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "egurkha.EgCrawler" %>
<%@ page import = "java.io.*" %>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "com.eg.supermanager.*" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgAggregateInfo" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%
	if(EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		String select_Node=request.getParameter("segment");
		if(select_Node != null && (select_Node=select_Node.trim()).length()>0)
		{
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("segment",select_Node);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(currentSession,managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);				
			}
		}
	}
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	response.setContentType("application/json");
	request.setCharacterEncoding("UTF-8");

	EgTopoInfo topoInfo=new EgTopoInfo("manager");
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");

	String segment = request.getParameter("segment");
	String service = request.getParameter("service");
	String serviceName = request.getParameter("segmentName");
	String segState = request.getParameter("state");
	String fromSuper = (String)session.getAttribute("fromSuper");
	String fromHomepage = request.getParameter("fromHomepage");
	fromHomepage = (fromHomepage!=null && !fromHomepage.equalsIgnoreCase("") && !fromHomepage.equalsIgnoreCase("null") && !fromHomepage.equalsIgnoreCase("undefined"))?fromHomepage:"";
	String isFromZone = request.getParameter("isFromZone"); 
	String iszoneName = request.getParameter("iszoneName")!=null?request.getParameter("iszoneName"):""; 
	String parentZone = request.getParameter("parentZone");
	String fromPage=request.getParameter("fromPage");
	
	boolean isJS = false;
	IniUI iniUI = IniUI.getInstance();
	String thisLanguage = iniUI.getDefaultLanguage();
	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String jsOption = 	iniUI.getValue("TOPOLOGY_OPTIONS","Javascript");
	if(jsOption!=null && jsOption.length() > 0)
	{
		if(jsOption.equalsIgnoreCase("yes") || jsOption.equalsIgnoreCase("true"))
			isJS = true;
		else if(jsOption.equalsIgnoreCase("auto"))
		{
			String max_limit = iniUI.getValue("TOPOLOGY_OPTIONS","Max_limit");
			int max = 100; // Default value
			try{
				max = Integer.parseInt(max_limit);
			}
			catch(Exception exp){
				max = 100;
			}
			String[] totalVariables =  topoInfo.getVariables(segment);
			int totalComps = 0;
			if(totalVariables!=null)
				totalComps = totalVariables.length;
			if(totalComps > max)
				isJS = false;
			else
				isJS = true;
		}
	}
	String zoomLevel = request.getParameter("zoom");
	if(zoomLevel==null)
	{
		zoomLevel = "100";
	}

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	String s_userid = user.getLoginID();
	session.setAttribute("segment",segment);

	Vector v_seg = new Vector();
	v_seg.addAll(user.getSegments());

	if(service!=null && !service.equals(""))
	{
		session.setAttribute("service",service);
	}

%>
<%
// Declaration part for variables and JSON objects

JSONObject json = null, selectedField = null;
%>

<%
json = new JSONObject();

request.setAttribute("jsonObject",json);
request.setAttribute("category","segment");
request.setAttribute("itemName",segment);

%>
	<%@ include file="aggregateTabHandler.jsp" %>
<%

if(v_seg!=null && v_seg.size()>0)
{
	try
	{
		String segmentState = "segment20New_"+EgStateZone.getState("Segment:"+segment.trim()+":NULL");
		json.put("segmentClass",segmentState);
		json.put("segmentName","Segment : "+segment);
		if(v_seg.size() > 1)
		{
			selectedField = new JSONObject();
			selectedField.put("selectLabel",mappingInfo.getTextDescription("monitor.topology.Select a Segment"));
				String siteSegs = "";
				List v_segment_state = new LinkedList();
				Vector vec_seg = new Vector();

				if((service!=null && !service.trim().equals("")) || (serviceName!=null && !serviceName.equals("")))
				{
					if(serviceName!=null && !serviceName.equals(""))
						siteSegs = topoInfo.getValue("WEB_SITE_SEGMENTS","Web_site:" + serviceName.trim()).trim();
					else
						siteSegs = topoInfo.getValue("WEB_SITE_SEGMENTS","Web_site:" + service.trim()).trim();
					if(siteSegs != null && siteSegs.length() > 0)
					{
						StringTokenizer stc = new StringTokenizer(siteSegs,",");
						while(stc.hasMoreTokens())
						{
							vec_seg = new Vector();
							List row = new LinkedList();

							String thisSeg = stc.nextToken().trim();
							if(thisSeg != null)
							{
								row.add(thisSeg);
								
								String thisSegState = (String)getStateForSegment(service,"SEG:"+thisSeg);

								if(thisSegState!=null)
									row.add(thisSegState);
							}
							v_segment_state.add(row);
						}
						
						Object[] segments = v_segment_state.toArray();
						Arrays.sort(segments, new Sorter(AlarmPriorities.getStatesOrder(), true));

						for (int a=0; a<segments.length; a++)
						{
							List lis = (List)segments[a];
							String segmentName = (String)lis.get(0);

							if(segmentName!=null)
							{
								segmentName = segmentName.trim();
								if(!vec_seg.contains(segmentName))
									vec_seg.add(segmentName);
							}
						}
						if(vec_seg!=null && vec_seg.size()>0)
						{
							v_seg = new Vector();
							v_seg.addAll(vec_seg);
						}
					}
				}
				else if(v_seg != null && v_seg.size() > 0)
				{
					vec_seg.addAll(v_seg);
					for(int v=0;v<vec_seg.size();v++)
					{
						//vec_seg = new Vector();
						List row = new LinkedList();

						String thisSeg = (String)vec_seg.get(v);
						if(thisSeg != null)
						{
							row.add(thisSeg);
							
							String thisSegState = EgStateZone.getState("Segment:"+thisSeg.trim()+":NULL");

							if(thisSegState!=null)
								row.add(thisSegState);
						}
						v_segment_state.add(row);
					}
					
					Object[] segments = v_segment_state.toArray();
					Arrays.sort(segments, new Sorter(AlarmPriorities.getStatesOrder(), true));

					vec_seg.clear();
					for (int a=0; a<segments.length; a++)
					{
						List lis = (List)segments[a];
						String segmentName = (String)lis.get(0);

						if(segmentName!=null)
						{
							segmentName = segmentName.trim();
							if(!vec_seg.contains(segmentName))
								vec_seg.add(segmentName);
						}
					}
					if(vec_seg!=null && vec_seg.size()>0)
					{
						v_seg = new Vector();
						v_seg.addAll(vec_seg);
					}
				}
				JSONArray selectOptions = new JSONArray();
				List sortSegList = new ArrayList();
				for(int i=0;i<v_seg.size();i++)
				{
					String segName = (String)v_seg.get(i);
					sortSegList.add(segName);
				}

				//Sorting Segments
				if (sortSegList != null && sortSegList.size() > 1)
				{
					EgSorter esort = new EgSorter(sortSegList, 1);
					sortSegList = esort.sort(1, "String", "asc");
				}

				for(int s=0; s<sortSegList.size();s++)
				{
					String segmentName = (String)sortSegList.get(s);
					if(segment.trim().equals(segmentName))
					{
						selectedField.put("selectedValue",segmentName);
					}
					JSONObject option  = new JSONObject();
					option.put("value",segmentName);
					option.put("name",segmentName);
					
					ArrayList aggregateArrayZC = aggregateInfo.getAggregateComponentsOfElement("segment",segmentName);

					boolean aggregateTab =false;
					if(aggregateArrayZC != null && aggregateArrayZC.size() > 0)
						aggregateTab = true;
					
					option.put("url","/final/monitor/segmentDashboard.jsp?fromPage=segmentTree&fromTab=topology&isFromZone=null&iszoneName=&parentZone=null&selectNode=Segment$cap$"+segmentName+"&selectedParam="+segmentName+"&currentTab=topology&aggregateTab="+aggregateTab+"&fromHomepage="+fromHomepage+"&treeOpen=false&openNode="+segmentName);
					
					selectOptions.add(option);
				}
				selectedField.put("selectOptions",selectOptions);
			}
			json.put("selectFieldData",selectedField);
			if(!isJS)
			{
				json.put("applet","true");
				JSONObject appletAttributes = new JSONObject();
				JSONObject appletParams = new JSONObject();
				appletAttributes.put("code","com.egurkha.EgTopology.class");
				appletAttributes.put("codebase","/final/topology");
				appletAttributes.put("align","center");
				appletAttributes.put("id","my_applet");
				appletAttributes.put("class","topoGraphAppDiv");
				//appletAttributes.put("width","935");
				//appletAttributes.put("height","480");
				
				appletParams.put("fromSuper",fromSuper);
				appletParams.put("sessionId",session.getId());
				appletParams.put("physical_topology","1");
				appletParams.put("urlPrefix",EgInstallInfo.getUrlPrefix());
				appletParams.put("segment",segment);
				appletParams.put("segmentState",segmentState);
				appletParams.put("fromPage","serviceDashboard");

				if(service!=null && !service.equals(""))
				{
					appletParams.put("service",service);
				}

				appletParams.put("site",service);
				appletParams.put("r_uri",request.getRequestURI());
				appletParams.put("r_port",String.valueOf(request.getServerPort()));
				appletParams.put("r_host",request.getServerName());
				appletParams.put("r_protocol",request.getProtocol());
				appletParams.put("canvasType","segment");
				appletParams.put("urlFinal",request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+request.getContextPath());
				json.put("appletAttr",appletAttributes);
				json.put("appletParams",appletParams);
			}
			else
			{
				json.put("applet","false");
				//int iframeWidth = 974;
				//int iframeHeight = 550;
				
				/**
				* /final/monitor/EgSegmentTopologyJS.jsp for Raphael JS Library
				* /final/monitor/EgSegmentTopologyD3JS.jsp for D3JS
				*/
				String frameSrc = "/final/monitor/EgSegmentTopologyD3JS.jsp?segment="+EgURLEncoder.encode(segment,"UTF-8")+"&physical_topology=1&fromHomepage="+fromHomepage+"&type=segment" + "&zoom="+EgURLEncoder.encode(zoomLevel,"UTF-8")+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&segmentState="+segmentState;
				if(fromSuper!=null)
				{
					frameSrc = frameSrc + "&fromSuper="+EgURLEncoder.encode(fromSuper,"UTF-8")+ "&sessionId="+(session.getId());
				}
				if(service!=null && !service.equals(""))
				{
					frameSrc = frameSrc+"&service="+EgURLEncoder.encode(service,"UTF-8")+"&site="+EgURLEncoder.encode(service,"UTF-8");
				}
				String graphData="<iframe id='segmentTopoIframeId'  width='100%' height='100%' src='"+frameSrc+"' border='0' scrolling='no' marginwidth='0px' marginheight='0px' frameborder='0' color='blue' style='border-width:0px; border-style:solid; border-color:yellow;' ></iframe>";
				json.put("graphData",graphData);
			}

			response.getWriter().write(json.toString());
				//To identify for come Back from LayerModel page
			session.setAttribute("prevPage","SEGMENT PREVIEW");//-------06/07/07----------

			if(request.getQueryString()!=null)
			{
				session.setAttribute("monitorLastSession","/final/monitor/segmentDashboard.jsp?"+request.getQueryString());
			}
			else
			{
				session.setAttribute("monitorLastSession","/final/monitor/segmentDashboard.jsp");
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in segmentDashboard..");
			e.printStackTrace();
		}
	}
	else if(v_seg.size()==0)
	{
		String pageStr = "header.jsp?title=SEGMENT PREVIEW";
		// This part is executed if no segment is found
	}
%>
<%!
	public String getStateForSegment(String serviceName, String segmentName)
	{
		ServiceDAO dao = MonitorDAOFactory.getInstance().getServiceDAO();
		return dao.getStateForSegment(serviceName, segmentName);
	}
%>