<!DOCTYPE html>
<%
/********************************************************************************************************
*	Name			:	serviceBusinessDetailsMain.jsp
*	Purpose			:	This is the main jsp used for Service Business Performance Details page
*	Version			:	6.0
*	CreationDate	:	Oct 28 2013
*	Author			:	Saravanan.A
*******************************************************************************************************/
%>
<%@ include file = "EgLoginTracker.jsp"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.eg.EgStateZone"%>
<%@ page import = "com.egurkha.EgUserPermission"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	request.setCharacterEncoding("UTF-8");

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	IniFile serviceDashIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_serviceperfdash.ini");
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	long refreshFrequency = 60 * 1000L;
	String refFreq = u_ser.getRefreshFrequency();

	if(refFreq!=null && refFreq.length()>0)
	{
		refreshFrequency =  Long.valueOf(refFreq).longValue() * 1000L;
	}

	IniUI iniUI = IniUI.getInstance();
	String thisLanguage = iniUI.getDefaultLanguage();
	UserRegistry ur = UserRegistry.getInstance();
	String sessionID = session.getId();
	User user = ur.getUser(sessionID);
	EgUserRole userRole = user.getUserRole();
	String roleName     = userRole.getRoleName();
	boolean hasAllComponentAccess=userRole.hasAllComponentAccess();
	boolean isAdminRole = (roleName.equals("Admin") || roleName.equals("Supermonitor"));
	boolean hasMonitorTab = userRole.hasAnyMonitorRole(EgUserPermission.MONITOR);
	String user_name = "";
	if (u_ser!=null)
	{
		String userLang = u_ser.getLanguage();
		user_name = user.getLoginID();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String title = mappingInfo.getTextDescription("monitor.serviceHealth.SERVICES PERFORMANCE DASHBOARD");
	String homePageName=(String)u_ser.getMonitorHomePage();
	String page_title=null;
	if(homePageName!=null)
		page_title=mappingInfo.getTextDescription("monitor.menu."+homePageName);
	
	boolean flageBackButton=true;
	if(title!=null && page_title!=null && (title.equalsIgnoreCase(page_title) || title.indexOf(page_title)>-1))
	{
		flageBackButton = false;
	}

	String service_name=request.getParameter("serviceName");
	service_name=(service_name==null)?"":service_name;

	String service_state=request.getParameter("serviceState");
	if(service_state==null || service_state.trim().length()==0)
	{
		service_state = EgStateZone.getState("Service:"+service_name+":NULL");
	}
	service_state=(service_state==null)?"GOOD":service_state;

	String isServiceBusiDash = request.getParameter("isServiceBusiDash");
	String treeFlag = request.getParameter("treeFlag");
	String outsideService = request.getParameter("outsideService");
	String titleText = request.getParameter("titleText");
	String selectNode = request.getParameter("selectNode");
	String isEmulTrans = request.getParameter("isEmulTrans");
	String serviceState = request.getParameter("serviceState");
	if(strCsrfToken==null||strCsrfToken.trim().length()==0||strCsrfToken.equalsIgnoreCase("NULL"))
		strCsrfToken = request.getParameter("com.eg.CSRF_NONCE");
	String refUrl="/final/monitor/serviceBusinessDetails.jsp?serviceName="+EgURLEncoder.encode(service_name,"UTF-8")+"&monCmd=serviceList&from=MainDashboard&action=service&isServiceBusiDetails=true&treeFlag="+treeFlag+"&outsideService="+outsideService+"&titleText="+titleText+"&selectNode="+EgURLEncoder.encode(selectNode,"UTF-8")+"&isEmulTrans="+isEmulTrans+"&serviceState="+serviceState+"&showLegend=true";

	String dashConfigText="";
	String backButtonText="";
	boolean dashFlage=true;
	boolean backFlage=true;
	if(flageBackButton)
	{
		if(isAdminRole || hasMonitorTab)
		{
			dashFlage = false;
			dashConfigText=mappingInfo.getTextDescription("monitor.serviceDashboard.Dashboard Settings");
		}
		backFlage=false;
		backButtonText=mappingInfo.getTextDescription("monitor.common.Back");
	}

	boolean isEnableSharing=false;
	String sharing_str = serviceDashIni.getValue("Services_Overview_Common","Enable_Sharing");
	if(sharing_str!=null && sharing_str.trim().length()>0 && (sharing_str.equalsIgnoreCase("true") || sharing_str.equalsIgnoreCase("yes")))
	{
		isEnableSharing = true;
	}

	boolean isSharingEnable=false;
	if(isEnableSharing && hasAllComponentAccess)
	{
		isSharingEnable = true;
	}

	boolean isSharingOpt=false;
	String sharing_opt_str = serviceDashIni.getValue("Services_Overview_Common","Enable_SharingOptions");
	if(sharing_opt_str!=null && sharing_opt_str.trim().length()>0 && (sharing_opt_str.equalsIgnoreCase("true") || sharing_opt_str.equalsIgnoreCase("yes")))
	{
		isSharingOpt = true;
	}
	String enableServiceSkipReorder =
	(String)serviceDashIni.getValue("Services_User_Config",user_name+":enableServiceSkipReorder");
	
	enableServiceSkipReorder = (enableServiceSkipReorder==null || enableServiceSkipReorder.trim().length()==0)?"false":enableServiceSkipReorder;
	
	boolean isEnableServiceSkipReorder = false;
	if(enableServiceSkipReorder!=null && enableServiceSkipReorder.equalsIgnoreCase("true")|| enableServiceSkipReorder.equalsIgnoreCase("yes"))
		isEnableServiceSkipReorder=true;

%>
<html class="content-frame">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<script>
	var headerText='<egui:intnl text="monitor.service.Tier wise performance metrics for service"/>&nbsp;:&nbsp;<%=service_name%>';

	
	var backButtonMsg='<%=backButtonText%>';
	var dashConfigMsg='<%=dashConfigText%>';
	var isServiceBusiDash='<%=isServiceBusiDash%>';
	var treeFlag='<%=treeFlag%>';
	var outsideService='<%=outsideService%>';
	var titleText='<%=titleText%>';
	var selectNode='<%=selectNode%>';
	var isEmulTrans='<%=isEmulTrans%>';
	var serviceState='<%=serviceState%>';

	var backButtonFlg=<%=backFlage%>;
	var dashConfigFlg=<%=dashFlage%>;
	var sharingFlg=<%=(!isSharingEnable)%>;
	var sharingOptFlag=<%=(!isSharingOpt)%>;
	var isServRmvReordr=<%=isEnableServiceSkipReorder%>;

	var titleConfig = '<%=mappingInfo.getTextDescription("monitor.services.Configuration Settings")%>';
	var titleSharing = '<%=mappingInfo.getTextDescription("monitor.services.Sharing Configuration Settings")%>';
	var configuration ='<egui:intnl text="monitor.services.Configuration"/>';
	var defaultValue='<egui:intnl text="monitor.services.Default"/>';
	var specific='<egui:intnl text="monitor.services.Specific"/>';
	var isAggregate='<egui:intnl text="monitor.services.Is Aggregate "/>';
	var yes='<egui:intnl text="monitor.services.Yes "/>';
	var no='<egui:intnl text="monitor.services.No "/>';
	var servicesName='<egui:intnl text="monitor.services.Services "/>';
	var category='<egui:intnl text="monitor.services.Category "/>';
	var demand='<egui:intnl text="monitor.services.Demand "/>';
	var consumption='<egui:intnl text="monitor.services.Consumption "/>';
	var quality='<egui:intnl text="monitor.services.Quality "/>';
	var serviceTypeLabel='<egui:intnl text="monitor.services.Service Types "/>';
	var filterByLabel='<egui:intnl text="monitor.services.Filter by Component Type "/>';
	var compTypeLabel='<egui:intnl text="monitor.services.Comp Type"/>';

	var typeLabel='<egui:intnl text="monitor.services.Component type "/>';
	var testLabel='<egui:intnl text="monitor.services.Test "/>';
	var measureLabel='<egui:intnl text="monitor.services.Measure"/>';
	var displayLabel='<egui:intnl text="monitor.services.Display Name "/>';

	var addLabel='<egui:intnl text="monitor.services.Add "/>';
	var updateLabe='<egui:intnl text="monitor.services.Update"/>';
	var sharingBtnLabe='<egui:intnl text="monitor.services.Share"/>';
	var deleteLabel='<egui:intnl text="monitor.services.Delete"/>';
	var modifyLabel='<egui:intnl text="monitor.services.Modify"/>';

	var titleAddMeasure='<egui:intnl text="monitor.services.Add Measure"/>';
	var specifyToLabel='<egui:intnl text="monitor.services.Specify to"/>';
	var compNameLabel='<egui:intnl text="monitor.services.Comp Name"/>';
	var layerLabel='<egui:intnl text="monitor.services.Layer"/>';

	var functionLabel='<egui:intnl text="monitor.services.Function"/>';
	var layerLabel='<egui:intnl text="monitor.services.Layer"/>';
	var sumLabel='<egui:intnl text="monitor.services.Sum"/>';
	var avgLabel='<egui:intnl text="monitor.services.Avg"/>';
	var minLabel='<egui:intnl text="monitor.services.Min"/>';
	var maxLabel='<egui:intnl text="monitor.services.Max"/>';
	var displayNameLabel='<egui:intnl text="monitor.services.Display Name"/>';
	var addButton='<egui:intnl text="monitor.services.Add"/>';
	var okButton='<egui:intnl text="monitor.services.Ok"/>';

	var titleModify='<egui:intnl text="monitor.services.Modify"/>';
	var okButton='<egui:intnl text="monitor.services.Ok"/>';

	var titleFirst='<egui:intnl text="monitor.services.Tiers"/>';
	var titleDemand='<egui:intnl text="monitor.services.Demand"/>';
	var titleConsumption='<egui:intnl text="monitor.services.Consumption"/>';
	var titleQuality='<egui:intnl text="monitor.services.Quality"/>';
	var titleHealth='<egui:intnl text="monitor.services.Component Health"/>';
	var noFound='<egui:intnl text="monitor.services.No Tiers found for the service"/>';
	var refreshURLValue='<%=refUrl%>';
	var isDetailPage='true';	
	var appliesTo='<egui:intnl text="monitor.services.Applies to"/>';
	var column='<egui:intnl text="monitor.services.Column"/>';
	
	var pcac='<egui:intnl text="monitor.services.Please choose a component"/>';
	var pcal='<egui:intnl text="monitor.services.Please choose a layer"/>';
	var pcat='<egui:intnl text="monitor.services.Please choose a test"/>';
	var pcam='<egui:intnl text="monitor.services.Please choose a measure"/>';
	var pcast='<egui:intnl text="monitor.services.Please choose a service type"/>';
	var pcact='<egui:intnl text="monitor.services.Please choose component type"/>';
	var pcas='<egui:intnl text="monitor.services.Please choose a service"/>';
	var sao='<egui:intnl text="monitor.services.Select only one row to edit"/>';
	var saod='<egui:intnl text="monitor.services.Select only one row to delete"/>';
	var psai='<egui:intnl text="monitor.services.Please select an item"/>';
	var psaim='<egui:intnl text="monitor.services.Please select an item to edit"/>';
	var psaid='<egui:intnl text="monitor.services.Please select an item to delete"/>';
	var labSL='<egui:intnl text="monitor.services.Show Legends"/>';
	var tipFS='<egui:intnl text="monitor.services.Full Screen"/>';
	var tipSharing='<egui:intnl text="monitor.services.Sharing"/>';
	var tipSt='<egui:intnl text="monitor.services.Settings"/>';
	var tipSpe='<egui:intnl text="monitor.services.Special characters are not allowed"/>';
	var setngLbl='<egui:intnl text="monitor.services.Settings"/>';
	var btnRmvTxt='<egui:intnl text="monitor.services.Remove"/>';
	var btnAddTxt='<egui:intnl text="monitor.services.Add"/>';
	var btnMvTop='<egui:intnl text="monitor.services.Move to Top"/>';
	var btnMvUp='<egui:intnl text="monitor.services.Move Up"/>';
	var btnMvDwn='<egui:intnl text="monitor.services.Move Down"/>';
	var btnMvBtm='<egui:intnl text="monitor.services.Move to Bottom"/>';
	var fromTitleTxt='<egui:intnl text="monitor.services.Available Services"/>';
	var toTitleTxt='<egui:intnl text="monitor.services.Removed Services"/>';
	var emptyPanel=new Array();
	var csrfToken = '<%=strCsrfToken%>';

</script>
<title><egui:intnl text="monitor.serviceDashboard.Service Business Dashboard"/></title>
<egui:skin ui="monitor"/>
<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="servicesBusinessDash" appFile="app.js"/>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script language="JavaScript1.2" src="/final/monitor/eg_scripts/jquery.tablednd.js"></script>
<script language="JavaScript1.2" type="text/JavaScript">

var $j = jQuery.noConflict();
if (typeof String.prototype.startsWith != 'function') {
  String.prototype.startsWith = function (str){
    return this.slice(0, str.length) == str;
  };
}

if (typeof String.prototype.endsWith != 'function') {
  String.prototype.endsWith = function (str){
    return this.slice(-str.length) == str;
  };
}

	function parseScript(_source)
		{
			var source = _source;
			var scripts = new Array();
			
			// Strip out tags
			while(source.indexOf("<script") > -1 || source.indexOf("</script") > -1) {

				var s = source.indexOf("<script");
				var s_e = source.indexOf(">", s);
				var e = source.indexOf("</script", s);
				var e_e = source.indexOf(">", e);
				// Add to scripts array
				scripts.push(source.substring(s_e+1, e));
				// Strip from source
				source = source.substring(0, s) + source.substring(e_e+1);
			}
			// Loop through every script collected and eval it
			for(var i=0; i<scripts.length; i++) {
				try {
					eval(scripts[i]);
				}
				catch(ex) {
					return;
				}
			}
			// Return the cleaned source
			return source;
		}
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.Ajax.on('requestexception', function (conn, response, options){
				var errorStr = response.responseText;
				parseScript(errorStr);
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
			});
			initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
		});

documentView ={
		getObject: function()
		{
			if(typeof( window.innerWidth) == 'number')
			{//Firefox
				this.height = window.innerHeight;
				this.width = window.innerWidth;
				this.fireFox = true;
			}
			else if( document.documentElement && ( document.documentElement.clientWidth
				|| document.documentElement.clientHeight ))
			{//IE 6 + in 'standards compliant mode'
				this.height = document.documentElement.clientHeight;
				this.width = document.documentElement.clientWidth;
				this.ie = true;
			}
			else if(document.body && document.body.clientHeight)
			{ //IE 4 compatible
				this.height = document.body.clientHeight;
				this.width = document.body.clientWidth;
				this.ie = true;
			}
			return this;
		},
		getHeight: function()
		{
			return this.getObject().height;
		},
		getWidth: function()
		{
			return this.getObject().width;
		},
		isIE: function()
		{
			return this.getObject().ie;
		},
		isFireFox: function()
		{
			return this.getObject().fireFox;
		}
	};

	//intvrl=setInterval("refreshPageInterval()",<%=refreshFrequency%>);
	var remoteURL="../servlet/com.eg.EgMonRemoteScriptingServlet";
	var refreshFrequency=<%=refreshFrequency%>;
	function goToPage(url)
	{
		window.location.href=url;
	}

</script>






</head>

<body style="overflow:hidden"  marginwidth="0" marginheight="0" topmargin="0" leftmargin="0" scroll="no" class="eg_lightlight" class="content-frame">
<input type="hidden" name="hiddenResult"  id="hiddenResult" value="">

</body>


<script language="JavaScript1.2" src="../monitor/eg_scripts/eg_validate.js"></script>
<!-- <script language = "JavaScript1.2"  type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script> -->
<!-- Fancy scroll------------------------------->
<script language = "JavaScript1.2" src = "/final/monitor/eg_scripts/jsrsClient.js"></script>

<!--Ext JS -->

<!-- <script src="/final/scripts/utilities/ScrollableUtils.js"></script>
<script src="/final/scripts/utilities/ScrollPanel.js"></script> -->
<script src="/final/scripts/utilities/ZoomGraphPanel.js"></script>
<script src="/final/scripts/utilities/Multiselector.js"></script>



<!-- fancy Scroll-->

<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>


<script language="JavaScript1.2" src="/final/Highcharts/js/highstock.js"></script>
<script language="JavaScript1.2" src="/final/monitor/eg_scripts/EgHighChart.js"></script>
<script src="/final/monitor/eg_scripts/egDashboardHighChart.js"></script>
<script src="/final/Highcharts/js/highcharts-more.js"></script>

<script src="/final/scripts/eg_DateUtil.js"></script>
<script type='text/javascript'>
var mgr_dateFormat= getExtjsDateFormat('<%=dateFormatForDatePicker%>');
var mgr_currentDateFormat= getExtjsDateFormat('<%=currentDateFormat%>');
var mgr_dateFormat_js= '<%=dateFormatForDatePicker%>';
var currentDateFormat_js= '<%=currentDateFormat%>';
function bigHighChart(url,divId,height,width,maxURL,isAxisTimeReq,legendPos,zoomed)
{
	Ext.onReady(function() 
	{
		var containerId = divId;
		var containerObj=Ext.getCmp(containerId);
		var errMsg = "<table border='0' height='100%' width='100%'><tr><td align='center'><img src='/final/images/<%=monitor_Skin%>/nomeasures_custom.png'></td></tr></table>";
		if(!Ext.isEmpty(url))
		{
			Ext.Ajax.request(
			{
				url : url,
				scope:this,
				success: function(response) 
				{
					if(response.status == 200 && !Ext.isEmpty(response))
					{
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							if(jsonText.indexOf("<HTML>") > -1 || jsonText.indexOf("png") > -1 || jsonText.indexOf("GIF") > -1 || jsonText.indexOf("gif") > -1 || jsonText.indexOf("PNG") > -1)
							{
								try
								{
									Ext.get(containerId).update(errMsg);
								}
								catch (e)
								{
									jQuery('#'+containerId).update(errMsg);
								}
							}
							else
							{
								var chartData=Ext.decode(jsonText);
								if(zoomed != undefined && zoomed)
									chartData["isServiceBusDash"]="false";
								else
									chartData["isServiceBusDash"]="true";
								if(maxURL!=null && maxURL.indexOf("close")>-1)
								{
									//chartData["xAxisDisplay"]="horizontal";
									chartData["enableTitle"]=true;
									var chartDataSetLen = 0;
									if(chartData.DataSet!=null && chartData.DataSet!='undefined')
										chartDataSetLen = chartData.DataSet.length;
									for(var i=0;i<chartDataSetLen;i++)
									{
										if(chartData.DataSet[i].name=='DATA')
										{
											chartData["legendEnabled"]=false;
										}
										else
										{
											chartData["legendEnabled"]=true;
										}
									}
								}
								else
								{
									chartData["xAxisDisplay"]="horizontal";
									chartData["enableTitle"]=false;
									chartData["showLastLabel"]=false;
									var chartDataSetLen = 0;
									if(chartData.DataSet!=null && chartData.DataSet!='undefined')
										chartDataSetLen = chartData.DataSet.length;
									for(var j=0;j<chartDataSetLen;j++)
									{
										if(chartData.DataSet[j].name=='DATA')
										{	
											chartData["legendEnabled"]=false;
										}
										else
										{
											chartData["legendEnabled"]=true;
										}
									}
								}

								try
								{
									var tmp_width=0;
									try
									{
										tmp_width = Ext.get(containerId).getWidth();
									}
									catch (e)
									{
										tmp_width=jQuery('#'+containerId).width();
									}
									if(tmp_width!=null && tmp_width!=undefined && tmp_width>0)
										width=tmp_width-30;
									var lineChart = {
									};
									lineChart = jQuery.extend(true, {}, getHighCharts(containerId,height,width,maxURL), lineChart);
									lineChart.setData(chartData,'<%=dateFormatForDatePicker%>',maxURL,isAxisTimeReq,legendPos);
									lineChart.drawChart();
								}
								catch (e)
								{
									//alert("e::"+e)
								}
							}
						}
						else
						{
							//Ext.get(containerId).update(errMsg);
							try
							{
								Ext.get(containerId).update(errMsg);
							}
							catch (e)
							{
								jQuery('#'+containerId).update(errMsg);
							}
						}
					}
					else
					{
						//Ext.get(containerId).update(errMsg);
						try
						{
							Ext.get(containerId).update(errMsg);
						}
						catch (e)
						{
							jQuery('#'+containerId).update(errMsg);
						}
					}
				}
			});
		}
	});
	}

</script>

</html>
