<!DOCTYPE html>
<%
/********************************************************************************************************
*	Name			:	serviceDashboard.jsp
*	Purpose			:	This is the main jsp which includes different tabs used in the service Dashboard and relevant scripts
*	Version			:	5.4
*	CreationDate	:	nov 29 2011
*	Author			:	SriDevi Gururajan, S.Saravanan and A.Saravanan
	Session remove	:	by Saravanan.A on 11/Apr/2012.
*******************************************************************************************************/
%>
<%@ include file = "EgLoginTracker.jsp"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgTopoInfo" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page autoFlush="true" buffer="1094kb"%>
<%@ page import = "com.eg.supermanager.*" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "net.sf.json.JSONObject" %>
<%@ page import = "net.sf.json.JSONArray" %>
<%@ page import = "com.egurkha.HighChartTimeline" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgStateZone"%>
<%@ page import="com.eg.EgManagersIniForManager"%>
<%
	if(EgInstallInfo.isSuperManager)
	{
		String currentSession = session.getId();
		String service_From_Zone=request.getParameter("serviceFromZone");
		if(service_From_Zone != null && (service_From_Zone=service_From_Zone.trim()).length()>0)
		{
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("service",service_From_Zone);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(currentSession,managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);				
			}
		}
	}
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	request.setCharacterEncoding("UTF-8");
	String rumFlagCheck = "false";
	ServiceListData servicedata = (ServiceListData) request.getAttribute("data");
	ServiceListResult serviceresult = (ServiceListResult) request.getAttribute("result");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String optionalListPage = egUI.getValue("OptionalList_Pages","serviceList");
	String transactionChart = egUI.getValue("CHART_TYPE","transactionChart");
	transactionChart = ( transactionChart == null || transactionChart.trim().length() ==0 )?"area":transactionChart;
	String isArea = ( transactionChart.equalsIgnoreCase("area") )?"yes":"no";
	boolean isFromMenu = "true".equals(request.getParameter("isFromMenu"))?true:false;
	String servName = request.getParameter("serviceName");
	String showLegStr = request.getParameter("showLegend");
	showLegStr = (showLegStr == null || showLegStr.equals(""))?showLegStr = egUI.getValue("CHART_TYPE","showLegendsInCharts"):showLegStr;
	EgDateInfo egDt = new EgDateInfo();
	java.util.Date local_date = new java.util.Date(egDt.egetUTCDate());
	Calendar cal = Calendar.getInstance();
	cal.setTime(local_date);
	cal.setTimeZone(egDt.getRealTimeZone());
	EgTopoInfo topoInfo = new EgTopoInfo("manager");
	ArrayList rumServiceList = new ArrayList();
	ArrayList rumServicenameList = new ArrayList();
	if(serviceresult!=null && serviceresult.serviceList!=null /*&& serviceresult.serviceList.size() > 0 */)
	{
		session.setAttribute("ServiceListData",servicedata);
		session.setAttribute("ServiceListResult",serviceresult);
		for(int i = 0; i < serviceresult.serviceList.size(); i++)
		{
			EgService service = (EgService) serviceresult.serviceList.get(i);
			String servicename = service.getName();
			String servicestate = service.getState().getName();
			String findsHostname = "";
			if(servicename != null && servicename.trim().length() > 0){
				java.util.List serviceComps = topoInfo.getComponentsForSite(servicename);
				if(serviceComps != null && serviceComps.size() > 0){
					for( int p=0;p<serviceComps.size();p++){
						String compValue = (String)serviceComps.get(p);
						if(compValue.indexOf("Real_user_monitor") != -1){
							rumServiceList.add(compValue+":"+servicename+"^"+servicestate);
							rumServicenameList.add(servicename);
						}
					}
				}
			}
			session.setAttribute("ServiceListData",servicedata);
			session.setAttribute("ServiceListResult",serviceresult);
		}
	}
	else{
		ErUserData userData = new ErUserData("admin",false);
		User user = userData.getUser("admin");
		List listService  = (List) user.getServices();
		List listSites  = (List) user.getSites();
		HashSet trgtSet = new HashSet(listService);
		for(int p=0;p<listSites.size();p++){
			trgtSet.add(""+listSites.get(p));
		}
		ArrayList serList = new ArrayList(trgtSet);
		for(int l=0;l<serList.size();l++){
			String servicename = (String)serList.get(l);
			String servicestate = (String)EgStateZone.getState("Service:"+servicename+":NULL");
			if(servicestate==null || servicestate.trim().length()==0)
				servicestate ="GOOD";

			//String servicestate = "GOOD";

			String findsHostname = "";

			if(servicename != null && servicename.trim().length() > 0){
				java.util.List serviceComps = topoInfo.getComponentsForSite(servicename);
				if(serviceComps != null && serviceComps.size() > 0){
					for( int p=0;p<serviceComps.size();p++){
						String compValue = (String)serviceComps.get(p);
						if(compValue.indexOf("Real_user_monitor") != -1){
							rumServiceList.add(compValue+":"+servicename+"^"+servicestate);
							rumServicenameList.add(servicename);
						}
					}
				}
			}
		}
	}
	if(serviceresult==null || servicedata==null)
	{
		servicedata  = (ServiceListData)session.getAttribute("ServiceListData");
		serviceresult=(ServiceListResult)session.getAttribute("ServiceListResult");
	}
	String isSite=request.getParameter("isSite");
	String outsideService=request.getParameter("outsideService");
	String isfromTopology=request.getParameter("isfromTopology");
	isfromTopology=(isfromTopology==null)?"false":isfromTopology;
	String serviceFromZone=request.getParameter("serviceFromZone");
	serviceFromZone=(serviceFromZone==null)?"":serviceFromZone;

	String isEmulTrans=request.getParameter("isEmulTrans");
	String pageComesfrom=request.getParameter("pageComesfrom");
	ArrayList sitesOnly = topoInfo.getAllSitesOnly();
	if(sitesOnly!=null)
	{
		if(sitesOnly.contains(serviceFromZone))
		{
			isSite="true";
		}
	}
	
	String refFrequency = u_ser.getRefreshFrequency();
	long refreshFrequency = 60000L;
	if(refFrequency!=null && refFrequency.length()>0)
	{
		refreshFrequency =  Long.valueOf(refFrequency).longValue() * 1000L;
	}
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = ui.getDefaultLanguage();
	if (u_ser!=null)
	{
		String userLang = u_ser.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	Hashtable serviceRumMap = null;
	if(session != null)
		serviceRumMap = (Hashtable)session.getAttribute("serviceRumMap");
	

	String sessionID = session.getId();
	UserRegistry ur = UserRegistry.getInstance();
	User user = ur.getUser(sessionID);
	String userName = user.getLoginID();
	EgUserRole userRole = user.getUserRole();

	boolean isAllComponentAccess = false;
	if(EgInstallInfo.isClusterSupported)
	{
		EgManagersIniForManager mi = EgManagersIniForManager.getInstance();
		if(mi.isPrimaryManager() && userRole.hasAllComponentAccess())
		{
			isAllComponentAccess = true;
		}
	}
	else if(userRole.hasAllComponentAccess())
	{
		isAllComponentAccess = true;
	}

	boolean isAdminUser= userRole.hasAnyAdminRole(EgUserPermission.ADMIN);
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	String titleText = mappingInfo.getTextDescription("monitor.services.Services");
	String selectNode=request.getParameter("selectNode");
	selectNode = (selectNode==null)?"Service":selectNode;
	if(selectNode != null)
	{
		selectNode = com.egurkha.util.StringUtils.replace(selectNode,"|eq|","=");
		selectNode = com.egurkha.util.StringUtils.replace(selectNode,"|plus|","+");
		selectNode = com.egurkha.util.StringUtils.replace(selectNode,"|amp|","&");
		selectNode = com.egurkha.util.StringUtils.replace(selectNode,"|pct|","%");
		selectNode = com.egurkha.util.StringUtils.replace(selectNode,"|hash|","#");
		selectNode = com.egurkha.util.StringUtils.replace(selectNode,"$cap$","^");
		selectNode = com.egurkha.util.StringUtils.replace(selectNode,"$pipe$","|");
	}
	
	String treeFlagg=request.getParameter("treeFlag");
	treeFlagg=(treeFlagg==null)?"false":treeFlagg;
	String openNode=request.getParameter("openNode");
	String column=request.getParameter("column");
	String sortOrder=request.getParameter("sortOrder");
	String imageId=request.getParameter("imgId");
	String appcolumn=request.getParameter("appcolumn");
	String appsortOrder=request.getParameter("appsortOrder");
	String appimageId=request.getParameter("appimgId");
	String setAssociate=request.getParameter("setAssociate");
	//String limit=request.getParameter("limit");
	String appCurrentHost=request.getParameter("appCurrentHost");
	String aggregateComp = request.getParameter("aggregateComp");
	String currentTab=request.getParameter("currentTab");
	String topoSegment=request.getParameter("segment");
	String segmentVal=request.getParameter("segmentVal");
	String seglist=request.getParameter("seglist");
	String refresh = request.getParameter("refresh");
	String rumHost=request.getParameter("rumHost");
	String aggregateTab = request.getParameter("aggregateTab");
	String hasTransactions = request.getParameter("hasTransactions");
	String rumLinkFlag = request.getParameter("rumLinkFlag");
	String hasEmulatedTransactions = request.getParameter("hasEmulatedTransactions");
	String hasLogonSimulations = request.getParameter("hasLogonSimulations");
	String transTab=request.getParameter("transTab");
	//String QueryString=request.getQueryString();
	String configOnTopology=request.getParameter("configOnTopology");
	//for timeline in transaction page
	String time_line=request.getParameter("time_line");
	String mode=request.getParameter("mode");
	String starttime=request.getParameter("starttime");
	String endtime=request.getParameter("endtime");
	String starthr=request.getParameter("starthr");
	String endhr=request.getParameter("endhr");
	String transactionDiv=request.getParameter("transactionDiv");
	String graphId = request.getParameter("graphId");
	String transCompVal = request.getParameter("transCompVal");
	String selectEmulate = request.getParameter("selectEmulate");
	String treeOpen = request.getParameter("treeOpen");
	String selectedTreeNode = request.getParameter("selected");
	String action = request.getParameter("action");
	String zoom = request.getParameter("zoomGraph");
	String fromHomepage = request.getParameter("fromHomepage");	
	fromHomepage = (fromHomepage!=null && !fromHomepage.equalsIgnoreCase("") && !fromHomepage.equalsIgnoreCase("null") && !fromHomepage.equalsIgnoreCase("undefined"))?fromHomepage:"";
	//globalsearch
	String searchNameString=request.getParameter("searchString");
	String from=request.getParameter("from");
	String serviceGroup=request.getParameter("serviceGroup");
	String iszoneName=request.getParameter("iszoneName")!=null?request.getParameter("iszoneName"):"";
	String isFromZone = request.getParameter("isFromZone");
	String iscurrentTab=request.getParameter("iscurrentTab");
	String isaggregateTab=request.getParameter("isaggregateTab ");
	String isopenNode=request.getParameter("isopenNode ");
	String zoneName=request.getParameter("zoneName");
	String parentZone=request.getParameter("parentZone");
	String istreeFlag=request.getParameter("istreeFlag");
	String treeFlag=request.getParameter("treeFlag");
	String isfromHomepage=request.getParameter("isfromHomepage");
	isfromHomepage = (isfromHomepage!=null && !isfromHomepage.equalsIgnoreCase("") && !isfromHomepage.equalsIgnoreCase("null") && !isfromHomepage.equalsIgnoreCase("undefined"))?isfromHomepage:"";
	//String currentTab=request.getParameter("currentTab");
	String selectedParam = request.getParameter("selectedParam");
	String currentViewTab=request.getParameter("curViewTab");
	if(strCsrfToken==null||strCsrfToken.trim().length()==0)
		strCsrfToken = (String)request.getParameter("com.eg.CSRF_NONCE");
	strCsrfToken = (strCsrfToken==null || strCsrfToken.trim().length()==0)?"":strCsrfToken;
	String compLabel = "Components";
	String segLabel = "Segments";
	compLabel = mappingInfo.getTextDescription("monitor.common."+compLabel);
	segLabel = mappingInfo.getTextDescription("monitor.common."+segLabel);
	if(action!=null && (action.equalsIgnoreCase("globalsearch") || action.equalsIgnoreCase("globalsearchallservice")))
	{	
		if(searchNameString!=null)
		{
			session.setAttribute("globalSearchLastSessionval","service "+searchNameString);
		}	
		else
		{
			session.setAttribute("globalSearchLastSessionval","service *");
		}
	}
	
	//added for refresh of transactions
	String transComp= request.getParameter("transComp");
	String selectedTab="";
	selectedTab= request.getParameter("selectedTab");
	String LayerModelTopology= request.getParameter("LayerModelTopology");
	String fromlayerBack= request.getParameter("fromlayerBack");
	if(LayerModelTopology == null && rumServicenameList!=null && rumServicenameList.contains(selectedParam))
	{
		if(currentTab!=null && !currentTab.equalsIgnoreCase("undefined") && !currentTab.equalsIgnoreCase("null") &&  currentTab.equalsIgnoreCase("system"))
		{
			currentTab="system";
		}
		else if(currentTab!=null && !currentTab.equalsIgnoreCase("undefined") && !currentTab.equalsIgnoreCase("null") && currentTab.equalsIgnoreCase("components"))
		{
			currentTab="components";
		}
		else if(currentTab!=null && !currentTab.equalsIgnoreCase("undefined") && !currentTab.equalsIgnoreCase("null") && currentTab.equalsIgnoreCase("aggregates"))
		{
			currentTab="aggregates";
		}
		else
		{
			if(fromlayerBack!=null && fromlayerBack.equalsIgnoreCase("true"))
				currentTab = "topology";
			else
				currentTab = "transactions";
		}
	}
	/*
	if(limit==null || limit.length()<0)
	{
		limit=egUI.getValue("TREE_SYSTEM_SETTINGS","Default");
	}
	*/
	if(setAssociate==null)
	{
		setAssociate="";
	}
	String emul_trans_present_conf=request.getParameter("emul_trans_present");
	String trans_present=request.getParameter("trans_present");
	String siteName_conf=request.getParameter("siteName_conf");
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	//ServiceListData servicedata = (ServiceListData) request.getAttribute("data");
	//ServiceListResult serviceresult = (ServiceListResult) request.getAttribute("result");

	String showDashboard = request.getParameter("showDashboard");
	String tabText = "monitor.serviceDashboard."+ currentTab;
	String treeSession=(String)session.getAttribute("monitorLastSession");
	if(openNode != null && openNode.trim().equalsIgnoreCase("Services"))
		treeSession = null;
	String backButtonText=mappingInfo.getTextDescription("monitor.common.Back");
	String graphUrl=response.encodeURL("../servlet/com.egurkha.TransactionMeasuresDisplay?");

	String chartOption = egUI.getValue("CHART_TYPE","ChartOption");
	String chartTimeline = egUI.getValue("CHART_TYPE","Timeline");

	String thisPageSession=(String)session.getAttribute("thisPageSession");

	JSONObject lineStyles = new JSONObject();
	JSONObject mainKey = new JSONObject();
	JSONObject timeLabelSty = HighChartTimeline.getAxisProperty("xaxislabel");
	JSONObject axisLabelSty =  HighChartTimeline.getAxisProperty("title");
	JSONObject panelLineSty =  HighChartTimeline.getChartPanelLineProperty(false);
	lineStyles.put("timeLabelStyle",timeLabelSty);
	lineStyles.put("axisLabelStyle",axisLabelSty);
	lineStyles.put("panelLineStyle",panelLineSty);
	//lineStyles.put("max", yMax );
	mainKey.put("styles",lineStyles);
	String fromPage=request.getParameter("fromPage");
	String myDashboardBackUrl="";
	 if(fromPage!=null && fromPage.equalsIgnoreCase("myDashboard"))
	{
		String myDashboardUrlParams=request.getParameter("backBtnUrl");
		myDashboardUrlParams=StringUtils.decodeSecurityChar(myDashboardUrlParams);
		myDashboardBackUrl="/final/monitor/MyDashboard.jsp?comesFrom=myDashboard&action=showMyDashboard"+myDashboardUrlParams;
	}

%>
<jsp:useBean id = "sitebean" scope = "page" class = "egurkha.ConfigSiteBean"/>

<html class="content-frame">
<head>
<title><egui:intnl text="monitor.serviceDashboard.Dashboard"/></title>
<meta charset="utf-8" http-equiv="X-UA-Compatible" content="IE=8,9,10" >


<script  type="text/javascript">
var rumServiceList = new Array();
var rumServiceListObject = new Array();
var rumFlagCheck = 'false';
var isZoomMeasureGraph=false;
var csrfToken = '<%=strCsrfToken%>';
<%
	if(rumServiceList != null ){
		for(int c=0;c<rumServiceList.size();c++){
			String serviceData = (String) rumServiceList.get(c);
			//RUM_11.70:NULL:Real_user_monitor:rumBala
			String serviceNameVal = serviceData.substring(serviceData.lastIndexOf(":")+1);
			String serviceNameState = "GOOD";
			
			if(serviceNameVal!=null && serviceNameVal.indexOf("^")>-1)
			{
				serviceNameState = serviceNameVal.substring(serviceNameVal.lastIndexOf("^")+1);
				serviceNameVal = serviceNameVal.substring(0,serviceNameVal.lastIndexOf("^"));
				if(serviceNameVal.equalsIgnoreCase(selectedParam) && rumFlagCheck.equals("false"))
					rumFlagCheck = "true";
			}

			String serviceNameHost = serviceData.substring(0,serviceData.indexOf(":"));
			String portCheck = serviceData.substring(serviceData.indexOf(":")+1);
			String portCheckVal = portCheck.substring(0,portCheck.indexOf(":"));
			String compType = portCheck.substring(portCheck.indexOf(":")+1,portCheck.lastIndexOf(":"));

			%>
				var servObj = new Object();
				rumServiceList.push('<%=serviceNameVal%>');
				servObj.name = '<%=serviceNameVal%>';
				servObj.servicestate = '<%=serviceNameState%>';
				servObj.value = '<%=serviceNameHost%>';
				servObj.port = '<%=portCheckVal%>';
				servObj.compType = '<%=compType%>';
				rumServiceListObject.push(servObj);
				var hasTransactions = '<%=hasTransactions%>';
				var selectedParam = '<%=selectedParam%>';
				var fromlayerBack = '<%=fromlayerBack%>';
			<%
		}
	}
	
%>
rumFlagCheck = '<%=rumFlagCheck%>';
</script>

<script>
	var treePanelTitle="";
	var requestParams ="";
	var compSelectedValue=null;
	var isFromZone = '<%=isFromZone%>';
	var iszoneName = '<%=iszoneName%>';
	iszoneName = encodeURI(iszoneName);
	var isAreaChart= '<%=isArea%>';
	var fromPage='<%=fromPage%>';
	var rumHost='<%=rumHost%>';
	var myDashboardBackUrl = '<%=myDashboardBackUrl%>';
	var LayerModelTopology = '<%=LayerModelTopology%>';
</script>

<egui:skin ui="monitor"/>
<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="services" appFile="services.js"/>

<link type="text/css" href="../styles/jscrollpane/jquery.jscrollpane.css" rel="stylesheet" media="all" />
<style>
	span.decimal-align{float: left; text-align: right; width:50%}
	span.decimal-align2{float: right; text-align: left; width:50%}
</style>

<script src="/final/scripts/eg_DateUtil.js"></script>
<script src="/final/jquery/jquery.js"></script>
<script src="../styles/jscrollpane/jquery.jscrollpane.js"></script>
<script src="../styles/jscrollpane/jquery.mousewheel.js"></script>
<script src="../styles/jscrollpane/mwheelIntent.js"></script>
<script src="/final/monitor/eg_scripts/eg_date.js"></script>
<script src="/final/Highcharts/js/highstock.js"></script>
<script src="/final/monitor/eg_scripts/EgHighChart.js"></script>


<script>
	var hideBackButton = <%=isFromMenu%>;
	var compLabel="<%=compLabel%>";
	var segLabel="<%=segLabel%>";
	function parseScript(_source)
	{
		var source = _source;
		var scripts = new Array();
		// Strip out tags
		if(source!=null && source!=undefined &&  source!='undefined')
		{
			while(source.indexOf("<script") > -1 || source.indexOf("</script") > -1) 
			{
				var s = source.indexOf("<script");
				var s_e = source.indexOf(">", s);
				var e = source.indexOf("</script", s);
				var e_e = source.indexOf(">", e);			
				// Add to scripts array
				scripts.push(source.substring(s_e+1, e));
				// Strip from source
				source = source.substring(0, s) + source.substring(e_e+1);
			}
		}
		// Loop through every script collected and eval it
		for(var i=0; i<scripts.length; i++) {
			try {
				eval(scripts[i]);
			}
			catch(ex) {
				return;
			}
		}
		// Return the cleaned source
		return source;
	}
	Ext.onReady(function(){
		Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.Ajax.on('requestexception', function (conn, response, options){
			var errorStr = response.responseText;
			parseScript(errorStr);
			if (!Ext.isEmpty(errorStr) && errorStr!=null && errorStr!=undefined &&  errorStr!='undefined' && errorStr.indexOf("customerror") != -1)
			{
				if (errorStr.indexOf("user-session-invalid") != -1)
				{
					callWindow(1);
				}
				else if (errorStr.indexOf("user-deleted") != -1)
				{
					callWindow(2);
				}
				else if (errorStr.indexOf("user-timedout") != -1)
				{
					callWindow(3);
				}
			}
		});
		initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
	});
	var showDashboard = false;
	treePanelTitle='<%=mappingInfo.getTextDescription("monitor.common.Services")%>';
	var listView = '<%=mappingInfo.getTextDescription("monitor.common.List View")%>';
	var gridView = '<%=mappingInfo.getTextDescription("monitor.common.Grid View")%>';
	var associations = '<%=mappingInfo.getTextDescription("monitor.common.Associations")%>';
	var userServiceAssociation = '<%=mappingInfo.getTextDescription("monitor.zoneDashboard.User and Service Associations")%>';
	var disptxt = '<egui:intnl text="monitor.common.Displaying"/>';
	var oftxt = '<egui:intnl text="monitor.common.of"/>';
	treePanelTitle="Services";
	var optionalListFlag = false;
	var user = "<%=userName%>";
	var mgr_dateFormat= getExtjsDateFormat('<%=dateFormatForDatePicker%>');
	requestParams = new Object();
	var refreshFrequency = <%=refreshFrequency%>;
	requestParams.treeSession = "<%=treeSession%>";
	requestParams.from = "<%=from%>";
	var curMonthStr = '<%=(cal.get(cal.MONTH)+1)%>';
	var curMnthInt = parseInt( curMonthStr );
	curMonthStr = ( curMnthInt <= 9 )?0+curMonthStr:curMonthStr;
	var curr_date_value=curMonthStr+"/"+'<%=cal.get(cal.DAY_OF_MONTH)+"/"+cal.get(cal.YEAR)%>';
	var cur_mgr_hour_str = '<%=cal.get(cal.HOUR_OF_DAY)%>';
	var cur_mgr_hour = parseInt(cur_mgr_hour_str);
	cur_mgr_hour_str = ( cur_mgr_hour <= 9 )?0+cur_mgr_hour_str:cur_mgr_hour_str;
	var curr_min_str  ='<%=cal.get(cal.MINUTE)%>';
	var cur_mgr_min = parseInt(curr_min_str);
	curr_min_str = ( cur_mgr_min <= 9 )?0+curr_min_str:curr_min_str;
	var curDateTime = curr_date_value+" "+cur_mgr_hour_str+":"+curr_min_str+":00";
	var logonChartType = '';
	var currentViewTab = '<%=currentViewTab%>';
<%
	if(treeSession!=null && treeSession.indexOf("zoneDash.jsp")>-1)
	{
		session.setAttribute("thisPageSession",treeSession);
	}
	else if(thisPageSession!=null && thisPageSession.indexOf("zoneDash.jsp")>-1)
	{
		session.removeAttribute("thisPageSession");
%>
		requestParams.treeSession='<%=thisPageSession%>';
<%
	}
%>
	requestParams.zoomGraph = false;
	requestParams.graphId = false;

	if('<%=zoom%>' != 'null' && '<%=zoom%>' != null && '<%=zoom%>' != 'undefined' && '<%=zoom%>' != undefined && '<%=zoom%>' != ''){
		requestParams.zoomGraph = '<%=zoom%>';
		requestParams.graphId = '<%=graphId%>';
	}

	if('<%=refresh%>' == 'true'){
		requestParams.refresh = 'true';
	}
	else{
		requestParams.refresh = 'false';
	}
	if('<%=openNode%>' != 'null' && '<%=openNode%>' != null && '<%=openNode%>' != 'undefined' && '<%=openNode%>' != undefined && '<%=openNode%>' != '')
		requestParams.selectedTreeNode = '<%=openNode%>';

	if('<%=treeOpen%>' == 'true')
		requestParams.treeOpen = 'true';
	else
		requestParams.treeOpen = 'false';

	if('<%=currentTab%>' != 'null' && '<%=currentTab%>' != null && '<%=currentTab%>' != 'undefined' && '<%=currentTab%>' != undefined && '<%=currentTab%>' != '')
	{
		requestParams.selectedTab = '<%=currentTab%>';
		if(requestParams.refresh == 'true')
			showDashboard = true;
	}

	if('<%=topoSegment%>' != 'null' && '<%=topoSegment%>' != null && '<%=topoSegment%>' != 'undefined' && '<%=topoSegment%>' != undefined && '<%=topoSegment%>' != '')
		requestParams.topoSegment = encodeURI('<%=topoSegment%>');
	else if('<%=selectedParam%>' != 'null' && '<%=selectedParam%>' != null && '<%=selectedParam%>' != 'undefined' && '<%=selectedParam%>' != undefined && '<%=selectedParam%>' != '' && '<%=selectedParam%>' != 'Services')
		requestParams.topoSegment = encodeURI('<%=selectedParam%>');

	if('<%=segmentVal%>' != null && '<%=segmentVal%>' != 'null' && '<%=segmentVal%>' != 'undefined' && '<%=segmentVal%>' != undefined && '<%=segmentVal%>' != '')
		requestParams.segmentVal = encodeURI('<%=segmentVal%>');
	else
		requestParams.segmentVal="";

	if('<%=seglist%>' != null && '<%=seglist%>' != 'null' && '<%=seglist%>' != 'undefined' && '<%=seglist%>' != undefined && '<%=seglist%>' != '')
		requestParams.seglist = encodeURI('<%=seglist%>');
	else
		requestParams.seglist="";

	if('<%=appCurrentHost%>' != 'null' && '<%=appCurrentHost%>' != null && '<%=appCurrentHost%>' != 'undefined' && '<%=appCurrentHost%>' != undefined && '<%=appCurrentHost%>' != '')
		requestParams.appCurrentHost = '<%=appCurrentHost%>';

	if('<%=aggregateComp%>' != 'null' && '<%=aggregateComp%>' != null && '<%=aggregateComp%>' != 'undefined' && '<%=aggregateComp%>' != undefined && '<%=aggregateComp%>' != '')
		requestParams.aggregateComp = '<%=aggregateComp%>';

	if('<%=transComp%>' != 'null' && '<%=transComp%>' != null && '<%=transComp%>' != 'undefined' && '<%=transComp%>' != undefined && '<%=transComp%>' != '')
		requestParams.transComp = '<%=transComp%>';

	if('<%=aggregateTab%>' != 'null' && '<%=aggregateTab%>' != null && '<%=aggregateTab%>' != 'undefined' && '<%=aggregateTab%>' != undefined && '<%=aggregateTab%>' != '')
		requestParams.aggregateTab = '<%=aggregateTab%>';

	if('<%=hasTransactions%>' != 'null' && '<%=hasTransactions%>' != null && '<%=hasTransactions%>' != 'undefined' && '<%=hasTransactions%>' != undefined && '<%=hasTransactions%>' != '')
		requestParams.hasTransactions = '<%=hasTransactions%>';

	if('<%=fromlayerBack%>' != 'null' && '<%=fromlayerBack%>' != null && '<%=fromlayerBack%>' != 'undefined' && '<%=fromlayerBack%>' != undefined && '<%=fromlayerBack%>' != '')
		requestParams.fromlayerBack = '<%=fromlayerBack%>';
	else
		requestParams.fromlayerBack = 'false';

	if('<%=fromHomepage%>' != 'null' && '<%=fromHomepage%>' != null && '<%=fromHomepage%>' != 'undefined' && '<%=fromHomepage%>' != undefined && '<%=fromHomepage%>' != '')
		requestParams.fromHomepage = '<%=fromHomepage%>';			//	Kaliraj

	if('<%=hasEmulatedTransactions%>' != 'null' && '<%=hasEmulatedTransactions%>' != null && '<%=hasEmulatedTransactions%>' != 'undefined' && '<%=hasEmulatedTransactions%>' != undefined && '<%=hasEmulatedTransactions%>' != '')
		requestParams.hasEmulatedTransactions = '<%=hasEmulatedTransactions%>';

	if('<%=hasLogonSimulations%>' != 'null' && '<%=hasLogonSimulations%>' != null && '<%=hasLogonSimulations%>' != 'undefined' && '<%=hasLogonSimulations%>' != undefined && '<%=hasLogonSimulations%>' != '')
		requestParams.hasLogonSimulations = '<%=hasLogonSimulations%>';
	else
		requestParams.hasLogonSimulations = false;

	//iszoneName
	if('<%=iszoneName%>' != 'null' && '<%=iszoneName%>' != null && '<%=iszoneName%>' != 'undefined' && '<%=iszoneName%>' != undefined && '<%=iszoneName%>' != '')
		requestParams.iszoneName = '<%=iszoneName%>';

	
	if('<%=zoneName%>' != 'null' && '<%=zoneName%>' != null && '<%=zoneName%>' != 'undefined' && '<%=zoneName%>' != undefined && '<%=zoneName%>' != '')
		requestParams.zoneName = '<%=zoneName%>';

	if('<%=parentZone%>' != 'null' && '<%=parentZone%>' != null && '<%=parentZone%>' != 'undefined' && '<%=parentZone%>' != undefined && '<%=parentZone%>' != '')
		requestParams.parentZone = '<%=parentZone%>';	

	// iscurrentTab
	if('<%=iscurrentTab%>' != 'null' && '<%=iscurrentTab%>' != null && '<%=iscurrentTab%>' != 'undefined' && '<%=iscurrentTab%>' != undefined && '<%=iscurrentTab%>' != '')
		requestParams.iscurrentTab = '<%=iscurrentTab%>';

	//isaggregateTab
	if('<%=isaggregateTab%>' != 'null' && '<%=isaggregateTab%>' != null && '<%=isaggregateTab%>' != 'undefined' && '<%=isaggregateTab%>' != undefined && '<%=isaggregateTab%>' != '')
		requestParams.isaggregateTab = '<%=isaggregateTab%>';

	//isopenNode
	if('<%=isopenNode%>' != 'null' && '<%=isopenNode%>' != null && '<%=isopenNode%>' != 'undefined' && '<%=isopenNode%>' != undefined && '<%=isopenNode%>' != '')
		requestParams.isopenNode = '<%=isopenNode%>';

	if('<%=currentTab%>' != 'null' && '<%=currentTab%>' != null && '<%=currentTab%>' != 'undefined' && '<%=currentTab%>' != undefined && '<%=currentTab%>' != '')
		requestParams.currentTab = '<%=currentTab%>';

	if('<%=istreeFlag%>' != 'null' && '<%=istreeFlag%>' != null && '<%=istreeFlag%>' != 'undefined' && '<%=istreeFlag%>' != undefined && '<%=istreeFlag%>' != '')
		requestParams.istreeFlag = '<%=istreeFlag%>';

	if('<%=treeFlag%>' != 'null' && '<%=treeFlag%>' != null && '<%=treeFlag%>' != 'undefined' && '<%=treeFlag%>' != undefined && '<%=treeFlag%>' != '')
		requestParams.treeFlag = '<%=treeFlag%>';

	if('<%=isfromHomepage%>' != 'null' && '<%=isfromHomepage%>' != null && '<%=isfromHomepage%>' != 'undefined' && '<%=isfromHomepage%>' != undefined && '<%=isfromHomepage%>' != '')
		requestParams.isfromHomepage = '<%=isfromHomepage%>';

	//serviceGroup
	if('<%=serviceGroup%>' != 'null' && '<%=serviceGroup%>' != null && '<%=serviceGroup%>' != 'undefined' && '<%=serviceGroup%>' != undefined && '<%=serviceGroup%>' != '')
		requestParams.serviceGroup = '<%=serviceGroup%>';

	var optionalListFlag = false;
	if("<%=optionalListPage%>" == "true" || "<%=optionalListPage%>" == "True" || "<%=optionalListPage%>" == "TRUE" || "<%=optionalListPage%>" == "yes" || "<%=optionalListPage%>" == "Yes" || "<%=optionalListPage%>" == "YES"){
		 optionalListFlag = true;
	}

	requestParams.sessionURL = 'monCmd=serviceList&from=MainDashboard&action=service&<%=request.getQueryString()%>';
	requestParams.systemTabText = '<%=mappingInfo.getTextDescription("monitor.common.Systems")%>';
	requestParams.componentsTabText = '<%=mappingInfo.getTextDescription("monitor.common.Components")%>';
	requestParams.topologyTabText = '<%=mappingInfo.getTextDescription("monitor.common.Topology")%>';
	requestParams.transactionTabText = '<%=mappingInfo.getTextDescription("monitor.common.Transactions")%>';
	requestParams.backButtonText = '<%=backButtonText%>';
	requestParams.time_line = '<%=time_line%>';
	requestParams.mode = '<%=mode%>';
	requestParams.starttime = '<%=starttime%>';
	requestParams.endtime = '<%=endtime%>';
	requestParams.starthr = '<%=starthr%>';
	requestParams.endhr = '<%=endhr%>';
	requestParams.action = '<%=action%>';
	var isAllComponentAccess = <%=isAllComponentAccess%>;

	requestParams.aggError = '<%=mappingInfo.getTextDescription("monitor.common.No metrics running")%>';

	documentView ={
		getObject: function()
		{
			if(typeof( window.innerWidth) == 'number')
			{//Firefox
				this.height = window.innerHeight;
				this.width = window.innerWidth;
				this.fireFox = true;
			}
			else if( document.documentElement && ( document.documentElement.clientWidth
				|| document.documentElement.clientHeight ))
			{//IE 6 + in 'standards compliant mode'
				this.height = document.documentElement.clientHeight;
				this.width = document.documentElement.clientWidth;
				this.ie = true;
			}
			else if(document.body && document.body.clientHeight)
			{ //IE 4 compatible
				this.height = document.body.clientHeight;
				this.width = document.body.clientWidth;
				this.ie = true;
			}
			return this;
		},
		getHeight: function()
		{
			return this.getObject().height;
		},
		getWidth: function()
		{
			return this.getObject().width;
		},
		isIE: function()
		{
			return this.getObject().ie;
		},
		isFireFox: function()
		{
			return this.getObject().fireFox;
		}
	};

	function isIE()
	{
		var ver = navigator.appVersion;
		ver = ver.toLowerCase();
		if (ver.indexOf("msie ") > 0 || document.all)
			return true;
		else
			return false;
	};

/*



function treeLoad(fromTab){
	 var currTab="<%=currentTab%>";
	 if(currTab==null ||currTab=="null" )
		{
			currTab="";
		}
		if(fromTab!=null && fromTab!=undefined && fromTab!="null")
		{
			currTab=fromTab;
		}
		if(currTab=='status' || currTab=="")
		{
			if("<%=outsideService%>"=="true")//if link come from outside for transaction and topology
			{
				var service="<%=serviceFromZone%>";
				var isSite="<%=isSite%>";
				var isEmulTrans="<%=isEmulTrans%>";
				goToStatusTab(service,isSite,isEmulTrans);
				return;
			}else if("<%=showDashboard%>"!="false" && "<%=showDashboard%>"!="null"){
				showDashboard="<%=showDashboard%>";
				requestParams.selectNode="<%=selectNode%>";
				requestParams.selectedParam="<%=selectedParam%>";
				requestParams.openNode="<%=openNode%>";
				requestParams.treeFlag=<%=treeFlagg%>;
				requestParams.isSite="<%=isSite%>";
			}
			//fillStatusTab('Zone','upperDeckID');
		}else if(currTab=='System'){
		    showDashboard="0";
		    requestParams.selectNode="<%=selectNode%>";
			requestParams.selectedParam="<%=selectedParam%>";
			requestParams.openNode="<%=openNode%>";
			requestParams.treeFlag=<%=treeFlagg%>;
			requestParams.isSite="<%=isSite%>";
	}else if(currTab=='application')
	{
		showDashboard="1";
	    requestParams.selectNode="<%=selectNode%>";
		requestParams.selectedParam="<%=selectedParam%>";
		requestParams.openNode="<%=openNode%>";
		requestParams.treeFlag=<%=treeFlagg%>;
		requestParams.isSite="<%=isSite%>";
	}
	else
	{
		showDashboard="2";
		if("<%=showDashboard%>"!="false" && "<%=showDashboard%>"!="null" && "<%=showDashboard%>"!=""){
			showDashboard=<%=showDashboard%>;
		}
	    requestParams.selectNode="<%=selectNode%>";
		requestParams.selectedParam="<%=selectedParam%>";
		requestParams.openNode="<%=openNode%>";
		requestParams.treeFlag=<%=treeFlagg%>;
		requestParams.isSite="<%=isSite%>";
	}
}

var gotoTopology='false';
var fromLayer='false';

function goToStatusTab(service,isSite,isEmulTrans)
{
	var site_present=isSite;
	var nName='Service^'+service;
	if(site_present=='true')
	{
		nName=nName+'(Site)';
	}
	var selType='Service';
	var selParam=service;
	var selTab='2';
	if("<%=showDashboard%>"!="false" && "<%=showDashboard%>"!="null"){
		selTab=<%=showDashboard%>;
	}	
	gotoTopology='true';
	fromLayer='true';
	changeURL(nName,selType,selParam,selTab,site_present,isEmulTrans);
}

function changeURL(nName,selType,selParam,selTab,isSite,isEmulatedTrans)
{
	var selectedType = selType;
	var selectedParam = selParam;
	var selectedTab = selTab;
	var trans_present=false;
	
<%
	String str_iniFileName = "eg_topology.ini";
	EgTopoInfo topoinfo = new EgTopoInfo("manager");
	String subject = "TRANSACTIONS";
	//strVarArr = ini_top.getVariables(subject);
	String strVarArr[] = topoinfo.getVariables(subject);
	if(strVarArr.length > 0)
	{
		for(int i=0; i<strVarArr.length; i++)
		{
			String site = strVarArr[i];
			site = site.substring(0,site.lastIndexOf(":"));
%>
			var temp_site="<%=site%>";
			if(temp_site==selParam)
			{
				trans_present = 'true';
			}
<%
		}
	}
%>
	if(selectedType!=null && selectedType == 'Service')
	{
		//if(selectedTab!=null && selectedTab == '2')
		//{
			var isfromTopology="<%=isfromTopology%>";
			if(gotoTopology=='true')
			{
				if(isSite=='true'&& trans_present=="true" && isfromTopology!="true")
				{
					transPresent = true;
					showDashboard=selectedTab;
	 				requestParams.selectNode="<%=selectNode%>";
	 				requestParams.selectedParam=selParam;
	 				requestParams.openNode="<%=openNode%>";
	 				requestParams.isSite="<%=isSite%>";
	 				//requestParams.treeFlag=<%=treeFlagg%>;
				}
				else if(isEmulatedTrans=="true")
				{
					showDashboard=selectedTab;
	 				requestParams.selectNode="<%=selectNode%>";
	 				requestParams.selectedParam=selParam;
	 				requestParams.openNode="<%=openNode%>";
	 				requestParams.isSite="<%=isSite%>";
	 			//	requestParams.treeFlag=<%=treeFlagg%>;
				}
				else
				{
					showDashboard=selectedTab;
	 				requestParams.selectNode="<%=selectNode%>";
	 				requestParams.selectedParam=selParam;
	 				requestParams.isSite=isSite;
	 				requestParams.openNode="<%=openNode%>";
	 				requestParams.isSite="<%=isSite%>";
	 				//requestParams.treeFlag=<%=treeFlagg%>;
				}
				gotoTopology='false';
				return;
			}
			    showDashboard=0;
				requestParams.selectNode="<%=selectNode%>";
				requestParams.selectedParam=selParam;
				requestParams.openNode="<%=openNode%>";
				requestParams.treeFlag=<%=treeFlagg%>;
				requestParams.isSite="<%=isSite%>";
				if(trans_present=="true"){
					transPresent = true;
				}
			//fillSystemTab('/final/monitor/serviceSystem.jsp?treeTitle=services&selectedNode='+selectedParam);
		//}
	}
}

function checkspecial(obj_val,s_spl)
{
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			//alert(_checkspecial);
			return false;
		}
	}
	return true;
}
function checkspace(s_val)
{
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			//alert(_checkblank);
			return false;
		}
	}
	return true;
}
function checkblank(str_Value)
{
	if(str_Value.length==0)
	{
		int_Flag=0;
	}
	for(i=1;i<=str_Value.length ;i++)
	{
		if(str_Value.charAt(i-1) == " ")
		{
			int_Flag=0;
		}
		else
		{
			int_Flag = 1;
			break;
		}
	}
	if(int_Flag != 1)
	{
		return false;
	}
	return true;
}
function goToLayerModel(url)
{
    $panel = $j('.listPageRight').html('');
    $j('<iframe/>', 
    {
        id: 'layerIframe',
        src: url+"&ComponentTree=false",
        height:'100%',
        width:'100%'
    }).appendTo($panel);
}
function checkUniquePage(pagename,pages)
{
	var pages_list = pagename;
	var count = 0;

	for(var k=0;k < pages_list.length;k++)
	{
		if(pages_list[k] == pages)
		{
			count = count + 1;
		}
	}
	if(count > 1)
	{
		return false;
	}
	else
	{
		return true;
	}
}
function validateTrans(pages,validationMessages)
{
	var maxcount = eval(6);
	var check;
	num = 0;

	if(pages.indexOf(",") > -1)
	{
		for(var k=0;k < pages.length;k++)
		{
			if(pages.charAt(k) == ',' && pages.charAt(k + 1) == ',')
			{
				var str =(validationMessages["Cannot have"] +' , '+["in consecutive positions"]);
				alert(str);
				return false;
			}
			else
			{
				continue;
			}
		}
		var pages_list = pages.split(",");
		if(pages_list.length > maxcount)
		{
			alert(validationMessages["Maximum number of pages associated with a transaction can only be 6"]);
			return false;
		}
		for(var x=0;x < pages_list.length;x++)
		{
			check = pages_list[x];
			num = 0;
			for(c=0; c < check.length; c++)
			{
				if(check.charAt(c) == '*')
				{
					num++;
				}
			}
			if(num > 6)
			{
				alert(validationMessages["Maximum number of patterns in a page can only be 6"]);
				return false;
			}
			if(!checkUniquePage(pages_list,pages_list[x]))
			{
				alert();
				return false;
			}
			if(pages_list[x].length > 48)
			{
				alert(validationMessages["Maximum length of a page associated with a transaction can only be 48 characters"]);
				return false;
			}
		}
	}
	else
	{
		for(c=0; c < pages.length; c++)
		{
			if(pages.charAt(c) == '*')
			{
				num++;
			}
		}
		if(num > 6)
		{
			alert(validationMessages["Maximum number of patterns in a page can only be 6"]);
			return false;
		}
		if(pages.length > 48)
		{
			alert(validationMessages["Maximum length of a page associated with a transaction can only be 48 characters"]);
			return false;
		}
	}
	return true;
}
function validateSingleByte(input)
{
	for(var i=0;i<input.length;i++)
	{
		var charValue=input.charCodeAt(i);
		if(charValue>255)
			return false;
	}
	return true;
}
function checkcomma(s_val)
{
	var	len = s_val.length;
	if(s_val.indexOf(",") > -1)
	{
		if(s_val.charAt(0) == ',' || s_val.charAt(len-1) == ',')
		{
			//alert("Please enter a port number");
			return false;
		}
	}
	return true;
}
var maxTransactions = 12;
function valform(transNm,tPages,tImage,trancount,translist,site,webTransactions,emulTransactions,currentuser,mode,validationMessages)
{
	var sub = "true";
	var formflag = 1;
	var trans_arr=translist.split(";");
	for(var j=0;j < trans_arr.length;j++)
	{
		if(transNm == trans_arr[j])
		{
			formflag = 0;
		}
	}
	var transName=true;
	if('<%=isDouble%>'=="false")
	{
		transName = validateSingleByte(transNm);
	}
	if(formflag == 0)
	{
		alert(validationMessages["Please enter unique transaction name"]);
		sub = "false";
	}
	else if(Ext.isEmpty(transNm))
	{
		alert(validationMessages["Please enter the transaction name"]);
		sub = "false";
	}
	 else if(!checkspecial(transNm,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,.?\/"))
	{
		sub = "false";
	}
	else if(!checkspace(transNm))
	{
		sub = "false";
	}
	else if(!transName)
	{
		alert(validationMessages["Transaction Name is not allowed in DBL"]);
		sub = "false";
	}
	else if(!checkblank(tPages))
	{
		alert(validationMessages["Please enter the pages associated"]);
		sub = "false";
	}
	else if(!checkspecial(tPages,"`~!@#$%^()[]{}|;\'\"<>"))
	{
		sub = "false";
	}
	else if(!checkspace(tPages))
	{
		sub = "false";
	} 
	else if(!validateTrans(tPages,validationMessages))
	{
		sub = "false";
	}
	else if(!checkcomma(tPages))
	{
		alert(validationMessages["Please enter the pages associated"]);
		sub = "false";
	}
	else if(!validateSingleByte(tPages))
	{
		alert(validationMessages["Pages to be Included is not allowed in DBL"]);
		sub = "false";
	}
	else if(tImage=="")
	{
		alert(validationMessages["Please select transaction image"]);
		sub = "false";
	}
	else if(trancount >= maxTransactions)
	{
		alert(validationMessages["Maximum number of transactions for a website cannot exceed"]+maxTransactions);
		sub = "false";
	}
	else
	{
		sub = "true";
	}
	if(sub == "true")
	{
		var user="<%=userName%>"; 
		var url="/final/monitor/addTransactionsP.jsp?";
		param='mode='+mode+'&trans='+translist+'&site='+site+'&user='+user+'&webTransactions='+webTransactions+'&emulTransactions='+emulTransactions+'&currentuser='+user+'&tran='+transNm+'&tranlist='+tPages+'&m='+tImage;
		url = url+param;
		return url;
	}else{
		return null;
	}*/

	function checkUniquePage(pagename,pages)
	{
		var pages_list = pagename;
		var count = 0;

		for(var k=0;k < pages_list.length;k++)
		{
			if(pages_list[k] == pages)
			{
				count = count + 1;
			}
		}
		if(count > 1)
		{
			return false;
		}
		else
		{
			return true;
		}
	}

	function validateTrans(pages,validationMessages)
	{
		var maxcount = eval(6);
		var check;
		num = 0;

		if(pages.indexOf(",") > -1)
		{
			for(var k=0;k < pages.length;k++)
			{
				if(pages.charAt(k) == ',' && pages.charAt(k + 1) == ',')
				{
					var str =(validationMessages["Cannot have"] +' , '+["in consecutive positions"]);
					alert(str);
					return false;
				}
				else
				{
					continue;
				}
			}
			var pages_list = pages.split(",");
			if(pages_list.length > maxcount)
			{
				alert(validationMessages["Maximum number of pages associated with a transaction can only be 6"]);
				return false;
			}
			for(var x=0;x < pages_list.length;x++)
			{
				check = pages_list[x];
				num = 0;
				for(c=0; c < check.length; c++)
				{
					if(check.charAt(c) == '*')
					{
						num++;
					}
				}
				if(num > 6)
				{
					alert(validationMessages["Maximum number of patterns in a page can only be 6"]);
					return false;
				}
				if(!checkUniquePage(pages_list,pages_list[x]))
				{
					alert();
					return false;
				}
				if(pages_list[x].length > 48)
				{
					alert(validationMessages["Maximum length of a page associated with a transaction can only be 48 characters"]);
					return false;
				}
			}
		}
		else
		{
			for(c=0; c < pages.length; c++)
			{
				if(pages.charAt(c) == '*')
				{
					num++;
				}
			}
			if(num > 6)
			{
				alert(validationMessages["Maximum number of patterns in a page can only be 6"]);
				return false;
			}
			if(pages.length > 48)
			{
				alert(validationMessages["Maximum length of a page associated with a transaction can only be 48 characters"]);
				return false;
			}
		}
		return true;
	}
	function validateSingleByte(input)
	{
		for(var i=0;i<input.length;i++)
		{
			var charValue=input.charCodeAt(i);
			if(charValue>255)
				return false;
		}
		return true;
	}
	function checkcomma(s_val)
	{
		var	len = s_val.length;
		if(s_val.indexOf(",") > -1)
		{
			if(s_val.charAt(0) == ',' || s_val.charAt(len-1) == ',')
			{
				//alert("Please enter a port number");
				return false;
			}
		}
		return true;
	}

	function checkspecial(obj_val,s_spl)
	{
		for(var i=0; i<obj_val.length; i++)
		{
			check_char = s_spl.indexOf(obj_val.charAt(i))
			//Returns value 1 if the special character listed in splChar is found
			if(check_char >= 0)
			{
				//alert(_checkspecial);
				return false;
			}
		}
		return true;
	}
	function checkspace(s_val)
	{
		for(count = 0; count < s_val.length; count++)
		{
			if(s_val.charAt(count) == ' ')
			{
				//alert(_checkblank);
				return false;
			}
		}
		return true;
	}
	function checkblank(str_Value)
	{
		if(str_Value.length==0)
		{
			int_Flag=0;
		}
		for(i=1;i<=str_Value.length ;i++)
		{
			if(str_Value.charAt(i-1) == " ")
			{
				int_Flag=0;
			}
			else
			{
				int_Flag = 1;
				break;
			}
		}
		if(int_Flag != 1)
		{
			return false;
		}
		return true;
	}

	var maxTransactions = 12;
	function valform(transNm,tPages,tImage,trancount,translist,site,webTransactions,emulTransactions,currentuser,mode,validationMessages)
	{
		var sub = "true";
		var formflag = 1;
		var trans_arr=translist.split(";");
		for(var j=0;j < trans_arr.length;j++)
		{
			if(transNm == trans_arr[j])
			{
				formflag = 0;
			}
		}
		var transName=true;
		if('<%=isDouble%>'=="false")
		{
			transName = validateSingleByte(transNm);
		}
		if(formflag == 0)
		{
			alert(validationMessages["Please enter unique transaction name"]);
			sub = "false";
		}
		else if(Ext.isEmpty(transNm))
		{
			alert(validationMessages["Please enter the transaction name"]);
			sub = "false";
		}
		 else if(!checkspecial(transNm,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,.?\/"))
		{
			sub = "false";
		}
		else if(!checkspace(transNm))
		{
			sub = "false";
		}
		else if(!transName)
		{
			alert(validationMessages["Transaction Name is not allowed in DBL"]);
			sub = "false";
		}
		else if(!checkblank(tPages))
		{
			alert(validationMessages["Please enter the pages associated"]);
			sub = "false";
		}
		else if(!checkspecial(tPages,"`~!@#$%^()[]{}|;\'\"<>"))
		{
			sub = "false";
		}
		else if(!checkspace(tPages))
		{
			sub = "false";
		} 
		else if(!validateTrans(tPages,validationMessages))
		{
			sub = "false";
		}
		else if(!checkcomma(tPages))
		{
			alert(validationMessages["Please enter the pages associated"]);
			sub = "false";
		}
		else if(!validateSingleByte(tPages))
		{
			alert(validationMessages["Pages to be Included is not allowed in DBL"]);
			sub = "false";
		}
		else if(tImage=="")
		{
			alert(validationMessages["Please select transaction image"]);
			sub = "false";
		}
		else if(trancount >= maxTransactions)
		{
			alert(validationMessages["Maximum number of transactions for a website cannot exceed"]+maxTransactions);
			sub = "false";
		}
		else
		{
			sub = "true";
		}
		if(sub == "true")
		{
			var user="<%=userName%>"; 
			var url="/final/monitor/addTransactionsP.jsp?";
			param='mode='+mode+'&trans='+translist+'&site='+site+'&user='+user+'&webTransactions='+webTransactions+'&emulTransactions='+emulTransactions+'&currentuser='+user+'&tran='+transNm+'&tranlist='+tPages+'&m='+tImage;
			url = url+param;
			return url;
		}else{
			return null;
		}
	}

	function loadTransConfigOnTopo(site)
	{
		var url ='/final/monitor/addTransactions.jsp';
		
		//if(site=='' || site=='null' || site==undefined || site=='null')
		//{
		//	 site=$j("#topo_site").val();
		//}
		var param='site='+encodeURI(site)+'&fromPage=Topology';
		var selectNode="<%=selectNode%>";
		var selectedParam="<%=selectedParam%>";
		var openNode="<%=openNode%>";
		var treeFlag="<%=treeFlagg%>";
		var currentTab="<%=currentTab%>";
		var transTab="<%=transTab%>";
		var configOnTopology="<%=configOnTopology%>";
		var isSite="<%=isSite%>";
		
		//param=param+'&param='+param+'&selectNode='+encodeURI(selectNode)+'&selectedParam='+encodeURI(selectedParam)+'&openNode='+openNode+'&treeFlag='+treeFlag+'&currentTab='+currentTab+'&transTab='+transTab+'&configOnTopology='+encodeURI(configOnTopology)+'&isSite='+isSite;
		
		param=param+'&selectNode='+encodeURI(selectNode)+'&selectedParam='+encodeURI(selectedParam)+'&openNode='+openNode+'&treeFlag='+treeFlag+'&currentTab='+currentTab+'&transTab='+transTab+'&configOnTopology='+encodeURI(configOnTopology)+'&isSite='+isSite;
		
		url = url+'?'+param;
		return url;
	}
	function chartGraphType(cdate)
	{
		if(cdate != null && cdate !=undefined)
		{
			if(cdate.indexOf(":") > -1)
			{
				var dateTime = cdate.split(":");
				var chartOpt = '<%=chartOption%>';
				var chartTimeLine = '<%=chartTimeline%>';
				var time_lineObj= dateTime[0];
				var tline = dateTime[0];
				
				var opcArray = new Array();
				var timeOptions = new Array("Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months");
				// Deciding chart
				chartOpt = (chartOpt != null && !chartOpt=="" )?chartOpt:"easychart";
				chartOpt = (chartOpt !="graph" && chartOpt.indexOf("high")> -1)?"higchart":"easychart";
				chartOpt = chartOpt.toLowerCase();
				if(chartOpt != 'null' && chartOpt !="" && chartOpt.indexOf("easy") == -1)
				{
					if(tline != null && tline == "Any")
					{
						var ch_st_time = dateTime[1];
						var ch_st_hr = dateTime[2];
						var ch_en_time = dateTime[3];
						var ch_en_hr = dateTime[4];
						var chartStartTime=formatDate(new Date(getDateFromFormat(ch_st_time,'<%=currentDateFormat%>')),"MM/dd/yyyy");
						var chartEndTime=formatDate(new Date(getDateFromFormat(ch_en_time,'<%=currentDateFormat%>')),"MM/dd/yyyy");
						var chartStartTime= Ext.Date.dateFormat(ch_st_time, 'm/d/Y');
						var chartEndTime = Ext.Date.dateFormat(ch_en_time,'m/d/Y');
						//enddt = Ext.Date.dateFormat(endDateObj, 'MM/dd/yyyy');
						chartStartTime = (Ext.isEmpty(chartStartTime))?ch_st_time:chartStartTime;
						chartEndTime = (Ext.isEmpty(chartEndTime))?ch_en_time:chartEndTime;
						var ctline = chartTimeLine.substring(chartTimeLine.indexOf(" ")+1);
						chartStartTime = chartStartTime+" "+ch_st_hr+":00:00";
						chartEndTime = chartEndTime+" "+ch_st_hr+":00:00";
						var durVal  = chartTimeLine.substring(0,chartTimeLine.indexOf(" "));
						var durUnit = chartTimeLine.substring(chartTimeLine.indexOf(" ")+1);
						var tline = getDateInfoDifference(chartStartTime,chartEndTime,ctline);
						var duraVal = parseInt(durVal);
						var durationVal = parseInt(tline);
						chartOpt = (durationVal <= duraVal)?"highcharts":"graph";
					}
					else if(tline != 'null' && tline !="Any")
					{
						var durVal  = chartTimeLine.substring(0,chartTimeLine.indexOf(" "));
						var durUnit = chartTimeLine.substring(chartTimeLine.indexOf(" ")+1);
						var duraVal = parseInt(durVal);
						if (durUnit.indexOf("ho") > -1)
						{
							for(var a=0;a<timeOptions.length;a++)
							{
								var tmpOpt = timeOptions[a];
								if(tmpOpt =="Any")
								{
									if($j.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
									continue;
								}
								var durLocVal  = tmpOpt.substring(0,tmpOpt.indexOf(" "));
								var durLocUnit = tmpOpt.substring(tmpOpt.indexOf(" ")+1);
								var locVal = parseInt(durLocVal);
								if(durLocUnit.indexOf("ho") > -1 && locVal == duraVal)
								{
									if($j.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
									break;
								}
								else if(durLocUnit.indexOf("ho") > -1 && locVal <= duraVal)
								{
									if($j.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
								}
							}
						}
						else if (durUnit.indexOf("da") > -1)
						{
							for(var a=0;a<timeOptions.length;a++)
							{
								var tmpOpt = timeOptions[a];
								if(tmpOpt == "Any")
								{
									if($.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
									continue;
								}
								var durLocVal  = tmpOpt.substring(0,tmpOpt.indexOf(" "));
								var durLocUnit = tmpOpt.substring(tmpOpt.indexOf(" ")+1);
								var locVal = parseInt(durLocVal);
								if(durLocUnit.indexOf("ho") > -1)
								{
									
									if($.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
								}
								else if(durLocUnit.indexOf("da") > -1 && locVal == duraVal)
								{
									if($.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
									break;
								}
								else if(durLocUnit.indexOf("da") > -1 && locVal <= duraVal)
								{
									if($.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
								}
							}
						}
						else if (durUnit.indexOf("we") > -1)
						{
							for(var a=0;a<timeOptions.length;a++)
							{
								var tmpOpt = timeOptions[a];
								if(tmpOpt == "Any")
								{
									if($.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
									continue;
								}
								var durLocVal  = tmpOpt.substring(0,tmpOpt.indexOf(" "));
								var durLocUnit = tmpOpt.substring(tmpOpt.indexOf(" ")+1);
								var locVal = parseInt(durLocVal);
								if(durLocUnit.indexOf("ho") > -1 || durLocUnit.indexOf("da") > -1)
								{
									if($.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
								}
								else if(durLocUnit.indexOf("we") > -1 && locVal == duraVal)
								{
									if($.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
									break;
								}
								else if(durLocUnit.indexOf("we") > -1 && locVal <= duraVal)
								{
									if($.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
								}
							}
						}
						else if (durUnit.indexOf("mo") > -1)
						{
							for(var a=0;a<timeOptions.length;a++)
							{
								var tmpOpt = timeOptions[a];
								if(tmpOpt == "Any")
								{
									if($.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
									continue;
								}
								var durLocVal  = tmpOpt.substring(0,tmpOpt.indexOf(" "));
								var durLocUnit = tmpOpt.substring(tmpOpt.indexOf(" ")+1);
								var locVal = parseInt(durLocVal);
								if(durLocUnit.indexOf("ho") > -1|| durLocUnit.indexOf("da") > -1|| durLocUnit.indexOf("we") > -1)
								{
									if($.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
								}
								else if(durLocUnit.indexOf("mo") > -1 && locVal == duraVal)
								{
									if($.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
									break;
								}
								else if(durLocUnit.indexOf("mo") > -1&& locVal <= duraVal)
								{
									if($.inArray(tmpOpt, opcArray) == -1)
										opcArray[a] = tmpOpt;
								}
							}
						}
						if(opcArray != null && opcArray != undefined)
						{
							chartOpt = ($.inArray(tline,opcArray) > -1)?"highcharts":"graph";
						}
					}
					else if(tline == null )
					{
						tline = "1 hour";
						for(var k=0;k<timeOptions.length;k++)
						{
							var tmpOpt = timeOptions[k];
							if($.inArray(tmpOpt, opcArray) == -1)
								opcArray[k] = tmpOpt;
						}
					}
				}
				else
					chartOpt = "easychart";
				opcArray = new Array();
			}
		}
		return chartOpt;
	}

	function loadTransHCGrap(seriesOptions,TotalTd,axisTitle,fmts,title,max,xmax,xmin,lineWidth, styleAttrbs)
	{
		try
		{
			var myImgHtml = '<div style="margin:12% 0 auto 25%"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" width="70%" /></div>';
			var tmpChartId = "transchart"+TotalTd+"-body";
			if(Ext.isEmpty(seriesOptions))
			{
				Ext.getCmp(tmpChartId).update(myImgHtml);
			}
			else
			{
				var xlineWidth = 1,xGridLineWidth = 1,ylineWidth = 1,yGridLineWidth = 0;
				var ymax = max;
				max = max+1;
				var toolTipFmt = '';
				//Get current date format from jsp variable
				toolTipFmt = tooltipDateFormate('<%=dateFormatForDatePicker%>');
				//toolTipFmt = tooltipDateFormate('<%=currentDateFormat%>');
				var chartWidth = 0;
				var docWid = $(document).width();
				chartWidth = ( $( window ).width() / 3 ) - 100;
				var legendSize = seriesOptions.length;
				var yVal = "";
				var offSets = "";
				var mBottom = 40;
				if(fmts == "%H:%M")
				{
					yVal = 20;
					offSets = 60;
				}
				else
				{
					yVal = 38;
					offSets = 100;
					mBottom = 80;
				}
				
				var minPad = null;
				var ymin = 0;
				if (!Ext.isEmpty(isYaxisBasedOnData) && isYaxisBasedOnData)
				{
					minPad=0;
					ymin=null;
					ymax=null;
				}

				if(ymin!=null && ymax!=null && (ymin == ymax))
					ymax = ymin+1;

				Highcharts.setOptions({
					global: {
						useUTC: true,
						timezoneOffset:timeZoneOffsetVal
					}
				});
				var typeStr = (isAreaChart.toLowerCase() == 'yes' || isAreaChart.toLowerCase() == 'true')?"areaspline":"line";
				var chart= $('#'+tmpChartId).highcharts('StockChart', {
					chart: {
						type:typeStr,
						defaultSeriesType: typeStr,
						//renderTo: tmpChartId,
						zoomType: 'x',
						animation: false,
						height:210,
						width:chartWidth,
						plotBorderColor : 'transparent',
						backgroundColor:'transparent',
						spacing:[15, 10, 10, 10],
						//marginTop:50,
						marginBottom:mBottom,
						plotShadow: false,
						shadow: false,
						events: {
							selection: function (event) {
								var text,label;
								if (event.xAxis) {
									if(Highcharts.numberFormat(event.xAxis[0].min, 2)>0){
										isZoomMeasureGraph=true;
									}
								} else {
									isZoomMeasureGraph=false;
								}
							},
							click: function (event) {
								if(event.srcElement.firstChild == null )
								{
									showGraph('event',TotalTd);
								}
								else if( event.srcElement.firstChild.data === "Reset zoom")
								{
									//this.xAxis[0].setExtremes(xmin,xmax);
								}
							}
						}
						//plotShadow: true
					},
					navigator: {
						enabled: false
					},
					yAxis: {
						border :0,
						min: ymin,
						minPadding:minPad,
						max:ymax,
						lineWidth: ylineWidth,
						gridLineWidth: yGridLineWidth,
						gridLineColor:styleAttrbs['axisLabelGridColor'],
						tickPixelInterval: 50,
						opposite:false,
						labels: {
							align: 'right',
							x: -10,
							y: 3,
							formatter: function() {
								return (this.value > 0 ? ' ' : '') + this.value ;
							},
							style: {
								color :styleAttrbs['axisLabelColor'],
								fontFamily:styleAttrbs['axisLabelFontFmy'],
								fontSize:styleAttrbs['axisLabelFontSize']
							},
						},
						showLastLabel: true,
						lineColor: styleAttrbs['axisLabelLineColor'],
						minorGridLineColor: styleAttrbs['axisLabelMinorGrid'],
						tickColor: styleAttrbs['axisLabelTickColor']
					},
					plotOptions: {
						series: {
							threshold: null,
							turboThreshold: 50000,
							connectNulls : false,
							smoothed: true,
							stacking: null,
							 states: {
								hover: {
									lineWidthPlus: 0
								}
							},
							events: {
								click: function (event) {
									if(event)
									{
										showGraph('event',TotalTd);
									}
								}
							}
						},
						line: {
							shadow: false,
							lineWidth: lineWidth
						}
					},
					rangeSelector: {
					enabled: false
					},
					scrollbar: {
						enabled: false
					},
					exporting: {
							enabled: false
						},
					legend: {
						enabled: false,
						align:'right',
						layout: 'vertical',
						verticalAlign: 'top',
						borderWidth: 0,
						itemStyle: {
							color : styleAttrbs['legendColor'],
							fontFamily: styleAttrbs['legendFontFmy'],
							fontSize: styleAttrbs['legendFontSize'],
						},
						y:50
					},
					tooltip: {
						/*crosshairs: {
								color: 'black',
								dashStyle: 'solid'
							},*/
							//shared: true,
							crosshairs: [false,false],
							backgroundColor : styleAttrbs['TooltipBgColor'],
							borderColor: styleAttrbs['TooltipBorderColor'],
							headerFormat: '{point.key}<br>',
							pointFormat: '{series.name}  <b>:  {point.y}</b><br>',
							style: {
									color : '#2a292a',
									padding: 10,
									//fontWeight: 'bold',
									fontFamily: styleAttrbs['TooltipFontFmy'],
									fontSize: styleAttrbs['TooltipFontSize'],
								},
						xDateFormat:toolTipFmt,
						valueDecimals: 4,
						formatter: function() {
								var s ='';
								if(strSkin=='Dark' || strSkin=='dark'){
									if( legendSize==1)
										s = '<span style="color:white">'+Highcharts.dateFormat (toolTipFmt,this.x,true)+'</span><br/>';
									else
										s = '<span>'+Highcharts.dateFormat (toolTipFmt,this.x,true)+'</span><br/>';
								}else{
									 if( legendSize==1)
										s = '<span style="color:black">'+Highcharts.dateFormat (toolTipFmt,this.x,true)+'</span><br/>';
									else
										s = '<span>'+Highcharts.dateFormat (toolTipFmt,this.x,true)+'</span><br/>';
								}
								jQuery.each(this.points, function(i, point) {
									var val = Highcharts.numberFormat (point.y,4, '.','');
									var val_ar = val.split('.');
									if(val_ar.length>1)
									{
										if(val_ar[1]=='0000')
											val = val_ar[0];
									}
									if(strSkin=='Dark' || strSkin=='dark'){
										if (point.series.name != '' && point.series.name != undefined && true) {
											if(legendSize==1)
												s += '<b><span style="color:white">'+ point.series.name +' :  '+val+'</span></b><br/>';
											else
												s += '<b><span style="color:' + this.series.color + '">'+ point.series.name +'  :  '+val+'</span></b><br/>';
											//s += '<br/>'+ point.series.name +': <b>'+val+'</b>';
										}
										else
										{
											s += '<br/> <b><span style="color:white">'+val+'</span></b><br/>';
										}
									}else{
										if (point.series.name != '' && point.series.name != undefined && true) {
											if(legendSize==1)
												s += '<b><span style="color:black">'+ point.series.name +' :  '+val+'</span></b><br/>';
											else
												s += '<b><span style="color:' + this.series.color + '">'+ point.series.name +'  :  '+val+'</span></b><br/>';
											//s += '<br/>'+ point.series.name +': <b>'+val+'</b>';
										}
										else
										{
											s += '<br/> <b><span style="color:black">'+val+'</span></b><br/>';
										}
									}
								});
								return s;
						}
					},
					title: {
						style: {
							color :styleAttrbs['titleFontClr'],
							fontFamily:styleAttrbs['titleFontFmy'],
							fontSize:styleAttrbs['titleFontSize'],
						},
						text: title
					},
					credits: {
						enabled: false
					},
					xAxis: {
						tickWidth: 0,
						endOnTick: true,
						lineWidth: xlineWidth,
						gridLineWidth: xGridLineWidth,
						gridLineColor:styleAttrbs['axisLabelGridColor'],
						type: 'datetime',
						ordinal:false,
						labels: {
							rotation:270,
							y:yVal,
							//x:4,
							align: 'center',
							style: {
								color :styleAttrbs['axisLabelColor'],
								fontFamily:styleAttrbs['axisLabelFontFmy'],
								fontSize:styleAttrbs['axisLabelFontSize']
							},
							overflow: 'justify',
							maxStaggerLines : 7,
							showLastLabel: true,
							showFirstLabel: false,
							startOnTick: true,
							useHTML: false,
							tickPixelInterval: 50,
						
							formatter: function() {
							return  Highcharts.dateFormat(fmts, this.value);
							}
						},
						title: {
							text: '',
							offset: ''
							
						},
						lineColor: styleAttrbs['axisLabelLineColor'],
						minorGridLineColor: styleAttrbs['axisLabelMinorGrid'],
						tickColor: styleAttrbs['axisLabelTickColor']
					},
					
					series: seriesOptions
				});
			}
			
		}
		catch(exp)
		{
			//alert("script error--->"+exp);
		}
	}
	function bigHighChart(url,divId)
	{
		Ext.onReady(function() 
		{
			var bigHSChartObj = Ext.getCmp(divId);
			
			var myhtml = "<table border='0' height='100%' width='100%' align='center'><tr><td align='middle'><img src='/final/monitor/eg_images/gray/graph_error_message.gif'></td></tr></table>";
			if(url != 'null')
			{
				//var url = "../servlet/com.egurkha.TimelineMeasures?"+param;
				var seriesOptions = [],
				yAxisOptions = [],
				seriesCounter = 0;
				var title = "";
				var fmts = "";
				var axisTitle = "";
				var max = "";
				var xmax = "";
				var xmin = "";
				var nameOfSeries = [];
				var lineWidth = "";
				url = url+"&isAreaChart="+isAreaChart;
				Ext.Ajax.request(
				{
					url : url,
					scope:this,
					success: function(response) 
					{
						if(response.status == 200 && !Ext.isEmpty(response))
						{
							var jsonText = response.responseText;
							if(!Ext.isEmpty(jsonText))
							{
								if(jsonText.indexOf("<HTML>") > -1 || jsonText.indexOf(".gif") > -1)
								{
									Ext.getCmp(divId).update(myhtml);
								}
								else
								{
									var data=Ext.decode(jsonText);
									
									var chartData=[];
									var seriesCounter = 0;
									var pntFormat='';

									var styleAttrbs=new Object();
									styleAttrbs['fontFamily']='Lucida Grande';
									styleAttrbs['fontSize']='10px';

									styleAttrbs['xlabelfontClr']='#636363';
									styleAttrbs['xlabelfontFmy']='Lucida Grande';
									styleAttrbs['xlabelfontSize']='10px';
									styleAttrbs['xlabelfontWgt']='normal';

									styleAttrbs['capFontClr']='#636363';
									styleAttrbs['capFontFmy']='Lucida Grande';
									styleAttrbs['capFontSize']='11px';
									styleAttrbs['capFontWgt']='bold';
									styleAttrbs['plotPanelColor']='#e5e5e5';
									styleAttrbs['lineThickness']='2';

									var styleObj = data["styles"];
									if(!Ext.isEmpty(styleObj['axisLabelStyle']))
									{
										styleAttrbs['capFontClr'] = styleObj['axisLabelStyle'].COLOR;
										styleAttrbs['capFontFmy'] = styleObj['axisLabelStyle'].FAMILY;
										styleAttrbs['capFontSize'] = styleObj['axisLabelStyle'].SIZE;
										styleAttrbs['capFontWgt'] = styleObj['axisLabelStyle'].WEIGHT;
									}
									if(!Ext.isEmpty(styleObj['timeLabelStyle']))
									{
										styleAttrbs['xlabelfontClr'] = styleObj['timeLabelStyle'].COLOR;
										styleAttrbs['xlabelfontFmy'] = styleObj['timeLabelStyle'].FAMILY;
										styleAttrbs['xlabelfontSize'] = styleObj['timeLabelStyle'].SIZE;
										styleAttrbs['xlabelfontWgt'] = styleObj['timeLabelStyle'].WEIGHT;
									}
									if(!Ext.isEmpty(styleObj['panelLineStyle']))
									{
										styleAttrbs['plotPanelColor']=styleObj['panelLineStyle'].COLOR;
										styleAttrbs['lineThickness']=styleObj['panelLineStyle'].LINETHICKNESS;
									}

									for ( var mainKey in data )
									{
										if( mainKey != "styles" )
										{
											var dataOfKey = data[mainKey];
											for ( var key in dataOfKey )
											{
												if(!isNaN(key))
												{
													seriesCounter = seriesCounter+1;
													title = dataOfKey[key]['title'];
													fmts = dataOfKey[key]['fmts'];
													max = dataOfKey[key]['max'];
													xmax = dataOfKey[key]['xmax'];
													xmin = dataOfKey[key]['xmin'];
													lineWidth = dataOfKey[key]['lineWidth'];
													axisTitle = dataOfKey[key]['axislabel'];
													nameOfSeries[key]= dataOfKey[key]['name'];
													seriesOptions[key] =
													{
														name: dataOfKey[key]['name'],
														data: dataOfKey[key]['data'],
														color: dataOfKey[key]['color'],
														lineWidth: dataOfKey[key]['lineWidth'],
														dataGrouping: {
															enabled: false
														}
													};
												}
											}
										}
									}
									if(seriesOptions == "" || seriesOptions == 'null' || seriesOptions == 'undefined')
									{
										
										Ext.getCmp(divId).update(myhtml);
										
									}
									else
									{
										var lineChart = {};
										lineChart = jQuery.extend(true, {}, createTransactionBigHighChart(divId,400,900,'',isAreaChart,logonChartType), lineChart);
										lineChart.setData(data,'<%=dateFormatForDatePicker%>','close',true,'right');
										lineChart.drawChart();
										for(var a=0;a<nameOfSeries.length;a++)
										{
											var names = nameOfSeries[a];
											if(names == "" || names == undefined || names == null)
												pntFormat = '<tr><td style="color:{point.series.color}"><b><span style="color:{point.series.color}">{point.y}</span></b></td></tr>';
											else
												pntFormat = '<tr><td style="color:{series.color}">{series.name}:</td><td style="text-align:right; color:#669;"><b>{point.y}</b></td></tr>';
										}
									}
								}
							}
							else
							{
								Ext.getCmp(divId).update(myhtml);
							}
						}
						else
						{
							Ext.getCmp(divId).update(myhtml);
						}
					},failure: function(){
						//alert("fail");
						Ext.getCmp(divId).update(myhtml);
					}
				});
				
			}
			else
			{
				if(bigHSChartObj)
					Ext.getCmp(divId).update(myhtml);
			}
		});
	}
	// currentDate format in tooltip of HighStockCharts

	requestParams.treeSession = "<%=treeSession%>";

	if('<%=refresh%>' == 'true'){
		requestParams.refresh = 'true';
	}
	else{
		requestParams.refresh = 'false';
	}
	requestParams.rumLinkFlag = '<%=rumLinkFlag%>';

	if('<%=openNode%>' != 'null' && '<%=openNode%>' != null && '<%=openNode%>' != 'undefined' && '<%=openNode%>' != undefined && '<%=openNode%>' != '')
		requestParams.selectedTreeNode = '<%=openNode%>';

	if('<%=treeOpen%>' == 'true')
		requestParams.treeOpen = 'true';
	else
		requestParams.treeOpen = 'false';

	if('<%=topoSegment%>' != 'null' && '<%=topoSegment%>' != null && '<%=topoSegment%>' != 'undefined' && '<%=topoSegment%>' != undefined && '<%=topoSegment%>' != '')
		requestParams.topoSegment = encodeURI('<%=topoSegment%>');
	else if('<%=selectedParam%>' != 'null' && '<%=selectedParam%>' != null && '<%=selectedParam%>' != 'undefined' && '<%=selectedParam%>' != undefined && '<%=selectedParam%>' != '' && '<%=selectedParam%>' != 'Services')
		requestParams.topoSegment = encodeURI('<%=selectedParam%>');
	
	if('<%=currentTab%>' != 'null' && '<%=currentTab%>' != null && '<%=currentTab%>' != 'undefined' && '<%=currentTab%>' != undefined && '<%=currentTab%>' != '')
	{
		requestParams.selectedTab = '<%=currentTab%>';
		showDashboard = true;
	}
	if('<%=appCurrentHost%>' != 'null' && '<%=appCurrentHost%>' != null && '<%=appCurrentHost%>' != 'undefined' && '<%=appCurrentHost%>' != undefined && '<%=appCurrentHost%>' != '')
		requestParams.appCurrentHost = '<%=appCurrentHost%>';

	if('<%=aggregateComp%>' != 'null' && '<%=aggregateComp%>' != null && '<%=aggregateComp%>' != 'undefined' && '<%=aggregateComp%>' != undefined && '<%=aggregateComp%>' != '')
		requestParams.aggregateComp = '<%=aggregateComp%>';

	if('<%=aggregateTab%>' != 'null' && '<%=aggregateTab%>' != null && '<%=aggregateTab%>' != 'undefined' && '<%=aggregateTab%>' != undefined && '<%=aggregateTab%>' != '')
		requestParams.aggregateTab = '<%=aggregateTab%>';

	if('<%=hasTransactions%>' != 'null' && '<%=hasTransactions%>' != null && '<%=hasTransactions%>' != 'undefined' && '<%=hasTransactions%>' != undefined && '<%=hasTransactions%>' != '')
		requestParams.hasTransactions = '<%=hasTransactions%>';

	if('<%=hasEmulatedTransactions%>' != 'null' && '<%=hasEmulatedTransactions%>' != null && '<%=hasEmulatedTransactions%>' != 'undefined' && '<%=hasEmulatedTransactions%>' != undefined && '<%=hasEmulatedTransactions%>' != '')
		requestParams.hasEmulatedTransactions = '<%=hasEmulatedTransactions%>';

	if('<%=selectNode%>' != 'null' && '<%=selectNode%>' != null && '<%=selectNode%>' != 'undefined' && '<%=selectNode%>' != undefined && '<%=selectNode%>' != '')
		requestParams.selectNode = '<%=selectNode%>';

	if('<%=isSite%>' != 'null' && '<%=isSite%>' != null && '<%=isSite%>' != 'undefined' && '<%=isSite%>' != undefined && '<%=isSite%>' != '')
		requestParams.isSite = '<%=isSite%>';

	//frompage
	if('<%=pageComesfrom%>' != 'null' && '<%=pageComesfrom%>' != null && '<%=pageComesfrom%>' != 'undefined' && '<%=pageComesfrom%>' != undefined && '<%=pageComesfrom%>' != '')
		requestParams.pageComesfrom = '<%=pageComesfrom%>';
	var optionalListFlag = false;
	if("<%=optionalListPage%>"=="true" || "<%=optionalListPage%>"=="True" || "<%=optionalListPage%>"=="TRUE" || "<%=optionalListPage%>"=="yes" || "<%=optionalListPage%>"=="Yes" || "<%=optionalListPage%>"=="YES"){
		 optionalListFlag=true;
	}
	
	if(LayerModelTopology == null || LayerModelTopology == 'null' ){
		var currentTab=requestParams.currentTab;
		if(currentTab!=null && currentTab!=undefined && currentTab!="null" && currentTab=="system")
		{
			requestParams.currentTab="system";
			requestParams.selectedTab="system";
		}
		else if(currentTab!=null && currentTab!=undefined && currentTab!="null" && currentTab=="components")
		{
			requestParams.currentTab="components";
			requestParams.selectedTab="components";
		}
		else if(currentTab!=null && currentTab!=undefined && currentTab!="null" && currentTab=="aggregates")
		{
			requestParams.currentTab="aggregates";
			requestParams.selectedTab="aggregates";
		}
		else if(currentTab!=null && currentTab!=undefined && currentTab!="null" && currentTab=="topology")
		{
			requestParams.currentTab="topology";
			requestParams.selectedTab="topology";
		}
		else
		{
			if( rumFlagCheck == 'true' || rumFlagCheck == true)
			{
				if(requestParams.fromlayerBack != null && requestParams.fromlayerBack != undefined && requestParams.fromlayerBack != 'null' && requestParams.fromlayerBack != 'undefined')
				{
					if(requestParams.fromlayerBack == 'true' || requestParams.fromlayerBack == true)
					{
						requestParams.currentTab="topology";
						requestParams.selectedTab="topology";
					}
				}
				else
				{
					requestParams.currentTab="transactions";
					requestParams.selectedTab="transactions";
				}

			}
			else if(requestParams.isSite == true || requestParams.isSite == 'true'){
				if( (requestParams.hasTransactions == 'true' || requestParams.hasTransactions == true) || (requestParams.hasEmulatedTransactions == 'true' || requestParams.hasEmulatedTransactions == true) )
				{
					if(requestParams.fromlayerBack != null && requestParams.fromlayerBack != undefined && requestParams.fromlayerBack != 'null' && requestParams.fromlayerBack != 'undefined')
					{
						if(requestParams.fromlayerBack == 'true' || requestParams.fromlayerBack == true)
						{
							requestParams.currentTab="topology";
							requestParams.selectedTab="topology";
						}
					}
					else
					{
						requestParams.currentTab="transactions";
						requestParams.selectedTab="transactions";
					}
				}else{
					requestParams.currentTab="topology";
					requestParams.selectedTab="topology";
				}
			}
			else if (requestParams.hasEmulatedTransactions == 'true' || requestParams.hasEmulatedTransactions == true){
				requestParams.currentTab="transactions";
				requestParams.selectedTab="transactions";
			}
			else if (requestParams.hasLogonSimulations == 'true' || requestParams.hasLogonSimulations == true){
				requestParams.currentTab="logon";
				requestParams.selectedTab="logon";
			}

			else
			{
				requestParams.currentTab="topology";
				requestParams.selectedTab="topology";
			}
		}
	}
function outerWindow(url){
		var windowEl = Ext.create('Ext.window.Window', {
				//title:'Detailed Diagnosis',
				//bodyPadding:'8 8 30 8',
				resizable:false,
				//padding:'5 5 32 5',
				//cls:'rumWindow',
				width:'90%',
				draggable: true,
				//ghost:true,
				//shadow:'sides',
				modal:true,
				renderTo:Ext.getBody(),
				//cls:'windowModal',
				height:'90%',
				items:[
					{
						xtype:'container',
						height:'100%',
						width:'100%',
						autoScroll:true,
						html:"<iframe id='ddId'  width='100%' height='100%' src='"+url+"' border='0' scrolling='yes' marginwidth='0px' marginheight='0px' frameborder='0' leftmargin='10' topmargin='10' allowtransparency='true' style='border-width:0px; border-style:solid; border-color:yellow;' class='content-frame' ></iframe>",
					}
				],
				listeners:
				{
					show: function(win)
					{
						if (this.modal)
						{
							var dom = Ext.dom.Query.select('.x-mask');
							
							var el = Ext.fly(dom[dom.length-1]);
							
							el.addCls('windowModal');
						}
					},
					hide: function(win)
					{
						if (this.modal)
						{
							var dom = Ext.dom.Query.select('.x-mask');
							var el = Ext.fly(dom[dom.length-1]);
							el.removeCls('windowModal');
						}
					},
					afterrender: function()
					{
						Ext.EventManager.onWindowResize(function()
						{
							var me = this;
							me.center();
						}, this);
					}
				}
			}).show();
		return windowEl;
	}
</script>
<script language = "JavaScript1.2" src = "/final/monitor/eg_scripts/jsrsClient.js"></script>
<!-- <script src="../monitor/eg_scripts/services.js"></script> -->
<!-- <script src="../scripts/utilities/ScrollableUtils.js"></script> -->

<script src="../scripts/utilities/ScrollableTreePanel.js"></script>
<script src="../scripts/utilities/CustomGrid.js"></script>
<script src="../scripts/utilities/ErrorPanel.js"></script>
<script src="../scripts/utilities/ZoomGraphPanel.js"></script>
<script src="../scripts/utilities/StatefulTreePanel.js"></script>
<script src="../monitor/eg_scripts/dashboards/DashboardGeneralMeasuresGridPanel.js"></script>
<script src="../monitor/eg_scripts/dashboards/DashboardGeneralMeasuresAggregatePanel.js"></script>
<script src="../monitor/eg_scripts/dashboards/DashboardGeneralMeasuresGrid.js"></script>


<script src="/final/scripts/utilities/CustomGrid.js"></script>
<script src="/final/scripts/utilities/EmptyPanel.js"></script>
</head>
<body class="content-frame">
</body>
</html>
<%
try
{
    if(action!=null &&action.equalsIgnoreCase("globalsearch") || action.equalsIgnoreCase("globalsearchallservice") )
    {
      if(request.getQueryString()!=null)
      {
	  session.setAttribute("globalSearchLastSessionURL","/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&refresh=true&"+request.getQueryString());
      }
     else
     {
		session.setAttribute("globalSearchLastSessionURL","/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&refresh=true");
     } 
   }
   else
   {
	if(request.getQueryString()!=null)
	{
		session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&refresh=true&"+request.getQueryString());
	}
	else
	{
		session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&refresh=true");
	}
	}
   }
catch(Exception e)
{
	System.out.println("Exception in serviceDashboard..");
	e.printStackTrace();
}
%>