var tabHelpTip = "Please enter the exact name of the tab page in which the Application/Desktop is listed in the StoreFront console. Few examples of Tab Names are &quot;FAVORITES&quot; or &quot;APPS&quot; or &quot;DESKTOPS&quot;. Note that the Tab Name is not case-sensitive. If Tab Name is set to none, the simulator will look for the configured Application/Desktop in the &quot;FAVORITES&quot; tab. For further information, please refer to The eG Enterprise Express Logon Simulator for Citrix XenApp and XenDesktop document.";
var appHelpTip = "Please enter the exact name of the Application/Desktop that is to be launched from StoreFront console. Note that the Application/Desktop Name is not case-sensitive. Few examples of applications/desktops are Adobe Reader XI, Internet Explorer, Microsoft Excel 2010, Desktop_VM1. For further information, please refer to The eG Enterprise Express Logon Simulator for Citrix XenApp and XenDesktop document.";
var winHelpTip = "Please enter the partial or exact name that is displayed for the configured Application/Desktop in the session window's title bar. Note that the Window Title is not case-sensitive. Do not specify wildcard characters in the Window Title. For example, if your launched application window title is &quot;Untitled - Notepad&quot;, then you are allowed to provide just &quot;Notepad&quot; or &quot;Untitled - Notepad&quot; in the Window Title. If Window Title is set to none, then the simulator will assume that the configured Application/Desktop Name is the same as the Window Title. For further information, please refer to The eG Enterprise Express Logon Simulator for Citrix XenApp and XenDesktop document.";

Ext.define('LogonSimulator.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Viewport','PublishedResources','AgentDownload','DownloadUtils','LogonSimulatorView'],
	refs : [
		{selector:'viewport', ref:'viewport'},
		{selector:'PublishedResources', ref:'PublishedResources'},
		{selector:'AgentDownload', ref:'AgentDownload'},
		{selector:'DownloadUtils', ref:'DownloadUtils'},
		{selector:'LogonSimulatorView', ref:'LogonSimulatorView'}
	],
	init : function(){
		thisController = this;
		testViews = this;
		appCnt = this;
		userName= "";
		this.buildFieldData();
		this.control({
			'viewport':
			{
				'afterrender':this.afterrender
			},
			'viewport button[id="addMultiSrcbtn"]': 
			{
				'click': this.addMultiSource
			},
			'viewport button[id="clearMultiConfSrc"]': 
			{
				'click': this.ClearMultiConfigSource
			},
			'viewport button[id="updateMultiConfSrc"]': 
			{
				'click': this.UpdateMultiConfigSource
			},
			'PublishedResources combo[id="compType"]':
			{
				'select':this.compTypeLoad
			}
		});
	},
	
	tabChange: function(tab)
	{
		var selectedTab = tab;
		var tabPanel = Ext.getCmp('mainTab');
		if(selectedTab.toLowerCase() == "tab1")
		{
			testViews.logonSimView();
			Ext.getCmp('buttonCont').hide();
			tabPanel.child('#tab1').tab.show();
		}
		if(selectedTab.toLowerCase() == "tab2")
		{
			Ext.getCmp('backupmulticontainer').removeAll();
			testViews.interConfigMultiSource(compType);
			tabPanel.child('#tab2').tab.show();
			Ext.getCmp('buttonCont').show();
		}
		if (selectedTab.toLowerCase() == "tab3")
		{
			testViews.agentView();
			Ext.getCmp('buttonCont').hide();
			tabPanel.child('#tab3').tab.show();
		}
	},

	afterrender : function()
	{
		Ext.get("video3").on('click',function(){
				testViews.showVideo("second");
			}
		);

		Ext.get("video3_1").on('click',function(){
				testViews.showVideo("first");
			}
		);

		Ext.get("video4").on('click',function(){
				testViews.showVideo("second");
			}
		);

		Ext.get("video4_1").on('click',function(){
				testViews.showVideo("first");
			}
		);

		var tabPanel = Ext.getCmp('mainTab');

		if (defaultLS != null && defaultLS.toLowerCase() == "all")
		{
			tabPanel.child('#tab1').tab.show();
			Ext.getCmp("compType").show();
			Ext.getCmp('buttonCont').hide();
		}
		else
		{
			tabPanel.child('#tab1').tab.hide();
			Ext.getCmp("compType").hide();
			Ext.getCmp('buttonCont').show();
		}
		
		if (tab != null && tab == "comp")
		{
			testViews.logonSimView();
			tabPanel.child('#tab1').tab.show();
			tabPanel.setActiveTab(0);
			Ext.getCmp('buttonCont').hide();
		}
		if (tab != null && tab == "configure")
		{
			Ext.getCmp('PublishedResources').getForm().reset();
			Ext.getCmp('backupmulticontainer').removeAll();
			tabPanel.child('#tab2').tab.show();
			tabPanel.setActiveTab(1);
			Ext.getCmp('buttonCont').show();
		}
		else if (tab != null && tab == "agentDownload")
		{
			testViews.agentView();
			tabPanel.child('#tab3').tab.show();
			tabPanel.setActiveTab(2);
			Ext.getCmp('buttonCont').hide();
		}
		else
		{
			if (defaultLS != null && defaultLS.toLowerCase() == "all")
			{
				testViews.logonSimView();
				tabPanel.child('#tab1').tab.show();
				tabPanel.setActiveTab(0);
				Ext.getCmp('buttonCont').hide();
			}
			else
			{
				Ext.getCmp('PublishedResources').getForm().reset();
				Ext.getCmp('backupmulticontainer').removeAll();
				tabPanel.child('#tab2').tab.show();
				tabPanel.setActiveTab(1);
				Ext.getCmp('buttonCont').show();
			}
		}
		Ext.Ajax.request(
		{
			url : '/final/portal/LogonSimulator/data/EgLogonSimulatorJson.jsp?comeFrom=getUserDetails',
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var resultJSONData = Ext.decode(jsonText);
				userName = resultJSONData.userName;
			},
			failure: function()
			{
			}
		});

		if (help != null && help.toLowerCase() == "true")
		{
			testViews.iconEnable();
			Ext.Ajax.request(
			{
				url : '/final/portal/LogonSimulator/data/EgLogonSimulatorJson.jsp?comeFrom=sendMail',
				method: 'POST',
				success: function(response)
				{
					var jsonText = response.responseText;
					var resultJSONData = Ext.decode(jsonText);
					if (resultJSONData.mailSent == 'No')
					{
						var firstName = resultJSONData.firstName;
						var lastName = resultJSONData.lastName;
						var email = resultJSONData.username;
						var phoneNo = resultJSONData.phoneNo;
						var comp = resultJSONData.company;
						var timeZone = resultJSONData.timeZone;
						var password = resultJSONData.password;
						var simulator = resultJSONData.simulator;
						if (sendUserDataToCMS != null && sendUserDataToCMS == 'true')
						{
							thisController.sendData(firstName,lastName,email,phoneNo,comp,timeZone,password,simulator,url,refurl);
						}
					}
				}
			});
		}
		else if (help != null && help.toLowerCase() == "yes")
		{
			testViews.iconEnable();
		}
		else
		{
			testViews.iconDisable();
		}

	},
	
	showVideo : function(video)
	{
		var videoUrl = '';
		var videoTitle = '';
		if (video != null && video == 'first')
		{
			videoUrl = 'https://www.youtube.com/embed/bxzrpqTOEQ4';
			videoTitle = "How to Set Up the Citrix Logon Simulator";
		}
		else
		{
			videoUrl = 'https://www.youtube.com/embed/YIV-n6fo38A';
			videoTitle = "Quick Overview of Features";
		}
		if(Ext.isEmpty(Ext.getCmp('youtubewindow')))
		{
			Ext.create('Ext.window.Window', {
					title: "<span style='text-transform:none;'>"+videoTitle+"</span>",
					modal:true,
					ui:'lightwindow',
					ghost:false,
					id:'youtubewindow',
					closeAction:'destroy',
					height:500,
					width: 800,
					border:true,
					padding:0,
					header:{
						padding:'8 10'
					},
					listeners: {
						show: function(h) {
							if (this.modal) {
								var g = Ext.dom.Query.select(".x-mask");
								for (var f in g) {
									this.dom = g[f];
									if (!Ext.isEmpty(this.dom.offsetParent)) {
										if (this.dom.offsetParent.tagName == "BODY") {
											Ext.fly(this.dom).addCls("windowModal");
										}
									}
								}
							}
						},
						hide: function(f) {
							if (this.modal) {
								Ext.fly(this.dom).removeCls("windowModal");
							}
						},
						afterrender: function() {
							Ext.EventManager.onWindowResize(function() {
								var f = this;
								f.center();
							}, this);
						}
					},
					resizable:false,
					layout: 'fit',
					//html:'<iframe width="800" frameborder="0" height="465" src="https://www.youtube.com/watch?v=YIV-n6fo38A" frameborder="0" allowfullscreen></iframe>'
					html:'<iframe width="800" frameborder="0" height="465" src="'+videoUrl+'" frameborder="0" allowfullscreen></iframe>'
			}).show();
		}
		if (Ext.getCmp('youtubewindow') != null && Ext.getCmp('youtubewindow') != undefined)
		{
			Ext.getCmp('youtubewindow').on("close", function() {
					testViews.iconEnable();
				}
			);
		}
	},

	sendData : function(firstName,lastName,email,phoneNo,comp,timeZone,password,simulator,url,refurl)
	{
		var environment = "";
		if (simulator == 'Citrix_XcLogon_Emulation')
		{
			environment = "Citrix XenApp/XenDesktop";
		}
		else if (simulator == 'Hrzn_Logon_Emulation')
		{
			environment = "VMware Horizon";
		}
		if (url == 'null' || url == null)
		{
			url = 'Non-PPC';
		}
		if (refurl == 'null' || refurl == null)
		{
			refurl = '';
		}
		jQuery.ajax({
			type: "POST",
			url: "https://www.eginnovations.com/company/whs_reg_collector.php",
			 data: {
				'First_Name': firstName,
				'Last_Name': lastName,
				'Email': email,
				'Phone': phoneNo,
				'Company_Name': comp,
				'Time_Zone': timeZone,
				'Password': password,
				'Confirm_Password': password,
				'Environment': environment,
				'URL' : url,
				'refurl' : refurl
			},
			cache: false,
			success: function(result){
			},
			error: function(error)
			{
				console.log(error);
			}
		});
	},

	sendCompData :  function(firstName,lastName,email,phoneNo,comp,timeZone,password,simulator,status)
	{
		var environment = "";
		if (simulator == 'Citrix_XcLogon_Emulation')
		{
			environment = "Citrix XenApp/XenDesktop";
		}
		else if (simulator == 'Hrzn_Logon_Emulation')
		{
			environment = "VMware Horizon";
		}
		jQuery.ajax({
			type: "POST",
			url: "https://www.eginnovations.com/company/whs_reg_collector.php",
			 data: {
				'First_Name': firstName,
				'Last_Name': lastName,
				'Email': email,
				'Phone': phoneNo,
				'Company_Name': comp,
				'Time_Zone': timeZone,
				'Password': password,
				'Confirm_Password': password,
				'Environment': environment,
				'Status' : status
			},
			cache: false
		});
	},

	iconEnable : function()
	{
		Ext.Ajax.request(
		{
			url : '/final/portal/LogonSimulator/data/EgLogonSimulatorJson.jsp?comeFrom=getsimulator',
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				compType = publicJSON['compType'];
				if (compType != null && compType == "Citrix_XcLogon_Emulation")
				{
					Ext.getCmp('video4link').show();
				}
				else if (compType != null && compType == "Hrzn_Logon_Emulation")
				{
					Ext.getCmp('video4link').hide();
				}
				else
				{
					Ext.getCmp('video4link').hide();
				}
			}
		});
		if (defaultLS != null && defaultLS.toLowerCase() == "all")
		{
			Ext.getCmp('mainTab').setVisible(false);
			Ext.getCmp('getStarted').setVisible(true);
			Ext.getCmp('4stepView').setVisible(true);
			Ext.getCmp('buttonCont').hide();
		}
		else
		{
			Ext.getCmp('mainTab').setVisible(false);
			Ext.getCmp('getStarted').setVisible(true);
			Ext.getCmp('3stepView').setVisible(true);
			Ext.getCmp('buttonCont').hide();
		}
		Ext.getCmp('2stepView').setVisible(false);
	},

	iconDisable : function()
	{
		if (defaultLS != null && defaultLS.toLowerCase() == "all")
		{
			Ext.getCmp('mainTab').setVisible(true);
			Ext.getCmp('getStarted').setVisible(false);
			Ext.getCmp('4stepView').setVisible(false);
		}
		else
		{
			Ext.getCmp('mainTab').setVisible(true);
			Ext.getCmp('getStarted').setVisible(false);
			Ext.getCmp('3stepView').setVisible(false);
		}
		var tabPanel = Ext.getCmp('mainTab');
		if (tabPanel.getActiveTab().itemId != null && tabPanel.getActiveTab().itemId == "tab2")
		{
			Ext.getCmp('buttonCont').show();
		}
		else
		{
			Ext.getCmp('buttonCont').hide();
		}
		Ext.getCmp('2stepView').setVisible(false);
	},

	citrixOrVdiTrial : function()
	{
		var comptype = Ext.getCmp('trial').html;
		var page = "";
		if (comptype != null && comptype.indexOf("Citrix") != -1)
		{
			page = "Citrix";
		}
		else if (comptype != null && comptype.indexOf("VDI") != -1)
		{
			page = "VDI";
		}
		var win = window.open("https://www.eginnovations.com/solutions/login?email="+userName+"&page="+page, '_blank');
		win.focus();
	},
	
	goToMonitor : function()
	{
		Ext.Ajax.request(
		{
			url : '/final/portal/LogonSimulator/data/EgLogonSimulatorJson.jsp?comeFrom=getMonURL',
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var publicJSONData = Ext.decode(jsonText);
				window.parent.goToTestConfiguration(indexTabURL.monitorTabURL+"&monLayerUrl="+encodeURIComponent(publicJSONData.url));
			}
		});
	},

	compTypeLoad : function()
	{
		compType = Ext.getCmp('compType').getValue();
		inputsmultisrc = 2;
		var tabPanel = Ext.getCmp('mainTab');
		tabPanel.child('#tab2').removeAll();

		tabPanel.child('#tab2').add({
			xtype: 'PublishedResources'
		});
		Ext.getCmp("compType").show();
		testViews.interConfigMultiSource(compType);
	},

	logonSimView : function()
	{
		Ext.Ajax.request(
		{
			url : '/final/portal/LogonSimulator/data/EgLogonSimulatorJson.jsp?comeFrom=getsimulator',
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				Ext.getCmp('compname').getStore().loadRawData(publicJSON.listOfComp);
				var tabPanel = Ext.getCmp('mainTab');
				if (publicJSON['disabled'] == undefined && publicJSON['disabled'] == null && Ext.isEmpty(publicJSON['disabled']))
				{
					tabPanel.child('#tab2').tab.disable();
					tabPanel.child('#tab3').tab.disable();

					tabPanel.child('#tab1').tab.show();
					tabPanel.setActiveTab(0);
					Ext.getCmp('buttonCont').hide();
					Ext.getCmp('trial').hide();
				}
				else
				{
					Ext.getCmp('buttonCont').hide();
					tabPanel.child('#tab2').tab.enable();
					tabPanel.child('#tab3').tab.enable();
					tabPanel.child('#tab2').tab.show();
					if (citrixOrVdiTrial != null && citrixOrVdiTrial == false)
					{
						Ext.getCmp('trial').show();
					}
					
					compType = publicJSON['compType'];
					if (compType != null && compType == "Citrix_XcLogon_Emulation")
					{
						Ext.getCmp('trial').update('<div style="text-align:center;width:177px;float:left">Ensure Citrix success with <br> eG Enterprise. Try it now.</div><div class="arrowRight" ></div>');
					}
					else if (compType != null && compType == "Hrzn_Logon_Emulation")
					{
						Ext.getCmp('trial').update('<div style="text-align:center;width:177px;float:left">Ensure VDI success with <br> eG Enterprise. Try it now.</div><div class="arrowRight" ></div>');
					}
				}
			}
		});
		return;
	},

	agentView : function()
	{
		Ext.Ajax.request(
		{
			url : '/final/portal/LogonSimulator/data/EgLogonSimulatorJson.jsp?comeFrom=getsimulator',
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				compType = publicJSON['compType'];
				if (compType != null && compType == "Citrix_XcLogon_Emulation")
				{
					Ext.getCmp('trial').update('<div style="text-align:center;width:177px;float:left">Ensure Citrix success with <br> eG Enterprise. Try it now.</div><div class="arrowRight" ></div>');
				}
				else if (compType != null && compType == "Hrzn_Logon_Emulation")
				{
					Ext.getCmp('trial').update('<div style="text-align:center;width:177px;float:left">Ensure VDI success with <br> eG Enterprise. Try it now.</div><div class="arrowRight" ></div>');
				}
			}
		});

		Ext.Ajax.request(
		{
			url : '/final/portal/LogonSimulator/data/agentPackDownloadJson.jsp',
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				Ext.getCmp('osname').getStore().loadRawData(publicJSON.listOfOS.reverse());
			}
		});
	},

	downloadAgentPack : function(osname)
	{
		var downloadUtils =  Ext.widget('DownloadUtils');
		var urlStr = '../servlet/com.eg.AgentPackDownloadServlet?os='+osname+'&unzipit=false&issueUID=no&from=logonSimulator';
		downloadUtils.download(urlStr,osname);
	},
	
	createComponent : function(compType,displayType)
	{
		var loadmask = new Ext.LoadMask(Ext.getBody(), {
							msg : "Creating "+displayType+"..."
						});
		loadmask.show();
		Ext.Ajax.request(
		{
			url : '/final/portal/LogonSimulator/data/EgLogonSimulatorJson.jsp?comeFrom=createsimulator&compType='+encodeURIComponent(compType),
			method: 'POST',
			success: function(response)
			{
				loadmask.hide();
				var jsonText = response.responseText;
				var resultObj = Ext.decode(jsonText);
				if (resultObj['success']=='extagent')
				{
					Ext.Msg.show({
						title: alertCompTitle,
						msg: resultObj['screenLabels']['extAgentErr'],
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
				else if (resultObj['success']=='comp')
				{
					Ext.Msg.show({
						title: alertCompTitle,
						msg: resultObj['screenLabels']['compErr'],
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
				else if (resultObj['success']=='false')
				{
					Ext.Msg.show({
						title: alertCompTitle,
						msg: resultObj['screenLabels']['compErr'],
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
				else if (resultObj['success']=='true')
				{
					Ext.Ajax.request(
					{
						url : '/final/portal/LogonSimulator/data/EgLogonSimulatorJson.jsp?comeFrom=sendMail',
						method: 'POST',
						success: function(response)
						{
							var jsonText = response.responseText;
							var resultJSONData = Ext.decode(jsonText);
							var firstName = resultJSONData.firstName;
							var lastName = resultJSONData.lastName;
							var email = resultJSONData.username;
							var phoneNo = resultJSONData.phoneNo;
							var comp = resultJSONData.company;
							var timeZone = resultJSONData.timeZone;
							var password = resultJSONData.password;
							var simulator = resultJSONData.simulator;
							if (sendUserDataToCMS != null && sendUserDataToCMS == 'true')
							{
								thisController.sendCompData(firstName,lastName,email,phoneNo,comp,timeZone,password,simulator,'EnvironmentChange');
							}
						}
					});
					Ext.Msg.show({
						title: alertCompTitle,
						msg: displayType +" "+compSuccessMsg,
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
						fn: function() {
							var tabPanel = Ext.getCmp('mainTab');
							Ext.getCmp('PublishedResources').getForm().reset();
							Ext.getCmp('backupmulticontainer').removeAll();
							inputsmultisrc = 2;
							tabPanel.child('#tab2').tab.enable();
							tabPanel.child('#tab3').tab.enable();
							tabPanel.child('#tab2').tab.show();
							if (compType != null && compType == "Citrix_XcLogon_Emulation")
							{
								Ext.getCmp('trial').update('<div style="text-align:center;width:177px;float:left">Ensure Citrix success with <br> eG Enterprise. Try it now.</div><div class="arrowRight" ></div>');
							}
							else if (compType != null && compType == "Hrzn_Logon_Emulation")
							{
								Ext.getCmp('trial').update('<div style="text-align:center;width:177px;float:left">Ensure VDI success with <br> eG Enterprise. Try it now.</div><div class="arrowRight" ></div>');
							}
							if (citrixOrVdiTrial != null && citrixOrVdiTrial == false)
							{
								Ext.getCmp('trial').show();
							}
							tabPanel.setActiveTab(1);
							testViews.interConfigMultiSource(compType);
						}
					});
					return false;
				}
			},
			failure : function()
			{
				loadmask.hide();
			}
		});
	},

	deleteComponent : function(compType,displayType)
	{
		Ext.Msg.show({
			title: alertCompTitle,
			msg: "Are you sure you want to delete "+displayType+"?",
			buttons: Ext.Msg.YESNO,
			icon: Ext.Msg.QUESTION,
			fn:function(key) {
				if (key=="yes")
				{
					var loadmask = new Ext.LoadMask(Ext.getBody(), {
							msg : "Deleting "+displayType+"..."
						});
					loadmask.show();
					Ext.Ajax.request(
					{
						url : '/final/portal/LogonSimulator/data/EgLogonSimulatorJson.jsp?comeFrom=deletesimulator&compType='+encodeURIComponent(compType),
						method: 'POST',
						success: function(response)
						{
							loadmask.hide();
							var jsonText = response.responseText;
							var resultObj = Ext.decode(jsonText);
							if (resultObj['success']=='delSimulator')
							{
								Ext.Msg.show({
									title: alertCompTitle,
									msg: resultObj['screenLabels']['delSimulatorErr'],
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
								return false;
							}
							else if (resultObj['success']=='true')
							{
								Ext.Msg.show({
									title: alertCompTitle,
									msg: displayType +" "+compDelSuccessMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									fn: function() {
										var tabPanel = Ext.getCmp('mainTab');
										Ext.getCmp('PublishedResources').getForm().reset();
										Ext.getCmp('backupmulticontainer').removeAll();
										inputsmultisrc = 2;
										tabPanel.child('#tab2').tab.enable();
										tabPanel.child('#tab3').tab.enable();
										tabPanel.child('#tab2').tab.show();

										Ext.getCmp('trial').hide();
										//tabPanel.setActiveTab(1);
										//tabPanel.child('#tab1').tab.hide();
										testViews.logonSimView();
									}
								});
								return false;
							}
						},
						failure : function()
						{
							loadmask.hide();
						}
					});
				}
			}
		});
	},

	addMultiSource: function(btn) 
	{
		addMultiSourceContact();
	},
	
	addMultiResource: function(btn) 
	{
		addMultiResouceContact();
	},

	ClearMultiConfigSource: function() 
	{
		var backupmulticontainer = Ext.getCmp('backupmulticontainer');
		backupmulticontainer.removeAll();
		if (Ext.getCmp('conmulti_1') != null || Ext.getCmp('conmulti_1') != undefined)
		{
			ismultisrc = 'true';
		}
		if (Ext.getCmp('publisresource1') != undefined)
		{
			Ext.getCmp('publisresource1').setValue("");
			Ext.getCmp('twofacttoken1').setValue("");
			Ext.getCmp('domainmultiusr1').setValue("");
			Ext.getCmp('usermultiusr1').setValue("");
			Ext.getCmp('pwdmultiusr1').setValue("");
			Ext.getCmp('confpwdmultiusr1').setValue("");
			Ext.getCmp('twofactlabel1_2').setValue(true);
			Ext.getCmp('disclaimermultiusr1_2').setValue(true);
		}
		else
		{
			inputsmultisrc = 1;
			addMultiSourceContact();
		}
	},

	clearMultiResourceContact : function()
	{
		var backupmulticontainer = Ext.getCmp('backupmultirescontainer');
		backupmulticontainer.removeAll();
		inputs = 1;
		addMultiResourceContact();
	},
	
	UpdateMultiConfigSource: function() 
	{
		var multiinputs = inputsmultisrc;
		
		var siteUrl = Ext.getCmp('siteUrl').getValue();
		var browserType = Ext.getCmp('browserType').getValue();
		if (!checkblank(siteUrl))
		{
			Ext.Msg.show({
				title: alertMsgSrcTitle,
				msg: enterUrl,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('siteUrl').focus(true,true);
				}
			});
			return;
		}
		else if (siteUrl.indexOf("$unconfigured") > -1)
		{
			Ext.Msg.show({
				title: alertMsgSrcTitle,
				msg: donotSpecifyKey,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('siteUrl').focus(true,true);
				}
			});
			return;
		}
		else if (siteUrl.indexOf("..") > -1)
		{
			Ext.Msg.show({
				title: alertMsgSrcTitle,
				msg: _checkdots,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('siteUrl').focus(true,true);
				}
			});
			return;
		}
		else if (siteUrl.indexOf(" ") > -1)
		{
			Ext.Msg.show({
				title: alertMsgSrcTitle,
				msg: urlSpace,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('siteUrl').focus(true,true);
				}
			});
			return;
		}
		else if (siteUrl.indexOf("  ") > -1)
		{
			Ext.Msg.show({
				title: alertMsgSrcTitle,
				msg: _checkSpaces,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('siteUrl').focus(true,true);
				}
			});
			return;
		}
		else if (!validateSingleUrl(siteUrl,siteUrl))
		{
			Ext.Msg.show({
				title: alertMsgSrcTitle,
				msg: urlInValidMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('siteUrl').focus(true,true);
				}
			});
			return;
		}

		for (var mul=1;mul<multiinputs-1;mul++)
		{
			if (Ext.getCmp('domainmultiusr'+mul) == undefined)
			{
				continue;
			}
			
			var publishResource = Ext.getCmp('publisresource'+mul).getValue();
			var twoFactAuth = Ext.getCmp('twofacttoken'+mul).getValue();
			var domain = Ext.getCmp('domainmultiusr'+mul).getValue();
			var uname = Ext.getCmp('usermultiusr'+mul).getValue();
			var pass = Ext.getCmp('pwdmultiusr'+mul).getValue();
			var confpasswd = Ext.getCmp('confpwdmultiusr'+mul).getValue();

			var twofa = Ext.getCmp('twofact'+mul).getChecked()[0];
			var istwofaenabled = twofa.getGroupValue();
			
			if (publishResource.split(",").length >= appsCount + 1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: appLimitMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			if (!checkblank(publishResource))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterPubRsrc,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (publishResource.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(publishResource,"`*=#.|;\"\'<>\/[]?"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(publishResource) == "")
			{
				Ext.getCmp('publisresource'+mul).focus();
				return;
			}
			else if (publishResource.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (publishResource.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (publishResource.indexOf(":") > -1)
			{
				var val = publishResource;
				if (val.indexOf(",") != -1)
				{
					var values = val.split(",");
					for(var v=0;v < values.length;v++)
					{
						var tmpVal = values[v];
						if(tmpVal.charAt(0) == ':' || tmpVal.charAt(tmpVal.length - 1) == ':')
						{
							Ext.Msg.show ({
								title: alertMsgSrcTitle,
								msg: "Published resource should not start or end with a colon",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('publisresource'+mul).focus(true,true);
								}
							});
							return;
						}
						else
						{
							var moreColons = new Array();
							for(var k=0;k < tmpVal.length;k++)
							{
								if (tmpVal.charAt(k) == ':')
								{
									moreColons.push(k);
								}

								if(tmpVal.charAt(k) == ':' && tmpVal.charAt(k + 1) == ':')
								{
									Ext.Msg.show ({
										title: pageName,
										msg: "Cannot have ':' in consecutive positions",
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp('publisresource'+mul).focus(true,true);
										}
									});
									moreColons = new Array();
									return;
								}
								else
								{
									continue;
								}
							}

							if (moreColons.length > 1)
							{
								Ext.Msg.show ({
									title: alertMsgSrcTitle,
									msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle].",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mul).focus(true,true);
									}
								});
								moreColons = new Array();
								return;
							}
						}
					}
				}
				else
				{
					if(val.charAt(0) == ':' || val.charAt(val.length - 1) == ':')
					{
						Ext.Msg.show ({
							title: alertMsgSrcTitle,
							msg: "Published resource should not start or end with a colon",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('publisresource'+mul).focus(true,true);
							}
						});
						return;
					}
					else
					{
						var moreColons = new Array();
						for(var k=0;k < val.length;k++)
						{
							if (val.charAt(k) == ':')
							{
								moreColons.push(k);
							}

							if(val.charAt(k) == ':' && val.charAt(k + 1) == ':')
							{
								Ext.Msg.show ({
									title: alertMsgSrcTitle,
									msg: "Cannot have ':' in consecutive positions",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mul).focus(true,true);
									}
								});
								moreColons = new Array();
								return ;
							}
							else
							{
								continue;
							}
						}

						if (moreColons.length > 1)
						{
							Ext.Msg.show ({
								title: alertMsgSrcTitle,
								msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle].",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('publisresource'+mul).focus(true,true);
								}
							});
							moreColons = new Array();
							return;
						}
					}
				}
			}
			
			if (istwofaenabled == 'true')
			{
				if(!checkblank(twoFactAuth))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enter2FAToken,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (twoFactAuth.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (twoFactAuth.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (!checkspecial(twoFactAuth,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
			}
			else
			{
				twoFactAuth = 'none';
			}
			
			if(!checkblank(domain))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (domain.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkDomain(domain,"true"))
			{
				Ext.getCmp('domainmultiusr'+mul).focus(true,true);
				return;
			}
			else if (domain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if(!checkHyphenText(domain,domain))
			{
				Ext.getCmp('domainmultiusr'+mul).focus();
				return;
			}
			else if (domain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecial(uname,"*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(uname) == "")
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if(!checkHyphenText(uname,uname))
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}

			if(pass == "")
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if (pass.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if(!checkspecial(pass,"|"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: PwdNotContainPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if(pass.indexOf("#~#")>-1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkHashTildeHash,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if(!checkForPassValidity(pass))
			{
				Ext.getCmp('pwdmultiusr'+mul).focus();
				sub = false;
				return;
			}
			else if(confpasswd == "")
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterCnfPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if (confpasswd.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if(pass != confpasswd)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: matchPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
		}

		var multiPublishSrcVal = "";
		var hiddenPublishSrcVal = "";
		var multiUsrdomainVal = "";
		var multiUsrVal = "";
		var multiUsrpassVal = "";
		var multi2FAuthVal = "";
		var multiUsrdisclaimVal = "";

		for(var mulusr=1; mulusr<multiinputs; mulusr++)
		{
			if (Ext.getCmp('domainmultiusr'+mulusr) == undefined)
			{
				continue;
			}

			var multiSrcPublis = Ext.getCmp('publisresource'+mulusr).getValue();
			if (multiSrcPublis.split(",").length >= appsCount + 1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: appLimitMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mulusr).focus(true,true);
					}
				});
				return;
			}
			if(multiSrcPublis!=null)
			{
				if(!checkblank(multiSrcPublis))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPubRsrc,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiSrcPublis,"`*=#.|;\"\'<>\/[]?"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiSrcPublis) == "")
				{
					Ext.getCmp('publisresource'+mulusr).focus();
					return;
				}
				else if (multiSrcPublis.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf(":") > -1)
				{
					var val = multiSrcPublis;
					if (val.indexOf(",") != -1)
					{
						var values = val.split(",");
						for(var v=0;v < values.length;v++)
						{
							var tmpVal = values[v];
							if(tmpVal.charAt(0) == ':' || tmpVal.charAt(tmpVal.length - 1) == ':')
							{
								Ext.Msg.show ({
									title: alertMsgSrcTitle,
									msg: "Published resource should not start or end with a colon",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mulusr).focus(true,true);
									}
								});
								return;
							}
							else
							{
								var moreColons = new Array();
								for(var k=0;k < tmpVal.length;k++)
								{
									if (tmpVal.charAt(k) == ':')
									{
										moreColons.push(k);
									}
									if(tmpVal.charAt(k) == ':' && tmpVal.charAt(k + 1) == ':')
									{
										Ext.Msg.show ({
											title: alertMsgSrcTitle,
											msg: "Cannot have ':' in consecutive positions",
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation',
											fn: function() {
												Ext.getCmp('publisresource'+mulusr).focus(true,true);
											}
										});
										moreColons = new Array();
										return;
									}
									else
									{
										continue;
									}
								}

								if (moreColons.length > 1)
								{
									Ext.Msg.show ({
										title: alertMsgSrcTitle,
										msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle].",
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp('publisresource'+mulusr).focus(true,true);
										}
									});
									moreColons = new Array();
									return;
								}

							}
						}
					}
					else
					{
						if(val.charAt(0) == ':' || val.charAt(val.length - 1) == ':')
						{
							Ext.Msg.show ({
								title: alertMsgSrcTitle,
								msg: "Published resource should not start or end with a colon",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('publisresource'+mulusr).focus(true,true);
								}
							});
							return;
						}
						else
						{
							var moreColons = new Array();
							for(var k=0;k < val.length;k++)
							{
								if (val.charAt(k) == ':')
								{
									moreColons.push(k);
								}

								if(val.charAt(k) == ':' && val.charAt(k + 1) == ':')
								{
									Ext.Msg.show ({
										title: alertMsgSrcTitle,
										msg: "Cannot have ':' in consecutive positions",
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp('publisresource'+mulusr).focus(true,true);
										}
									});
									moreColons = new Array();
									return ;
								}
								else
								{
									continue;
								}
							}

							if (moreColons.length > 1)
							{
								Ext.Msg.show ({
									title: alertMsgSrcTitle,
									msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle].",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mulusr).focus(true,true);
									}
								});
								moreColons = new Array();
								return;
							}
						}
					}
				}
			}

			var multidisclaimer= Ext.getCmp('disclaimermultiusr'+mulusr+'_1').getValue();
			if(multidisclaimer == null) continue;
			
			var multi2FAuth= Ext.getCmp('twofacttoken'+mulusr).getValue();
			var multitwofa = Ext.getCmp('twofact'+mulusr).getChecked()[0];
			var ismultitwofaenabled = multitwofa.getGroupValue()
			if(multi2FAuth == null) continue;
			if(multi2FAuth != null)
			{
				if (ismultitwofaenabled == 'true')
				{
					if(!checkblank(multi2FAuth))
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: enter2FAToken,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+mul).focus(true,true);
							}
						});
						return;
					}
					if (multi2FAuth.indexOf(",") > -1)
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
					else if (multi2FAuth.indexOf("..") > -1)
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkdots,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
					else if (!checkspecial(multi2FAuth,"|"))
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
				}
				else
				{
					multi2FAuth = 'none';
				}
			}

			var multidomain= Ext.getCmp('domainmultiusr'+mulusr).getValue();
			if(multidomain == null) continue;
			if(multidomain != null)
			{
				if (!checkblank(multidomain))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterDomain,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (multidomain.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (!checkDomain(multidomain,"true"))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus(true,true);
					return;
				}
				else if (multidomain.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multidomain.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multidomain,multidomain))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus();
					return;
				}
			}

			var multiUname = Ext.getCmp('usermultiusr'+mulusr).getValue();
			if(multiUname!=null)
			{
				if(!checkblank(multiUname))
				{

					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterUsrId,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecial(multiUname,"*+=|:;\"\'<>\/[]?,"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiUname) == "")
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
				else if (multiUname.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUname,multiUname))
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
			}

			var multipass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
			var multiconfpasswd = Ext.getCmp('confpwdmultiusr'+mulusr).getValue();
			if(multipass!=null && multiconfpasswd!=null )
			{
				if (multipass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multipass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecial(multipass,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(multipass.indexOf("#~#")>-1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkHashTildeHash,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(!checkForPassValidity(multipass))
				{
					Ext.getCmp('pwdmultiusr'+mulusr).focus();
					sub = false;
					return;
				}
				else if(multiconfpasswd == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiconfpasswd.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(multipass != multiconfpasswd)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
			}

			if(multiPublishSrcVal != null && multi2FAuth != null && multidomain!=null && multidisclaimer!=null && multiUname!=null && multipass!=null && multiconfpasswd!=null )
			{
				var tempmultiUsrdoma = Ext.getCmp('domainmultiusr'+mulusr).getValue();
				multiUsrdomainVal+=tempmultiUsrdoma+"|";
				
				var tempmultiUsrdisclaim = Ext.getCmp('disclaimermultiusr'+mulusr+'_1').getValue();
				var strdisclaimValue = 'false';
				if (tempmultiUsrdisclaim)
				{
					strdisclaimValue = 'true';
				}
				multiUsrdisclaimVal+=strdisclaimValue+"|";

				var tempmulti2FA = Ext.getCmp('twofacttoken'+mulusr).getValue();
				var multi2FA = Ext.getCmp('twofact'+mulusr).getChecked()[0];
				var tempismulti2FA = multi2FA.getGroupValue();
				if (tempismulti2FA == 'false')
				{
					tempmulti2FA = 'none';
				}
				multi2FAuthVal+=tempmulti2FA+"#~#";

				var tempmultiSrcPublis = Ext.getCmp('publisresource'+mulusr).getValue();
				var tmpHiddenPublishSrc = tempmultiSrcPublis;
				if (!Ext.isEmpty(tmpHiddenPublishSrc) && tmpHiddenPublishSrc.indexOf(",") != -1)
				{
					tmpHiddenPublishSrc = tmpHiddenPublishSrc.replace(/,/g,'~#~');
				}
				multiPublishSrcVal+=tempmultiSrcPublis+",";
				hiddenPublishSrcVal+=tmpHiddenPublishSrc+"|";

				var tempmultiUsr = Ext.getCmp('usermultiusr'+mulusr).getValue();
				multiUsrVal+=tempmultiUsr+"|";

				var tempmultiUsrPass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
				multiUsrpassVal+=tempmultiUsrPass+"#~#";
			}
		}
		multiPublishSrcVal = multiPublishSrcVal.substring(0,multiPublishSrcVal.length-1);

		hiddenPublishSrcVal = hiddenPublishSrcVal.substring(0,hiddenPublishSrcVal.length-1);

		multi2FAuthVal = multi2FAuthVal.substring(0,multi2FAuthVal.length-3);

		multiUsrdomainVal = multiUsrdomainVal.substring(0,multiUsrdomainVal.length-1);

		multiUsrdisclaimVal = multiUsrdisclaimVal.substring(0,multiUsrdisclaimVal.length-1);

		multiUsrVal = multiUsrVal.substring(0,multiUsrVal.length-1);

		multiUsrpassVal = multiUsrpassVal.substring(0,multiUsrpassVal.length-3);

		compType = Ext.getCmp('compType').getValue();

		var ctxCloudWrkSpace = Ext.getCmp('ctxCloudWrkSpace1_1').getValue();

		if (Ext.isEmpty(ctxCloudWrkSpace))
		{
			ctxCloudWrkSpace = 'false';
		}

		Ext.Ajax.request({
			url:'/final/portal/LogonSimulator/data/EgLogonJson.jsp?hiddenPublishSrcVal='+encodeURIComponent(hiddenPublishSrcVal)+'&multi2FAuthVal='+encodeURIComponent(multi2FAuthVal)+'&multiUsrdomainVal='+encodeURIComponent(multiUsrdomainVal)+'&multiUsrVal='+encodeURIComponent(multiUsrVal)+'&multiUsrpassVal='+encodeURIComponent(multiUsrpassVal)+'&multiUsrdisclaimVal='+encodeURIComponent(multiUsrdisclaimVal)+'&siteUrl='+encodeURIComponent(siteUrl)+'&comeFrom=update&compType='+encodeURIComponent(compType)+'&browserType='+browserType+'&ctxCloudWrkSpace='+encodeURIComponent(ctxCloudWrkSpace),
			method:'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var publicJson = Ext.decode(jsonText);
				var agentDownloadRedirect = publicJson['agentDownload'];
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: successMsg,
					width: 500,
					buttons: Ext.Msg.OK,
					icon: 'iconInformation',
					fn: function() {
						var tabPanel = Ext.getCmp('mainTab');
						tabPanel.child('#tab2').removeAll();

						tabPanel.child('#tab2').add({
							xtype: 'PublishedResources'
						});
						if (defaultLS != null && defaultLS.toLowerCase() == "all")
						{
							Ext.getCmp("compType").show();
						}
						testViews.interConfigMultiSource(compType);

						if (agentDownloadRedirect!=null && agentDownloadRedirect!='undefined' && agentDownloadRedirect=='No')
						{
							var tabPanel = Ext.getCmp('mainTab');
							tabPanel.setActiveTab(2);
						}
					}
				});
			}
		});
	},

	updateMultiResourceContact : function(resourceId)
	{
		var multiinputs = inputs;
		var publishResource = "";
		for (var mul=1;mul<=multiinputs-1;mul++)
		{
			if (Ext.getCmp('folderName'+mul) == undefined)
			{
				continue;
			}
			var folderName = Ext.getCmp('folderName'+mul).getValue();
			var resourceName = Ext.getCmp('resourceName'+mul).getValue();
			var winTitle = Ext.getCmp('winTitle'+mul).getValue();
			if (!checkblank(folderName))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterFolderName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('folderName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (folderName.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('folderName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(folderName,"`*=#.|;:\"\'<>,\/[]{}()?\\"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('folderName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(folderName) == "")
			{
				Ext.getCmp('folderName'+mul).focus();
				return;
			}
			else if (folderName.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('folderName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (folderName.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('folderName'+mul).focus(true,true);
					}
				});
				return;
			}

			if (!checkblank(resourceName))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterResourceName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('resourceName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (resourceName.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('resourceName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (resourceName.indexOf("none") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: validResourceName,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('resourceName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(resourceName,"`*=#.|;:\"\'<>,\/[]?\\"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('resourceName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(resourceName) == "")
			{
				Ext.getCmp('resourceName'+mul).focus();
				return;
			}
			else if (resourceName.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('resourceName'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (resourceName.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('resourceName'+mul).focus(true,true);
					}
				});
				return;
			}

			if (!checkblank(winTitle))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterwinTitle,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winTitle'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (winTitle.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winTitle'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(winTitle,"`*=#.|;:\"\'<>,\/[]{}()?\\"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('winTitle'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(winTitle) == "")
			{
				Ext.getCmp('winTitle'+mul).focus();
				return;
			}
			else if (winTitle.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winTitle'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (winTitle.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('winTitle'+mul).focus(true,true);
					}
				});
				return;
			}
			if (folderName != 'none' && winTitle != 'none')
			{
				publishResource += folderName+"\\"+resourceName+":"+winTitle; 
			}
			else if (folderName == 'none' && winTitle != 'none')
			{
				publishResource += resourceName+":"+winTitle;
			}
			else if (folderName != 'none' && winTitle == 'none')
			{
				publishResource += folderName+"\\"+resourceName;
			}
			else if (folderName == 'none' && winTitle == 'none')
			{
				publishResource += resourceName;
			}
			publishResource += ",";
		}
		publishResource = publishResource.substring(0,publishResource.lastIndexOf(","));
		Ext.getCmp(resourceId).setValue(publishResource);
		Ext.getCmp('egconfigureresource').close();
	},

	buildFieldData: function() 
	{
		Ext.Ajax.request({
			url : '/final/portal/LogonSimulator/data/EgLogonSimulatorJson.jsp?comeFrom=getsimulator&from=userSimulator',
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				var tabPanel = Ext.getCmp('mainTab');
				if (publicJSON['disabled'] == undefined && publicJSON['disabled'] == null && Ext.isEmpty(publicJSON['disabled']))
				{
					tabPanel.child('#tab2').tab.disable();
					tabPanel.child('#tab3').tab.disable();
					tabPanel.setActiveTab(0);
					tab = "comp";
				}
				else
				{
					Ext.getCmp('buttonCont').hide();
					//tabPanel.child('#tab1').tab.hide();
					tabPanel.child('#tab2').tab.enable();
					tabPanel.child('#tab3').tab.enable();
					tabPanel.child('#tab2').tab.show();
					//tabPanel.setActiveTab(1);
				}
			}
		});
	},
	interConfigMultiSource: function(compType) 
	{
		var loadmask = new Ext.LoadMask(Ext.getBody(), {
							msg : "Please wait..."
						});
		loadmask.show();
		var cType = compType;
		Ext.Ajax.request(
		{
			url : '/final/portal/LogonSimulator/data/EgLogonSimulatorJson.jsp?comeFrom=getsimulator&from=userSimulator',
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				Ext.getCmp('compType').getStore().suspendEvents(true);
				Ext.getCmp('compType').getStore().loadRawData(publicJSON.listOfComp);
				Ext.getCmp('compType').getStore().resumeEvents();
				compType = publicJSON.compType;
				Ext.getCmp('compType').setValue(compType);
				
				compType = Ext.getCmp('compType').getValue();
				if (compType!=null && compType=="Citrix_XcLogon_Emulation")
				{
					Ext.getCmp("siteUrl").emptyText = 'URL for connecting to StoreFront/NetScaler/Web Interface';
					Ext.getCmp("noteCont").hide();
					Ext.getCmp("ctxCloudWrkSpace").show();
					Ext.getCmp('trial').update('<div style="text-align:center;width:177px;float:left">Ensure Citrix success with <br> eG Enterprise. Try it now.</div><div class="arrowRight" ></div>');
				}
				else if (compType!=null && compType=="Hrzn_Logon_Emulation")
				{
					Ext.getCmp("siteUrl").emptyText = 'URL for connecting to VMware Access Point/Horizon Connection Server';
					Ext.getCmp("noteCont").show();
					Ext.getCmp("ctxCloudWrkSpace").hide();
					Ext.getCmp('trial').update('<div style="text-align:center;width:177px;float:left">Ensure VDI success with <br> eG Enterprise. Try it now.</div><div class="arrowRight" ></div>');
				}
				
				Ext.Ajax.request({
					url:'/final/portal/LogonSimulator/data/EgLogonJson.jsp?comeFrom=view&compType='+encodeURIComponent(compType),
					method:'POST',
					success: function(response)
					{
						loadmask.hide();
						var multidom = '';
						inputsmultisrc = 2;
						ismultisrc = 'false';

						var jsonText = response.responseText;
						var publicJson = Ext.decode(jsonText);
						var Site_url = publicJson['Site_url'];
						var Browser_type = publicJson['Browser_type'];
						var Published_resources = publicJson['Published_resources'];
						var ValueUsr2FA = publicJson['Two_FA'];
						var Domain = publicJson['Domain'];
						var Username = publicJson['Username'];
						var password = publicJson['Password'];
						var ValueUsrdisclaimer = publicJson['Disclaimer'];

						if (Published_resources!=null && Published_resources!='undefined')
						{
							var splitPublisSrc = Published_resources.split("|");

							var splitUsr2FA = '';
							if (!Ext.isEmpty(ValueUsr2FA))
							{
								splitUsr2FA = ValueUsr2FA.split("#~#");
							}
							var splitUsrDomain = Domain.split("|");
							var splituser = Username.split("|");
							var splitpass = password.split("#~#");
							var splitUsrDisclaim = ValueUsrdisclaimer.split("|");
						}
						
						Ext.getCmp('browserType').getStore().loadRawData(publicJson.listOfBrowser);
						Ext.getCmp('browserType').setValue(Browser_type);
						
						Ext.getCmp('compType').setReadOnly(true);
						Ext.getCmp('compType').disable();
						Ext.getCmp('compType').inputEl.addCls('disabledField');
						Ext.getCmp('compType').inputEl.dom.style.cursor = 'inherit';
						
						if (publicJson.listOfBrowser!=null && publicJson.listOfBrowser!='undefined')
						{
							if (publicJson.listOfBrowser.length <= 1)
							{
								//Ext.getCmp('browserType').setReadOnly(true);
								//Ext.getCmp('browserType').disable();
								//Ext.getCmp('browserType').inputEl.addCls('disabledField');
								//Ext.getCmp('browserType').inputEl.dom.style.cursor = 'inherit';
								Ext.getCmp('browserType').hide();
							}
						}
						if (Site_url != '$unconfigured')
						{
							Ext.getCmp('siteUrl').setValue(Site_url);
						}
						else
						{
							Ext.getCmp('siteUrl').setValue("");
						}

						if (compType!=null && compType=="Citrix_XcLogon_Emulation")
						{
							var ctxCloudWrkSpaceValue = publicJson['Citrix_cloud_workspace'];

							if (!Ext.isEmpty(ctxCloudWrkSpaceValue))
							{
								if (ctxCloudWrkSpaceValue.toLowerCase() == 'true')
								{
									Ext.getCmp('ctxCloudWrkSpace1_1').setValue(true);
								}
								else
								{
									Ext.getCmp('ctxCloudWrkSpace1_2').setValue(true);
								}
							}
							else
							{
								Ext.getCmp('ctxCloudWrkSpace1_2').setValue(true);
							}
						}

						Ext.suspendLayouts();

						if (Domain != null || Domain != undefined)
						{
							var mainContainerObj = Ext.getCmp('mainContainer');

							var cond = splitUsrDomain.length-1;
							if (Ext.isEmpty(mainContainerObj))
							{
								inputsmultisrc = 1;

								cond = splitUsrDomain.length;
							}
							for (var k=0;k<cond;k++ )
							{
								addMultiSourceContact();
							}
							for (multidom=1;multidom<splitUsrDomain.length+1;multidom++)
							{
								if (!Ext.isEmpty(splitPublisSrc[multidom-1]) && splitPublisSrc[multidom-1].indexOf('~#~') != -1)
								{
									splitPublisSrc[multidom-1] = splitPublisSrc[multidom-1].replace(/~#~/g,',');
								}
								if (compType!=null && compType=="Citrix_XcLogon_Emulation")
								{
									Ext.getCmp("noteCont").hide();
									Ext.getCmp("ctxCloudWrkSpace").show();
									Ext.getCmp('publisresource'+multidom).setReadOnly(true);
									Ext.getCmp('publisresource'+multidom).columnWidth = '0.97';
									Ext.getCmp('publisresource'+multidom).emptyText = ctxAppEmptyText;
									Ext.getCmp('confpublisresource'+multidom).setVisible(true);
								}
								else if (compType!=null && compType=="Hrzn_Logon_Emulation")
								{
									Ext.getCmp("noteCont").show();
									Ext.getCmp("ctxCloudWrkSpace").hide();
									Ext.getCmp('publisresource'+multidom).setReadOnly(false);
									Ext.getCmp('publisresource'+multidom).columnWidth = '1';
									Ext.getCmp('publisresource'+multidom).emptyText = hrznAppEmptyText;
									Ext.getCmp('confpublisresource'+multidom).setVisible(false);
								}
								if (!Ext.isEmpty(splitUsr2FA))
								{
									var str2FAToken = splitUsr2FA[multidom-1];
									var strDisClaimer = splitUsrDisclaim[multidom-1];
									if (!Ext.isEmpty(str2FAToken) && Ext.getCmp('twofacttoken'+multidom) != null && Ext.getCmp('twofacttoken'+multidom) != undefined)
									{
										if (str2FAToken != 'none')
										{
											Ext.getCmp('twofactlabel'+multidom+'_1').setValue(true);
											Ext.getCmp('twofacttoken'+multidom).setVisible(true);
										}
										else
										{
											Ext.getCmp('twofactlabel'+multidom+'_2').setValue(true);
											Ext.getCmp('twofacttoken'+multidom).setVisible(false);
										}
										if (Ext.getCmp('publisresource'+multidom) != null && Ext.getCmp('publisresource'+multidom) != undefined && splitPublisSrc[multidom-1] != '$unconfigured')
										{
											if (str2FAToken != 'none')
											{
												Ext.getCmp('twofacttoken'+multidom).setValue(str2FAToken);
											}
										}
										else
										{
											Ext.getCmp('twofacttoken'+multidom).setValue("");
										}
									}
									if (!Ext.isEmpty(strDisClaimer))
									{
										if (strDisClaimer.toLowerCase() == 'true')
										{
											Ext.getCmp('disclaimermultiusr'+multidom+'_1').setValue(true);
										}
										else
										{
											Ext.getCmp('disclaimermultiusr'+multidom+'_2').setValue(true);
										}
									}
								}
								if (Ext.getCmp('publisresource'+multidom) != null && Ext.getCmp('publisresource'+multidom) != undefined && splitPublisSrc[multidom-1] != '$unconfigured')
								{
									Ext.getCmp('publisresource'+multidom).setValue(splitPublisSrc[multidom-1]);
									Ext.getCmp('domainmultiusr'+multidom).setValue(splitUsrDomain[multidom-1]);
									Ext.getCmp('usermultiusr'+multidom).setValue(splituser[multidom-1]);
									Ext.getCmp('pwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
									Ext.getCmp('confpwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
								}
								else if (Ext.getCmp('publisresource'+multidom) != null && Ext.getCmp('publisresource'+multidom) != undefined)
								{
									Ext.getCmp('publisresource'+multidom).setValue("");
									Ext.getCmp('domainmultiusr'+multidom).setValue("");
									Ext.getCmp('usermultiusr'+multidom).setValue("");
									Ext.getCmp('pwdmultiusr'+multidom).setValue("");
									Ext.getCmp('confpwdmultiusr'+multidom).setValue("");
								}
							}
						}
						Ext.resumeLayouts(true);
					},
					failure: function()
					{
						loadmask.hide();
					}
					
				});
			},
			failure: function()
			{
				loadmask.hide();
			}
		});
	},

	getPopUpView : function(ResourceId)
	{
		if (Ext.getCmp('egconfigureresource') != undefined)
		{
			Ext.getCmp('egconfigureresource').removeAll();
			Ext.getCmp('backupmultirescontainer').removeAll();
			Ext.getCmp('backupmultirescontainer').doLayout();
		}
		
		var resValue = Ext.getCmp(ResourceId).getValue();
		inputs = 1;
		popUpWin = Ext.create('Ext.Window', {
			layout: 'fit',
			border: false,
			title: pubResourceToolTip,
			id: 'egconfigureresource',
			width: 700,
			height: 250,
			padding:'5 10 10 10',
			autoScroll: true,
			modal: true,
			listeners:{
				 'close':function(win){
					var fieldtoolTip = Ext.getCmp('fieldtoolTip');
					if (!Ext.isEmpty(fieldtoolTip) && fieldtoolTip.isVisible()) 
					{
						fieldtoolTip.destroy();
					}
				  },
				 'hide':function(win){
					var fieldtoolTip = Ext.getCmp('fieldtoolTip');
					if (!Ext.isEmpty(fieldtoolTip) && fieldtoolTip.isVisible()) 
					{
						fieldtoolTip.destroy();
					}
				  }
			},
			layout: {
				type: 'auto',
				pack: 'start',
				align: 'stretch'
			},
			dockedItems: [
				{
					dock: 'bottom',
					layout:{
						type:'hbox',
						align:'stretch',
						pack:'center'
					},
					border:false,
					padding : '10 0 0 0',
					items: [
						{
							xtype: 'button',
							cls: 'quickMenuWhiteButton',
							id: 'addMultiresbtn',
							width: 80,
							text: 'Add More',
							listeners : 
							{
								'click' : function()
								{
									addMultiResourceContact();
								}
							}
						},
						{
							xtype: 'button',
							cls: 'quickMenuWhiteButton',
							text: 'Update',
							width: 80,
							id: 'updateMultires',
							name: 'updateMultires',
							margin: '0 0 0 10',
							listeners : 
							{
								'click' : function()
								{
									testViews.updateMultiResourceContact(ResourceId);
								}
							}
						},
						{
							xtype: 'button',
							cls: 'quickMenuWhiteButton',
							text: 'Clear',
							width: 80,
							id: 'clearMultires',
							name: 'clearMultires',
							margin: '0 0 0 10',
							listeners : 
							{
								'click' : function()
								{
									testViews.clearMultiResourceContact();
								}
							}
						}
					]
				}
			],
			items: [
				{
					xtype: 'container',
					id: 'backupmultirescontainer',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'stretch'
					}
				},
				{
					xtype: 'container',
					id: 'NoMultiResPattern',
					hidden: true,
					layout: {
						type: 'hbox',
						pack: 'center',
						align: 'center'
					},
					border:true,
					flex:1,
					columnWidth:1,
					style:{
						'height':'100%',
					},
					items: [
						{
							xtype: 'label',
							html: '<table border="0px" height="300"><tr><td align="center"><table><tr><td align="center"><div class="iconInformation"></div><div class="commonErrorMsgText">'+noDataMsg+'</div></td></tr></table></td></tr></table>'
						}
					]
				}
			]
		});
		popUpWin.show();
		//addMultiResourceContact();
		var multidom = '';
		var splitresValue = resValue.split(",");
		if (resValue != null || resValue != undefined)
		{
			var val = splitresValue.length-1;
			for (var k =0;k<=splitresValue.length-1;k++ )
			{
				addMultiResourceContact();
			}
			for (multidom=1;multidom<splitresValue.length+1;multidom++)
			{
				if (splitresValue[multidom-1].indexOf("\\") != -1)
				{
					var folderName = splitresValue[multidom-1].split("\\");
					Ext.getCmp('folderName'+multidom).setValue(splitresValue[multidom-1].split('\\')[0]);
					if (splitresValue[multidom-1].split('\\')[1].indexOf(":") != -1)
					{
						var temp = splitresValue[multidom-1].split('\\')[1];
						Ext.getCmp('resourceName'+multidom).setValue(temp.split(':')[0]);
						Ext.getCmp('winTitle'+multidom).setValue(temp.split(':')[1]);
					}
					else
					{
						Ext.getCmp('resourceName'+multidom).setValue(splitresValue[multidom-1].split('\\')[1]);
						Ext.getCmp('winTitle'+multidom).setValue('none');
					}
				}
				else
				{
					if (splitresValue[multidom-1].indexOf(":") != -1)
					{
						Ext.getCmp('folderName'+multidom).setValue('none');
						Ext.getCmp('resourceName'+multidom).setValue(splitresValue[multidom-1].split(':')[0]);
						Ext.getCmp('winTitle'+multidom).setValue(splitresValue[multidom-1].split(':')[1]);
					}
					else
					{
						Ext.getCmp('folderName'+multidom).setValue('none');
						Ext.getCmp('resourceName'+multidom).setValue(splitresValue[multidom-1]);
						Ext.getCmp('winTitle'+multidom).setValue('none');
					}
				}
				
			}
		}
	}

});

function checkspecial(fieldValue,s_spl)
{
	var obj_val = fieldValue;
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}

function addMultiSourceContact()
{
	var mainForm = Ext.getCmp('PublishedResources');
	var backupmulticontainer = Ext.getCmp('backupmulticontainer');
	if (Ext.getCmp('mainContainer') != undefined)
	{
		if (backupmulticontainer.items.length == simulationsCount - 1)
		{
			Ext.Msg.show({
				title: alertMsgSrcTitle,
				msg: SimulationsLimitMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
	}
	else 
	{
		if (backupmulticontainer.items.length == simulationsCount)
		{
			Ext.Msg.show({
				title: alertMsgSrcTitle,
				msg: SimulationsLimitMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
	}

	var compType = Ext.getCmp('compType').getValue();
	var publishResEmptyText = "";
	if (compType!=null && compType=="Citrix_XcLogon_Emulation")
	{
		publishResEmptyText = ctxAppEmptyText;
	}
	else if (compType!=null && compType=="Hrzn_Logon_Emulation")
	{
		publishResEmptyText = hrznAppEmptyText;
	}
	
	var conIdMulti = "con_"+inputsmultisrc
	var tmpMultiContainer = {
		xtype : 'fieldset',
		id : conIdMulti,
		style: {
			'background' : '#ffffff',
			'border' : '1px solid lightGrey',
			'box-shadow':'none'
		},
		padding:'10 0 10 10',
		margin: '10 10 0 10',
		items: [
			
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					labelSeparator:' ',
					labelWidth:150
				},
				items: [
					{
						xtype: 'fieldcontainer',
						layout: 'column',
						defaults: {
							labelSeparator:' ',
							labelWidth: 150
						},
						columnWidth: 1,
						items: [
							{
								xtype: 'textfield',
								cls: 'textbox',
								fieldLabel: appNameLabel,
								style:{'white-space':'nowrap'},
								id:'publisresource'+inputsmultisrc,
								emptyText : publishResEmptyText,
								margin:'10 0 10 10',
								columnWidth: 0.97,
								enableKeyEvents : true,
								readOnly : true,
								listeners:{
									'change' :function(thistext)
									{
										if (thistext.getValue().split(",").length >= appsCount + 1)
										{
											Ext.Msg.show({
												title: alertMsgSrcTitle,
												msg: appLimitMsg,
												buttons: Ext.Msg.OK,
												icon: 'iconExclamation',
												fn: function() {
													thistext.focus(true,true);
												}
											});
											return;
										}
									}
								}
							},
							{
								xtype: 'button',
								columnWidth: 0.03,
								tooltip: pubResourceToolTip,
								id:'confpublisresource'+inputsmultisrc,
								iconCls : 'iconConfigure',
								style : {
									background : 'none',
									border : '0px'
								},
								margin: '14 0 0 2',
								listeners: {
									click: function() {
										var resId = this.getId().replace("confpublisresource","publisresource");
										testViews.getPopUpView(resId);
									}
								}
							}
						]
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: 'Domain',
						style:{'white-space':'nowrap'},
						id:'domainmultiusr'+inputsmultisrc,
						emptyText : 'Domain name',
						margin:'10 50 10 10',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: 'User',
						style:{'white-space':'nowrap'},
						id:'usermultiusr'+inputsmultisrc,
						emptyText : 'Username',
						margin:'10 0 10 50',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: 'Password',
						style:{'white-space':'nowrap'},
						id:'pwdmultiusr'+inputsmultisrc,
						inputType: 'password',
						emptyText : 'Password',
						margin:'10 50 10 10',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: 'Confirm Password',
						style:{'white-space':'nowrap'},
						id:'confpwdmultiusr'+inputsmultisrc,
						inputType: 'password',
						emptyText : 'Confirm password',
						margin:'10 0 10 50',
						columnWidth: 0.5
					},
					{
						xtype: 'fieldcontainer',
						id: 'twofaCont'+inputsmultisrc,
						fieldLabel: 'Is 2FA enabled?',
						columnWidth: 0.5,
						layout: 'column',
						margin:'10 50 10 10',
						items : [
							{
								xtype: 'radiogroup',
								columnWidth: 0.6,
								cls: 'radiobt',
								id: 'twofact'+inputsmultisrc,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: 'twofactlabel'+inputsmultisrc, id: 'twofactlabel'+inputsmultisrc+'_1',  inputValue: 'true'},
									{ boxLabel: 'No', name: 'twofactlabel'+inputsmultisrc, id: 'twofactlabel'+inputsmultisrc+'_2',  inputValue: 'false', checked: true}
								],
								listeners : {
									'change' : function(obj, value)
									{
										var value = this.getChecked()[0];
										var twofa = this.getId().replace("twofact","twofacttoken");
										if (value.getGroupValue() == 'false')
										{
											Ext.getCmp(twofa).setVisible(false);
										}
										else
										{
											Ext.getCmp(twofa).setVisible(true);
										}
									}
								}
							},
							{
								xtype: 'textfield',
								cls: 'textbox',
								style:{'white-space':'nowrap'},
								id:'twofacttoken'+inputsmultisrc,
								inputType: 'password',
								emptyText: '2FA code',
								margin:'0 0 0 5',
								hidden: true,
								columnWidth: 0.4,
								fieldHelp: 'Please provide static 2FA code.',
								listeners: {
									scope: this,
									focus: onFieldFocus,
									blur: onFieldBlur
								}
							}
						]
					},
					{
						xtype: 'radiogroup',
						columnWidth: 0.5,
						cls: 'radiobt',
						id: 'disclaimer_radioGrp'+inputsmultisrc,
						fieldLabel: 'Is disclaimer enabled?',
						vertical: false,
						columns: 2,
						margin:'10 0 10 50',
						items: [
							{ boxLabel: 'Yes', name: 'disclaimermultiusr'+inputsmultisrc, id: 'disclaimermultiusr'+inputsmultisrc+'_1',  inputValue: 'true'},
							{ boxLabel: 'No', name: 'disclaimermultiusr'+inputsmultisrc, id: 'disclaimermultiusr'+inputsmultisrc+'_2',  inputValue: 'false', checked: true}
						]
					},
					{
						xtype: 'container',
						style:{
							'position':'absolute',
							'top':'2px',
							'right':'2px',
							'width':'20px',
							'height':'20px'
						},
						margin:'0 0 0 0',
						items : [
							{
								xtype : 'button',
								iconCls : 'fieldsetClose',
								tooltip : '<b>Remove</b>',
								style : {
									background : 'none',
									border : '0px'
								},
								handler: function()
								{
									removeMultiSrc(conIdMulti);
								}
							}
						]
					}
				]
			}
		]
	}
	
	backupmulticontainer.add(tmpMultiContainer);
	mainForm.doLayout();

	var compType = Ext.getCmp('compType').getValue();
	if (compType!=null && compType=="Citrix_XcLogon_Emulation")
	{
		Ext.getCmp('publisresource'+inputsmultisrc).setReadOnly(true);
		Ext.getCmp('publisresource'+inputsmultisrc).columnWidth = '0.97';
		Ext.getCmp('publisresource'+inputsmultisrc).emptyText = ctxAppEmptyText;
		Ext.getCmp('confpublisresource'+inputsmultisrc).setVisible(true);
		Ext.getCmp('noteCont').hide();
		Ext.getCmp('ctxCloudWrkSpace').show();
	}
	else if (compType!=null && compType=="Hrzn_Logon_Emulation")
	{
		Ext.getCmp('publisresource'+inputsmultisrc).setReadOnly(false);
		Ext.getCmp('publisresource'+inputsmultisrc).columnWidth = '1';
		Ext.getCmp('publisresource'+inputsmultisrc).emptyText = hrznAppEmptyText;
		Ext.getCmp('confpublisresource'+inputsmultisrc).setVisible(false);
		Ext.getCmp('noteCont').show();
		Ext.getCmp('ctxCloudWrkSpace').hide();
	}
	
	Ext.getCmp('publisresource'+inputsmultisrc).focus(true);

	Ext.getCmp('addMultiSrcbtn').setText('Add More');
	Ext.getCmp('updateMultiConfSrc').enable();
	Ext.getCmp('clearMultiConfSrc').enable();
	Ext.getCmp('NoMultiUsrPattern').hide();

	inputsmultisrc++;
}

function addMultiResourceContact()
{
	var mainForm = Ext.getCmp('egconfigureresource');
	var backupmulticontainer = Ext.getCmp('backupmultirescontainer');
	if (backupmulticontainer.items.length == appsCount)
	{
		Ext.Msg.show({
			title: alertMsgSrcTitle,
			msg: appLimitMsg,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return;
	}
	var conIdRes = "conRes_"+inputs
	var tmpMultiContainer = {
		xtype : 'fieldset',
		id : conIdRes,
		style: {
			'background' : '#ffffff',
			'border' : '1px solid lightGrey',
			'box-shadow':'none'
		},
		padding:'10 0 10 10',
		margin: '10 10 0 10',
		items: [
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					labelSeparator:' ',
					labelWidth:150
				},
				items: [
					{
						xtype: 'fieldcontainer',
						layout: 'column',
						columnWidth: 1,
						defaults: {
							margin: 5,
							labelSeparator:' ',
							labelAlign: 'top',
						},
						items: [
							{
								xtype: 'textfield',
								cls: 'textbox',
								style:{'white-space':'nowrap'},
								id:'folderName'+inputs,
								fieldLabel: 'Tab Name',
								fieldHelp: tabHelpTip,
								value: 'none',
								columnWidth: 0.33,
								listeners: {
									scope: this,
									focus: onFieldFocus,
									blur: onFieldBlur
								}
							},
							{
								xtype: 'textfield',
								cls: 'textbox',
								style:{'white-space':'nowrap'},
								fieldLabel: 'Application/Desktop Name',
								id:'resourceName'+inputs,
								fieldHelp: appHelpTip,
								columnWidth: 0.34,
								listeners: {
									scope: this,
									focus: onFieldFocus,
									blur: onFieldBlur
								}
							},
							{
								xtype: 'textfield',
								cls: 'textbox',
								style:{'white-space':'nowrap'},
								fieldLabel: 'Window Title',
								fieldHelp: winHelpTip,
								id:'winTitle'+inputs,
								value: 'none',
								columnWidth: 0.33,
								listeners: {
									scope: this,
									focus: onFieldFocus,
									blur: onFieldBlur
								}
							}
						]
					},
					{
						xtype: 'container',
						style:{
							'position':'absolute',
							'top':'2px',
							'right':'2px',
							'width':'20px',
							'height':'20px'
						},
						margin:'0 0 0 0',
						items : [
							{
								xtype : 'button',
								iconCls : 'fieldsetClose',
								tooltip : '<b>Remove</b>',
								style : {
									background : 'none',
									border : '0px'
								},
								handler: function()
								{
									removeMultiResource(conIdRes);
								}
							}
						]
					}
				]
			}
		]
	}
	backupmulticontainer.add(tmpMultiContainer);
	mainForm.doLayout();

	Ext.getCmp('addMultiresbtn').setText('Add More');
	Ext.getCmp('updateMultires').enable();
	Ext.getCmp('clearMultires').enable();
	Ext.getCmp('NoMultiResPattern').hide();

	inputs++;
}

function onFieldFocus (el) 
{
	var x = Ext.getCmp('viewport').getWidth();
	var xpos = x/2;
	var y = Ext.getCmp('viewport').getHeight();
	var ypos = y/2;
	var text = el.fieldHelp;

	var titleText = "Help";
	if (el.id.startsWith("folderName"))
	{
		titleText = "Help - Tab Name";
	}
	else if (el.id.startsWith("resourceName"))
	{
		titleText = "Help - Application/Desktop Name";
	}
	else if (el.id.startsWith("winTitle"))
	{
		titleText = "Help - Window Title";
	}
	else if (el.id.startsWith("twofacttoken"))
	{
		titleText = "Help - 2FA Code";
	}

	if (typeof text !== "undefined") 
	{
		this.fieldHelp1 = Ext.create('Ext.tip.Tip', {
			id: 'fieldtoolTip',
			ui:'infobox',
			iconCls:'iconSimulatorInfo',
			title: titleText,
			width : 700,
			height: 130,
			maxWidth: 900
		});
		this.fieldHelp1.update(text);
		this.fieldHelp1.fieldId = el.id;
		this.fieldHelp1.showAt([xpos-350,ypos-260]);
    }
}
 
function onFieldBlur (el) 
{
	var fieldtoolTip = Ext.getCmp('fieldtoolTip');
	if (fieldtoolTip.isVisible()) 
	{
		fieldtoolTip.destroy();
	}
}

function removeMultiSrc(containerID) 
{
	var backupcontainer = Ext.getCmp('backupmulticontainer');
	var mainContainer = Ext.getCmp('conmulti_1');
	backupcontainer.remove(containerID);
	var bckitemsmultiLen = backupcontainer.items.length;
	if (containerID == 'conmulti_1')
	{
		ismultisrc = 'true';
		Ext.getCmp('conmulti_1').removeAll();
		Ext.getCmp('conmulti_1').hide();
		Ext.getCmp('addMultiSrcbtn').setText('Add');
	}
	if (bckitemsmultiLen == 0)
	{
		if (mainContainer.items.length == 0)
		{
			ismultisrc = 'true';
			inputsmultisrc = 1;
		}
		if (ismultisrc == 'true')
		{
			Ext.getCmp('NoMultiUsrPattern').show();
			Ext.getCmp('noteCont').hide();
			Ext.getCmp('updateMultiConfSrc').disable();
			Ext.getCmp('clearMultiConfSrc').disable();
			Ext.getCmp('addMultiSrcbtn').setText('Add');
		}
	}
}

function removeMultiResource(containerID)
{
	var backupcontainer = Ext.getCmp('backupmultirescontainer');
	backupcontainer.remove(containerID);
	var bckitemsmultiLen = backupcontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		inputs = 1;
		Ext.getCmp('NoMultiResPattern').show();
		Ext.getCmp('updateMultires').disable();
		Ext.getCmp('clearMultires').disable();
		Ext.getCmp('addMultiresbtn').setText('Add');
	}
}

function checkspecialExt(field,s_spl)
{
	if (typeof(field)=='object')
	{
		obj_val = field.value;
	}
	else
	{
		obj_val = field;
	}
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}



