Ext.define('LogonSimulator.view.DownloadUtils',{
	alias:'widget.DownloadUtils',
	id:'DownloadUtils',
	download : function(s_qryString,osname)
	{
		var progressBar = Ext.MessageBox.progress({
			title: 'Download status',
			value: 5,
			width: 100,
			increment: 15,
			closable: true,
			cls:'custom',
			progressText: 'Connecting..',
			wait: true,
			waitConfig: {
				interval: 200
			},
			msg: '<b>Agent Downloading. Please wait...</b>'
		});

		var iFrameExists = Ext.query("#pdfIframe");

		if(Ext.isEmpty(iFrameExists))
		{
			Ext.DomHelper.append(document.body, {
				tag: 'iframe',
				frameBorder: 0,
				width: 0,
				height: 0,
				css: 'display:none;visibility:hidden;height:1px;',
				src: s_qryString,
				id: 'pdfIframe'
			});
		}
		else
		{
			Ext.select('#pdfIframe').set( { src :  s_qryString });
		}

		Ext.Ajax.request(
		{
			url : '/final/portal/LogonSimulator/data/DownloadStatusJson.jsp?osname='+encodeURIComponent(osname),
			scope:this,
			timeout:240000,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);

				if(!Ext.isEmpty(jsonData))
				{
					var downloadStatus = jsonData.isDownloaded;
					if(downloadStatus == true)
					{
						progressBar.hide();
						Ext.Msg.show({
							title: "Download Agent",
							msg: "Agent downloaded successfully",
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function() {
								Ext.getCmp('mainTab').setVisible(false);
								Ext.getCmp('getStarted').setVisible(true);
								Ext.getCmp('2stepView').setVisible(true);
								Ext.getCmp('buttonCont').hide();
							}
						});
					}
					else
					{
						progressBar.hide();
						Ext.Msg.show({
							 title:'Agent Pack Download',
							 msg: 'Invalid dir!',
							 buttons: Ext.Msg.OK,
							 icon: Ext.Msg.ERROR
						});
					}
				}
				else
				{
					progressBar.hide();
				}
			},
			failure : function()
			{
				progressBar.hide();
				console.log("failure");
			}
		});
	}
});



