Ext.define('LogonSimulator.view.PublishedResources',{
	extend: 'Ext.form.Panel',
	alias: 'widget.PublishedResources',
	id: 'PublishedResources',
	autoScroll: true,
	scroll: false,
	margin: 20,
	bodyPadding:10,
	flex: 1,
	requires:[
		'utilities.ScrollCombo',
	],
	layout: {
		type: 'auto',
		pack: 'start',
		align: 'stretch'
	},

	dockedItems:[
		{
			dock: 'top',
			xtype: 'toolbar',
			margin: '0 16 -14 16',
			ui: 'citrixLogonToolbar',
			style: {
				'border':'0px solid red',
				'overflow':'visible',
				'background':'#f7f7f7',
				'height':'30px',
				'z-index':'999'
			},
			items: [
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					fieldLabel: 'Simulator',
					style:{'white-space':'nowrap'},
					id: 'compType',
					name: 'compType',
					hidden: true,
					displayField:'displayField',
					valueField:'valueField',
					queryMode: 'local',
					emptyText:'Not Applicable',
					parent:this,
					readOnlyCls:'textbox',
					width: 270,
					labelWidth: 70,
					labelSeparator:' ',
					labelStyle:{'font-weight':'bold'},
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					}),
					margin: '0 15 0 0'
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: 'Site URL',
					style:{'white-space':'nowrap'},
					id:'siteUrl',
					labelWidth: 60,
					emptyText : 'URL for connecting to StoreFront/NetScaler/Web Interface',
					labelSeparator:' ',
					labelStyle:{'font-weight':'bold'},
					flex: 1
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					margin: '0 0 0 15',
					fieldLabel: 'Browser Type',
					style:{'white-space':'nowrap'},
					id: 'browserType',
					displayField:'displayField',
					valueField:'valueField',
					queryMode: 'local',
					emptyText:'Not Applicable',
					parent:this,
					readOnlyCls:'textbox',
					width: 180,
					labelWidth: 95,
					labelSeparator:' ',
					labelStyle:{'font-weight':'bold'},
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					})
				}
			]
		}
	],

	items: [
		{
			xtype : 'panel',
			border:false,
			style: {
				'background' : 'none',
				'border':'none',
				'box-shadow':'none'
			},
			layout: {
				type: 'vbox',
				pack: 'start',
				align: 'stretch'
			},
			margin:'10 0 0 0',
			items: [
				{
					xtype: 'container',
					margin: '10 0 0 10',
					items: [
						{
							xtype: 'radiogroup',
							cls: 'radiobt',
							id: 'ctxCloudWrkSpace',
							fieldLabel: 'Is this service hosted on Citrix Cloud?',
							style:{'white-space':'nowrap'},
							vertical: false,
							columns: 2,
							width: 400,
							labelWidth: 250,
							labelSeparator:' ',
							labelStyle:{'font-weight':'bold'},
							items: [
								{ boxLabel: 'Yes', name: 'ctxCloudWrkSpace1', id: 'ctxCloudWrkSpace1_1',  inputValue: 'true'},
								{ boxLabel: 'No', name: 'ctxCloudWrkSpace1', id: 'ctxCloudWrkSpace1_2',  inputValue: 'false', checked: true}
							]
						}
					]
				},
				{
					xtype: 'container',
					id: 'NoMultiUsrPattern',
					hidden: true,
					layout: {
						type: 'hbox',
						pack: 'center',
						align: 'center'
					},
					border:true,
					flex:1,
					columnWidth:1,
					style:{
						'height':'100%',
					},
					items: [
						{
							xtype: 'label',
							html: '<table border="0px" height="280"><tr><td align="center"><table><tr><td align="center"><div class="iconInformation"></div><div class="commonErrorMsgText">'+noDataMsg+'</div></td></tr></table></td></tr></table>'
						}
					]
				},
				{
					xtype: 'container',
					border:false,
					id: 'noteCont',
					style: {
						'border' : '1px solid red',
					},
					height: 20,
					margin: '5 10 0 10',
					html: '<div><strong style="font-weight:bold;">Note:</strong> Please ensure that VMware Horizon HTML Access is installed on the VMware Horizon Connection Server.</div>'
				},
				{
					xtype : 'fieldset',
					id : 'conmulti_1',
					style: {
						'background' : '#ffffff',
						'border' : '1px solid lightGrey',
						'box-shadow':'none'
					},
					padding:'10 0 10 10',
					margin: '10 10 0 10',
					items: [
						{
							xtype: 'container',
							id: 'mainContainer',
							layout: 'column',
							defaults: {
								labelSeparator:' ',
								labelWidth: 150
							},
							items: [
								{
									xtype: 'fieldcontainer',
									layout: 'column',
									defaults: {
										labelSeparator:' ',
										labelWidth: 150
									},
									columnWidth: 1,
									items: [
										{
											xtype: 'textfield',
											cls: 'textbox',
											fieldLabel: appNameLabel,
											style:{'white-space':'nowrap'},
											id:'publisresource1',
											emptyText : ctxAppEmptyText,
											margin:'10 0 10 10',
											columnWidth: 0.97,
											enableKeyEvents : true,
											//readOnly : true,
											listeners:{
												'change' :function()
												{
													var val = Ext.getCmp('publisresource1').getValue();
													if (val.split(",").length >= appsCount + 1)
													{
														Ext.Msg.show({
															title: alertMsgSrcTitle,
															msg: appLimitMsg,
															buttons: Ext.Msg.OK,
															icon: 'iconExclamation',
															fn: function() {
																Ext.getCmp('publisresource1').focus(true,true);
															}
														});
														return;
													}
												}
											}
										},
										{
											xtype: 'button',
											columnWidth: 0.03,
											tooltip: pubResourceToolTip,
											id: 'confpublisresource1',
											iconCls : 'iconConfigure',
											style : {
												background : 'none',
												border : '0px'
											},
											margin: '14 0 0 2',
											listeners: {
												click: function() {
													testViews.getPopUpView('publisresource1');
												}
											}
										}
									]
								},
								{
									xtype: 'textfield',
									cls: 'textbox',
									fieldLabel: 'Domain',
									style:{'white-space':'nowrap'},
									id:'domainmultiusr1',
									emptyText : 'Domain name',
									margin:'10 50 10 10',
									columnWidth: 0.5
								},
								{
									xtype: 'textfield',
									cls: 'textbox',
									fieldLabel: 'User',
									style:{'white-space':'nowrap'},
									id:'usermultiusr1',
									emptyText : 'Username',
									margin:'10 0 10 50',
									columnWidth: 0.5
								},
								{
									xtype: 'textfield',
									cls: 'textbox',
									fieldLabel: 'Password',
									style:{'white-space':'nowrap'},
									id:'pwdmultiusr1',
									inputType: 'password',
									emptyText : 'Password',
									margin:'10 50 10 10',
									columnWidth: 0.5
								},
								{
									xtype: 'textfield',
									cls: 'textbox',
									fieldLabel: 'Confirm Password',
									style:{'white-space':'nowrap'},
									id:'confpwdmultiusr1',
									inputType: 'password',
									emptyText : 'Confirm password',
									margin:'10 0 10 50',
									columnWidth: 0.5
								},
								{
									xtype: 'fieldcontainer',
									id: 'twofaCont1',
									fieldLabel: 'Is 2FA enabled?',
									columnWidth: 0.5,
									layout: 'column',
									margin:'10 50 10 10',
									items : [
										{
											xtype: 'radiogroup',
											columnWidth: 0.6,
											cls: 'radiobt',
											id: 'twofact1',
											vertical: false,
											columns: 2,
											items: [
												{ boxLabel: 'Yes', name: 'twofactlabel1', id: 'twofactlabel1_1',  inputValue: 'true'},
												{ boxLabel: 'No', name: 'twofactlabel1', id: 'twofactlabel1_2',  inputValue: 'false', checked: true}
											],
											listeners : {
												'change' : function(obj, value)
												{
													var value = Ext.getCmp('twofact1').getChecked()[0];
													if (value.getGroupValue() == 'false')
													{
														Ext.getCmp('twofacttoken1').setVisible(false);
													}
													else
													{
														Ext.getCmp('twofacttoken1').setVisible(true);
													}
												}
											}
										},
										{
											xtype: 'textfield',
											cls: 'textbox',
											style:{'white-space':'nowrap'},
											id:'twofacttoken1',
											inputType: 'password',
											emptyText: '2FA code',
											margin: '0 0 0 5',
											columnWidth: 0.4,
											hidden: true,
											enableKeyEvents : true,
											fieldHelp: 'Please provide static 2FA code.',
											listeners: {
												scope: this,
												focus: onFieldFocus,
												blur: onFieldBlur
											}
										}
									]
								},
								{
									xtype: 'radiogroup',
									columnWidth: 0.5,
									cls: 'radiobt',
									id: 'disclaimer_radioGrp1',
									fieldLabel: 'Is disclaimer enabled?',
									vertical: false,
									columns: 2,
									margin:'10 0 10 50',
									items: [
										{ boxLabel: 'Yes', name: 'disclaimermultiusr1', id: 'disclaimermultiusr1_1',  inputValue: 'true'},
										{ boxLabel: 'No', name: 'disclaimermultiusr1', id: 'disclaimermultiusr1_2',  inputValue: 'false', checked: true}
									]
								},
								{
									xtype: 'container',
									style:{
										'position':'absolute',
										'top':'2px',
										'right':'2px',
										'width':'20px',
										'height':'20px'
									},
									margin:'0 0 0 0',
									items : [
										{
											xtype : 'button',
											iconCls : 'fieldsetClose',
											tooltip : '<b>Remove</b>',
											style : {
												background : 'none',
												border : '0px'
											},
											handler: function()
											{
												removeMultiSrc('conmulti_1');
											}
										}
									]
								}
							]
						}
					]
				},
				{
					xtype: 'container',
					id: 'backupmulticontainer',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'stretch'
					}
				}
			]
		}
	]
});

function onFieldFocus (el) 
{
	var x = Ext.getCmp('viewport').getWidth();
	var xpos = x/2;
	var y = Ext.getCmp('viewport').getHeight();
	var ypos = y/2;
	var text = el.fieldHelp;

	var titleText = "Help";
	if (el.id.startsWith("folderName"))
	{
		titleText = "Help - Tab Name";
	}
	else if (el.id.startsWith("resourceName"))
	{
		titleText = "Help - Application/Desktop Name";
	}
	else if (el.id.startsWith("winTitle"))
	{
		titleText = "Help - Window Title";
	}
	else if (el.id.startsWith("twofacttoken"))
	{
		titleText = "Help - 2FA Code";
	}

	if (typeof text !== "undefined") 
	{
		this.fieldHelp1 = Ext.create('Ext.tip.Tip', {
			id: 'fieldtoolTip',
			ui:'infobox',
			iconCls:'iconSimulatorInfo',
			title: titleText,
			width : 700,
			height: 130,
			maxWidth: 900
		});
		this.fieldHelp1.update(text);
		this.fieldHelp1.fieldId = el.id;
		this.fieldHelp1.showAt([xpos-350,ypos-260]);
    }
}
 
function onFieldBlur (el) 
{
	var fieldtoolTip = Ext.getCmp('fieldtoolTip');
	if (fieldtoolTip.isVisible()) 
	{
		fieldtoolTip.destroy();
	}
}




