Ext.define('PortalLogin.view.ForgetPassword', {
	extend: 'Ext.form.Panel',
	alias: 'widget.ForgetPassword',
	id: 'ForgetPassword',

	requires: [
		'PortalLogin.view.FormErrorState'
	],

	frame: false,
	border : false,
	bodyPadding:0,
	layout:'anchor',
	align:'center',
	height:'auto',

	defaults: {
		labelAlign: 'top',
		allowBlank: false,
		anchor:'100%',
		msgTarget: 'none',
		invalidCls: ''//unset the invalidCls so individual fields do not get styled as invalid
	},

	items: [
		{
			xtype:'container',
			margin:'0 10 10 10',
			html: '<div class="portalLoginText">Forgot Password</div>'
		},
		{
			xtype: 'textfield',
			cls: 'textboxPortalLoginMailId',
			name: 'fpusername',
			id: 'fpusername',
			emptyText : 'Email',
			maxLength : 256,
			enforceMaxLength : true,
			listeners:{
				specialkey: function (f,e) {
					if (e.getKey() == e.ENTER) {
						Ext.getCmp('getPassword').focus();
					}
				}
			},
			margin:'10px 10px 0px 10px'
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'end'
			},
			margin: '5 12 10 10',
			items:[
				{
					xtype: 'container',
					bodyPadding: '0px',
					html: '<div id="gotologindiv" style="cursor:pointer;text-decoration:none;font-size:9px;line-height:1.2em;color:#ffffff;">Sign In</div>'
				}
			]
		},
		{
			xtype: 'formErrorState',
			id: 'errorState2',
			anchor: '100%',
			bodyPadding:'0px',
			margin:'0px 10px 20px 10px',
			hidden: true
		},
		{
			xtype: 'button',
			action: 'submit',
			buttonAlign: 'right',
			ui:'ls_ButtonBig',
			scale:'large',
			margin:'0 10 10 10',
			bodyPadding: '0px',
			id: 'getPassword',
			disabled: false,
			text: 'GET PASSWORD'
		}
	]
});



