/*
 * File: app/view/FormErrorState.js
 *
 * This file was generated by Sencha Architect version 2.1.0.
 * http://www.sencha.com/products/architect/
 *
 * This file requires use of the Ext JS 4.0.x library, under independent license.
 * License of Sencha Architect does not include license for Ext JS 4.0.x. For more
 * details see http://www.sencha.com/license or contact license@sencha.com.
 *
 * This file will be auto-generated each and everytime you save your project.
 *
 * Do NOT hand edit this file.
 */

Ext.define('PortalLogin.view.FormErrorState', {
	extend: 'Ext.Component',
	alias: 'widget.formErrorState',
	validText: 'Form is valid',
	invalidText: 'Form has errors',
	baseCls: 'form-error-state',
	cls:'ls_loginErrorMsg',
	initComponent: function() {
		var me = this;

		me.callParent(arguments);
	},

	getTip: function() {
		var tip = this.tip;
		if (!tip) {
			tip = this.tip = Ext.widget('tooltip', {
				target: this.el,
				title: 'Error Details:',
				autoHide: false,
				anchor: 'top',
				mouseOffset: [-11, -2],
				closable: true,
				constrainPosition: false,
				cls: 'errors-tip'
			});
			tip.show();
		}
		return tip;
	},

	setErrors: function(errorstext) {
		var me = this,
		baseCls = me.baseCls;

		var tipTpl = Ext.create('Ext.XTemplate', 
		[
		'<ul><tpl for=".">',
		'<li><span class="field-name">{name}</span>: ',
		'<span class="error">{error}</span></li>',
		'</tpl></ul>'
		]);

		errors = Ext.Array.from(errorstext);
		
		// Update CSS class and tooltip content
		if (errors.length) {
			me.addCls(baseCls + '-invalid');
			me.removeCls(baseCls + '-valid');
			me.update(errorstext);
			
		} else {
			me.addCls(baseCls + '-valid');
			me.removeCls(baseCls + '-invalid');
			me.update(me.validText);
		}
	},
	setTiperrors : function(error) {
		var me = this,
		baseCls = me.baseCls; 
		errors = Ext.Array.from(error);
		
		if (errors.length) {
			me.addCls(baseCls + '-invalid');
			me.removeCls(baseCls + '-valid');
			me.setDisabled(true);
			
		} else {
			me.addCls(baseCls + '-valid');
			me.removeCls(baseCls + '-invalid');
			me.setDisabled(false);
		}
	}
});



