Ext.define('PortalLogin.view.RegFormCS', {
	extend: 'Ext.form.Panel',
	alias: 'widget.RegFormCS',
	id: 'RegFormCS',
	name: 'RegFormCS',

	requires: [
		'PortalLogin.view.FormErrorState',
		'utilities.ScrollCombo'
	],

	frame: false,
	border : false,
	bodyPadding:0,
	layout:'anchor',
	align:'center',
	height:'auto',

	defaults: {
		labelAlign: 'top',
		allowBlank: false,
		anchor:'100%',
		msgTarget: 'none',
		invalidCls: ''//unset the invalidCls so individual fields do not get styled as invalid
	},

	items: [
		{
			xtype: 'fieldcontainer',
			layout: 'column',
			columnWidth: 1,
			margin:'10px 10px 10px 10px',
			items: [
				{
					xtype: 'textfield',
					cls: 'cs_textboxPortalLoginMailId',
					name: 'fname',
					id: 'fname',
					emptyText : 'First Name',
					margin:'10 5 0 0',
					columnWidth: 0.5,
					listeners: {
						focus : function(obj)
						{
							obj.removeCls('cs_warning');
						}
					}
				},
				{
					xtype: 'textfield',
					cls: 'cs_textboxPortalLoginMailId',
					name: 'lname',
					id: 'lname',
					emptyText : 'Last Name',
					margin:'10 0 0 5',
					columnWidth: 0.5,
					listeners: {
						focus : function(obj)
						{
							obj.removeCls('cs_warning');
						}
					}
				}
			]
		},
		{
			xtype: 'textfield',
			cls: 'cs_textboxPortalLoginMailId',
			name: 'emailid',
			id: 'emailid',
			emptyText : 'Corporate Email',
			maxLength : emailMaxLength,
			enforceMaxLength : true,
			margin:'10px 10px 0px 10px',
			listeners: {
				focus : function(obj)
				{
					obj.removeCls('cs_warning');
				}
			}
		},
		{
			xtype: 'fieldcontainer',
			layout: 'column',
			columnWidth: 1,
			margin:'0px 10px 0px 10px',
			items: [
				{
					xtype: 'textfield',
					cls: 'cs_textboxPortalLoginPassword',
					inputType: 'password',
					name: 'password',
					emptyText : 'Password',
					id:'password',
					margin:'10 5 0 0',
					columnWidth: 0.5,
					listeners: {
						focus : function(obj)
						{
							obj.removeCls('cs_warning');
						}
					}
				},
				{
					xtype: 'textfield',
					cls: 'cs_textboxPortalLoginPassword',
					inputType: 'password',
					name: 'cpassword',
					emptyText : 'Confirm Password',
					id:'cpassword',
					margin:'10 0 0 5',
					columnWidth: 0.5,
					listeners: {
						focus : function(obj)
						{
							obj.removeCls('cs_warning');
						}
					}
				}
			]
		},
		{
			xtype: 'fieldcontainer',
			layout: 'column',
			columnWidth: 1,
			margin:'0px 10px 10px 10px',
			items: [
				{
					xtype: 'textfield',
					cls: 'cs_textboxPortalLoginCompany',
					name: 'company',
					emptyText : 'Company',
					id:'company',
					margin:'10 3 0 0',
					columnWidth: 0.5,
					listeners: {
						focus : function(obj)
						{
							obj.removeCls('cs_warning');
						}
					}
				},
				{
					xtype: 'textfield',
					cls: 'cs_textboxPortalLoginPhone',
					name: 'phoneNo',
					emptyText : 'Phone/Mobile Number',
					id:'phoneNo',
					margin:'10 0 0 3',
					columnWidth: 0.5,
					listeners: {
						focus : function(obj)
						{
							obj.removeCls('cs_warning');
						}
					}
				}
			]
		},
		{
			xtype:'scrollcombo',
			id: 'timeZone',
			name: 'timeZone',
			cls: 'cs_dropdown28 iconTimeZone',
			editable : true,
			emptyText : 'Time Zone',
			store: new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []
			}),
			displayField : 'displayField',
			valueField : 'valueField',
			queryMode : 'local',
			disabled : false,
			margin:'0px 10px 15px 10px',
			listeners: {
				focus : function(obj)
				{
					obj.removeCls('cs_warning');
				}
			}
		},
		{
			xtype:'scrollcombo',
			id: 'simulator',
			name: 'simulator',
			cls: 'cs_dropdown28 iconTimeZone',
			editable : true,
			forceSelection : true,
			hidden : hideSimulator,
			displayField : 'displayField',
			valueField : 'valueField',
			queryMode : 'local',
			emptyText : 'Environment for Logon Simulation',
			store: new Ext.data.Store({
				fields: ['displayField','valueField'],
				data: []
			}),
			margin:'0px 10px 15px 10px',
			listeners: {
				focus : function(obj)
				{
					obj.removeCls('cs_warning');
				}
			}
		},
		{
			xtype: 'button',
			action: 'submit',
			buttonAlign: 'right',
			ui:'cs_ButtonBig',
			margin:'5 10 10 10',
			bodyPadding: '0px',
			scale:'large',
			id: 'reg',
			anchor:'',
			disabled: false,
			text: 'Register'
		},
		{
			xtype: 'hiddenfield',
			id: 'hiddenFName',
			name: 'hiddenFName'
		},
		{
			xtype: 'hiddenfield',
			id: 'hiddenLName',
			name: 'hiddenLName'
		},
		{
			xtype: 'hiddenfield',
			id: 'hiddenEmail',
			name: 'hiddenEmail'
		},
		{
			xtype: 'hiddenfield',
			id: 'hiddenpass',
			name: 'hiddenpass'
		},
		{
			xtype: 'hiddenfield',
			id: 'hiddenComp',
			name: 'hiddenComp'
		},
		{
			xtype: 'hiddenfield',
			id: 'hiddenTimeZone',
			name: 'hiddenTimeZone'
		},
		{
			xtype: 'hiddenfield',
			id: 'hiddenPhoneNo',
			name: 'hiddenPhoneNo'
		}
	]
});



