Ext.define('PortalLogin.view.TwoFACS', {
	extend: 'Ext.form.Panel',
	alias: 'widget.TwoFACS',
	id:'TwoFACS',
	frame: false,
	border : false,

	items: [
		{
			xtype: 'hiddenfield',
			id: '_empcode',
			name: '_empcode'
		},
		{
			xtype: 'hiddenfield',
			id: '_passwd',
			name: '_passwd'
		},
		{
			xtype: 'hiddenfield',
			id: '_from',
			name: '_from'
		},
		{
			xtype: 'hiddenfield',
			id: '_twoFA',
			name: '_twoFA'
		},
		{
			xtype: 'container',
			layout: {
				type: 'anchor',
				height:'auto',
				align: 'center'
			},
			defaults: {
				labelAlign: 'top',
				allowBlank: false,
				anchor:'100%',
				msgTarget: 'none',
				invalidCls: ''//unset the invalidCls so individual fields do not get styled as invalid
			},
			items: [
				{
					xtype:'container',
					margin:'5 10 10 10',
					html: '<div class="cs_verificationHeadText">Email Verification</div>'
				},
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'center',
						align: 'stretch'
					},
					flex:1,
					margin:'10 10 7 10',
					items: [
						{
							xtype: 'container',
							flex:1,
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'stretch'
							},
							items: [
								{
									xtype: 'label',
									id:'mailIdLabel',
									html: '<div class="cs_verificationMsg">Enter the verification code sent to your email address<br/> <span class="cs_mailText">xxx@eginnovations.com</span></div>'
								}
							]
						}
					]
				},
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'center',
						align: 'stretch'
					},
					id:'cs_otp',
					margin:'0 10 4 10',
					items: [
						{
							xtype : 'textfield',
							name : 'otp',
							id:'otp',
							labelSeparator: '',
							margin:0,
							enableKeyEvents : true,
							listeners :
							{
								'afterrender':function(textbox){
									$("#"+textbox.id+'-inputEl').mask("**-**-**",{placeholder:' '});
									Ext.defer(function(){
										$("#"+textbox.id+'-inputEl').focus();
									},1000)
								},
								'keydown' : function(textbox,e,opts)
								{
									if(e.getKey() == 13) // Enter Key
									{
										//appCnt.twofalogin();
										Ext.getCmp('2fa_submit').focus();
									}
								},
								focus : function(obj)
								{
									obj.removeCls('cs_warning');
								}
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: {
						type: 'anchor',
						pack: 'center',
						align: 'stretch'
					},
					hidden: false,
					margin:'0 10 6 10',
					id: 'resendOtpCnt',
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'stretch'
							},
							items: [
								{
									xtype: 'label',
									html: '<div class="cs_resendCodeMsg">Haven\'t received the code yet? <span id="resend_otp_divCS"> Resend code </span></div>',
									listeners: {
										click: {
											element: 'el',
											fn: function()
											{
												var empcode = Ext.getCmp('_empcode').getValue();
												var from = Ext.getCmp('_from').getValue();
												var twoFA = Ext.getCmp('_twoFA').getValue();
												if (twoFA == 'fwdToGoogleAuthLoginPage' || twoFA == 'forwardTo2faLoginPg')
												{
													appCnt.sendOtpForLogin(empcode,from,'resendotp',twoFA);
												}
												else
												{
													appCnt.sendOtp(empcode,from,'resendotp');
												}
												Ext.getCmp('resendOtpCnt').hide();
											}
										}
									}
								}
							]
						}
					]
				},
				{
					xtype : 'button',
					action : 'submit',
					buttonAlign :'right',
					id :'2fa_submit',
					text: 'VERIFY',
					ui:'cs_ButtonBig',
					anchor:'',
					margin:'10 10 10 10',
					scale:'large'
				}
			]
		}
	]
});



