var originalShow = Ext.window.MessageBox.prototype.show;

Ext.override(Ext.window.MessageBox,{
	minWidth : 300,
	show: function(cfg) {
		if (cfg != undefined && cfg.msg != undefined)
		{
			cfg.msg = Ext.String.trim(cfg.msg);
			var lastChar = cfg.msg.charAt(cfg.msg.length-1);
			if (lastChar  !=  '.'  &&  lastChar  !=  '?')
			{
				cfg.msg = cfg.msg + ".";
			}
		}
		if (cfg != undefined && cfg.msg != undefined && !cfg.hasOwnProperty("width"))
		{
			var tmpWidth = cfg.msg.length * 7;
			Ext.applyIf(cfg,{width : tmpWidth});
		}
		return originalShow.apply(this, arguments);
	},
	alert: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) {
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '.'  &&  lastChar  !=  '?')
				{
					msg = msg + ".";
				}
			}
			cfg = {
				title : cfg,
				msg : msg ,
				buttons: this.OK,
				icon : 'iconExclamation',
				fn: fn,
				scope : scope,
				minWidth: this.minWidth
			};
		}
		return this.show(cfg);
	},
	confirm: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) {
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '?')
				{
					msg = msg + "?";
				}
			}
			cfg = {
				title: cfg,
				icon: 'iconConfirmation',
				msg: msg,
				buttons: this.YESNO,
				callback: fn,
				scope: scope
			};
		}
		return this.show(cfg);
	}
});

Ext.define('PortalLogin.view.Viewport', {
	extend: 'Ext.container.Viewport',
	layout:{
		type:'fit',
		align:'stretch',
		pack:'start',
	},
	id: 'viewport',
	requires: [
		'PortalLogin.view.LogonSimulatorView',
		'PortalLogin.view.CitrixView',
		'PortalLogin.view.SaaSRegistrationView'
	],

	initComponent: function() 
	{
		if (Ext.get('loadmask'))
		{
			Ext.get('loadmask').remove();
		}
		
		if (reqFrom == "clsTrial")
		{
			this.items = [
				{
					xtype : 'LogonSimulatorView'
				}
			];
		}
		else if (reqFrom == "citrix")
		{
			if (cloudModel.toLowerCase() == 'phoenix')
			{
				this.items = [
					{
						xtype : 'SaaSRegistrationView'
					}
				];
			}
			else
			{
				this.items = [
					{
						xtype : 'CitrixView'
					}
				];
			}
		}
		this.callParent();
	}
});



