<!DOCTYPE html>

<%
/**************************************************************************************************
* File name			: ErAlarmHistoryResults.jsp
* Purpose			: Genarates History of Alarm Report Results
* Version			: 1.0
* Creation			: 9th June 2011
* Last Modified		:
* Author			: Sathya Kala Veeraraj
**************************************************************************************************/
%>


<%@ include file = "ErTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgDiscInfoHelper"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgTablesInfo"%>
<%@ page import = "com.eg.EgURLDecoder" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.LangInfo"%>

<%@ page import = "com.egurkha.monitor.EgServiceMappingBean"%>
<%@ page import = "com.egurkha.monitor.EgComponentUserMappingBean"%>

<%@ page import = "com.egurkha.util.DateTimeTokenizer"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "egurkha.reporter.ErAlarmHistoryHelper"%>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "java.text.*" %>
<jsp:useBean id="dd" scope="page" class="com.egurkha.monitor.EgDiagnosisBean" />
<jsp:useBean id="esmb" scope="page" class="com.egurkha.monitor.EgServiceMappingBean" />

<%
	try
	{

//Request parameter

		String showUserValue         = request.getParameter("showuser");
		String s_event               = request.getParameter("v_event");
		String subevent              = request.getParameter("subevent");
		String selectedsubzone       = request.getParameter("includeSubZone");
		String selectedCompType      = request.getParameter("compTypeList");
		String selectedCompName      = request.getParameter("compNameList");
		String s_state               = request.getParameter("state");
		String unknownState               = request.getParameter("unknownState");
		String selectedArrangeOption = request.getParameter("arrangeAlarms");
		String searchBy = request.getParameter("searchBy");
		String infosearch            = request.getParameter("infosearch");
		String compsearch            = request.getParameter("compsearch");
		String noRecPerPage          = request.getParameter("eventsPerPage");
		String printGraph            = request.getParameter("printGraph");
		String view                  = request.getParameter("er_view");
		String startdate             = request.getParameter("startdate");
		String enddate               = request.getParameter("enddate");
		String starthr               = request.getParameter("starthr");
		String endhr                 = request.getParameter("endhr");
		String startmin              = request.getParameter("startmin");
		String endmin                = request.getParameter("endmin");
		String s_user_id             = request.getParameter("userID");
		String inidate               = request.getParameter("inidate");
		String er_usertimeline       = request.getParameter("er_usertimeline");
		String er_timeline           = request.getParameter("er_timeline");
		String limitforbg            = request.getParameter("limitforbg");
		String getMaxDaysInMonth     = request.getParameter("getMaxDaysInMonth");
		String strPageNo             = request.getParameter("pageno");
		String language              = thisuser.getLanguage();
		String req_heading           = request.getParameter("heading");
		String hasVMs				 = request.getParameter("hasVMs");
		String searchByUser				 = request.getParameter("searchByUser");

		ArrayList aListColumnNames = new ArrayList();
		ArrayList userColumnNames = new ArrayList();

		boolean hasOnlyVM = false;
		hasVMs=(hasVMs!=null)?hasVMs:"false";
		if(thisuser.isOnlyVMAssigned() && !thisuser.isVMAssigned())
		{
			hasOnlyVM = true;
		}

		String [] arr_choosenComponent=request.getParameterValues("compNameList");
		List choosenComponents=new LinkedList();
		if(printGraph==null && arr_choosenComponent!=null)
		{
		choosenComponents=Arrays.asList(arr_choosenComponent);
		}
		else
		{
				if((List)session.getAttribute("component")!=null)
					choosenComponents=(List)(List)session.getAttribute("component");
		
		}
		if(req_heading==null)
		{
			req_heading = s_event;
			if (s_event == null || s_event.equals("null")) {
				req_heading = "Components";
			}
			else if(s_event != null && s_event.equalsIgnoreCase("Component"))
			{
				req_heading = s_event+"s";
			}
			if (subevent == null || subevent.equals("null")) {
				subevent = null;
			}
			if (subevent != null) {
				if(subevent.equalsIgnoreCase("Component"))
					req_heading = subevent+"s";
				else
					req_heading += " : " + subevent;
			}
		}

		String showUsers = "";
		String ShowGroupName = "";
		String currentDateFormat = "";
		String str_fontStyleDblSingl = "";
		String th_title="";
		String colForTest="";
		String colForDesc="";
		String colForSttime="",colForcname="",colForservice="";
		String th_description="";
		if(unknownState !=null && unknownState.equals("UNKNOWN"))
		{
			th_title="History of Unknowns for ";
			th_description = "reporter.common.Measure";
			colForDesc="19%";colForTest="18%";colForSttime="17%";colForservice="11%";
		}
		else
		{
			th_title="History of Alarms for ";
			th_description = "reporter.common.Description";
			colForDesc="45%";colForTest="15%";colForSttime="15%";colForservice="8%" ;
		}
//UI Skin

		String skinColor = thisuser.getReporterSkin();
		String strEncodedUserID = s_user_id;
		if(s_user_id!=null )
			strEncodedUserID = EgURLEncoder.encode(s_user_id,"UTF-8");

//Common Link URL parameters

		String param_pass = "&startdate="+startdate+"&er_usertimeline="+er_usertimeline+"&enddate="+enddate+"&inidate="+inidate+"&getMaxDaysInMonth="+getMaxDaysInMonth+"&er_timeline="+er_timeline+"&starthr="+starthr+"&endhr="+endhr+"&startmin="+startmin+"&endmin="+endmin+"&userID="+strEncodedUserID+"&uid="+strEncodedUserID+"&v_event="+s_event+"&subevent="+subevent+"&includeSubZone="+selectedsubzone+"&compTypeList="+selectedCompType+"&showuser="+showUserValue+"&heading="+req_heading+"&hasVMs="+hasVMs;


//Other than Submit page, All records displayed without Pagination

		if((printGraph!=null && printGraph.equalsIgnoreCase("yes"))|| (view != null && view.equalsIgnoreCase("PRINT")))
			noRecPerPage = "All";

//Class Initialization

		EgComponentUserMappingBean ecumb = new EgComponentUserMappingBean();
		ErAlarmHistoryHelper helper      = new ErAlarmHistoryHelper();
		com.eg.EgDbInfo db_Info          = new com.eg.EgDbInfo("manager");
		EgDateInfo egDate                = new EgDateInfo();
		EgDiscInfoHelper discInfoHelper  = new EgDiscInfoHelper();
		EgDiscInfo egDisc = new EgDiscInfo("manager");
		ErUtils erUtils                  = new ErUtils();
		ErInfo erInfo                    = new ErInfo();
		ErReqData erd                    = new ErReqData(request);
		LangInfo langinfo                = new LangInfo(thisuser.getLoginID());
		EgMappingInfo mappingInfo        = new EgMappingInfo(language);
		EgGroupInfo egGroupinfo        = new EgGroupInfo();
		IniFile egUI                     = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
		IniFile egFormat                     = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_format.ini");
		EgUserRole userRole              = thisuser.getUserRole();
		User selectedUser                = null;
		//List a_userVMs = thisuser.getOnlyVMs();
		List a_userVMs = thisuser.getAlluserDesktopVms();

//Collection Objects

		// For Service component mapping
		Hashtable resultServiceNamesForComp = (Hashtable)esmb.getServiceNamesForComponentMap();
		Hashtable resultUserCompMap         = (Hashtable)ecumb.getUserNamesForComponentMap();
		List siteNames                      = new LinkedList();
		List userCompList                   = new LinkedList();
		List a_list                         = null;

		int maxPage = 10,totalNoOfRecPerPage = 12;
		int pageNo = 1;
		int total_num_page = 1,start_index_page = 0,end_index_page = 0;
		int startPage = 1, endpage = maxPage;

		boolean hasAllComponentAccess = userRole.hasAllComponentAccess();

//Fetch - ini Entry values

		showUsers = egUI.getValue("ALARM_HISTORY","Show_Users");
		ShowGroupName = egUI.getValue("ALARM_HISTORY","Show_GroupName");
		currentDateFormat = strUserDateFormat;

//User Selected from UI. if 'User=All' then 'showUserValue=-1'

		if(showUserValue!=null)
			showUserValue = EgURLDecoder.decode(showUserValue,"UTF-8");
		showUserValue = (showUserValue==null || showUserValue.trim().length()==0 || showUserValue.equals("null") || showUserValue.equals(""))?"":showUserValue;

		if(showUserValue!=null && showUserValue.trim().length()>0 && !showUserValue.equalsIgnoreCase("-1"))
		{
			ErUserData userData = new ErUserData(showUserValue,false);
			if(userData!=null)
			{
				selectedUser = userData.usr;
				if(selectedUser==null)
					selectedUser = userData.getUser(showUserValue);
			}
		}

//User with No Full Component Access

		if(!hasAllComponentAccess)
		{
			userCompList = thisuser.getServers(false);
			List userCompList1 = thisuser.getServers(true);
			if(userCompList!=null && userCompList.size()>0)
			{
				List userCompList_host = new LinkedList();
				for(int r=0; r<userCompList.size(); r++)
				{
					String s = (String) userCompList.get(r);
					if(s!=null && !s.endsWith(":NULL"))
					{
						StringTokenizer st = new StringTokenizer(s,":");
						String ctype = st.nextToken();
						String cname = st.nextToken();
						if(ctype!=null && cname!=null && ctype.trim().length()>0 && cname.trim().length()>0)
							userCompList_host.add(ctype+":"+cname+":NULL");
					}
				}
				if(userCompList_host!=null && userCompList_host.size()>0)
					userCompList.addAll(userCompList_host);
			}
		}

//Service Names

		siteNames.addAll(thisuser.getSites());
		siteNames.addAll(thisuser.getServices());

//Pagination - Current Page Number

		if(strPageNo!=null && !strPageNo.equals("") && !strPageNo.equalsIgnoreCase("null"))
		{
			try
			{
				pageNo = Integer.parseInt(strPageNo);
			}catch(Exception e)
			{
				pageNo = 1;
			}
		}
//Session attribute
		if(session.getAttribute("NO_OF_ALARMS")!=null && !session.getAttribute("NO_OF_ALARMS").equals(""))
			a_list = (List)session.getAttribute("NO_OF_ALARMS");

//Pagination Calculation - Total Pages

		if(a_list!=null && a_list.size()>0)
		{
			int totalRecord = a_list.size();
			try {
				if(noRecPerPage.equalsIgnoreCase("All"))
					totalNoOfRecPerPage = totalRecord;
				else
					totalNoOfRecPerPage = Integer.parseInt(noRecPerPage);
			}catch(Exception e)
			{
					totalNoOfRecPerPage = 12;
			}
			total_num_page = (totalRecord/totalNoOfRecPerPage);
			if((totalRecord%totalNoOfRecPerPage)>0)
				total_num_page = total_num_page+1;
		}

		if(pageNo>total_num_page)
			pageNo = total_num_page;
		else if(pageNo<=0)
			pageNo = 1;

		int interIndex = maxPage/2;

		if(pageNo>1)
		{
			int temp = pageNo+1;
			
			for(int kk=0;kk<=interIndex;kk++)
				--temp;
			if(temp>0)
				startPage = temp;
			else
				startPage = 1;

			if(pageNo>interIndex)
				endpage = pageNo+ (maxPage - (pageNo+1 - startPage));
			else
				endpage = pageNo+(maxPage-pageNo);

			if(endpage >total_num_page)
				endpage = total_num_page;

			if((endpage-startPage)!=(maxPage-1))
				startPage = total_num_page-(maxPage-1) ;
		}

//DoubleByte - Other Language Support

		if((db_Info.doubleByteEnabled || !language.equals("en_US")) && view!=null)
			str_fontStyleDblSingl = "multi_font";
		else
			str_fontStyleDblSingl = "";
%>
<html>
	<head>
		<script language="javascript" src="../reporter/scripts/er_alarmHistory.js"></script>
		<script language="JavaScript1.2" src="../reporter/scripts/er_imagesLite.js"></script>
		<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
		<script language="JavaScript">
			var totalpages = <%=total_num_page%>;
			function checkPageNumber()
			{
				var thisform = window.document.ErAlerts;
				if (thisform.pageno.value=='')
				{
					alert('<egui:intnl text="reporter.common.Please enter Page Number"/>'+" !");
					return false;
				}
				if(totalpages<thisform.pageno.value)
				{
					alert('<egui:intnl text="reporter.common.Page Number"/> '+thisform.pageno.value+ ' <egui:intnl text="reporter.common.does not exist"/>'+"!");
					thisform.pageno.value = "";
					thisform.pageno.focus();
					return false;
				}
				if(thisform.pageno.value<=0)
				{
					alert('<egui:intnl text="reporter.common.Page Number"/> '+thisform.pageno.value+' <egui:intnl text="reporter.common.does not exist"/>'+"!");
					thisform.pageno.value = "";
					thisform.pageno.focus();
					return false;
				}
				if(isNaN(thisform.pageno.value))
				{
					alert('<egui:intnl text="reporter.common.Page Number"/> '+thisform.pageno.value+' <egui:intnl text="reporter.common. is Invalid"/>'+"!");
					thisform.pageno.value = "";
					thisform.pageno.focus();
					return false;
				}

				thisform.action = "/final/reporter/ErAlarmHistoryResults.jsp?pageno="+thisform.pageno.value+"<%=param_pass%>";
				thisform.submit();

			}

			function showPage(pageno)
			{
				var thisform = window.document.ErAlerts;
				thisform.pageno.value = pageno;
				thisform.action = "/final/reporter/ErAlarmHistoryResults.jsp?pageno="+pageno+"&eventsPerPage=<%=noRecPerPage%><%=param_pass%>";

				thisform.submit();
			}
		</script>


<!--<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />-->
	<link rel="stylesheet" type="text/css" href="../../final/styles/eGLightThemeIcons.css" />
	<link rel="stylesheet" type="text/css" href="../../final/reporter/styles/printpagestyle.css" />

<style type="text/css" media="print">
#printbt{ display:none}
</style>

<style>
@page {size : landscape; margin : 0in }
@page :footer {content: none, "Macro Home" decimal(pageno), none;}
</style>

</head>
<body marginwidth="20" marginheight="20" bgcolor="#FFFFFF">
		<input type="hidden" name="compTypeList"      value = "<%=selectedCompType%>">
<%
			if(choosenComponents!=null)
			{
				for(int j=0;choosenComponents.size()>j;j++)
				{
%>
				<input type="hidden" name="compNameList"      value = "<%=choosenComponents.get(j)%>">
<%
				}
			}
%>
			<input type="hidden" name="state"             value = "<%=s_state%>">
			<input type="hidden" name="unknownState"             value = "<%=unknownState%>">
			<input type="hidden" name="eventsPerPage"     value = "<%=noRecPerPage%>">
			<input type="hidden" name="arrangeAlarms"     value = "<%=selectedArrangeOption%>">
			<input type="hidden" name="searchBy"     value = "<%=searchBy%>">
			<input type="hidden" name="isSubmit"          value = "<%=request.getParameter("isSubmit")%>">
			<input type="hidden" name="timeselect"        value = "<%=request.getParameter("timeselect")%>">
			<input type="hidden" name="showuser"          value = "<%=showUserValue%>">
			<input type="hidden" name="v_event"           value = "<%=s_event%>">
			<input type="hidden" name="subevent"          value = "<%=subevent%>">
			<input type="hidden" name="state"             value = "<%=s_state%>">
			<input type="hidden" name="selectedsubzone"   value = "<%=selectedsubzone%>">
			<input type="hidden" name="startdate"         value = "<%=startdate%>">
			<input type="hidden" name="enddate"           value = "<%=enddate%>">
			<input type="hidden" name="starthr"           value = "<%=starthr%>">
			<input type="hidden" name="endhr"             value = "<%=endhr%>">
			<input type="hidden" name="startmin"          value = "<%=startmin%>">
			<input type="hidden" name="endmin"            value = "<%=endmin%>">
			<input type="hidden" name="s_user_id"         value = "<%=userID%>">
			<input type="hidden" name="inidate"           value = "<%=inidate%>">
			<input type="hidden" name="er_usertimeline"   value = "<%=er_usertimeline%>">
			<input type="hidden" name="er_timeline"       value = "<%=er_timeline%>">
			<input type="hidden" name="limitforbg"        value = "<%=limitforbg%>">
			<input type="hidden" name="startmin"          value = "<%=startmin%>">
			<input type="hidden" name="getMaxDaysInMonth" value = "<%=getMaxDaysInMonth%>">
			<input type="hidden" name="heading" value = "<%=req_heading%>">
			<input type="hidden" name="hasVMs" value = "<%=hasVMs%>">
			<input type="hidden" name="searchByUser" value = "<%=searchByUser%>">

		<%
				if(a_list!=null && a_list.size()>0)
				{
//Pagination Calculation - Start & End Page Index
					int tempEndIndex = totalNoOfRecPerPage;
					if(pageNo>1)
					{
						start_index_page = ((pageNo-1) * tempEndIndex );
					}

					if(a_list.size() < totalNoOfRecPerPage)
					{
						end_index_page = a_list.size();
					}
					else
					{
						end_index_page = start_index_page + tempEndIndex ;
						if(end_index_page >= a_list.size())
							end_index_page = a_list.size();
					}
					int diff = end_index_page-start_index_page;
		%>
	
					<div class="newTable">
					<!-- <div style="height:256px;position:static;overflow-y:auto"> -->
		<%
					String str_colspan = "8";
					if(hasAllComponentAccess && selectedUser==null && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
					{
						str_colspan = "9";
		%>
						<col width="40%"><col width="8%"><col width="20%">
		<%
					}
					else
					{
  		%>
						<col width="<%=colForDesc%>"><col width="<%=colForSttime%>">
		<%
					}
					if(ShowGroupName!=null && (ShowGroupName.equalsIgnoreCase("true") || ShowGroupName.equalsIgnoreCase("yes")))
					{
						str_colspan = (Integer.parseInt(str_colspan)+1)+"";
					}
		%>
						<col width="10%">
		<%
					
					if(printGraph==null && view == null)
					{
						if(str_colspan.equals("9"))
							str_colspan = "11";
						else if (str_colspan.equals("8"))
							str_colspan = "10";
						if(unknownState !=null && !unknownState.equals("UNKNOWN"))
						{
		%>
						<col width="0.5%"><col width="0.5%">
		<%
						}
						else
						{
						%>
						<col width="0.5%">
						<%
						}
					}
					if(unknownState !=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
					{
						str_colspan = (Integer.parseInt(str_colspan)+4)+"";
%>
						<col width="15%"><col width="15%"><col width="15%"><col width="15%"><col width="15%">
<%
					}
		%>
<!-- Result Table Headings -->
		<%
					if(req_heading != null)
						req_heading = com.eg.EgURLDecoder.decode(req_heading,"UTF-8");
					String heading = th_title+req_heading;
					if(printGraph==null && view == null)
					{
		%>
								<!--<td class="printTableHeader" colspan="<%=str_colspan%>" ><egui:intnl text="<%=heading%>"/></td>-->
								<div class="printOuterBoxHeader"><egui:intnl text="<%=heading%>"/></div>
		<%
					}
					else
					{
		%>
							<!--	<td class="printTableHeader"  colspan="<%=str_colspan%>" ><egui:intnl text="<%=heading%>"/></td>-->
							<div class="printOuterBoxHeader" style="float:left"><egui:intnl text="<%=heading%>"/></div>
		<%
					}
		%>
				<table align="center" width="100%" cellspacing="0" cellpadding="0">
						<col width="18"><col width="15%">
						<col width="70"><col width="<%=colForservice%>">
		<%
					if(ShowGroupName!=null && (ShowGroupName.equalsIgnoreCase("true") || ShowGroupName.equalsIgnoreCase("yes")))
					{
		%>
						<col width="15%">
		<%
					}
		
		%>
						<col width="<%=colForTest%>">
							<thead>
							<tr>
								<th align="center">
									<img src="/final/monitor/eg_images/spacer.gif" width="14" height="19">
								</th>
					


		<%
					if(printGraph==null && view == null)
					{
						aListColumnNames.add("C0");
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Component Type"));
		%>
								<th align="center"><egui:intnl text="reporter.common.Component Type"/></th>
		<%
						if(selectedCompType!=null && selectedCompType.equals("Virtual_Machine") || hasOnlyVM)
						{
							aListColumnNames.add("C1");
							userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Virtual Machine"));
		%>
								<th align="center"><egui:intnl text="reporter.common.Virtual Machine"/></th>
		<%
						}
						else if (selectedCompType!=null && selectedCompType.equals("All") && hasVMs!=null && hasVMs.equals("true"))
						{
							aListColumnNames.add("C2");
							userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Component Name / VM"));
		%>
								<th align="center"><egui:intnl text="reporter.common.Component Name / VM"/></th>
		<%
						}
						else
						{
							aListColumnNames.add("C3");
							userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Component Name"));
		%>
								<th align="center"><egui:intnl text="reporter.common.Component Name"/></th>
		<%
						}
						aListColumnNames.add("C4");
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Service")+""+mappingInfo.getTextDescription("reporter.common.(s)"));
		%>
								<th align="center"><egui:intnl text="reporter.common.Service(s)"/></th>
		<%
						if(ShowGroupName!=null && (ShowGroupName.equalsIgnoreCase("true") || ShowGroupName.equalsIgnoreCase("yes")))
						{
							aListColumnNames.add("C5");
							userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Group Name"));
%>
								<td th align="center"><egui:intnl text="reporter.common.Group Name"/></td>
<%
						}
						aListColumnNames.add("C6");
						aListColumnNames.add("C7");
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Test"));
						userColumnNames.add(mappingInfo.getTextDescription(th_description));
		%>
								<th align="center"><egui:intnl text="reporter.common.Test"/></th>

								<th align="center"><egui:intnl text="<%=th_description%>"/></th>
	<%
					}
					else
					{
		%>
								<th align="center"><egui:intnl text="reporter.common.Component Type"/></th>
		<%
						if(selectedCompType!=null && selectedCompType.equals("Virtual_Machine")|| hasOnlyVM)
						{
		%>
								<th align="center"><egui:intnl text="reporter.common.Virtual Machine"/></th>
		<%
						}
						else if (selectedCompType!=null && selectedCompType.equals("All") && hasVMs!=null && hasVMs.equals("true"))
						{
		%>
								<th align="center"><egui:intnl text="reporter.common.Component Name / VM"/></th>
		<%
						}
						else
						{
		%>
								<th align="center"><egui:intnl text="reporter.common.Component Name"/></th>
		<%
						}
		%>
								<th align="center"><egui:intnl text="reporter.common.Service"/><egui:intnl text="reporter.common.(s)"/></th>
		<%
						
						if(ShowGroupName!=null && (ShowGroupName.equalsIgnoreCase("true") || ShowGroupName.equalsIgnoreCase("yes")))
						{
		%>
								<th class="printTableHeader2" align="center"><egui:intnl text="reporter.common.Group Name"/></th>
		<%
						}
		%>
								<th align="center"><egui:intnl text="reporter.common.Test"/></th>

								<th align="center"><egui:intnl text="<%=th_description%>"/></th>
		<%
 					}

					if(hasAllComponentAccess && selectedUser==null && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
					{
						aListColumnNames.add("C8");
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.User")+""+mappingInfo.getTextDescription("reporter.common.(s)"));
		%>
								<th align="center"><egui:intnl text="reporter.common.User"/><egui:intnl text="reporter.common.(s)"/></th>
		<%
					}
						aListColumnNames.add("C9");
						aListColumnNames.add("C10");
					
					if(unknownState!=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
					{
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Alarm Start Time"));
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Alarm Duration"));
					}
					else
					{
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Start Time"));
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Duration"));
					}
					if(unknownState!=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
					{
		%>
								<th align="center"><egui:intnl text="reporter.common.Alarm Start Time"/></th>
								<th align="center"><egui:intnl text="reporter.common.Alarm Duration"/></th>
		<%
					}
					else
					{
		%>
								<th align="center"><egui:intnl text="reporter.common.Start Time"/></th>
								<th align="center"><egui:intnl text="reporter.common.Duration"/></th>
		<%	
					}
					if(printGraph==null && view == null && unknownState !=null && !unknownState.equals("UNKNOWN"))
					{
		%>
								<th align="center"><egui:intnl text=" "/></th>
								<th align="center"><egui:intnl text=" "/></th>
		<%
					}
					if(printGraph==null && view == null && unknownState !=null && unknownState.equals("UNKNOWN"))
					{
		%>
								<th align="center"><egui:intnl text=" "/></th>
		<%
					}
					if(unknownState !=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
					{
						aListColumnNames.add("C11");
						aListColumnNames.add("C12");
						aListColumnNames.add("C13");
						aListColumnNames.add("C14");
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Status"));
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Response time"));
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Acknowledged by"));
						userColumnNames.add(mappingInfo.getTextDescription("reporter.common.Time"));
					%>
						<th align="center"><egui:intnl text="reporter.common.Status"/></th>
						<th align="center"><egui:intnl text="reporter.common.Response time"/></th>
						<th align="center"><egui:intnl text="reporter.common.Acknowledged by"/></th>
						<th align="center"><egui:intnl text="reporter.common.Time"/></th>

					<%
					}
		%>
							</tr>
							</thead>
							 <tbody>
		<%
//Encoding
					er_timeline       = (er_timeline==null)?er_timeline:EgURLEncoder.encode(er_timeline,"UTF-8");
					er_usertimeline   = (er_usertimeline==null)?er_usertimeline:EgURLEncoder.encode(er_usertimeline,"UTF-8");
					limitforbg        = (limitforbg==null)?limitforbg:EgURLEncoder.encode(limitforbg,"UTF-8");
					inidate           = (inidate==null)?inidate:EgURLEncoder.encode(inidate,"UTF-8");
					startdate         = (startdate==null)?startdate:EgURLEncoder.encode(startdate,"UTF-8");
					enddate           = (enddate==null)?enddate:EgURLEncoder.encode(enddate,"UTF-8");
					starthr           = (starthr==null)?starthr:EgURLEncoder.encode(starthr,"UTF-8");
					endhr             = (endhr==null)?endhr:EgURLEncoder.encode(endhr,"UTF-8");
					startmin          = (startmin==null)?startmin:EgURLEncoder.encode(startmin,"UTF-8");
					endmin            = (endmin==null)?endmin:EgURLEncoder.encode(endmin,"UTF-8");
					s_user_id         = (s_user_id==null)?s_user_id:EgURLEncoder.encode(s_user_id,"UTF-8");
					getMaxDaysInMonth = (getMaxDaysInMonth==null)?getMaxDaysInMonth:EgURLEncoder.encode(getMaxDaysInMonth,"UTF-8");

					if(choosenComponents!=null)
					{
						List temp_choosenComponents=new LinkedList(choosenComponents);
						choosenComponents=new LinkedList();
						
						//replacing special character
						for(int n=0;temp_choosenComponents.size()>n;n++)
						{
						String tmpcomp=(String)temp_choosenComponents.get(n);
						if(tmpcomp.indexOf("|plus|")>-1)
						{
						tmpcomp=StringUtils.replace(tmpcomp,"|plus|","+");
						}
						if(tmpcomp.indexOf("|amp|")>-1)
						{
							tmpcomp=StringUtils.replace(tmpcomp,"|amp|","&");
						}
						if (tmpcomp.indexOf("|pct|")>-1)
						{
							tmpcomp=StringUtils.replace(tmpcomp,"|pct|","%");
						}
						if (tmpcomp.indexOf("|hash|")>-1)
						{
							tmpcomp=StringUtils.replace(tmpcomp,"|hash|","#");
						}
						choosenComponents.add(tmpcomp);
						}
						//end
					}

					
					
					for(int a=start_index_page;a<end_index_page;a++)
					{
//session values
						String[] check = (String[])a_list.get(a);
						/*for(int i=0;i<check.length;i++)
							out.println("<BR> i = "+i+" check--- "+check[i]);*/
						String site = check[1];
						String component = check[2];
						String comp_with_port = component;

						String compTypeName = check[3];
						String compotype = check[3];
						String strType = compotype;
						String strTempCompType=strType;

						String desc = check[4];
						String tests = check[5];
						String measure= check[6];

 						String svrty="";
						String s_time="";
						String	e_time="";
						long timeDiff =0l;
						String str_compType = "";
						String str_service = "";
						String display_Str           = "";
						String ack_status = "Yet to be acknowledged";
						String ack_time = "-";
						String ack_user = "-";
						long responseTime = 0;
						boolean size_check = false;
						if(desc!=null && desc.indexOf("###")>-1)
						{
							desc=desc.substring(0,desc.indexOf("###"));
						}
						if(unknownState!=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
						{
							svrty = check[8];
							s_time = (String)check[9];
 							timeDiff = Long.parseLong((String)check[10]);
							if((String)check[12]!=null)
							{
								ack_status = (String)check[12];
								if(ack_status.equalsIgnoreCase("Acknowledgement"))
									ack_status = "Acknowledged";
								if(ack_status.equalsIgnoreCase("Unacknowledgement"))
									ack_status = "Unacknowledged";
							}
							if((String)check[13]!=null)
								ack_time = (String)check[13];
							if((String)check[14]!=null)
								ack_user = (String)check[14];
							if((String)check[15]!=null)
								responseTime =Long.parseLong((String)check[15]);
						}
						else if(unknownState!=null && !unknownState.equals("UNKNOWN"))
						{
 							svrty = check[8];
							s_time = (String)check[9];
 							timeDiff = Long.parseLong((String)check[10]);
 							if(check!=null && check.length>12)
							{
								str_compType = check[11];
								str_service = check[12];
  								size_check = true;
							}
						}
						else
						{
 							svrty = "UNKNOWN";
							s_time = (String)check[8];
  							timeDiff = Long.parseLong((String)check[9]);
 								if(check!=null && check.length>10)
								{
									str_compType = check[10];
									str_service = check[11];
									size_check = true;
								}
						}
						String parameter             = "";
						String operation_App_Url     = "";
						String executive_Service_Url = "";
						String service               = "";
						String comp_info             = "";
						String duration              = "Current";
						String s_sttime              = s_time;
						String graph_Url             = "";
						String comp                  = null;
						String tmp_tests             = tests;
						String display_measure       = measure;
						String displayUsers          = "",
								displayUsersInTitle  = "";
						boolean defaultLoop=true;
						String select_vm="";
						String infoForGraph="";
						String modifiedDescForVM="";
						String responseTimeStr = "-";
						if(hasVMs!=null && hasVMs.equals("true"))
						{
							if(selectedCompType!=null && (selectedCompType.equals("All") || selectedCompType.equals("Virtual_Machine")))
							{
								boolean vmSelected=false;
								for(int ii=0;choosenComponents.size()>ii;ii++)
									if(a_userVMs.contains(choosenComponents.get(ii))){
										vmSelected=true;
								}
								if(vmSelected)
								{
									modifiedDescForVM=desc;
									if(modifiedDescForVM.indexOf("{")>-1 && modifiedDescForVM.indexOf("}")>-1)
									{
										String vm_info=modifiedDescForVM.substring(modifiedDescForVM.indexOf("{")+1,modifiedDescForVM.indexOf("}"));
										infoForGraph=vm_info;
										if(vm_info.indexOf(":")>-1)
											vm_info=vm_info.substring(0,vm_info.indexOf(":"));
										if(choosenComponents.contains(vm_info))
										{
											defaultLoop=false;
											select_vm=vm_info;
											comp_info="VM";
											if(modifiedDescForVM.indexOf(vm_info+":")>-1)
												modifiedDescForVM=StringUtils.replace(modifiedDescForVM,vm_info+":","");
											else
												modifiedDescForVM=StringUtils.replace(modifiedDescForVM,vm_info,"");
											if(modifiedDescForVM.endsWith("{}"))
												modifiedDescForVM=modifiedDescForVM.substring(0,modifiedDescForVM.indexOf("{"));
											if(service.equalsIgnoreCase("NULL") || service.equalsIgnoreCase("NONE"))
											{
												service="-";
											}
											if(display_Str.equals("NULL") || display_Str.equals(""))
												display_Str = "-";
										}
									}
								}
								else
								{
									defaultLoop=true;
								}
							}
							else
							{
								defaultLoop=true;
							}
						}
						if(defaultLoop)
						{
							if(!component.toUpperCase().endsWith(":NULL"))
							{
								component=component;
							}
							else if(component.toUpperCase().endsWith(":NULL"))
							{
								component=component.substring(0,component.indexOf(":"));
							}

							if(service.equalsIgnoreCase("NULL") || service.equalsIgnoreCase("NONE"))
							{
								service="-";
							}
	//if 'Sort by!=Start Time' then 'size_check=true'.
							if(!size_check)
							{
								//to get real type for hostsystem.

								String port = comp_with_port.substring(comp_with_port.indexOf(":")+1);
								String str_comp = comp_with_port.substring(0,comp_with_port.indexOf(":"));
								if(port.equalsIgnoreCase("NULL") && str_comp!=null && !str_comp.equals(""))
								{
									if(!"All".equalsIgnoreCase(selectedCompType))
									{
										strTempCompType=selectedCompType;
									}
									else
									{
										List list = egDisc.getServerTypesForNick(str_comp);
										if(list.size()>0){
											strTempCompType = list.get(0).toString();
										}
									}
								}

								comp_info = discInfoHelper.getCompTypeForHostSystem(strType,comp_with_port,tests,hasAllComponentAccess,mappingInfo,userCompList);

								display_Str = esmb.getServiceNamesForComponent(resultServiceNamesForComp,strType,comp_with_port,service,siteNames,hasAllComponentAccess);
							}
							else
							{
								comp_info = str_compType;
								display_Str = str_service;
							}

						if(display_Str.equals("NULL") || display_Str.equals(""))
							display_Str = "-";
						else
							display_Str = display_Str.trim();

						if(desc.indexOf("{")>-1 && desc.indexOf("}")>-1)
						{
							infoForGraph=desc.substring(desc.indexOf("{")+1,desc.indexOf("}"));
						}

						}

	 					if(searchByUser !=null && !searchByUser.equals("") && searchBy.trim().equalsIgnoreCase("Service"))
						{
							if(display_Str.indexOf(searchByUser)==-1)
								continue;
						}

						s_sttime = DateUtil.changeDateFormat(s_sttime,"MM/dd/yy HH:mm","MM/dd/yyyy HH:mm");
						s_sttime = s_sttime.substring(0,16);

						String s_starttime = s_sttime.substring(0,10);
						String sthrmin = s_sttime.substring(10,16);
						s_sttime = DateUtil.changeDateFormat(s_starttime,"MM/dd/yy",currentDateFormat)+" "+sthrmin;
						EgTimeZoneConverter converterStart = new EgTimeZoneConverter(s_sttime,thisuser);
						if(ack_time!=null && !ack_time.equals("-"))
						{
							Timestamp timeStmp = Timestamp.valueOf(ack_time);
							long ack_timeVal = timeStmp.getTime();
							java.util.Date ack_timeDate = new  java.util.Date(ack_timeVal);
							SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" HH:mm:ss");
							ack_time = formatter.format(ack_timeDate);
						}
						if(timeDiff>0)
							duration = DateTimeTokenizer.getTimeDifference(timeDiff);
						if(responseTime>0)
							responseTimeStr = DateTimeTokenizer.getTimeDifference(responseTime);

 						String disp_measure = mappingInfo.getMeasureDescription(tests,measure);
						tests = mappingInfo.getTestDescription(tests);
						//tests = StringUtils.split(tests,14);
						//component = StringUtils.split(component,20);
						compotype = mappingInfo.getComponentTypeDescription(compotype);
						//compotype = StringUtils.split(compotype,20);

						if(hasAllComponentAccess && selectedUser==null && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
						{
							List disp_user_list = null;
							if(printGraph==null && view == null)
							{
								disp_user_list = helper.getUserAssociatedWithSpecifiedComp(resultUserCompMap,strType,comp_with_port,"submit");
							}
							else
							{
								disp_user_list = helper.getUserAssociatedWithSpecifiedComp(resultUserCompMap,strType,comp_with_port,"print");
							}
							if(disp_user_list!=null && disp_user_list.size()>0)
							{
								displayUsers = (String)disp_user_list.get(0);
								if(displayUsers!=null && !displayUsers.equals("-"))
									displayUsersInTitle = (String)disp_user_list.get(1);
							}
						}

//Setting Links URL for Submit Results.
//This loop is not executed other than Submit page.
//Not Executed for Print,Mail,Save,Pdf,Schedule.
						if(printGraph==null && view == null)
						{
//Corresponding Component Type of Host System
							if(compTypeName!=null && compTypeName.equalsIgnoreCase("Host_system") && comp_with_port!=null && !comp_with_port.equals(""))
							{
								String port = comp_with_port.substring(comp_with_port.indexOf(":")+1);
								String str_comp = comp_with_port.substring(0,comp_with_port.indexOf(":"));
								if(port.equalsIgnoreCase("NULL") && str_comp!=null && !str_comp.equals(""))
								{
									List list = egDisc.getServerTypesForNick(str_comp);
									if(list.size()>0){
										compTypeName = list.get(0).toString();
									}
								}
							}
							if(comp_with_port!=null && compTypeName!=null)
								comp = comp_with_port+":"+compTypeName;
//Encoding
							String s_compTypeName = (compTypeName==null)?compTypeName:EgURLEncoder.encode(compTypeName,"UTF-8");
							String s_comp         = (comp==null)?comp:EgURLEncoder.encode(comp,"UTF-8");
							String str_analysis = request.getParameter("eventfor");
//to select the service link which is get selected
							String display_service = display_Str;
							if(display_service!=null && !display_service.equals("-") && display_service.indexOf(",")>-1)
							{
								StringTokenizer str = new StringTokenizer(display_service,",");
								if(str_analysis!=null && str_analysis.equalsIgnoreCase("Service"))
								{
									String str_selectedService = request.getParameter("event_select");
									while(str.hasMoreTokens())
									{
										String services = str.nextToken();
										 if(str_selectedService!=null && services.equalsIgnoreCase(str_selectedService))
											display_service = services;
									}
								}else
								{
									if(str.hasMoreTokens())
									{
										display_service = str.nextToken();
									}
								}
							}

							String s_display_Str  = (display_Str==null)?display_Str:EgURLEncoder.encode(display_service,"UTF-8");
//Setting Links URL
							parameter = "&startdate="+startdate+"&enddate="+enddate+"&er_timeline="+er_timeline+"&isSubmit=true&enableBack=true&backServletName=/servlet/com.eg.ErAlarmHistoryC?&er_mode=3D&";

							String tmp = "";
							if(s_event!=null && s_event.equalsIgnoreCase("Component"))
								tmp = "Components";
							else
								tmp = s_event;
							
							if(defaultLoop)
							{
								operation_App_Url = "../servlet/com.eg.ErRepoLiteC?er_reportType=operation&er_rtype=Application&er_bgreportfrom=Operation_Application&trendenable=true&er_gtype=Measure&reporttype=operation&us_id="+strEncodedUserID+"&er_comptype="+s_compTypeName+"&starthr="+starthr+"&endhr="+endhr+"&startmin="+startmin+"&endmin="+endmin+"&userID="+strEncodedUserID+"&uid="+strEncodedUserID+"&er_component="+comp+"&fromFavSch=true&er_trenddata=No&er_option="+tmp+"&er_subzone="+selectedsubzone+"&er_group="+subevent+parameter;
							}
							else
							{
								
						
								operation_App_Url="../servlet/com.eg.ErEsxVMServerReportC?er_usertimeline=-1&ervm_disp=No&trendenable=true&er_reportgenration=foreground&forwardto=ErEsxGuestVMReport&er_trgttype=Virtual_Machine_Details&er_check=Virtualization&vmStrData=&er_mode=3D&er_ViewName=ErEsxGuestVMReport.jsp&er_type=Yes&fromSchedule=null&schedule_id=null&isSubmit=true&isVmReport=null&er_bgreportfrom=Virtualization_VM_Virtual_Resource&savereport=save&er_trenddata=No&detailtime=-1&servletName=com.eg.ErEsxVMServerReportC&er_timeline="+er_timeline+"&er_measure=All&er_rtype=Virtualization&reqfrom=vmGuest&enableBack=true&backServletName=/servlet/com.eg.ErAlarmHistoryC?&minto=00&minfrom=00&timeto=24&timefrom=00";
								operation_App_Url+="&userID="+strEncodedUserID+"&er_comptype="+s_compTypeName+"&er_excwe=No&er_excweekend=No&er_component="+s_comp+"&select_vm="+EgURLEncoder.encode(select_vm,"UTF-8");
								operation_App_Url+="&er_stdate_h="+startdate+"&er_enddate_h=" +enddate+ "&er_sthr_h=" + starthr + "&er_endhr_h=" + endhr + "&startmin="+ startmin + "&endmin=" + endmin;
								operation_App_Url+="&startdate=" +startdate+ "&enddate=" + enddate+ "&starthr=" + starthr + "&endhr=" + endhr;
								operation_App_Url+="&st_date="+startdate+"&en_date="+enddate+"&isOnlyVMAssigned=true";
							}
//out.println("operation_App_Url = "+operation_App_Url);

							executive_Service_Url = "../servlet/com.eg.ErControllerServlet?er_trenddata=Yes&reporttype=executive&er_selection="+s_display_Str+"&font=CODE2000&forwardto=ErMacro&starthr=0&eruserid="+strEncodedUserID+"&er_trgttype=Service&er_ViewName=ErMacro.jsp&servletName=com.eg.ErControllerServlet&endmin=&er_view=GRAPH&endhr=0&startmin=&er_rtype=Macro&er_bgreportfrom=Executive_Service&"+parameter;

							measure = db_Info.getColumnForMeasure(tmp_tests,measure);

							graph_Url = "option=graph&er_trgttype=Server+Report+&er_rtype=Snapshot&er_gtype=intrasnap&startdate="+startdate+"&enddate="+enddate+"&starthr="+starthr+"&endhr="+endhr+"&startmin="+startmin+"&endmin="+endmin+"&er_timeline="+er_timeline+"&er_test="+tmp_tests+"&er_disp_meas="+display_measure+"&er_measure="+measure+"&er_component="+s_comp+"&er_sid=&er_site=&inidate="+inidate+"&&userID="+strEncodedUserID+"&er_trenddata=No&drilldownenabled=Yes";
							graph_Url+="&er_info_list="+EgURLEncoder.encode(infoForGraph,"UTF-8");
							
							if(!defaultLoop)
								graph_Url+="&select_vm="+select_vm+"&isOnlyVMAssigned=true";
							else
								graph_Url+="&isFromAlarmHistory=true";

						}
		%>				  
							<tr class="newimg">
								<td nowrap="nowrap" style="padding:1px 0px 1px 1px;line-height:0px" align="center" TITLE='<%=mappingInfo.getLabelDescription(svrty)%>'><img src="/final/images/Light/state20_<%=svrty%>.png" border="0">
								</td>
		<%
						if(printGraph==null && view == null)
						{
//Main Page Results part
							int displayLength=18;
							/*if(component!=null && component.length()>20)
							{
								component = component.substring(0,18)+"...";
							}*/
		%>
<!-- Component Type -->
								<td align="left" wrap>
									<%=comp_info%>
								</td>
<!-- Component -->
					<%
						String strDispComponentTemp = component;
						if(!defaultLoop)
							strDispComponentTemp=select_vm;
					%>
								<td align="left" wrap>
									<a target="_parent" href="<%=operation_App_Url%>" class="eg_rep_monlink" title="<%=strDispComponentTemp%>">
										<egui:display name="<%=strDispComponentTemp%>" length="<%=Integer.toString(displayLength)%>"/>
									</a>
								</td>
<!-- Service -->
								<td align="center" wrap>
		<%
							if(display_Str!=null && !display_Str.equals("-"))
							{
		%>
									<a target="_parent" href="<%=executive_Service_Url%>" class="eg_rep_monlink" title="<%=display_Str%>">
										<egui:display name="<%=display_Str%>" length="<%=Integer.toString(displayLength-2)%>"/>
									</a>
		<%
							}
							else
							{
		%>
									<%=display_Str%>
		<%
							}
		%>
								</td>
<%
							if(ShowGroupName!=null && (ShowGroupName.equalsIgnoreCase("true") || ShowGroupName.equalsIgnoreCase("yes")))
							{
								String groupNameValComp = component;
								if(groupNameValComp!=null && groupNameValComp.indexOf(":")==-1)
								{
									ArrayList aListPort = egDisc.getPort(strTempCompType,groupNameValComp);
									if(aListPort!=null && aListPort.size()>0)
									{
										groupNameValComp = groupNameValComp+":"+aListPort.get(0);
									}
									else
									{
										groupNameValComp = groupNameValComp+":NULL";
									}
								}
								groupNameValComp = strTempCompType+":"+groupNameValComp;
								String ShowGroupNameVal = egGroupinfo.getGroupNameForComponent(groupNameValComp);
								if(ShowGroupNameVal==null || ShowGroupNameVal.length()==0)
								{
									ShowGroupNameVal = "-";
								}
%>
								<td align="left" wrap>
									<%=ShowGroupNameVal%>
								</td>
<%
							}
%>
<!-- Tests -->
								<td align="left" wrap>
									<%=tests%>
								</td>
<!-- Description -->
		<%
			String DispDesc = desc;
			if(!defaultLoop)
				DispDesc=modifiedDescForVM;
			if(!unknownState.equals("UNKNOWN"))
			{
		%>
								<td id="tdborder" wrap>
									<%=DispDesc%>
								</td>

<!-- User Added -->
		<%
			}
			else
			{
			%>
								<td align="left" wrap>
									<%=disp_measure%>
								</td>
			<%
			}
							if(hasAllComponentAccess && selectedUser==null && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
							{
		%>
								<td align="left" wrap title="<%=displayUsersInTitle%>">
									<%=displayUsers%>
								</td>
		<%
							}
		%>
<!-- Start Time -->
								<td align="center" nowrap>
									<%=converterStart.getDateTime()%>
								</td>
<!-- Duration -->
								<td align="center" nowrap>
									<%=duration%>
								</td>
	<%
					if(unknownState!=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
					{
	%>
						<td align="center" nowrap><%=ack_status%></td>
						<td align="center" nowrap><%=responseTimeStr%></td>
						<td align="center" nowrap><%=ack_user%></td>
						<td align="center" nowrap><%=ack_time%></td>
	<%
					}
	%>
<!-- Graph Image & Link -->
								<td align="center" nowrap="nowrap">
									<a id="mouse" onClick="javascript:openInNewWin('<%=graph_Url%>')" >
										<img src="/final/monitor/eg_images/graph-o.gif" alt="<egui:intnl text='monitor.common.GRAPH'/>" border="0" align="absBottom" title="<egui:intnl text='monitor.common.GRAPH'/>"/>
									</a>
								</td>
<!-- Detailed Description(DD) -->
		<%
							egurkha.TestBean testBean = new egurkha.TestBean();
							com.eg.EgSpecsInfo specsInfo = new com.eg.EgSpecsInfo("manager");
							com.eg.EgAgentInfo agentInfo = new com.eg.EgAgentInfo("manager");

							boolean ddEnabled = com.eg.EgMemInfo.ddEnabled;

							String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
							IniFile fmtUI = new IniFile(s_iniFile_dir + "eg_format.ini");
							//String ddEnableForCompType = fmtUI.getValue("Tests_For_DDWithoutInfos", tmp_tests + ":" + display_measure);
							String ddEnableForCompType = fmtUI.getValue("Default_DDEnabled", compTypeName);
							boolean isddEnabled = ddEnableForCompType.equalsIgnoreCase("yes") ? true : false;

							String tmp_comp = "";


							boolean isAgentlessServer = agentInfo.isAgentlessServer(component, compTypeName, true);
							boolean isTestExternal = specsInfo.isTestExternal(tmp_tests.trim());
							boolean isDdEnableTestMeas = testBean.isDdEnabled(tmp_tests.trim(),display_measure.trim());

							String ddEnable ="No";
							if (ddEnabled && isDdEnableTestMeas && (!isAgentlessServer || isTestExternal || isddEnabled))
							{
								ddEnable = "Yes";
							}

							String port = "";
							if(comp_with_port!=null && comp_with_port.indexOf(":")>-1)
								port = comp_with_port.substring(comp_with_port.indexOf(":")+1);

							String info = "";
							if(desc!=null && desc.indexOf("{")>-1)
								info = "*"+desc.substring(desc.indexOf("{")+1,desc.indexOf("}"));
							else
								info = "*";

							EgTablesInfo tablesInfo = new EgTablesInfo(EgConstants.MANAGER);
							String layer = tablesInfo.getRelevantLayer(compTypeName, tmp_tests.trim(), display_measure.trim());

							if(component!=null && component.indexOf(":")>-1)
							{
								component=component.substring(0,component.indexOf(":"));
							}
							if(port!=null && port.indexOf(":")>-1)
							{
								info=port.substring(port.indexOf(":")+1)+info;
								port=port.substring(0,port.indexOf(":"));
							}
							
							/*String dd_url = "/final/monitor/EventsGraph.jsp?pageToShow=diagnosis&url=EgDiagnosis.jsp?site="+site+"&host="+com.eg.EgURLEncoder.encode(component,"UTF-8")+"&port="+port+"&test="+tmp_tests+"&info="+info+"&from=0&measure="+display_measure+"&firsttime=true&comeFrom=Reporter&newWindow=true&flag=1&starttime="+startdate+"&endtime="+enddate+"&starthr="+starthr+"&endhr="+endhr+"&startmin="+startmin+"&timeline="+er_timeline+"&endmin="+endmin+"&msmt_host="+com.eg.EgURLEncoder.encode(check[7],"UTF-8")+"&inidate="+inidate+"&layer="+layer+"&comptype="+compTypeName;*/
							
							
						String dd_url = "/final/monitor/componentMeasureTabSet.jsp?type="+EgURLEncoder.encode(compTypeName,"UTF-8")+"&site="+site+"&host="+EgURLEncoder.encode(component,"UTF-8")+"&port="+port+"&info="+EgURLEncoder.encode(info,"UTF-8")+"&state=&messy="+display_measure+"&msmt_host="+EgURLEncoder.encode(check[7],"UTF-8")+"&userID="+EgURLEncoder.encode(urs,"UTF-8")+"&test="+ tmp_tests+"&comptype="+compTypeName+"&measureDisp="+display_measure+"&from=measurespage&dd=yes&clicked=dd&newWindow=true&fromReporterHis=true&popup=true&fromPage=eveHist";
							
							if(!defaultLoop)//murali
								dd_url+="&isVM=true";
							StringBuffer key = new StringBuffer(32);
							key.append(tmp_tests.trim());
							key.append(":");
							key.append(display_measure.trim());
							String tm = key.toString();
							String disInfo = egFormat.getValue("Tests_For_DDWithoutInfos",tm);
							if(disInfo!=null && disInfo.equalsIgnoreCase("Yes"))
							{
								info = "+";
							}
							else
							{
								if(info!=null)
								{
									if(info.indexOf("+")>-1)
									{
										info=com.egurkha.util.StringUtils.replace(info,"+","|plus|");
									}
									if(info.indexOf("&")>-1)
									{
										info=com.egurkha.util.StringUtils.replace(info,"&","|amp|");
									}
									if(info.indexOf("%")>-1)
									{
										info=com.egurkha.util.StringUtils.replace(info,"%","|pct|");
									}
									if(info.indexOf("#")>-1)
									{
										info=com.egurkha.util.StringUtils.replace(info,"#","|hash|");
									}
									if(info.indexOf("*")>-1)
									{
										info=com.egurkha.util.StringUtils.replace(info,"*","+");
									}
								}
							}
							if(unknownState!=null &&  !unknownState.equals("UNKNOWN"))
							{
								if(ddEnable!=null && !ddEnable.equals("") && ddEnable.equalsIgnoreCase("Yes"))
								{
									if(dd.ShowDDData(site,component,tmp_tests.trim(),display_measure.trim(),info,check[7]))
									{
		%>
								<td align="center">
									<a href='javascript:void(0)' onClick='javascript:openDDWin("<%=dd_url%>");'>
										<img src="../reporter/images/diagnosis.gif" hspace="0" vspace="0" border="0">
									</a>
								</td>
		<%
								}
								else
								{
		%>
								<td align="center" wrap>
									<img src='/final/monitor/eg_images/spacer.gif' width='18'>
								</td>

		<%
								}
							}
							else
							{
		%>
								<td align="center" wrap>
									<img src='/final/monitor/eg_images/spacer.gif' width='18'>
								</td>

		<%
							}
						}
					}
					else
					{
//Results part for print,Save,...
		%>
<!-- Component Type -->
								<td align="left" wrap>
									<%=comp_info%>
								</td>
<!-- Component -->
					<%
						String strDispComponentTemp = component;
						if(!defaultLoop)
							strDispComponentTemp=select_vm;
					%>

								<td align="left" wrap>
									<%=strDispComponentTemp%>
								</td>
<!-- Service -->
								<td align="center" wrap>
									<div style="width:100px;word-wrap: break-word; overflow-x:auto;"><%=display_Str%></div>
								</td>
<%
							if(ShowGroupName!=null && (ShowGroupName.equalsIgnoreCase("true") || ShowGroupName.equalsIgnoreCase("yes")))
							{
								String groupNameValComp = component;
								if(groupNameValComp!=null && groupNameValComp.indexOf(":")==-1)
								{
									ArrayList aListPort = egDisc.getPort(strTempCompType,groupNameValComp);
									if(aListPort!=null && aListPort.size()>0)
									{
										groupNameValComp = groupNameValComp+":"+aListPort.get(0);
									}
									else
									{
										groupNameValComp = groupNameValComp+":NULL";
									}
								}
								groupNameValComp = strTempCompType+":"+groupNameValComp;
								String ShowGroupNameVal = egGroupinfo.getGroupNameForComponent(groupNameValComp);
								if(ShowGroupNameVal==null || ShowGroupNameVal.length()==0)
								{
									ShowGroupNameVal = "-";
								}
%>
								<td align="center" wrap>
									<div style="width:100px;word-wrap: break-word; overflow-x:auto;"><%=ShowGroupNameVal%></div>
								</td>
<%
							}
%>
<!-- Tests -->
								<td align="left" wrap>
									<%=tests%>
								</td>
<!-- Description -->
		<%
			String DispDesc = desc;
			if(!defaultLoop)
				DispDesc=modifiedDescForVM;
			if(unknownState !=null && !unknownState.equals("UNKNOWN"))
			{
		%>
								<td align="left" wrap>
									<div style="width:280px;word-wrap:break-word;overflow-x:auto;"><%=DispDesc%></div>
								</td>
<!-- User Added -->
		<%
			}
			else
			{
		%>
								<td align="left" wrap>
									<%=disp_measure%>
								</td>
		<%
			}
							if(hasAllComponentAccess && selectedUser==null && showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
							{
		%>
								<td align="center" wrap title="<%=displayUsersInTitle%>">
									<%=displayUsers%>
								</td>
		<%
							}
		%>
<!-- Start Time -->
								<td align="center" nowrap>
									<div style="width:110px;word-wrap:break-word;overflow-x:auto;"><%=converterStart.getDateTime()%></div>
								</td>
<!-- Duration -->
								<td align="center" nowrap>
									<%=duration%>
								</td>
		<%
					if(unknownState!=null && unknownState.equalsIgnoreCase("ACKNOWLEDGEMENT"))
					{
	%>
						<td align="center" nowrap><%=ack_status%></td>
						<td align="center" nowrap><%=responseTimeStr%></td>
						<td align="center" nowrap><%=ack_user%></td>
						<td align="center" nowrap><%=ack_time%></td>
	<%
						}
				}
		%>
							</tr>	
		<%
					}

					String startDate = startdate + " " + starthr + ":" + startmin;
					String endDate = enddate + " " + endhr + ":" + endmin;

					HashMap tmp_map = new HashMap();
					tmp_map.put("startDate",startDate);
					tmp_map.put("endDate",endDate);
					tmp_map.put("showUsers",showUsers);
					tmp_map.put("selectedUser",selectedUser);
					tmp_map.put("hasAllComponentAccess",new Boolean(hasAllComponentAccess));
					tmp_map.put("mappingInfo",mappingInfo);
					tmp_map.put("currentDateFormat",currentDateFormat);
					tmp_map.put("siteNames",siteNames);
					tmp_map.put("userCompList",userCompList);
					tmp_map.put("resultUserCompMap",resultUserCompMap);
					tmp_map.put("hasVMs",hasVMs);
					tmp_map.put("selectedCompType",selectedCompType);
					tmp_map.put("a_userVMs",a_userVMs);
					tmp_map.put("unknownState",unknownState);
					tmp_map.put("searchByUser",searchByUser);
					tmp_map.put("searchBy",searchBy);
					tmp_map.put("resultServiceNamesForComp",resultServiceNamesForComp);
					tmp_map.put("choosenComponents",choosenComponents);
					tmp_map.put("aListColumnNames",aListColumnNames);
					tmp_map.put("userColumnNames",userColumnNames);
					tmp_map.put("a_list",a_list);
					tmp_map.put("MainTitle",(String)session.getAttribute("MainTitle"));
					tmp_map.put("SubTitle",(String)session.getAttribute("SubTitle"));
					tmp_map.put("reporttype",(String)session.getAttribute("reporttype"));
					tmp_map.put("subReportType",(String)session.getAttribute("subReportType"));
					tmp_map.put("thisLanguage",language);
					session.setAttribute("tmp_map",tmp_map);

		%>
							</tbody>
						</table>

<!-- Pagination Design-->
				
		<%
					if(total_num_page>1)
					{
		%>
						<table valign="top" border="0" cellspacing="0" cellpadding="0" width="100%" >
							<tr>
								<td id="blankspace" height="10" >&nbsp;</td>
							</tr>
							<tr>
								<td valign="top" align="right" class="cellbglight" style="width:200px">
									<b>
										<egui:intnl text="reporter.common.Go to Page"/> # :
									</b>&nbsp;
									<input type="text" name="pageno" style="width: 50px; text-align: center;">
								</td>
								<td valign="top" align="left" class="cellbglight" style="width:25px;">
									<img src="../reporter/images/<%=skinColor%>/arrow_1.gif" name="gotopage" onClick="return checkPageNumber();" alt="<egui:intnl text='reporter.common.GO'/>" id="eg_input" class="mouse">
								</td>
								<td valign="top" class="cellbglight" >
									<table valign="top" border="0" width="100%" cellpadding="0px" cellspacing="0px">
										<tr>
											<td valign="top" colspan="3" width="100%" height="20px" valign="bottom" ID="cellbglight" >&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		<%
						if(pageNo>1)
						{
		%>
												<img src="/final/reporter/images/home.gif" class="mouse" border="0" alt='<egui:intnl text="reporter.common.First"/>' title='<egui:intnl text="reporter.common.First"/>' onClick="javascript:showPage(1)"> 
												&nbsp;&nbsp;
												<img src="/final/reporter/images/prev.gif" class="mouse" border="0" alt='<egui:intnl text="reporter.common.Previous"/>' title='<egui:intnl text="reporter.common.Previous"/>' onClick="javascript:showPage(<%=(pageNo-1)%>)">&nbsp;
		<%
						}
						else
						{
		%>
												&nbsp;
		<%
						}
						for(int i=startPage;i<=endpage;i++)
						{
							if((i>total_num_page) ||(i<=0))
							{
								continue;
							}
							else
							if(pageNo==i)
							{
		%>
												<b id="page_no" style="border-bottom-width:1px;" class="eg_75" ><%=i%></b>
		<%
							}
							else
							{
		%>
												<b class="eg_75" ><a href="/final/reporter/ErAlarmHistoryResults.jsp?pageno=<%=i%>&eventsPerPage=<%=noRecPerPage%>&arrangeAlarms=<%=selectedArrangeOption%><%=param_pass%>&unknownState=<%=unknownState%>&searchBy=<%=searchBy%>&searchByUser=<%=searchByUser%>" class="alarmlink1" style="padding:2px"><%=i%></a></b>
		<%
							}
						}
		%>
												&nbsp;
		<%
						if(pageNo!=total_num_page)
						{
							try
							{
		%>
												<img src="/final/reporter/images/next2.gif" class="mouse" border="0" alt='<egui:intnl text="reporter.common.Next"/>' title='<egui:intnl text="reporter.common.Next"/>' onClick="javascript:showPage(<%=(pageNo+1)%>)" >
												&nbsp;&nbsp;
												<img src="/final/reporter/images/end.gif" class="mouse" border="0" alt='<egui:intnl text="reporter.common.Last"/>' title='<egui:intnl text="reporter.common.Last"/>' onClick="javascript:showPage(<%=(total_num_page)%>)" >
												&nbsp;
		<%
							}catch(Throwable ddd)
							{
								System.out.println("Exception in last page transition = "+ddd.getMessage());
								ddd.printStackTrace();
							}
						}
						else
						{
		%>
												&nbsp;
		<%
						}
		%>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
		<%
					}
				}
		%>
				<!-- 	</td>
				</tr>
				
			<table ID="cellbglight" class="blackcontent" cellpadding="0" cellspacing="0" border="0" width="100%">
				<tr>
					<td ID="cellbglight" class="blackcontent" height="10">
						&nbsp;
					</td>
				</tr>
			</table>   -->
			</div>
			</div>
	</body>
</html>
<%
	}catch(Throwable yy)
	{
		yy.printStackTrace();
	}
%>
