<!DOCTYPE html>
<%
/************************************************************************************************
*	File			:	ErApplicationLaunchCountReportPrint.jsp
*	Purpose			:	Displays the configured measures and its details for the Citrix Applications
*	Version			:	Reporter v5.65
*	Author			:	Arul Edward J
*	Creation Date	:	10/06/14 
*
*************************************************************************************************/
%>
<%@ include file = "ErTracker.jsp" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgReportInfo"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "egurkha.reporter.ErUtils"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	List lst = new LinkedList();
	Vector v_measure_csv = new Vector();
	List list_data = new LinkedList();
	List tListt=null;
	ErUtils erUtils = new ErUtils();
try{
	Map resultMap = (HashMap) session.getAttribute("APPLICATION_LAUNCH_COUNT");
	String strManagerURL = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort();
	EgDbInfo dbInfo = new EgDbInfo("manager");
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	EgReportInfo reportInfo = new EgReportInfo("manager");

	String BLANK_SPACE = " ";
	String COMA = ",";
	String COLON = ":";
	String UTF_8 = "UTF-8";
	String s_st_time = request.getParameter("startdate");
	String s_en_time = request.getParameter("enddate");
	String s_st_hr = request.getParameter("starthr");
	String s_en_hr = request.getParameter("endhr");
	String strmin = request.getParameter("startmin");
	String enmin = request.getParameter("endmin");
	String applicationName = request.getParameter("er_application");
	String pdfPrint = request.getParameter("pdfPrint");
	String sample = request.getParameter("sample");
	String timefrom = request.getParameter("timefrom");
	String minfrom = request.getParameter("minfrom");
	String timeto = request.getParameter("timeto");
	String minto = request.getParameter("minto");
	String iniDate = request.getParameter("inidate");
	String er_type = request.getParameter("er_type");
	String er_top = request.getParameter("er_top");
	String er_workerGroup = request.getParameter("er_workerGroup");
	String er_zone = request.getParameter("er_zone");
	String er_comptype = request.getParameter("er_compType");
	String s_compType = request.getParameter("er_compType");
	String[] s_application = request.getParameterValues("er_application");
	String[] selectedCompArray = request.getParameterValues("er_component");
	String[] er_adGroup = request.getParameterValues("er_adGroup");
	String[] er_user = request.getParameterValues("er_adGroup");
	String er_groupby = request.getParameter("er_groupBy");
	String geoDetails = request.getParameter("geoDetails");
	String er_detailsBasedOn = request.getParameter("er_detailsBasedOn");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";	
	com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	//prakash
	String strExcWeekend = reportInfo.getExcludeWeekend("APPLICATION_LAUNCH_COUNT");
	String excludeWeekend = request.getParameter("er_excwe");
	//
	String fontStyleDblSingl = "";
	if((dbInfo.doubleByteEnabled || !thisuser.getLanguage().equals("en_US")) && !(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes") || (sample != null && !sample.equalsIgnoreCase("yes") )))
	{
		fontStyleDblSingl = "multi_font";
	}
	else
	{
		fontStyleDblSingl = "";
	}
	//prakash
	if(er_detailsBasedOn!=null)
	{
		if(er_detailsBasedOn.equalsIgnoreCase("user"))
		{	
			if(er_groupby!=null && er_groupby.equalsIgnoreCase("user"))
			{
				er_groupby = "Application";
			}
		}
		else if(er_detailsBasedOn.equalsIgnoreCase("application"))
		{
			if(er_groupby!=null && er_groupby.equalsIgnoreCase("application"))
			{
				er_groupby = "User";
			}
		}
	}
	//
	String er_option =request.getParameter("er_option");
	String er_site = request.getParameter("er_site");
	String headerKeyName="";
		if(er_option!=null && er_option.equalsIgnoreCase("Segment"))
		{
			headerKeyName=er_option+" : "+er_site;
		}
		else if(er_option!=null && er_option.equalsIgnoreCase("Service"))
		{
			headerKeyName=er_option+" : "+er_site;
		}
		else if(er_option!=null && er_option.equalsIgnoreCase("Component"))
		{
			headerKeyName=er_option;
		}
		else
		{
			headerKeyName="Zone"+" : "+request.getParameter("select_farm");
		}
	EgMappingInfo intlmap=new EgMappingInfo(thisuser.getLanguage());
	
	HashMap htHeading = new HashMap();
	ArrayList aList1 = new ArrayList();
	ArrayList aList2 = new ArrayList();
	ArrayList aList3 = new ArrayList();

	String isSearchByVmCompSt = request.getParameter("isSearchByVmComp");
	String isLaunchByVmSt = request.getParameter("islaunchByVm");
	boolean isLaunchByVm=false;
	boolean isSearchByVmComp=false;
	boolean isAppLaunchDuarationColumnEnabled = false;
	boolean isVm = false;
	Boolean booleanObj = (Boolean)resultMap.get("isAppLaunchDuarationColumnEnabled");
	Boolean isVmObj = (Boolean)resultMap.get("isVm");
	if(booleanObj!=null)
		isAppLaunchDuarationColumnEnabled = booleanObj.booleanValue();
	if(isVmObj!=null)
		isVm = isVmObj.booleanValue();

	if(isSearchByVmCompSt!=null && isSearchByVmCompSt.equalsIgnoreCase("true"))
	{
		isSearchByVmComp=true;
	}
	if(isLaunchByVmSt!=null && isLaunchByVmSt.equalsIgnoreCase("true"))
	{
		isLaunchByVm=true;
	}
	boolean getSessionDetails = true;
	String ShowSessionDetails= reportInfo.getValue("APPLICATION_LAUNCH_COUNT","ShowSessionDetails");
	if(ShowSessionDetails!=null && (ShowSessionDetails.equalsIgnoreCase("NO") || ShowSessionDetails.equalsIgnoreCase("FALSE")))
		getSessionDetails = false;
%>
<html>
<head>
<%
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
		<title>&nbsp; <egui:intnl text="reporter.common.Reporter"/>
		&nbsp; &nbsp; <egui:intnl text="reporter.common.Print"/> &nbsp;</title>
<%
	}
	else
	{
%>
		<title>&nbsp; <egui:intnl text="reporter.common.Reporter" />
		&nbsp; &nbsp;</title>
<%
	}
%>

<meta name="Author" content="">
<meta  charset="UTF-8">

<link rel="stylesheet" type="text/css" href="../../final/styles/eGLightThemeIcons.css" />
<link rel="stylesheet" type="text/css" href="../../final/reporter/styles/printpagestyle.css" />

<style type="text/css" media="print">
#printbt{ display:none}
</style>

<style>
@page {size : landscape; margin : 0in }
@page :footer {content: none, "Macro Home" decimal(pageno), none;}
</style>

</head>

<body marginwidth="20" marginheight="20" bgcolor="#FFFFFF">

<%
	String strLogCls = "printHeaderBoxLogo";
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
		strLogCls = "printHeaderBoxLogo";
	}else
		strLogCls = "printPdfHeaderBoxLogo";
%>
	<div class="<%=strLogCls%>" style="float:right"><img src="<%=imageName%>" border="0" /></div>

	<%
	
						lst.add(intlmap.getTextDescription("reporter.thin.THIN CLIENT REPORTS")+" - "+intlmap.getTextDescription("reporter.common.APPLICATION LAUNCH COUNT"));
	 %>
	 <div class="printHeaderBox">
				
		<div class="printHeaderBoxTitle"><egui:intnl text="reporter.common.Application Launch for " /> - <span class="bold"><egui:intnl text="<%=headerKeyName%>" /></div>
	<%
		if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
		{
	%>
			<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrintPreview mouse"  id="pri ntbt"src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
	<%
		}
	%>		   
	</div>
			
		
	<div class="printOuterBoxNoBorder">
				
		<div class="printSelectionFields"><egui:intnl text="reporter.common.Component Type" /> - <span class="bold"><%=intlmap.getComponentTypeDescription(er_comptype)%></span></div>

<%
			if(excludeWeekend!=null && excludeWeekend.equalsIgnoreCase("yes"))
			{
%>				
				<div class="printSelectionFields"><egui:intnl text="reporter.common.WeekEnd" /> - <span class="bold"><%=strExcWeekend%></span></div>
<%
			}
			String dispStart="";
			String dispEnd="";
			EgTimeZoneConverter converterStart = new EgTimeZoneConverter(s_st_time + " " + s_st_hr+COLON+strmin,thisuser);
			String st_Time = converterStart.getDateTime();
			EgTimeZoneConverter converterEnd = new EgTimeZoneConverter(s_en_time + " " + s_en_hr+COLON+enmin,thisuser);
			String en_Time = converterEnd.getDateTime();
			dispStart = st_Time+" hrs";
			dispEnd = en_Time+" hrs";
			Vector dvec = new Vector();
			String stimefmt = "Start Date : "+dispStart;
			String etimefmt = "End Date : "+dispEnd;
			dvec.add('"'+stimefmt+'"');
			dvec.add('"'+etimefmt+'"');
			lst.add(dvec);
%>
		<div class="printSelectionFields">Timeline - <span class="bold"><%=dispStart%>&nbsp;to <%=dispEnd%>&nbsp;</span></div>
			
</div>
<%
	String er_topStr = "";
	if (er_top !=null && er_top.indexOf("-")>-1)
		er_topStr = er_topStr.replace("- ","");
	if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))
	{
%>
		
			<div class="printOuterBox">
				<div class="printOuterBoxHeader"><%= er_topStr %>&nbsp;<egui:intnl text="reporter.common.Application Launch"/></div>
<%
	}
	else
	{
%>
		<div class="printOuterBox">
			<div class="printOuterBoxHeader"><%= er_topStr %>&nbsp;<egui:intnl text="reporter.common.Application Launch by User"/></div>
<%
	}
%>

<%
Map dataMap = (HashMap)resultMap.get("REPORT_DATA");
String geoColDetails = (String)reportInfo.getValue("APPLICATION_LAUNCH_COUNT","GeoColumnDetails_"+s_compType);
ArrayList geoColumnList = com.egurkha.util.StringUtils.egTokenizer(geoColDetails, ",",false,false,true);
if (er_type != null && !er_type.equalsIgnoreCase("yes")) 
{
	Iterator itr = dataMap.keySet().iterator();
	int userCount = 0;
	Map tempDataMap = new HashMap();
	// by karthikeyan
	HashSet overAllUniqueUserForLaunchByUser = new HashSet();
	HashSet overAllUniqueUserForLaunchByApplication = new HashSet();
	HashSet overAllUniqueUserGroupByComponent = new HashSet();
	HashMap uniqueUsrCntByGrpComp = new HashMap();
	HashMap overAllAppLaunchDuration = new HashMap();
	HashMap AppLanchDuration = new HashMap();
	boolean isGroupByComponent=false;
	if (er_groupby != null && er_groupby.equalsIgnoreCase("Component"))
		{
			isGroupByComponent=true;
		}
	//
	int launchCount = 0;
	double totalAvgLaunchduration=0;
	while(itr.hasNext()) {
		String keyStr = (String) itr.next();
		overAllUniqueUserForLaunchByUser.add(keyStr);
		Map userMap = (HashMap) dataMap.get(keyStr);
		Iterator userItr = userMap.keySet().iterator();
		Iterator userItr2 = userMap.keySet().iterator();
		int count = 0;
		HashSet hsTemp=new HashSet();
		double totalAppLaunchDuration = 0.0;
		String strOverAllAppLaunchDuration = "-";
		while(userItr2.hasNext()){
			String usr = (String) userItr2.next();
			overAllUniqueUserForLaunchByApplication.add(usr);
			List vList = (ArrayList) userMap.get(usr);
			count += vList.size();
			launchCount += vList.size();
						if(isGroupByComponent)
						{
							for(int k=0;k<vList.size();k++)
							{
								ArrayList ss=(ArrayList)vList.get(k);
								for(int i=0;i<ss.size();i++)
								{
									hsTemp.add(ss.get(0));
									overAllUniqueUserGroupByComponent.add(ss.get(0));
								}
							}
							uniqueUsrCntByGrpComp.put(keyStr,hsTemp.size());
						}
			if (s_compType!=null && er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application") && isAppLaunchDuarationColumnEnabled)
						{
							double totalLaunchDurationByComp=0.0;
							double avgLaunchDurationByComp=0.0;
							String strAvgLaunchTime = "-";
							int laucnhcolumn=2;
							if(isVm)
								laucnhcolumn=3;
							if(vList!=null && vList.size()>0)
							{
								for(int y=0;y<vList.size();y++)
								{
									ArrayList aListUserData = (ArrayList)vList.get(y);
									if(aListUserData!=null && aListUserData.size()>2)
									{
										String getAvg = (String)aListUserData.get(laucnhcolumn);
										if(getAvg!=null && getAvg.length()>0 &&!getAvg.equals("-"))
										{
											totalLaunchDurationByComp+=Double.valueOf(getAvg);
											totalAppLaunchDuration+=Double.valueOf(getAvg);
										}
									}
								}
								if(totalLaunchDurationByComp>0)
								{
									avgLaunchDurationByComp = totalLaunchDurationByComp/vList.size();
									strAvgLaunchTime = erUtils.round(avgLaunchDurationByComp,4);
								}
							}
							AppLanchDuration.put(usr+keyStr,strAvgLaunchTime);

						}

		}
		if(totalAppLaunchDuration>0)
		{
			if(launchCount>0)
			{
				double tempavg = totalAppLaunchDuration/count;
				totalAvgLaunchduration +=tempavg;
				strOverAllAppLaunchDuration = erUtils.round(tempavg,4);
			}
		}
		List list = new ArrayList();
		if (tempDataMap.containsKey(count+""))
			list = (ArrayList) tempDataMap.get(count+"");
		list.add(keyStr);
		tempDataMap.put(count+"",list);
		overAllAppLaunchDuration.put(keyStr,strOverAllAppLaunchDuration);
	}	
	int divCount = 1;
	if (dataMap.keySet().size() > 0)
	{
		String applicationCount = "0";
		lst.add("SUMMARY");
		lst.add("Total Number of Unique Users "+" - "+ overAllUniqueUserForLaunchByApplication.size());
		lst.add("Total Number of Application Launches"+" - "+launchCount);

		if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))
		{
			v_measure_csv.add("Applications");
			lst.add("Total Number of Unique Applications"+" - "+overAllUniqueUserForLaunchByUser.size());
			applicationCount = overAllUniqueUserForLaunchByUser.size()+"";
		}
		else if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("user"))
		{
			v_measure_csv.add("User");
			if(isGroupByComponent)
			{
				lst.add("Total Number of Unique Applications"+" - "+overAllUniqueUserGroupByComponent.size());
				applicationCount = overAllUniqueUserGroupByComponent.size()+"";
			}
			else
			{
				lst.add("Total Number of Unique Applications"+" - "+overAllUniqueUserForLaunchByApplication.size());
				applicationCount = overAllUniqueUserForLaunchByApplication.size()+"";
			}
		}
		lst.add(" "+"Published Application");

		v_measure_csv.add("");
		v_measure_csv.add("");
		v_measure_csv.add("");
		v_measure_csv.add("");
		v_measure_csv.add("Launches");
		if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))
		{
			if (s_compType!=null && isAppLaunchDuarationColumnEnabled)
				v_measure_csv.add("Avg Launch Duration (Secs)");
			v_measure_csv.add("Unique Users");
			v_measure_csv.add("");
		}
		else
		{
			v_measure_csv.add("");
			v_measure_csv.add("");
		}
		v_measure_csv.add("");
		v_measure_csv.add("");
%>
	<div class="printOuterBox">
		<div class="newTable">
			<table width="100%"  cellpadding="4" cellspacing="0"><col width="90%"><col width="10%">
				<thead><tr>
					<th align="center" class="printTableHeader">Summary</th>
					<th align="center" class="printTableHeader"></th>
				</tr></thead>
				<tbody>
				<tr>
					<td>Total Number of Unique Users</td>
<%
		if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))
		{
				if(isGroupByComponent)
				{
					
					%>
						<td align="center"><%=overAllUniqueUserGroupByComponent.size()%></td>
					<% 
				}
				else
				{
%>
					<td align="center"><%=overAllUniqueUserForLaunchByApplication.size()%></td>
<%
				}
		}
		else
		{ 
%>
					<td align="center"><%=overAllUniqueUserForLaunchByUser.size()%></td>
					
<%
		}
%>
				</tr>
				<tr>
							<td>Total Number of Application Launches</td>
							<td align="center"><%=launchCount%></td>
				</tr>
				<tr>
							<td>Total Number of Unique Applications</td>
							<td align="center"><%=applicationCount%></td>
				</tr>
				<%
				if (s_compType!=null &&(s_compType.equalsIgnoreCase("Citrix_XcXenApp_server") || s_compType.equalsIgnoreCase("Citrix_server")|| s_compType.equalsIgnoreCase("VMWareView_RDS"))&& er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application") && isAppLaunchDuarationColumnEnabled)
				{
					totalAvgLaunchduration=totalAvgLaunchduration/Double.parseDouble(applicationCount);
					String totalAvgLaunchdurationStr=erUtils.round(totalAvgLaunchduration,2);
					%>
						<tr>
							<td>Average Launch Duration</td>
							<td align="center"><%=totalAvgLaunchdurationStr%></td>
						</tr>
					<%
				}
				%>
				</tbody>
			</table><br/>
			<%
		if (s_compType!=null && er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application") && isAppLaunchDuarationColumnEnabled)
		{
	%>
			<table width="100%"  cellpadding="0" cellspacing="0"><col width="50%"><col width="10%"><col width="20%"><col width="20%">
			<%
		}
		else
		{
			%>
			<table width="100%"  cellpadding="0" cellspacing="0"><col width="90%"><col width="10%">
			<%
		}
			%>
				<thead><tr>
<%
		if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))
		{
									
%>
					<th align="left" class="printTableHeader">Application</th>
<%
		}
		else
		{
										%>
					<th align="left" class="printTableHeader">Users</th>
<%
		}
									%>
					<th align="left" class="printTableHeader"> Launches</th>
<%
		if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))
		{
			if (s_compType!=null && isAppLaunchDuarationColumnEnabled)
%>
				<th align="left" class="printTableHeader">Avg Launch Duration (Secs)</th>
				<th align="left" class="printTableHeader">Unique Users</th>
					
<%
		}
%>
				</tr>
				</thead>
				<tbody>
<%
		Set set = tempDataMap.keySet();
		List timeList = new ArrayList(set);
		Comparator comparator = new ErNumreicComparator();
		Collections.sort(timeList, comparator);
		for (int k=timeList.size()-1; k>=0; k--)
		{
			String tempKey = (String) timeList.get(k);
			List list = (ArrayList) tempDataMap.get(tempKey);
			int uniqUserByGrpComp=0;
			for (int l=0; l<list.size(); l++)
			{
				String keyStr = (String)list.get(l);
				Map userMap = (HashMap) dataMap.get(keyStr);
				Set userKeySet = userMap.keySet();
				Iterator userItr = userMap.keySet().iterator();
				String strAppLauncDuration = (String)overAllAppLaunchDuration.get(keyStr);
				if(isGroupByComponent)
				{
					uniqUserByGrpComp=(Integer)uniqueUsrCntByGrpComp.get(keyStr);
				}
				list_data.add(keyStr);
				list_data.add("");
				list_data.add("");
				list_data.add("");
				list_data.add("");
				list_data.add(tempKey);
				if (s_compType!=null && er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application") && isAppLaunchDuarationColumnEnabled)
				{
					list_data.add(strAppLauncDuration);
				}
				if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))
				{
					if(isGroupByComponent)
					{
						list_data.add(uniqUserByGrpComp+"");
					}
					else
					{
						list_data.add(userKeySet.size()+"");
					}
					
					list_data.add("");
				}
				else
				{
					list_data.add("");
					list_data.add("");
				}
				list_data.add("");
				list_data.add("");
				//
%>
				<tr>
					<td><%=keyStr %></td>
					<td align="center"> <%=tempKey %></td>
<%
				if (s_compType!=null && er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application") && isAppLaunchDuarationColumnEnabled)
				{
	%>
						<td align="center"> <%=strAppLauncDuration%></td>
						<%
					// by karthikeyan
						if(isGroupByComponent)
						{
						// uniqUserByGrpComp=(Integer)uniqueUsrCntByGrpComp.get(keyStr);
						%>
						 <td align="center"> <%=(Integer)uniqueUsrCntByGrpComp.get(keyStr)%></td>
						 <%
						}
						else
						{
%>
					<td align="center"> <%=userKeySet.size()%></td>

<%
						}
%>
				
				<%
				}
%>
				</tr>
				<tr>
				<%
				//if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))
				if(s_compType!=null && er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application") && isAppLaunchDuarationColumnEnabled)
				{
					%>
					<td align="right" colspan="4" style="padding:10px 20px 10px 20px">
					<%
				}
				else
				{
					%>
					<td align="right" colspan="2" style="padding:10px 20px 10px 20px">
					<%
				}
					%>
<%
				Map tempMap = new HashMap();
				while(userItr.hasNext()){
					String usrName = (String) userItr.next();
					List valueList = (ArrayList) userMap.get(usrName);
					List vlist = new ArrayList();
					if (tempMap.containsKey(valueList.size()+""))
						vlist = (ArrayList) tempMap.get(valueList.size()+"");
					vlist.add(usrName);
					tempMap.put(valueList.size()+"",vlist);
				}
				set = tempMap.keySet();
				List tList = new ArrayList(set);
				Collections.sort(tList, comparator);
				for (int m=tList.size()-1;m>=0;m--)
				{
					String countStr = (String) tList.get(m);
					List outList = (ArrayList) tempMap.get(countStr);
					for (int n=0; n<outList.size(); n++)
					{
						String usrNameStr = (String) outList.get(n);
						divCount++;
						List valueList = (ArrayList) userMap.get(usrNameStr);
						if(er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))
							list_data.add("");
						else if(s_compType!=null && (s_compType.equalsIgnoreCase("Citrix_XcXenApp_server") || s_compType.equalsIgnoreCase("Citrix_server")))
							list_data.add("");
						else if(er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("user") &&  n == 0 )
							list_data.add("");
						String strAvgLaucnhTime = (String)AppLanchDuration.get(usrNameStr+keyStr);
						if (s_compType!=null && er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application") && isAppLaunchDuarationColumnEnabled)
						{
			%>
							<table width="100%" cellpadding="0" cellspacing="0" class="printTable"><col width="90%"><col width="10%">
			<%
						}
						else
						{
							%>
							<table width="100%" cellpadding="0" cellspacing="0" class="printTable"><col width="80%"><col width="20%">
							<%
						}
							%>
							<thead><tr>
<%
						if (er_groupby != null && er_groupby.equalsIgnoreCase("user"))
						{
							list_data.add("User");
%>
							<th align="left" class="printTableHeader2">User</th>
<%
						}
						else if (er_groupby != null && er_groupby.equalsIgnoreCase("application"))
						{
							list_data.add("Application");
%>
							<th align="left" class="printTableHeader2">Application</th>
<%
						}
						else
						{
							if(er_groupby != null && er_groupby.equalsIgnoreCase("Component") && isLaunchByVm)
							list_data.add("Desktop");
							else
							list_data.add("Server");
%>
				<% if(er_groupby != null && er_groupby.equalsIgnoreCase("Component") && isLaunchByVm) 
				%>
								<th align="left" class="printTableHeader2">Desktop</th>
						<% else %>
								<th align="left" class="printTableHeader2">Server</th>
<%
						}
									list_data.add("");
									list_data.add("");
									list_data.add("");
									list_data.add("Launches");
									list_data.add("");
									list_data.add("");
									list_data.add("");
									if(er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("user"))
										list_data.add("");
									if (s_compType!=null && er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application") && isAppLaunchDuarationColumnEnabled)
									{
										if (s_compType!=null && (s_compType.equalsIgnoreCase("Citrix_XcXenApp_server") || s_compType.equalsIgnoreCase("Citrix_server") || s_compType.equalsIgnoreCase("VMWareView_RDS")))
											list_data.add("");
										list_data.add("Avg Launch Duration (Secs)");
									}
									list_data.add("");
									if(er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))//add condn for vm Component
										list_data.add("");
									list_data.add(usrNameStr);
									list_data.add("");
									list_data.add("");
									list_data.add("");
									list_data.add(countStr);
									list_data.add("");
									list_data.add("");
									list_data.add("");
									list_data.add("");
									if (s_compType!=null && er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application") && isAppLaunchDuarationColumnEnabled)
									{
										list_data.add(strAvgLaucnhTime);
									}
									%>
								<th align="left" class="printTableHeader2"> Launches</th>
							<%
								if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application") && isAppLaunchDuarationColumnEnabled)
								{
							%>
									<th align="left" class="printTableHeader2"> Avg Launch Duration (Secs)</th>
							<%
								}
							%>
							</tr>
							</thead>
							<tbody>
							<tr>
								<td class="tdClass"><%= usrNameStr %></td>
								<td class="tdClass" align="center"> <%= countStr%></td>
								<%
								if (s_compType!=null && er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application") && isAppLaunchDuarationColumnEnabled)
								{
										%>
									<td class="tdClass" align="center"> <%= strAvgLaucnhTime%></td>
									<%
								}
									%>
							</tr>
<%
%>
							<tr>
<%
							if (s_compType!=null &&  er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application") && isAppLaunchDuarationColumnEnabled)
								{
%>
										<td  align="right" colspan="3" style="padding:10px 20px 10px 20px">
<%								
								}
					
						else if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))
						{
							%>
							<td  align="right" colspan="2" style="padding:10px 20px 10px 20px">
							<%
						}
						else if (s_compType!=null &&  er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("User") && isAppLaunchDuarationColumnEnabled)
						{
							%>
							<td  align="right" colspan="2" style="padding:10px 20px 10px 20px">
							<%
						}
						else
						{
							%>
							<td  align="right" colspan="2" style="padding:10px 20px 10px 20px">
							<%
						}
							%>
								<!-- <div id="componentDiv_<%=divCount%>" style="visibility:hidden;display:none;width:100%"> -->
							<table width="100%" cellpadding="0" cellspacing="0" class="printTable" border="0">
								<thead><tr>
<%
						list_data.add("");
						list_data.add("");
						if (er_groupby != null && er_groupby.equalsIgnoreCase("user"))
						{
							if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))
							{
								list_data.add("Server");
%>
								<th align="left" class="printTableHeader2">Server</th>
<%
							}
							else
							{
								list_data.add("Application");
%>
								<th align="left" class="printTableHeader2">Application</th>
<%
							}
						}
						else if (er_groupby != null && er_groupby.equalsIgnoreCase("application"))
						{
							if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("user"))
							{
								list_data.add("Server");
%>
								<th align="left" class="printTableHeader2">Server</th>
<%
							}
							else
							{
								list_data.add("User");
%>
								<th align="left" class="printTableHeader2">User</th>
<%
							}
						}
						else
						{
							if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("user"))
							{
								list_data.add("Application");
%>
								<th align="left" class="printTableHeader2">Application</th>
<%
							}
							else
							{
								list_data.add("User");
%>
								<th align="left" class="printTableHeader2">User</th>
<%
							}
						}
						Comparator comparator1 = new ErNumreicComparator(strUserDateFormat); // DATE FORMAT ALONE
						if(isLaunchByVm || isSearchByVmComp)
							comparator1 = new ErNumreicComparator(2,strUserDateFormat);// SORT INDEX AND DATE FORMAT
						
						Collections.sort(valueList,comparator1);
						Collections.reverse(valueList);

						if(valueList!=null && valueList.size()>0)
							 tListt = (ArrayList) valueList.get(0);

						if(er_groupby != null && er_groupby.equalsIgnoreCase("Component") && isLaunchByVm)
						{
							list_data.add("Server");
							list_data.add("Application Launch Time");
							if (s_compType!=null &&  isAppLaunchDuarationColumnEnabled)
							{
								list_data.add("Launch duration (Secs)");
							}
							if(getSessionDetails)
							{
							list_data.add("Session Start");
							list_data.add("Session End");
							}
							int sizeOftList =5;
							if(!getSessionDetails)
								sizeOftList =3;
							if(tListt!=null && tListt.size()>sizeOftList)
							{
								list_data.add("Client Address");
								list_data.add("Client Name");
								list_data.add("Client Version");
							}
							else
							{
								list_data.add("");
								list_data.add("");
								list_data.add("");
							}
						}
						else if(isSearchByVmComp)
						{
							int sizeOftList =5;
							if(!getSessionDetails)
								sizeOftList =3;
							list_data.add("Desktop");
							list_data.add("Application Launch Time");
							if (s_compType!=null && isAppLaunchDuarationColumnEnabled)
							{
								list_data.add("Launch duration (Secs)");
								sizeOftList++;
							}
							if(getSessionDetails)
							{
								list_data.add("Session Start");
								list_data.add("Session End");
							}

							if(tListt!=null && tListt.size()>sizeOftList)
							{
								list_data.add("Client Address");
								list_data.add("Client Name");
								list_data.add("Client Version");
							}
							else
							{
								list_data.add("");
								list_data.add("");
								list_data.add("");
							}
						}
						else
						{
							list_data.add("Application Launch Time");
							int sizeOftList =4;
							if(!getSessionDetails)
								sizeOftList =2;
							if (s_compType!=null &&  isAppLaunchDuarationColumnEnabled)
							{
								list_data.add("Launch duration (Secs)");
								sizeOftList++;
							}
							if(getSessionDetails)							
							{
								list_data.add("Session Start");
								list_data.add("Session End");
							}


							if(tListt!=null && tListt.size()>sizeOftList)
							{
								list_data.add("Client Address");
								list_data.add("Client Name");
								list_data.add("Client Version");
							}
							else
							{
								list_data.add("");
								list_data.add("");
							}
						}
						if(!getSessionDetails)
						{
							list_data.add("");
							list_data.add("");
						}
						if(geoDetails != null && geoDetails.equalsIgnoreCase("yes")){
							if(geoColumnList != null){
								for(int i=0;i<geoColumnList.size();i++)
									list_data.add((String)geoColumnList.get(i));
							}
						}
%>
<%
if(er_groupby != null && er_groupby.equalsIgnoreCase("Component") && isLaunchByVm)
{
%>
	<th class="printTableHeader2"> Server</th>
	<th class="printTableHeader2"> Application Launch Time</th>
	<!-- <td class="tdborder"id="er_submit"> Application End</td> -->
	<%
	if(getSessionDetails)
	{
%>
	<th class="printTableHeader2"> Session Start</th>
	<th class="printTableHeader2"> Session End</th>
<%
	}

	if(tListt!=null && tListt.size()>5)
	{
%>
		<th class="printTableHeader2"> Client Address</th>
		<th class="printTableHeader2"> Client Name</th>
		<th class="printTableHeader2"> Client Version</th>
	<%
	}
%>
<%
}
	else if(isSearchByVmComp)
	{
%>
		<th class="printTableHeader2"> Desktop</th>

		<th class="printTableHeader2"> Application Launch Time</th>
		<%
		int clintCnt=5;
		if (s_compType!=null && isAppLaunchDuarationColumnEnabled)
		{
	%>
			<th class="printTableHeader2"> Launch Duration (Secs)</th>
	<%
			clintCnt=6;
		}
	if(getSessionDetails)
	{
%>
		<th class="printTableHeader2"> Session Start</th>
		<th class="printTableHeader2"> Session End</th>
<%
	}
%>
	<%
		if(tListt!=null && tListt.size()>clintCnt)
		{
	%>
			<th class="printTableHeader2"> Client Address</th>
			<th class="printTableHeader2"> Client Name</th>
			<th class="printTableHeader2"> Client Version</th>
		<%
		}
%>
<%
	}
else
	{
		int sizeList = 4;
	%>
		<th class="printTableHeader2"> Application Launch Time</th>
		<%
		if (s_compType!=null && isAppLaunchDuarationColumnEnabled)
		{
			sizeList++;
		%>
			<th class="printTableHeader2"> Launch Duration (Secs)</th>
			<%
		}
		if(getSessionDetails)
		{
%>
		<th class="printTableHeader2"> Session Start</th>
		<th class="printTableHeader2"> Session End</th>
<%
		}
%>
	<%
		if(tListt!=null && tListt.size()>sizeList)
		{
	%>
			<th class="printTableHeader2"> Client Address</th>
			<th class="printTableHeader2"> Client Name</th>
			<th class="printTableHeader2"> Client Version</th>
		<%
		}
		%>
		<%
	}
		if(geoDetails != null && geoDetails.equalsIgnoreCase("yes")){
			if(geoColumnList != null){
				for(int i=0;i<geoColumnList.size();i++){
		%>
			<th class="printTableHeader2"><%=(String)geoColumnList.get(i)%></th>
		<%	
				}
			}
		}
%>
					</tr>
				</thead>
				<tbody>
<%
						list_data.add("");
						if (s_compType!=null && (s_compType.equalsIgnoreCase("Citrix_XcXenApp_server") || s_compType.equalsIgnoreCase("Citrix_server"))){
								list_data.add("");
						}
						else if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("application")){
							list_data.add("");
						}
						int columnSize=0;
						int sizeOftList =5;
						if(!getSessionDetails)
							sizeOftList =3;
						for (int i=0; i<valueList.size(); i++)
						{
							if(i>0)
							{
								if(isSearchByVmComp||(er_groupby != null && er_groupby.equalsIgnoreCase("Component") && isLaunchByVm))
								{
									if(tListt!=null && tListt.size()>sizeOftList)
									{
										list_data.add("");
									}
									else
									{
										list_data.add("");
									}
								}
								else
								{
									list_data.add("");
									if (s_compType!=null && !(s_compType.equalsIgnoreCase("Citrix_XcXenApp_server") || s_compType.equalsIgnoreCase("Citrix_server")))
									{
										list_data.add("");
									}
								}
							}
							if (!isLaunchByVm && !isSearchByVmComp && !isAppLaunchDuarationColumnEnabled && er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("user"))
								list_data.add("");
							List tempList = (ArrayList) valueList.get(i);
							columnSize=tempList.size();
							if(isSearchByVmComp)
							{
								if(tListt!=null && tListt.size()>sizeOftList && !isAppLaunchDuarationColumnEnabled)
								{
									list_data.add("");
								}
							}
							else if(tListt!=null && tListt.size()>sizeOftList-1)
							{
								if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("application"))
								{
									list_data.add("");
								}
							}
							else
							{
								if(i==0)
								{
									list_data.add("");
									if (s_compType!=null && !(s_compType.equalsIgnoreCase("Citrix_XcXenApp_server") || s_compType.equalsIgnoreCase("Citrix_server")))
									{
										list_data.add("");
									}
								}
							}
%>
										<tr>
<%
							for (int j=0; j<tempList.size(); j++) 
							{
								String tempStr = (String) tempList.get(j);
								list_data.add("\""+tempStr+"\"");
%>
								<td class="tdClass"> <%= tempStr %></td>
<%
							}
							if(tempList!=null && tempList.size()<=sizeOftList-1)
							{
								list_data.add("");
								list_data.add("");
								list_data.add("");
							}

								list_data.add("");
							if(isSearchByVmComp||(er_groupby != null && er_groupby.equalsIgnoreCase("Component") && isLaunchByVm))
							{
								if(i==valueList.size()-1)
								{
									list_data.add("");
									if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("application"))
										list_data.add("");
									else if(n < outList.size() -1)
										list_data.add("");
								}
								else
								{
									list_data.add("");
									list_data.add("");
									if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("application"))
										list_data.add("");
									else{ 
										if(er_groupby != null && !er_groupby.equalsIgnoreCase("Component"))
											list_data.add("");
									}
								}
							}
%>
										</tr>
<%
							if(!getSessionDetails)
							{
								list_data.add("");
								list_data.add("");
							}
						}
		//break;
%>
									</tbody>
									</table>
								<!-- </div> -->
								</td>
							</tr>
						</tbody>
						</table>
<%
					}
				}
				userCount++;
%>
					</td>
				</tr>
<%
			}
		}
%>
			</tbody>
			</table>
		</div>
	</div>
<%
	}
	else
	{
		lst.add(intlmap.getTextDescription("reporter.common.No measures available for the current selection"));

%>
	<table>
		<tr>
			<td align="center" valign="middle" width="100%" height="100%">
				<egui:intnl text="reporter.common.No measures available for the current selection"/>
			</td>
		</tr>
	</table>
<%
	}
}
else
{
	String servlet = "/final/servlet/com.eg.ErApplicationLaunchCountReportC;jsessionid=" + session.getId() + "?er_option=graph&inidate="+com.eg.EgURLEncoder.encode(currentDateFormat,UTF_8)+"&startdate="+com.eg.EgURLEncoder.encode(s_st_time,UTF_8)+"&enddate="+com.eg.EgURLEncoder.encode(s_en_time,UTF_8)+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&startmin="+strmin+"&endmin="+enmin+"&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto+"&er_compType="+s_compType+"&er_width=800&er_height=450&er_top="+com.eg.EgURLEncoder.encode(er_top,UTF_8)+"&er_detailsBasedOn="+com.eg.EgURLEncoder.encode(er_detailsBasedOn,UTF_8);

%>
<table width="100%" align="center">
	<tr>
		<td align="center" width="100%" style="padding:0px 10px 10px 0px">
		<div class="printOuterBox" >
			<div style="width:100%;overflow:auto;padding:0px">
				<img src="<%= strManagerURL + servlet + "&isChartRequest=yes&" %>"/>
			</div>
		</div>
		</td>
	</tr>
<%
	//if (er_detailsBasedOn != null && !er_detailsBasedOn.equalsIgnoreCase("user") && s_compType != null && isAppLaunchDuarationColumnEnabled)
	if (isAppLaunchDuarationColumnEnabled)
	{
%>
		 <tr>
			<td align="center" width="100%" style="padding:0px 10px 10px 0px">
			<div class="printOuterBox" >
				<div style="width:100%;overflow:auto;padding:0px">
					<img src="<%= strManagerURL + servlet + "&isDurationChartRequest=yes&" %>"/>
				</div>
			</div>
			</td>
		</tr>
<%
	}
%>
</table>
<%
}
%>
</div>
<%
 if(pdfPrint!=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
	 <div class="printFooterText"><%=strPrintFooterText%></div>
<%
	}
%>
</body>
</html>
<%

	Hashtable h_tabrc = new Hashtable();	//SubTable Data
	Hashtable h_tab = new Hashtable();	//SunTitle with SubTable Data
	String s_title = "";

	h_tabrc.put(v_measure_csv,list_data);
	h_tab.put(s_title,h_tabrc);
	lst.add(h_tab);
	if(lst!= null && !lst.isEmpty())
	{
		session.setAttribute("ScheduleCSVData",lst);
	}
	if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application"))
		aList1.add("Application");
	else 
		aList1.add("User");
	aList1.add("Launch");

	if (er_groupby != null && er_groupby.equalsIgnoreCase("Application"))
		aList2.add("Application");
	else if (er_groupby != null && er_groupby.equalsIgnoreCase("User"))
		aList2.add("User");
	else 
	{
		if(er_groupby != null && er_groupby.equalsIgnoreCase("Component") && isLaunchByVm)
		aList2.add("Desktop");
		else
		aList2.add("Server");
	}
	aList2.add("Launch");

	if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("Application")){
		if (er_groupby != null && er_groupby.equalsIgnoreCase("User"))
			aList3.add("Server");
		else 
			aList3.add("User");
	} else if (er_detailsBasedOn != null && er_detailsBasedOn.equalsIgnoreCase("User")){
		if (er_groupby != null && er_groupby.equalsIgnoreCase("Application"))
			aList3.add("Server");
		else 
			aList3.add("Application");
	}
	if(er_groupby != null && er_groupby.equalsIgnoreCase("Component") && isLaunchByVm)	{
		aList3.add("Server");
		aList3.add("Application Launch Time");
		aList3.add("Session Start");
		aList3.add("Session End");
		aList3.add("Client Address");
		aList3.add("Client Name");
		aList3.add("Client Version");
	}
	else if(isSearchByVmComp)
	{
		aList3.add("Desktop");
		aList3.add("Application Launch Time");
		aList3.add("Session Start");
		aList3.add("Session End");
		aList3.add("Client Address");
		aList3.add("Client Name");
		aList3.add("Client Version");
	}
	else
	{
		aList3.add("Application Launch Time");
		aList3.add("Session Start");
		aList3.add("Session End");
		aList3.add("Client Address");
		aList3.add("Client Name");
		aList3.add("Client Version");
	}
} catch(Exception e) {
	e.printStackTrace();
}
%>
<%
	//For Setting the PDf File Name
	HashMap paramVal =new HashMap();
	paramVal.put("fileName","Application_Launch_Count_Report");
	session.setAttribute("parameters", paramVal);
%>
<%@ include file = "ErRemoveUser.jsp" %>
