<%
/*******************************************************************************
*	File name		:	ErCitrixMachineReport.jsp
*	Purpose			:	Displays the Citrix 
*	Version			:	6.3
*	Author			:	Ganesh P
*	Creation Date	:	05/02/18 
*******************************************************************************/
%>
<%@ include file = "ErTracker.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<%@ page import="com.eg.EgReportInfo"%>

<html>
<head>
<title><egui:intnl text="reporter.common.eG Reporter"/> </title>
<egui:skin ui="reporter"/>
<meta charset="utf-8">
<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>


<style>
  span.decimal-align{float: left; text-align: right; width:50%}
  span.decimal-align2{float: right; text-align: left; width:50%}


  .divTable{
	display: table;
	width: 100%;
}

}
.divTableBody {
	display: table-row-group;
}

.divTableRow {
	display: table-row;
}

.divTableCell, .divTableHead {
	display: table-cell;
	padding: 3px 10px;
	border: 1px solid #999999;
}

.hidePlus .x-grid-row-expander {
    visibility: hidden !important;
}
.highcharts-legend {
    visibility: hidden !important;
}
.div-left{
    float:left;
    padding-left:10px;
}
.legendCircleNew
{
	width:6px;height:6px;border-radius:4px;
}
</style> 

<script  src="../reporter/scripts/jsrsClient.js"></script>
<!-- fancy Scroll-->
<script src="/final/jquery/jquery.js"></script>
<script src="/final/reporter/scripts/er_validator.js"></script>
<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script><!-- reporterHomeApp -->
<script src="/final/reporter/scripts/eg_DateUtil.js"></script>
<script src="../scripts/<%=script_src%>"></script>
<script src="/final/reporter/scripts/er_validator.js"></script>
<script src="/final/reporter/scripts/er_date.js"></script>
<script src="../reporter/scripts/eg_DateUtil.js"></script>
<script src="/final/Highcharts/js/highcharts.js"></script>
<script src="/final/Highcharts/js/modules/exporting.js"></script>
<script src="../reporter/scripts/ErHighChart_builder.js"></script>


<%
	String isSubmit = (request.getParameter("isSubmit")!=null) ? request.getParameter("isSubmit") : "";
	String queryStr = (String)ErUtils.prepareQueryString(request.getParameterMap());
	String favoriteID =  request.getParameter("FavoriteId"); 
	String scheduleID =  request.getParameter("schedule_id"); 
	String isModifyFavorite =  request.getParameter("fromFavoriteModify");
	String isModifySchedule =  request.getParameter("fromScheduleModify");
	String erFavorite =  request.getParameter("er_favorite");
	String fromdrillHeading = request.getParameter("fromdrillHeading");
	String selectedGridColumns=request.getParameter("selectedGridColumns");//..for selected grid column
	EgReportInfo reportInfo= new EgReportInfo("manager");
	String strReportFor = request.getParameter("er_reportFor");
	String reportIniName = "";
	if(strReportFor !=null && strReportFor.equalsIgnoreCase("unregistered"))
	{
		reportIniName = "CITRIX_MACHINE_REPORT";
	}
	else if(strReportFor !=null && strReportFor.equalsIgnoreCase("maintenance"))
	{
		reportIniName = "CITRIX_MACHINE_MAINTENANCE_REPORT";
	}
	String CurrentTimePeriod = reportInfo.getValue(reportIniName, "CurrentTimePeriod");
	if(CurrentTimePeriod==null || CurrentTimePeriod.length()==0)
	{
		CurrentTimePeriod = "1 hour";
	}
	if(selectedGridColumns == null)
	{
		selectedGridColumns="0|MACHINE NAME,1|Delivery group name,2|FAILURE DATE$130,3|Failure Type$130,4|Failure Reason$130,5|Ip address$100,6|Power state$100,7|Session count$110,8|Is in maintenance mode$170,9|Machine dns name";
	}	
	String currentDateFormat = strUserDateFormat;
	String isEnableBack =  ("true".equalsIgnoreCase(request.getParameter("enableBack")))? "true" : "false";
	String isReptSubmit =  ("true".equalsIgnoreCase(request.getParameter("isReptSubmit")))? "true" : "false";
	ErUtils erUtils = new ErUtils();
%>
<script>

	var mgrDateFormat = getExtjsDateFormat('<%=currentDateFormat%>');
	var appConstants = new Object();
	appConstants.forGrdReportConfirmMsg = 'Foreground report generation will take some time Do you want to proceed?';
	appConstants.er_ViewName ='ErCitrixMachineReport.jsp';
	appConstants.servletName ='com.eg.ErUserLogonSummaryReportC';
	var title = '<%=trackerMappingInfo.getTextDescription("reporter.common.Unregister Machine Details")%>';
	appConstants.erUtils = null;
	appConstants.defaultLoadData = null;
	appConstants.LoadingMask = null;
	appConstants.appController = null;
	appConstants.appObj = null;
	appConstants.CurrentTimePeriod ='<%=CurrentTimePeriod%>';
	appConstants.favoriteID ='<%=favoriteID%>';
	appConstants.fromdrillHeading ='<%=fromdrillHeading%>';
	appConstants.scheduleID ='<%=scheduleID%>';
	appConstants.isModifyFavorite = '<%=isModifyFavorite%>';
	appConstants.isModifySchedule = '<%=isModifySchedule%>';
	appConstants.erFavorite = '<%=erFavorite%>';
	appConstants.isSubmit = '<%=isSubmit%>'
	appConstants.isReptSubmit = '<%=isReptSubmit%>'
	appConstants.queryStr = '<%=queryStr.replace("\\","\\\\")%>';
	appConstants.isEnableBack = true;
	appConstants.isShowSubmitBtn = true;
	appConstants.reportFor = '<%=strReportFor%>';
	appConstants.selectedGridColumns='<%=selectedGridColumns%>';//..
	if((appConstants.isModifyFavorite.toUpperCase() == 'YES') || (appConstants.isModifySchedule.toUpperCase() == 'YES'))
	{
		appConstants.isShowSubmitBtn = false;
	}
	if('true'=='<%=isEnableBack.toLowerCase()%>')
	{
		appConstants.isEnableBack = false;
	}
	function openInNewWin(urlQStr,fromdrillHeading) 
	{
		parent.maximizeDataWindowLightBox(urlQStr,fromdrillHeading);//this method is defined in ErReporterMenuDashBoard.jsp for loading drilldown app
	}
	function reportForHighChart(detailLineId,detailDataLine)
	{
		var lineChart = {};
		lineChart = jQuery.extend(true, {}, getHighChartsInstance(detailLineId,"",""), lineChart);
		lineChart.setData(detailDataLine,'<%=currentDateFormat%>','');
		lineChart.drawChart();		
	}
</script>
<egui:loadApp baseDir="/final/reporter/scripts" appName="CitrixMachineReportApp" appFile="app.js"/>
<script>
	Ext.onReady(function(){
		Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
	});
</script>
<%
	if(strSkin!=null && strSkin.equalsIgnoreCase("Light"))
	{
%>
		<link rel="stylesheet" href="/final/reporter/styles/userSessionView_light.css"/>
<%
	}
	else
	{
%>
		<link rel="stylesheet" href="/final/reporter/styles/userSessionView_dark.css"/>
<%
	}
%>
</head>
</html>