 <%@ include file="ErReporterTracker.jsp"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgReportInfo"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import = "org.json.simple.JSONObject"%>
<%@ page import = "org.json.simple.JSONArray"%>

<%!
	private static final String BLANK_SPACE = " ";
	private static final String COMA = ",";
	private static final String COLON = ":";
	private static final String PIE = "|";
	private static final String BSLASH = "/";
	private static final String UTF_8 = "UTF-8";
	private static final String NODATAFOUND = "NO_DATA_FOUND";
	private static final String MANAGER = "manager"; 
	private static final String INFRASTRUCTURE_HEALTH_REPORT = "INFRASTRUCTURE_HEALTH_REPORT";
	private static final String HEALTHREPORT_MEASURE_MAPPING = "HEALTHREPORT_MEASURE_MAPPING";
%>
<%
try {
	response.setContentType("application/json");
	JSONObject popUpDetails=new JSONObject();
	
	EgReportInfo reportInfo = new EgReportInfo(MANAGER);
	EgDbInfo dbInfo = new EgDbInfo(MANAGER);
	ErEsxVMutils erEsxUtils = new ErEsxVMutils();
	ErUtils erUtils = new ErUtils();
	String language = thisuser.getLanguage();
	EgMappingInfo intlmap = new EgMappingInfo(language);
	String criteria = request.getParameter("er_criteria");
	String er_healthSummary = request.getParameter("er_healthSummary");
	String componentType = request.getParameter("er_comptype");
	String er_option = request.getParameter("er_option");
	String er_includeZone = request.getParameter("er_includeZone");
	String displayName = request.getParameter("tierName");
	String component = request.getParameter("component");
	String popUpHeader = request.getParameter("popUpHeader");
	popUpHeader = erUtils.specialCharDecode(popUpHeader);  //..prakash 
	popUpDetails.put("popUpHeader",popUpHeader);
	boolean includeZone = false;
	if (er_includeZone != null && er_includeZone.equalsIgnoreCase("yes"))
		includeZone = true;
	EgTablesInfo tablesInfo = new EgTablesInfo(MANAGER);
	String testMeasureDetails = reportInfo.getValue("HEALTHREPORT_MEASURE_MAPPING",criteria);
	if(testMeasureDetails == null || testMeasureDetails.length()==0)
	{
		ArrayList aListLayerTest = tablesInfo.getTestsForLayer (criteria,componentType);
		for (int m=0; m<aListLayerTest.size();m++ )
		{
			if(testMeasureDetails == null || testMeasureDetails.length() ==0)
				testMeasureDetails = (String) aListLayerTest.get(m);
			else
				testMeasureDetails +=","+(String) aListLayerTest.get(m);
		}
		displayName = intlmap.getLayerDescription(criteria);
	}
	if (er_healthSummary != null && er_healthSummary.equalsIgnoreCase("At Server Level"))
	{
		if (criteria.indexOf("#$#") != -1){
			displayName = criteria.substring(criteria.indexOf("#$#")+3);
			criteria = criteria.substring(0,criteria.indexOf("#$#"));
		} else {
			if(testMeasureDetails.indexOf("#$#") != -1)
				displayName =testMeasureDetails.substring(0,testMeasureDetails.indexOf("#$#"));
		}
	}
	List componentList = erEsxUtils.getEsxElements(thisuser,componentType,er_option,includeZone,"");
	Map resultMap = (HashMap) session
				.getAttribute("INFRASTRUCTURE_HEALTH_REPORT");
	//ErUtils erUtils = new ErUtils();
	Long reportDurationObj = (Long) resultMap.get("Total_report_Duration");
	long reportDuration = 1;
	if (reportDurationObj != null)
		reportDuration = reportDurationObj.longValue();
	//System.out.println("displayName ************************* :"+displayName);
	String header = displayName+" - "+ intlmap.getComponentTypeDescription(componentType);
	if (er_healthSummary != null && er_healthSummary.equalsIgnoreCase("At Server Level")){
		if(component.endsWith(":NULL"))
			component=component.substring(0,component.lastIndexOf(":"));
		header += " - " + component;
	}
		JSONObject rowObj;
		JSONArray rowArray;
		JSONObject colObj;
		JSONArray popUpTableData=new JSONArray();
		
			StringTokenizer st = new StringTokenizer(testMeasureDetails,",");
			boolean showInfos = false;
			while(st.hasMoreTokens())
			{
				String test = st.nextToken();
				if (test.indexOf("##") != -1){
					showInfos = true;
				}
			}
			st = new StringTokenizer(testMeasureDetails,",");
			if (st.hasMoreTokens()){
 				
				 colObj=new JSONObject();
				 colObj.put("c1",intlmap.getTextDescription("reporter.common.Test"));
				 colObj.put("c2",intlmap.getTextDescription("reporter.common.Measure"));
				 colObj.put("c4",intlmap.getTextDescription("reporter.common.Health(%)"));
		
			if (showInfos){ 
			colObj.put("c3",intlmap.getTextDescription("reporter.common.Descriptor"));
		 } 
				st = new StringTokenizer(testMeasureDetails,",");
				
				while(st.hasMoreTokens())
				{
					rowArray=new JSONArray();
					String testIndex=null;
					String test = st.nextToken();
					String info = "-";
					boolean testFlag = true;
					int testRowCount = 0;
 					if (test.indexOf("##") != -1){
						info = test.substring(test.indexOf("##")+2);
						test = test.substring(0,test.indexOf("##"));
					}
					if (test.indexOf("#$#") != -1)
						test = test.substring(test.indexOf("#$#")+3);
					List measureList = new ArrayList();
					if (test.indexOf(":") != -1){
						String measure = test.substring(test.indexOf(":")+1);
						measureList.add(measure);
						test = test.substring(0,test.indexOf(":"));
					}else{
						String[] measure = dbInfo.getMeasurementsForTest(test);
						measureList = Arrays.asList(measure);
					}
					testRowCount = measureList.size();
					for(int i=0; i<measureList.size(); i++){
						rowObj=new JSONObject();
						String measure = (String) measureList.get(i);
			
						if (testFlag) {
						testFlag = false;
						testIndex=intlmap.getTestDescription(test);
						}
						rowObj.put("measure",intlmap.getMeasureDescription(test,measure) );

						if (showInfos){ 
						rowObj.put("info",info);

						}
						double health  = 100;
						String healthStr  =erUtils.round(100,2);
						String measureKey = componentType + "|" + criteria + "|" + test + "|" + measure;
						if (resultMap.containsKey(measureKey)){
							Long healthValue = (Long) resultMap.get(measureKey);
							long healthDuration = healthValue.longValue();
							if ( healthDuration > 0) {
							healthDuration = reportDuration/ healthDuration;
							healthStr = erUtils.round(healthDuration,2);
							}

						}
						rowObj.put("health",healthStr);	   
						rowArray.add(rowObj);
					}
				 	
					JSONObject testObj=new JSONObject();
					testObj.put("test",testIndex);
					testObj.put("array",rowArray);
					popUpTableData.add(testObj);    
					
				}  
				 popUpDetails.put("dataColumn",colObj);
				popUpDetails.put("dataHeader",header);
				popUpDetails.put("tableData",popUpTableData);	 
			} else {
					 JSONObject testObj=new JSONObject();
					testObj.put("noTestConfigured","No tests configured for this layer");
					//popUpTableData.add(testObj);
					popUpDetails.put("tableData",testObj); 

			}
		
 //System.out.println("popUpDetails=="+popUpDetails);
 out.println(popUpDetails);
} catch(Exception e) {
	e.printStackTrace();
}
%>