<%
/*******************************************************************************
*	File name		:	ErCrashFault.jsp
*	Purpose			:	Displays the Citrix capacity summary report
*	Version			:	7.0
*	Author			:	Ganesh P
*	Creation Date	:	15/Nov/2017
*******************************************************************************/
%>
<%@ include file = "ErTracker.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld" %>
<html>
	<head>
		<title><egui:intnl text="reporter.common.eG Reporter"/> </title>
		<egui:skin ui="reporter"/>
		<meta charset="utf-8">
		<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>
		<script src="/final/jquery/jquery.js"></script>
		<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
		<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
		<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
		<script src="/final/reporter/scripts/eg_DateUtil.js"></script>
		<script src="/final/reporter/scripts/er_validator.js"></script>
		<script src="../scripts/<%=script_src%>"></script>
		<script type="text/javascript" src="/final/Highcharts/js/highstock.js"></script>
		<script type="text/javascript" src="/final/Highcharts/js/modules/exporting.js"></script>
		<script src="../reporter/scripts/ErHighChart.js"></script>
		<script src="../reporter/scripts/ErHighChartBar.js"></script>
		<script src="../reporter/scripts/ErHighChartColumns.js"></script>
		<%
			String currentDateFormat = strUserDateFormat;
			String isSubmit = (request.getParameter("isSubmit")!=null) ? request.getParameter("isSubmit") : "";
			String favoriteID =  request.getParameter("FavoriteId"); 
			String scheduleID =  request.getParameter("schedule_id"); 
			String isModifyFavorite =  request.getParameter("fromFavoriteModify");
			String isModifySchedule =  request.getParameter("fromScheduleModify");
			String erFavorite =  request.getParameter("er_favorite");
			String supportedComponents = request.getParameter("supportedComponents");
			String reportType = request.getParameter("reportType");			
			String queryStr = (String)ErUtils.prepareQueryString(request.getParameterMap());	
			String compTypeMultiSelect = iniFile.getValue("Application_Logon_Failure_Report","compTypeMultiSelect");
			boolean enableMultiCompType=false;
			if(compTypeMultiSelect != "" && compTypeMultiSelect != null && compTypeMultiSelect.equalsIgnoreCase("yes"))
			{
				enableMultiCompType=true;
			}
			String isEnableBack =  ("true".equalsIgnoreCase(request.getParameter("enableBack")))? "true" : "false";
			ErUtils erUtils = new ErUtils();
			boolean customPaging = false;
			String er_rtype = "";
			String er_RmDispName = "";	
			String er_bgreportfrom = "";
			if(reportType.equalsIgnoreCase("Logon Failure"))	
			{
				customPaging = true;
				er_rtype = "LogonFailure";
				er_RmDispName = "LogonFailure";
				er_bgreportfrom= "Logon Failure";
			}				
			else if(reportType.equalsIgnoreCase("VMUnregistered"))	
			{				
				customPaging = false;
				er_rtype = "VMUnregisteredMachine";
				er_RmDispName = "VMUnregisteredMachine";
				er_bgreportfrom= "VM Unregistered Machine";
			}
		%>
		<script>
			var mgrDateFormat = getExtjsDateFormat('<%=currentDateFormat%>');
			var appConstants = new Object();
			var fromPerBtn = false;			
			var keepResult = false;
			var gridChartAry;
			appConstants.forGrdReportConfirmMsg = 'Foreground report generation will take some time Do you want to proceed?';
			appConstants.erUtils = null;
			appConstants.defaultLoadData = null;
			appConstants.LoadingMask = null;
			appConstants.appController = null;
			appConstants.appObj = null;
			appConstants.favoriteID ='<%=favoriteID%>';
			appConstants.scheduleID ='<%=scheduleID%>';
			appConstants.isModifyFavorite = '<%=isModifyFavorite%>';
			appConstants.isModifySchedule = '<%=isModifySchedule%>';
			appConstants.erFavorite = '<%=erFavorite%>';
			appConstants.isSubmit = '<%=isSubmit%>'
			appConstants.isEnableBack = true;
			appConstants.isShowSubmitBtn = true;
			appConstants.chartType='<%=BarAndPieChartType%>';
			appConstants.supportedComponents='<%=supportedComponents%>';
			appConstants.reportType='<%=reportType%>';
			appConstants.enableMultiCompType = <%=enableMultiCompType%>;
			appConstants.customPaging = <%=customPaging%>;
			appConstants.er_rtype = '<%=er_rtype%>';
			appConstants.er_RmDispName = '<%=er_RmDispName%>';
			appConstants.er_bgreportfrom = '<%=er_bgreportfrom%>';
			appConstants.queryStr = '<%=queryStr.replace("\\","\\\\")%>';
			appConstants.currentPage = 1;
			var activePage = 1;
			var gridPageSize=10;
			var subZoneLabel = '<%=trackerMappingInfo.getTextDescription("reporter.common.Sub Zone")%>';
			var excludeWeekendsLabel = '<%=trackerMappingInfo.getTextDescription("reporter.common.Exclude weekends")%>';


			if((appConstants.isModifyFavorite.toUpperCase() == 'YES') || (appConstants.isModifySchedule.toUpperCase() == 'YES'))
			{
				appConstants.isShowSubmitBtn = false;
			}
			if('true'=='<%=isEnableBack.toLowerCase()%>')
			{
				appConstants.isEnableBack = false;
			}
			function reportForHighChart(id,detailData)
			{
				var chartData = {};
				chartData = jQuery.extend(true, {}, getHighChartsBarInstance(id,"",""), chartData);
				chartData.setData(detailData,'<%=currentDateFormat%>','');
				chartData.drawChart();		
			}			
		</script>
		<egui:loadApp baseDir="/final/reporter/scripts" appName="LogonFailureApp" appFile="app.js"/>
		<script>
			Ext.onReady(function(){
				Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
				Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
				Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			});
		</script>
	</head>
</html>