<%
/**************************************************************************************************
* File name			: ErUptimeReportData.jsp
* Purpose			: Genarates Servers' Uptime Reports
* Version			: 1.0
* Creation			: 18/5/2009
* Last Modified 	:
* Author			: R.Sivakumar
**************************************************************************************************/
%>

<%@ include file = "ErReporterTracker.jsp" %>
<%@ page import="egurkha.reporter.*" %>
<%@ page import="egurkha.reporter.uptime.*" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.*" %>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import="com.eg.EgGroupInfo" %>
<%@ page import="com.eg.EgDiscInfo" %>
<%@ page import= "com.eg.EgTopoInfo" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgURLDecoder" %>
<%@ page import="com.egurkha.util.DateTimeTokenizer" %>
<%@ page import="com.egurkha.util.DateUtil" %>
<%@ page import="java.text.*" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgTestInfo"%>
<%@ page import = "com.eg.EgReportInfo"%>
<%@ page import="com.egurkha.pdfmaker.*" %>
<%@ page import="net.sf.json.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	String titleToDisplay=request.getParameter("er_RmDispName");
	JSONObject json = new JSONObject();
	String imgDivId=request.getParameter("imgDivId");
		String divQstr[]=request.getParameterValues("divQstr");

try
{
	String skinColor="";
	skinColor = thisuser.getReporterSkin();
	String selectionSortBy1=null;
	String selectionSortBy=null;
	JSONObject selectionDetailsData = new JSONObject();

	String bggroundStr = (String)request.getAttribute("bggroundStr");
	String status = (String)request.getAttribute("status");

	//Back Button - Start
	String queryString = null;

	HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
	String backQnumber = request.getParameter("backQnumber");
	String servlet2 = request.getParameter("backServletName");

	ErHelperUtils erhelputils = null;

	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);

	boolean enableBack=erhelputils.isBackButtonEnable();

	String backButtonEnable = request.getParameter("back");

	if(backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True"))
	{
		status = (String)request.getParameter("status");
		request.setAttribute("chartData",null);
		request.setAttribute("pdfData",null);
		bggroundStr = (String)request.getParameter("bggroundStr");
	}
	//Back Button - End

	ErEsxVMutils eresx = new ErEsxVMutils();

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	UBean = new ErUserData(urs,false);
	ErUserData erdata = new ErUserData(UBean.getUserId(),false); //boolean arg given to check Ent or asplite
	User this_user = UserRegistry.getInstance().getUser(session.getId());
	EgTestInfo tokInfo = new EgTestInfo("manager");
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	UserRegistry mregistry = UserRegistry.getInstance();
	User muser = mregistry.getUser(session.getId());

	EgDateInfo egDt = new EgDateInfo();
	ErUtils erUtils = new ErUtils();
	EgGroupInfo gpinfo = new EgGroupInfo();
	ErUptimeReportBean eruptime = new ErUptimeReportBean();
	String thisLanguage = ui.getDefaultLanguage();
	if (muser!=null)
	{
		String userLang = muser.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(thisuser.getLanguage());
	ErComponentsUtils compUtil = new ErComponentsUtils(thisuser.getLoginID());

	String protocol = request.getScheme();
	String font = ui.getFontName();
	String userid = UBean.getUserId();
	long msecsPerHour = (long) 1000 * 60 * 60;

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = strUserDateFormat;

	Map resultDataMap = (Map) request.getAttribute("ResultDataMap");
	EgPdfData pdfdata = (EgPdfData) request.getAttribute("Pdfdata");
	if(pdfdata !=null)
	{
		session.setAttribute(ErUptimePdfGenerator.UPTIME_REPORT,pdfdata);
	}
	session.setAttribute("uptimePrintData",resultDataMap);

	/** For Save CSV Data Format */
	List list = new LinkedList();		//Add List of Data
	Vector v_measure = new Vector();	//User ColumnName
	List list_data = new LinkedList();	//ColumnData
	Hashtable h_tabrc = new Hashtable();//SubTable Data
	Hashtable h_tab = new Hashtable();	//SunTitle with SubTable Data
	
	String er_type = request.getParameter("er_type");
	/*if(er_type == null) {
		er_type="Yes";
	}*/
	String er_show = request.getParameter("er_show");
	if(er_show == null || er_show.equals("")) {
		er_show = "%Uptime/%Downtime";
	}
	if (er_show.indexOf("|pct|")>-1)
	{
		er_show=StringUtils.replace(er_show,"|pct|","%");
	}
	String s_st_time  = request.getParameter("startdate");
	String s_en_time  = request.getParameter("enddate");
	String s_st_hr    = request.getParameter("starthr");
	String s_en_hr    = request.getParameter("endhr");
	String strmin     = request.getParameter("startmin");
	String enmin      = request.getParameter("endmin");
	String er_timeline = request.getParameter("er_timeline");
	String er_time     = request.getParameter("er_time");
	String s_inidate   = request.getParameter("inidate");
	String fromDash    = request.getParameter("isDash");
	String schedule_id = request.getParameter("schedule_id");
	String reqFromSchedule = request.getParameter("fromSchedule");
	String fromFavoriteModify = request.getParameter("fromFavoriteModify");
	String fromScheduleModify = request.getParameter("fromScheduleModify");
	String favorite_id = request.getParameter("id");
	String er_favorite = request.getParameter("er_favorite");

	String tmpCType=null;
	if(reqFromSchedule==null || reqFromSchedule.equals(""))
		reqFromSchedule = "";

	if(schedule_id==null || schedule_id.equals(""))
		schedule_id = "";

	String action = request.getParameter("OperationUptimeUIAction");
	if(action==null)
	{
		action="defaultLoad";
	}
	String stmin = "00";
	String selectedCompType="NotApplicable";
	
	String dispCsvStartDate = s_st_time+" "+s_st_hr+":"+strmin;
	String dispCsvEndDate = s_en_time+" "+s_en_hr+":"+enmin;
	if(er_timeline == null)
	{
		er_timeline="2 weeks";
	}

	Vector v_comp_popup = new Vector();
	Vector v_comp_popup_disp = new Vector();
	Vector v_option = new Vector();
	v_option.add("Zone");
	v_option.add("Segment");
	v_option.add("Service");
	v_option.add("Component");

	Vector v_site = new Vector();
	String datafrom = request.getParameter("er_dataFrom");
	if(datafrom==null)
	{
		datafrom = request.getParameter("er_datafrom");
	}
	if(datafrom == null || datafrom.equals(""))
	{
		datafrom = "Component";
	}
	String includezone = request.getParameter("er_dataZone");
	if (includezone==null || (includezone !=null && includezone.equals("")))
	{
		includezone = "yes";
	}
	String divStatus = request.getParameter("divStatus");
	String srcForImg="";
	if(divStatus==null)
	{
		divStatus="none";
	}
	if(divStatus.equals("none"))
	{
		srcForImg="../images/moreoption.png";
	}
	else if(divStatus.equals("block"))
	{
		srcForImg="../images/lessoption.png";
	}
	Vector v_zones = new Vector();
	Vector v_segment = new Vector();
	Vector v_other = new Vector();
	Vector v_comptype = new Vector();

	String s_site = request.getParameter("er_site");//site specific code
	String treeParam = request.getParameter("treeParam");
	if(treeParam!=null && treeParam.length() > 0)
	{
		s_site = treeParam;
	}
	//  for - reports by segment,Service default loading setup
	String er_service = request.getParameter("er_service");
	if(datafrom!=null && (datafrom.equalsIgnoreCase("Segment")||datafrom.equalsIgnoreCase("Service")||datafrom.equalsIgnoreCase("Zone")))
	{
		if(er_service!=null)
		{
			s_site=er_service;
		}
	}
	String s_comp = request.getParameter("er_component");
	String tempTitleStr=s_comp;
	String[] selectedCompArray = request.getParameterValues("er_component");
	String s_combination = request.getParameter("er_combination");

	EgReportInfo reportinfo = new EgReportInfo("manager");
	StringBuffer selectedCompSb = new StringBuffer();
	boolean isComponentsSelected = false;
	List selectedCompList = new ArrayList();
	if(selectedCompArray != null) {
		if(selectedCompArray.length > 0)
		{
			isComponentsSelected = true;
			for (int i = 0; i < selectedCompArray.length; i++) {
				try {
					selectedCompSb.append(","+selectedCompArray[i]);
				} catch (Exception e1) {}
			}
		}
	}
					session.setAttribute("divQstr",divQstr);
					if(datafrom!=null && datafrom.equalsIgnoreCase("Component")&& tempTitleStr!=null)
					{
						tempTitleStr=tempTitleStr.substring(0,tempTitleStr.indexOf(":"));
					}
					else if(tempTitleStr!=null)
					{
						tempTitleStr=tempTitleStr.substring(tempTitleStr.indexOf(":")+1,tempTitleStr.lastIndexOf(":"));
					}
					session.setAttribute("title_"+imgDivId,tempTitleStr);
	EgDiscInfo discInfo = new EgDiscInfo("manager");

	EgTopoInfo topoInfo = new EgTopoInfo("manager");
	Vector v_component = new Vector();
	Vector temp_component = new Vector();
	String[] reportTypes = new String[0];
	List nwDevices = discInfo.getAllNetworkDevices();
	String confrimation = reportinfo.getValue("BACKGROUND_PROCESS","NeedConfirmation");
	String strbgrepportName = reportinfo.getValue("BACKGROUND_PROCESS","EnableBackgroundReport");
	String limitforbg = reportinfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");

	String uptimeFor = reportinfo.getValue("UPTIME_REPORTS","UptimeFor");
	if(uptimeFor != null && uptimeFor.indexOf("##")!=-1) {
		StringTokenizer st = new StringTokenizer(uptimeFor, "##");
		reportTypes = new String[st.countTokens()];
		int i = 0;
		while(st.hasMoreTokens()) {
			String labelTable = st.nextToken();
			if(labelTable.indexOf("*") != -1) {
				reportTypes[i++] = labelTable.substring(0, labelTable.indexOf("*"));
			}
		}
	}
	String er_uptimetest = request.getParameter("er_uptimetest");
	if(er_uptimetest == null) {
		er_uptimetest = reportTypes[0];
	}
	String showDetails = request.getParameter("er_show_details");

	if(showDetails==null || showDetails.equals(""))
		showDetails = "No";

	String encodedShowDetails = showDetails;
	if(showDetails!=null)
		encodedShowDetails = java.net.URLEncoder.encode(showDetails);

	EgCrawler crawlerBean = new EgCrawler(new IniFile(s_iniFile_dir + "eg_topology.ini"));
	if(datafrom!=null && datafrom.equals("Service"))
	{
		v_site = erdata.getSites();
		Collections.sort(v_site,String.CASE_INSENSITIVE_ORDER);
		if(s_site != null && !s_site.equals("-1")) {
			v_component=crawlerBean.getAssociates(s_site);
		}
	
		temp_component=new Vector(v_component);
		
		//Uptime report for Server is chosen
		if(er_uptimetest.equals(reportTypes[0]))
		{
			v_component.removeAll(nwDevices);
			List listCompTypes =reportinfo.getComponent("ESX_UPTIME_REPORT",false);
			Vector tempComponent = new Vector();
			tempComponent.addAll(v_component);
			for(int i=0; i<tempComponent.size(); i++) {
				String loopComponent = (String) tempComponent.get(i);
				String loopType = loopComponent.substring(0, loopComponent.indexOf(":"));
				if(listCompTypes.contains(loopType)) {
					v_component.remove(loopComponent);
				}
			}
		} else {
			v_component.retainAll(nwDevices);
		}
		for(int i=0; i<v_component.size(); i++) {
			String loopComponent = (String) v_component.get(i);
			String loopType = loopComponent.substring(0, loopComponent.indexOf(":"));
			if(!v_comptype.contains(loopType)) {
				v_comptype.add(loopType);
			}
		}
	}
	else if(datafrom!=null && datafrom.equals("Zone"))
	{
		v_zones.add("--Default--");
		if(this_user.getZones()!=null)
			v_zones.addAll(this_user.getZones());
		Collections.sort(v_zones,String.CASE_INSENSITIVE_ORDER);
		v_site=v_zones;
		if(s_site != null && !s_site.equals("-1")) {
			if(s_site.equalsIgnoreCase("--Default--")) {
				v_component = UBean.getAllUserComponents(3);
			
				temp_component=new Vector(v_component);
				
				Vector vecRelaventcomponent =eruptime.getUptimeTestRelaventComponent(v_component,er_uptimetest);
				v_component =vecRelaventcomponent;
				Vector v_componentCorrectFormat = new Vector();
				for(int i=0; i<v_component.size(); i++) {
					String loopComponent = (String) v_component.get(i);
					String strcomptype = loopComponent.substring(0,loopComponent.lastIndexOf(":"));
					String strcompname = loopComponent.substring(loopComponent.lastIndexOf(":")+1,loopComponent.length());
					String correctFormat = strcompname + ":" + strcomptype;
					v_componentCorrectFormat.add(correctFormat);
				}
				v_component = v_componentCorrectFormat;
				for(int i=0; i<v_zones.size(); i++) {
					List v_temp = gpinfo.getAllComponentsUnderZone((String)v_zones.get(i),includezone.equalsIgnoreCase("yes"));
					v_component.removeAll(v_temp);
				}
			} else {
				v_component.addAll(gpinfo.getAllComponentsUnderZone(s_site,includezone.equalsIgnoreCase("yes")));
				temp_component=new Vector(v_component);
			}
		}
		else
		{
			if(request.getParameter("er_service")!=null)
			{
				v_component.addAll(gpinfo.getAllComponentsUnderZone(request.getParameter("er_service"),true));
			
				temp_component=new Vector(v_component);
				
			}
		}
		
		//Uptime report for Server is chosen
		if(er_uptimetest.equals(reportTypes[0]))
		{
			v_component.removeAll(nwDevices);
			List listCompTypes =reportinfo.getComponent("ESX_UPTIME_REPORT",false);
			Vector tempComponent = new Vector();
			tempComponent.addAll(v_component);
			for(int i=0; i<tempComponent.size(); i++) {
				String loopComponent = (String) tempComponent.get(i);
				String loopType = loopComponent.substring(0, loopComponent.indexOf(":"));
				if(listCompTypes.contains(loopType)) {
					v_component.remove(loopComponent);
				}
			}
		} else {
			v_component.retainAll(nwDevices);
		}

		for(int i=0; i<v_component.size(); i++) {
			String loopComponent = (String) v_component.get(i);
			String loopType = loopComponent.substring(0, loopComponent.indexOf(":"));
			if(!v_comptype.contains(loopType)) {
				v_comptype.add(loopType);
			}
		}
	}
	else if(datafrom!=null && datafrom.equals("Segment"))
	{
		v_site=erdata.getSegments();
		Collections.sort(v_site,String.CASE_INSENSITIVE_ORDER);
		if(s_site != null && !s_site.equals("-1")) {
			v_component = topoInfo.getAssociatesForSegment(s_site,2);
			if(v_component == null) {
				v_component = new Vector();
			}
			
			temp_component=new Vector(v_component);
			
			//Uptime report for Server is chosen
			if(er_uptimetest.equals(reportTypes[0]))
			{
				v_component.removeAll(nwDevices);
				List listCompTypes =reportinfo.getComponent("ESX_UPTIME_REPORT",false);
				Vector tempComponent = new Vector();
				tempComponent.addAll(v_component);
				for(int i=0; i<tempComponent.size(); i++) {
					String loopComponent = (String) tempComponent.get(i);
					String loopType = loopComponent.substring(0, loopComponent.indexOf(":"));
					if(listCompTypes.contains(loopType)) {
						v_component.remove(loopComponent);
					}
				}
			} else {
				v_component.retainAll(nwDevices);
			}
		}
		for(int i=0; i<v_component.size(); i++) {
			String loopComponent = (String) v_component.get(i);
			String loopType = loopComponent.substring(0, loopComponent.indexOf(":"));
			if(!v_comptype.contains(loopType)) {
				v_comptype.add(loopType);
			}
		}
	}
	else if(datafrom==null || (datafrom!=null && datafrom.equals("Component")))
	{
		v_component  = new Vector(UBean.getAllUserComponents(3));
		
		temp_component=new Vector(v_component);
		
		Vector v_component_copy = new Vector(v_component.size());
		List listCompTypes = reportinfo.getComponent("ESX_UPTIME_REPORT",false);
		Vector vecRelaventcomponent =eruptime.getUptimeTestRelaventComponent(v_component,er_uptimetest);
		v_component = vecRelaventcomponent;
		for(int i=0; i<v_component.size(); i++) {
			String compString = (String)v_component.get(i);
			String lastPart = compString.substring(compString.lastIndexOf(":")+1);
			String firstPart = compString.substring(0, compString.lastIndexOf(":"));;
			String strToCompare = lastPart + ":" + firstPart;

			if(nwDevices.contains(strToCompare)) {
				//Uptime report for Server is chosen
				if(!er_uptimetest.equals(reportTypes[0])) {
					v_component_copy.add(v_component.get(i));
					if(!v_comptype.contains(lastPart)) {
						v_comptype.add(lastPart);
					}
				}
			} else {
				if(er_uptimetest.equals(reportTypes[0]) && !listCompTypes.contains(lastPart)) {
					v_component_copy.add(v_component.get(i));
					if(!v_comptype.contains(lastPart)) {
						v_comptype.add(lastPart);
					}
				} // 
			} // nwDevices if block
		}
		v_component = v_component_copy;
	}
//@S This block is for uptime for services functionality.
if(er_uptimetest!=null && er_uptimetest.equalsIgnoreCase("Services") && temp_component!=null)
	{
		List serviceUptimeSupportCompType = reportinfo.getComponent("SERVICE_UPTIME_REPORT",false);
List tmp_cmps=new ArrayList();
		if(datafrom!=null && (datafrom.equals("Zone")))
		{
			if(s_site!=null && s_site.equalsIgnoreCase("--Default--")) {
				for(int i=0; i<v_zones.size(); i++) {
					List v_temp = gpinfo.getAllComponentsUnderZone((String)v_zones.get(i),includezone.equalsIgnoreCase("yes"));
					if(v_temp!=null)
						tmp_cmps.addAll(v_temp);
				}
			}
		}
			Vector vcc=new Vector(temp_component);
Vector tmpComponet=new Vector();
Vector tmpCompType=new Vector();
	for(int i=0; i<vcc.size(); i++) {
			String compString = (String)vcc.get(i);
			String strcomptype="";
			String strcompname="";
			if(datafrom!=null && (datafrom.equals("Segment")||datafrom.equals("Service")))
				{
				strcomptype=compString.substring(0,compString.indexOf(":"));
				strcompname=compString.substring(compString.indexOf(":")+1,compString.length());
				}
			else if(datafrom!=null && (datafrom.equals("Zone")))
				{
				if(s_site!=null && s_site.equalsIgnoreCase("--Default--")) {
				 strcomptype = compString.substring(compString.lastIndexOf(":")+1);
					strcompname = compString.substring(0, compString.lastIndexOf(":"));
				String correctFormat = strcomptype + ":" + strcompname;
				compString=correctFormat;
				if(tmp_cmps!=null&& tmp_cmps.contains(compString))
					continue;
				}
				else
					{
					strcomptype=compString.substring(0,compString.indexOf(":"));
				strcompname=compString.substring(compString.indexOf(":")+1,compString.length());
					}
				}
				else{
				 strcomptype = compString.substring(compString.lastIndexOf(":")+1);
				strcompname = compString.substring(0, compString.lastIndexOf(":"));
				}
			if(serviceUptimeSupportCompType.contains(strcomptype))
				{
				if(!tmpComponet.contains(compString))
					tmpComponet.add(compString);
				if(!tmpCompType.contains(strcomptype))
					{
					tmpCompType.add(strcomptype);
					}
				}
	}
v_component=tmpComponet;
v_comptype=tmpCompType;
	}

	String s_comptype = request.getParameter("er_comptype");
	Collections.sort(v_component,String.CASE_INSENSITIVE_ORDER);
	//If component type is chosen then remove the components that are not of chosen type
	if(s_comptype != null && !s_comptype.equals("-1") &&
		!s_comptype.equals("NotApplicable") && v_comptype.contains(s_comptype)) {
		List removeList = new ArrayList();
		for(int i=0; i<v_component.size(); i++) {
			String v_comp = (String)v_component.get(i);
			if(-1 == v_comp.indexOf(s_comptype)) {
				removeList.add(v_comp);
			}
		}
		v_component.removeAll(removeList);
	}
	if (!isComponentsSelected && !(v_component.isEmpty())) {
		Iterator itrComps = v_component.iterator();
		while(itrComps.hasNext())
		{
			String comp = (String) itrComps.next();
			selectedCompSb.append(","+comp);
		}
	}
	Collections.sort(v_comptype);
	ArrayList aSortedList = new ArrayList();
	for(int m=0;m<v_comptype.size();m++)
	{
		String s=(String)v_comptype.get(m);
		String component = mappingInfo.getComponentTypeDescription(s);
		aSortedList.add(component);
		Collections.sort(aSortedList,String.CASE_INSENSITIVE_ORDER);
	}
	
	if (v_comptype!=null && v_comptype.size()==1){
		s_comptype = mappingInfo.getReverseComponentTypeDescription((String)aSortedList.get(0));
	}
	if(v_comptype!=null && !v_comptype.contains(s_comptype)){
		s_comptype="-1";
	}
	Vector v_time = new Vector();
	v_time.add("00");
	v_time.add("01");
	v_time.add("02");
	v_time.add("03");
	v_time.add("04");
	v_time.add("05");
	v_time.add("06");
	v_time.add("07");
	v_time.add("08");
	v_time.add("09");
	v_time.add("10");
	v_time.add("11");
	v_time.add("12");
	v_time.add("13");
	v_time.add("14");
	v_time.add("15");
	v_time.add("16");
	v_time.add("17");
	v_time.add("18");
	v_time.add("19");
	v_time.add("20");
	v_time.add("21");
	v_time.add("22");
	v_time.add("23");

	Vector v_min = new Vector();
	v_min.add("00");
	v_min.add("05");
	v_min.add("10");
	v_min.add("15");
	v_min.add("20");
	v_min.add("25");
	v_min.add("30");
	v_min.add("35");
	v_min.add("40");
	v_min.add("45");
	v_min.add("50");
	v_min.add("55");
	v_min.add("59");

	ErReportHelper erh = new ErReportHelper();
	int maxInfo = erh.getMaxInfos("INFOS","Showtop");
	String timefrom1=(erh.getTimeFrame("TIMEFRAME","From")==null) ? "00:00" :erh.getTimeFrame("TIMEFRAME","From");
	String timeto1=(erh.getTimeFrame("TIMEFRAME","To")==null) ? "23:59" :erh.getTimeFrame("TIMEFRAME","To");
	
	String timefrom="";
	String minfrom="";
	String timeto="";
	String minto="";
	StringTokenizer st=new StringTokenizer(timefrom1,":");
	if(st.hasMoreTokens())
	{
		timefrom=st.nextToken();
		minfrom=st.nextToken();
	}
	st=new StringTokenizer(timeto1,":");
	if(st.hasMoreTokens())
	{
		timeto=st.nextToken();
		minto=st.nextToken();
	}
	String timefrom2 = request.getParameter("timefrom");
	String minfrom2 = request.getParameter("minfrom");
	String timeto2 = request.getParameter("timeto");
	String minto2 = request.getParameter("minto");

	if (timefrom2!=null)
		timefrom = timefrom2;
	if (minfrom2!=null)
		minfrom = minfrom2;
	if (timeto2!=null)
		timeto = timeto2;
	if (minto2!=null)
		minto = minto2;
	
	String excludeweekend = request.getParameter("er_excwe");
	if (excludeweekend == null || excludeweekend.equals(""))
		excludeweekend = "No";

	String Maintenance_Period = request.getParameter("er_maintenance");
	if(Maintenance_Period == null || Maintenance_Period.equals(""))
		Maintenance_Period = "No";
	String Days = (erh.getExcludeWeekends("EXCLUDE_WEEKEND","Days") == null) ? 
		"Saturday,Sunday" : erh.getExcludeWeekends("EXCLUDE_WEEKEND","Days");
	request.setAttribute("Weekends",Days);
	String returnfrom = request.getParameter("isreturn");

	//Date calculation according to time select
	String[] options = {"Any","1 day", "2 days", "3 days", "4 days", "5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
	String startDateTime = "";
	String endDateTime = "";
	String dispDate = null;
	String comFormat = null;
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		int blankSpaceIndex = er_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date today =  egDt.egetRealDate();
			endDateTime = sdf.format(today);

			long value = Integer.parseInt(er_timeline.substring(0, blankSpaceIndex));
			String unit = er_timeline.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				value *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				value *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{
				if(unit.endsWith("last")){
					//last week
					int weekCount = (int) value;
					SimpleDateFormat simpledf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
					java.util.Date currDateTime = egDt.egetRealDate();
					String currentDateTime = simpledf.format(currDateTime);
					String currentDate = currentDateTime.substring(0, currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
					String currentHr = currentDateTime.substring(currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, currentDateTime.indexOf(":"));
					String currentMin = currentDateTime.substring(currentDateTime.indexOf(":")+1, currentDateTime.lastIndexOf(":"));
					String userFormat = thisuser.getUserDateFormat();
					String curFormatDate = DateUtil.changeDateFormat(currentDate,"MM/dd/yyyy", userFormat); 
					EgTimeZoneConverter realDateTime = new EgTimeZoneConverter(curFormatDate+" "+currentHr+":"+currentMin,thisuser);
					java.util.Date realDate=new SimpleDateFormat(userFormat).parse((String) realDateTime.getDate(false));
					Calendar c = Calendar.getInstance();
					c.setTime(realDate);
					int i = c.get(Calendar.DAY_OF_WEEK) - c.getFirstDayOfWeek() * weekCount;
					int startDayCount = 7 * weekCount + (1 * (weekCount - 1));
					int lastDayCount = 6 * weekCount + (1 * (weekCount - 1));
					c.add(Calendar.DATE, - i - startDayCount);
					c.set(Calendar.HOUR, 00);
					c.set(Calendar.MINUTE, 00);
					java.util.Date start = c.getTime();
					startDateTime = new SimpleDateFormat(userFormat).format(start);
					c.add(Calendar.DATE, lastDayCount);	
					c.set(Calendar.HOUR, 23);
					c.set(Calendar.MINUTE, 00);
					java.util.Date end = c.getTime();
					endDateTime = new SimpleDateFormat(userFormat).format(end);
					System.out.println("ErUptimeReportDataJson Last Week Start Date-->"+startDateTime+ "    End Time-->"+endDateTime);
				}else{
					//weeks
					value *= (7 * 24 * 3600);
				}
			}
			else if (unit.startsWith("mo"))
			{
				if(unit.endsWith("last"))
				{//last month
					int monthCount = (int) value;
					SimpleDateFormat simpledf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
					java.util.Date currDateTime = egDt.egetRealDate();
					String currentDateTime = simpledf.format(currDateTime);
					String currentDate = currentDateTime.substring(0, currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
					String currentHr = currentDateTime.substring(currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, currentDateTime.indexOf(":"));
					String currentMin = currentDateTime.substring(currentDateTime.indexOf(":")+1, currentDateTime.lastIndexOf(":"));
					String userFormat = thisuser.getUserDateFormat();
					String curFormatDate = DateUtil.changeDateFormat(currentDate,"MM/dd/yyyy", userFormat); 
					EgTimeZoneConverter realDateTime = new EgTimeZoneConverter(curFormatDate+" "+currentHr+":"+currentMin,thisuser);
					java.util.Date realDate=new SimpleDateFormat(userFormat).parse((String) realDateTime.getDate(false));
					Calendar c = Calendar.getInstance();
					c.setTime(realDate);
					c.add(Calendar.MONTH, -monthCount);
					c.set(Calendar.DATE, 1);
					c.set(Calendar.HOUR, 00);
					c.set(Calendar.MINUTE, 00);
					java.util.Date start = c.getTime();
					startDateTime = new SimpleDateFormat(userFormat).format(start);
					Calendar c1 = Calendar.getInstance();
					c1.setTime(realDate);
					c1.add(Calendar.MONTH, -1);
					c1.set(Calendar.DAY_OF_MONTH, c1.getActualMaximum(Calendar.DAY_OF_MONTH));
					c1.set(Calendar.HOUR, 23);
					c1.set(Calendar.MINUTE, 59);
					java.util.Date end = c1.getTime();
					endDateTime = new SimpleDateFormat(userFormat).format(end);
					System.out.println("ErUptimeReportDataJson Last Month Start Date-->"+startDateTime+ "    End Time-->"+endDateTime);
				}else{
					//months
					java.util.Date dt_temp = egDt.egetRealDate();
					Calendar cal_temp = new GregorianCalendar();
					cal_temp.setTime(dt_temp);
					cal_temp.add(Calendar.HOUR_OF_DAY,0);
					java.util.Date dt_temp1 = cal_temp.getTime();
					long l_temp = dt_temp1.getTime();
					int  totalDays=24*(ErUtils.getMaxDaysInMonth());
					startDateTime = egDt.egetDate(l_temp -(long)( (value*totalDays * msecsPerHour)));
					startDateTime = DateUtil.changeDateFormat(startDateTime,"dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
				}
			}
			if (unit!=null&&!unit.startsWith("mo")&& !unit.endsWith("last"))
			{
				java.util.Date start = new java.util.Date();
				java.util.Date startTmp=new java.util.Date(endDateTime);
				start.setTime(startTmp.getTime() - (value * 1000));
				startDateTime = sdf.format(start);
			}else if (unit.endsWith("last")){
				String usrStartDateTime = startDateTime +" 00:00";
				String usrEndDateTime = endDateTime +" 23:59";
				System.out.println("ErUptimeReportDataJson User Start Date-->"+usrStartDateTime+ "    End Time-->"+usrEndDateTime);
				EgTimeZoneConverter timeZoneConverterStart = new EgTimeZoneConverter(usrStartDateTime, thisuser, true);
				startDateTime = DateUtil.changeDateFormat((String) timeZoneConverterStart.getDate(false), thisuser.getUserDateFormat(), "MM/dd/yyyy");
				startDateTime = startDateTime+" "+(String) timeZoneConverterStart.getHour()+":"+(String) timeZoneConverterStart.getMinute();
				EgTimeZoneConverter timeZoneConverterEnd = new EgTimeZoneConverter(usrEndDateTime, thisuser, true);
				endDateTime = DateUtil.changeDateFormat((String) timeZoneConverterEnd.getDate(false), thisuser.getUserDateFormat(), "MM/dd/yyyy");
				endDateTime = endDateTime +" "+(String) timeZoneConverterEnd.getHour()+":"+(String) timeZoneConverterEnd.getMinute();
				System.out.println("ErUptimeReportDataJson Manager Start Date-->"+startDateTime+ "    End Time-->"+endDateTime);
			}
		}
		if ((startDateTime != null) && (endDateTime != null))
		{
			s_inidate="MM/dd/yyyy";
			try
			{
				int shr=Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));
				int en_hr=Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
				s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_hr = String.valueOf(shr);
				s_en_hr = String.valueOf(en_hr);
			}
			catch(Exception e)
			{
				System.out.println("Eception caught :"+e);
				e.printStackTrace();
			}
		}
	}
	String disable="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		disable ="disabled";
	}
	if(er_timeline!=null&&er_timeline.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			 StrDate =df.format(new java.util.Date());
		}
		catch(Exception ee)
		{
			System.out.println("Exception is"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		if(s_st_time==null)
		{
			s_st_time=SDate;
			s_inidate="MM/dd/yyyy";
		}
		if(s_en_time==null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}
	}
%>
	<%@  include file ="ErTimeFormatJSON.jsp"%>
<%

	JSONObject hiddenParams = new JSONObject();
	JSONObject pageParams = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	String reporttype_1  =  request.getParameter("reporttype");
	String er_trgttype  =  request.getParameter("er_trgttype");
	String hiddenQryStr="er_rtype=Uptime&font="+font+"&reporttype="+reporttype_1+"&er_trgttype="+er_trgttype+"&eruserid="+userid+"&fromSchedule="+reqFromSchedule+"&schedule_id="+schedule_id+"&er_ViewName=ErUptimeReportData.jsp&er_trenddata=No&userID="+urs+"&getMaxDaysInMonth="+ErUtils.getMaxDaysInMonth()+"&forwardto=ErUptimeReportData&er_bgreportfrom=Operation_Uptime&bgenabled="+strbgrepportName+"&limitforbg="+limitforbg+"&savereport=save&servletName=com.eg.ErUptimeServletC&divStatus="+divStatus+"&inidate="+currentDateFormat;

	pageParams.put("showDetails",showDetails);
	pageParams.put("includeMaintenancePeriod",Maintenance_Period);

	json.put("timelineJSONArray",timelineComboArray);
	pageParams.put("selectedTimeline",er_timeline);
	pageParams.put("s_st_time",startDateJSON);
	pageParams.put("s_en_time",endDateJSON);
	pageParams.put("starthr",startHourJSON);
	pageParams.put("endhr",endHourJSON);
	pageParams.put("startmin",startMin);
	pageParams.put("endmin",endMin);

	String pdfStartDate = startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
	String pdfEndDate = endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;

	//User TimeZone changes
	pageParams.put("startDateForDisplay",startDateForDisplay);
	pageParams.put("startHourForDisplay",startHourForDisplay);
	pageParams.put("startMinForDisplay",startMinForDisplay);
	pageParams.put("endDateForDisplay",endDateForDisplay);
	pageParams.put("endHourForDisplay",endHourForDisplay);
	pageParams.put("endMinForDisplay",endMinForDisplay);

	hiddenParams.put("er_rtype","Uptime");
	hiddenParams.put("font",font);
	hiddenParams.put("reporttype",reporttype_1);
	hiddenParams.put("er_trgttype",er_trgttype);
	hiddenParams.put("eruserid",userid);
	hiddenParams.put("fromSchedule",reqFromSchedule);
	hiddenParams.put("schedule_id",schedule_id);
	hiddenParams.put("er_ViewName","ErUptimeReportData.jsp");
	hiddenParams.put("er_trenddata","No");
	hiddenParams.put("inidate",currentDateFormat);
	hiddenParams.put("userID",urs);
	hiddenParams.put("getMaxDaysInMonth",String.valueOf(ErUtils.getMaxDaysInMonth()));
	hiddenParams.put("er_bgreportfrom","Operation_Uptime");
	hiddenParams.put("bgenabled",strbgrepportName);
	hiddenParams.put("limitforbg",limitforbg);
	hiddenParams.put("savereport","save");
	hiddenParams.put("servletName","com.eg.ErUptimeServletC");
	hiddenParams.put("divStatus",divStatus);
	hiddenParams.put("er_usertimeline", strUsrTimeline);
	if(fromFavoriteModify!=null)
	{
		hiddenParams.put("fromFavoriteModify",fromFavoriteModify);
	}
	if(fromScheduleModify!=null)
	{
		hiddenParams.put("fromScheduleModify",fromScheduleModify);
	}
	hiddenParams.put("favorite_id", favorite_id);
	hiddenParams.put("er_favorite", er_favorite);

	String fromFavSch = request.getParameter("fromFavSch");
	if(backreqMap != null && backreqMap.size() > 0 && (request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true")) || (fromFavSch!=null && fromFavSch.equalsIgnoreCase("true")))//..
	{
		hiddenParams.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
		hiddenQryStr=hiddenQryStr+"&ID="+"backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString();
		json.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
	}
	pageParams.put("NotApplicable", mappingInfo.getTextDescription("reporter.common.Not Applicable"));
	   System.out.println("er_uptimetest___________"+er_uptimetest);
   if(!"Services".equals(er_uptimetest)){
	   System.out.println("Test Data_________er_type__"+er_type);
	
	if(er_type == null || (er_type.equalsIgnoreCase("Overview") ))
	{
		pageParams.put("selectedReportType","overview");
		pageParams.put("er_type","Overview");
	}else if( er_type == null ||  er_type.equals("Yes"))
	{
		
		pageParams.put("selectedReportType","graph");
		pageParams.put("er_type","Yes");
	}
	else
	{
		pageParams.put("selectedReportType","data");
		pageParams.put("er_type","No");
	}
	}
	else if( er_type == null ||  er_type.equals("Yes"))
	{
		pageParams.put("selectedReportType","graph");
		pageParams.put("er_type","Yes");
	}
	else
	{
		pageParams.put("selectedReportType","data");
		pageParams.put("er_type","No");
	}
	if(datafrom!=null &&  datafrom.equalsIgnoreCase("Zone")&& request.getParameter("er_service")!=null)
	{
		pageParams.put("selctedSite",request.getParameter("er_service"));
	}
	else if(datafrom!=null &&  !datafrom.equalsIgnoreCase("Component"))
	{
		if(s_site==null || s_site.equals("") || s_site.equalsIgnoreCase("null"))
		{
			pageParams.put("selctedSite","-1");
		}
		else
		{
			pageParams.put("selctedSite",s_site);
		}
	}
	if(action!=null)
	{
		if(action.equals("defaultLoad"))
		{
			screenLabels.put("reporter.common.OPERATION REPORTS",mappingInfo.getTextDescription("reporter.common.OPERATION REPORTS")+" - "+mappingInfo.getTextDescription("reporter.uptime.UPTIME"));
			screenLabels.put("reporter.common.Report Type",mappingInfo.getTextDescription("reporter.common.Report Type"));
			screenLabels.put("reporter.common.Data",mappingInfo.getTextDescription("reporter.common.Data"));
			screenLabels.put("reporter.common.Graph",mappingInfo.getTextDescription("reporter.common.Graph"));
			screenLabels.put("reporter.uptime.Uptime for",mappingInfo.getTextDescription("reporter.uptime.Uptime for"));
			screenLabels.put("uptime.Analyze by",mappingInfo.getTextDescription("uptime.Analyze by"));
			screenLabels.put("reporter.common.Show Details",mappingInfo.getTextDescription("reporter.common.Show Details"));
			screenLabels.put("reporter.comparison.Include Subzone",mappingInfo.getTextDescription("reporter.comparison.Include Subzone"));
			screenLabels.put("reporter.consolidated.Component Type",mappingInfo.getTextDescription("reporter.consolidated.Component Type"));

			JSONArray repOptions =  new JSONArray();
			JSONObject jRepObj = null;
			if(!"Services".equals(er_uptimetest)){
				jRepObj =  new JSONObject();
				jRepObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Overview"));
				jRepObj.put("valueField","overview");
				repOptions.add(jRepObj);
			}
			jRepObj =  new JSONObject();
			jRepObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Summary"));
			jRepObj.put("valueField","graph");
			repOptions.add(jRepObj);

			jRepObj =  new JSONObject();
			jRepObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Detail"));
			jRepObj.put("valueField","data");
			repOptions.add(jRepObj);

			json.put("reportOptions",repOptions);

			JSONArray yesNoOptions =  new JSONArray();
			JSONObject jYesObj =  new JSONObject();
			jYesObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Yes"));
			jYesObj.put("valueField","Yes");
			yesNoOptions.add(jYesObj);

			JSONObject jNOObj =  new JSONObject();
			jNOObj.put("displayField",mappingInfo.getTextDescription("reporter.common.No"));
			jNOObj.put("valueField","No");
			yesNoOptions.add(jNOObj);

			json.put("yesNoOptions",yesNoOptions);
			// exclude weekend option
			JSONArray excludeWeekendsCombo =  new JSONArray();
			JSONObject jYesOBJ =  new JSONObject();
			jYesOBJ.put("displayField",mappingInfo.getTextDescription("reporter.common.Yes")+" ("+Days+") ");
			jYesOBJ.put("valueField","Yes");
			excludeWeekendsCombo.add(jYesOBJ);

			JSONObject jNOOBJ =  new JSONObject();
			jNOOBJ.put("displayField",mappingInfo.getTextDescription("reporter.common.No"));
			jNOOBJ.put("valueField","No");
			excludeWeekendsCombo.add(jNOOBJ);

			json.put("excludeWeekendsCombo",excludeWeekendsCombo);
			//
			pageParams.put("selectedUptimeReportFor",er_uptimetest);
			JSONArray upTimeForComboOptions = new JSONArray();

			repOptions =  new JSONArray();
			jRepObj =  new JSONObject();
			jRepObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Greater than"));
			jRepObj.put("valueField","gt");
			repOptions.add(jRepObj);

			jRepObj =  new JSONObject();
			jRepObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Less than"));
			jRepObj.put("valueField","lt");
			repOptions.add(jRepObj);
			json.put("runningFrom",repOptions);

			repOptions =  new JSONArray();
			jRepObj =  new JSONObject();
			jRepObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Days"));
			jRepObj.put("valueField","Days");
			repOptions.add(jRepObj);

			jRepObj =  new JSONObject();
			jRepObj.put("displayField",mappingInfo.getTextDescription("reporter.common.Hours"));
			jRepObj.put("valueField","Hours");
			repOptions.add(jRepObj);
			json.put("runningFromUnit",repOptions);
			String runningDurationVal = request.getParameter("runningDurationVal");
			String runningDurationFun = request.getParameter("runningDurationFun");
			String runningDurationUnit = request.getParameter("runningDurationUnit");
			if(runningDurationVal==null)
			{
				runningDurationVal = "0";
			}
			if(runningDurationFun==null)
			{
				runningDurationFun = "gt";
			}
			if(runningDurationUnit==null)
			{
				runningDurationUnit = "Days";
			}
			pageParams.put("selectedrunningFromVal",runningDurationVal);
			pageParams.put("selectedrunningFromFun",runningDurationFun);
			pageParams.put("selectedrunningFromUnit",runningDurationUnit);
			screenLabels.put("reporter.common.Running from",mappingInfo.getTextDescription("reporter.common.Running Since"));
//
			if(er_uptimetest!=null&& er_uptimetest.equalsIgnoreCase("Services"))
			{

				JSONObject jObj = new JSONObject();
				jObj.put("displayField","Services");
				jObj.put("valueField","Services");
				upTimeForComboOptions.add(jObj);
			}
//

			else
			{

						for(int i=0; i<reportTypes.length; i++) 
						{
							String str_reportTyps="reporter.uptime."+reportTypes[i];
							JSONObject jObj = new JSONObject();
							jObj.put("displayField",mappingInfo.getTextDescription(str_reportTyps));
							jObj.put("valueField",reportTypes[i]);
							upTimeForComboOptions.add(jObj);
						}
			}
			json.put("uptimeForJSON",upTimeForComboOptions);

			pageParams.put("selectedAnalysisOption",datafrom);
			JSONArray analysisOptions = new JSONArray();

			for(int i=0; i<v_option.size(); i++)
			{
				String str_option="reporter.compliance.eventlog."+v_option.get(i);
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",mappingInfo.getTextDescription(str_option));
				jObj.put("valueField",((String)v_option.get(i)));
				analysisOptions.add(jObj);
			}

			json.put("analysisOptions",analysisOptions);

			pageParams.put("er_type",er_type);
			pageParams.put("datafrom",datafrom);
			if(datafrom!=null &&  !datafrom.equalsIgnoreCase("Component"))
			{
				JSONArray vSiteJson = new JSONArray();
				String defaultSiteText = "Please choose a " + datafrom;
			
				if(v_site != null && v_site.size() > 0)
				{
					String str_defaultSiteText =  mappingInfo.getTextDescription("reporter.uptime."+defaultSiteText);
					JSONObject jObj = new JSONObject();
					jObj.put("displayField",str_defaultSiteText);
					jObj.put("valueField","-1");
					vSiteJson.add(jObj);
					Iterator itrVSite = v_site.iterator();
					while ( itrVSite.hasNext() )
					{
						String siteName = (String) itrVSite.next();
						JSONObject jObj1 = new JSONObject();
						jObj1.put("displayField",siteName);
						jObj1.put("valueField",siteName);
						vSiteJson.add(jObj1);
					}
				}
				else
				{
					String str_defaultSiteText = mappingInfo.getTextDescription("reporter.common.Not Applicable");
					JSONObject jObj = new JSONObject();
					jObj.put("displayField",str_defaultSiteText);
					jObj.put("valueField","-1");
					vSiteJson.add(jObj);
				}
				json.put("vSiteJson",vSiteJson);
			}
				
			String str_datafrom= mappingInfo.getTextDescription("reporter.compliance.eventlog."+datafrom);
			screenLabels.put("infraType",str_datafrom);

			if(datafrom!=null && datafrom.equalsIgnoreCase("Zone"))
			{
				pageParams.put("includezone",includezone);
			}
			JSONArray vCompTypeJson = new JSONArray();
			if (v_comptype.size()==0)
			{
				String noOptionsMsg = mappingInfo.getTextDescription("reporter.common.Not Applicable");
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",noOptionsMsg);
				jObj.put("valueField","NotApplicable");
				vCompTypeJson.add(jObj);
			}
			else if (v_comptype.size()==1)
			{
				String compName =(String) v_comptype.get(0);
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",mappingInfo.getComponentTypeDescription(compName));
				jObj.put("valueField",compName);
				vCompTypeJson.add(jObj);
				selectedCompType = compName;
			}
			else 
			{
				JSONObject jObj = new JSONObject();
				jObj.put("displayField","ALL");
				jObj.put("valueField","-1");
				vCompTypeJson.add(jObj);
				if(aSortedList!=null && aSortedList.size()>0)
				{	
					for(int n=0;n<aSortedList.size();n++)
					{
						String dispValue=(String)aSortedList.get(n);
						String s = mappingInfo.getReverseComponentTypeDescription(dispValue);
						JSONObject jObj1 = new JSONObject();
						jObj1.put("displayField",dispValue);
						jObj1.put("valueField",s);
						vCompTypeJson.add(jObj1);
					}
				}
				selectedCompType = s_comptype;
			}
			json.put("vCompTypeJson",vCompTypeJson);
			
			Map compMap = new HashMap();
			for(int i=0; i<v_component.size(); i++)
			{
				String compString = (String)v_component.get(i);
				String strcompname = "";
				if(datafrom.equalsIgnoreCase("Component")) {
					strcompname=compString.substring(0,compString.indexOf(":"));
				} else {
					strcompname=compString.substring(compString.indexOf(":")+1, compString.lastIndexOf(":"));
				}
				if(!compMap.containsKey(strcompname)) {
					compMap.put(strcompname, compString);
				}
			}
			v_component = new Vector(compMap.values());
			if(datafrom.equalsIgnoreCase("Zone") || datafrom.equalsIgnoreCase("Segment") ||	  datafrom.equalsIgnoreCase("Service"))
			{
				v_component=compUtil.getIntnlSupportComponent(v_component,"#",2);//to sort and language support
			}
			else
			{
				v_component=compUtil.getIntnlSupportComponent(v_component,"#",1);//to sort and language support
			}
			String str_er_uptimetest= mappingInfo.getTextDescription("reporter.uptime." + er_uptimetest);
			screenLabels.put("testFilterLabel",str_er_uptimetest);

			JSONArray compFilterJSON = new JSONArray();
			if(v_component.size() == 0)
			{
				JSONObject jObj = new JSONObject();
				jObj.put("displayField","Not Applicable");
				jObj.put("valueField","-1");
				v_comp_popup.add("-1");
				v_comp_popup_disp.add("Applicable!");
				compFilterJSON.add(jObj);
				selectedCompSb = new StringBuffer();
			}
			for(int i=0;i<v_component.size();i++)
			{
				String str_temp=(String)v_component.get(i);
				ArrayList aListData = tokInfo.egTokenizer(str_temp,"#");
				String comp_disp=(String)aListData.get(0);
				String comp_value=(String)aListData.get(1);
				v_comp_popup.add(comp_value);
				v_comp_popup_disp.add(comp_disp);
				String 	displayComp = comp_disp.substring(0, comp_disp.indexOf(":"));
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",displayComp);
				jObj.put("valueField",comp_value);
				compFilterJSON.add(jObj);
			}
			if(selectedCompSb!=null)
			{
				String selectedComps = selectedCompSb.toString();
				if(selectedComps!=null && selectedComps.indexOf(",")==0)
					selectedComps = selectedComps.substring(1,selectedComps.length());
				pageParams.put("selectedComps",selectedComps);
			}
				JSONArray componentJSONAray = new JSONArray();
				if(datafrom!=null && datafrom.equals("Zone")&& request.getParameter("er_service")!=null)
				{
					Vector y_component = new Vector();
					for(int i=0;i<v_component.size();i++)
					{
						String str_temp=(String)v_component.get(i);
						ArrayList aListData = tokInfo.egTokenizer(str_temp,"#");
						String comp_disp=(String)aListData.get(0);
						String comp_value=(String)aListData.get(1);
						y_component.add(comp_value);
						String 	displayComp = comp_disp.substring(0, comp_disp.indexOf(":"));
						JSONObject loopJsonObj = new JSONObject();
						loopJsonObj.put("displayField",displayComp);
						loopJsonObj.put("valueField", comp_value);
						componentJSONAray.add(loopJsonObj);
					}
						pageParams.put("selectedComps",y_component);
						json.put("compFilterJSON",componentJSONAray);
				}
				else
				{
					json.put("compFilterJSON",compFilterJSON);
				}
			pageParams.put("reporter_Skin",reporter_Skin);
			screenLabels.put("reporter.comparison.Systems",mappingInfo.getTextDescription("reporter.comparison.Systems"));
			screenLabels.put("admin.common.Select",mappingInfo.getTextDescription("admin.common.Select"));
			screenLabels.put("reporter.common.Include Maintenance",mappingInfo.getTextDescription("reporter.common.Include Maintenance"));
			screenLabels.put("reporter.common.Exclude weekends",mappingInfo.getTextDescription("reporter.common.Exclude weekends"));
			pageParams.put("srcForImg",srcForImg);
			pageParams.put("Maintenance_Period",Maintenance_Period);
			pageParams.put("excludeweekend",excludeweekend);
			screenLabels.put("reporter.common.Excludes",mappingInfo.getTextDescription("reporter.common.Excludes")+" "+Days);
			screenLabels.put("reporter.uptime.Chart",mappingInfo.getTextDescription("reporter.uptime.Chart"));
			screenLabels.put("reporter.comparison.Sort by",mappingInfo.getTextDescription("reporter.comparison.Sort by"));
			screenLabels.put("reporter.comparison.Show",mappingInfo.getTextDescription("reporter.comparison.Show"));
			screenLabels.put("reporter.common.Time period",mappingInfo.getTextDescription("reporter.common.Time period"));
			screenLabels.put("reporter.common.Hrs",mappingInfo.getTextDescription("reporter.common.Hrs"));
			screenLabels.put("reporter.common.From",mappingInfo.getTextDescription("reporter.common.From"));
			screenLabels.put("reporter.common.Mins",mappingInfo.getTextDescription("reporter.common.Mins"));
			screenLabels.put("reporter.common.To",mappingInfo.getTextDescription("reporter.common.To"));
			screenLabels.put("reporter.common.Timeline",mappingInfo.getTextDescription("reporter.common.Timeline"));

			JSONArray chartOptionJSONArray =  new JSONArray();
			if(er_type == null || er_type.equals("Yes")) 
			{
				JSONObject jObj1 = new JSONObject();
				jObj1.put("displayField",mappingInfo.getTextDescription("reporter.uptime.% Uptime/% Downtime"));
				jObj1.put("valueField","%Uptime/%Downtime");
				chartOptionJSONArray.add(jObj1);

				jObj1 = new JSONObject();
				jObj1.put("displayField",mappingInfo.getTextDescription("reporter.uptime.Uptime/Downtime"));
				jObj1.put("valueField","Uptime/Downtime");
				chartOptionJSONArray.add(jObj1);

				jObj1 = new JSONObject();
				jObj1.put("displayField",mappingInfo.getTextDescription("reporter.uptime.Reboots"));
				jObj1.put("valueField","Reboots");
				chartOptionJSONArray.add(jObj1);
			}
			json.put("chartOptionJSONArray",chartOptionJSONArray);
			if(er_show!=null)
				pageParams.put("er_show",er_show);

			Vector v_sortby=new	Vector();
			v_sortby.add("Component");
			if(!er_show.equalsIgnoreCase("Reboots"))
			{
				v_sortby.add("Uptime");
				v_sortby.add("Downtime");
			}
			v_sortby.add("Reboots");

			List sortByValue = new ArrayList();
			sortByValue.add(new Integer(ErUptimeDowntimeBeanComparator.COMPONENT));
			if(!er_show.equalsIgnoreCase("Reboots"))
			{
				sortByValue.add(new Integer(ErUptimeDowntimeBeanComparator.UPTIME));
				sortByValue.add(new Integer(ErUptimeDowntimeBeanComparator.DOWNTIME));
			}
			sortByValue.add(new Integer(ErUptimeDowntimeBeanComparator.REBOOT));
			
			String sortby=request.getParameter("er_sortby");
			if (sortby==null ||	sortby.equals(""))
			{
				if(er_show.equalsIgnoreCase("Reboots")) {
					sortby=String.valueOf(ErUptimeDowntimeBeanComparator.REBOOT);
				} else {
					sortby=String.valueOf(ErUptimeDowntimeBeanComparator.DOWNTIME);
				}
			}
			JSONArray sortByJSONArray = new JSONArray();
			JSONArray sortByRebootJSONArray = new JSONArray();
			for(int n=0;n<v_sortby.size();n++)
			{
				String s=(String)v_sortby.get(n);
				String value = sortByValue.get(n).toString();
				String str_s="reporter.uptime."+s;
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",mappingInfo.getTextDescription(str_s));
				jObj.put("valueField",value);
				sortByJSONArray.add(jObj);
				if(value.equalsIgnoreCase("1") || value.equalsIgnoreCase("6"))
					sortByRebootJSONArray.add(jObj);
			}
			json.put("sortByJSONArray",sortByJSONArray);
			json.put("sortByRebootJSONArray",sortByRebootJSONArray);
			for(int i=0;i<sortByJSONArray.size();i++)
			{
				JSONObject jObj1 = (JSONObject)sortByJSONArray.get(i);
				String str=(String)jObj1.get("valueField");
				if(str.equals(sortby))
				{
					selectionSortBy=(String)jObj1.get("displayField");
				} 
			}
			selectionSortBy1=selectionSortBy;
			pageParams.put("sortby",sortby);

			String er_mode = request.getParameter("er_mode");
			boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
			if(er_mode==null || er_mode.equals(""))
			{
				if(use3DGraphs)
					er_mode="3D";
				else
					er_mode="2D";
			}
			JSONArray graphModeJsonArray = new JSONArray();

			JSONObject JSONArr_3D = new JSONObject();
			JSONArr_3D.put("displayField",mappingInfo.getTextDescription("reporter.common.3D"));
			JSONArr_3D.put("valueField","3D");
			graphModeJsonArray.add(JSONArr_3D);

			JSONObject JSONArr_2D = new JSONObject();
			JSONArr_2D.put("displayField",mappingInfo.getTextDescription("reporter.common.2D"));
			JSONArr_2D.put("valueField","2D");
			graphModeJsonArray.add(JSONArr_2D);

			json.put("graphModeJsonArray",graphModeJsonArray);
			pageParams.put("er_mode",er_mode);

			String priority=request.getParameter("er_priority");
			if(priority==null || priority.equals("")){
				//priority="TOP  - " +maxInfo;//Comment for Overview
				  priority="ALL";
			}
					
			Vector v_show=new Vector();
			v_show.add("TOP  - " +maxInfo/4);
			v_show.add("TOP  - " +maxInfo/2);
			v_show.add("TOP  - " +maxInfo);
			v_show.add("ALL");
			v_show.add("LAST  - " +maxInfo);
			v_show.add("LAST  - " +maxInfo/2);
			v_show.add("LAST  - " +maxInfo/4);

			JSONArray priorityJSONArray =  new JSONArray();
			for(int n=0;n<v_show.size();n++)
			{
				String s=(String)v_show.get(n);
				String commons="reporter.common."+s;
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",mappingInfo.getTextDescription(commons));
				jObj.put("valueField",s);
				priorityJSONArray.add(jObj);
			}
			json.put("priorityJSONArray",priorityJSONArray);
			pageParams.put("priority",priority);

			JSONArray timeJSONArray = new JSONArray();
			if(v_time!=null && !v_time.isEmpty())
			{
				Iterator itrTime = v_time.iterator();
				while(itrTime.hasNext())
				{
					String timeVal = (String)itrTime.next();
					JSONObject jObj = new JSONObject();
					jObj.put("displayField",timeVal);
					jObj.put("valueField",timeVal);
					timeJSONArray.add(jObj);
				}
			}
			json.put("timeJSONArray",timeJSONArray);
			pageParams.put("selectHrsFrom",timefrom);
			pageParams.put("selectMinsFrom",minfrom);
			pageParams.put("selectHrsTo",timeto);
			pageParams.put("selectMinsTo",minto);

			JSONArray minseJSONArray = new JSONArray();
			if(v_min!=null && !v_min.isEmpty())
			{
				Iterator itrMins = v_min.iterator();
				while(itrMins.hasNext())
				{
					String minsVal = (String)itrMins.next();
					JSONObject jObj = new JSONObject();
					jObj.put("displayField",minsVal);
					jObj.put("valueField",minsVal);
					minseJSONArray.add(jObj);
				}
			}
			json.put("minseJSONArray",minseJSONArray);
		//	ErTimeFormat.jsp
			String er_reportgenration = request.getParameter("er_reportgenration");
			if(er_reportgenration==null || er_reportgenration.equals("") || er_reportgenration.equalsIgnoreCase("null"))
			{
				pageParams.put("er_reportgenration","foreground");
			}
			else if (er_reportgenration!=null && er_reportgenration.equals("background-csv"))
			{
				pageParams.put("er_reportgenration","background-csv");
			}
			else
			{
				pageParams.put("er_reportgenration",er_reportgenration);
			}
			String bg_reportname = request.getParameter("bg_reportname");
			pageParams.put("bg_reportname",bg_reportname);
			if(bg_reportname == null)
			{
				bg_reportname = "";
			}
			if(strbgrepportName != null && strbgrepportName.equalsIgnoreCase("Yes"))
			{
				screenLabels.put("reporter.consolidated.Report Generation",mappingInfo.getTextDescription("reporter.consolidated.Report Generation"));
				screenLabels.put("reporter.consolidated.Report Name",mappingInfo.getTextDescription("reporter.consolidated.Report Name"));
				JSONArray reportGenerationJSONArray = new JSONArray();
				JSONObject jObj = new JSONObject();

				jObj = new JSONObject();
				jObj.put("displayField",strforeground);
				jObj.put("valueField","foreground");
				reportGenerationJSONArray.add(jObj);

				jObj.put("displayField",strbackground);
				jObj.put("valueField","background");
				reportGenerationJSONArray.add(jObj);
				if(er_type!=null && er_type.equals("No"))
				{
					jObj = new JSONObject();
					jObj.put("displayField","Background Save - CSV");
					jObj.put("valueField","background-csv");
					reportGenerationJSONArray.add(jObj);
				}
				json.put("reportGenerationJSONArray",reportGenerationJSONArray);
			}
			if(reqFromSchedule!=null && reqFromSchedule.equalsIgnoreCase("Yes"))
			{
				screenLabels.put("reporter.common.SAVE",mappingInfo.getTextDescription("reporter.common.SAVE"));
			}else
			{
				screenLabels.put("reporter.common.SUBMIT",mappingInfo.getTextDescription("reporter.common.SUBMIT"));
			}
			if(bggroundStr != null && !bggroundStr.equals(""))
			{
				if((status != null && status.equalsIgnoreCase("duplicate")) || (bggroundStr!=null && bggroundStr.equalsIgnoreCase("User background report generationlimit is finished")))
				{
					pageParams.put("report_generation_status","finsihed");
				}
				pageParams.put("report_generation_msg",erbgreport.getlangsupportedString(bggroundStr,bgString,urs));
				pageParams.put("report_generation_url","/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom=Operation_Uptime&userID="+urs+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
				pageParams.put("reporter.common.Click here to see a list of generated and processing reports",mappingInfo.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));
			}
		}
		else if(action.equals("loadComponents"))
		{
			if(datafrom !=null && !datafrom.equalsIgnoreCase("component"))
			{
				if(datafrom.equalsIgnoreCase("zone"))
					pageParams.put("includezone",includezone);
			
				JSONArray vCompTypeJson = new JSONArray();
				if (v_comptype.size()==0)
				{
					String noOptionsMsg = mappingInfo.getTextDescription("reporter.common.Not Applicable");
					JSONObject jObj = new JSONObject();
					jObj.put("displayField",noOptionsMsg);
					jObj.put("valueField","NotApplicable");
					vCompTypeJson.add(jObj);
				}
				else if (v_comptype.size()==1)
				{
					String compName =(String) v_comptype.get(0);
					JSONObject jObj = new JSONObject();
					jObj.put("displayField",mappingInfo.getComponentTypeDescription(compName));
					jObj.put("valueField",compName);
					vCompTypeJson.add(jObj);
					selectedCompType = compName;
				}
				else 
				{
					JSONObject jObj = new JSONObject();
					jObj.put("displayField","ALL");
					jObj.put("valueField","-1");
					vCompTypeJson.add(jObj);
					if(aSortedList!=null && aSortedList.size()>0)
					{
						for(int n=0;n<aSortedList.size();n++)
						{
							String dispValue=(String)aSortedList.get(n);
							String s = mappingInfo.getReverseComponentTypeDescription(dispValue);
							JSONObject jObj1 = new JSONObject();
							jObj1.put("displayField",dispValue);
							jObj1.put("valueField",s);
							vCompTypeJson.add(jObj1);
						}
					}
					selectedCompType = s_comptype;
				}
				json.put("vCompTypeJson",vCompTypeJson);
				
			}
			Map compMap = new HashMap();
			for(int i=0; i<v_component.size(); i++)
			{
				String compString = (String)v_component.get(i);
				String strcompname = "";
				if(datafrom.equalsIgnoreCase("Component")) {
					strcompname=compString.substring(0,compString.indexOf(":"));
				} else {
					strcompname=compString.substring(compString.indexOf(":")+1, compString.lastIndexOf(":"));
				}
				if(!compMap.containsKey(strcompname)) {
					compMap.put(strcompname, compString);
				}
			}
			v_component = new Vector(compMap.values());
			if(datafrom.equalsIgnoreCase("Zone") || datafrom.equalsIgnoreCase("Segment") ||	  datafrom.equalsIgnoreCase("Service"))
			{
				v_component=compUtil.getIntnlSupportComponent(v_component,"#",2);//to sort and language support
			}
			else
			{
				v_component=compUtil.getIntnlSupportComponent(v_component,"#",1);//to sort and language support
			}
			String str_er_uptimetest= mappingInfo.getTextDescription("reporter.uptime." + er_uptimetest);
			screenLabels.put("testFilterLabel",str_er_uptimetest);

			JSONArray compFilterJSON = new JSONArray();

			if(v_component.size() == 0)
			{
				JSONObject jObj = new JSONObject();
				jObj.put("displayField","Not Applicable");
				jObj.put("valueField","-1");
				v_comp_popup.add("-1");
				v_comp_popup_disp.add("Applicable!");
				compFilterJSON.add(jObj);
			}
			for(int i=0;i<v_component.size();i++)
			{
				String str_temp=(String)v_component.get(i);
				ArrayList aListData = tokInfo.egTokenizer(str_temp,"#");
				String comp_disp=(String)aListData.get(0);
				String comp_value=(String)aListData.get(1);
				v_comp_popup.add(comp_value);
				v_comp_popup_disp.add(comp_disp);
				String 	displayComp = comp_disp.substring(0, comp_disp.indexOf(":"));
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",displayComp);
				jObj.put("valueField",comp_value);
				compFilterJSON.add(jObj);
			}
			if(selectedCompSb!=null)
			{
				String selectedComps = selectedCompSb.toString();
				if(selectedComps!=null && selectedComps.indexOf(",")==0)
					selectedComps = selectedComps.substring(1,selectedComps.length());
				pageParams.put("selectedComps",selectedComps);
			}
					if(datafrom!=null && datafrom.equals("Zone")&& s_site!=null)
					{
						JSONArray componentJSONAray =new JSONArray();
						 Vector y_component = new Vector();
						for(int i=0;i<v_component.size();i++)
						{
							String str_temp=(String)v_component.get(i);
							ArrayList aListData = tokInfo.egTokenizer(str_temp,"#");
							String comp_disp=(String)aListData.get(0);
							String comp_value=(String)aListData.get(1);
							String tempStr = comp_value;
							tempStr = tempStr.substring(tempStr.indexOf(":") + 1)+ ":"+ tempStr.substring(0, tempStr.indexOf(":"));
							y_component.add(tempStr);
							String 	displayComp = comp_disp.substring(0, comp_disp.indexOf(":"));
							JSONObject loopJsonObj = new JSONObject();
							loopJsonObj.put("displayField",displayComp);
							loopJsonObj.put("valueField", comp_value);
							componentJSONAray.add(loopJsonObj);
						}
						pageParams.put("selectedComps::jj:",y_component);
						json.put("compFilterJSON",componentJSONAray);
					}
					else
					{
						json.put("compFilterJSON",compFilterJSON);
					}
		}
	}
	String isSubmit = request.getParameter("isSubmit");
	if(isSubmit != null && isSubmit.equalsIgnoreCase("true"))
	{
		if(datafrom == null || datafrom.equals(""))
		{
			datafrom = "Component";
		}
		if (excludeweekend == null || excludeweekend.equals(""))
			excludeweekend = "No";

		dispCsvStartDate = s_st_time+" "+s_st_hr+":"+strmin;
		dispCsvEndDate = s_en_time+" "+s_en_hr+":"+enmin;

		String bckGrdSaveMsg = "";
		String bckGrdSaveURL = "";
		String er_sortby =request.getParameter("er_sortby");// selectionSortBy;//

		if(bggroundStr != null && !bggroundStr.equals(""))
		{
			if((status != null && (status.equalsIgnoreCase("duplicate")) || (bggroundStr!=null && bggroundStr.equalsIgnoreCase("User background report generationlimit is finished"))))
			{
				pageParams.put("bgGroundMsg","User background report generationlimit is finished");
			}
			bckGrdSaveMsg=erbgreport.getlangsupportedString(bggroundStr,bgString,urs);
			String bglinkMsg=mappingInfo.getTextDescription("reporter.common.Click here to see a list of generated and processing reports");
			bckGrdSaveURL="/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom=Operation_Uptime&userID="+urs+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess";

			pageParams.put("bckGrdSaveMsg",bckGrdSaveMsg);
			pageParams.put("status",status);
			pageParams.put("bckGrdSaveURL",bckGrdSaveURL);
			pageParams.put("bglinkMsg",bglinkMsg);
			pageParams.put("currentDateFormat",currentDateFormat);
			pageParams.put("er_type",er_type);
		}
			screenLabels.put("reporter.common.No measures available for the current selection",mappingInfo.getTextDescription("reporter.common.No measures available for the current selection"));

			queryString = ErUtils.prepareQueryString(request.getParameterMap());
			screenLabels.put("selectionDetailsTitle",mappingInfo.getTextDescription("reporter.uptime.Selection Details of Uptime Report for"+" "+er_uptimetest));

			selectionDetailsData.put(mappingInfo.getTextDescription("reporter.uptime.Analyze by"),datafrom);
			String displaySelectionCompType = s_comptype;
			if(displaySelectionCompType!=null && displaySelectionCompType.equals("-1"))
				displaySelectionCompType = "ALL";
			selectionDetailsData.put(mappingInfo.getTextDescription("reporter.consolidated.Component Type"),mappingInfo.getComponentTypeDescription(displaySelectionCompType));
			
			selectionDetailsData.put(mappingInfo.getTextDescription("reporter.comparison.Sort by"),selectionSortBy1);
			selectionDetailsData.put(mappingInfo.getTextDescription("reporter.common.Exclude weekends"),excludeweekend);

            selectionDetailsData.put(mappingInfo.getTextDescription("reporter.common.Time Period"),"<span class='font_bold'> </span>  " +timefrom2+":"+minfrom2+"<span class='font_bold'>  "+mappingInfo.getTextDescription("reporter.common.to")+" </span>  "+timeto2+":"+minto2);

			selectionDetailsData.put(mappingInfo.getTextDescription("reporter.common.Timeline"),
			"<span class='font_bold'> </span> " +pdfStartDate+" "+mappingInfo.getTextDescription("reporter.common.hrs")+
			" <span class='font_bold'>"+mappingInfo.getTextDescription("reporter.common.to")+
			"</span> "+pdfEndDate+" "+mappingInfo.getTextDescription("reporter.common.hrs"));

			String detailsTitle = "";
			if(er_show!=null && er_show.equalsIgnoreCase("Reboots"))
			{
				detailsTitle = er_uptimetest + " Reboots";
			}
			else
			{
				detailsTitle = er_uptimetest + " Uptime/Downtime";
			}
			if(er_type == null || er_type.equals("Yes")) {
				detailsTitle += " Summary";
			} else if(er_type != null && er_type.equals("No")) {
				detailsTitle += " Detail";
			}else if (er_type != null && er_type.equalsIgnoreCase("overview")){
				detailsTitle += " _Report";
			}
			String detailsSubTitle = "";
			String detailsSubTitle1 = "";
			String detailsSubTitle2 = "";
			String detailsSubTitle3 = "";
			if(!datafrom.equals("Component")) {
				detailsTitle += " for";
				detailsSubTitle = s_site;
				detailsSubTitle1 = datafrom;
			}

			if(s_comptype != null && !s_comptype.equals("-1") && !s_comptype.equals("NotApplicable")) {
						detailsSubTitle2 = " - ";
						detailsSubTitle3 = mappingInfo.getComponentTypeDescription(s_comptype);
					}

			if(er_type == null || er_type.equals("No"))
			{
				screenLabels.put("Details_Table_Title",mappingInfo.getTextDescription("reporter.uptime." + detailsTitle)+" "+( detailsSubTitle1==""?"":mappingInfo.getTextDescription("reporter.uptime." +detailsSubTitle1))+" "+(detailsSubTitle3 == "" ? "" : detailsSubTitle2)+" "+(detailsSubTitle3!=null?detailsSubTitle3:""));
			}
			else if(er_type != null && er_type.equals("Yes"))
			{
				String detailTableTile = mappingInfo.getTextDescription("reporter.uptime." + detailsTitle)+" "+detailsSubTitle+" "+( detailsSubTitle1==""?"":mappingInfo.getTextDescription("reporter.uptime." + detailsSubTitle1))+" "+(detailsSubTitle3 == "" ? "" : detailsSubTitle2)+" "+(detailsSubTitle3!=null?detailsSubTitle3:"");

                         	screenLabels.put("Details_Table_Title",detailTableTile);
			}else if("overview".equals(er_type)){
               screenLabels.put("Details_Table_Title",mappingInfo.getTextDescription("reporter.uptime.Overview Data"));
			}

			json.put("selectionDetailsData",selectionDetailsData);
			if(isSubmit != null && isSubmit.equalsIgnoreCase("true")&& (bggroundStr == null || bggroundStr != null && bggroundStr.equals(""))) 
			{
				HashMap resultMap = (HashMap)request.getAttribute("ResultDataMap");
				session.setAttribute("ResultVal",resultMap);
				List uptimeList = null;
				if(resultMap != null)
				{
					uptimeList = (List)resultMap.get("COMPONENT_LIST");
				}
				if(resultMap !=null && uptimeList != null && uptimeList.size() > 0)
				{
					if(er_type == null || er_type.equals("No"))
					{
						screenLabels.put("Uptime_for",mappingInfo.getTextDescription("reporter.uptime." + er_uptimetest));
						screenLabels.put("reporter.uptime.Uptime",mappingInfo.getTextDescription("reporter.uptime.Uptime"));
						screenLabels.put("reporter.uptime.yMdhm",mappingInfo.getTextDescription("reporter.uptime.yMdhm"));
						screenLabels.put("reporter.uptime.% Uptime",mappingInfo.getTextDescription("reporter.uptime.% Uptime"));
						screenLabels.put("reporter.uptime.% Downtime",mappingInfo.getTextDescription("reporter.uptime.% Downtime"));
						screenLabels.put("reporter.uptime.Reboots",mappingInfo.getTextDescription("reporter.uptime.Reboots"));
						screenLabels.put("reporter.uptime.Details",mappingInfo.getTextDescription("reporter.uptime.Details"));
						screenLabels.put("reporter.uptime.Downtime",mappingInfo.getTextDescription("reporter.uptime.Downtime"));
						screenLabels.put("reporter.uptime.y - year, M - month, d - day, h - hour, m - min",mappingInfo.getTextDescription("reporter.uptime.y - year, M - month, d - day, h - hour, m - min"));

						screenLabels.put("reporter.uptime.Server",mappingInfo.getTextDescription("reporter.uptime.Server"));
						screenLabels.put("reporter.uptime.Running since",mappingInfo.getTextDescription("reporter.uptime.Running since"));
						
						screenLabels.put("reporter.uptime.Uptime",mappingInfo.getTextDescription("reporter.uptime.Uptime"));

						screenLabels.put("reporter.uptime.Uptime (yMdhm)","("+mappingInfo.getTextDescription("reporter.uptime.yMdhm")+")*");



						screenLabels.put("reporter.uptime.% Uptime",mappingInfo.getTextDescription("reporter.uptime.% Uptime"));

						screenLabels.put("reporter.uptime.Downtime",mappingInfo.getTextDescription("reporter.uptime.Downtime"));

						screenLabels.put("reporter.uptime.Downtime (yMdhm)","("+mappingInfo.getTextDescription("reporter.uptime.yMdhm")+")*");



						screenLabels.put("reporter.uptime.% Downtime",mappingInfo.getTextDescription("reporter.uptime.% Downtime"));
						screenLabels.put("reporter.uptime.Reboots",mappingInfo.getTextDescription("reporter.uptime.Reboots"));
						screenLabels.put("reporter.uptime.Services",mappingInfo.getTextDescription("reporter.uptime.Servers"));
						if (!StringUtils.isNull(titleToDisplay)){ 
							list.add(titleToDisplay);
						}
						else
						{
							list.add(mappingInfo.getTextDescription("reporter.common.OPERATION REPORT")+" - "+mappingInfo.getTextDescription("reporter.uptime.UPTIME REPORT"));
						}
						Vector v_date = new Vector();
						v_date.add("\""+mappingInfo.getTextDescription("reporter.common.Start Date")+" : "+pdfStartDate+"\"");
						v_date.add("\""+mappingInfo.getTextDescription("reporter.common.End Date")+" : "+pdfEndDate+"\"");
						String csv_wk="";
						if(excludeweekend!=null && excludeweekend.equalsIgnoreCase("Yes"))
							 csv_wk=mappingInfo.getTextDescription("reporter.common.Exclude weekends")+" : " +Days;
						v_date.add('"'+csv_wk+'"');
						list.add(v_date);

						String s_title = "";		
						s_title = mappingInfo.getTextDescription("reporter.uptime. Uptime Report")+detailsSubTitle+mappingInfo.getTextDescription("reporter.uptime. Uptime Report "+detailsSubTitle1)+detailsSubTitle2+" "+mappingInfo.getComponentTypeDescription(detailsSubTitle3);
						
						if(er_uptimetest!=null && er_uptimetest.equalsIgnoreCase("Services"))
						{
							s_title=tempTitleStr;
							v_measure.add(mappingInfo.getTextDescription("reporter.uptime.Servers"));
							v_measure.add(mappingInfo.getTextDescription("reporter.uptime.Uptime (yMdhm)"));
							v_measure.add(mappingInfo.getTextDescription("reporter.uptime.% Uptime"));
							v_measure.add(mappingInfo.getTextDescription("reporter.uptime.Downtime (yMdhm)"));
							v_measure.add(mappingInfo.getTextDescription("reporter.uptime.% Downtime"));
						}
						else
						{
							v_measure.add(mappingInfo.getTextDescription("reporter.uptime.Server"));
							if(er_uptimetest!=null && er_uptimetest.equalsIgnoreCase("Systems"))
							{
								v_measure.add(mappingInfo.getTextDescription("reporter.uptime.Running since"));
							}
							v_measure.add(mappingInfo.getTextDescription("reporter.uptime.Uptime (yMdhm)"));
							v_measure.add(mappingInfo.getTextDescription("reporter.uptime.% Uptime"));
							v_measure.add(mappingInfo.getTextDescription("reporter.uptime.Downtime (yMdhm)"));
							v_measure.add(mappingInfo.getTextDescription("reporter.uptime.% Downtime"));
							v_measure.add(mappingInfo.getTextDescription("reporter.uptime.Reboots"));
						}

						JSONArray tableData = new JSONArray();
						if(uptimeList !=null)
						{
							for(int i=0; i<uptimeList.size(); i++)
							{
								ErUptimeDowntimeBean uptimeBean = (ErUptimeDowntimeBean) uptimeList.get(i);
								String sUpTime = uptimeBean.getUpTime();
								list_data.add(uptimeBean.getComponent());
								if(er_uptimetest!=null && er_uptimetest.equalsIgnoreCase("Systems"))
								{
									list_data.add(getDisplayString(uptimeBean.getRunningSince(), "0"));
								}
								list_data.add(getDisplayString(uptimeBean.getUpTime(), "0"));
								list_data.add(uptimeBean.getPerUpTime());
								list_data.add(getDisplayString(uptimeBean.getDownTime(), "0"));
								list_data.add(uptimeBean.getPerDownTime());
								String sNoOfReboots = "-";
								if (sUpTime.equals("-")) {
										if(er_uptimetest!=null && !er_uptimetest.equalsIgnoreCase("Services"))
									list_data.add(sNoOfReboots);
								} else {
										if(er_uptimetest!=null && !er_uptimetest.equalsIgnoreCase("Services"))
									list_data.add(uptimeBean.getNoOfReboots()+"");
									sNoOfReboots = uptimeBean.getNoOfReboots()+"";
								}

								JSONObject trData = new JSONObject();

								trData.put("component",uptimeBean.getComponent());
								trData.put("runningSince",getDisplayString(uptimeBean.getRunningSince(), "0"));
								trData.put("uptime",getDisplayString(uptimeBean.getUpTime(), "0"));
								trData.put("uptimePercent",uptimeBean.getPerUpTime());
								trData.put("downTime",getDisplayString(uptimeBean.getDownTime(), "0"));
								trData.put("downTimePercent",uptimeBean.getPerDownTime());
								trData.put("reBoots",sNoOfReboots);
								if(!sNoOfReboots.equals("-") && uptimeBean.isShowDetails())
								{
									String detailsLinkUrl ="";
									if(er_uptimetest!=null && er_uptimetest.equalsIgnoreCase("Services"))
									{
									 detailsLinkUrl = "/final/reporter/ErServiceDownDetails.jsp?option=data&er_rtype=Uptime&component="+uptimeBean.getComponent()+"&startdate="+s_st_time+"&enddate="+s_en_time+"&timefrom="+timefrom2+"&minfrom="+minfrom2+"&timeto="+timeto2+"&minto="+minto2+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&stmin="+strmin+"&enmin="+enmin+"&er_timeline="+er_timeline+"&startmin="+strmin+"&endmin="+enmin+"&er_component="+s_comp+"&er_datafrom="+datafrom+"&imgDivId="+imgDivId;
									}
									else
									{
									 detailsLinkUrl = "/final/reporter/ErRebootDetails.jsp?option=data&er_rtype=Uptime&component="+uptimeBean.getComponent()+"&startdate="+s_st_time+"&enddate="+s_en_time+"&timefrom="+timefrom2+"&minfrom="+minfrom2+"&timeto="+timeto2+"&minto="+minto2+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&stmin="+strmin+"&enmin="+enmin+"&er_timeline="+er_timeline+"&startmin="+strmin+"&endmin="+enmin;
									}
									/*String detailsLinkUrl = "/final/reporter/ErRebootDetails.jsp?option=data&er_rtype=Uptime&component="+uptimeBean.getComponent()+"&startdate="+s_st_time+"&enddate="+s_en_time+"&timefrom="+timefrom2+"&minfrom="+minfrom2+"&timeto="+timeto2+"&minto="+minto2+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&stmin="+strmin+"&enmin="+enmin+"&er_timeline="+er_timeline+"&startmin="+strmin+"&endmin="+enmin;*/
											//com.eg.EgURLEncoder.encode(uptimeBean.getComponent(), "UTF-8")
									trData.put("detailsLink",detailsLinkUrl);
								}
								else
								{
									trData.put("detailsLink","NOLINK");
								}
								tableData.add(trData);
							}
						}
						h_tabrc.put(v_measure,list_data);
						h_tab.put(s_title,h_tabrc);
						list.add(h_tab);
						list_data.add("\n");
						v_measure = new Vector();
						list_data = new LinkedList();
						s_title = new String();
						h_tabrc = new Hashtable();
						h_tab = new Hashtable();
						json.put("dataTable",tableData);
						json.put("selectedReportType","Data");
					}
					if(er_type != null && er_type.equals("Yes"))
					{
						HashMap barChartParam = (HashMap) resultMap.get("SERVERS_BARCHART");
						session.setAttribute("SERVERS_BARCHART",barChartParam);
						String yAxisMinMax = ""; 
						if(barChartParam != null && !barChartParam.isEmpty())
						{
							String numberSuffix = "";
							if(er_show.equalsIgnoreCase("%Uptime/%Downtime"))
							{
								numberSuffix = "%25";
								yAxisMinMax = "yAxisMaxvalue='100' yAxisMinValue='0' numDivLines='5'";
							}
							else if(er_show.equalsIgnoreCase("Uptime/Downtime"))
							{
								numberSuffix = " sec";
							}
						// fusion chart graph starts here
							ErFusionChartBean chartbean = new ErFusionChartBean();
							IniFile eg_report = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_report.ini");
							String uptimeColor = eg_report.getValue("UPTIME_REPORTS", "FusionColorForUptime");
							if(uptimeColor == null)
							{
								uptimeColor = "";
							}
							String downtimeColor = eg_report.getValue("UPTIME_REPORTS", "FusionColorForDowntime");
							if(downtimeColor == null)
							{
								downtimeColor = "";
							}
							String rebootColor = eg_report.getValue("UPTIME_REPORTS", "FusionColorForReboot");
							if(rebootColor == null)
							{
								rebootColor = "";
							}
							String er_mode = request.getParameter("er_mode");
							boolean use3DGraphs = ui.use3DGraphs(IniUI.REPORTER);
							if(er_mode==null || er_mode.equals(""))
							{
								if(use3DGraphs)
									er_mode="3D";
								else
									er_mode="2D";
							}
							String barLabels = (String) barChartParam.get("barLabels");
							st = new StringTokenizer(barLabels, ",");
							String barwidth = "";
							String gap = "";
							int countlabels = st.countTokens();
							int heightForapplet = chartbean.getbarHeightforCount(countlabels);

							if(heightForapplet>0)
							{
								heightForapplet = (heightForapplet - (countlabels*15));
							}
							
							if(countlabels <= 4)
							{
								if(er_mode != null && er_mode.equalsIgnoreCase("3D")){
									barwidth = "50";
									gap = "12";
								}
								else{
									if(countlabels == 1)
										gap = "50";
									else
										gap ="2";
								}
							}
							else
							{
								if(er_mode != null && er_mode.equalsIgnoreCase("3D")){
									barwidth = "45";
									gap = "12";
								}
								else
								{
									gap = "12";
								}
							}
							pageParams.put("graphHeight",""+heightForapplet);

							JSONArray xAxisDataLabel = new JSONArray();
							JSONArray  barUptimeDataSet= new JSONArray();
							JSONArray  barDowntimeDataSet= new JSONArray();

							Vector labelList=new Vector();
							String yAxisLabel= (String) barChartParam.get("rangeAxisLabel");
							String strXML = "";
							StringBuffer sb = new StringBuffer(1024);
							sb.append("<chart plotGradientColor='' bgcolor='ffffff' palette='1' alpha='0' caption='' shownames='1' showvalues='1' numDivLines='5' divLineAlpha='60' showSum='0' placeValuesInside='1' decimals='2' overlapBars='0' showShadow='0' formatNumberScale = '0' showplotborder='0' showBorder='0' canvasborderalpha='0' showcanvasborder='0' showAlternateHGridColor='0' showAlternateVGridColor='0' divLineIsDashed='0' baseFontColor='000000' numberSuffix='" + numberSuffix + "' " + yAxisMinMax + " >");
							sb.append("<categories> ");
							
							while (st.hasMoreTokens() )
							{
								String strValue = st.nextToken();
								while(strValue.indexOf("\\n") >=0)
								{
									String Comp = strValue.substring(0,strValue.indexOf("\\n")).trim();
									String str = strValue.substring(strValue.indexOf("\\n")+2,strValue.length());
									strValue = Comp+str;
								}
								strValue = chartbean.getDisplayLabel1(strValue);
								String displayValue = strValue;
								labelList.add(displayValue);
								sb.append("<category label='"+ strValue +"' toolText='"+ displayValue +"'/> ");
								xAxisDataLabel.add(strValue);
							}
							sb.append("</categories>");
							String downtimeValues = (String) barChartParam.get("sampleValues_1");
							sb.append("<dataset seriesName='"+ (downtimeValues == null ? "Reboots" : "Uptime") +"' color='"+ (downtimeValues == null ? rebootColor : uptimeColor) +"' alpha='100' anchorAlpha='0' lineThickness='2' showAnchors='1' >");
							String uptimeValues = (String) barChartParam.get("sampleValues_0");
							st = new StringTokenizer(uptimeValues, ",");
							int i=0;
							while (st.hasMoreTokens() ){
								String strValue = st.nextToken();
									if(strValue.equalsIgnoreCase("0"))
									{
										strValue = "";
									}
									String strurl= (String) barChartParam.get("url_0_"+i);
									sb.append("<set value='"+ strValue +"' alpha='100' link='j-openInGraphWin-"+com.eg.EgURLEncoder.encode(strurl,"UTF-8")+"'/>");

								if(er_show!=null &&  er_show.equalsIgnoreCase("Uptime/Downtime"))
								{
									ErUptimeDowntimeBean uptimeBean = (ErUptimeDowntimeBean) uptimeList.get(i);
									String upTimePrecentage=uptimeBean.getPerUpTime();
									if(strValue.length()==0)
									{
										strValue = "0";
										JSONObject obj = new JSONObject();
										obj.put("name",labelList.get(i));
										obj.put("y",Double.valueOf(strValue));
										obj.put("url",strurl);
										JSONObject dataLabelObj = new JSONObject();
										dataLabelObj.put("enabled",false);
										obj.put("dataLabels",dataLabelObj);
										barUptimeDataSet.add(obj);
									}
									else if(Double.valueOf(upTimePrecentage)<13)
									{
										JSONObject obj = new JSONObject();
										obj.put("name",labelList.get(i));
										obj.put("y",Double.valueOf(strValue));
										obj.put("url",strurl);
										JSONObject dataLabelObj = new JSONObject();
										dataLabelObj.put("enabled",false);
										obj.put("dataLabels",dataLabelObj);
										barUptimeDataSet.add(obj);
									}
									else
									{
										JSONObject obj = new JSONObject();
										obj.put("name",labelList.get(i));
										obj.put("y",Double.valueOf(strValue));
										obj.put("url",strurl);
										barUptimeDataSet.add(obj);
									}

								}
								else
								{
									if(strValue.length()==0)
									{
										strValue = "0";
										JSONObject obj = new JSONObject();
										obj.put("name",labelList.get(i));
										obj.put("y",Double.valueOf(strValue));
										obj.put("url",strurl);
										JSONObject dataLabelObj = new JSONObject();
										dataLabelObj.put("enabled",false);
										obj.put("dataLabels",dataLabelObj);
										barUptimeDataSet.add(obj);
									}
									else if(Double.valueOf(strValue)<13)
									{
										JSONObject obj = new JSONObject();
										obj.put("name",labelList.get(i));
										obj.put("y",Double.valueOf(strValue));
										obj.put("url",strurl);
										JSONObject dataLabelObj = new JSONObject();
										dataLabelObj.put("enabled",false);
										obj.put("dataLabels",dataLabelObj);
										barUptimeDataSet.add(obj);
									}
									else
									{
										JSONObject obj = new JSONObject();
										obj.put("name",labelList.get(i));
										obj.put("y",Double.valueOf(strValue));
										obj.put("url",strurl);
										barUptimeDataSet.add(obj);
									}
								}
								i++;
							}
							sb.append( "</dataset>");
							if(downtimeValues != null)
							{
								sb.append("<dataset seriesName='Downtime'  color='" + downtimeColor + "' alpha='100' anchorAlpha='0' lineThickness='2' showAnchors='1' >");
								st = new StringTokenizer(downtimeValues, ",");
								i = 0;
								while (st.hasMoreTokens())
								{
									String strValue = st.nextToken();
										if(strValue.equalsIgnoreCase("0"))
										{
										strValue = "";
										}
										String strurl= (String) barChartParam.get("url_1_"+i);
										sb.append("<set value='"+ strValue +"' alpha='100' link='j-openInGraphWin-"+com.eg.EgURLEncoder.encode(strurl,"UTF-8")+"'/>");

										if(er_show!=null &&  er_show.equalsIgnoreCase("Uptime/Downtime"))
										{
										ErUptimeDowntimeBean uptimeBean = (ErUptimeDowntimeBean) uptimeList.get(i);
										String downTimePrecentage=uptimeBean.getPerDownTime();
											if(strValue.length()==0)
											{
												strValue = "0";
												JSONObject obj = new JSONObject();
												obj.put("name",labelList.get(i));
												obj.put("y",Double.valueOf(strValue));
												obj.put("url",strurl);
												JSONObject dataLabelObj = new JSONObject();
												dataLabelObj.put("enabled",false);
												obj.put("dataLabels",dataLabelObj);
												barDowntimeDataSet.add(obj);
											}
											else if(Double.valueOf(downTimePrecentage)<13)
											{
												JSONObject obj = new JSONObject();
												obj.put("name",labelList.get(i));
												obj.put("y",Double.valueOf(strValue));
												obj.put("url",strurl);
												JSONObject dataLabelObj = new JSONObject();
												dataLabelObj.put("enabled",false);
												obj.put("dataLabels",dataLabelObj);
												barDowntimeDataSet.add(obj);
											}
											else
											{
												JSONObject obj = new JSONObject();
												obj.put("name",labelList.get(i));
												obj.put("y",Double.valueOf(strValue));
												obj.put("url",strurl);
												barDowntimeDataSet.add(obj);
											}
										}
										else
										{					   
											if(strValue.length()==0)
											{
												strValue = "0";
												JSONObject obj = new JSONObject();
												obj.put("name",labelList.get(i));
												obj.put("y",Double.valueOf(strValue));
												obj.put("url",strurl);
												JSONObject dataLabelObj = new JSONObject();
												dataLabelObj.put("enabled",false);
												obj.put("dataLabels",dataLabelObj);
												barDowntimeDataSet.add(obj);
											}
											else if(Double.valueOf(strValue)<13)
											{
												JSONObject obj = new JSONObject();
												obj.put("name",labelList.get(i));
												obj.put("y",Double.valueOf(strValue));
												obj.put("url",strurl);
												JSONObject dataLabelObj = new JSONObject();
												dataLabelObj.put("enabled",false);
												obj.put("dataLabels",dataLabelObj);
												barDowntimeDataSet.add(obj);
											}
											else
											{
												JSONObject obj = new JSONObject();
												obj.put("name",labelList.get(i));
												obj.put("y",Double.valueOf(strValue));
												obj.put("url",strurl);
												barDowntimeDataSet.add(obj);
											}
									}
									i++;
								}
								sb.append("</dataset>");
							}
							sb.append("<styles><definition><style type='font' name='myDataFont' size='11' color='000000' bold='0'/></definition><application><apply toObject='DataValues' styles='myDataFont' /><apply toObject='DATALABELS' styles='myDataFont' /><apply toObject='YAXISVALUES' styles='myDataFont' /></application></styles>");
							sb.append("</chart>");
							if(sb!=null)
								strXML = sb.toString();
							String swf = "/final/FusionCharts/swf/StackedBar" +  (er_mode != null && er_mode.equalsIgnoreCase("2D") ? "2" : "3" ) + "D.swf";
							JSONObject chartData =  new JSONObject();
							chartData.put("swfPath",swf);
							chartData.put("xmlData",strXML);
											// high chart stacked  bar
							int barheight=100;
							if(barUptimeDataSet.size()<=5)
							{
								barheight=290;
							}
							else if(barUptimeDataSet.size()==6)
							{
								barheight+=barUptimeDataSet.size()*27;
							}
							else if(barUptimeDataSet.size()>6)
							{
								barheight+=barUptimeDataSet.size()*25;
							}
							else if(barDowntimeDataSet.size()<=5)
							{
								barheight=290;
							}
							else if(barDowntimeDataSet.size()==6)
							{
								barheight+=barDowntimeDataSet.size()*27;
							}
							else if(barDowntimeDataSet.size()>6)
							{
								barheight+=barDowntimeDataSet.size()*25;
							}

							//vengat for bar chart heigth modifidcation
							barheight = (barDowntimeDataSet.size() * 22)+150;
							if(barheight<330)
								barheight=330;
							//

							int barchwidth=600;
							String uptimeVal = "Uptime";
							if(downtimeValues == null){
								uptimeVal = "Reboots";
                            }
							chartData.put("xAxisLabel",xAxisDataLabel);
							chartData.put("yAxisLabel",yAxisLabel);
							JSONArray dataSet = new JSONArray();

							JSONObject s1=new JSONObject();
							s1.put("name",uptimeVal);
							s1.put("color", "#"+(downtimeValues == null ? rebootColor : uptimeColor));
							s1.put("showInLegend", new Boolean(true));
							s1.put("data",barUptimeDataSet);
							
							 dataSet.add(s1);
							if(downtimeValues!=null){
								JSONObject s2=new JSONObject();
								s2.put("name","Downtime");
								s2.put("color","#"+downtimeColor);
								s2.put("showInLegend",new Boolean(true));
								s2.put("data",barDowntimeDataSet);
							
							dataSet.add(s2);
							}
							chartData.put("DataSet",dataSet);
							chartData.put("title","");
							chartData.put("chartType","bar");
							chartData.put("chartHeight",new Integer(barheight));
							chartData.put("chartWidth",new Integer(barchwidth));
							chartData.put("LegendPosition","top");
							chartData.put("legend",new Boolean(true));
							chartData.put("inside",new Boolean(true));
							chartData.put("chartSubType","stacked");
							chartData.put("drildown","newtab");
							chartData.put("allowMarginTop", "yes");
							chartData.put("marginTop","25");
							chartData.put("isFromNetScalerReport","Yes");
							if(er_show!=null &&  er_show.equalsIgnoreCase("%Uptime/%Downtime"))
								chartData.put("ymax",100);
							 chartData.put("percentEnableTick",true);
							chartData.put("uptime","uptimechart");

							json.put("chartData",chartData);
						}
						else
						{
							JSONObject chartData =  new JSONObject();
							chartData.put("xmlData","-");
							chartData.put("swfPath","-");
							json.put("chartData",chartData);
						}
						json.put("selectedReportType","graph");
						pageParams.put("selectedReportType","graph");
						String qString  = "";
						if(queryString!=null)
						{
							StringTokenizer strtok = new StringTokenizer(queryString,"&");
							while(strtok.hasMoreTokens())
							{
								String parameter = strtok.nextToken();
								int ind = parameter.indexOf("=");
								if (ind < 0)
									continue;
								String reqparam =parameter.substring(0,ind);
								String value = parameter.substring(ind+1);
								if(reqparam!=null&&reqparam.equals("er_component"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_uptimetest"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								/*if(reqparam!=null&&reqparam.equals("er_uptimetest"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}*/
								if(reqparam!=null&&reqparam.equals("er_combination"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_site"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("startdate"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("enddate"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_show"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("inidate"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("pdfTime"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_priority"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_usertimeline"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								/*
								if(reqparam!=null&&reqparam.equals("er_priority"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								*/
								qString += reqparam+"="+value+"&";
							}
						}
						queryString="/final/servlet/com.eg.ErUptimeServletC?"+qString.substring(0,qString.length())+"&er_view=imageprint&er_width=450&er_height=225&fromRefreshUrl=true";
						session.setAttribute("querygraph",queryString);
					}else if(er_type.equals("overview")){
						
					        int totalNoOfServers      = 0;
							int fullUptimeServerCount = 0;
							int downtimeServerCount   = 0;
							long perServerDownTime    = 0;
							long totalDownTimeMin     = 0;
							long avgDownTimeMin       = 0;
                            String serverUptime       = "0";
                            String serverDowntime     = "0";
							int graphLimit            = 10;
							String compontentName     = "";
							double totalDownPercentage=0;

							IniFile eg_report = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_report.ini");
							String uptimeColor = eg_report.getValue("UPTIME_REPORTS", "FusionColorForUptime");
							if(uptimeColor == null)
							{
								uptimeColor = "1fc1b7";
							}
							String downtimeColor = eg_report.getValue("UPTIME_REPORTS", "FusionColorForDowntime");
							if(downtimeColor == null)
							{
								downtimeColor = "f57e7e";
							}
							JSONObject overviewLineChat = new JSONObject();
                            JSONArray xAxisDataLabel    = new JSONArray();
							
							JSONArray dataUp    = new JSONArray();
							JSONArray dataDown    = new JSONArray();
							JSONObject allDataUp = new JSONObject();
							JSONObject allDataDown = new JSONObject();
							JSONArray data1    = new JSONArray();
							JSONObject obj     = null;
							totalNoOfServers = uptimeList.size();
							boolean isLowUptimeNotServerFound = false;
							double dVal = 0;
							int barcountFordowntime = 0;
							ArrayList aListLowDownTimeServer = new ArrayList();
                            for(int cnt=0;cnt<totalNoOfServers;cnt++)
							{
                               ErUptimeDowntimeBean uptimeBean = (ErUptimeDowntimeBean) uptimeList.get(cnt);
							   perServerDownTime = uptimeBean.getDownTimeMills();
								
								if(perServerDownTime==0){
									 fullUptimeServerCount++;
								 }else{
                                     totalDownTimeMin+=perServerDownTime/60000;
                                     downtimeServerCount++;
                                     //totalDownPercentage +=Double.valueOf(uptimeBean.getPerDownTime());
                                     totalDownPercentage +=Double.valueOf(uptimeBean.getDownTimeMills()+"");
								 }
                                       serverUptime   = uptimeBean.getPerUpTime();
									   serverDowntime =uptimeBean.getPerDownTime();
									   compontentName = uptimeBean.getComponent();
										
                                   if(cnt<graphLimit && !"100".equals(serverUptime)){
                                        xAxisDataLabel.add(compontentName);
										
										obj = new JSONObject();
										obj.put("name",compontentName);
										aListLowDownTimeServer.add(compontentName);
										dVal = Double.valueOf(serverUptime);
                                        obj.put("y",dVal);
                                        if(dVal==0 || dVal<10){
											JSONObject dataLabelObj = new JSONObject();
											dataLabelObj.put("enabled",false);
											obj.put("dataLabels",dataLabelObj);
                                        }
										dataUp.add(obj);
										
										obj = new JSONObject();
										dVal=Double.valueOf(serverDowntime);
										obj.put("name",compontentName);
                                        obj.put("y",dVal);
									if(dVal==0 || dVal<10){
											JSONObject dataLabelObj = new JSONObject();
											dataLabelObj.put("enabled",false);
											obj.put("dataLabels",dataLabelObj);
                                        }
										dataDown.add(obj);
                                       isLowUptimeNotServerFound=false;
									   barcountFordowntime++;
                                     }
                             }
							if(barcountFordowntime <graphLimit){
								  for(int cnt=0;cnt<totalNoOfServers;cnt++){
									  if(barcountFordowntime<graphLimit){
										ErUptimeDowntimeBean uptimeBean = (ErUptimeDowntimeBean) uptimeList.get(cnt);
											serverUptime   = uptimeBean.getPerUpTime();
											compontentName = uptimeBean.getComponent();
										    serverDowntime =uptimeBean.getPerDownTime();
										if(aListLowDownTimeServer!=null && aListLowDownTimeServer.contains(compontentName))
											continue;
                                        xAxisDataLabel.add(compontentName);
										obj = new JSONObject();
										obj.put("name",compontentName);
                                        obj.put("y",Double.valueOf(serverUptime));
										dataUp.add(obj);


										obj = new JSONObject();
										obj.put("name",compontentName);
                                        obj.put("y",Double.valueOf(serverDowntime));
										dataDown.add(obj);
										barcountFordowntime++;                                     
								  }     
                             }
							 }
                            
                             json.put("isLowUptimeNotServerFound",isLowUptimeNotServerFound);

							 if(totalDownTimeMin!=0 && downtimeServerCount!=0)
                                avgDownTimeMin=totalDownTimeMin/downtimeServerCount;
                              
							  JSONObject overviewData = new JSONObject();

							  overviewData.put("totalNoOfServers",totalNoOfServers);
							  overviewData.put("fullUptimeServerCount",(fullUptimeServerCount==0)?"0":fullUptimeServerCount);
							  overviewData.put("downtimeServerCount",(downtimeServerCount==0?"0":downtimeServerCount));
								overviewData.put("avgDownTimeMin",(avgDownTimeMin==0?"0":avgDownTimeMin));

								json.put("overviewData",overviewData);


								overviewLineChat.put("xAxisLabel",xAxisDataLabel);
								overviewLineChat.put("yAxisLabel","(%)");

								allDataUp.put("name","Uptime");
							  allDataUp.put("color","#"+uptimeColor);
								allDataUp.put("data",dataUp);
								data1.add(allDataUp);


								allDataDown.put("name","Downtime");
								allDataDown.put("color","#"+downtimeColor);
								allDataDown.put("data",dataDown);
								data1.add(allDataDown);
								overviewLineChat.put("DataSet",data1);
							  //vengat for bar chart heigth modifidcation
								System.out.println("allDataUpallDataUp "+allDataUp);
								int barheight=300;
								if(dataUp!=null && dataDown!=null && dataUp.size()>=dataDown.size())
								{
									int barCount = dataUp.size();
									barheight = (barCount * 22)+150;
								}
								else if(dataDown!=null && dataDown.size()>0)
								{
									int barCount = dataDown.size();
									barheight = (barCount * 22)+150;
								}

								if(barheight<300)
									barheight=300;
							// end
									   
							   overviewLineChat.put("title","");
							   overviewLineChat.put("chartType","bar");
							   overviewLineChat.put("chartHeight",new Integer(barheight));
							   overviewLineChat.put("chartWidth",600);
							   overviewLineChat.put("LegendPosition", "top");
							   overviewLineChat.put("legend", true);
							   overviewLineChat.put("inside", true);
							   overviewLineChat.put("chartSubType", "stacked");
							   overviewLineChat.put("drildown", "newtab");
							   overviewLineChat.put("ymax", 100);
							   overviewLineChat.put("percentEnableTick",true);
							   overviewLineChat.put("uptime", "uptimechart");
							   overviewLineChat.put("allowMarginTop", "yes");
							   overviewLineChat.put("marginTop","40");
					
					          json.put("overviewLineChat",overviewLineChat);
                               
							  //Pie Chart
							JSONObject overviewPieChat     = new JSONObject();
                            JSONArray xAxisDataLabelPie    = new JSONArray();
							
							JSONArray dataPie              = new JSONArray();
							JSONObject allDataPie          = new JSONObject();
							JSONArray data1Pie              = new JSONArray();
							JSONObject objPie              = null;

							 double totalTime = 0;
							 String totalTime_temp = resultDataMap.get("TOTAL_TIME")+"";
							 if(totalTime_temp!=null && totalTime_temp.length()>0)
								totalTime = Double.parseDouble(totalTime_temp);
							  double avgDownPercentage = 0;
							  if(totalDownPercentage!=0 && downtimeServerCount!=0 ){
									  avgDownPercentage= totalDownPercentage/downtimeServerCount;
									  avgDownPercentage= (avgDownPercentage/totalTime)*100;
							  }
							  double uptimePercentage = 100-avgDownPercentage;
							 
							 if(uptimePercentage!=0){
								String UpPercentageStr =erUtils.round(uptimePercentage, 2);
								   xAxisDataLabelPie.add(""+UpPercentageStr);
							obj = new JSONObject();
							obj.put("name","Uptime");
							obj.put("y",Double.valueOf(UpPercentageStr));
							obj.put("visible","true");
										obj.put("color","#"+uptimeColor);
							dataPie.add(obj);
							 }
							if(avgDownPercentage!=0){
								String downPercentageStr =erUtils.round(avgDownPercentage, 2);
								xAxisDataLabelPie.add(""+downPercentageStr);
								obj = new JSONObject();
								obj.put("name","Downtime");
								obj.put("y",Double.valueOf(downPercentageStr));
								//obj.put("visible","true");
										obj.put("color","#"+downtimeColor);
								dataPie.add(obj);
							}
							allDataPie.put("data",dataPie);
							data1Pie.add(allDataPie);
							overviewPieChat.put("xAxisLabel",xAxisDataLabelPie);
							overviewPieChat.put("yAxisLabel","(%)");
							overviewPieChat.put("DataSet",data1Pie);
							overviewPieChat.put("formatForLegendOnlyPercentage",true);

							overviewPieChat.put("title","");
							overviewPieChat.put("chartType","pie");
							overviewPieChat.put("chartHeight", 300);
							overviewPieChat.put("chartWidth",600);
							overviewPieChat.put("legend", true);//To show legend in pie chart
							overviewPieChat.put("ymax", 100);
							overviewPieChat.put("percentEnableTick",true);
							overviewPieChat.put("uptime", "uptimechart");
							overviewPieChat.put("LegendPosition", "top");
                              
							json.put("overviewPieChat",overviewPieChat);
							String qString  = "";
						if(queryString!=null)
						{
							StringTokenizer strtok = new StringTokenizer(queryString,"&");
							while(strtok.hasMoreTokens())
							{
								String parameter = strtok.nextToken();
								int ind = parameter.indexOf("=");
								if (ind < 0)
									continue;
								String reqparam =parameter.substring(0,ind);
								String value = parameter.substring(ind+1);
								if(reqparam!=null&&reqparam.equals("er_component"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_uptimetest"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_combination"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_site"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("startdate"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("enddate"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_show"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("inidate"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("pdfTime"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_priority"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								if(reqparam!=null&&reqparam.equals("er_usertimeline"))
								{
									value=com.eg.EgURLEncoder.encode(value, "UTF-8");
								}
								qString += reqparam+"="+value+"&";
							}
						}
						queryString="/final/servlet/com.eg.ErUptimeServletC?"+qString.substring(0,qString.length())+"&er_view=imageprint&er_width=450&er_height=225&fromRefreshUrl=true";
						session.setAttribute("querygraph",queryString);
					}
					boolean canShowDetails = false;
					if((er_type == null || er_type.equals("No")) && showDetails != null && showDetails.equalsIgnoreCase("Yes"))
					{
						for(int i=0; i<uptimeList.size(); i++)
						{
							ErUptimeDowntimeBean uptimeBean = (ErUptimeDowntimeBean) uptimeList.get(i);
							if(uptimeBean.getNoOfReboots() > 0) 
							{
								canShowDetails = true;
								break;
							}
						}
					}
					json.put("canShowDetails",""+canShowDetails);	
					if(canShowDetails) 
					{
						List uptimeData = (List)resultMap.get("UPTIME_DATA");
						SimpleDateFormat sdf = new SimpleDateFormat(currentDateFormat+" HH:mm:ss");
						String s_title = mappingInfo.getTextDescription("reporter.uptime.Reboot Details for") +" "+ er_uptimetest;
						v_measure.add(er_uptimetest);
							if(er_uptimetest!=null && er_uptimetest.equalsIgnoreCase("Services"))
						{
								s_title=mappingInfo.getTextDescription("reporter.uptime.Downtime Details for") +" "+ er_uptimetest;
						v_measure.add(mappingInfo.getTextDescription("reporter.ServicesDown At"));
						v_measure.add(mappingInfo.getTextDescription("reporter.uptime.ServicesUp At"));
						v_measure.add(mappingInfo.getTextDescription("reporter.uptime.Downtime")+ " (" + mappingInfo.getTextDescription("reporter.uptime.mins") + ")");
						}
						else{
						v_measure.add(mappingInfo.getTextDescription("reporter.Shutdown At"));
						v_measure.add(mappingInfo.getTextDescription("reporter.uptime.Rebooted At"));
						v_measure.add(mappingInfo.getTextDescription("reporter.uptime.Downtime")+ " (" + mappingInfo.getTextDescription("reporter.uptime.mins") + ")");
						v_measure.add(mappingInfo.getTextDescription("reporter.uptime.UptimeBeforeReboot")+" (" + mappingInfo.getTextDescription("reporter.uptime.yMdhm") + ")");
						}

						screenLabels.put("reporter.uptime.Shutdown At",mappingInfo.getTextDescription("reporter.uptime.Shutdown At"));
						screenLabels.put("reporter.uptime.Rebooted At",mappingInfo.getTextDescription("reporter.uptime.Rebooted At"));
						screenLabels.put("reporter.uptime.Downtime",mappingInfo.getTextDescription("reporter.uptime.Downtime"));
						screenLabels.put("reporter.uptime.mins",mappingInfo.getTextDescription("reporter.uptime.mins"));
						screenLabels.put("reporter.uptime.UptimeBeforeReboot",mappingInfo.getTextDescription("reporter.uptime.UptimeBeforeReboot"));
						screenLabels.put("reporter.uptime.yMdhm",mappingInfo.getTextDescription("reporter.uptime.yMdhm"));
						//
						screenLabels.put("reporter.uptime.Down At",mappingInfo.getTextDescription("reporter.uptime.Down At"));
						screenLabels.put("reporter.uptime.Up At",mappingInfo.getTextDescription("reporter.uptime.Up At"));
						//

						JSONArray detailsTableData = new JSONArray();
						for(int i=0; i<uptimeList.size(); i++)
						{
							ErUptimeDowntimeBean uptimeBean = (ErUptimeDowntimeBean) uptimeList.get(i);
							if(uptimeBean.getNoOfReboots() > 0) 
							{
								boolean compFound = false;
								ErUptimeData data = null;
								for(int j=0; j<uptimeData.size(); j++)
								{
									data = (ErUptimeData)uptimeData.get(j);
									if(data.getTrgtHost().equals(uptimeBean.getComponent()))
									{
										compFound = true;
										break;
									}
								}
								List detailBeanList = new ArrayList();
								if(compFound)
								{
									List rebootList = data.getFilteredReboot();
									List shutdownList = data.getFilteredShutdown();
									List durationList = data.getFilteredDuration();
									List lastUpTimesList = data.getLastUpTimesList();

									for(int j=0; j<shutdownList.size(); j++)
									{
										ErRebootDetailBean detailBean = new ErRebootDetailBean();
										detailBean.setShutdown((Calendar)shutdownList.get(j));
										detailBean.setReboot((Calendar)rebootList.get(j));
										detailBean.setDuration((String)durationList.get(j));
										detailBean.setLastUpTime(
											getDisplayString((String)lastUpTimesList.get(j),"0"));
										detailBeanList.add(detailBean);
									}
									Collections.sort(detailBeanList);
								}
								if(detailBeanList.size() > 0) 
								{
									JSONObject trData = new JSONObject();
									trData.put("component",uptimeBean.getComponent());
									list_data.add(uptimeBean.getComponent());
									trData.put("runningSince",getDisplayString(uptimeBean.getRunningSince(), "0"));
									if(er_uptimetest!=null && er_uptimetest.equalsIgnoreCase("Systems"))
									{
										list_data.add(getDisplayString(uptimeBean.getRunningSince(), "0"));
									}
									for(int j=0; j<detailBeanList.size(); j++) 
									{
										ErRebootDetailBean bean = (ErRebootDetailBean)detailBeanList.get(j);
										String shutTime = sdf.format(bean.getShutdown().getTime());
										String rebootTime = sdf.format(bean.getReboot().getTime());

										String usr_shutTime="";
										String usr_rebootTime="";
										if(shutTime!=null)
										{
											timeZoneConverterStart = new EgTimeZoneConverter(shutTime,thisuser);
											usr_shutTime = timeZoneConverterStart.getDateTime();
										}
										if(rebootTime!=null)
										{
											timeZoneConverterEnd = new EgTimeZoneConverter(rebootTime,thisuser);
											usr_rebootTime = timeZoneConverterEnd.getDateTime();
										}
										//
										Calendar ca=bean.getReboot();
										if(ca!=null)
										{ // for still down
										int year = ca.get(Calendar.YEAR);
										if(year==1900)
										usr_rebootTime="-";
										}

										//
										if(j > 0)
											list_data.add("");
										if(er_uptimetest!=null && er_uptimetest.equalsIgnoreCase("Services"))
										{
										list_data.add(usr_shutTime);
										list_data.add(usr_rebootTime);
										list_data.add(bean.getDuration());
										}
										else{
										list_data.add(usr_shutTime);
										list_data.add(usr_rebootTime);
										list_data.add(bean.getDuration());
										list_data.add(bean.getLastUpTime());
										}
										trData.put("shutDownAt",usr_shutTime);
										trData.put("reBootAt",usr_rebootTime);
										trData.put("downTime",bean.getDuration());
										trData.put("uptimeBeforeReBoot",bean.getLastUpTime());
										detailsTableData.add(trData);
									}
								}
							} // reboot > 0 if loop
						} // uptimelist for loop
						json.put("detailsData",detailsTableData);
						h_tabrc.put(v_measure,list_data);
						h_tab.put(s_title,h_tabrc);
						list.add(h_tab);
						list_data.add("\n");
						v_measure = new Vector();
						list_data = new LinkedList();
						s_title = new String();
						h_tabrc = new Hashtable();
						h_tab = new Hashtable();
					} // show details if loop
					json.put("dataAvailable","true");
				} // uptimelist not empty loop
				else
				{
					json.put("dataAvailable","false");

							//
					Vector no_measure = new Vector();
					list_data.add("");
					list_data.add("");
					list_data.add(mappingInfo.getTextDescription("reporter.common.No measures available"));

					no_measure.add("");
					no_measure.add("");
					no_measure.add("");

					Hashtable sen=new Hashtable();
					sen.put(no_measure,list_data);
					Hashtable hr=new Hashtable();
					hr.put(tempTitleStr,sen);
					list.add(hr);
					//
				}
				if(er_uptimetest!=null && er_uptimetest.equalsIgnoreCase("Services"))
				{
				List sessionCSV = (List)session.getAttribute("listData");
                 if(sessionCSV!=null){
					 if(list!=null && list.size()>2)
					 {
					list.remove(0);
					list.remove(0);
					 }
					 sessionCSV.addAll(list);
					 	session.setAttribute("listData",sessionCSV);
				 }
				if(list!= null && !list.isEmpty()&& sessionCSV== null)
				{
					session.setAttribute("listData",list);
				}
			}
			else
				{
					session.setAttribute("listData",list);
				}
			}
			if (request.getAttribute("ResultDataMap") != null)
			{
				HashMap resultMap = (HashMap)request.getAttribute("ResultDataMap");

				JSONObject barChartHiddenParams = new JSONObject();
				HashMap barChartParam = (HashMap) resultMap.get("SERVERS_BARCHART");
				if(barChartParam!=null && barChartParam.get("sampleValues_0") !=null)
				{
					String uptimeValuesurl = (String)barChartParam.get("sampleValues_0");
					StringTokenizer sturlUptime = new StringTokenizer(uptimeValuesurl, ",");
					int i=0;
					while (sturlUptime.hasMoreTokens() )
					{
						String strUptimeValue = sturlUptime.nextToken();
						if(strUptimeValue.equalsIgnoreCase("0"))
						{
							strUptimeValue = "";
						}
						String urlhidden = "url_0_"+i++;
						String hiddenurlval = barChartParam.get(urlhidden).toString();
						hiddenParams.put(urlhidden,hiddenurlval);
					}
				}
				if(barChartParam!=null && barChartParam.get("sampleValues_1") !=null)
				{
					String downtimeValuesurl = (String)barChartParam.get("sampleValues_1");
					StringTokenizer sturlDowntime = new StringTokenizer(downtimeValuesurl, ",");
					int j=0;
					while (sturlDowntime.hasMoreTokens() )
					{
						String strDownTimeValue = sturlDowntime.nextToken();
						if(strDownTimeValue.equalsIgnoreCase("0"))
						{
							strDownTimeValue = "";
						}
						String urlhidden = "url_1_"+j++;
						String hiddenurlval = barChartParam.get(urlhidden).toString();
						barChartHiddenParams.put(urlhidden,hiddenurlval);
					}
				}
				json.put("barChartHiddenParams",barChartHiddenParams);
				String strEncodeSite = "";
				if(s_site!=null) 
					strEncodeSite = com.eg.EgURLEncoder.encode(s_site,"UTF-8");

				String encodedEr_uptimetest =  request.getParameter("er_uptimetest");
				if(encodedEr_uptimetest!=null)
					encodedEr_uptimetest = com.eg.EgURLEncoder.encode(encodedEr_uptimetest,"UTF-8");

				String encodedStDate= request.getParameter("startdate");
				if(encodedStDate!=null)
					encodedStDate = com.eg.EgURLEncoder.encode(encodedStDate,"UTF-8");

				String encodedEndDate = request.getParameter("enddate");

				if(encodedEndDate!=null)
					encodedEndDate = com.eg.EgURLEncoder.encode(encodedEndDate,"UTF-8");

				String encodedErTimeline = er_timeline;

				if(encodedErTimeline!=null)
					encodedErTimeline = com.eg.EgURLEncoder.encode(encodedErTimeline,"UTF-8");

				String encodedDateFormat = request.getParameter("inidate");

				if(encodedDateFormat!=null)
					encodedDateFormat = com.eg.EgURLEncoder.encode(encodedDateFormat,"UTF-8");

				encodedShowDetails = showDetails;
				if(showDetails!=null)
					encodedShowDetails = java.net.URLEncoder.encode(showDetails);

				String dataProcess="";
				if(er_uptimetest!=null && er_uptimetest.equalsIgnoreCase("Services"))
				{
				dataProcess = mngrIProc+"/final/reporter/ErServiceUptimePrintData.jsp;jsessionid="+ session.getId()+"?er_comptype="+s_comptype+"&er_datafrom="+datafrom+"&er_type="+er_type+"&er_site="+strEncodeSite+"&er_uptimetest="+encodedEr_uptimetest+"&er_show_details="+encodedShowDetails+"&startdate="+encodedStDate+"&enddate="+encodedEndDate+"&timefrom="+timefrom2+"&minfrom="+minfrom2+"&timeto="+timeto2+"&minto="+minto2+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&er_timeline="+encodedErTimeline+"&startmin="+strmin+"&endmin="+enmin+"&inidate="+encodedDateFormat+"&pgTittle=OPERATION";			
				}
				else
				{
				dataProcess = mngrIProc+"/final/reporter/ErUptimePrintData.jsp;jsessionid="+ session.getId()+"?er_comptype="+s_comptype+"&er_datafrom="+datafrom+"&er_type="+er_type+"&er_site="+strEncodeSite+"&er_uptimetest="+encodedEr_uptimetest+"&er_show_details="+encodedShowDetails+"&startdate="+encodedStDate+"&enddate="+encodedEndDate+"&timefrom="+timefrom2+"&minfrom="+minfrom2+"&timeto="+timeto2+"&minto="+minto2+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&er_timeline="+encodedErTimeline+"&startmin="+strmin+"&endmin="+enmin+"&inidate="+encodedDateFormat+"&pgTittle=OPERATION";		
				}
				session.setAttribute("MAIL_URL",dataProcess);
			}
	}
if(er_uptimetest!=null && er_uptimetest.equalsIgnoreCase("Services"))
	session.setAttribute("PDF_URL", mngrIProc+"/final/reporter/ErServiceUptimePrintData.jsp");
else
	session.setAttribute("PDF_URL", mngrIProc+"/final/reporter/ErUptimePrintData.jsp");

	queryString=(String)ErUtils.prepareQueryString(request.getParameterMap());
	String qString="";
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String parameter = strtok.nextToken();
			int ind = parameter.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =parameter.substring(0,ind);
			String value = parameter.substring(ind+1);
			if(reqparam != null && reqparam.equals("action"))
			{
				continue;
			}
			if(reqparam!=null&&reqparam.equals("er_combination"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("er_timeline"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("startdate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("enddate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("inidate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("pdfTime"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("er_uptimetest"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("er_priority"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam!=null&&reqparam.equals("limitforbg"))
			{
				value= java.net.URLEncoder.encode(value);
			}
			if(reqparam != null && reqparam.equals("component"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam != null && reqparam.equals("er_component"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam != null && reqparam.equals("er_show"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			if(reqparam != null && reqparam.equals("er_RmDispName"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			qString += reqparam+"="+value+"&";
		}
		if(request.getParameter("isSubmit")!=null)
		{
			session.setAttribute("reportLastAccessedURL","/final/reporter/ErUptimeReportData.jsp?" + qString);
		}
		else 
		{
			String strTemp_ = request.getParameter("OperationUptimeUIAction");
			if(strTemp_!=null && !strTemp_.equalsIgnoreCase("loadComponents"))
				session.setAttribute("reportLastAccessedURL","/final/reporter/ErUptimeReportData.jsp?" + qString);
		}
	}

	//For Setting the PDf File Name
	String report_Type = request.getParameter("er_type");
	HashMap paramVal =new HashMap();
	if(report_Type!=null && report_Type.equalsIgnoreCase("Yes"))
		paramVal.put("fileName","OperationUptimeReport_Graph");
	else if(report_Type!=null && report_Type.equalsIgnoreCase("No"))
		paramVal.put("fileName","OperationUptimeReport_Data");
	session.setAttribute("parameters", paramVal);

	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);

	//Back Button - Start
	ArrayList listbackvar = new  ArrayList();
	if(request.getParameter("isSubmit")!=null)
	{
		listbackvar.add("/reporter/ErUptimeReportData.jsp?");
		listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+queryString);
		session.setAttribute("favSchBackDisplay","Yes");
	}
	else 
	{
		listbackvar.add("ErUptimeReportData.jsp");
		listbackvar.add(queryString);
		session.setAttribute("favSchBackDisplay","No");
	}
	String backadded = erhelputils.getBackID();
	backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
	session.setAttribute("backQuery",backreqMap);


	pageParams.put("selectedCompType",selectedCompType);
	//String titleToDisplay = "";
	String er_RmDispName = request.getParameter("er_RmDispName");
	if(er_RmDispName!=null && er_RmDispName.length()>0){
		titleToDisplay = er_RmDispName.trim();
		json.put("rm_titleDisplay",titleToDisplay);
	}
	else
	{
		titleToDisplay = "Uptime / Downtime Analysis";
		json.put("rm_titleDisplay",titleToDisplay);
	}

	json.put("screenLabels",screenLabels);
	json.put("hiddenParams",hiddenParams);
	json.put("hiddenQryStr",hiddenQryStr);
	json.put("pageParams",pageParams);
	//
	json.put("rImgDivId",imgDivId);
	//
	response.setContentType("application/json");
	response.getWriter().write(json.toString());

}catch(Throwable t)
{
	json = new JSONObject();
	json.put("rImgDivId",imgDivId);
	response.getWriter().write(json.toString());
	t.printStackTrace();
}
	//Back Button - End
%>
<%!
	public String getDisplayString(String input, String defaultString)
	{
		String displayString = "";
		if (input.equals("-")) {
			displayString = input;
		} else {
			StringTokenizer st = new StringTokenizer(input);
				while(st.hasMoreTokens()) {
				if(displayString.equals("")) {
					displayString = st.nextToken();
				} else {
					displayString += " " + st.nextToken();
				}
				displayString += st.nextToken();
			}
			if(displayString.equals("")) {
				displayString = defaultString;
			} else if(displayString.equals("0m")) {
				displayString = defaultString;
			}
		}
		return displayString;
	}
%>