<%
/*************************************************************************
* FileName		: ErViewEventHistory.jsp
* Purpose		: To view Event History List
* Author			: M.Saravanan
* Created		: 24-06-2004
* Last modified:
					29-07-2004 M.Saravanan
					Alignment changed,Bugs fixed
**************************************************************************/
%>
<%@ include file = "ErReporterTracker.jsp" %>
<%@ page import="com.egurkha.*" %>
<%@ page import="egurkha.reporter.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.text.*" %>
<%@ page import="com.eg.EgDateInfo"%>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "java.text.*" %>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import ="com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import ="com.eg.IniFile"%>
<%@ page import = "net.sf.json.*" %>
<%@ page import="java.net.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>


<%

	try{
	//code added
	response.setContentType("application/json");
	JSONObject rootJSON = new JSONObject();
	JSONObject screenLableJSON = new JSONObject();
	JSONObject selectionDetails=new JSONObject();
	JSONObject columnDetails =  new JSONObject();
	JSONArray alarmArray =  new JSONArray();;
	String starttime = null;
	String endtime = null;
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	if(request.getParameter("er_timeline")!=null && request.getParameter("er_timeline").trim().length()>0)
	{
		ErParseRequest epr=new ErParseRequest(request);
		starttime=epr.getFromDate(request.getParameter("er_timeline"))+" 00:00:00";
		endtime=epr.getToDate(request.getParameter("er_timeline"),"FIXED")+" 00:00:00";
	}
	else
	{
		starttime=request.getParameter("er_starttime");
		if(request.getParameter("er_endtime")!=null && request.getParameter("er_endtime").indexOf("@")>-1)
		{
			endtime = request.getParameter("er_endtime").substring((request.getParameter("er_endtime").indexOf("@")+1));
		}
		else
		{
			endtime = request.getParameter("er_endtime");
		}
	}
	endtime=endtime.trim();
	starttime=starttime.trim();
	Calendar cal = new GregorianCalendar();
	int year = cal.get(Calendar.YEAR);
	int month = cal.get(Calendar.MONTH)+1;
	int day = cal.get(Calendar.DAY_OF_MONTH);
	String currdate ="";
	currdate = month+"/"+day+"/"+year;
	if(day<10)
		currdate =month+"/0"+day+"/"+year;
	if(month<10)
		currdate = "0"+month+"/"+day+"/"+year;
	if(day<10&&month<10)
		currdate = "0"+month+"/0"+day+"/"+year;

	int Month =cal.get(Calendar.DAY_OF_MONTH);
	int hour24 = cal.get(Calendar.HOUR_OF_DAY);
	int min = cal.get(Calendar.MINUTE);
	int sec = cal.get(Calendar.SECOND);
	String curritme = hour24+":"+min+":"+sec;
	String cDate = currdate+" "+curritme;

	IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_ui.ini");
	String stateIcons = uiIni.getValue("STATE_ICONS","Default");
	String optClassName = "";
	if ( stateIcons != null && stateIcons.equalsIgnoreCase("no") )
	{
		optClassName = "_optional";
	}
	HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
	String backQnumber = request.getParameter("backQnumber");
	String servlet2 = request.getParameter("backServletName");

	ErHelperUtils erhelputils = null;

	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);

	boolean enableBack=erhelputils.isBackButtonEnable();

	String comp = request.getParameter("er_selection");
	String layer = request.getParameter("er_layer");
	String macroDateFormat=request.getParameter("inidate");
	String fromMacro_Index=request.getParameter("isSubmit");
	String starttimeformat="";
	String endtimeformat="";
	String start_disp="";
	String end_disp="";
	String comFormat="";
	String language              = thisuser.getLanguage();
	EgMappingInfo mappingInfo        = new EgMappingInfo(language);

	if(starttime.indexOf(DateTimeTokenizer.BLANK_SPACE)>-1)
	{
		String strstart=starttime.substring(0,starttime.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
		String strstarttime=starttime.substring(starttime.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1);
		if(macroDateFormat!=null && fromMacro_Index!=null && fromMacro_Index.equals("true"))
		{
			starttimeformat=DateUtil.changeDateFormat(strstart,macroDateFormat,"MM/dd/yyyy");
			starttimeformat=starttimeformat+" "+strstarttime;
		}
		else
		{
			starttimeformat=DateUtil.changeDateFormat(strstart,currentDateFormat,"MM/dd/yyyy");
			starttimeformat=starttimeformat+" "+strstarttime;
		}
	}
	else
	{
		starttimeformat=starttime;
	}
	if(endtime.indexOf(DateTimeTokenizer.BLANK_SPACE)>-1)
	{
		String strsend=endtime.substring(0,endtime.lastIndexOf(DateTimeTokenizer.BLANK_SPACE));
		String strsendtime=endtime.substring(endtime.lastIndexOf(DateTimeTokenizer.BLANK_SPACE)+1);
		if(macroDateFormat!=null && fromMacro_Index!=null && fromMacro_Index.equals("true"))
		{
			endtimeformat=DateUtil.changeDateFormat(strsend,macroDateFormat,"MM/dd/yyyy");
			endtimeformat=endtimeformat+" "+strsendtime;
		}
		else
		{
			endtimeformat=DateUtil.changeDateFormat(strsend,currentDateFormat,"MM/dd/yyyy");
			endtimeformat=endtimeformat+" "+strsendtime;
		}
	}
	else
	{
		endtimeformat=endtime;
	}

	ErEventHistoryBean ehb=new ErEventHistoryBean(starttimeformat,endtimeformat,comp,layer);

	Vector v_eventhist=ehb.getEventHistory();
	int taskLength = v_eventhist.size();

	ErEventHistoryBean arr_task[] = new ErEventHistoryBean[taskLength];
	for(int i = 0;i<taskLength;i++)
	{
		arr_task[i]=(ErEventHistoryBean)v_eventhist.get(i);
	}

	// Changes can be made here to change the no of events per page & no of indexs per page.
	int i_eventsPerPage = 10; //specifies no.of events per page
	int i_indexsPerPage = 10; // specifies no.of page indexs in a page.
	rootJSON.put("eventsPerPage",i_eventsPerPage);

	int i_pageNo = 1;
	if(request.getParameter("pageno")!=null)
		i_pageNo = Integer.parseInt(request.getParameter("pageno"));
	int i_totEvents = arr_task.length;
	int i_totPages = i_totEvents/i_eventsPerPage + (i_totEvents/i_eventsPerPage>0?1:0);

	int i_leadInd = i_indexsPerPage / 2;
	int i_trailInd = i_leadInd - (i_indexsPerPage % 2==0 ?1 :0);


	int i_pageIdxStart = i_pageNo - i_leadInd;
	int i_pageIdxEnd =  i_pageNo + i_trailInd;

	if(i_pageIdxStart <=0 && i_pageIdxEnd > i_totPages)
	{
		i_pageIdxStart = 1;
		i_pageIdxEnd = i_totPages;
	}else if(i_pageIdxStart <=0)
	{
		i_pageIdxEnd += Math.abs(i_pageIdxStart) + 1;
		if(i_pageIdxEnd>i_totPages)
			i_pageIdxEnd = i_totPages;
		i_pageIdxStart = 1;
	}
	else if(i_pageIdxEnd > i_totPages)
	{
		i_pageIdxStart -= (i_pageIdxEnd-i_totPages);
		if(i_pageIdxStart<=0)
			i_pageIdxStart= 1;
		i_pageIdxEnd = i_totPages;
	}
	SimpleDateFormat sd = new SimpleDateFormat(currentDateFormat);
	String start= starttime.substring(0,starttime.lastIndexOf(" "));
	String  shr=starttime.substring(starttime.lastIndexOf(" ")+1,starttime.length());
	String end=endtime.substring(0,endtime.lastIndexOf(" "));
	String  enhr=endtime.substring(endtime.lastIndexOf(" ")+1,endtime.length());
	end=end.trim();

	if(macroDateFormat!=null && fromMacro_Index!=null && fromMacro_Index.equals("true"))
	{
		start=DateUtil.changeDateFormat(start,macroDateFormat,currentDateFormat)+" "+shr;
		end=DateUtil.changeDateFormat(end,macroDateFormat,currentDateFormat)+" "+enhr;
	}
	else
	{
		start=starttime;
		end=endtime;
	}
	EgTimeZoneConverter converterStart=null;
	EgTimeZoneConverter converterEnd=null;

	converterStart = new EgTimeZoneConverter(start,thisuser);
	String s_dateTime = converterStart.getDateTime();
	converterEnd = new EgTimeZoneConverter(end,thisuser);
	String e_dateTime = converterEnd.getDateTime();

	String s_selection=request.getParameter("er_selection");
	String selectiontodisp="";
	if(s_selection!=null && s_selection.indexOf(":NULL")>-1)
		selectiontodisp=s_selection.substring(0,s_selection.indexOf(":"))+":"+s_selection.substring(s_selection.indexOf(":NULL")+6);
	else
		selectiontodisp=s_selection;

		screenLableJSON.put("Component", mappingInfo.getTextDescription("reporter.common.Component"));
		screenLableJSON.put("Layer", mappingInfo.getTextDescription("reporter.common.Layer"));
		screenLableJSON.put("From Date", mappingInfo.getTextDescription("reporter.common.From Date"));
		screenLableJSON.put("To Date", mappingInfo.getTextDescription("reporter.common.To Date"));

		String str_selectiontodisp=selectiontodisp.substring(0,selectiontodisp.lastIndexOf(":"))+":";
		String str_selectiontodisp1=selectiontodisp.substring(selectiontodisp.lastIndexOf(":")+1);


		selectionDetails.put("Component",(str_selectiontodisp+mappingInfo.getComponentTypeDescription(str_selectiontodisp1)));
		selectionDetails.put("Layer", mappingInfo.getLayerDescription(layer));
		selectionDetails.put("From", s_dateTime + " " +mappingInfo.getTextDescription("reporter.common.Hrs"));
		selectionDetails.put("To", e_dateTime+ " " + mappingInfo.getTextDescription("reporter.common.Hrs"));

		columnDetails.put("severity",mappingInfo.getTextDescription("reporter.common.severity"));
		columnDetails.put("test",mappingInfo.getTextDescription("reporter.common.Test"));
		columnDetails.put("measure",mappingInfo.getTextDescription("reporter.common.Measure"));
		columnDetails.put("service",mappingInfo.getTextDescription("reporter.common.Service"));
		columnDetails.put("starttime",mappingInfo.getTextDescription("reporter.common.Start Time"));
		columnDetails.put("endtime",mappingInfo.getTextDescription("reporter.common.End Time"));
		columnDetails.put("duration",mappingInfo.getTextDescription("reporter.common.Duration"));
		columnDetails.put("measureOrDesc",mappingInfo.getTextDescription("reporter.common.Description"));

		rootJSON.put("gridTitle"," ");
		rootJSON.put("reportTitle","Event History");

		rootJSON.put("screenLable",screenLableJSON);
		rootJSON.put("selectionDetails",selectionDetails);
		rootJSON.put("gridColumnNames",columnDetails);

		if(arr_task == null || arr_task.length == 0)
		{
					rootJSON.put("NoRecord",mappingInfo.getTextDescription("reporter.common.No Event History Found"));
		}
		else
		{
			EgDateInfo egDate = new EgDateInfo();
			int i_startIdx = (i_pageNo-1) * i_eventsPerPage;
			int i_endIdx = Math.min(i_startIdx +i_eventsPerPage,i_totEvents);

			EgTablesInfo egtblinfo=new EgTablesInfo("manager");
			for(int i=0;i<arr_task.length;i++)
			{
				JSONObject alaramDetails = new JSONObject();
				String s_site = arr_task[i].getSiteName();
				if(s_site.equalsIgnoreCase("NULL"))
					s_site = "NONE";
				String s_stTime=egDate.egetDateUS(arr_task[i].getStartedTime());
				String s_endTime = "-";
				String s_duration = "Current";
				String s_durationInSec = "0";
				long l_endTime = arr_task[i].getEndedTime();
				if(l_endTime!=-1)
				{
					s_endTime = egDate.egetDateUS(l_endTime);
					DateTimeTokenizer dtd = new DateTimeTokenizer();
					dtd.setDateFormat(DateTimeTokenizer._YMD);
					dtd.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
					dtd.setTimeFormat(DateTimeTokenizer.HMS);
					s_duration=dtd.getTimeDifference((arr_task[i].getEndedTime()-arr_task[i].getStartedTime())/1000);
					s_durationInSec = ""+((arr_task[i].getEndedTime()-arr_task[i].getStartedTime())/1000);
				}
				Hashtable alertParams = new Hashtable();
				alertParams.put("$componentType",mappingInfo.getComponentTypeDescription(str_selectiontodisp1));
				alertParams.put("$componentName",Server.getServerNameWithoutPort(str_selectiontodisp, false));
				if(arr_task[i].getInfo()!=null && arr_task[i].getInfo().trim().length()>1){
					if(arr_task[i].getInfo().startsWith("+"))
						alertParams.put("$info",arr_task[i].getInfo().substring(1));
					else
						alertParams.put("$info",arr_task[i].getInfo());
				}
				String s_desc = egtblinfo.getMeasureAlert(arr_task[i].getTestName()+":"+arr_task[i].getMeasure(),arr_task[i].getInfo(),alertParams);
				s_desc = (s_desc.indexOf("~!~") != -1)?s_desc.substring(0,s_desc.indexOf("~!~")):s_desc;
				String  str_arr_task=arr_task[i].getTestName().trim()+":"+arr_task[i].getMeasure().trim();
				alaramDetails.put("severity",arr_task[i].getState());
				alaramDetails.put("test",mappingInfo.getTestDescription(arr_task[i].getTestName()));
				alaramDetails.put("measure",mappingInfo.getMeasureDescription(arr_task[i].getTestName(),arr_task[i].getMeasure()));
				if(s_site.trim().equalsIgnoreCase("NONE"))
				{
					String str_s_site="reporter.common."+s_site;
					alaramDetails.put("service",mappingInfo.getTextDescription(str_s_site));
				}
				else
				{
					alaramDetails.put("service",mappingInfo.getTextDescription(s_site));
				}
				SimpleDateFormat sdf = new SimpleDateFormat(currentDateFormat);
				String s_shr=s_stTime.substring(s_stTime.lastIndexOf(" ")+1,s_stTime.length());
				java.util.Date startDate = new java.util.Date(s_stTime);
				String e_enhr="";
				String end_time="";
				if(!s_endTime.equals("-"))
				{
					e_enhr=s_endTime.substring(s_endTime.lastIndexOf(" ")+1,s_endTime.length());
					java.util.Date  endDate = new java.util.Date(s_endTime);
					end_time=sdf.format(endDate)+" "+e_enhr;
					converterEnd=new EgTimeZoneConverter(end_time,thisuser);
				}
				else
				{
					end_time="-";
				}
				String start_time=sdf.format(startDate)+" "+s_shr;
				converterStart=new EgTimeZoneConverter(start_time,thisuser);
				String strdesc="";
				String str_measureAlert=arr_task[i].getTestName()+":"+arr_task[i].getMeasure();
				alaramDetails.put("starttime",converterStart.getDateTime());
				alaramDetails.put("endtime",converterEnd.getDateTime());
				alaramDetails.put("duration",s_duration);
				alaramDetails.put("durationInSec",s_durationInSec);
				alaramDetails.put("measureOrDesc",s_desc);
				alarmArray.add(alaramDetails);
			}
		}
		rootJSON.put("alarmGridValues",alarmArray);
		String queryString =(String)ErUtils.prepareQueryString(request.getParameterMap());
		String Qstring="";
		if(queryString!=null)
		{
			StringTokenizer strtok = new StringTokenizer(queryString,"&");
			while(strtok.hasMoreTokens())
			{
				String parameter = strtok.nextToken();
				int ind = parameter.indexOf("=");
				if (ind < 0)
					continue;
				String reqparam =parameter.substring(0,ind);
				String value = parameter.substring(ind+1);
				if(reqparam!=null&&reqparam.equals("er_selection"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null&&reqparam.equals("er_endtime"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null&&reqparam.equals("inidate"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null&&reqparam.equals("er_starttime"))
				{
					value=com.eg.EgURLEncoder.encode(value, "UTF-8");
				}
				if(reqparam!=null && reqparam.equals("isSubmit"))
				{
					Qstring=Qstring+reqparam+"=true&";
				}
				else
					Qstring=Qstring+reqparam+"="+value+"&";
			}
		}
		if((backreqMap != null && backreqMap.size() > 0 &&  enableBack && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true")) || (backQnumber == null))
			{
				rootJSON.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
			}

		//Back button - Start
		ArrayList listbackvar = new  ArrayList();
		if(Qstring!=null)
		{
			session.setAttribute("reportLastAccessedURL","/final/reporter/ErViewEventHistory.jsp?"+Qstring);
			listbackvar.add("ErViewEventHistory.jsp");
			listbackvar.add(queryString);
		}
		//Back Button - End
		response.getWriter().write(rootJSON.toString());
	System.out.println("rootJSON ____________"+rootJSON);
	}catch(Throwable e)
	{
		e.printStackTrace();
	}
%>


