<%
/**
 *	FileName	: ErVMmeasureGraph.jsp
 *	Purpose	: This page Handles a single Line chart
 *	Author	: Soban Babu M.S
 */
%>
<%@ include file="ErReporterTracker.jsp" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "egurkha.reporter.ErEsxVMutils" %>
<%@ page import = "egurkha.reporter.ErReportHelper" %>
<%@ page import="com.egurkha.pdfmaker.*"%>
<%@ page import="egurkha.reporter.ErUtils.*"%>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import="com.eg.EgDbInfo" %>
<%@ page import="com.eg.EgMappingInfo" %>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import = "java.net.URLDecoder" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "net.sf.json.*" %>
<%@ page import="com.eg.EgDateInfo" %>

<jsp:useBean id="dd" scope="page" class="com.egurkha.monitor.EgDiagnosisBean" />
<%
try
{
	EgDateInfo egDt = new EgDateInfo();
	ErUtils erUtils = new ErUtils();

	ErReportHelper er_helper = new ErReportHelper();
	EgReportInfo reportinfo = new EgReportInfo("manmager");
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	
	String s_host = request.getParameter("er_host");
	String s_component_dd = request.getParameter("s_component_dd");
	boolean isClusterHost = (s_host != null && !s_host.equals("")) ? true : false;
	ArrayList singleColors = null;
	ArrayList singleSelection = null;
	
	ErInfo erInfo=new ErInfo();

	JSONObject json = new JSONObject();
	JSONObject pageParams = new JSONObject();
	JSONObject hiddenParams = new JSONObject();
	JSONObject screenLabels = new JSONObject();


	HashMap tmpReqMap=new HashMap(request.getParameterMap());
	try
	{
		if(tmpReqMap.containsKey("select_vm"))
		{
			Object object=tmpReqMap.get("select_vm");
			String tmpSelect_vm=null;
			if(object instanceof String)
			{
				tmpSelect_vm=(String)object;
			}else if(object instanceof String[])
			{
				String[] vmArray=(String[])object;
				tmpSelect_vm=vmArray[0];
			}
			if(tmpSelect_vm!=null)
			{
				if(tmpSelect_vm.indexOf("+")>-1)
				{
					tmpSelect_vm=StringUtils.replace(tmpSelect_vm,"+","|plus|");
				}
				if(tmpSelect_vm.indexOf("&")>-1)
				{
					tmpSelect_vm=StringUtils.replace(tmpSelect_vm,"&","|amp|");
				}
				if(tmpSelect_vm.indexOf("%")>-1)
				{
					tmpSelect_vm=StringUtils.replace(tmpSelect_vm,"%","|pct|");
				}
				if(tmpSelect_vm.indexOf("#")>-1)
				{
					tmpSelect_vm=StringUtils.replace(tmpSelect_vm,"#","|hash|");
				}
			}
			tmpReqMap.put("select_vm",tmpSelect_vm);
		}
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
	String queryStrValue = ErUtils.prepareQueryString(tmpReqMap);
	String pdfPrint = request.getParameter("pdfPrint");
	String drilldown = request.getParameter("drilldown");
	String qString = "";
	if(queryStrValue!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryStrValue,"&");
		while(strtok.hasMoreTokens())
		{
			String parameter = strtok.nextToken();
			int ind = parameter.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =parameter.substring(0,ind);

			String value = parameter.substring(ind+1);

			if(reqparam!=null&&reqparam.equals("er_trgttype"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_timeline"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("startdate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("enddate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_stdate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("er_enddate"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("select_vm"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("currentDateFormatForJS"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("currentformat"))
			{
				value=com.eg.EgURLEncoder.encode(value, "UTF-8");
			}
			else if(reqparam!=null&&reqparam.equals("timelineval"))
			{
				value=com.eg.EgURLEncoder.encode(value,"UTF-8");
			}
			qString += reqparam+"="+value.trim()+"&";
		}
	}
	String queryStr="/final/servlet/com.eg.ErEsxVMServerReportC?"+request.getQueryString();
	EgMappingInfo intlmap = new EgMappingInfo(thisuser.getLanguage());

	String[] options = new String[21];
	String strTest ="";
	String strMeasure="";
	String er_timeline = request.getParameter("er_timeline");
	String trenddata = request.getParameter("er_trenddata");
	String test_measure = request.getParameter("ertest_measure");
	String er_value = request.getParameter("er_value");
	String disable="";
	String dispDate = null;
	String comFormat = null;
	String s_st_time = request.getParameter("er_stdate");
	String s_en_time = request.getParameter("er_enddate");
	String s_st_hr = request.getParameter("starthr");
	String s_en_hr = request.getParameter("endhr");
	String select_group = request.getParameter("select_group");
	String ertest_measure = request.getParameter("ertest_measure");
	String select_vm = request.getParameter("select_vm");
	String isOnlyVMAssigned = request.getParameter("isOnlyVMAssigned");
	String encodeselectvm ="";
	if(request.getParameter("select_vm") !=null)
		encodeselectvm = EgURLEncoder.encode(request.getParameter("select_vm"),"UTF-8");
	String ervmgraphpresent = request.getParameter("ervmgraphpresent");
	String[] er_component = request.getParameterValues("er_component");
	String er_type = request.getParameter("er_type");
	if (ervmgraphpresent == null)
	{
		ervmgraphpresent ="No";
	}
	String er_comptype = request.getParameter("er_comptype");
	String er_compName = request.getParameter("er_compName");
	String ervm_disp = request.getParameter("ervm_disp");
	String er_datadisplay = request.getParameter("er_datadisplay");
	String s_priority = request.getParameter("er_priority");
	String er_excwe = request.getParameter("er_excwe");
	String s_dbMeas = request.getParameter("er_disp_meas");
	String s_cluster = request.getParameter("er_cluster");
	String s_option = request.getParameter("er_option");

	String screenWidth = request.getParameter("screenWidth");
	String screenHeight = request.getParameter("screenHeight");

	String graphWidth = "650";
	String graphHeight = "450";


	try
	{
		if(!StringUtils.isNull(screenWidth))
		{
			double defaultGraphWidth = 983.0;
			double defaultWidthPercentFor1024 = defaultGraphWidth/1024;
			double currScrWidth = Double.parseDouble(screenWidth);
			double grpWidForCurtScrWidth = defaultWidthPercentFor1024 * currScrWidth;
			graphWidth=erUtils.round(grpWidForCurtScrWidth,0);			
		}
		if(!StringUtils.isNull(screenHeight))
		{
			double defaultGraphHeight = 540.0;
			double defaultHeightPercentFor768 = defaultGraphHeight/768;
			double currScrHeight = Double.parseDouble(screenHeight);
			double grpHeightForCurScrHeight = defaultHeightPercentFor768 * currScrHeight;
			graphHeight=erUtils.round(grpHeightForCurScrHeight,0);
		}
	}
	catch(Exception e)
	{
		
	}
	String disptest_measure ="";
	if (test_measure != null) {
		strTest = test_measure.substring(0,test_measure.indexOf("/"));
		strMeasure = test_measure.substring(test_measure.indexOf("/")+1);
	}
	if (ertest_measure != null) {
		disptest_measure = ertest_measure.replace('/',':');
	}
	if (select_vm ==null) {
		select_vm ="";
	}
 	String strmin ="";
	String enmin ="";
	String stsec ="";
	String ensec ="";
	String startDate ="";
	String endDate ="";
	IniUI ui = IniUI.getInstance();
	String currentDateFormat = strUserDateFormat;//ui.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	
 	String opt=request.getParameter("er_trenddata");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	Vector vec = new Vector();
	UserRegistry userValue = UserRegistry.getInstance();
	User usrDetail = userValue.getUser(session.getId());
	String loginVal = usrDetail.getLoginID();
	String strUsrTime = er_helper.getUserTimeline(loginVal);
 	if(opt==null)
	{
		opt="No";
	}
	if(er_timeline!=null && er_timeline.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df = new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			 StrDate = df.format(new java.util.Date());	
		}
		catch(Exception ee)
		{
			System.out.println("Exception is"+ee);
		}
		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);
		if(s_st_time==null)
		{
			s_st_time=SDate;
		}
		if(s_en_time == null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour = shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			s_st_hr=String.valueOf(starthr);
		}
		if(s_en_hr==null)
		{
			shour = shour.trim();
			s_en_hr = shour;
		}
	}
	if(trenddata.equals("Yes"))
	{
		options = new String[]{"Any","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
	}
	else
	{
		options = new String[]{"Any","1 hour", "3 hours", "6 hours", "9 hours", "12 hours", "15 hours", "18 hours", "21 hours","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
	}
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		disable ="disabled";
	}
	ErEsxVMutils ervm = new ErEsxVMutils();
	HashMap clusterQryMap = null;
	if (s_option != null && s_option.equals("graph"))
	{
		session.removeAttribute("MeasuresGraph");
	}
	Object strgraph =(Object)session.getAttribute("MeasuresGraph");
	if(strgraph != null && strgraph instanceof HashMap)
	{
	  clusterQryMap = (HashMap)strgraph;
	}
 	else
	{
		if(strgraph != null)
		{
			clusterQryMap = erUtils.parseQueryString(strgraph.toString());
		}
	}
	strmin =request.getParameter("startmin");
	enmin = request.getParameter("endmin");
	if(er_timeline!=null && !er_timeline.equals("Any"))
	{
		s_st_time = "";
		s_en_time = "";
		ervm.setCurrentDateFormat(currentDateFormat);
		HashMap mapTimeLine = ervm.getDateTime(er_timeline,trenddata);

		startDate = (String)mapTimeLine.get("dbstartdate");
		endDate = (String)mapTimeLine.get("dbenddate");
		s_st_time = (String)mapTimeLine.get("calStartDate");
		s_en_time = (String)mapTimeLine.get("calEndDate");
		s_st_hr = (String)mapTimeLine.get("startHour");
		s_en_hr = (String)mapTimeLine.get("endHour");
		strmin = (String)mapTimeLine.get("startMin");
		enmin = (String)mapTimeLine.get("endMin");
		stsec = (String)mapTimeLine.get("startSec");
		ensec = (String)mapTimeLine.get("endSec");
	}
	else
	{
		startDate = DateUtil.changeDateFormat(s_st_time.trim(),currentDateFormat,"dd-MM-yyyy");
		endDate = DateUtil.changeDateFormat(s_en_time.trim(),currentDateFormat,"dd-MM-yyyy");
		if (isClusterHost && clusterQryMap != null)
		{
			clusterQryMap.put("beanstartdate", startDate);
			clusterQryMap.put("beanenddate", endDate);
			clusterQryMap.put("starthr", s_st_hr);
			clusterQryMap.put("endhr", s_en_hr);
		}
	}
	String timefrom = request.getParameter("timefrom");
	String timeto = request.getParameter("timeto");
	String minfrom = request.getParameter("minfrom");
	String minto = request.getParameter("timeto");
	String forResoures = request.getParameter("forResoures");



		if (!isClusterHost)
	{
		egurkha.reporter.ErVMGuestServerReportBean ervmguestserver = new egurkha.reporter.ErVMGuestServerReportBean();
		request.setAttribute("st_date",startDate);
		request.setAttribute("en_date",endDate);

		ervmguestserver.initRequest(request);
		ervmguestserver.getVMChartData();
		singleColors = ervmguestserver.singleColors;
		singleSelection = ervmguestserver.singleSelection;
	}

	ReporterDAOFactory reportDAO = ReporterDAOFactory.getInstance(); 
	EgEsxVMDAO esxDAO = reportDAO.getEsxVMDAO();
	String strDmin = request.getParameter("d_min");
	String strDmax = request.getParameter("d_max");
	if (isClusterHost && clusterQryMap != null)
	{
		clusterQryMap.put("d_min", strDmin);
		clusterQryMap.put("d_max", strDmax);
		clusterQryMap.put("er_mode", request.getParameter("er_mode"));
		clusterQryMap.put("er_timeline", er_timeline);
		clusterQryMap.put("ervmgraphpresent", ervmgraphpresent);
	}
	if (strDmin == null && strDmax == null)
	{
		strDmin ="";
		strDmax ="";
	}

	int presentEsxCount = 0;
	int maxVms = (new ErReportHelper()).getMaxInfos("INFOS","MaxInfos");

	String startTime ="";
	String endTime ="";
	startTime = startDate+" "+s_st_hr+":"+strmin+":00";
	endTime = endDate+" "+s_en_hr+":"+enmin+":00";
	
	String rangebox="";
	String timeFromValue= timefrom+":"+minfrom+":00";
	String timeToValue= timeto+":"+minto+":00";
	boolean isExeclude = "Yes".equalsIgnoreCase(er_excwe) ? true : false;
	boolean isFromData = "Yes".equalsIgnoreCase(ervmgraphpresent) ? false : true;
	String strCompName="";
	Object obj = null;
 	if (isFromData)
	{
 		obj = er_compName;
	}
	else
	{
 		obj = thisuser.getServersForType(er_comptype);
	}
	String subject ="";
	if (ervm_disp !=null && ervm_disp.equals(""))
	{
		subject = "MEASURE_GROUP";
	}
	else
	{
		subject = "VIRTUAL_MEASURE_GROUP";
	}
	//thisuser.getServersForType(er_comptype);
 	String [] strCountMinMaxAray = null;
	String sHostName = s_host;
	try
	{
		if (s_host !=null && !"null".equals(s_host))
		{
			subject = "VIRTUAL_CLUSTER";
			if (sHostName != null && sHostName.indexOf(":") > -1) {
				sHostName = s_host.substring(s_host.indexOf(":")+1, s_host.lastIndexOf(":"));
			}
			strCountMinMaxAray = ervm.getClusterHostMinMaxCount(sHostName,strTest,s_dbMeas,
				startTime,endTime,isExeclude,trenddata,timeFromValue, timeToValue,subject,"Info");
		}
		else {
			strCountMinMaxAray = ervm.getEsxMinMaxCount(isFromData,isExeclude,subject, select_vm,strTest,strMeasure,startTime,endTime,trenddata,timeFromValue,timeToValue,forResoures,obj);
		}
	}
	catch (Exception e)
	{
		e.printStackTrace();
	}
	double dmin=0.0;
	double dmax=0.0;
	int esxcount =0;
 	if (strCountMinMaxAray != null && strCountMinMaxAray.length == 3)
	{
		if (strCountMinMaxAray[0] != null)
		{
			esxcount = Integer.parseInt(strCountMinMaxAray[0]);
		}
		if (strCountMinMaxAray[1] != null)
		{
			dmin = Float.parseFloat(strCountMinMaxAray[1]);
		}
		 if(strCountMinMaxAray[2] != null)
		{
 			dmax = Float.parseFloat(strCountMinMaxAray[2]);
		}
	}
	boolean showTop = false;
	String strTopVal = "";
 	if (esxcount >=maxVms && !ervmgraphpresent.equals("Yes"))
	{
		showTop = true;
		strTopVal="Yes";
	}
	pageParams.put("strTopVal",strTopVal);
 	String s_filter = request.getParameter("er_filter");
 	if(s_filter == null)
	{
		s_filter ="INFO";
	}

	String strTopChecked = "";
	String strRangeChecked ="";
	String disabledselcted="";
	if (showTop && s_filter != null && s_filter.equalsIgnoreCase("INFO"))
	{
		pageParams.put("showDescriptor","true");
	}
	else
	{
		pageParams.put("showDescriptor","false");
	}
	if(s_filter.equalsIgnoreCase("INFO"))
	{
		pageParams.put("selectedFilterOption","DescriptorPriority");
	}
	else
	{
		pageParams.put("selectedFilterOption","Range");
	}
	if (strDmin != null && strDmin.equals(""))
	{
		strDmin = dbInfo.formatValue(String.valueOf(dmin));
	}
	if (strDmax != null && strDmax.equals(""))
	{
		strDmax = dbInfo.formatValue(String.valueOf(dmax));
	}
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");

	String strDispunits="";
	if(strTest != null && strMeasure !=null)
	{
		strDispunits = tablesInfo.getUnitForMeasure(strTest.trim(),strMeasure.trim());
		strDispunits = "("+strDispunits+")";
	}

	session.setAttribute("DRILLDOWN_PDF_URL", mngrIProc+"/final/reporter/ErVMmeasureGraphPrint.jsp");
	
	String strcomp=request.getParameter("strcomp");
 	if(strcomp != null && strcomp.equals("")&& !strcomp.equals("null"))
	{
		if(er_component != null)
		{
			for (int j=0;j <er_component.length;j++)
			{
				strcomp += "&er_component="+er_component[j];
			}
		}
	}
	if(strcomp == null || strcomp != null && strcomp.equals("null"))
		strcomp ="";

	hiddenParams.put("currentformat",currentDateFormat);
	hiddenParams.put("inidate",currentDateFormat);
	hiddenParams.put("optval",trenddata);
	hiddenParams.put("timelineval",er_timeline);
	hiddenParams.put("currentDateFormatForJS",currentDateFormatForJS);
	//hiddenParams.put("startmin",strmin);
	//hiddenParams.put("endmin",enmin);
	hiddenParams.put("startsec",stsec);
	hiddenParams.put("endsec",ensec);
	hiddenParams.put("eruserid",urs);
	hiddenParams.put("er_trenddata",trenddata);
	hiddenParams.put("ervmgraphpresent",ervmgraphpresent);
	hiddenParams.put("strcomp",strcomp);
	hiddenParams.put("er_type",er_type);
	hiddenParams.put("er_comptype",er_comptype);
	hiddenParams.put("forResoures",request.getParameter("forResoures"));
	hiddenParams.put("timefrom",request.getParameter("timefrom"));
	hiddenParams.put("timeto",request.getParameter("timeto"));
	hiddenParams.put("minfrom",request.getParameter("minfrom"));
	hiddenParams.put("minto",request.getParameter("minto"));
	hiddenParams.put("er_excwe",request.getParameter("er_excwe"));
	hiddenParams.put("ertest_measure",request.getParameter("ertest_measure"));
	hiddenParams.put("select_vm",select_vm);
	hiddenParams.put("drilldown",drilldown);
	//hiddenParams.put("startTime",request.getParameter("startTime"));
	//hiddenParams.put("endTime",request.getParameter("endTime"));
	hiddenParams.put("userID",request.getParameter("userID"));
	hiddenParams.put("select_group",request.getParameter("select_group"));
	hiddenParams.put("ervm_type",request.getParameter("ervm_type"));
	hiddenParams.put("vmGraph",request.getParameter("vmGraph"));
	hiddenParams.put("er_datadisplay",er_datadisplay);
	hiddenParams.put("er_compName",er_compName);
	hiddenParams.put("er_value",er_value);
	hiddenParams.put("er_width",request.getParameter("er_width"));
	hiddenParams.put("er_height",request.getParameter("er_height"));
	hiddenParams.put("er_cluster",s_cluster);
	hiddenParams.put("er_disp_meas",s_dbMeas);
	hiddenParams.put("er_host",s_host);
	hiddenParams.put("graphtype",request.getParameter("graphtype"));
	hiddenParams.put("getMaxDaysInMonth",String.valueOf(ErUtils.getMaxDaysInMonth()));
	hiddenParams.put("isOnlyVMAssigned",isOnlyVMAssigned);

	String query="";
	if (ervmgraphpresent !=null && !ervmgraphpresent.equals("Yes"))
	{
		if (s_priority == null && s_filter != null && s_filter.equalsIgnoreCase("INFO"))
		{
			query = "&er_filter=INFO&er_priority="+EgURLEncoder.encode("TOP - "+String.valueOf(maxVms),"UTF-8");
		}
		else
		{
			if (s_priority == null) {
				s_priority ="";
			}
 			query = "&er_filter="+s_filter+"&er_priority="+EgURLEncoder.encode(s_priority,"UTF-8");
		}
	}
	//String queryforPrint="/final/servlet/com.eg.ErEsxVMServerReportC?reqData=Yes&reqfrom=vmGuest&optval="+trenddata+"&er_timeline="+er_timeline+"&startdate="+s_st_time+"&st_date="+startDate+"&en_date="+endDate+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&startmin="+strmin+"&endmin="+enmin+"&startsec="+stsec+"&endsec="+ensec+"&eruserid="+urs+"&er_trenddata="+trenddata+"&ervmgraphpresent="+ervmgraphpresent+"&er_comptype="+er_comptype+"&forResoures="+request.getParameter("forResoures")+"&timefrom="+timefrom+"&timeto="+timeto+"&minfrom="+request.getParameter("minfrom")+"&minto"+request.getParameter("minto")+"&eresxwe="+request.getParameter("er_excwe")+"&ertest_measure="+test_measure+"&select_vm="+EgURLEncoder.encode(select_vm,"UTF-8")+"&userID="+urs+"&er_compName="+er_compName+"&startTime="+startDate+"&endTime="+endDate+"&d_min="+strDmin+"&d_max="+strDmax+query;
	String er_mode = request.getParameter("er_mode");
	String queryforGraph ="";
	String queryforPrint = "";
	if (s_host !=null && !s_host.equals("null"))
	{
		queryforGraph = "/final/servlet/com.eg.ErVirtualClusterReportC?er_legendPosition=right"+query;
		if (clusterQryMap != null)
		{
			String sQueryString =(String)ErUtils.prepareQueryString(clusterQryMap);
			queryforGraph += "&"+ sQueryString;
		} else
		{
			queryforGraph += "&" + request.getQueryString();
		}
		queryforPrint = queryforGraph + "&reqData=Yes";
	}
	else
	{

	 
		queryforGraph = "/final/servlet/com.eg.ErEsxVMServerReportC?optval="+trenddata+"&er_timeline="+EgURLEncoder.encode(er_timeline,"UTF-8")+"&enddate="+URLEncoder.encode(s_en_time)+"&startdate="+URLEncoder.encode(s_st_time)+"&st_date="+startDate+"&en_date="+endDate+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&startmin="+strmin+"&endmin="+enmin+"&startsec="+stsec+"&endsec="+ensec+"&eruserid="+urs+"&er_trenddata="+trenddata+"&ervmgraphpresent="+ervmgraphpresent+"&er_comptype="+er_comptype+"&forResoures="+request.getParameter("forResoures")+"&timefrom="+timefrom+"&timeto="+timeto+"&minfrom="+request.getParameter("minfrom")+"&minto="+request.getParameter("minto")+"&er_excwe="+request.getParameter("er_excwe")+"&ertest_measure="+test_measure+"&select_vm="+EgURLEncoder.encode(select_vm,"UTF-8")+"&userID="+urs+"&er_compName="+er_compName+"&startTime="+startDate+"&endTime="+endDate+"&d_min="+strDmin+"&d_max="+strDmax+query+"&er_datadisplay=No&vmGraph=yes&er_mode="+er_mode+"&isOnlyVMAssigned="+isOnlyVMAssigned;
		
		queryforPrint = "/final/servlet/com.eg.ErEsxVMServerReportC?reqData=Yes&reqfrom=vmGuest&optval="+trenddata+"&er_timeline="+EgURLEncoder.encode(er_timeline,"UTF-8")+"&enddate="+URLEncoder.encode(s_en_time)+"&startdate="+s_st_time+"&st_date="+startDate+"&en_date="+endDate+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&startmin="+strmin+"&endmin="+enmin+"&startsec="+stsec+"&endsec="+ensec+"&eruserid="+urs+"&er_trenddata="+trenddata+"&ervmgraphpresent="+ervmgraphpresent+"&er_comptype="+er_comptype+"&forResoures="+request.getParameter("forResoures")+"&timefrom="+timefrom+"&timeto="+timeto+"&minfrom="+request.getParameter("minfrom")+"&minto="+request.getParameter("minto")+"&er_excwe="+request.getParameter("er_excwe")+"&ertest_measure="+test_measure+"&select_vm="+EgURLEncoder.encode(select_vm,"UTF-8")+"&userID="+urs+"&er_compName="+er_compName+"&startTime="+startDate+"&endTime="+endDate+"&d_min="+strDmin+"&d_max="+strDmax+query+"&isOnlyVMAssigned="+isOnlyVMAssigned;
	}
	if(showTop)
	{
		queryforGraph = queryforGraph+"&er_filter="+s_filter;
	}
	String title="";

	String strTestintl =disptest_measure.substring(0,disptest_measure.indexOf(":"));
	String strMeasureintl = disptest_measure.substring(disptest_measure.indexOf(":")+1);
	if(isOnlyVMAssigned!=null && isOnlyVMAssigned.equalsIgnoreCase("true"))
	{
		title = intlmap.getMeasureDescription(strTestintl,strMeasureintl)+" Details ";
	}
	else
	{
		title = intlmap.getMeasureDescription(strTestintl,strMeasureintl)+" Details for a Component Type :"+intlmap.getComponentTypeDescription(er_comptype);
	}
	pageParams.put("mainPageTitle",title);
	pageParams.put("printPageUrl","../reporter/ErVMmeasureGraphPrint.jsp?"+qString+"&er_view=PRINT&print=yes&pdfPrint=yes");
	pageParams.put("pdfUrl","../reporter/ErHtmlToSavePdf.jsp?drillSes=Yes&"+qString+"&er_view=PRINT&print=yes");
	if (er_datadisplay != null && !er_datadisplay.equals("Yes"))
	{
		pageParams.put("dataPageUrl",queryforPrint);
		String port = "";
		String s_site = "NULL";
		String s_component = "";
		String s_infovalue = "*";
		String mhost = "";
		String tempTimeline = "Any";
		if(s_component_dd!=null && !s_component_dd.equals("")&& !s_component_dd.equals("Not Applicable"))
		{
			s_component = s_component_dd.substring(0,s_component_dd.indexOf(":"));
			port = s_component_dd.substring(s_component_dd.indexOf(":")+1);
			s_component_dd = s_component_dd+":"+er_comptype;
		}
		else
		{
			if(er_component!=null && er_component.length>-1)
			{
				s_component = er_component[0];
			}
			String er_component1 = request.getParameter("er_component");
			if(er_component1!=null && er_component1.length()>0)
			{
				s_component = er_component1;
			}
			s_component_dd = s_component+":"+port+":"+er_comptype;
		}
		Vector v_infos = erInfo.getInfosForTest(s_site,strTest,s_component_dd);
		if (v_infos!=null && v_infos.size()>0)
		{
			for (int m=0;m<v_infos.size();m++)
			{
				String s1=(String)v_infos.get(m);
				if (s1.toUpperCase().indexOf(select_vm.toUpperCase())==1)
				{
					s_infovalue = s_infovalue+s1.substring(1);
					break;
				}
			}
		}
		if(s_infovalue.equals("*"))
		{
			s_infovalue = s_infovalue+select_vm;
		}
		v_infos = erInfo.getMsmtHostForGraph(s_site,strTest,s_component_dd);
		if(v_infos!=null && v_infos.size() >0 )
			mhost = (String)v_infos.get(0);
		if(mhost==null || mhost.equals(""))
			mhost = "";

		//String dd_url = "/final/monitor/EventsGraph.jsp?pageToShow=diagnosis&url=EgDiagnosis.jsp?site="+s_site+"&host="+EgURLEncoder.encode(s_component,"UTF-8")+"&port="+port+"&test="+strTest+"&info="+s_infovalue+"&msmt_host="+mhost+"&from=0&measure="+strMeasure+"&firsttime=true&flag=0 &starttime="+request.getParameter("startdate")+"&endtime="+request.getParameter("enddate")+"&starthr="+s_st_hr+"&endhr="+ s_en_hr+"&startmin="+strmin+"&endmin="+enmin+"&fromPage=alarm&comeFrom=Reporter&newWindow=true&timeline="+tempTimeline+"&inidate="+request.getParameter("inidate")+"&comptype="+er_comptype+"&isVM="+isOnlyVMAssigned;

		String dd_url = "/final/monitor/componentMeasureTabSet.jsp?type="+EgURLEncoder.encode(er_comptype,"UTF-8")+"&site="+s_site+"&host="+EgURLEncoder.encode(s_component,"UTF-8")+"&port="+port+"&info="+EgURLEncoder.encode(s_infovalue,"UTF-8")+"&state=&messy="+strMeasure+"&msmt_host="+EgURLEncoder.encode(mhost,"UTF-8")+"&userID="+EgURLEncoder.encode(urs,"UTF-8")+"&test="+ strTest+"&comptype="+er_comptype+"&measureDisp="+strMeasure+"&starttime="+request.getParameter("startdate")+"&endtime="+request.getParameter("enddate")+"&starthr="+s_st_hr+"&endhr="+ s_en_hr+"&startmin="+strmin+"&endmin="+enmin+"&from=measurespage&dd=yes&clicked=dd&newWindow=true&fromReporterHis=true&popup=true&fromPage=eveHist";

		if(dd.ShowDDData(s_site,s_component,strTest,strMeasure,"+"+s_infovalue.substring(1),mhost))
		{
			pageParams.put("showDD","true");
			pageParams.put("ddPageUrl",dd_url);
		}
		else
		{
			pageParams.put("showDD","false");
			pageParams.put("ddPageUrl","-");
		}
	}
	else
	{
		pageParams.put("showDD","false");
		pageParams.put("ddPageUrl","-");
		pageParams.put("dataPageUrl","-");
	}

	List lst = new LinkedList();
	ArrayList lst_dat = new ArrayList();
	Hashtable  hashData = new Hashtable();
	Hashtable  hashIn = new Hashtable();
	if (er_datadisplay != null && !er_datadisplay.equals("Yes"))
	{
		JSONArray filterOptionsArr = new JSONArray();
		JSONObject filterOptionsObj = new JSONObject();
		filterOptionsObj.put("displayField",intlmap.getTextDescription("reporter.common.Descriptor By Priority"));
		filterOptionsObj.put("valueField","DescriptorPriority");
		filterOptionsArr.add(filterOptionsObj);
		filterOptionsObj = new JSONObject();
		filterOptionsObj.put("displayField",intlmap.getTextDescription("reporter.common.Range"));
		filterOptionsObj.put("valueField","Range");
		filterOptionsArr.add(filterOptionsObj);

		screenLabels.put("admin.filter.Filter by",intlmap.getTextDescription("admin.filter.Filter by"));

		json.put("filterOptionsArr",filterOptionsArr);

		pageParams.put("displayType","Graph");
		if (showTop)
		{
			pageParams.put("showFilter","Yes");
			screenLabels.put("reporter.common.Descriptor",intlmap.getTextDescription("reporter.common.Descriptor"));
			screenLabels.put("reporter.common.Range",intlmap.getTextDescription("reporter.common.Range"));
			//er_filter

			JSONArray priorityOptsJson =  new JSONArray();
			String topVal = intlmap.getTextDescription("reporter.common.TOP");
			String lastVal = intlmap.getTextDescription("reporter.common.LAST");
			//er_priority
			for (int v = 1; v <=10;v++)
			{
				String strTopValue = "TOP - "+String.valueOf(v);

				JSONObject jObj = new JSONObject();
				jObj.put("displayField",topVal+" - "+v);
				jObj.put("valueField",strTopValue);
				priorityOptsJson.add(jObj);
				if (s_priority != null && s_priority.equals(strTopValue))
				{
					pageParams.put("selectedPriority",strTopValue);
				}
				else if (s_priority == null && strTopValue.equals("TOP - "+String.valueOf(maxVms)))
				{
					strTopValue = "TOP - "+String.valueOf(v);
					if (s_priority == null)
					{
						pageParams.put("selectedPriority",strTopValue);
					}
					queryStr = queryStr+"&er_filter=INFO&er_priority="+strTopValue;
				}
			}
			JSONObject AllOpt = new JSONObject();
			AllOpt.put("displayField",intlmap.getTextDescription("reporter.common.All"));
			AllOpt.put("valueField","All");
			priorityOptsJson.add(AllOpt);
			if (s_priority != null && s_priority.equals("All"))
			{
				pageParams.put("selectedPriority","All");
			}
		
			for (int v = 1; v <=10;v++)
			{
				String strTopValue = "LAST - "+String.valueOf(v);
				JSONObject jObj = new JSONObject();
				jObj.put("displayField",lastVal+" - "+v);
				jObj.put("valueField",strTopValue);
				priorityOptsJson.add(jObj);
				if (s_priority != null && s_priority.equals(strTopValue))
				{
					pageParams.put("selectedPriority",strTopValue);
				}
			}
			json.put("priorityOptsJson",priorityOptsJson);
			//d_min
			pageParams.put("minRange",strDmin);
			//d_max
			pageParams.put("maxRange",strDmax);
		}
		else
		{
			pageParams.put("showFilter","No");
		}
		String sdispParam1 = "ComponentType";
		String sdispParam2 = "Virtual Machine";
		String sdispvalue1 = intlmap.getComponentTypeDescription(er_comptype);
		String sdispValue2 = select_vm;
		if (s_cluster !=null && !s_cluster.equals("null") && !s_cluster.equals("")) {
			sdispParam1 = "Cluster";
			if (s_cluster.startsWith("+",0)) {
				s_cluster = s_cluster.substring(1,s_cluster.length());
			}
			sdispvalue1 = s_cluster;
		}
		if (s_host !=null && !s_host.equals("null") && !s_host.equals("")) {
			sdispParam2 = "Physical servers";
			sdispValue2 = sHostName;
		}
		JSONObject displayDetailsJson = new JSONObject();
		if(isOnlyVMAssigned!=null && isOnlyVMAssigned.equalsIgnoreCase("true"))
		{
			displayDetailsJson.put(intlmap.getTextDescription("reporter.vmdetails.VM Name"),sdispValue2);
		}
		else
		{
			displayDetailsJson.put(intlmap.getTextDescription("reporter.common."+sdispParam1),sdispvalue1);
			displayDetailsJson.put(intlmap.getTextDescription("reporter.common."+sdispParam2),sdispValue2);
		}
		json.put("selectionDetails",displayDetailsJson);
		screenLabels.put("reporter.common.Timeline",intlmap.getTextDescription("reporter.common.Timeline"));
%>
<%@  include file ="ErTimeFormatJSON.jsp"%>

<%
	hiddenParams.put("er_usertimeline",strUsrTimeline);
	json.put("timelineComboArray",timelineComboArray);

	pageParams.put("startDateJSON",startDateJSON);
	pageParams.put("endDateJSON",endDateJSON);
	pageParams.put("startHourJSON",startHourJSON);
	pageParams.put("endHourJSON",endHourJSON);
	pageParams.put("startmin",startMin);
	pageParams.put("endmin",endMin);
	//

	pageParams.put("startDateForDisplay",startDateForDisplay);
									pageParams.put("startHourForDisplay",startHourForDisplay);
									pageParams.put("startMinForDisplay",startMinForDisplay);
									pageParams.put("endDateForDisplay",endDateForDisplay);
									pageParams.put("endHourForDisplay",endHourForDisplay);
									pageParams.put("endMinForDisplay",endMinForDisplay);

	//

	chartTypeForUI=ErHighchartUtils.getChartType(startDateForHighchart,endDateForHighchart,currentDateFormat+" HH:mm");
	json.put("chartType",chartTypeForUI);

	pageParams.put("selectedTimeline",er_timeline);
	screenLabels.put("reporter.common.SUBMIT",intlmap.getTextDescription("reporter.common.SUBMIT"));

	pageParams.put("mainGraphTitle",intlmap.getTestDescription(strTest)+"/"+intlmap.getMeasureDescription(strTest,strMeasure)+" "+strDispunits);

	pageParams.put("graphDrillDown",queryforGraph+"&drilldownData=Yes&chartformat=No&er_width="+graphWidth+"&er_height="+graphHeight);
	pageParams.put("graphWidth",graphWidth);
	pageParams.put("graphHeight",graphHeight);

	String strselectioncount = reportinfo.getValue("MISC","RightDisplaySelectioncount");
	int selectioncount=10;
	if(strselectioncount !=null && !strselectioncount.equals(""))
	{
		try
		{
			selectioncount = Integer.parseInt(strselectioncount);
		}
		catch (Exception e)
		{
			selectioncount = 10;
		}
	}
	if (singleSelection != null && singleSelection.size() >selectioncount)
	{
		JSONObject legendObj = new JSONObject();
		HashMap mappedLegends = new HashMap();
		int count1=0;
		ArrayList singleSelectList = new ArrayList();
		ArrayList singleColorList = new ArrayList();
		
		for (int k=0; k <singleSelection.size();k++)
		{
			String st_key = (String)singleColors.get(k);
			String value = (String)singleSelection.get(k);
			st_key = st_key.substring(1,st_key.length());
			singleSelectList.add(value);
			singleColorList.add(st_key);
			legendObj.put(value,"/final/servlet/com.eg.ErImageDrawC?req="+st_key);
		}
		mappedLegends.put("singleSelection",singleSelectList);
		mappedLegends.put("singleColors",singleColorList);
		session.setAttribute("mappedLegends",mappedLegends);
		json.put("legendObj",legendObj);
		pageParams.put("showLegends","true");
	}
	else
	{
		pageParams.put("showLegends","false");
	}
}
else
{
	//title="Added guests Details for a Component"+" : ";
	String strReboot = request.getParameter("reboot");
	if (strReboot != null && strReboot.equals("Yes"))
	{
		pageParams.put("displayType","rebootData");
		ArrayList listVMReboots = new ArrayList();
		if (listVMReboots != null)
		{
			listVMReboots = (ArrayList)request.getAttribute("listVMReboots");
		}

		JSONObject gridObj = new JSONObject();
		JSONObject gridCols = new JSONObject();
		gridCols.put("COLUMN_0",intlmap.getTextDescription("reporter.common.Number"));
		gridCols.put("COLUMN_1",intlmap.getTextDescription("reporter.esx.Date and Time"));
		gridCols.put("COLUMN_2",intlmap.getTextDescription("reporter.esx.Number of Reboots"));
		JSONArray gridData =  new JSONArray();
		int countvm = 1;
		vec.add("Number");
		vec.add("Date and Time");
		vec.add("Number of Reboots");
		for (int v = 0; v < listVMReboots.size(); v++)
		{
			String vmdateReeboots = (String)listVMReboots.get(v);
			String strData = "";
			String numberOftimes = "";
			String timeToDisplay="";
			String dateFormatToDiaplay ="";
			int countToDisp=0;
			if (vmdateReeboots != null && vmdateReeboots.indexOf(":") > -1)
			{
				countToDisp = countvm++;
				strData = vmdateReeboots.substring(0,vmdateReeboots.lastIndexOf(":"));
				String dateToDisplay = strData.substring(0,strData.indexOf(" "));
				dateFormatToDiaplay = DateUtil.changeDateFormat(dateToDisplay.trim(),"yyyy-MM-dd",currentDateFormat);
				lst_dat.add(String.valueOf(countToDisp));
				timeToDisplay = strData.substring(strData.indexOf(" ")+1);
				if (timeToDisplay.indexOf(".") >-1)
				{
					timeToDisplay = timeToDisplay.substring(0,timeToDisplay.indexOf("."));
				}
				numberOftimes = vmdateReeboots.substring(vmdateReeboots.lastIndexOf(":")+1);
				lst_dat.add(dateFormatToDiaplay+" "+timeToDisplay);
				lst_dat.add(numberOftimes);
			}
			JSONObject gridRow = new JSONObject();
			gridRow.put("COLUMN_0",String.valueOf(countToDisp));
			gridRow.put("COLUMN_1",dateFormatToDiaplay+" "+timeToDisplay);
			gridRow.put("COLUMN_2",numberOftimes);
			gridData.add(gridRow);
		}
		gridObj.put("gridCols",gridCols);
		gridObj.put("gridData",gridData);
		json.put("gridObj",gridObj);
	}
	else
	{
		pageParams.put("displayType","VmDetails");
		HashMap mappedVM = new HashMap();
		if (mappedVM != null)
		{
			mappedVM = (HashMap)request.getAttribute("mappedVMmeasure");
		}
		lst_dat = new ArrayList();
		JSONObject gridObj = new JSONObject();
		JSONObject gridCols = new JSONObject();
		gridCols.put("COLUMN_0",intlmap.getTextDescription("reporter.common.Number"));
		gridCols.put("COLUMN_1",intlmap.getTextDescription("reporter.esx.Date and Time"));
		gridCols.put("COLUMN_2",intlmap.getTextDescription("reporter.esx.Virtual Machine"));
		gridCols.put("COLUMN_3",intlmap.getTextDescription("reporter.esx.Machine IP"));
		JSONArray gridData =  new JSONArray();

		vec.add("Number");
		vec.add("Date and Time");
		vec.add("Virtual Machine");
		vec.add("Machine IP");
		Iterator itrtyp = (new TreeMap(mappedVM)).keySet().iterator();
		int count = 1;
		while (itrtyp.hasNext())
		{
			String msmt_time = (String)itrtyp.next();
			ArrayList listInformationlist = (ArrayList)mappedVM.get(msmt_time);
			String dateToDisplay = msmt_time.substring(0,msmt_time.indexOf(" "));
			String dateFormatToDiaplay = DateUtil.changeDateFormat(dateToDisplay.trim(),"yyyy-MM-dd",currentDateFormat);
			int countVal = count++;
			String timeToDisplay = msmt_time.substring(msmt_time.indexOf(" ")+1);
			if (timeToDisplay.indexOf(".") >-1)
			{
				timeToDisplay =timeToDisplay.substring(0,timeToDisplay.indexOf("."));
			}
			JSONObject gridRow = new JSONObject();
			gridRow.put("COLUMN_0",String.valueOf(countVal));
			gridRow.put("COLUMN_1",dateFormatToDiaplay+" "+timeToDisplay);
			gridData.add(gridRow);
			int colCnt = 2;
			for (int c = 0;c <listInformationlist.size(); c++)
			{
				ArrayList listinfo = (ArrayList)listInformationlist.get(c);
				lst_dat.add(String.valueOf(countVal));
				lst_dat.add(dateFormatToDiaplay+" "+timeToDisplay);

				for (int k = 0;k < listinfo.size(); k++)
				{
					String strexcalation = (String)listinfo.get(k);
					if (strexcalation != null && strexcalation.equals("N/A"))
					{
						strexcalation ="-";
						lst_dat.add("-");
					}
					else
					{
						lst_dat.add(strexcalation);
					}
					gridRow.put("COLUMN_"+colCnt,strexcalation);
					colCnt++;
				}
			}
		}
		gridObj.put("gridCols",gridCols);
		gridObj.put("gridData",gridData);
		json.put("gridObj",gridObj);
	}
}
json.put("hiddenParams",hiddenParams);
json.put("screenLabels",screenLabels);
json.put("pageParams",pageParams);
response.setContentType("application/json;charset=UTF-8");
response.getWriter().write(json.toString());

String dataProcess =  mngrIProc+ "/final/reporter/ErVMmeasureGraphPrint.jsp"+";jsessionid="+ session.getId()+"?"+"../reporter/ErVMmeasureGraphPrint.jsp?"+qString+"&er_view=PRINT&drillSes=yes&print=yes";
session.setAttribute("DRILLDOWN_MAIL_URL",dataProcess);

hashIn.put(vec,lst_dat);
hashData.put(title,hashIn);

lst.add(hashData);
session.setAttribute("list",lst);
//HashMap mappedData = (HashMap)request.getAttribute("mappedData");
String queryString="";

HashMap reqMap=new HashMap(request.getParameterMap());

	
String strScheme = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort();
reqMap.put("strScheme",strScheme);
//queryString = "/final/servlet/com.eg.ErEsxVMServerReportC?"+queryStr+"&drilldownData=Yes";
session.setAttribute("querygraphdrill",queryforGraph+"&drilldownData=Yes&chartformat=No&er_width="+graphWidth+"&er_height="+graphHeight);
if (isClusterHost)
{
	String s_clusterQuery = queryforGraph.substring (
			queryforGraph.indexOf("?") + 1, queryforGraph.length() );
	session.setAttribute("MeasuresGraph",s_clusterQuery);
	reqMap.put("beanstartdate", startDate);
	reqMap.put("beanenddate", endDate);
}
session.setAttribute("reqGraphMap",reqMap);
}
catch(Throwable t)
{
	t.printStackTrace();
}
	 
%>